---
title: Anotações sobre SEO
authors: Diego Eis
type: post
date: 2008-09-08
url: /anotacoes-seo/
aktt_tweeted:
  - 1
tweetbackscheck:
  - 1356386004
shorturls:
  - 'a:3:{s:9:"permalink";s:37:"https://tableless.com.br/anotacoes-seo";s:7:"tinyurl";s:26:"https://tinyurl.com/3grppve";s:4:"isgd";s:19:"https://is.gd/bvuuLo";}'
twittercomments:
  - 'a:1:{i:18287600661962752;s:6:"136485";}'
tweetcount:
  - 1
dsq_thread_id: 503038510
categories:
  - Artigos
  - SEO
  - Tecnologia e Tendências
tags:
  - buscadores
  - google
  - otimizacao para buscadores
  - search optimization
  - SEO
  - yahoo

---
SEO é um assunto bastante interessante porque gira em torno de boatos, mitos e suposições. Na verdade, sabemos pouca coisa sobre o que ajuda ou não na boa colocação dos sites nos sistemas de busca. O engraçado é que esse mistério todo é levantado pelos próprios buscadores. Isso é necessário, sem dúvida. Imagine se qualquer pessoa pudessem fazer dinheiro. A situação é a mesma. Por isso, os buscadores, principalmente o Google, tem seus segredos e divulga apenas o necessário para que possamos fazer um bom trabalho.<!--more-->

O trabalho de SEO hoje é um pouco mais complexo do que 5 anos atrás, quando os Padrões Web começaram a ganhar força aqui no Brasil. Teve uma época em que era fácil fazer um site ficar em primeiro na busca orgânica do Google, bastava apenas retirar as tabelas da estrutura do site e utilizar as tags da maneira correta. Tive experiências de ter apenas convertido o código do site para Tableless (XHTML e CSS), e sem muito trabalho o site apareceu em primeiro lugar.
  
Hoje não é tão fácil assim. O diferencial naquele tempo era o código limpo, semântico e legível. Atualmente qualquer site tem o código feito com CSS e um XHTML relativamente legível. Isso fez com que profissionais encontrassem outras maneiras de colocar os sites em lugares  privilegiados nas buscas.
  
Agora, é necessário que façamos muito além do que apenas uma mudança no código fonte. Há trabalho de textos, escolha, pesquisa e monitoramento de palavras chaves, relevância do texto, semântica dos elementos, cuidados com conteúdo duplicado, entre outros pontos importantes. Esses pontos devem ser combinados para que o resultado seja mais interessante.

O trabalho de SEO é um trabalho feito por partes. Para que ele seja efetivo e tenha resultados duradouros, há uma série de passos que devem ser seguidos, que vão desde a estruturação do código até a criação de campanhas para levantar links relevantes apontando para o site. É um trabalho que leva tempo para que os resultados se tornem interessantes e que estimulem o cliente. Por isso é interessante informar ao cliente na hora da contratação do serviço, que resultados satisfatórios podem demorar para chegar. Dependendo do mercado que o cliente atua, pode levar semanas ou meses. Mesmo assim, relatórios semanais ou mensais são importantes para o cliente esteja ciente da evolução do seu investimento e possa decidir se quer ou não continuar com o trabalho. Dar um prazo de no mínimo três meses é algo que pode ser seguro para o profissional. Assim, há bastante tempo para que as alterações possam ser feitas e os robôs possam absorver toda a informação modificada e atualizar o ranking do site.

Há alguns pontos que podemos controlar e que são básicos para o início do trabalho de SEO:

  1. Otimização de código fonte
  2. Estudo e estrutura de palavras-chaves e termos importantes
  3. Links externos para o site
  4. Idade da página
  5. [Criação do Sitemaps.xml][1]
  6. .HTACCESS atualizado

Normalmente a otimização do código fonte e o estudo e edição de palavras e termos podem ser feitos por terceiros ou pelos próprios integrantes da equipe de desenvolvimento. Mesmo assim, para o trabalho com texto, é aconselhável contratar um editor.

Os links externos podem ser conseguidos a partir de campanhas online. Há trabalhos e parcerias que podem ser feitos com sites de terceiros, em comunidades e até mesmo blogueiros. A idéia é que seu site tenha conteúdo relevante e seja linkado em outro sites com relevância interessante e que o raking seja significativo. Isso também leva tempo e pode ser difícil dependendo do mercado que o cliente atua.

A idade da página é outro ponto importante. Não se deve modificar URLs regularmente. O endereço de cada página é único e nada pode ser perdido. Se a URL deve ser modificada, o endereço antigo deve ser redirecionado para o endereço mais atual. Muitos CMS como o WordPress já vem munidos de permalinks e URLs amigáveis. Divulgar sempre um mesmo endereço é algo importante e não deve passar despercebido.

A criação de um Sitemap.xml é importante para manter os buscadores atualizados sobre a relevância das páginas do seu site e regularidade de atualização. O WordPress tem plugins que fazem o Sitemap.xml específico para seu site e o mantem atualizado.

O .htaccess vai servir para o controle de endereços antigos e redirecionamento para os endereços mais atuais. Atenção: cuidado para que o .htaccess tenha redirecionamentos demais. Isso pode prejudicar o trabalho dos buscadores e algumas de suas páginas podem não ser redirecionadas corretamente.

 [1]: https://tableless.com.br/seo-sitemaps