---
title: Alternativas ao jQuery
authors: Davi Ferreira
type: post
date: 2011-08-17
excerpt: Conheça as principais opções de frameworks e bibliotecas no desenvolvimento JavaScript e saiba que existe vida além do jQuery
url: /alternativas-ao-jquery/
tweetbackscheck:
  - 1356452582
shorturls:
  - 'a:3:{s:9:"permalink";s:31:"https://tableless.com.br/?p=4034";s:7:"tinyurl";s:26:"https://tinyurl.com/3hw3d9w";s:4:"isgd";s:19:"https://is.gd/QnfvAA";}'
twittercomments:
  - 'a:0:{}'
dsq_thread_id: 503040374
categories:
  - Javascript
  - Código
tags:
  - JQuery
  - dojo
  - Javascript
  - mootools

---
Apesar de toda a sua popularidade, não são poucas as alternativas para quem procura bibliotecas mais específicas, mais eficientes em certos aspectos e mais enxutas do que o jQuery.

Algumas foram a raiz do novo estilo de desenvolvimento JavaScript, visando uma maior legibilidade e facilidade de aprendizado e acabaram sendo responsáveis pelo atual estado das bibliotecas e frameworks JavaScript.

A curta curva de aprendizado e o leque de plugins fazem do jQuery um concorrente imbatível (com atualmente 50% do &#8220;mercado&#8221;), no entanto, bibliotecas como ExtJS, MooTools e Prototype possuem uma base fiel de usuários e mostram-se alternativas altamente viáveis para a implementação de JavaScript em suas aplicações.

### MooTools + mocha(ui)

[mootools.net][1]
  
[mochaui.org][2]

Esse talvez seja o maior &#8220;rival&#8221; do jQuery. MooTools é a biblioteca favorita dos desenvolvedores e a disputa até resultou em um site bastante informativo, [jQuery vs. MooTools][3].

Enquanto jQuery é um framework mais focado em HTML/CSS e animações, o objetivo do MooTools é oferecer mais poder para desenvolvedores, com foco em modularidade, orientação a objetos, flexibilidade. MooTools é voltado pra quem já desenvolve em JavaScript.

Assim como o jQuery possui o pacote jQuery UI, mocha(ui) é a biblioteca MooTools para interfaces, com opções de abas, dialogs, widgets etc.

### ExtJS 4

[sencha.com/products/extjs][4]

Antes conhecido por YUI-ext (por ter sido baseado na biblioteca do Yahoo), o framework ExtJS pode ser bem complicado no início, mas é de todos o mais robusto no que diz respeito a interfaces de aplicações com opções para grids, layout, botões, gráficos e janelas.

Atualmente mantido pela empresa Sencha, o ExtJS vem nos sabores open source e comercial. Possui uma comunidade fortíssima com uma vasta documentação e, assim como o MooTools, é indicado para desenvolvedores com conhecimento em JavaScript.

[Nesse link][5] você confere algumas aplicações desenvolvidas em ExtJS, como, por exemplo, um leitor de feeds, um desktop web e um visualizador de imagens.

### Prototype + Script.aculo.us

[prototypejs.org][6]
  
[script.aculo.us][7]

Prototype pode ser considerado o avô dos frameworks JavaScript. Alguns dizem que seu sucesso ocorreu por ter sido escolhido como a biblioteca padrão do Rails, mas o Prototype ficou conhecido mesmo através do plugin Lightbox, que acabou engolindo o próprio framework.

O Prototype conta com uma biblioteca a parte para efeitos visuais, a Script.aculo.us.

Os desenvoldeores do framework perderam a oportunidade de colocar o Prototype no topo da cadeia de desenvolvimento JavaScript. Seu código acabou ficando muito complicado perto de códigos desenvolvidos com jQuery e MooTools.

### YUI 3

[developer.yahoo.com/yui/3/][8]

A biblioteca YUI (Yahoo User Interface) também foi pioneira e o seu diferencial sempre foi a gama de widgets, além, é claro, de ser a biblioteca oficial do Yahoo.

Como o próprio nome sugere, é focada na interface com usuário e foi uma das primeiras a oferecer scripts e módulos para abas, janelas, botões entre outros elementos. 

Apesar de não estar relacionado com JavaScript, outro recurso que a deixou famosa foi o seu [reset de CSS][9].

### Dojo Toolkit

[dojotoolkit.org][10]

Biblioteca que melhor aplica os princípios da orientação a objetos e, por isso, é uma das mais indicadas para desenvolvedores e para projetos maiores.

Um dos seus principais destaques é o alto nível de modularização, permitindo até o carregamento de módulos somente quando eles forem necessários (lazy loading).

### John Resig sobre as bibliotecas JavaScript

Para concluir, segue uma [apresentação][11] do criador do jQuery que, apesar de um pouco antiga (2008), é bem legal e fala sobre o framework e suas alternativas.

 [1]: https://mootools.net/
 [2]: https://mochaui.org/
 [3]: https://jqueryvsmootools.com/
 [4]: https://www.sencha.com/products/extjs/
 [5]: https://www.sencha.com/products/extjs/examples/
 [6]: https://www.prototypejs.org/
 [7]: https://script.aculo.us/
 [8]: https://developer.yahoo.com/yui/3/
 [9]: https://developer.yahoo.com/yui/3/cssreset/
 [10]: https://dojotoolkit.org/
 [11]: https://www.slideshare.net/jeresig/javascript-library-overview-presentation/