---
title: Agora é a vez dos desenvolvedores
authors: Diego Eis
type: post
date: 2012-02-05
excerpt: A revolução pode começar sem você.
url: /agora-e-a-vez-dos-desenvolvedores/
categories:
  - Opinião
tags:
  - Tecnologia e Tendências
  - Carreira
  - w3c
---
O desenvolvimento web depende de três personagens principais: **W3C**, que regulamenta, cria e sanciona padrões para a web. Os **browsers**, que importam essas regras e padrões de forma que a web seja mais homogênea e também podem criar padrões. E por fim os **desenvolvedores**, que aplicam os padrões em projetos, produzindo e criando na web.

Cada um destes personagens tem papéis importantes para que a web continue evoluindo com força, traçando novos caminhos, cobrindo as necessidades atuais dos usuários e prevendo necessidades e soluções futuras. Existe um ciclo que envolve estes três personagens para que tudo ande bem.

## O W3C

O W3C cuida dos padrões. Ele tem ideias, ele prevê problemas e tenta solucioná-los. Ele incorpora boas ideias dos desenvolvedores e principalmente dos browsers. O W3C não aplica, ele apenas planeja. É um trabalho difícil por que é necessário uma visão muito apurada da web. Uma decisão errada pode acarretar problemas que levarão anos para serem solucionados. Por isso esse trabalho de planejamento deve ser meticuloso. Devo confessar que em muitos casos o W3C não supera as expectativas e faz com que iniciativas paralelas surjam e direcionem a Web para um caminha mais correto. Foi o que aconteceu com o HTML 5.

## Os browsers

Os browsers, por sua vez, precisam entender e adotar as idéias do W3C, absorvendo as soluções e criando suporte nos seus softwares. Esse trabalho também tem seus perigos. Os browsers precisam pesquisar quais das necessidades dos desenvolvedores é mais importante e assim implementá-las. Não pode ser algo feito ao acaso. Os browsers precisam ouvir os desenvolvedores para implementar soluções que realmente ajudem na produção diária. Obviamente alguns decidem suportar aquelas soluções que darão mais pontos estratégicos contra o concorrente. Por que você acha que o Safari tem um bom suporte aos padrões desde o primeiro iPhone?

## Os desenvolvedores

Finalizando o ciclo, os desenvolvedores aplicam tudo o W3C define, mas apenas aquilo que os browsers “querem” ou podem suportar. E isso, claro, faz com que o desenvolvedor tenha problemas na produção. Principalmente de compatibilidade. Nesse ponto, hoje está tudo muito mais tranquilo. Mas quem nunca quis usar uma determinada API do Javascript ou uma propriedade do CSS que estava disponível apenas em um navegador?

Durante muito tempo, esse ciclo não era afinado. Havia uma certa confusão e um jogo de interesses próprios envolvendo principalmente os browsers. O W3C estava apenas pensando em como resolver problemas que talvez existiriam daqui longos anos. Os browsers estavam apenas interessados em criar uma massa de usuários suficiente para ser o primeiro no ranking. Os desenvolvedores, por sua vez, queriam ganhar seu dinheirinho, fazer o trabalho, entregar pro cliente e acabar com o problema.
  
Ninguém deu atenção quando começamos a desenvolver com tabelas, fazendo com que os sites ficassem mais pesados, aumentando o tempo de desenvolvimento e o custo do projeto. 

Este ciclo defeituoso foi praticado durante muito tempo. Por incrível que pareça, foram os Desenvolvedores que começaram a fazer o ciclo funcionar como deveria. Eles acordaram os fabricantes de browsers e também o W3C. A revolução começou nas trincheiras.

Por causa dessa revolução silenciosa dos desenvolvedores, o W3C passou a pensar mais em problemas presentes. Solucionou problemas iminentes e que entregavam valor para os projetos. 

> Os desenvolvedores fizeram duas revoluções: uma que foi liderada pelo pessoal da WaSP e outra quando um grupo começou o desenvolvimento do HTML 5, sem depender do W3C para planejar.

Os browsers suportaram o mais rápido possível essas mudanças, atualizando seus engines, e fortalecendo as bases para novas soluções e flexibilizações posteriores.

Já os desenvolvedores estagnaram. Desculpe-me, serei um pouco revoltado daqui para frente. Os desenvolvedores dormiram. Quando o W3C e os browsers apresentaram soluções para problemas como transparência, bordas arredondadas, backgrounds inteligentes, utilização de fonte remotas, apis de javascript decentes, novas tags e etc, os desenvolvedores resolveram que não era a hora dessas soluções por causa de coisas como o IE6. Na verdade estou sendo meio injusto aqui. Não foram todos os desenvolvedores que criaram caso com isso, foram somente os idiotas.

Logo os idiotas, que reclamavam tanto da falta de recursos mais inteligentes para trabalhar. Que precisávamos de idéias realmente inovadoras que transformassem os projetos e facilitassem o desenvolvimento. Protestaram, escreveram manifestos, postaram em blogs, revoltados com a falta de visão do W3C e com a pobreza do suporte dos browsers. Mas quando chegou a hora, deram para trás. Amarelaram. Pediram arrego.

Infelizmente, via-se muito mais disso aqui no Brasil do que no resto do mundo. Ouvi muitas desculpas como: &#8211; &#8220;Mas meu cliente usa IE6.&#8221; ou &#8220;Mas isso não funciona em IE6.&#8221;
  
Entenda uma coisa: você é desenvolvedor web. Você trata com seu cliente todos os dias. Você tem o poder de [educar e convencer][1]. Se você acha que não tem poder nenhum, por que ainda trabalha com web?

> Talvez isso seja trauma do passado. Talvez não. O fato é que não podemos mais nivelar por baixo. Isso é atrasar uma &#8220;evolução&#8221; inteira.

Temos falado incansavelmente aqui no Tableless sobre [Graceful Degradation, Enhanced Progressive][2], [HTML 5][3], as [maravilhas do CSS 3][4] e etc, pois esse é o assunto que rola lá fora. Há desenvolvedores e empresas, que acham que devemos ter uma autorização especial dos gringos para utilizarmos novas tecnologias e principalmente [para deixar os browsers antigos no passado][5].

Esse assunto me faz pensar em outra pergunta: Estamos (você está?) preparados para o ritmo alucinante que será ditado daqui pra frente?
  
Até a Microsoft está cumprindo com a palavra de ter um browser atualizado. Eles anunciam uma versão após a outra do Internet Explorer com mais inovações, suporte aos padrões e novidades&#8230; Mas ainda há os bobalhões que preferem falar mal do Internet Explorer do que abrir os olhos e seguir em frente.

O mercado de client-side se transformará rapidamente nos próximos anos. Muitas mudanças no HTML e no CSS serão publicadas com o intuito de tornar a web mais homogênea, flexível, portável. O HTML 5 não é só uma coleção de novas tags e APIs. O CSS 3 não ganhou só bordas arredondadas. E nem só de iPhone vive o homem. Existem milhares de Nokias, Windows Phones e Androids por aí.

Os desenvolvedores precisam acordar.

<small>Artigo originalmente publicado em Nov/2009 na revista TI Digital.</small>

 [1]: https://tableless.com.br/convencimento-e-educacao-liberdade/ "Convencimento e educação = liberdade"
 [2]: https://tableless.com.br/bem-vindo-a-xangrila-parte-1/ "Bem vindo a Xangri-lá – Parte 1"
 [3]: https://tableless.com.br/categoria/client-side/html-css/html5-client-side/
 [4]: https://tableless.com.br/categoria/client-side/html-css/css3/
 [5]: https://tableless.com.br/browsers-antigos-guerra-contra-o-terror/