---
title: 'Adobe Edge Inspect: Uma ajudinha no desenvolvimento para múltiplos dispositivos'
authors: Gabriel Nascimento
type: post
date: 2012-09-30
excerpt: Saiba como você pode testar seu código em diversos dispositivos com o Adobe Edge Inspect
url: /adobe-edge-inspect/
categories:
  - HTML
tags:
  - ferramentas
  - Mercado
  - Tecnologia e Tendências
  - adobe
  - desenvolvimento
  - inspect
  - mobile
---
Dentre as possibilidades de adaptação, temos técnicas de redimensionamento de tela, reconhecimento de dispositivos para redirecionamento a sites feitos especificamente pra este, a ainda envolta em mistério: a técnica de _responsive design,_ entre outras soluções. Em fim, cabe a escolha da melhor técnica de acordo com as definições do projeto adotado.

### Adobe Edge Inspect

Para facilitar a vida de quem encara constantemente ou até mesmo esporadicamente este tipo de desafio, a Adobe lançou dentro de seu kit de ferramentas denominado Edge Tools o curioso Inspect. Esta trata-se de uma ferramenta responsável por testar seu Website em diversos dispositivos simultaneamente. Inicialmente conhecido como Adobe Shadow, esta ferramenta executa a conexão entre seu navegador principal (Chrome) e os demais dispositivos com o aplicativo instalado, onde estes exibem a pagina ativa no navegado. Sendo assim, alterando propriedades HTML ou CSS no navegador, os demais dispositivos são atualizados instantaneamente.

### Como funciona?

Para utilizar o recurso você precisa ter um navegador (Chrome) com o plugin do Inspect instalado, os dispositivos que pretende usar para teste com o aplicativo instalado e rede Wi-Fi para permitir a sincronização.

Ao conectar um dispositivo com o App do Inspect instalado na rede Wi-Fi, será exibido um código de emparelhamento que deve ser digitado na interface do plugin onde está o nome do respectivo dispositivo. A fazer este procedimento corretamente, o dispositivo passa a exibir a guia ativa no navegador com o qual fez o emparelhamento. Ao alternar entre guias ou modificar o código da pagina, os dispositivos emparelhados atualizam instantaneamente.

Ainda é possível editar remotamente por meio da plugin instalado no navegador, o código da página de um dos dispositivos e acompanhar as modificações em tempo real no mesmo.

Para ver o que foi explicado acima, vejam este vídeo  <https://tv.adobe.com/watch/adobe-technology-sneaks-2012/adobe-shadow/>.

Já existem versões do aplicativo para IOS e Android, proporcionando assim uma compatibilidade com a maior fatia do mercado de dispositivos móveis.

### Conclusão

Sem duvidas é uma ferramenta que agiliza o processo de teste no desenvolvimento de websites para várias plataformas e dispositivos móveis, contudo ainda limita o teste aos dispositivos que o desenvolvedor detêm.

Sendo assim vale a pena conferir essa novidade que a gigante Adobe oferece para nós.

#### Fontes:

  * <https://www.webmonkey.com/2012/03/adobe-shadow-simplifies-mobile-web-testing/> 
  * [https://html.adobe.com/edge/inspect/?promoid=3tv64\_12285L&promoid=3tv64\_12314L][1] 
  * <https://tableless.com.br/responsive-web-design-voce-esta-fazendo-isso-errado/> 
  * <https://blogs.adobe.com/edgeinspect/2012/09/23/shadow-is-now-adobe-edge-inspect/>

 [1]: https://html.adobe.com/edge/inspect/?promoid=3tv64_12285L&promoid=3tv64_12314L