---
title: A usabilidade deve ser pensada por todos
authors: Talita Pagani
type: post
date: 2012-03-05
excerpt: A usabilidade é um compromisso de todos em um projeto. Ö que precisa acontecer é um diálogo maior entre o especialista de usabilidade e o restante da equipe.
categories:
  - Design
tags:
  - usabilidade
  - UX
  - Acessibilidade
---
No final de 2010, fui contatada pela <a title="Revista WIDE" href="https://revistawide.com.br/" target="_blank">Revista WIDE</a> para participar da seção “Opinião” respondendo à seguinte questão: Todos devem pensar em usabilidade? A proposta era opinar se a usabilidade era algo a ser pensado apenas pelo designer (ou especialista de usabilidade) ou se programadores, editores, entre outros membros da equipe, deveriam têm responsabilidade na facilidade de uso do projeto. Isto é um tema delicado, às vezes polêmico, mas importante para ser debatido.

O texto aqui divulgado é baseado na resposta que conferi à Revista WIDE e foi publicada na edição de Janeiro/Fevereiro de 2011.

Como já vimos em <a title="O que é Usabilidade?" href="https://tableless.com.br/o-que-e-usabilidade/" target="_blank">outros artigos</a>, a usabilidade é uma característica crítica de um website e, portanto, atualmente temos especialistas focados neste quesito. Mas existem aspectos que são tangíveis a designers, programadores e redatores/editores de conteúdo, sendo fatores pertinente a todos os profissionais envolvidos em um projeto. Porém, um dos maiores desafios é fazer com que toda a equipe tenha essa consciência das responsabilidades que os membros da equipe possuem quanto à usabilidade do projeto, cada qual dentro de seu contexto.

Programadores e redatores de conteúdo não precisam se tornar especialistas em usabilidade, mas precisam compreender qual o seu papel, a sua contribuição para a facilidade de uso de um website. O programador é o responsável por implementar a interface planejada. Durante a implementação, aparecem questões funcionais de facilidade de uso que não foram previstas nos _wireframes_, _storyboards_ e diagramas de fluxo de interação. Um campo de formulário sem validação, um erro de programação sem tratamento adequado que mostra uma mensagem genérica, um cadastro que não informa se a operação &#8220;salvar&#8221; foi bem sucedida, campos sem valores default, entre outros, são exemplos de falhas comuns que o programador pode corrigir para melhorar a experiência do usuário se ele conhecer algo sobre usabilidade.

Da mesma forma, o designer pode projetar algo que tenha um bom apelo visual, mas que não apresente claramente o conteúdo do site, onde o usuário pode clicar, para onde ele pode ir. O redator também tem um papel importante na usabilidade: textos que sejam de fácil leitura, conteúdo claro e conciso que fale a linguagem do público-alvo, títulos de seções e artigos que sejam perceptivos e intuitivos facilitam a forma como as pessoas interagem e navegam em um determinado website. Um texto confuso pode comprometer a usabilidade, mesmo que do ponto de vista da interface e da funcionalidade esteja tudo correto.

Quando se trata de usabilidade, um detalhe pode afetar a experiência do usuário. Toda a equipe tem que trabalhar em sintonia e cooperativamente para que a experiência do usuário seja abordada corretamente em todos os aspectos.

Da mesma forma como programadores precisam entender algumas questões de usabilidade, é importante também que os especialistas em usabilidade compreendam determinadas restrições em termos de design, de implementação do código e de comunicação. Esta interação entre toda a equipe é importante para que a usabilidade seja pensada não somente sob o prisma da interface com o usuário, mas também sobre o ponto de vista funcional.

O especialista de usabilidade pode atuar como um consultor da equipe em todas as fases de desenvolvimento de um projeto, mas cada profissional também precisa compreender diretrizes de usabilidade dentro do seu contexto de trabalho. É um esforço conjunto que precisa envolver toda a equipe.