---
title: A linguagem como parte integrante da user experience
authors: Dani Guerrato
paid: true
type: post
date: 2013-02-26
excerpt: A linguagem é a ferramenta que utilizamos para entender e definir o mundo. E isto vale também para a criação de interfaces.
url: /a-linguagem-como-parte-integrante-da-user-experience/
dsq_thread_id: 1105236417
categories:
  - Código
  - Design
  - UX

---
É do campo da user experience estudar a percepção e as reações emocionais e psicológicas de uma pessoa sobre um produto, sistema ou serviço. Na prática isto envolve diversas disciplinas como arquitetura da informação, design de interfaces, usabilidade&#8230; Estes elementos são fundamentais para garantir uma boa experiência do usuário, mas muitas vezes esquecemos do principal em uma comunicação: a linguagem.

A linguagem é a ferramenta que utilizamos para entender e definir o mundo. E isto vale também para a criação de interfaces. O texto dos botões, por exemplo, tem a função, em tese, de comunicar de maneira simples e rápida o destino de uma âncora, mas muitas vezes acabam fazendo o usuário se sentir confuso, irritado, desestimulado ou até levemente ofendido. Gastamos muito tempo com o aspecto gráfico, mas a escolha das palavras em uma interface é frequentemente menosprezada.

É claro, nem sempre temos controle sobre o conteúdo final. Mas as ações principais de menus, links e &#8220;call to actions&#8221; deveriam, em uma situação ideal, ser nomeadas pelo designer. Afinal, se algumas expressões podem arruinar a experiência do usuário devemos levar a escolha do vocabulário com mais seriedade e responsabilidade. Ninguém tem a obrigação de ser um especialista em linguística. Mas algumas dicas simples podem te ajudar a escolher a melhor palavra para apontar o usuário na direção correta. Vamos a elas!

## Toda vez que você utiliza &#8220;clique aqui&#8221; um gatinho morre.

Okay. Talvez nem tanto&#8230; Mas existem diversos problemas associados com esta expressão. A começar pela palavra clique. Seu usuário sabe o que é um link. Ele sabe como usar um mouse. Você não precisa ensina-lo, certo? Seria mais interessante descrever qual é a ação que o usuário vai realizar ao clicar. O foco deve ser no conteúdo e não na mecânica.

> Muitas vezes esquecemos do principal em uma comunicação: a linguagem.

Outro ponto contra o verbo clicar é que esta não é mais a única ação disponível. Com a crescente popularidade de dispositivos capazes de acessar a internet como tablets, smartphones, televisores e consoles de games portáteis o modo de acesso a informação também se transforma. Quando você utitiliza um joystick, caneta stylus ou a ponta dos dedos não existe mais o clique em seu sentido literal. É necessário ter um mouse para clicar&#8230; Utilizar uma linguagem que não exclui nenhum usuário também deve ser uma preocupação do designer.

A palavra &#8220;aqui&#8221; é outra dor de cabeça. Muitas vezes um usuário apenas escaneia o conteúdo de uma página, sem efetivamente ler o texto completo. Links e botões chamam a atenção por seu constraste de cor, formato, peso, etc. O ideal é que o seu visitante saiba do que se trata aquele link sem precisar ler o restante do texto. Ele precisa saber onde está indo. O contrário pode levar a confusão, perda de tempo desnecessária e até desistência do usuário em realizar a ação.

Se nada disso te convenceu pense que é uma questão de SEO. Os mecanismos de busca vão relacionar o texto do seu link ao conteúdo final, que ficará vinculado a expressão escolhida. É extremamente recomendável portanto portanto utilizar palavras-chaves relevante para o seu link. Insistir em utilizar &#8220;clique aqui&#8221; pode gerar um impacto negativo no seu ranking no Google.

## Dicas para nomear botões e links

O ideal é combinar verbos e substantivos para descrever a tarefa utilizando duas ou três palavras. Expressões como &#8220;Assista o video&#8221;, &#8220;Crie sua conta&#8221;, &#8220;Leia mais&#8221; e &#8220;Enviar mensagem&#8221; sinalizam claramente qual é a ação a ser realizada através de um botão.

> Insistir em utilizar &#8220;clique aqui&#8221; pode gerar um impacto negativo no seu ranking no Google

Para links únicos o ideal é descrever de maneira concreta qual é a página destino. Seja o mais específico possível. Evite palavras genéricas como filme, livro, jogo, etc. Utilize nomes próprios e títulos dos objetos em questão. É muito menos efetivo dizer [leia o artigo][1] do que [leia o artigo Repensando CSS Resets][1].

Reparou como o link anterior ganhou mais destaque? É por que eu estruturei a frase de maneira a deixa-lo propositalmente no final do texto. O espaçamento entre parágrafos faz com que os links no fim da frase chamem naturalmente mais atenção já que a posição coincide com o ponto de quebra do texto.

Mas evite utilizar links muito longos. Se você utilizar duas ou três linhas para descrever um link ele fica difícil de distinguir do restante do parágrafo.

## Meu vs Seu

O que é correto &#8220;minha conta&#8221; ou &#8220;sua conta&#8221;? &#8220;Meu perfil&#8221; ou &#8220;seu perfil&#8221;? Aqui não existe uma resposta definitiva. Depende muito do contexto. Ao utilizar o pronome &#8220;meu&#8221; o ênfase está em aquela ferramenta ser uma posse, parte do que pertence ao usuário. Mas existe uma certa seriedade e frieza nesta interação. O que muitas vezes não é o ideal para um sistema.

Interfaces são essencialmente plataformas de comunicação. São agentes que servem como um meio para carregar uma mensagem ou executar uma tarefa. Se você se refere ao &#8220;seu&#8221; perfil o ênfase passa a ser no &#8220;você&#8221;. A interface passa assim a ter uma personalidade, como um interlocutor que conversa diretamente com o visitante. O usuário torna-se o centro das atenções já que o sistema passa a trabalhar para um &#8220;você&#8221;, em &#8220;seu&#8221; beneficio. Este aspecto social torna a expressão &#8220;sua conta&#8221;, &#8220;seu perfil&#8221;, &#8220;seu cadastro&#8221;, etc opções mais interessante, principalmente para o caso de plataformas sociais. A frase &#8220;O que esta acontecendo agora?&#8221; foi uma das grandes responsáveis pelo sucesso do Twitter. O Facebook inclui recentemente diversas pequenas mensagens no campo de postagem. Ele muitas vezes me pergunta &#8220;Como vai, Dani?&#8221;, &#8220;O que está acontecendo, Dani?&#8221; e até &#8220;Como você está se sentindo, Dani?&#8221;. Este tipo de interação humaniza a inteface. É como se o próprio Facebook fosse um dos meus amigos, efetivamente interessado em saber o que acontece comigo. Este tipo de práticas é visto com simpatia pelos usuários que se sentem mais incentivados a postar na plataforma.

## Esqueça o botão &#8220;cancelar&#8221; em formulários

Botões como &#8220;cancelar&#8221;, &#8220;limpar dados&#8221; e &#8220;apagar&#8221; só servem para atrapalhar o usuário que pode acidentalmente clicar na opção errada e perder todos os dados já preenchidos. Se o usuário quiser desistir ele pode clicar no botão &#8220;voltar&#8221; ou escolher outro link no menu. Não faz o menor sentido existir um botão para apagar os campos já preenchidos&#8230;

> Interfaces são essencialmente plataformas de comunicação.

## &#8220;Ok&#8221; não diz nada

O botão &#8220;ok&#8221; é uma herança das antigas interfaces gráficas. Em sistemas mais antigos só haviam duas opções: confirmar ou cancelar uma ação. Este tipo de pensamento binário não se aplica mais a nosso tempo. Nem todos os usuários querem perder tempo lendo todo texto explicativo de uma caixa de diálogo. Um botão informativo diminui o tempo necessário para a tomada da decisão e garante que o usuário saiba exatamente o que vai acontecer. É muito mais efetivo utilizar botões que descrevem diretamente as tarefas a serem realizadas como: &#8220;salvar&#8221;, &#8220;enviar&#8221; e &#8220;buscar&#8221;.

## Saiba como utilizar a emoção a seu favor

Palavras como &#8220;agora&#8221;, &#8220;hoje&#8221; e &#8220;tempo limitado&#8221; criam tensão e um senso de urgência que pode muitas vezes influenciar na hora de uma decisão. Mas use com moderação pois o usuário pode sentir pressionado demais a realizar aquela ação. Expressões no tempo imperativo acompanhadas de pontos de exclamação como &#8220;Compre agora!&#8221; ou &#8220;Cadastre-se já!&#8221; possuem o mesmo efeito. Novamente é necessário dosar. Você não quer parecer desesperado, certo?

## A ordem dos fatores

Já reparou que na maior parte dos casos os botões contato e cadastro aparecem no final de um menu? É uma pratica padrão deixar os links para as páginas informativas como Sobre, Serviços, Produtos, etc primeiro e os links que requerem uma ação do usuário no final da lista. E isto faz todo sentido, afinal, o visitante primeiro precisa saber quem você é para depois interagir com o seu serviço. Só depois de você construir credibilidade e confiança ele estará interessado em realizar uma ação. Ninguém vai assinar um feed RSS sem primeiro conhecer o conteúdo de um site. O mesmo vale para entrar em contato.

> Apontar para os links principais do site, um campo de busca e um formulário de contato são boas práticas que conquistam de volta a simpatia e engajamento do usuário.

## Evite linguagem técnica

Se você é um desenvolvedor web é provavel que esteja bem familiarizado com os jargões da internet. Mas, dependendo do seu público alvo, você não pode esperar automaticamente do seu visitante o mesmo tipo de conhecimento. Evite expressões técnicas. Um exemplo prático é o botão &#8220;submeter&#8221;. Esta palavra é muito ligada ao mundo dos sistemas e passa a impressão que o seu site é pouco amigável.

## Seja simpático na hora de comunicar um problema

Uma mensagem de erro efetiva deve descrever o que aconteceu, por que aconteceu e como resolver o problema. Um exemplo clássico é o infame &#8220;Erro 404&#8221;. Esta mensagem padrão não é suficiente para comunicar a um usuário não familiar com a linguagem da internet que a página que ele solicitou não foi encontrada. É necessário explicar isto com palavras, não com códigos. Uma boa prática é utilizar um tom gentil, informativo ou até bem humorado nesta hora. Afinal, o usuário não encontrou o que procurava, provavelmente está um pouco irritado com esta situação e a probabilidade dele desistir de continuar navegando aumenta bastante nesta hora&#8230; Explique que a culpa não foi dele e ofereça alternativas. Apontar para os links principais do site, um campo de busca e um formulário de contato são boas práticas que conquistam de volta a simpatia e engajamento do usuário.

## Encontre o tom certo

Estilo e consistência também são elementos importantes. É necessário conhecer o público alvo de um site para escolher a variante linguística mais adequada. Uma linguagem puramente acadêmica pode entediar um público mais jovem, enquanto o uso recorrente de gíria e abreviações vai fazer os mais velhos rangerem os dentes em irritação. E não force a barra. Encontre o estilo ideal para a sua marca. Tentar parecer descolado demais muitas vezes tem o efeito oposto&#8230; Evite utilizar adjetivos que possam se aplicar a qualquer um. Tente encontrar o que faz o seu produto ou serviço único.

> Ninguém vai assinar um feed RSS sem primeiro conhecer o conteúdo de um site. O mesmo vale para entrar em contato.

## Teste teste teste

Quando você não tiver uma boa estimativa de quem é o seu usuário padrão é necessário utilizar uma linguagem acessível ao público em geral. A pergunta de ouro aqui é: &#8220;Minha mãe entenderia?&#8221;. Se a resposta for sim você está em um bom caminho. Você pode até realizar alguns testes simples. Peça para seus familiares e amigos navegarem no site e realizarem uma ação simples como cadastrar-se para um serviço e depois avaliarem o grau de dificuldade. Se você escolher pessoas de idade, sexo, profissão, classe social e regiões diferentes vai ter um bom material para trabalhar. E lembre-se: faça perguntas objetivas! Evite perguntar se gostaram ou não. Este tipo de pergunta inibe as pessoas. O que você deve avaliar neste momento é a facilidade de uso, organização e entendimento do conteúdo. O prazo está curto? Sem problemas. Existem algumas ferramenta online como [FiveSecondTest][2] que agilizam o processo.

## Conclusão

O cuidado com a linguagem é essencial para garantir que seus visitantes saibam quando, como e por que realizar uma ação. Estes pequenos detalhes garantem que a comunicação seja efetivada de maneira clara e objetiva, tornando as interfaces digitais plataformas mais humanas. Os resultados? Mais cliques, mais conversões e mais usuários felizes.

[Language: The Ultimate User Interface][3]
  
[Why your links should never say click here][4]
  
[Why your form buttons should never say submit][5]
  
[Yours vs Mine][6]

 [1]: https://tableless.com.br/repensando-css-resets/ "Repensando CSS Resets"
 [2]: https://fivesecondtest.com/
 [3]: https://alistapart.com/article/ultimate
 [4]: https://uxmovement.com/content/why-your-links-should-never-say-click-here/
 [5]: https://uxmovement.com/forms/why-your-form-buttons-should-never-say-submit/
 [6]: https://dcurt.is/yours-vs-mine