---
title: A internet faz você feliz?
authors: Tiago Dória
paid: true
type: post
date: 2015-10-08
url: /a-internet-faz-voce-feliz/
categories:
  - Opinião
tags:
  - Comportamento
  - Tecnologia e Tendências
---

O mundo está mudando, e para melhor. Segundo [Rafael Calvo][1], pesquisador do Departamento de Ciências da Computação da [Universidade de Sydney][2], estamos entrando rapidamente numa nova fase no desenvolvimento e design de softwares. Nesta nova etapa da computação, produtividade e eficiência não serão mais os únicos critérios para mensurar o sucesso de um sistema.

Para Calvo, essa nova fase é parte de uma saga em [inovação na área de UX][3]. Num primeiro estágio, nos preocupamos em criar sistemas que tivessem usabilidade, e, num momento posterior, que sustentassem hábitos. E agora o foco está em criar sistemas que nos façam não somente mais inteligentes, produtivos e sociais, mas também mais felizes e bem-vindos.

Calvo é autor de [Positive Computing][4], livro que sustenta a ideia de que devemos inserir os conceitos de felicidade e bem estar ao delinear um software. As ideias do pesquisador têm chamado a atenção de muita gente do Google, Facebook e MIT. Há um mês, tive a oportunidade de assistir a sua [palestra][5] no MIT, aqui, em Boston.

Segundo Calvo, numa primeira fase, a computação foi impulsionada por produtividade e eficiência, onde os usuários eram vistos como máquinas (como se as pessoas estivessem interessadas somente em aumentar a sua produtividade e eficiência). Hoje buscamos mais das tecnologias. Não basta que nos tornem mais produtivos, inteligentes e sociais, queremos também nos sentir mais felizes e realizados.

Essa mudança na expectativa sobre o que as tecnologias podem fazer por nós teria surgido por várias razões:

**1)** A partir do momento em que softwares passam a fazer parte de cada aspecto da vida das pessoas, estas passam a esperar mais das tecnologias (não só aumento de produtividade, comunicação rápida ou eficiência).

**2)** A ideia de que é impossível mensurar de forma científica felicidade e bem estar tem sido deixada de lado. É inegável que ainda existe pouca experiência em medir tais aspectos no desenvolvimento de software; entretanto a área de “interação humano computador” (HCI) vem colocando essas questões há bastante tempo.

A rigor, felicidade e bem estar têm sido mensurados por economistas, psicólogos e governos. A ONU tem o seu próprio índice de felicidade &#8211; [World Happiness Report][6]. Já o governo britânico produz periodicamente um relatório sobre felicidade e bem estar, o qual é utilizado como referência para criar políticas públicas.

**3)** Recentes avanços em tecnologia de dados, affective computing e computing vision abriram consistentes caminhos para avaliar a felicidade e a realização dos usuários. E isso pode ser usado como métrica e referência na hora de projetar um software.

Como tudo isso acontece na prática? Na área de softwares para tratamento médico, faz bastante sentido. Entretanto envolve repensar e criar funcionalidades que realmente promovam o bem estar, como desenvolver uma arquitetura que evite o bullying numa rede social.

As ideias de Calvo demonstram uma vez mais que o desenvolvimento de software vem cada vez mais bebendo na fonte de outras áreas. O que o pesquisador da Universidade de Sydney faz é mesclar ideias da [psicologia positiva][7] com das ciências da computação. E isso é bem interessante e inspirador.

Positive computing é mais um exemplo de como nós, desenvolvedores, designers e tecnologistas, estamos sempre questionando a forma como fazemos as coisas. E essa é uma das características mais bacanas de se trabalhar com tecnologia: estamos num ambiente onde é normal questionar o que até então era tratado como verdade absoluta.

&#8212;
  
Apoio [Net Combo][8].

 [1]: https://twitter.com/rafael_a_calvo
 [2]: https://sydney.edu.au/
 [3]: https://www.forbes.com/sites/giovannirodriguez/2015/01/25/positive-computing-the-next-big-thing-in-human-centered-design/
 [4]: https://mitpress.mit.edu/books/positive-computing
 [5]: https://twitter.com/tdoria/status/643880204037943296
 [6]: https://worldhappiness.report/
 [7]: https://pt.wikipedia.org/wiki/Psicologia_positiva
 [8]: https://www.combomultinet.com/net-combo/