---
type: post
title: 'A importância da teoria das cores na escolha dos elementos visuais '
excerpt: O que a Teoria das Cores diz para o sucesso de um design digital.
authors: Tableless
date: '2019-05-01'
publishDate: '2019-05-01'
image: 'https://i.imgur.com/b8LhlJs.png'
categories:
  - Publieditorial
tags:
  - ui
---
Ao criar um website, blog, ou qualquer outra plataforma digital, uma das mais importantes decisões diz respeito às cores que serão usadas. Se durante a criação dos elementos visuais essa etapa for ignorada, muito provavelmente o resultado não será tão bom quanto poderia ser. Para buscar o sucesso gráfico, é preciso um pouco de tempo para entender a melhor forma de decidir quais cores serão usadas e como isso impactará na usabilidade da plataforma. Como o [McDonald’s](https://www.mcdonalds.com.br/) consegue uma harmonia tão grande em suas redes digitais?

Certamente, a empresa não confia apenas na sua intuição e bom gosto de quem cria seus elementos de publicidade. E por qual motivo empresas como o [Subway](https://www.subway.com/pt-BR) utilizam cores que lembram uma horta? Bem, existem vários truques simples que podem ser usados para encontrar as melhores opções. Se os passos forem seguidos de forma correta, a paleta de cores estará sempre ajustada e a plataforma se destacará em um mar de designs sem graça. Antes, porém, é preciso entender o que é a teoria das cores.

## A teoria das cores

“Teoria das cores” é um termo usada para descrever uma coleção de regras e guias que governam o uso de cores em qualquer elemento artístico e de design. A teoria informa qual o melhor esquema de cores para atingir uma estética agradável e efetiva para a comunicação de uma mensagem gráfica. Para tal, a teoria se vale da influência das cores tanto nos aspectos visuais e quanto nos psicológicos.

Para exemplificar, é só pensar na temperatura da cor – um aspecto vital nos designs. É possível distinguir as cores em quentes, frias e neutras, sendo que cada uma delas é capaz de evocar uma resposta emocional nas pessoas. Empresas de fastfood e [cassino Brasil](https://cassinosbrazil.com.br/) se aproveitam dessa característica majestosamente. Ambas utilizam cores quentes, tais como o vermelho-vivo, laranja e amarelo para, no caso da primeira, fomentar o consumo de alimentos e, no caso da segunda, encorajarem os usuários a apostarem maiores quantias em seus jogos.

![Espaço interno de um estabelecimento da empresa de fast food McDonald’s. As cores quentes predominantes têm importante papel emocional para fomentar o consumo. (FONTE: The Spoon)](https://i.imgur.com/Qu37nxK.png)

_Espaço interno de um estabelecimento da empresa de fast food McDonald’s. As cores quentes predominantes têm importante papel emocional para fomentar o consumo. (FONTE: The Spoon)_

As cores podem ser combinadas para ajudar os designers a conseguirem harmonia em suas artes. Quanto à harmonização, as cores podem ser:

- **Análogas**: quando três cores são localizadas ao lado uma da outra na paleta de cores;
- **Complementares**: quando uma ou mais cores, quando combinadas, cancelam umas às outras, produzindo contraste;
- **Split-complementares**: combinação de cores análogas e complementares;
- **Triádica**: três cores com distâncias equivalentes umas das outras na paleta de cores;
- **Tetrádicas**: quando dois conjuntos de cores complementares são usados.

## Considerações

Quando se trata de design e web design, a escolha das cores não deve ser deixada de lado. Mesmo que as páginas e o conteúdo sejam impressionantes, é preciso usar as cores certas para garantir que cada elemento prenda a atenção dos visitantes. Confiar apenas no instinto pode, às vezes, não dar muito certo. Portanto, uma abordagem mais analítica deve ser procurada para que os elementos visuais sejam mais uma carta na manga visando ao sucesso de uma marca, site de empresa ou outra identidade visual.
