---
title: 7 Plugins do sublime text que você deveria conhecer
authors: Pedro Polisenso
type: post
date: 2014-08-26
excerpt: Conheça 7 plugins de Sublime Text que podem ajudar a sua produtividade diária.
url: /7-plugins-sublime-text-que-voce-deveria-conhecer/
dsq_thread_id: 2938770245
categories:
  - Código
  - Editores
  - Técnicas e Práticas
tags:
  - editores
  - ferramentas
  - sublime
  - tooling

---
## O Package Control

Antes de tentar instalar qualquer pacote e começar a brincadeira, é importante que você já tenha instalado em seu Sublime o “package control&#8221; de acordo com sua versão: [Sublime Text 2][1] ou [Sublime Text 3][2]. 

O Package Control é um plugin para Sublime que vai gerenciar todos os outros plugins. Com ele você vai instalar, desinstalar e configurar todos os plugins do seu Sublime. 

Saiba mais <a href="https://sublime.wbond.net/installation" target="_blank">aqui!</a>

[<img class="alignnone size-full wp-image-43953" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/02.jpg" alt="02" width="531" height="359" srcset="uploads/2014/08/02.jpg 531w, uploads/2014/08/02-205x139.jpg 205w, uploads/2014/08/02-400x270.jpg 400w" sizes="(max-width: 531px) 100vw, 531px" />][3]

## 1 &#8211; Emmet

O Emmet (anteriormente conhecido como Zen Coding) é simplesmente um conjunto de ferramentas de desenvolvimento web que ajudam a codificação de HTML e CSS. Ele permite que você crie, com mais velocidade, seus elementos através de expressões específicas, seguidas da tecla TAB. Saiba mais em <https://emmet.io/>

#### Escrita da expressão: 

<pre class="lang-html">ul # nav&gt; li.item $ * 4&gt; a {item $} + TAB</pre>

#### Resultado:

<pre class="lang-html">&lt;Ul id = "nav"&gt;
   &lt;Li class = "Item1"&gt; &lt;a href=""&gt; &lt;/a&gt; News Item 1 &lt;/ li&gt;
   &lt;Li class = "Item2"&gt; &lt;a href=""&gt; &lt;/a&gt; Item 2 &lt;/ li&gt;
   &lt;Li class = "Item3"&gt; &lt;a href=""&gt; &lt;/a&gt; ponto 3 &lt;/ li&gt;
   &lt;Li class = "Item4"&gt; &lt;a href=""&gt; Novamente, 4 &lt;/a&gt; &lt;/ li&gt;
&lt;/ Ul&gt;</pre>

## 2 &#8211; jQuery

Esse plugin pode facilitar bastante na momento da criação de bibliotecas em seus projetos. Ele é um pacote que fornece alguns trechos para a maioria dos métodos do jQuery, muito usados no dia a dia.

[<img class="alignnone size-full wp-image-43965" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/03.jpg" alt="03" width="531" height="359" srcset="uploads/2014/08/03.jpg 531w, uploads/2014/08/03-205x139.jpg 205w, uploads/2014/08/03-400x270.jpg 400w" sizes="(max-width: 531px) 100vw, 531px" />][4]

## 3 &#8211; ColorHighlighter

Esse é um plugin maneiríssimo e serve para o Sublime Text 2 e 3. Ele inspeciona discretamente os valores de cores hexadecimais selecionados em diferentes estilos e ícones. Além disso, o plugin adiciona o seletor de cores eum conversor de formato de cor. Seria um tipo de “inspecionar elemento” para cores em tempo real. =]

[<img class="alignnone size-full wp-image-43966" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/04.gif" alt="04" width="700" height="400" />][5]

## 4 &#8211; AlignTab

Esse plugin é bem interessante para sua forma de organização de códigos. Ele vai te auxiliar a permanecer com uma indentação 100% padronizada. É um plugin de alinhamento usando expressão regular. Confira abaixo suas características:

  * Alinha usando expressão regular
  * Espaçamento personalizado, preenchimento e justificado
  * Detecção inteligente para alinhamentos se linhas são selecionadas
  * Suporte a múltiplos cursores
  * Modo de mesa e modo de visualização ao vivo

[<img class="alignnone size-full wp-image-43970" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/05.gif" alt="05" width="690" height="388" />][6]

## 5 &#8211; ColorSchemeSelector

Esse plugin costuma chamar de “plugin para design”, porque ele vai permitir que você crie uma customização no seu Sublime Text. Resumidamente ele serve para selecionar esquema de cores através do Painel. Infelizmente isso só são adotados cores padrões escolhidas pela ferramenta.

[<img class="alignnone size-full wp-image-43971" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/06.gif" alt="06" width="840" height="534" />][7]

## 6 &#8211; CSS3 Syntax ou CSS3

Esse plugin serve para manter uma boa organização no CSS. Existem casos onde queremos acabar ir logo embora para casa e acabamos esquecendo um simples &#8220;**;**&#8220;. O CSS3 Syntax ou apenas CSS3 é bem abrangente, pois se baseia nos mais recentes projetos e especificações atuais. **Uso: Navegue até View > Syntax > CSS3**

#### Todas as propriedades deverão terminar com ponto e vírgula.

[<img class="alignnone size-full wp-image-43972" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/07.jpg" alt="07" width="499" height="222" srcset="uploads/2014/08/07.jpg 499w, uploads/2014/08/07-265x117.jpg 265w, uploads/2014/08/07-400x177.jpg 400w" sizes="(max-width: 499px) 100vw, 499px" />][8]

#### Todas as propriedades deverão ser escritas em minúsculo.

[<img class="alignnone size-full wp-image-43973" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/08.jpg" alt="08" width="499" height="219" srcset="uploads/2014/08/08.jpg 499w, uploads/2014/08/08-265x116.jpg 265w, uploads/2014/08/08-400x175.jpg 400w" sizes="(max-width: 499px) 100vw, 499px" />][9]

_OBS: O plugin **CSS3 Syntax** estava para ser substituído pelo **“CSS3”**. Na hora de instalar, pesquise pelo 2 nomes e instale o que for de sua preferência._

## 7 &#8211; JavaScriptNext

Bom. Como a graça é sempre deixar o melhor pro final, te apresento o **JavaScriptNext.** Este é um pacote de sintaxe melhorada para JavaScript. Baseia-se nos arquivos de linguagem comumente usados ​​e também inclui novos recursos de ECMAScript 6 como módulos, métodos, arrows functions, classes, geradores e acessores (ES5).

Se você quiser usá-lo para cada arquivo js, você ​​cria ou abra um arquivo JavaScript, e dai clica no nome de sintaxe no canto inferior direito do Sublime, em seguida, clique em &#8220;Abrir todos com extensão atual e depois selecione JavascriptNext &#8211; ES6 > JavascriptNext.

Você já vai poder ir testando as novas funcionalidades que o ES6 tem para apresentar, e é claro, ir se familiarizando com essa parada nota 10.

[<img class="alignnone size-full wp-image-43976" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/10.jpg" alt="10" width="650" height="459" srcset="uploads/2014/08/10.jpg 650w, uploads/2014/08/10-196x139.jpg 196w, uploads/2014/08/10-400x282.jpg 400w" sizes="(max-width: 650px) 100vw, 650px" />][10]

[<img class="alignnone size-full wp-image-43974" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/09.jpg" alt="09" width="630" height="366" srcset="uploads/2014/08/09.jpg 630w, uploads/2014/08/09-239x139.jpg 239w, uploads/2014/08/09-400x232.jpg 400w" sizes="(max-width: 630px) 100vw, 630px" />][11]

### Concluindo

Pesquise e estude suas ferramentas de trabalho. Seu editor pode se tornar muito mais poderoso do que você pode imaginar. De repente todo mundo estava usando Sublime Text e isso faz com que esse editor seja poderoso. Há outros editores surgindo e ganhando espaço no mercado, como o Atom e o Brakets, mas o Sublime foi um acontecimento inesperado e feliz.

 [1]: https://sublime.wbond.net/installation#st2
 [2]: https://sublime.wbond.net/installation#st3
 [3]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/02.jpg
 [4]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/03.jpg
 [5]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/04.gif
 [6]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/05.gif
 [7]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/06.gif
 [8]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/07.jpg
 [9]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/08.jpg
 [10]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/10.jpg
 [11]: https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2014/08/09.jpg