---
title: 7 dicas de otimização de conversão em landing pages
authors: Rodrigo Simoni
type: post
date: 2013-05-20
excerpt: Entenda melhor como otimizar conversões em landing-pages.
url: /7-dicas-de-otimizacao-de-conversao-em-landing-pages/
dsq_thread_id: 1286607856
categories:
  - SEO
  - UX
tags:
  - 2013
  - conversao
  - landing pages

---
O e-commerce no Brasil tem tido um crescimento acelerado nos últimos anos. Segundo a e-bit, empresa especializada em dados do setor, estima-se que só em 2013 haverá um crescimento de até 24%, gerando uma receita de 28 bilhões e atingindo cerca de 50 milhões de consumidores online.

Diante disso, é cada vez mais importante que cada detalhe de um e-commerce ou uma landing page seja pensado para atrair mais leads, ou seja, mais conversões. Por isso, a otimização de conversão em sites tem se mostrado cada vez mais presente no setor de [marketing digital][1] e [SEO][2] e fazer uso dessas técnicas com certeza irá aumentar o número de leads e consequentemente o aumento da sua receita.

As técnicas de otimização de conversão também têm se mostrado presentes, em especial às landing pages, isto é, páginas de destino onde o usuário possa concluir uma meta ou objetivo final do site: Conversão. As landing pages são criadas exatamente para fazer com que o usuário encontre facilmente o que deseja e possa sair da página satisfeito e com seu objetivo concluído. Neste artigo, irei citar 07 dicas importantes de otimização de conversão que lhe auxiliarão a melhorar os resultados de qualquer landing page. Vamos a elas:

## 1 – Call to Actions claros

O Call to Action, ou chamada à ação, são botões de conversão. É clicando nos botões de Call to Action que o usuário é levado para a conversão de uma landing page. Ele é o botão mais importante da página e por isso, é fundamental que ele seja extremamente claro e objetivo em sua chamada e que preferencialmente possua uma cor que contraste com o restante das cores do site e que chame mais atenção que os outros elementos.

[<img alt="Call to Action" src="https://www.conversion.com.br/uploads/2013/05/call-to-action.jpg?9d7bd4" width="560" height="388" />][3]

Neste exemplo, o Call to Action é fácil de ser visto na página. O botão se encontra no topo da página e não precisamos usar a barra de rolagem para visualizá-lo. A chamada “Crie uma conta grátis” está mais do que clara e o botão é amarelo, constrastando com o resto das cores. Tenha um botão de Call to Action onde todos possam ver sem ter que pensarem.

## 2 – Quanto menos escolhas melhor

[<img alt="Muitas escolhas" src="https://www.conversion.com.br/uploads/2013/05/muitas-escolhas.jpg?9d7bd4" width="560" height="299" />][4]

> Landing pages: páginas de destino onde o usuário possa concluir uma meta ou objetivo final do site.

Muitas landing pages são projetadas para terem bastante conteúdo, fazendo com que o usuário tenha o máximo de informação relevante possível, afinal, você sabe o quanto seu produto ou serviço é maravilhoso e quanto mais informação sua página oferecer, mais você convencerá seus visitantes de que realmente é bom. A verdade é que a coisa toda não funciona assim.

Quando estamos visitando a página pela primeira vez, damos uma olhada por cima e em questão de milésimo de segundos, tomamos decisões e clicamos onde achamos que seja o lugar certo. A questão é que quanto mais informações e distrações sua página conter, mais o usuário ficará confuso e poderá simplesmente sair da sua página. Faça com que sua landing page contenha informações precisas e que seu visitante possa ter a menor possibilidade de escolha possível.

## 3 – Formulários chatos

Quem aqui gosta de preencher um bom e velho formulário de contato? Imagine você entrando em uma loja de sapatos onde o vendedor insiste em solicitar o seu nome, e-mail, idade, data de nascimento, número do cartão de crédito, endereço, escolaridade, RG, CPF, carteira de motorista, nome da mãe, nome do pai, nome dos irmãos, nome do papagaio e uma série de informações? Você só quer comprar um sapato e ir embora, mas se não preencher esses dados não levará. Isso é bastante parecido com o que acontece nos formulários de landing pages.

É comum vermos páginas nos oferecendo um simples e-book grátis, mas para isso precisamos preencher dezenas de campos chatos de formulário. Ninguém gosta de formulários. Nem mesmo o mais curtos. Se sua landing page realmente precisa de um formulário para fazer a captação de leads, procure deixá-lo simples e com os campos mais básicos como nome, e-mail e mensagem. Facilite a vida dos seus visitantes.

## 4 – Textos muito extensos

Se é uma coisa que aprendi em usabilidade, essa coisa é: Os textos servem para não serem lidos. Quantas vezes nos deparamos com páginas usando aqueles textos institucionais, chatos e enfadonhos, mas que na verdade sabemos que não quer dizer muita coisa e que não fariam falta se não estivessem ali?

Exceto em casos de blogs ou páginas que precisem de artigos, uma landing page não deve conter textos muito extensos. Isso deixará sua página chata e poderá entendiar o usuário. A verdade é que realmente não lemos os textos, mas damos uma leve “passada de olho” neles. Fazemos isso muito devido a falta de tempo, criando o hábito de mal ler os textos de uma revista ou jornal, mas sim identificar apenas o que for interessante para nós e acabamos ficando bons nisso.

Por isso, procure deixar os textos da sua landing page curtos e diretos. Uma boa dica que aprendi com Steve Krug, no livro “Não me Faça Pensar” é cortar pela metade o texto que você escreveu para sua landing page. A partir daí, você corta outra metade do texto e talvez assim você tenha um texto mais direto. Tenho certeza que muitas frases não farão a menor falta porque não eram importante. Deixe os títulos mais importantes em destaques e subtítulos em menor destaque e faça com que os textos realmente estejam lá por ser uma informação importante. Faça com que eles façam total sentido na página de forma fácil, objetiva e direta.

## 5 – Design sem distrações visuais

O design de uma landing page não deve existir apenas para deixar a página “bonita”. Ele existe para causar impacto e ajudar a sua marca a transmitir uma sensação positiva nos visitantes de seu site. Tendo isso em vista, o design da página deve ser conciso e objetivo. Quanto mais houver elementos que possam distrair o visitante, mais o lead irá se afastar e não concluir sua meta. Procure fazer com que o layout da sua landing page seja condizente com os elementos de imagem e vídeo. Crie uma unidade visual orientando o usuário a fazer o caminho da sua conversão e não deixe que nada atrapalhe esse caminho.

## 6 – Evite slides animados

Sabemos que os slides animados no topo de uma landing page podem deixar o funcionamento e transmissão do conteúdo das informações mais dinâmico. Bem, em alguns casos sim, mas na maioria dos casos, ou seja, em landing pages otimizadas para conversão eles podem atrapalhar a navegação do usuário e distraí-los da conversão. Sua landing page não precisa ser um parque de diversões e também não precisa estar na última moda da tecnologia. Ele precisa converter e para isso deve ser o mais enxuto possível. Não se preocupe com a simplicidade da sua página, é exatamente isso o que estamos procurando fazer: páginas extremamente simples de serem navegadas para que os usuários convertam sem dificuldades. Isso é otimizar conversão. Slides podem ser bonitos de ver, mas talvez isso te atrapalhe.

## 7 – Títulos claros e objetivo

Os títulos da sua landing page devem ser extremamente claros e objetivos. Procure escrevê-los usando sua principal palavra-chave e indicando ao usuário claramente do que se trata. Lembre-se que geralmente os seus visitantes podem chegar na sua landing page através do Google, seja [busca orgânica][5] ou paga, e por isso buscaram por determinada palavra-chave. Se o usuário buscou por “Smart TV 42 polegadas”, é fundamental que sua landing page trate apenas disso e que possua títulos chamativos sobre este assunto.s

## Conclusão

As técnicas de otimização de conversão obviamente não se resumem apenas em 7 dicas. Essas são consideradas as mais importantes e cada projeto possuem suas próprias estratégias e características. Mas a prática dessas otimizações resultam em aumento de conversão, o que em casos de e-commerce é aumento de receita. Estude e pratique otimização de conversão em suas landing pages. Como SEO, as técnicas não se restringem em receitas prontas, mas sim estratégias personalizadas para cada objetivo, seja uma venda de um produto ou geração de um lead através de um formulário.

 [1]: https://www.conversion.com.br/marketing-digital/ "marketing digital"
 [2]: https://www.conversion.com.br/otimizacao-de-sites-seo/ "SEO"
 [3]: https://www.conversion.com.br/uploads/2013/05/call-to-action.jpg?9d7bd4
 [4]: https://www.conversion.com.br/uploads/2013/05/muitas-escolhas.jpg?9d7bd4
 [5]: https://www.conversion.com.br/otimizacao-de-sites-seo/busca-organica/ "busca orgânica"