---
title: 3 patinhos foram passear. Por que? Quem eram eles?
authors: Bernard De Luna
type: post
date: 2013-09-09
excerpt: Usuários tomam decisões a todo momento, você precisa identificar os perfis de usuários, assim como seus objetivos e comportamentos antes de projetar sua interface, assim saberá criar um verdadeiro Design centrado no usuário.
url: /3-patinhos-passear-eram/
dsq_thread_id: 1718590056
categories:
  - Design
tags:
  - design
  - mvp
  - projetos

---
Algumas vezes se perde muito tempo falando das funcionalidades de um produto, os objetivos financeiros da empresa e o processo do serviço da empresa, e esquecem o mais importante, o que os usuários querem. Acredito que o desejo do usuário é tão importante no processo do Design que determinamos um capítulo só para ele.

Nesses anos de profissão, acredito que já tenha ouvido de tudo de clientes, desde alguns que nem tinham empresa até outros de multinacionais. A maioria dos casos são pensamentos confusos e fechados por parte dos clientes, porém muitas outras é uma postura egocêntrica ou arrogante do próprio designer. Ambas juntas somam uma verdadeira catástrofe para o projeto e para o usuário.

## Eu sei o que o usuário quer

Quando atuava como Team Leader de Front-end e Design na Petrobras, em quase todos os projetos quem tinha o contato de elaboração de projeto com o cliente eram os gerentes de projeto. Em muito dos casos, eles chegavam na nossa mesa com o sistema já definido e inclusive rabiscado no papel. Começamos então um trabalho, onde sempre um dos designers participa da primeira reunião para evitar esse tipo de engano, infelizmente a situação se tornou pior, pois o gerente de projeto acreditava que se estávamos na reunião, deveríamos elaborar o projeto e interfaces junto ao cliente e preparava o cliente para receber o mesmo nessa reunião.

A situação ficou bastante critica até eu criar uma das únicas regras que foram impostas no time, a proibição de qualquer designer tomar qualquer decisão sobre um projeto em qualquer reunião. Quando você não pode tomar decisão no momento, você acaba sendo obrigado a absorver ao máximo as reuniões e não dá margem para pular etapas sob pressão, como citado no capítulo anterior.

Muitas vezes o cliente acha que conhece o seu público porque ele faz as perguntas erradas. Já foi provado que se você perguntar para seus usuários se eles querem uma nova funcionalidade X, 90% deles dirão que sim. Existe uma frase criada pelo arquiteto de informação _Rudy Duke_ que diz que um bom designer pode não ter todas as respostas, mas ele sabe que perguntas devem ser feitas.

Entendo também que muitos Designers têm grande parcela de culpa no processo, por acreditarem saberem mais que o cliente e não ouvi-lo em reunião. Uma boa parceria com o cliente faz um projeto ser de grande satisfação e produção para os projetistas e um retorno maior ainda para o cliente. Vale lembrar que os projetistas de um site ou aplicativo não são apenas os designers, desenvolvedores são peças importantes na hora de discutir sobre o projeto com o cliente.

<blockquote class="big-blockquote">
  <p>
    O Startup DEV é um modelo de desenvolvimento de Software em que uma equipe entrega aplicativos web completamente funcionais após dois dias de trabalho. Antes do desenvolvimento, é feita uma reunião para a definição de um número restrito de funcionalidades suficientes para a resolução de um determinado problema do cliente. Isso é chamado de <strong>MVP &#8211; Minimum Viable Product</strong>.
  </p>
  
  <p>
    Uma das etapas utilizadas para a descoberta do MVP é o trabalho de prototipação colaborativa, que consiste em desenhos feitos por cada um dos presentes na reunião (integrantes da equipe e o cliente). Cada pessoa deve apresentar o seu desenho mostrando quais telas e funcionalidades o sistema deve ter. Nesse momento, é formada uma discussão para definição de quais são as melhores ideias e, assim, é feito um desenho final compilado a partir delas.
  </p>
  
  <p>
    Os desenhos visam primordialmente melhorar a comunicação e não necessariamente são determinantes para o design final dos projetos. Até pouco antes da publicação deste artigo, o Startup DEV já entregou mais de 30 projetos e teve 100% de satisfação. A equipe (Rafael Lima, Ramon Bispo, Sylvestre Mergulhão e o time HE:labs) acredita que a prototipagem em papel é parte fundamental desse sucesso.
  </p>
  
  <p>
    <b class="fake-blockquote-cite" style="text-align: right;font-size: .8em">Rafael Lima, Ramon Bispo e Sylvestre Mergulhão &#8211; StartupDEV</b>
  </p>
</blockquote>

A prototipação colaborativa foi o método mais eficiente que a Startup DEV encontrou para conseguir evitar refação e garantir o alinhamento das expectativas do seu cliente ao longo do projeto, e é uma das técnicas mais indicadas para trazer o cliente para o processo de criação, garantindo uma satisfação maior de todos os lados, pois se o cliente virar alvo da apresentação final, existe uma grande chance do projeto ser feito focado na aprovação e não na utilização do cliente final, onde todos sairão perdendo em qualidade, investimento e experiência.