---
title: 16 ferramentas para designers e desenvolvedores
authors: Dani Guerrato
type: post
date: 2013-05-06
excerpt: Sites, aplicativos, plugins, agregadores e portais que vão fazer toda a diferença na hora de aprender coisas novas, organizar seu dia-a-dia e encontrar inspiração.
url: /16-ferramentas-para-designers-e-desenvolvedores/
dsq_thread_id: 1246895553
categories:
  - Browsers
  - Digest
tags:
  - 2013
  - designers
  - devs
  - ferramentas

---
Sites, aplicativos, plugins, agregadores e portais que vão fazer toda a diferença na hora de aprender coisas novas, organizar seu dia-a-dia e encontrar inspiração.

## Aprender

**Microsoft Virtual Academy**

[<img class="alignnone size-full wp-image-37066" alt="mva" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/mva.jpg" width="660" height="342" srcset="uploads/2013/04/mva.jpg 660w, uploads/2013/04/mva-324x168.jpg 324w, uploads/2013/04/mva-588x304.jpg 588w, uploads/2013/04/mva-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][1]

Já falamos aqui no [Tableless][2] do excelente [Codeacademy][3] &#8211; um site que gamefica o processo de aprendizado na internet com níveis, badges e interação com redes sociais. O que pouca gente sabe é que a Microsoft possui um sistema parecido, o [Microsoft Virtual Academy][1]. O MVA possui diversos roteiros de estudo em português para temas como HTML5, certificações, segurança, desenvolvimento de aplicativos para Windows 8, etc. Cada roteiro completo vale um número de pontos que faz você subir no ranking de desenvolvedores do site, separados em categorias bronze, prata, ouro e platina. Dependendo da sua classificação no ranking você pode obter acesso a descontos e promoções. É possível ainda acompanhar os próximos eventos da empresa direcionados a desenvolvedores como o [Appday][4].

**Coursera**

[<img class="alignnone size-full wp-image-37067" alt="coursera" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/coursera.jpg" width="660" height="342" srcset="uploads/2013/04/coursera.jpg 660w, uploads/2013/04/coursera-324x168.jpg 324w, uploads/2013/04/coursera-588x304.jpg 588w, uploads/2013/04/coursera-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][5]
  
Que tal assistir a cursos completos em univerdades internacionais renomadas sem sair de casa? Esta é a proposta do [Coursera][5]. Através de video aulas e exercícios interativos você pode aprender os assuntos mais diversos nas áreas de humanas, biológicas e exatas! Até o momento são 341 cursos em 62 universidades diferentes. Pesquisando um pouco não é difícil achar assuntos super relevantes para desenvolvedores como [Learn to Program: The Fundamentals][6], [Human-Computer Interaction][7] e [Creative Programming for Digital Media and Mobile Apps][8]. Procurando por algo menos denso? Sem problemas, você pode estudar </a>[A história do rock][9] ou [O papel dos esportes na sociedade][10], por exemplo. São cursos para todos os gostos e formações. O único contra é que não existe material em português. Grande parte dos cursos está em inglês ou espanhol.

**CodePen**

[<img class="alignnone size-full wp-image-37068" alt="codepen" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/codepen.jpg" width="660" height="342" srcset="uploads/2013/04/codepen.jpg 660w, uploads/2013/04/codepen-324x168.jpg 324w, uploads/2013/04/codepen-588x304.jpg 588w, uploads/2013/04/codepen-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][11]
  
Algumas pessoas aprendem melhor na prática. Através do [CodePen][11] você pode criar, compartilhar e pesquisar exemplos de códigos. A premissa do CodePen é ser um [Dribbble][12] para desenvolvedores (sem a frescura de precisar de um convite). Os itens, ou &#8220;pens&#8221;, são basicamente divididos em dois painéis: um referente ao código e outro com os elementos renderizados ao vivo. Isto significa que você pode editar e copiar snippets e verificar as mudanças em tempo real. É possível ainda criar forks para as suas alterações / melhorias e compartilhar novamente com a comunidade. Você pode encontrar nos arquivos do CodePen todo tipo de coisa: animações, elementos de user interface e até pequenos jogos. Impossível não aprender algo novo. O editor do CodePen é bem bacana e suporta elementos como LASS, SASS e CoffeeScript. Como o foco é na comunidade todos os elementos criados são disponibilizados para o público. Mas existem planos PRO onde é possível postar códigos privados entre outras vantagens.

**Web Design Weekly**

[<img class="alignnone size-full wp-image-37069" alt="wdw" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/wdw.jpg" width="660" height="342" srcset="uploads/2013/04/wdw.jpg 660w, uploads/2013/04/wdw-324x168.jpg 324w, uploads/2013/04/wdw-588x304.jpg 588w, uploads/2013/04/wdw-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][13]
  
Quando você é um desenvolvedor é muito importante estar sempre atualizado. Novas tecnologias pipocam a todo instante e se você não tomar cuidado acaba virando um Infossauro. Mas as vezes encontrar as notícias relevantes é uma tarefa extenuante. O [Web Design Weekly][13] é uma curadoria de notícias sobre, bem, web design. Você recebe toda semana por e-mail uma newsletter com 5 notícias fresquinhas e relevantes. Super prático. Você também pode optar por ler as notícias através do site. Quer notícias diárias? O [Sidebar.io][14] também tem um conteúdo bacana.

**Method & Craft**

[<img class="alignnone size-full wp-image-37071" alt="method-and-craft" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/method-and-craft.jpg" width="660" height="342" srcset="uploads/2013/04/method-and-craft.jpg 660w, uploads/2013/04/method-and-craft-324x168.jpg 324w, uploads/2013/04/method-and-craft-588x304.jpg 588w, uploads/2013/04/method-and-craft-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][15]
  
O [Method & Craft][15] é um site de artigos, vídeos e artigos sobre design e desenvolvimento web. O diferencial é que a abordagem é mais &#8220;por trás das cenas&#8221;, mostrando os bastidores por trás da criação de cada projeto. É possível assim conferir de perto o fluxo de trabalho e entender melhor os processos de design e as dicas pessoais de cada profissional..

**Fórum do Tableless**

[<img class="alignnone size-full wp-image-37072" alt="tableless-forum" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/tableless-forum.jpg" width="660" height="342" srcset="uploads/2013/04/tableless-forum.jpg 660w, uploads/2013/04/tableless-forum-324x168.jpg 324w, uploads/2013/04/tableless-forum-588x304.jpg 588w, uploads/2013/04/tableless-forum-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][16]
  
Muita gente não conhece, mas existe um espaço muito bacana aqui mesmo no Tableless para você interagir, perguntar e dividir conhecimento sobre web standarts. No Fórum do [Tableless][17] você vai encontrar discussões sobre HTML, CSS, Javascript, AJAX, jQuery, Mobile&#8230; Vale uma visitinha.

## Organizar

Quando iniciei minha carreira como Freelancer (e posteriormente abri minha própria empresa) eu ficava perdida com a quantidade de tarefas, reuniões, projetos, etc. O mais difícil foi conciliar as funções que eu já exercia como designer / desenvolvedora com as novas responsabilidades de administração, controle financeiro, atendimento ao cliente&#8230; Estas foram as ferramentas que me ajudaram organizar minha vida.

**Wunderlist**

[<img class="alignnone size-full wp-image-37073" alt="wunderlist" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/wunderlist.jpg" width="660" height="342" srcset="uploads/2013/04/wunderlist.jpg 660w, uploads/2013/04/wunderlist-324x168.jpg 324w, uploads/2013/04/wunderlist-588x304.jpg 588w, uploads/2013/04/wunderlist-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][18]
  
A maneira mais fácil de completar um projeto é dividi-lo em estapas menores. Basicamente crio uma lista para cada cliente / projeto onde incluo todas as tarefas pendentes que incluem coisas como enviar um e-mail, fechar um arquivo, desenvolver um layout&#8230; Anoto todas as tarefas e desta maneira fica muito mais fácil delegar funções e estabelecer prazos. Por isto sou uma fanática por listas e gerenciadores de tarefa. Já testei diversos serviços, mas o meu queridinho é o [Wunderlist][19]. A interface é bacana, você consegue compartilhar as tarefas com sua equipe, receber notificações de prazos e o melhor existem versões para [Mac][20], [Windows][21], [iPhone][22], [iPad][22], [Android][23]&#8230; Tudo gratuito e sincronizado. A extensão para [Google Chrome][24] também ajuda na hora de salvar tarefas diretamente da caixa de entrada do Gmail ou da Wikipedia, por exemplo.

**Organizze**

[<img class="alignnone size-full wp-image-37074" alt="organizze" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/organizze.jpg" width="660" height="342" srcset="uploads/2013/04/organizze.jpg 660w, uploads/2013/04/organizze-324x168.jpg 324w, uploads/2013/04/organizze-588x304.jpg 588w, uploads/2013/04/organizze-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][25]
  
A lição básica para conseguir juntar dinheiro é bem simples: gaste menos do que você ganha. Mas as vezes é complicado saber onde exatamente você está gastando. Minha alterativa anterior eram planilhas de dados, as famosas tabelas de Excel. Vou ser sincera com vocês. Eu odeio malditas tabelas. Elas são feias, desajeitadas e são bem complicadinhas para controlar orçamentos. Este gerenciador financeiro brasileiro quebra um galho na hora de organizar o fluxo de caixa tanto pessoal quanto empresarial de maneira simples, rápida e descomplicada. Com o [Organizze][26] você consegue adicionar despesas (e recebimentos) como tarefas. Assim você sempre sabe quando você vai receber ou quando você precisa pagar a próxima conta. E acompanhar dia-a-dia suas despesas e lucros. Pagou a conta? Recebeu dinheiro? Basta clicar no polegar para cima. É possível configurar lançamentos individuais, parcelados ou recorrentes. Você consegue ver todos os gastos divididos por categorias em gráficos e relatórios bonitinhos para saber exatamente para onde seu dinheiro está indo. Desta maneira é muito mais simples saber exatamente quanto você tem.
  
O Organizze possui uma versão básica gratuita (muito boa), e uma paga com diversas funções extras úteis como gerenciamento de clientes e projetos.

**Snippi**

[<img class="alignnone size-full wp-image-37075" alt="snippi" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/snippi.jpg" width="660" height="342" srcset="uploads/2013/04/snippi.jpg 660w, uploads/2013/04/snippi-324x168.jpg 324w, uploads/2013/04/snippi-588x304.jpg 588w, uploads/2013/04/snippi-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][27]
  
Na hora de escrever códigos sempre acabamos perdendo um tempo grande fazendo as mesmas coisas repetidamente como campos de formulário, por exemplo. Alguns pedaços de código poderiam facilmente ser re-aproveitados em novos projetos. Ou você escreveu algo genial que te deixou super orgulhoso apenas para perder um tempão tentando encontrar aquele pedacinho de código no meio de tantos outros? O [Snippi][27] é para estas horas. Trata-se basicamente um webapp que te deixa salvar pedaços de código e organiza-los por tags. Escreva HTML, CSS, Javascript, PHP, Ruby, SQL ou XML que ele gera um mark-up organizadinho. Basta colar, comentar e compartilhar já que cada Snippet possui uma URL fixa (Ou manter escondido a sete chaves &#8211; é o seu código. Faça o que quiser com ele. ). É possível ainda definir uma data de expiração de 10 minutos até, bem&#8230; nunca! Super útil para criar sua própria biblioteca de recursos.

**Kippt**

[<img class="alignnone size-full wp-image-37076" alt="kippt" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/kippt.jpg" width="660" height="342" srcset="uploads/2013/04/kippt.jpg 660w, uploads/2013/04/kippt-324x168.jpg 324w, uploads/2013/04/kippt-588x304.jpg 588w, uploads/2013/04/kippt-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][28]
  
A internet é um lugar muito, mas muito grande. Diariamente nos deparamos com coisas interessantes e é difícil salvar (e organizar) todos os links legais. Já testei diversos gerenciadores como o Delicious, Zootools e até mesmo os velhos favoritos do browser sem encontrar em nenhuma deles uma maneira fácil, rápida e confiável de organizar coleções de links. Tenho tanta coisa arquivada que buscar por um artigo específico tomava muito tempo. Até eu conhecer o [Kippt][29].
  
Este Webapp gratuito possui diversas funções legais para criar sua biblioteca de links como thumbnails automáticas, separação por grupos, tag, busca, possibilidade de incluir notas (com mark-up de títulos, parágrafos, listas e a possibilidade de adição de imagens). Perfeito para organizar textos, vídeos e fotos internet a fora. O Kippt possui ainda funções de redes sociais e ferramentas que facilitam a importação / sincronização de links de outros serviços como o Pocket, por exemplo. Além de extenções para browsers para agilizar o processo. E o visual é super bonito.

**Pixel Dropr**

[<img class="alignnone size-full wp-image-37077" alt="pixeldropr" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/pixeldropr.jpg" width="660" height="342" srcset="uploads/2013/04/pixeldropr.jpg 660w, uploads/2013/04/pixeldropr-324x168.jpg 324w, uploads/2013/04/pixeldropr-588x304.jpg 588w, uploads/2013/04/pixeldropr-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][30]
  
O [Pixel Dropr][30] é uma extensão de Photoshop super útil. Através dele você pode criar coleções de arquivos (chamadas Refills) e organiza-los dentro do próprio Photoshop. Vamos supor que você sempre re-utiliza um conjunto de ícones de métodos de pagamento, por exemplo. Ao invés de perder tempo pesquisando no seu computador e importando os arquivos um-por-um a cada projeto você pode simplesmente clicar e arrastar da aba da extensão. Desta forma organizar ícones, botões, fotos, kits de user interface, etc fica muito mais prático e rápido. Existe ainda uma [lojinha][31] de elementos dentro do próprio aplicativo onde você pode baixar refills gratuitos e pagos. A extensão é de graça para utilizar, mas se você quiser criar seus próprios refills é necessário desembolsar 19 doláres. Um valor justo considerando o tempo que você economiza&#8230;

**Feedly**

[<img class="alignnone size-full wp-image-37079" alt="feedly" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/feedly.jpg" width="660" height="342" srcset="uploads/2013/04/feedly.jpg 660w, uploads/2013/04/feedly-324x168.jpg 324w, uploads/2013/04/feedly-588x304.jpg 588w, uploads/2013/04/feedly-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][32]
  
Sigo uma quantidade imensa de blogs, sites e portais e ficar entrando em um por um diariamente em busca de atualizações é simplesmente inviável. Por isto sempre gostei muito de Feeds RSS. Com o recente anúncio do fim do Google Reader muitas pessoas ficaram orfãs do serviço. Uma alternativa bacana é o Feedly. As notícias são organizadas em um grid super clean com textos e imagens em uma diagramação bacana. O Feedly é totalmente gratuito e pode ser lido no browser, no [iOS][33], [Android][34] ou [Kindle][35]. O serviço ainda permite a importação de toda a bibilioteca do Google.

## Inpiração

**Niice**

[<img class="alignnone size-full wp-image-37080" alt="niice" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/niice.jpg" width="660" height="342" srcset="uploads/2013/04/niice.jpg 660w, uploads/2013/04/niice-324x168.jpg 324w, uploads/2013/04/niice-588x304.jpg 588w, uploads/2013/04/niice-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][36]
  
Encontrar inspiração na internet sempre significou garimpar o Google atrás de projetos gráficos bacanas. O [Niice][36] agrega o conteúdo do Behance, Dribbble,Designspiration e Fubiz para facilitar o trabalho. Basta digitar o tema desejado no campo de busca para visualizar centenas de imagens sobre o tema escolhido. Dá para perder horas navegando&#8230;

**PLTTS**

[<img class="alignnone size-full wp-image-37085" alt="PLTTS" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/PLTTS.jpg" width="660" height="342" srcset="uploads/2013/04/PLTTS.jpg 660w, uploads/2013/04/PLTTS-324x168.jpg 324w, uploads/2013/04/PLTTS-588x304.jpg 588w, uploads/2013/04/PLTTS-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][37]
  
Sempre gostei de pesquisar por paletas de cores diferentes. O [PLTTS][37] é uma ferramenta super prática para isto. Basta digitar um código HEX para visualizar diversos esquemas de cores criados pelos usuários. Você pode salvar criar, colecionar e pesquisar diversas paletas. Uma alternativa parecida é o &#8211; old but gold &#8211; [Colour Lovers][38].

**Little Big Details**

[<img class="alignnone size-full wp-image-37081" alt="littlebigdetails" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/littlebigdetails.jpg" width="660" height="342" srcset="uploads/2013/04/littlebigdetails.jpg 660w, uploads/2013/04/littlebigdetails-324x168.jpg 324w, uploads/2013/04/littlebigdetails-588x304.jpg 588w, uploads/2013/04/littlebigdetails-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][39]
  
São os pequenos detalhes que fazem toda a diferença. Não acredita? O tumblr [Little Big Details][39] coleciona diversas screenshots de interfaces com idéias simples mas que acabam de alguma forma facilitando a vida, cativando, surpreendendo ou simplesmente divertindo o usuário.

**Ideeeas**

[<img class="alignnone size-full wp-image-37082" alt="ideeeas" src="https://raw.githubusercontent.com/diegoeis/tableless-static-images/master/2013/04/ideeeas.jpg" width="660" height="342" srcset="uploads/2013/04/ideeeas.jpg 660w, uploads/2013/04/ideeeas-324x168.jpg 324w, uploads/2013/04/ideeeas-588x304.jpg 588w, uploads/2013/04/ideeeas-598x310.jpg 598w" sizes="(max-width: 660px) 100vw, 660px" />][40]
  
Para fazer uma idéia tornar-se realidade é necessário saber explica-la de maneira simples e objetiva. Que tal duas imagens e um tweet? Este é o espaço que você tem no [ideeeas][40] um catálogo virtual de idéias (de todos os tipos) a procura de pessoas dispostas a coloca-las em prática. Precisa de um conceito para um projeto? Este pode ser um bom ponto de partida.

## E vocês?

Quais ferramentas recomendariam para outros designers e desenvolvedores? Qual é o aplicativo fundamental para o fuxo de trabalho? Deixem suas sugestões nos comentários. Até a próxima! 🙂

 [1]: https://www.microsoftvirtualacademy.com/
 [2]: https://tableless.com.br/aprenda-a-programar-javascript-no-codecademy
 [3]: https://www.codecademy.com/
 [4]: https://www.microsoft.com/brasil/apps/appday.html
 [5]: https://www.coursera.org/
 [6]: https://www.coursera.org/course/programming1
 [7]: https://www.coursera.org/course/hci
 [8]: https://www.coursera.org/course/digitalmedia
 [9]: https://www.coursera.org/course/historyofrock1
 [10]: https://www.coursera.org/course/sports
 [11]: https://codepen.io/
 [12]: https://dribbble.com/
 [13]: https://web-design-weekly.com/
 [14]: https://sidebar.io/
 [15]: https://methodandcraft.com/
 [16]: https://tableless.com.br/forum/?utm_source=tableless&utm_medium=link&utm_campaign=linkAtalho
 [17]: https://tableless.com.br/forum/
 [18]: https://www.wunderlist.com/#/login
 [19]: https://www.wunderlist.com/
 [20]: https://appstore.com/mac/Wunderlist
 [21]: https://windows.wunderlist.com/download/
 [22]: https://www.appstore.com/Wunderlist
 [23]: https://play.google.com/store/apps/details?id=com.wunderkinder.wunderlistandroid
 [24]: https://chrome.google.com/webstore/detail/wunderlist/dmnddeddcgdllibmaodanoonljfdmooc
 [25]: https://www.organizze.com.br/
 [26]: https://www.organizze.com.br
 [27]: https://snippi.com/
 [28]: https://kippt.com/inbox
 [29]: https://kippt.com/
 [30]: https://www.pixeldropr.com/
 [31]: https://refillstore.io/
 [32]: https://www.feedly.com/home
 [33]: https://www.feedly.com/k/feedly-iphone
 [34]: https://play.google.com/store/apps/details?id=com.devhd.feedly
 [35]: https://www.feedly.com/k/feedly_amazon_homelink
 [36]: https://www.niice.co/
 [37]: https://pltts.me/
 [38]: https://www.colourlovers.com/
 [39]: https://littlebigdetails.com/
 [40]: https://ideeeas.com/