---
title: Sobre o Tableless
excerpt: O Tableless é um site sobre desenvolvimento para web. Começamos falando sobre desenvolvimento front-end, mas hoje o site fala sobre design, ux, back-end, mercado e outros assuntos.
author: Diego Eis
type: page
date: 2016-04-09
---


<p>
  Este site foi criado com um único intuito: compartilhar os padrões web e no Brasil. Por volta de 2003, os Padrões Web estavam se popularizando no mundo todo. Aqui no Brasil já existia algumas listas de discussão (sim, aquelas antigas listas de discussão que funcionavam exclusivamente por e-email) que comentavam sobre o assunto, mas pouco conteúdo era publicado na web brasileira. Até que resolvi (Diego Eis) criar um site onde eu pudesse divulgar não só o que eu estava aprendendo na época (CSS, HTML e JS), mas também tudo sobre o status dos Padrões Web e as boas práticas de front-end usando as recomendações do W3C.
</p>
<p>
  O Tableless começou a ficar bastante visitado quando comecei a publicar uma série de estudos, onde eu e um monte de pessoas da comunidade começamos a publicar websites que usavam tabelas para sua estruturação, transformando-os com apenas CSS e HTML semântico. Você pode <a href="http://tableless.com.br/convertidos/">ver alguns desses sites aqui</a>. Essa seção do site ficou conhecida como <b>Convertidos do Tableless</b>.
</p>
  
<h2>Quem mantém o Tableless?</h2>
<p>
  O <a href="http://diegoeis.com">Diego Eis</a> é o fundador do site desde o início. Mas durante todo o caminho ele obteve ajuda de toda a comunidade, seja com autores voluntários (ou pagos) escrevendo artigos ou editores voluntários avaliando e fazendo a curadoria dos artigos.
</p>
<p>
  Aproveitando para agradecer a todos os voluntários que de alguma forma, até aqui, ajudaram o site de alguma forma, seja curando conteúdo, escrevendo ou fazendo o design do site. Sem vocês, com certeza o trabalho seria muito mais difícil.
</p>
  
<h2>Editores</h2>
<p>
  Estes são os editores do Tableless, responsáveis por fazer a curadoria dos artigos, edição e revisão:
</p>

<div class="tb-editors">
  <div class="tb-editor-bio">
      <img src="images/danilo.jpg" class="tb-editor-avatar">
      <h3>Danilo Vitoriano</h3>
      <p>
        <a href="https://twitter.com/dnvtrn">Danilo</a> é desenvolvedor na @InternetGroup, ajuda no <a href="https://github.com/abc-dev">@abc-dev</a> and <a href="https://github.com/react-brasil">React Brasil</a>. Fundador do <a href="https://github.com/fullcirclebr">Fullcirclebr</a>.
      </p>
  </div>

  <div class="tb-editor-bio">
      <img src="images/ricardo.jpg" class="tb-editor-avatar">
      <h3>Ricardo Yasuda</h3>
      <p>
        Ricardo (ou <a href="https://twitter.com/shadowmaru">Shadowmaru</a>) é desenvolvedor focado em aplicações web usando Ruby, Rails, JavaScript, HTML e CSS. Tem experiência em vários métodos ágeis.
      </p>
  </div>

  <div class="tb-editor-bio">
      <img src="images/tailo.jpg" class="tb-editor-avatar">
      <h3>Tailo Mateus</h3>
      <p>
        <a href="http://github.com/TailoMateus">Programador web</a>, leitor assíduo, escritor nas horas vagas e editor no site <a href="http://tableless.com.br">Tableless</a>!
      </p>
  </div>

</div>


<h2>Como você pode nos acomapanhar?</h2>
<p>
  Além do site, nós mantemos uma série de canais para que você acompanhe nosso conteúdo: <a href="http://forum.tableless.com.br/">Fórum</a>, <a href="http://twitter.com/tableless">Twitter</a>, <a href="http://facebook.com/tablelessbr">Facebook</a>, <a href="http://medium.com/tableless">Medium</a>, <a href="https://telegram.me/tableless">Telegram</a>.
</p>
  


<h2>Por que o site chama Tableless?</h2>

<p>
  O nome <b>Tableless</b> é um nome bastante polêmico, mas que marca bem a fase na época: os Padrões Web começaram a crescer porque muitos desenvolvedores passaram a não utilizar tabelas na estruturação de web sites. Você pode não saber, mas há muito tempo atrás, usávamos os elementos table, tr, td, tbody, thead e etc para estruturamos os sites e produtos.

</p>
<p>
  Como você sabe, uma boa prática é manter o código semântico, usar cada tag para sua função específica. Tabelas servem para exibir dados tabulados, não para fazer estruturas de layouts. Para se referir à estes novos websites, que não usavam tabelas para sua estrutura, demos o nome de sites "tableless". Lá fora o termo que pegou foram CSS Layouts.
</p>
<p>
  Todo mundo já sabe que dizer que um site é <a href="http://tableless.com.br/web-standards-vs-tableless">tableless</a> não significa que ele seja feito de acordo com os Padrões. Por isso o nome Tableless já saiu de moda e não quer dizer muita coisa atualmente.
</p>
<p>
  Hoje este site não trata apenas de técnicas e tutoriais de CSS e HTML, que faziam muito sentido naquela época, mas ampliamos o foco falando sobre o mercado de desenvolvimento web como um todo, envolvendo os assuntos que estão relacionados à este processo, não incluindo apenas front-end, mas também back-end e design.
</p>

<h2>Nossa missão</h2>
<p>
  A missão do Tableless é sem dúvida melhorar o mercado de desenvolvimento web compartilhando conhecimento por meio do site e outros canais. Queremos servir de fonte de inspiração e informação aos profissionais da área e cativar novatos a continuarem estudando, consumindo conteúdo de outros profissionais e principalmente, quando chegar a hora, compartilhar o que aprenderam.
</p>


<!--
<h3>Uma pequena história em vídeo</h3>
<object width="500" height="405"><param name="movie" value="http://www.youtube.com/v/SX5bCCtHYXo&hl=pt-br&fs=1&rel=0&color1=0x3a3a3a&color2=0x999999&border=1"></param><param name="allowFullScreen" value="true"></param><param name="allowscriptaccess" value="always"></param><embed src="http://www.youtube.com/v/SX5bCCtHYXo&hl=pt-br&fs=1&rel=0&color1=0x3a3a3a&color2=0x999999&border=1" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" width="500" height="405"></embed></object>-->

