#!/usr/bin/env bash

set -u

readonly SHECC="$PWD/out/shecc"

function update_snapshot() {
    local source="$1"
    local dest="tests/snapshots/$(basename $source .c).json"
    local temp_exe=$(mktemp)
    local temp_json=$(mktemp --suffix .json)

    $SHECC --dump-ir -o $temp_exe $source &>/dev/null
    dot -Tdot_json -o $temp_json CFG.dot
    sed -i -E "/0x[0-9a-f]+/d" $temp_json
    jq -S -c '.edges |= sort_by(._gvid) | .objects |= sort_by(._gvid) |
                .objects |= map_values(.edges |= (. // [] | sort)) |
                .objects |= map_values(.nodes |= (. // [] | sort)) |
                .objects |= map_values(.subgraphs |= (. // [] | sort))' $temp_json > $dest
}

for file in tests/*.c; do
    update_snapshot "$file"
done
