//---------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: D2D1.h
//---------------------------------------------------------------------------
#ifdef _MSC_VER
#pragma once
#endif // #ifdef _MSC_VER

#ifndef _D2D1_H_
#define _D2D1_H_

#ifndef COM_NO_WINDOWS_H
#include <windows.h>
#endif // #ifndef COM_NO_WINDOWS_H
#include <unknwn.h>
#include <dcommon.h>
#include <D2DErr.h>
#include <D2DBaseTypes.h>
#include <dxgiformat.h>
#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)
#include <d3d10_1.h>
#else
#include <d3dcommon.h>
#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */

#ifndef D2D_USE_C_DEFINITIONS

//
// We use the 'C' definitions if C++ is not defined
//
#ifndef __cplusplus
#define D2D_USE_C_DEFINITIONS
#endif

#endif // #ifndef D2D_USE_C_DEFINITIONS

#include <winapifamily.h>

//
// Forward declarations here
//

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

typedef interface IDWriteTextFormat IDWriteTextFormat;
typedef interface IDWriteTextLayout IDWriteTextLayout;
typedef interface IDWriteRenderingParams IDWriteRenderingParams;
typedef interface IDXGISurface IDXGISurface;
typedef interface IWICBitmap IWICBitmap;
typedef interface IWICBitmapSource IWICBitmapSource;

typedef struct DWRITE_GLYPH_RUN DWRITE_GLYPH_RUN;

#ifndef D2D_USE_C_DEFINITIONS

interface ID2D1Factory;
interface ID2D1RenderTarget;
interface ID2D1BitmapRenderTarget;
interface ID2D1SimplifiedGeometrySink;
interface ID2D1TessellationSink;
interface ID2D1Geometry;
interface ID2D1Brush;

#else

typedef interface ID2D1Factory ID2D1Factory;
typedef interface ID2D1RenderTarget ID2D1RenderTarget;
typedef interface ID2D1BitmapRenderTarget ID2D1BitmapRenderTarget;
typedef interface ID2D1SimplifiedGeometrySink ID2D1SimplifiedGeometrySink;;
typedef interface ID2D1TessellationSink ID2D1TessellationSink;
typedef interface ID2D1Geometry ID2D1Geometry;
typedef interface ID2D1Brush ID2D1Brush;

#endif
        
#define D2D1_INVALID_TAG ULONGLONG_MAX
#define D2D1_DEFAULT_FLATTENING_TOLERANCE (0.25f)


/// <summary>
/// This defines the superset of interpolation mode supported by D2D APIs
/// and built-in effects
/// </summary>
enum 
{
    D2D1_INTERPOLATION_MODE_DEFINITION_NEAREST_NEIGHBOR = 0,
    D2D1_INTERPOLATION_MODE_DEFINITION_LINEAR = 1,
    D2D1_INTERPOLATION_MODE_DEFINITION_CUBIC = 2,
    D2D1_INTERPOLATION_MODE_DEFINITION_MULTI_SAMPLE_LINEAR = 3,
    D2D1_INTERPOLATION_MODE_DEFINITION_ANISOTROPIC = 4,
    D2D1_INTERPOLATION_MODE_DEFINITION_HIGH_QUALITY_CUBIC = 5,
    D2D1_INTERPOLATION_MODE_DEFINITION_FANT = 6,
    D2D1_INTERPOLATION_MODE_DEFINITION_MIPMAP_LINEAR = 7

};


/// <summary>
/// This determines what gamma is used for interpolation/blending.
/// </summary>
typedef enum D2D1_GAMMA
{
    
    /// <summary>
    /// Colors are manipulated in 2.2 gamma color space.
    /// </summary>
    D2D1_GAMMA_2_2 = 0,
    
    /// <summary>
    /// Colors are manipulated in 1.0 gamma color space.
    /// </summary>
    D2D1_GAMMA_1_0 = 1,
    D2D1_GAMMA_FORCE_DWORD = 0xffffffff

} D2D1_GAMMA;


/// <summary>
/// Specifies what the contents are of an opacity mask.
/// </summary>
typedef enum D2D1_OPACITY_MASK_CONTENT
{
    
    /// <summary>
    /// The mask contains geometries or bitmaps.
    /// </summary>
    D2D1_OPACITY_MASK_CONTENT_GRAPHICS = 0,
    
    /// <summary>
    /// The mask contains text rendered using one of the natural text modes.
    /// </summary>
    D2D1_OPACITY_MASK_CONTENT_TEXT_NATURAL = 1,
    
    /// <summary>
    /// The mask contains text rendered using one of the GDI compatible text modes.
    /// </summary>
    D2D1_OPACITY_MASK_CONTENT_TEXT_GDI_COMPATIBLE = 2,
    D2D1_OPACITY_MASK_CONTENT_FORCE_DWORD = 0xffffffff

} D2D1_OPACITY_MASK_CONTENT;


/// <summary>
/// Enum which describes how to sample from a source outside its base tile.
/// </summary>
typedef enum D2D1_EXTEND_MODE
{
    
    /// <summary>
    /// Extend the edges of the source out by clamping sample points outside the source
    /// to the edges.
    /// </summary>
    D2D1_EXTEND_MODE_CLAMP = 0,
    
    /// <summary>
    /// The base tile is drawn untransformed and the remainder are filled by repeating
    /// the base tile.
    /// </summary>
    D2D1_EXTEND_MODE_WRAP = 1,
    
    /// <summary>
    /// The same as wrap, but alternate tiles are flipped  The base tile is drawn
    /// untransformed.
    /// </summary>
    D2D1_EXTEND_MODE_MIRROR = 2,
    D2D1_EXTEND_MODE_FORCE_DWORD = 0xffffffff

} D2D1_EXTEND_MODE;


/// <summary>
/// Enum which describes the manner in which we render edges of non-text primitives.
/// </summary>
typedef enum D2D1_ANTIALIAS_MODE
{
    
    /// <summary>
    /// The edges of each primitive are antialiased sequentially.
    /// </summary>
    D2D1_ANTIALIAS_MODE_PER_PRIMITIVE = 0,
    
    /// <summary>
    /// Each pixel is rendered if its pixel center is contained by the geometry.
    /// </summary>
    D2D1_ANTIALIAS_MODE_ALIASED = 1,
    D2D1_ANTIALIAS_MODE_FORCE_DWORD = 0xffffffff

} D2D1_ANTIALIAS_MODE;


/// <summary>
/// Describes the antialiasing mode used for drawing text.
/// </summary>
typedef enum D2D1_TEXT_ANTIALIAS_MODE
{
    
    /// <summary>
    /// Render text using the current system setting.
    /// </summary>
    D2D1_TEXT_ANTIALIAS_MODE_DEFAULT = 0,
    
    /// <summary>
    /// Render text using ClearType.
    /// </summary>
    D2D1_TEXT_ANTIALIAS_MODE_CLEARTYPE = 1,
    
    /// <summary>
    /// Render text using gray-scale.
    /// </summary>
    D2D1_TEXT_ANTIALIAS_MODE_GRAYSCALE = 2,
    
    /// <summary>
    /// Render text aliased.
    /// </summary>
    D2D1_TEXT_ANTIALIAS_MODE_ALIASED = 3,
    D2D1_TEXT_ANTIALIAS_MODE_FORCE_DWORD = 0xffffffff

} D2D1_TEXT_ANTIALIAS_MODE;


/// <summary>
/// Specifies the algorithm that is used when images are scaled or rotated. Note
/// Starting in Windows 8, more interpolations modes are available. See
/// D2D1_INTERPOLATION_MODE for more info.
/// </summary>
typedef enum D2D1_BITMAP_INTERPOLATION_MODE
{
    
    /// <summary>
    /// Nearest Neighbor filtering. Also known as nearest pixel or nearest point
    /// sampling.
    /// </summary>
    D2D1_BITMAP_INTERPOLATION_MODE_NEAREST_NEIGHBOR = D2D1_INTERPOLATION_MODE_DEFINITION_NEAREST_NEIGHBOR,
    
    /// <summary>
    /// Linear filtering.
    /// </summary>
    D2D1_BITMAP_INTERPOLATION_MODE_LINEAR = D2D1_INTERPOLATION_MODE_DEFINITION_LINEAR,
    D2D1_BITMAP_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff

} D2D1_BITMAP_INTERPOLATION_MODE;


/// <summary>
/// Modifications made to the draw text call that influence how the text is
/// rendered.
/// </summary>
typedef enum D2D1_DRAW_TEXT_OPTIONS
{
    
    /// <summary>
    /// Do not snap the baseline of the text vertically.
    /// </summary>
    D2D1_DRAW_TEXT_OPTIONS_NO_SNAP = 0x00000001,
    
    /// <summary>
    /// Clip the text to the content bounds.
    /// </summary>
    D2D1_DRAW_TEXT_OPTIONS_CLIP = 0x00000002,
    
    /// <summary>
    /// Render color versions of glyphs if defined by the font.
    /// </summary>
    D2D1_DRAW_TEXT_OPTIONS_ENABLE_COLOR_FONT = 0x00000004,
    
    /// <summary>
    /// Bitmap origins of color glyph bitmaps are not snapped.
    /// </summary>
    D2D1_DRAW_TEXT_OPTIONS_DISABLE_COLOR_BITMAP_SNAPPING = 0x00000008,
    D2D1_DRAW_TEXT_OPTIONS_NONE = 0x00000000,
    D2D1_DRAW_TEXT_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_DRAW_TEXT_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_DRAW_TEXT_OPTIONS);

typedef D2D_POINT_2U D2D1_POINT_2U;
typedef D2D_POINT_2F D2D1_POINT_2F;
typedef D2D_RECT_F D2D1_RECT_F;
typedef D2D_RECT_U D2D1_RECT_U;
typedef D2D_SIZE_F D2D1_SIZE_F;
typedef D2D_SIZE_U D2D1_SIZE_U;
typedef D2D_COLOR_F D2D1_COLOR_F;
typedef D2D_MATRIX_3X2_F D2D1_MATRIX_3X2_F;
typedef UINT64 D2D1_TAG;

/// <summary>
/// Describes the pixel format and dpi of a bitmap.
/// </summary>
typedef struct D2D1_BITMAP_PROPERTIES
{
    D2D1_PIXEL_FORMAT pixelFormat;
    FLOAT dpiX;
    FLOAT dpiY;

} D2D1_BITMAP_PROPERTIES;


/// <summary>
/// Contains the position and color of a gradient stop.
/// </summary>
typedef struct D2D1_GRADIENT_STOP
{
    FLOAT position;
    D2D1_COLOR_F color;

} D2D1_GRADIENT_STOP;


/// <summary>
/// Describes the opacity and transformation of a brush.
/// </summary>
typedef struct D2D1_BRUSH_PROPERTIES
{
    FLOAT opacity;
    D2D1_MATRIX_3X2_F transform;

} D2D1_BRUSH_PROPERTIES;


/// <summary>
/// Describes the extend modes and the interpolation mode of an ID2D1BitmapBrush.
/// </summary>
typedef struct D2D1_BITMAP_BRUSH_PROPERTIES
{
    D2D1_EXTEND_MODE extendModeX;
    D2D1_EXTEND_MODE extendModeY;
    D2D1_BITMAP_INTERPOLATION_MODE interpolationMode;

} D2D1_BITMAP_BRUSH_PROPERTIES;


/// <summary>
/// Contains the starting point and endpoint of the gradient axis for an
/// ID2D1LinearGradientBrush.
/// </summary>
typedef struct D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES
{
    D2D1_POINT_2F startPoint;
    D2D1_POINT_2F endPoint;

} D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES;


/// <summary>
/// Contains the gradient origin offset and the size and position of the gradient
/// ellipse for an ID2D1RadialGradientBrush.
/// </summary>
typedef struct D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES
{
    D2D1_POINT_2F center;
    D2D1_POINT_2F gradientOriginOffset;
    FLOAT radiusX;
    FLOAT radiusY;

} D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES;


/// <summary>
/// Differentiates which of the two possible arcs could match the given arc
/// parameters.
/// </summary>
typedef enum D2D1_ARC_SIZE
{
    D2D1_ARC_SIZE_SMALL = 0,
    D2D1_ARC_SIZE_LARGE = 1,
    D2D1_ARC_SIZE_FORCE_DWORD = 0xffffffff

} D2D1_ARC_SIZE;


/// <summary>
/// Enum which describes the drawing of the ends of a line.
/// </summary>
typedef enum D2D1_CAP_STYLE
{
    
    /// <summary>
    /// Flat line cap.
    /// </summary>
    D2D1_CAP_STYLE_FLAT = 0,
    
    /// <summary>
    /// Square line cap.
    /// </summary>
    D2D1_CAP_STYLE_SQUARE = 1,
    
    /// <summary>
    /// Round line cap.
    /// </summary>
    D2D1_CAP_STYLE_ROUND = 2,
    
    /// <summary>
    /// Triangle line cap.
    /// </summary>
    D2D1_CAP_STYLE_TRIANGLE = 3,
    D2D1_CAP_STYLE_FORCE_DWORD = 0xffffffff

} D2D1_CAP_STYLE;


/// <summary>
/// Describes the sequence of dashes and gaps in a stroke.
/// </summary>
typedef enum D2D1_DASH_STYLE
{
    D2D1_DASH_STYLE_SOLID = 0,
    D2D1_DASH_STYLE_DASH = 1,
    D2D1_DASH_STYLE_DOT = 2,
    D2D1_DASH_STYLE_DASH_DOT = 3,
    D2D1_DASH_STYLE_DASH_DOT_DOT = 4,
    D2D1_DASH_STYLE_CUSTOM = 5,
    D2D1_DASH_STYLE_FORCE_DWORD = 0xffffffff

} D2D1_DASH_STYLE;


/// <summary>
/// Enum which describes the drawing of the corners on the line.
/// </summary>
typedef enum D2D1_LINE_JOIN
{
    
    /// <summary>
    /// Miter join.
    /// </summary>
    D2D1_LINE_JOIN_MITER = 0,
    
    /// <summary>
    /// Bevel join.
    /// </summary>
    D2D1_LINE_JOIN_BEVEL = 1,
    
    /// <summary>
    /// Round join.
    /// </summary>
    D2D1_LINE_JOIN_ROUND = 2,
    
    /// <summary>
    /// Miter/Bevel join.
    /// </summary>
    D2D1_LINE_JOIN_MITER_OR_BEVEL = 3,
    D2D1_LINE_JOIN_FORCE_DWORD = 0xffffffff

} D2D1_LINE_JOIN;


/// <summary>
/// This enumeration describes the type of combine operation to be performed.
/// </summary>
typedef enum D2D1_COMBINE_MODE
{
    
    /// <summary>
    /// Produce a geometry representing the set of points contained in either the first
    /// or the second geometry.
    /// </summary>
    D2D1_COMBINE_MODE_UNION = 0,
    
    /// <summary>
    /// Produce a geometry representing the set of points common to the first and the
    /// second geometries.
    /// </summary>
    D2D1_COMBINE_MODE_INTERSECT = 1,
    
    /// <summary>
    /// Produce a geometry representing the set of points contained in the first
    /// geometry or the second geometry, but not both.
    /// </summary>
    D2D1_COMBINE_MODE_XOR = 2,
    
    /// <summary>
    /// Produce a geometry representing the set of points contained in the first
    /// geometry but not the second geometry.
    /// </summary>
    D2D1_COMBINE_MODE_EXCLUDE = 3,
    D2D1_COMBINE_MODE_FORCE_DWORD = 0xffffffff

} D2D1_COMBINE_MODE;


/// <summary>
/// Describes how one geometry object is spatially related to another geometry
/// object.
/// </summary>
typedef enum D2D1_GEOMETRY_RELATION
{
    
    /// <summary>
    /// The relation between the geometries couldn't be determined. This value is never
    /// returned by any D2D method.
    /// </summary>
    D2D1_GEOMETRY_RELATION_UNKNOWN = 0,
    
    /// <summary>
    /// The two geometries do not intersect at all.
    /// </summary>
    D2D1_GEOMETRY_RELATION_DISJOINT = 1,
    
    /// <summary>
    /// The passed in geometry is entirely contained by the object.
    /// </summary>
    D2D1_GEOMETRY_RELATION_IS_CONTAINED = 2,
    
    /// <summary>
    /// The object entirely contains the passed in geometry.
    /// </summary>
    D2D1_GEOMETRY_RELATION_CONTAINS = 3,
    
    /// <summary>
    /// The two geometries overlap but neither completely contains the other.
    /// </summary>
    D2D1_GEOMETRY_RELATION_OVERLAP = 4,
    D2D1_GEOMETRY_RELATION_FORCE_DWORD = 0xffffffff

} D2D1_GEOMETRY_RELATION;


/// <summary>
/// Specifies how simple the output of a simplified geometry sink should be.
/// </summary>
typedef enum D2D1_GEOMETRY_SIMPLIFICATION_OPTION
{
    D2D1_GEOMETRY_SIMPLIFICATION_OPTION_CUBICS_AND_LINES = 0,
    D2D1_GEOMETRY_SIMPLIFICATION_OPTION_LINES = 1,
    D2D1_GEOMETRY_SIMPLIFICATION_OPTION_FORCE_DWORD = 0xffffffff

} D2D1_GEOMETRY_SIMPLIFICATION_OPTION;


/// <summary>
/// Indicates whether the given figure is filled or hollow.
/// </summary>
typedef enum D2D1_FIGURE_BEGIN
{
    D2D1_FIGURE_BEGIN_FILLED = 0,
    D2D1_FIGURE_BEGIN_HOLLOW = 1,
    D2D1_FIGURE_BEGIN_FORCE_DWORD = 0xffffffff

} D2D1_FIGURE_BEGIN;


/// <summary>
/// Indicates whether the figure is open or closed on its end point.
/// </summary>
typedef enum D2D1_FIGURE_END
{
    D2D1_FIGURE_END_OPEN = 0,
    D2D1_FIGURE_END_CLOSED = 1,
    D2D1_FIGURE_END_FORCE_DWORD = 0xffffffff

} D2D1_FIGURE_END;


/// <summary>
/// Describes a cubic bezier in a path.
/// </summary>
typedef struct D2D1_BEZIER_SEGMENT
{
    D2D1_POINT_2F point1;
    D2D1_POINT_2F point2;
    D2D1_POINT_2F point3;

} D2D1_BEZIER_SEGMENT;


/// <summary>
/// Describes a triangle.
/// </summary>
typedef struct D2D1_TRIANGLE
{
    D2D1_POINT_2F point1;
    D2D1_POINT_2F point2;
    D2D1_POINT_2F point3;

} D2D1_TRIANGLE;


/// <summary>
/// Indicates whether the given segment should be stroked, or, if the join between
/// this segment and the previous one should be smooth.
/// </summary>
typedef enum D2D1_PATH_SEGMENT
{
    D2D1_PATH_SEGMENT_NONE = 0x00000000,
    D2D1_PATH_SEGMENT_FORCE_UNSTROKED = 0x00000001,
    D2D1_PATH_SEGMENT_FORCE_ROUND_LINE_JOIN = 0x00000002,
    D2D1_PATH_SEGMENT_FORCE_DWORD = 0xffffffff

} D2D1_PATH_SEGMENT;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_PATH_SEGMENT);


/// <summary>
/// Defines the direction that an elliptical arc is drawn.
/// </summary>
typedef enum D2D1_SWEEP_DIRECTION
{
    D2D1_SWEEP_DIRECTION_COUNTER_CLOCKWISE = 0,
    D2D1_SWEEP_DIRECTION_CLOCKWISE = 1,
    D2D1_SWEEP_DIRECTION_FORCE_DWORD = 0xffffffff

} D2D1_SWEEP_DIRECTION;


/// <summary>
/// Specifies how the intersecting areas of geometries or figures are combined to
/// form the area of the composite geometry.
/// </summary>
typedef enum D2D1_FILL_MODE
{
    D2D1_FILL_MODE_ALTERNATE = 0,
    D2D1_FILL_MODE_WINDING = 1,
    D2D1_FILL_MODE_FORCE_DWORD = 0xffffffff

} D2D1_FILL_MODE;


/// <summary>
/// Describes an arc that is defined as part of a path.
/// </summary>
typedef struct D2D1_ARC_SEGMENT
{
    D2D1_POINT_2F point;
    D2D1_SIZE_F size;
    FLOAT rotationAngle;
    D2D1_SWEEP_DIRECTION sweepDirection;
    D2D1_ARC_SIZE arcSize;

} D2D1_ARC_SEGMENT;


/// <summary>
/// Contains the control point and end point for a quadratic Bezier segment.
/// </summary>
typedef struct D2D1_QUADRATIC_BEZIER_SEGMENT
{
    D2D1_POINT_2F point1;
    D2D1_POINT_2F point2;

} D2D1_QUADRATIC_BEZIER_SEGMENT;


/// <summary>
/// Contains the center point, x-radius, and y-radius of an ellipse.
/// </summary>
typedef struct D2D1_ELLIPSE
{
    D2D1_POINT_2F point;
    FLOAT radiusX;
    FLOAT radiusY;

} D2D1_ELLIPSE;


/// <summary>
/// Contains the dimensions and corner radii of a rounded rectangle.
/// </summary>
typedef struct D2D1_ROUNDED_RECT
{
    D2D1_RECT_F rect;
    FLOAT radiusX;
    FLOAT radiusY;

} D2D1_ROUNDED_RECT;


/// <summary>
/// Properties, aside from the width, that allow geometric penning to be specified.
/// </summary>
typedef struct D2D1_STROKE_STYLE_PROPERTIES
{
    D2D1_CAP_STYLE startCap;
    D2D1_CAP_STYLE endCap;
    D2D1_CAP_STYLE dashCap;
    D2D1_LINE_JOIN lineJoin;
    FLOAT miterLimit;
    D2D1_DASH_STYLE dashStyle;
    FLOAT dashOffset;

} D2D1_STROKE_STYLE_PROPERTIES;


/// <summary>
/// Specified options that can be applied when a layer resource is applied to create
/// a layer.
/// </summary>
typedef enum D2D1_LAYER_OPTIONS
{
    D2D1_LAYER_OPTIONS_NONE = 0x00000000,
    
    /// <summary>
    /// The layer will render correctly for ClearType text. If the render target was set
    /// to ClearType previously, the layer will continue to render ClearType. If the
    /// render target was set to ClearType and this option is not specified, the render
    /// target will be set to render gray-scale until the layer is popped. The caller
    /// can override this default by calling SetTextAntialiasMode while within the
    /// layer. This flag is slightly slower than the default.
    /// </summary>
    D2D1_LAYER_OPTIONS_INITIALIZE_FOR_CLEARTYPE = 0x00000001,
    D2D1_LAYER_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_LAYER_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_LAYER_OPTIONS);


/// <summary>
/// Contains the content bounds, mask information, opacity settings, and other
/// options for a layer resource.
/// </summary>
typedef struct D2D1_LAYER_PARAMETERS
{
    
    /// <summary>
    /// The rectangular clip that will be applied to the layer. The clip is affected by
    /// the world transform. Content outside of the content bounds will not render.
    /// </summary>
    D2D1_RECT_F contentBounds;
    
    /// <summary>
    /// A general mask that can be optionally applied to the content. Content not inside
    /// the fill of the mask will not be rendered.
    /// </summary>
    _Field_size_opt_(1) ID2D1Geometry *geometricMask;
    
    /// <summary>
    /// Specifies whether the mask should be aliased or antialiased.
    /// </summary>
    D2D1_ANTIALIAS_MODE maskAntialiasMode;
    
    /// <summary>
    /// An additional transform that may be applied to the mask in addition to the
    /// current world transform.
    /// </summary>
    D2D1_MATRIX_3X2_F maskTransform;
    
    /// <summary>
    /// The opacity with which all of the content in the layer will be blended back to
    /// the target when the layer is popped.
    /// </summary>
    FLOAT opacity;
    
    /// <summary>
    /// An additional brush that can be applied to the layer. Only the opacity channel
    /// is sampled from this brush and multiplied both with the layer content and the
    /// over-all layer opacity.
    /// </summary>
    _Field_size_opt_(1) ID2D1Brush *opacityBrush;
    
    /// <summary>
    /// Specifies if ClearType will be rendered into the layer.
    /// </summary>
    D2D1_LAYER_OPTIONS layerOptions;

} D2D1_LAYER_PARAMETERS;


/// <summary>
/// Describes whether a window is occluded.
/// </summary>
typedef enum D2D1_WINDOW_STATE
{
    D2D1_WINDOW_STATE_NONE = 0x0000000,
    D2D1_WINDOW_STATE_OCCLUDED = 0x0000001,
    D2D1_WINDOW_STATE_FORCE_DWORD = 0xffffffff

} D2D1_WINDOW_STATE;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_WINDOW_STATE);


/// <summary>
/// Describes whether a render target uses hardware or software rendering, or if
/// Direct2D should select the rendering mode.
/// </summary>
typedef enum D2D1_RENDER_TARGET_TYPE
{
    
    /// <summary>
    /// D2D is free to choose the render target type for the caller.
    /// </summary>
    D2D1_RENDER_TARGET_TYPE_DEFAULT = 0,
    
    /// <summary>
    /// The render target will render using the CPU.
    /// </summary>
    D2D1_RENDER_TARGET_TYPE_SOFTWARE = 1,
    
    /// <summary>
    /// The render target will render using the GPU.
    /// </summary>
    D2D1_RENDER_TARGET_TYPE_HARDWARE = 2,
    D2D1_RENDER_TARGET_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_RENDER_TARGET_TYPE;


/// <summary>
/// Describes the minimum DirectX support required for hardware rendering by a
/// render target.
/// </summary>
typedef enum D2D1_FEATURE_LEVEL
{
    
    /// <summary>
    /// The caller does not require a particular underlying D3D device level.
    /// </summary>
    D2D1_FEATURE_LEVEL_DEFAULT = 0,
    
    /// <summary>
    /// The D3D device level is DX9 compatible.
    /// </summary>
    D2D1_FEATURE_LEVEL_9 = D3D_FEATURE_LEVEL_9_1,
    
    /// <summary>
    /// The D3D device level is DX10 compatible.
    /// </summary>
    D2D1_FEATURE_LEVEL_10 = D3D_FEATURE_LEVEL_10_0,
    D2D1_FEATURE_LEVEL_FORCE_DWORD = 0xffffffff

} D2D1_FEATURE_LEVEL;


/// <summary>
/// Describes how a render target is remoted and whether it should be
/// GDI-compatible. This enumeration allows a bitwise combination of its member
/// values.
/// </summary>
typedef enum D2D1_RENDER_TARGET_USAGE
{
    D2D1_RENDER_TARGET_USAGE_NONE = 0x00000000,
    
    /// <summary>
    /// Rendering will occur locally, if a terminal-services session is established, the
    /// bitmap updates will be sent to the terminal services client.
    /// </summary>
    D2D1_RENDER_TARGET_USAGE_FORCE_BITMAP_REMOTING = 0x00000001,
    
    /// <summary>
    /// The render target will allow a call to GetDC on the ID2D1GdiInteropRenderTarget
    /// interface. Rendering will also occur locally.
    /// </summary>
    D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE = 0x00000002,
    D2D1_RENDER_TARGET_USAGE_FORCE_DWORD = 0xffffffff

} D2D1_RENDER_TARGET_USAGE;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_RENDER_TARGET_USAGE);


/// <summary>
/// Describes how present should behave.
/// </summary>
typedef enum D2D1_PRESENT_OPTIONS
{
    D2D1_PRESENT_OPTIONS_NONE = 0x00000000,
    
    /// <summary>
    /// Keep the target contents intact through present.
    /// </summary>
    D2D1_PRESENT_OPTIONS_RETAIN_CONTENTS = 0x00000001,
    
    /// <summary>
    /// Do not wait for display refresh to commit changes to display.
    /// </summary>
    D2D1_PRESENT_OPTIONS_IMMEDIATELY = 0x00000002,
    D2D1_PRESENT_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_PRESENT_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_PRESENT_OPTIONS);


/// <summary>
/// Contains rendering options (hardware or software), pixel format, DPI
/// information, remoting options, and Direct3D support requirements for a render
/// target.
/// </summary>
typedef struct D2D1_RENDER_TARGET_PROPERTIES
{
    D2D1_RENDER_TARGET_TYPE type;
    D2D1_PIXEL_FORMAT pixelFormat;
    FLOAT dpiX;
    FLOAT dpiY;
    D2D1_RENDER_TARGET_USAGE usage;
    D2D1_FEATURE_LEVEL minLevel;

} D2D1_RENDER_TARGET_PROPERTIES;


/// <summary>
/// Contains the HWND, pixel size, and presentation options for an
/// ID2D1HwndRenderTarget.
/// </summary>
typedef struct D2D1_HWND_RENDER_TARGET_PROPERTIES
{
    HWND hwnd;
    D2D1_SIZE_U pixelSize;
    D2D1_PRESENT_OPTIONS presentOptions;

} D2D1_HWND_RENDER_TARGET_PROPERTIES;


/// <summary>
/// Specifies additional features supportable by a compatible render target when it
/// is created. This enumeration allows a bitwise combination of its member values.
/// </summary>
typedef enum D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS
{
    D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_NONE = 0x00000000,
    
    /// <summary>
    /// The compatible render target will allow a call to GetDC on the
    /// ID2D1GdiInteropRenderTarget interface. This can be specified even if the parent
    /// render target is not GDI compatible.
    /// </summary>
    D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_GDI_COMPATIBLE = 0x00000001,
    D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS);


/// <summary>
/// Allows the drawing state to be atomically created. This also specifies the
/// drawing state that is saved into an IDrawingStateBlock object.
/// </summary>
typedef struct D2D1_DRAWING_STATE_DESCRIPTION
{
    D2D1_ANTIALIAS_MODE antialiasMode;
    D2D1_TEXT_ANTIALIAS_MODE textAntialiasMode;
    D2D1_TAG tag1;
    D2D1_TAG tag2;
    D2D1_MATRIX_3X2_F transform;

} D2D1_DRAWING_STATE_DESCRIPTION;


/// <summary>
/// Specifies how a device context is initialized for GDI rendering when it is
/// retrieved from the render target.
/// </summary>
typedef enum D2D1_DC_INITIALIZE_MODE
{
    
    /// <summary>
    /// The contents of the D2D render target will be copied to the DC.
    /// </summary>
    D2D1_DC_INITIALIZE_MODE_COPY = 0,
    
    /// <summary>
    /// The contents of the DC will be cleared.
    /// </summary>
    D2D1_DC_INITIALIZE_MODE_CLEAR = 1,
    D2D1_DC_INITIALIZE_MODE_FORCE_DWORD = 0xffffffff

} D2D1_DC_INITIALIZE_MODE;


/// <summary>
/// Indicates the debug level to be output by the debug layer.
/// </summary>
typedef enum D2D1_DEBUG_LEVEL
{
    D2D1_DEBUG_LEVEL_NONE = 0,
    D2D1_DEBUG_LEVEL_ERROR = 1,
    D2D1_DEBUG_LEVEL_WARNING = 2,
    D2D1_DEBUG_LEVEL_INFORMATION = 3,
    D2D1_DEBUG_LEVEL_FORCE_DWORD = 0xffffffff

} D2D1_DEBUG_LEVEL;


/// <summary>
/// Specifies the threading model of the created factory and all of its derived
/// resources.
/// </summary>
typedef enum D2D1_FACTORY_TYPE
{
    
    /// <summary>
    /// The resulting factory and derived resources may only be invoked serially.
    /// Reference counts on resources are interlocked, however, resource and render
    /// target state is not protected from multi-threaded access.
    /// </summary>
    D2D1_FACTORY_TYPE_SINGLE_THREADED = 0,
    
    /// <summary>
    /// The resulting factory may be invoked from multiple threads. Returned resources
    /// use interlocked reference counting and their state is protected.
    /// </summary>
    D2D1_FACTORY_TYPE_MULTI_THREADED = 1,
    D2D1_FACTORY_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_FACTORY_TYPE;


/// <summary>
/// Allows additional parameters for factory creation.
/// </summary>
typedef struct D2D1_FACTORY_OPTIONS
{
    
    /// <summary>
    /// Requests a certain level of debugging information from the debug layer. This
    /// parameter is ignored if the debug layer DLL is not present.
    /// </summary>
    D2D1_DEBUG_LEVEL debugLevel;

} D2D1_FACTORY_OPTIONS;


#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion


#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)


EXTERN_C CONST IID IID_ID2D1Resource;
EXTERN_C CONST IID IID_ID2D1Image;
EXTERN_C CONST IID IID_ID2D1Bitmap;
EXTERN_C CONST IID IID_ID2D1GradientStopCollection;
EXTERN_C CONST IID IID_ID2D1Brush;
EXTERN_C CONST IID IID_ID2D1BitmapBrush;
EXTERN_C CONST IID IID_ID2D1SolidColorBrush;
EXTERN_C CONST IID IID_ID2D1LinearGradientBrush;
EXTERN_C CONST IID IID_ID2D1RadialGradientBrush;
EXTERN_C CONST IID IID_ID2D1StrokeStyle;
EXTERN_C CONST IID IID_ID2D1Geometry;
EXTERN_C CONST IID IID_ID2D1RectangleGeometry;
EXTERN_C CONST IID IID_ID2D1RoundedRectangleGeometry;
EXTERN_C CONST IID IID_ID2D1EllipseGeometry;
EXTERN_C CONST IID IID_ID2D1GeometryGroup;
EXTERN_C CONST IID IID_ID2D1TransformedGeometry;
EXTERN_C CONST IID IID_ID2D1SimplifiedGeometrySink;
EXTERN_C CONST IID IID_ID2D1GeometrySink;
EXTERN_C CONST IID IID_ID2D1TessellationSink;
EXTERN_C CONST IID IID_ID2D1PathGeometry;
EXTERN_C CONST IID IID_ID2D1Mesh;
EXTERN_C CONST IID IID_ID2D1Layer;
EXTERN_C CONST IID IID_ID2D1DrawingStateBlock;
EXTERN_C CONST IID IID_ID2D1RenderTarget;
EXTERN_C CONST IID IID_ID2D1BitmapRenderTarget;
EXTERN_C CONST IID IID_ID2D1HwndRenderTarget;
EXTERN_C CONST IID IID_ID2D1DCRenderTarget;
EXTERN_C CONST IID IID_ID2D1Factory;


#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)


EXTERN_C CONST IID IID_ID2D1GdiInteropRenderTarget;


#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion


#ifndef D2D_USE_C_DEFINITIONS


#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

/// <summary>
/// The root interface for all resources in D2D.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd90691-12e2-11dc-9fed-001143a055f9") ID2D1Resource  : public IUnknown
{
    
    /// <summary>
    /// Retrieve the factory associated with this resource.
    /// </summary>
    STDMETHOD_(void, GetFactory)(
        _Outptr_ ID2D1Factory **factory 
        ) CONST PURE;
}; // interface ID2D1Resource


/// <summary>
/// Represents a producer of pixels that can fill an arbitrary 2D plane.
/// </summary>
interface DX_DECLARE_INTERFACE("65019f75-8da2-497c-b32c-dfa34e48ede6") ID2D1Image  : public ID2D1Resource
{
}; // interface ID2D1Image


/// <summary>
/// Root bitmap resource, linearly scaled on a draw call.
/// </summary>
interface DX_DECLARE_INTERFACE("a2296057-ea42-4099-983b-539fb6505426") ID2D1Bitmap  : public ID2D1Image
{
    
    /// <summary>
    /// Returns the size of the bitmap in resolution independent units.
    /// </summary>
    STDMETHOD_(D2D1_SIZE_F, GetSize)(
        ) CONST PURE;
    
    /// <summary>
    /// Returns the size of the bitmap in resolution dependent units, (pixels).
    /// </summary>
    STDMETHOD_(D2D1_SIZE_U, GetPixelSize)(
        ) CONST PURE;
    
    /// <summary>
    /// Retrieve the format of the bitmap.
    /// </summary>
    STDMETHOD_(D2D1_PIXEL_FORMAT, GetPixelFormat)(
        ) CONST PURE;
    
    /// <summary>
    /// Return the DPI of the bitmap.
    /// </summary>
    STDMETHOD_(void, GetDpi)(
        _Out_ FLOAT *dpiX,
        _Out_ FLOAT *dpiY 
        ) CONST PURE;
    
    STDMETHOD(CopyFromBitmap)(
        _In_opt_ CONST D2D1_POINT_2U *destPoint,
        _In_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_RECT_U *srcRect 
        ) PURE;
    
    STDMETHOD(CopyFromRenderTarget)(
        _In_opt_ CONST D2D1_POINT_2U *destPoint,
        _In_ ID2D1RenderTarget *renderTarget,
        _In_opt_ CONST D2D1_RECT_U *srcRect 
        ) PURE;
    
    STDMETHOD(CopyFromMemory)(
        _In_opt_ CONST D2D1_RECT_U *dstRect,
        _In_ CONST void *srcData,
        UINT32 pitch 
        ) PURE;
}; // interface ID2D1Bitmap


/// <summary>
/// Represents an collection of gradient stops that can then be the source resource
/// for either a linear or radial gradient brush.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a7-12e2-11dc-9fed-001143a055f9") ID2D1GradientStopCollection  : public ID2D1Resource
{
    
    /// <summary>
    /// Returns the number of stops in the gradient.
    /// </summary>
    STDMETHOD_(UINT32, GetGradientStopCount)(
        ) CONST PURE;
    
    /// <summary>
    /// Copies the gradient stops from the collection into the caller's interface.  The
    /// returned colors have straight alpha.
    /// </summary>
    STDMETHOD_(void, GetGradientStops)(
        _Out_writes_to_(gradientStopsCount, _Inexpressible_("Retrieved through GetGradientStopCount()") ) D2D1_GRADIENT_STOP *gradientStops,
        UINT32 gradientStopsCount 
        ) CONST PURE;
    
    /// <summary>
    /// Returns whether the interpolation occurs with 1.0 or 2.2 gamma.
    /// </summary>
    STDMETHOD_(D2D1_GAMMA, GetColorInterpolationGamma)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendMode)(
        ) CONST PURE;
}; // interface ID2D1GradientStopCollection


/// <summary>
/// The root brush interface. All brushes can be used to fill or pen a geometry.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a8-12e2-11dc-9fed-001143a055f9") ID2D1Brush  : public ID2D1Resource
{
    
    /// <summary>
    /// Sets the opacity for when the brush is drawn over the entire fill of the brush.
    /// </summary>
    STDMETHOD_(void, SetOpacity)(
        FLOAT opacity 
        ) PURE;
    
    /// <summary>
    /// Sets the transform that applies to everything drawn by the brush.
    /// </summary>
    STDMETHOD_(void, SetTransform)(
        _In_ CONST D2D1_MATRIX_3X2_F *transform 
        ) PURE;
    
    STDMETHOD_(FLOAT, GetOpacity)(
        ) CONST PURE;
    
    STDMETHOD_(void, GetTransform)(
        _Out_ D2D1_MATRIX_3X2_F *transform 
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    void
    SetTransform(
        CONST D2D1_MATRIX_3X2_F &transform 
        )  
    {
        SetTransform(&transform);
    }
}; // interface ID2D1Brush


/// <summary>
/// A bitmap brush allows a bitmap to be used to fill a geometry.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906aa-12e2-11dc-9fed-001143a055f9") ID2D1BitmapBrush  : public ID2D1Brush
{
    
    /// <summary>
    /// Sets how the bitmap is to be treated outside of its natural extent on the X
    /// axis.
    /// </summary>
    STDMETHOD_(void, SetExtendModeX)(
        D2D1_EXTEND_MODE extendModeX 
        ) PURE;
    
    /// <summary>
    /// Sets how the bitmap is to be treated outside of its natural extent on the X
    /// axis.
    /// </summary>
    STDMETHOD_(void, SetExtendModeY)(
        D2D1_EXTEND_MODE extendModeY 
        ) PURE;
    
    /// <summary>
    /// Sets the interpolation mode used when this brush is used.
    /// </summary>
    STDMETHOD_(void, SetInterpolationMode)(
        D2D1_BITMAP_INTERPOLATION_MODE interpolationMode 
        ) PURE;
    
    /// <summary>
    /// Sets the bitmap associated as the source of this brush.
    /// </summary>
    STDMETHOD_(void, SetBitmap)(
        _In_opt_ ID2D1Bitmap *bitmap 
        ) PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeX)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeY)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_BITMAP_INTERPOLATION_MODE, GetInterpolationMode)(
        ) CONST PURE;
    
    STDMETHOD_(void, GetBitmap)(
        _Outptr_result_maybenull_ ID2D1Bitmap **bitmap 
        ) CONST PURE;
}; // interface ID2D1BitmapBrush


/// <summary>
/// Paints an area with a solid color.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a9-12e2-11dc-9fed-001143a055f9") ID2D1SolidColorBrush  : public ID2D1Brush
{
    
    STDMETHOD_(void, SetColor)(
        _In_ CONST D2D1_COLOR_F *color 
        ) PURE;
    
    STDMETHOD_(D2D1_COLOR_F, GetColor)(
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    void
    SetColor(
        CONST D2D1_COLOR_F &color 
        )  
    {
        SetColor(&color);
    }
}; // interface ID2D1SolidColorBrush


/// <summary>
/// Paints an area with a linear gradient.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906ab-12e2-11dc-9fed-001143a055f9") ID2D1LinearGradientBrush  : public ID2D1Brush
{
    
    STDMETHOD_(void, SetStartPoint)(
        D2D1_POINT_2F startPoint 
        ) PURE;
    
    /// <summary>
    /// Sets the end point of the gradient in local coordinate space. This is not
    /// influenced by the geometry being filled.
    /// </summary>
    STDMETHOD_(void, SetEndPoint)(
        D2D1_POINT_2F endPoint 
        ) PURE;
    
    STDMETHOD_(D2D1_POINT_2F, GetStartPoint)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_POINT_2F, GetEndPoint)(
        ) CONST PURE;
    
    STDMETHOD_(void, GetGradientStopCollection)(
        _Outptr_ ID2D1GradientStopCollection **gradientStopCollection 
        ) CONST PURE;
}; // interface ID2D1LinearGradientBrush


/// <summary>
/// Paints an area with a radial gradient.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906ac-12e2-11dc-9fed-001143a055f9") ID2D1RadialGradientBrush  : public ID2D1Brush
{
    
    /// <summary>
    /// Sets the center of the radial gradient. This will be in local coordinates and
    /// will not depend on the geometry being filled.
    /// </summary>
    STDMETHOD_(void, SetCenter)(
        D2D1_POINT_2F center 
        ) PURE;
    
    /// <summary>
    /// Sets offset of the origin relative to the radial gradient center.
    /// </summary>
    STDMETHOD_(void, SetGradientOriginOffset)(
        D2D1_POINT_2F gradientOriginOffset 
        ) PURE;
    
    STDMETHOD_(void, SetRadiusX)(
        FLOAT radiusX 
        ) PURE;
    
    STDMETHOD_(void, SetRadiusY)(
        FLOAT radiusY 
        ) PURE;
    
    STDMETHOD_(D2D1_POINT_2F, GetCenter)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_POINT_2F, GetGradientOriginOffset)(
        ) CONST PURE;
    
    STDMETHOD_(FLOAT, GetRadiusX)(
        ) CONST PURE;
    
    STDMETHOD_(FLOAT, GetRadiusY)(
        ) CONST PURE;
    
    STDMETHOD_(void, GetGradientStopCollection)(
        _Outptr_ ID2D1GradientStopCollection **gradientStopCollection 
        ) CONST PURE;
}; // interface ID2D1RadialGradientBrush


/// <summary>
/// Resource interface that holds pen style properties.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd9069d-12e2-11dc-9fed-001143a055f9") ID2D1StrokeStyle  : public ID2D1Resource
{
    
    STDMETHOD_(D2D1_CAP_STYLE, GetStartCap)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_CAP_STYLE, GetEndCap)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_CAP_STYLE, GetDashCap)(
        ) CONST PURE;
    
    STDMETHOD_(FLOAT, GetMiterLimit)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_LINE_JOIN, GetLineJoin)(
        ) CONST PURE;
    
    STDMETHOD_(FLOAT, GetDashOffset)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_DASH_STYLE, GetDashStyle)(
        ) CONST PURE;
    
    STDMETHOD_(UINT32, GetDashesCount)(
        ) CONST PURE;
    
    /// <summary>
    /// Returns the dashes from the object into a user allocated array. The user must
    /// call GetDashesCount to retrieve the required size.
    /// </summary>
    STDMETHOD_(void, GetDashes)(
        _Out_writes_(dashesCount) FLOAT *dashes,
        UINT32 dashesCount 
        ) CONST PURE;
}; // interface ID2D1StrokeStyle


/// <summary>
/// Represents a geometry resource and defines a set of helper methods for
/// manipulating and measuring geometric shapes. Interfaces that inherit from
/// ID2D1Geometry define specific shapes.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a1-12e2-11dc-9fed-001143a055f9") ID2D1Geometry  : public ID2D1Resource
{
    
    /// <summary>
    /// Retrieve the bounds of the geometry, with an optional applied transform.
    /// </summary>
    STDMETHOD(GetBounds)(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _Out_ D2D1_RECT_F *bounds 
        ) CONST PURE;
    
    /// <summary>
    /// Get the bounds of the corresponding geometry after it has been widened or have
    /// an optional pen style applied.
    /// </summary>
    STDMETHOD(GetWidenedBounds)(
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _Out_ D2D1_RECT_F *bounds 
        ) CONST PURE;
    
    /// <summary>
    /// Checks to see whether the corresponding penned and widened geometry contains the
    /// given point.
    /// </summary>
    STDMETHOD(StrokeContainsPoint)(
        D2D1_POINT_2F point,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _Out_ BOOL *contains 
        ) CONST PURE;
    
    /// <summary>
    /// Test whether the given fill of this geometry would contain this point.
    /// </summary>
    STDMETHOD(FillContainsPoint)(
        D2D1_POINT_2F point,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _Out_ BOOL *contains 
        ) CONST PURE;
    
    /// <summary>
    /// Compare how one geometry intersects or contains another geometry.
    /// </summary>
    STDMETHOD(CompareWithGeometry)(
        _In_ ID2D1Geometry *inputGeometry,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *inputGeometryTransform,
        FLOAT flatteningTolerance,
        _Out_ D2D1_GEOMETRY_RELATION *relation 
        ) CONST PURE;
    
    /// <summary>
    /// Converts a geometry to a simplified geometry that has arcs and quadratic beziers
    /// removed.
    /// </summary>
    STDMETHOD(Simplify)(
        D2D1_GEOMETRY_SIMPLIFICATION_OPTION simplificationOption,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST PURE;
    
    /// <summary>
    /// Tessellates a geometry into triangles.
    /// </summary>
    STDMETHOD(Tessellate)(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1TessellationSink *tessellationSink 
        ) CONST PURE;
    
    /// <summary>
    /// Performs a combine operation between the two geometries to produce a resulting
    /// geometry.
    /// </summary>
    STDMETHOD(CombineWithGeometry)(
        _In_ ID2D1Geometry *inputGeometry,
        D2D1_COMBINE_MODE combineMode,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *inputGeometryTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST PURE;
    
    /// <summary>
    /// Computes the outline of the geometry. The result is written back into a
    /// simplified geometry sink.
    /// </summary>
    STDMETHOD(Outline)(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST PURE;
    
    /// <summary>
    /// Computes the area of the geometry.
    /// </summary>
    STDMETHOD(ComputeArea)(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _Out_ FLOAT *area 
        ) CONST PURE;
    
    /// <summary>
    /// Computes the length of the geometry.
    /// </summary>
    STDMETHOD(ComputeLength)(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _Out_ FLOAT *length 
        ) CONST PURE;
    
    /// <summary>
    /// Computes the point and tangent a given distance along the path.
    /// </summary>
    STDMETHOD(ComputePointAtLength)(
        FLOAT length,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _Out_opt_ D2D1_POINT_2F *point,
        _Out_opt_ D2D1_POINT_2F *unitTangentVector 
        ) CONST PURE;
    
    /// <summary>
    /// Get the geometry and widen it as well as apply an optional pen style.
    /// </summary>
    STDMETHOD(Widen)(
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST PURE;
    
    /// <summary>
    /// Retrieve the bounds of the geometry, with an optional applied transform.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetBounds(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _Out_ D2D1_RECT_F *bounds 
        ) CONST  
    {
        return GetBounds(&worldTransform, bounds);
    }
    
    /// <summary>
    /// Get the bounds of the corresponding geometry after it has been widened or have
    /// an optional pen style applied.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetWidenedBounds(
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _Out_ D2D1_RECT_F *bounds 
        ) CONST  
    {
        return GetWidenedBounds(strokeWidth, strokeStyle, &worldTransform, flatteningTolerance, bounds);
    }
    
    /// <summary>
    /// Get the bounds of the corresponding geometry after it has been widened or have
    /// an optional pen style applied.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetWidenedBounds(
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _Out_ D2D1_RECT_F *bounds 
        ) CONST  
    {
        return GetWidenedBounds(strokeWidth, strokeStyle, worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, bounds);
    }
    
    /// <summary>
    /// Get the bounds of the corresponding geometry after it has been widened or have
    /// an optional pen style applied.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetWidenedBounds(
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _Out_ D2D1_RECT_F *bounds 
        ) CONST  
    {
        return GetWidenedBounds(strokeWidth, strokeStyle, &worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, bounds);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    StrokeContainsPoint(
        D2D1_POINT_2F point,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _Out_ BOOL *contains 
        ) CONST  
    {
        return StrokeContainsPoint(point, strokeWidth, strokeStyle, &worldTransform, flatteningTolerance, contains);
    }
    
    /// <summary>
    /// Checks to see whether the corresponding penned and widened geometry contains the
    /// given point.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    StrokeContainsPoint(
        D2D1_POINT_2F point,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _Out_ BOOL *contains 
        ) CONST  
    {
        return StrokeContainsPoint(point, strokeWidth, strokeStyle, worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, contains);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    StrokeContainsPoint(
        D2D1_POINT_2F point,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _Out_ BOOL *contains 
        ) CONST  
    {
        return StrokeContainsPoint(point, strokeWidth, strokeStyle, &worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, contains);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    FillContainsPoint(
        D2D1_POINT_2F point,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _Out_ BOOL *contains 
        ) CONST  
    {
        return FillContainsPoint(point, &worldTransform, flatteningTolerance, contains);
    }
    
    /// <summary>
    /// Test whether the given fill of this geometry would contain this point.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    FillContainsPoint(
        D2D1_POINT_2F point,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _Out_ BOOL *contains 
        ) CONST  
    {
        return FillContainsPoint(point, worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, contains);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    FillContainsPoint(
        D2D1_POINT_2F point,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _Out_ BOOL *contains 
        ) CONST  
    {
        return FillContainsPoint(point, &worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, contains);
    }
    
    /// <summary>
    /// Compare how one geometry intersects or contains another geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CompareWithGeometry(
        _In_ ID2D1Geometry *inputGeometry,
        CONST D2D1_MATRIX_3X2_F &inputGeometryTransform,
        FLOAT flatteningTolerance,
        _Out_ D2D1_GEOMETRY_RELATION *relation 
        ) CONST  
    {
        return CompareWithGeometry(inputGeometry, &inputGeometryTransform, flatteningTolerance, relation);
    }
    
    /// <summary>
    /// Compare how one geometry intersects or contains another geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CompareWithGeometry(
        _In_ ID2D1Geometry *inputGeometry,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *inputGeometryTransform,
        _Out_ D2D1_GEOMETRY_RELATION *relation 
        ) CONST  
    {
        return CompareWithGeometry(inputGeometry, inputGeometryTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, relation);
    }
    
    /// <summary>
    /// Compare how one geometry intersects or contains another geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CompareWithGeometry(
        _In_ ID2D1Geometry *inputGeometry,
        CONST D2D1_MATRIX_3X2_F &inputGeometryTransform,
        _Out_ D2D1_GEOMETRY_RELATION *relation 
        ) CONST  
    {
        return CompareWithGeometry(inputGeometry, &inputGeometryTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, relation);
    }
    
    /// <summary>
    /// Converts a geometry to a simplified geometry that has arcs and quadratic beziers
    /// removed.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Simplify(
        D2D1_GEOMETRY_SIMPLIFICATION_OPTION simplificationOption,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Simplify(simplificationOption, &worldTransform, flatteningTolerance, geometrySink);
    }
    
    /// <summary>
    /// Converts a geometry to a simplified geometry that has arcs and quadratic beziers
    /// removed.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Simplify(
        D2D1_GEOMETRY_SIMPLIFICATION_OPTION simplificationOption,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Simplify(simplificationOption, worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, geometrySink);
    }
    
    /// <summary>
    /// Converts a geometry to a simplified geometry that has arcs and quadratic beziers
    /// removed.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Simplify(
        D2D1_GEOMETRY_SIMPLIFICATION_OPTION simplificationOption,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Simplify(simplificationOption, &worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, geometrySink);
    }
    
    /// <summary>
    /// Tessellates a geometry into triangles.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Tessellate(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1TessellationSink *tessellationSink 
        ) CONST  
    {
        return Tessellate(&worldTransform, flatteningTolerance, tessellationSink);
    }
    
    /// <summary>
    /// Tessellates a geometry into triangles.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Tessellate(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _In_ ID2D1TessellationSink *tessellationSink 
        ) CONST  
    {
        return Tessellate(worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, tessellationSink);
    }
    
    /// <summary>
    /// Tessellates a geometry into triangles.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Tessellate(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _In_ ID2D1TessellationSink *tessellationSink 
        ) CONST  
    {
        return Tessellate(&worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, tessellationSink);
    }
    
    /// <summary>
    /// Performs a combine operation between the two geometries to produce a resulting
    /// geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CombineWithGeometry(
        _In_ ID2D1Geometry *inputGeometry,
        D2D1_COMBINE_MODE combineMode,
        CONST D2D1_MATRIX_3X2_F &inputGeometryTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return CombineWithGeometry(inputGeometry, combineMode, &inputGeometryTransform, flatteningTolerance, geometrySink);
    }
    
    /// <summary>
    /// Performs a combine operation between the two geometries to produce a resulting
    /// geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CombineWithGeometry(
        _In_ ID2D1Geometry *inputGeometry,
        D2D1_COMBINE_MODE combineMode,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *inputGeometryTransform,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return CombineWithGeometry(inputGeometry, combineMode, inputGeometryTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, geometrySink);
    }
    
    /// <summary>
    /// Performs a combine operation between the two geometries to produce a resulting
    /// geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CombineWithGeometry(
        _In_ ID2D1Geometry *inputGeometry,
        D2D1_COMBINE_MODE combineMode,
        CONST D2D1_MATRIX_3X2_F &inputGeometryTransform,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return CombineWithGeometry(inputGeometry, combineMode, &inputGeometryTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, geometrySink);
    }
    
    /// <summary>
    /// Computes the outline of the geometry. The result is written back into a
    /// simplified geometry sink.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Outline(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Outline(&worldTransform, flatteningTolerance, geometrySink);
    }
    
    /// <summary>
    /// Computes the outline of the geometry. The result is written back into a
    /// simplified geometry sink.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Outline(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Outline(worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, geometrySink);
    }
    
    /// <summary>
    /// Computes the outline of the geometry. The result is written back into a
    /// simplified geometry sink.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Outline(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Outline(&worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, geometrySink);
    }
    
    /// <summary>
    /// Computes the area of the geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputeArea(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _Out_ FLOAT *area 
        ) CONST  
    {
        return ComputeArea(&worldTransform, flatteningTolerance, area);
    }
    
    /// <summary>
    /// Computes the area of the geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputeArea(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _Out_ FLOAT *area 
        ) CONST  
    {
        return ComputeArea(worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, area);
    }
    
    /// <summary>
    /// Computes the area of the geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputeArea(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _Out_ FLOAT *area 
        ) CONST  
    {
        return ComputeArea(&worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, area);
    }
    
    /// <summary>
    /// Computes the length of the geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputeLength(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _Out_ FLOAT *length 
        ) CONST  
    {
        return ComputeLength(&worldTransform, flatteningTolerance, length);
    }
    
    /// <summary>
    /// Computes the length of the geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputeLength(
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _Out_ FLOAT *length 
        ) CONST  
    {
        return ComputeLength(worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, length);
    }
    
    /// <summary>
    /// Computes the length of the geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputeLength(
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _Out_ FLOAT *length 
        ) CONST  
    {
        return ComputeLength(&worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, length);
    }
    
    /// <summary>
    /// Computes the point and tangent a given distance along the path.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputePointAtLength(
        FLOAT length,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _Out_opt_ D2D1_POINT_2F *point,
        _Out_opt_ D2D1_POINT_2F *unitTangentVector 
        ) CONST  
    {
        return ComputePointAtLength(length, &worldTransform, flatteningTolerance, point, unitTangentVector);
    }
    
    /// <summary>
    /// Computes the point and tangent a given distance along the path.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputePointAtLength(
        FLOAT length,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _Out_opt_ D2D1_POINT_2F *point,
        _Out_opt_ D2D1_POINT_2F *unitTangentVector 
        ) CONST  
    {
        return ComputePointAtLength(length, worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, point, unitTangentVector);
    }
    
    /// <summary>
    /// Computes the point and tangent a given distance along the path.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputePointAtLength(
        FLOAT length,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _Out_opt_ D2D1_POINT_2F *point,
        _Out_opt_ D2D1_POINT_2F *unitTangentVector 
        ) CONST  
    {
        return ComputePointAtLength(length, &worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, point, unitTangentVector);
    }
    
    /// <summary>
    /// Get the geometry and widen it as well as apply an optional pen style.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Widen(
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Widen(strokeWidth, strokeStyle, &worldTransform, flatteningTolerance, geometrySink);
    }
    
    /// <summary>
    /// Get the geometry and widen it as well as apply an optional pen style.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Widen(
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Widen(strokeWidth, strokeStyle, worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, geometrySink);
    }
    
    /// <summary>
    /// Get the geometry and widen it as well as apply an optional pen style.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    Widen(
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _In_ ID2D1SimplifiedGeometrySink *geometrySink 
        ) CONST  
    {
        return Widen(strokeWidth, strokeStyle, &worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, geometrySink);
    }
}; // interface ID2D1Geometry


/// <summary>
/// Describes a two-dimensional rectangle.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a2-12e2-11dc-9fed-001143a055f9") ID2D1RectangleGeometry  : public ID2D1Geometry
{
    
    STDMETHOD_(void, GetRect)(
        _Out_ D2D1_RECT_F *rect 
        ) CONST PURE;
}; // interface ID2D1RectangleGeometry


/// <summary>
/// Describes a rounded rectangle.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a3-12e2-11dc-9fed-001143a055f9") ID2D1RoundedRectangleGeometry  : public ID2D1Geometry
{
    
    STDMETHOD_(void, GetRoundedRect)(
        _Out_ D2D1_ROUNDED_RECT *roundedRect 
        ) CONST PURE;
}; // interface ID2D1RoundedRectangleGeometry


/// <summary>
/// Represents an ellipse.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a4-12e2-11dc-9fed-001143a055f9") ID2D1EllipseGeometry  : public ID2D1Geometry
{
    
    STDMETHOD_(void, GetEllipse)(
        _Out_ D2D1_ELLIPSE *ellipse 
        ) CONST PURE;
}; // interface ID2D1EllipseGeometry


/// <summary>
/// Represents a composite geometry, composed of other ID2D1Geometry objects.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a6-12e2-11dc-9fed-001143a055f9") ID2D1GeometryGroup  : public ID2D1Geometry
{
    
    STDMETHOD_(D2D1_FILL_MODE, GetFillMode)(
        ) CONST PURE;
    
    STDMETHOD_(UINT32, GetSourceGeometryCount)(
        ) CONST PURE;
    
    STDMETHOD_(void, GetSourceGeometries)(
        _Out_writes_(geometriesCount) ID2D1Geometry **geometries,
        UINT32 geometriesCount 
        ) CONST PURE;
}; // interface ID2D1GeometryGroup


/// <summary>
/// Represents a geometry that has been transformed.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906bb-12e2-11dc-9fed-001143a055f9") ID2D1TransformedGeometry  : public ID2D1Geometry
{
    
    STDMETHOD_(void, GetSourceGeometry)(
        _Outptr_ ID2D1Geometry **sourceGeometry 
        ) CONST PURE;
    
    STDMETHOD_(void, GetTransform)(
        _Out_ D2D1_MATRIX_3X2_F *transform 
        ) CONST PURE;
}; // interface ID2D1TransformedGeometry


/// <summary>
/// Describes a geometric path that does not contain quadratic bezier curves or
/// arcs.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd9069e-12e2-11dc-9fed-001143a055f9") ID2D1SimplifiedGeometrySink  : public IUnknown
{
    
    STDMETHOD_(void, SetFillMode)(
        D2D1_FILL_MODE fillMode 
        ) PURE;
    
    STDMETHOD_(void, SetSegmentFlags)(
        D2D1_PATH_SEGMENT vertexFlags 
        ) PURE;
    
    STDMETHOD_(void, BeginFigure)(
        D2D1_POINT_2F startPoint,
        D2D1_FIGURE_BEGIN figureBegin 
        ) PURE;
    
    STDMETHOD_(void, AddLines)(
        _In_reads_(pointsCount) CONST D2D1_POINT_2F *points,
        UINT32 pointsCount 
        ) PURE;
    
    STDMETHOD_(void, AddBeziers)(
        _In_reads_(beziersCount) CONST D2D1_BEZIER_SEGMENT *beziers,
        UINT32 beziersCount 
        ) PURE;
    
    STDMETHOD_(void, EndFigure)(
        D2D1_FIGURE_END figureEnd 
        ) PURE;
    
    STDMETHOD(Close)(
        ) PURE;
}; // interface ID2D1SimplifiedGeometrySink


/// <summary>
/// Describes a geometric path that can contain lines, arcs, cubic Bezier curves,
/// and quadratic Bezier curves.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd9069f-12e2-11dc-9fed-001143a055f9") ID2D1GeometrySink  : public ID2D1SimplifiedGeometrySink
{
    
    STDMETHOD_(void, AddLine)(
        D2D1_POINT_2F point 
        ) PURE;
    
    STDMETHOD_(void, AddBezier)(
        _In_ CONST D2D1_BEZIER_SEGMENT *bezier 
        ) PURE;
    
    STDMETHOD_(void, AddQuadraticBezier)(
        _In_ CONST D2D1_QUADRATIC_BEZIER_SEGMENT *bezier 
        ) PURE;
    
    STDMETHOD_(void, AddQuadraticBeziers)(
        _In_reads_(beziersCount) CONST D2D1_QUADRATIC_BEZIER_SEGMENT *beziers,
        UINT32 beziersCount 
        ) PURE;
    
    STDMETHOD_(void, AddArc)(
        _In_ CONST D2D1_ARC_SEGMENT *arc 
        ) PURE;
    
    COM_DECLSPEC_NOTHROW
    void
    AddBezier(
        CONST D2D1_BEZIER_SEGMENT &bezier 
        )  
    {
        AddBezier(&bezier);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    AddQuadraticBezier(
        CONST D2D1_QUADRATIC_BEZIER_SEGMENT &bezier 
        )  
    {
        AddQuadraticBezier(&bezier);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    AddArc(
        CONST D2D1_ARC_SEGMENT &arc 
        )  
    {
        AddArc(&arc);
    }
}; // interface ID2D1GeometrySink


/// <summary>
/// Populates an ID2D1Mesh object with triangles.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906c1-12e2-11dc-9fed-001143a055f9") ID2D1TessellationSink  : public IUnknown
{
    
    STDMETHOD_(void, AddTriangles)(
        _In_reads_(trianglesCount) CONST D2D1_TRIANGLE *triangles,
        UINT32 trianglesCount 
        ) PURE;
    
    STDMETHOD(Close)(
        ) PURE;
}; // interface ID2D1TessellationSink


/// <summary>
/// Represents a complex shape that may be composed of arcs, curves, and lines.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906a5-12e2-11dc-9fed-001143a055f9") ID2D1PathGeometry  : public ID2D1Geometry
{
    
    /// <summary>
    /// Opens a geometry sink that will be used to create this path geometry.
    /// </summary>
    STDMETHOD(Open)(
        _COM_Outptr_ ID2D1GeometrySink **geometrySink 
        ) PURE;
    
    /// <summary>
    /// Retrieve the contents of this geometry. The caller passes an implementation of a
    /// ID2D1GeometrySink interface to receive the data.
    /// </summary>
    STDMETHOD(Stream)(
        _In_ ID2D1GeometrySink *geometrySink 
        ) CONST PURE;
    
    STDMETHOD(GetSegmentCount)(
        _Out_ UINT32 *count 
        ) CONST PURE;
    
    STDMETHOD(GetFigureCount)(
        _Out_ UINT32 *count 
        ) CONST PURE;
}; // interface ID2D1PathGeometry


/// <summary>
/// Represents a set of vertices that form a list of triangles.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd906c2-12e2-11dc-9fed-001143a055f9") ID2D1Mesh  : public ID2D1Resource
{
    
    /// <summary>
    /// Opens the mesh for population.
    /// </summary>
    STDMETHOD(Open)(
        _COM_Outptr_ ID2D1TessellationSink **tessellationSink 
        ) PURE;
}; // interface ID2D1Mesh


/// <summary>
/// Represents the backing store required to render a layer.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd9069b-12e2-11dc-9fed-001143a055f9") ID2D1Layer  : public ID2D1Resource
{
    
    STDMETHOD_(D2D1_SIZE_F, GetSize)(
        ) CONST PURE;
}; // interface ID2D1Layer


/// <summary>
/// Represents the drawing state of a render target: the antialiasing mode,
/// transform, tags, and text-rendering options.
/// </summary>
interface DX_DECLARE_INTERFACE("28506e39-ebf6-46a1-bb47-fd85565ab957") ID2D1DrawingStateBlock  : public ID2D1Resource
{
    
    /// <summary>
    /// Retrieves the state currently contained within this state block resource.
    /// </summary>
    STDMETHOD_(void, GetDescription)(
        _Out_ D2D1_DRAWING_STATE_DESCRIPTION *stateDescription 
        ) CONST PURE;
    
    /// <summary>
    /// Sets the state description of this state block resource.
    /// </summary>
    STDMETHOD_(void, SetDescription)(
        _In_ CONST D2D1_DRAWING_STATE_DESCRIPTION *stateDescription 
        ) PURE;
    
    /// <summary>
    /// Sets the text rendering parameters of this state block resource.
    /// </summary>
    STDMETHOD_(void, SetTextRenderingParams)(
        _In_opt_ IDWriteRenderingParams *textRenderingParams = NULL 
        ) PURE;
    
    /// <summary>
    /// Retrieves the text rendering parameters contained within this state block
    /// resource. If a NULL text rendering parameter was specified, NULL will be
    /// returned.
    /// </summary>
    STDMETHOD_(void, GetTextRenderingParams)(
        _Outptr_result_maybenull_ IDWriteRenderingParams **textRenderingParams 
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    void
    SetDescription(
        CONST D2D1_DRAWING_STATE_DESCRIPTION &stateDescription 
        )  
    {
        SetDescription(&stateDescription);
    }
}; // interface ID2D1DrawingStateBlock


/// <summary>
/// Represents an object that can receive drawing commands. Interfaces that inherit
/// from ID2D1RenderTarget render the drawing commands they receive in different
/// ways.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd90694-12e2-11dc-9fed-001143a055f9") ID2D1RenderTarget  : public ID2D1Resource
{
    
    /// <summary>
    /// Create a D2D bitmap by copying from memory, or create uninitialized.
    /// </summary>
    STDMETHOD(CreateBitmap)(
        D2D1_SIZE_U size,
        _In_opt_ CONST void *srcData,
        UINT32 pitch,
        _In_ CONST D2D1_BITMAP_PROPERTIES *bitmapProperties,
        _COM_Outptr_ ID2D1Bitmap **bitmap 
        ) PURE;
    
    /// <summary>
    /// Create a D2D bitmap by copying a WIC bitmap.
    /// </summary>
    STDMETHOD(CreateBitmapFromWicBitmap)(
        _In_ IWICBitmapSource *wicBitmapSource,
        _In_opt_ CONST D2D1_BITMAP_PROPERTIES *bitmapProperties,
        _COM_Outptr_ ID2D1Bitmap **bitmap 
        ) PURE;
    
    /// <summary>
    /// Create a D2D bitmap by sharing bits from another resource. The bitmap must be
    /// compatible with the render target for the call to succeed. For example, an
    /// IWICBitmap can be shared with a software target, or a DXGI surface can be shared
    /// with a DXGI render target.
    /// </summary>
    STDMETHOD(CreateSharedBitmap)(
        _In_ REFIID riid,
        _Inout_ void *data,
        _In_opt_ CONST D2D1_BITMAP_PROPERTIES *bitmapProperties,
        _COM_Outptr_ ID2D1Bitmap **bitmap 
        ) PURE;
    
    /// <summary>
    /// Creates a bitmap brush. The bitmap is scaled, rotated, skewed or tiled to fill
    /// or pen a geometry.
    /// </summary>
    STDMETHOD(CreateBitmapBrush)(
        _In_opt_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_BITMAP_BRUSH_PROPERTIES *bitmapBrushProperties,
        _In_opt_ CONST D2D1_BRUSH_PROPERTIES *brushProperties,
        _COM_Outptr_ ID2D1BitmapBrush **bitmapBrush 
        ) PURE;
    
    STDMETHOD(CreateSolidColorBrush)(
        _In_ CONST D2D1_COLOR_F *color,
        _In_opt_ CONST D2D1_BRUSH_PROPERTIES *brushProperties,
        _COM_Outptr_ ID2D1SolidColorBrush **solidColorBrush 
        ) PURE;
    
    /// <summary>
    /// A gradient stop collection represents a set of stops in an ideal unit length.
    /// This is the source resource for a linear gradient and radial gradient brush.
    /// </summary>
    /// <param name="colorInterpolationGamma">Specifies which space the color
    /// interpolation occurs in.</param>
    /// <param name="extendMode">Specifies how the gradient will be extended outside of
    /// the unit length.</param>
    STDMETHOD(CreateGradientStopCollection)(
        _In_reads_(gradientStopsCount) CONST D2D1_GRADIENT_STOP *gradientStops,
        _In_range_(>=,1) UINT32 gradientStopsCount,
        D2D1_GAMMA colorInterpolationGamma,
        D2D1_EXTEND_MODE extendMode,
        _COM_Outptr_ ID2D1GradientStopCollection **gradientStopCollection 
        ) PURE;
    
    STDMETHOD(CreateLinearGradientBrush)(
        _In_ CONST D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES *linearGradientBrushProperties,
        _In_opt_ CONST D2D1_BRUSH_PROPERTIES *brushProperties,
        _In_ ID2D1GradientStopCollection *gradientStopCollection,
        _COM_Outptr_ ID2D1LinearGradientBrush **linearGradientBrush 
        ) PURE;
    
    STDMETHOD(CreateRadialGradientBrush)(
        _In_ CONST D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES *radialGradientBrushProperties,
        _In_opt_ CONST D2D1_BRUSH_PROPERTIES *brushProperties,
        _In_ ID2D1GradientStopCollection *gradientStopCollection,
        _COM_Outptr_ ID2D1RadialGradientBrush **radialGradientBrush 
        ) PURE;
    
    /// <summary>
    /// Creates a bitmap render target whose bitmap can be used as a source for
    /// rendering in the API.
    /// </summary>
    /// <param name="desiredSize">The requested size of the target in DIPs. If the pixel
    /// size is not specified, the DPI is inherited from the parent target. However, the
    /// render target will never contain a fractional number of pixels.</param>
    /// <param name="desiredPixelSize">The requested size of the render target in
    /// pixels. If the DIP size is also specified, the DPI is calculated from these two
    /// values. If the desired size is not specified, the DPI is inherited from the
    /// parent render target. If neither value is specified, the compatible render
    /// target will be the same size and have the same DPI as the parent target.</param>
    /// <param name="desiredFormat">The desired pixel format. The format must be
    /// compatible with the parent render target type. If the format is not specified,
    /// it will be inherited from the parent render target.</param>
    /// <param name="options">Allows the caller to retrieve a GDI compatible render
    /// target.</param>
    /// <param name="bitmapRenderTarget">The returned bitmap render target.</param>
    STDMETHOD(CreateCompatibleRenderTarget)(
        _In_opt_ CONST D2D1_SIZE_F *desiredSize,
        _In_opt_ CONST D2D1_SIZE_U *desiredPixelSize,
        _In_opt_ CONST D2D1_PIXEL_FORMAT *desiredFormat,
        D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS options,
        _COM_Outptr_ ID2D1BitmapRenderTarget **bitmapRenderTarget 
        ) PURE;
    
    /// <summary>
    /// Creates a layer resource that can be used on any target and which will resize
    /// under the covers if necessary.
    /// </summary>
    /// <param name="size">The resolution independent minimum size hint for the layer
    /// resource. Specify this to prevent unwanted reallocation of the layer backing
    /// store. The size is in DIPs, but, it is unaffected by the current world
    /// transform. If the size is unspecified, the returned resource is a placeholder
    /// and the backing store will be allocated to be the minimum size that can hold the
    /// content when the layer is pushed.</param>
    STDMETHOD(CreateLayer)(
        _In_opt_ CONST D2D1_SIZE_F *size,
        _COM_Outptr_ ID2D1Layer **layer 
        ) PURE;
    
    /// <summary>
    /// Create a D2D mesh.
    /// </summary>
    STDMETHOD(CreateMesh)(
        _COM_Outptr_ ID2D1Mesh **mesh 
        ) PURE;
    
    STDMETHOD_(void, DrawLine)(
        D2D1_POINT_2F point0,
        D2D1_POINT_2F point1,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth = 1.0f,
        _In_opt_ ID2D1StrokeStyle *strokeStyle = NULL 
        ) PURE;
    
    STDMETHOD_(void, DrawRectangle)(
        _In_ CONST D2D1_RECT_F *rect,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth = 1.0f,
        _In_opt_ ID2D1StrokeStyle *strokeStyle = NULL 
        ) PURE;
    
    STDMETHOD_(void, FillRectangle)(
        _In_ CONST D2D1_RECT_F *rect,
        _In_ ID2D1Brush *brush 
        ) PURE;
    
    STDMETHOD_(void, DrawRoundedRectangle)(
        _In_ CONST D2D1_ROUNDED_RECT *roundedRect,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth = 1.0f,
        _In_opt_ ID2D1StrokeStyle *strokeStyle = NULL 
        ) PURE;
    
    STDMETHOD_(void, FillRoundedRectangle)(
        _In_ CONST D2D1_ROUNDED_RECT *roundedRect,
        _In_ ID2D1Brush *brush 
        ) PURE;
    
    STDMETHOD_(void, DrawEllipse)(
        _In_ CONST D2D1_ELLIPSE *ellipse,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth = 1.0f,
        _In_opt_ ID2D1StrokeStyle *strokeStyle = NULL 
        ) PURE;
    
    STDMETHOD_(void, FillEllipse)(
        _In_ CONST D2D1_ELLIPSE *ellipse,
        _In_ ID2D1Brush *brush 
        ) PURE;
    
    STDMETHOD_(void, DrawGeometry)(
        _In_ ID2D1Geometry *geometry,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth = 1.0f,
        _In_opt_ ID2D1StrokeStyle *strokeStyle = NULL 
        ) PURE;
    
    /// <param name="opacityBrush">An optionally specified opacity brush. Only the alpha
    /// channel of the corresponding brush will be sampled and will be applied to the
    /// entire fill of the geometry. If this brush is specified, the fill brush must be
    /// a bitmap brush with an extend mode of D2D1_EXTEND_MODE_CLAMP.</param>
    STDMETHOD_(void, FillGeometry)(
        _In_ ID2D1Geometry *geometry,
        _In_ ID2D1Brush *brush,
        _In_opt_ ID2D1Brush *opacityBrush = NULL 
        ) PURE;
    
    /// <summary>
    /// Fill a mesh. Since meshes can only render aliased content, the render target
    /// antialiasing mode must be set to aliased.
    /// </summary>
    STDMETHOD_(void, FillMesh)(
        _In_ ID2D1Mesh *mesh,
        _In_ ID2D1Brush *brush 
        ) PURE;
    
    /// <summary>
    /// Fill using the alpha channel of the supplied opacity mask bitmap. The brush
    /// opacity will be modulated by the mask. The render target antialiasing mode must
    /// be set to aliased.
    /// </summary>
    STDMETHOD_(void, FillOpacityMask)(
        _In_ ID2D1Bitmap *opacityMask,
        _In_ ID2D1Brush *brush,
        D2D1_OPACITY_MASK_CONTENT content,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle = NULL,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle = NULL 
        ) PURE;
    
    STDMETHOD_(void, DrawBitmap)(
        _In_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle = NULL,
        FLOAT opacity = 1.0f,
        D2D1_BITMAP_INTERPOLATION_MODE interpolationMode = D2D1_BITMAP_INTERPOLATION_MODE_LINEAR,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle = NULL 
        ) PURE;
    
    /// <summary>
    /// Draws the text within the given layout rectangle and by default also performs
    /// baseline snapping.
    /// </summary>
    STDMETHOD_(void, DrawText)(
        _In_reads_(stringLength) CONST WCHAR *string,
        UINT32 stringLength,
        _In_ IDWriteTextFormat *textFormat,
        _In_ CONST D2D1_RECT_F *layoutRect,
        _In_ ID2D1Brush *defaultFillBrush,
        D2D1_DRAW_TEXT_OPTIONS options = D2D1_DRAW_TEXT_OPTIONS_NONE,
        DWRITE_MEASURING_MODE measuringMode = DWRITE_MEASURING_MODE_NATURAL 
        ) PURE;
    
    /// <summary>
    /// Draw a text layout object. If the layout is not subsequently changed, this can
    /// be more efficient than DrawText when drawing the same layout repeatedly.
    /// </summary>
    /// <param name="options">The specified text options. If D2D1_DRAW_TEXT_OPTIONS_CLIP
    /// is used, the text is clipped to the layout bounds. These bounds are derived from
    /// the origin and the layout bounds of the corresponding IDWriteTextLayout object.
    /// </param>
    STDMETHOD_(void, DrawTextLayout)(
        D2D1_POINT_2F origin,
        _In_ IDWriteTextLayout *textLayout,
        _In_ ID2D1Brush *defaultFillBrush,
        D2D1_DRAW_TEXT_OPTIONS options = D2D1_DRAW_TEXT_OPTIONS_NONE 
        ) PURE;
    
    STDMETHOD_(void, DrawGlyphRun)(
        D2D1_POINT_2F baselineOrigin,
        _In_ CONST DWRITE_GLYPH_RUN *glyphRun,
        _In_ ID2D1Brush *foregroundBrush,
        DWRITE_MEASURING_MODE measuringMode = DWRITE_MEASURING_MODE_NATURAL 
        ) PURE;
    
    STDMETHOD_(void, SetTransform)(
        _In_ CONST D2D1_MATRIX_3X2_F *transform 
        ) PURE;
    
    STDMETHOD_(void, GetTransform)(
        _Out_ D2D1_MATRIX_3X2_F *transform 
        ) CONST PURE;
    
    STDMETHOD_(void, SetAntialiasMode)(
        D2D1_ANTIALIAS_MODE antialiasMode 
        ) PURE;
    
    STDMETHOD_(D2D1_ANTIALIAS_MODE, GetAntialiasMode)(
        ) CONST PURE;
    
    STDMETHOD_(void, SetTextAntialiasMode)(
        D2D1_TEXT_ANTIALIAS_MODE textAntialiasMode 
        ) PURE;
    
    STDMETHOD_(D2D1_TEXT_ANTIALIAS_MODE, GetTextAntialiasMode)(
        ) CONST PURE;
    
    STDMETHOD_(void, SetTextRenderingParams)(
        _In_opt_ IDWriteRenderingParams *textRenderingParams = NULL 
        ) PURE;
    
    /// <summary>
    /// Retrieve the text render parameters. NOTE: If NULL is specified to
    /// SetTextRenderingParameters, NULL will be returned.
    /// </summary>
    STDMETHOD_(void, GetTextRenderingParams)(
        _Outptr_result_maybenull_ IDWriteRenderingParams **textRenderingParams 
        ) CONST PURE;
    
    /// <summary>
    /// Set a tag to correspond to the succeeding primitives. If an error occurs
    /// rendering a primitive, the tags can be returned from the Flush or EndDraw call.
    /// </summary>
    STDMETHOD_(void, SetTags)(
        D2D1_TAG tag1,
        D2D1_TAG tag2 
        ) PURE;
    
    /// <summary>
    /// Retrieves the currently set tags. This does not retrieve the tags corresponding
    /// to any primitive that is in error.
    /// </summary>
    STDMETHOD_(void, GetTags)(
        _Out_opt_ D2D1_TAG *tag1 = NULL,
        _Out_opt_ D2D1_TAG *tag2 = NULL 
        ) CONST PURE;
    
    /// <summary>
    /// Start a layer of drawing calls. The way in which the layer must be resolved is
    /// specified first as well as the logical resource that stores the layer
    /// parameters. The supplied layer resource might grow if the specified content
    /// cannot fit inside it. The layer will grow monotonically on each axis.  If a NULL
    /// ID2D1Layer is provided, then a layer resource will be allocated automatically.
    /// </summary>
    STDMETHOD_(void, PushLayer)(
        _In_ CONST D2D1_LAYER_PARAMETERS *layerParameters,
        _In_opt_ ID2D1Layer *layer 
        ) PURE;
    
    /// <summary>
    /// Ends a layer that was defined with particular layer resources.
    /// </summary>
    STDMETHOD_(void, PopLayer)(
        ) PURE;
    
    STDMETHOD(Flush)(
        _Out_opt_ D2D1_TAG *tag1 = NULL,
        _Out_opt_ D2D1_TAG *tag2 = NULL 
        ) PURE;
    
    /// <summary>
    /// Gets the current drawing state and saves it into the supplied
    /// IDrawingStatckBlock.
    /// </summary>
    STDMETHOD_(void, SaveDrawingState)(
        _Inout_ ID2D1DrawingStateBlock *drawingStateBlock 
        ) CONST PURE;
    
    /// <summary>
    /// Copies the state stored in the block interface.
    /// </summary>
    STDMETHOD_(void, RestoreDrawingState)(
        _In_ ID2D1DrawingStateBlock *drawingStateBlock 
        ) PURE;
    
    /// <summary>
    /// Pushes a clip. The clip can be antialiased. The clip must be axis aligned. If
    /// the current world transform is not axis preserving, then the bounding box of the
    /// transformed clip rect will be used. The clip will remain in effect until a
    /// PopAxisAligned clip call is made.
    /// </summary>
    STDMETHOD_(void, PushAxisAlignedClip)(
        _In_ CONST D2D1_RECT_F *clipRect,
        D2D1_ANTIALIAS_MODE antialiasMode 
        ) PURE;
    
    STDMETHOD_(void, PopAxisAlignedClip)(
        ) PURE;
    
    STDMETHOD_(void, Clear)(
        _In_opt_ CONST D2D1_COLOR_F *clearColor = NULL 
        ) PURE;
    
    /// <summary>
    /// Start drawing on this render target. Draw calls can only be issued between a
    /// BeginDraw and EndDraw call.
    /// </summary>
    STDMETHOD_(void, BeginDraw)(
        ) PURE;
    
    /// <summary>
    /// Ends drawing on the render target, error results can be retrieved at this time,
    /// or when calling flush.
    /// </summary>
    STDMETHOD(EndDraw)(
        _Out_opt_ D2D1_TAG *tag1 = NULL,
        _Out_opt_ D2D1_TAG *tag2 = NULL 
        ) PURE;
    
    STDMETHOD_(D2D1_PIXEL_FORMAT, GetPixelFormat)(
        ) CONST PURE;
    
    /// <summary>
    /// Sets the DPI on the render target. This results in the render target being
    /// interpreted to a different scale. Neither DPI can be negative. If zero is
    /// specified for both, the system DPI is chosen. If one is zero and the other
    /// unspecified, the DPI is not changed.
    /// </summary>
    STDMETHOD_(void, SetDpi)(
        FLOAT dpiX,
        FLOAT dpiY 
        ) PURE;
    
    /// <summary>
    /// Return the current DPI from the target.
    /// </summary>
    STDMETHOD_(void, GetDpi)(
        _Out_ FLOAT *dpiX,
        _Out_ FLOAT *dpiY 
        ) CONST PURE;
    
    /// <summary>
    /// Returns the size of the render target in DIPs.
    /// </summary>
    STDMETHOD_(D2D1_SIZE_F, GetSize)(
        ) CONST PURE;
    
    /// <summary>
    /// Returns the size of the render target in pixels.
    /// </summary>
    STDMETHOD_(D2D1_SIZE_U, GetPixelSize)(
        ) CONST PURE;
    
    /// <summary>
    /// Returns the maximum bitmap and render target size that is guaranteed to be
    /// supported by the render target.
    /// </summary>
    STDMETHOD_(UINT32, GetMaximumBitmapSize)(
        ) CONST PURE;
    
    /// <summary>
    /// Returns true if the given properties are supported by this render target. The
    /// DPI is ignored. NOTE: If the render target type is software, then neither
    /// D2D1_FEATURE_LEVEL_9 nor D2D1_FEATURE_LEVEL_10 will be considered to be
    /// supported.
    /// </summary>
    STDMETHOD_(BOOL, IsSupported)(
        _In_ CONST D2D1_RENDER_TARGET_PROPERTIES *renderTargetProperties 
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmap(
        D2D1_SIZE_U size,
        _In_opt_ CONST void *srcData,
        UINT32 pitch,
        CONST D2D1_BITMAP_PROPERTIES &bitmapProperties,
        _COM_Outptr_ ID2D1Bitmap **bitmap 
        )  
    {
        return CreateBitmap(size, srcData, pitch, &bitmapProperties, bitmap);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmap(
        D2D1_SIZE_U size,
        CONST D2D1_BITMAP_PROPERTIES &bitmapProperties,
        _COM_Outptr_ ID2D1Bitmap **bitmap 
        )  
    {
        return CreateBitmap(size, NULL, 0, &bitmapProperties, bitmap);
    }
    
    /// <summary>
    /// Create a D2D bitmap by copying a WIC bitmap.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapFromWicBitmap(
        _In_ IWICBitmapSource *wicBitmapSource,
        CONST D2D1_BITMAP_PROPERTIES &bitmapProperties,
        _COM_Outptr_ ID2D1Bitmap **bitmap 
        )  
    {
        return CreateBitmapFromWicBitmap(wicBitmapSource, &bitmapProperties, bitmap);
    }
    
    /// <summary>
    /// Create a D2D bitmap by copying a WIC bitmap.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapFromWicBitmap(
        _In_ IWICBitmapSource *wicBitmapSource,
        _COM_Outptr_ ID2D1Bitmap **bitmap 
        )  
    {
        return CreateBitmapFromWicBitmap(wicBitmapSource, NULL, bitmap);
    }
    
    /// <summary>
    /// Creates a bitmap brush. The bitmap is scaled, rotated, skewed or tiled to fill
    /// or pen a geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapBrush(
        _In_opt_ ID2D1Bitmap *bitmap,
        _COM_Outptr_ ID2D1BitmapBrush **bitmapBrush 
        )  
    {
        return CreateBitmapBrush(bitmap, NULL, NULL, bitmapBrush);
    }
    
    /// <summary>
    /// Creates a bitmap brush. The bitmap is scaled, rotated, skewed or tiled to fill
    /// or pen a geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapBrush(
        _In_opt_ ID2D1Bitmap *bitmap,
        CONST D2D1_BITMAP_BRUSH_PROPERTIES &bitmapBrushProperties,
        _COM_Outptr_ ID2D1BitmapBrush **bitmapBrush 
        )  
    {
        return CreateBitmapBrush(bitmap, &bitmapBrushProperties, NULL, bitmapBrush);
    }
    
    /// <summary>
    /// Creates a bitmap brush. The bitmap is scaled, rotated, skewed or tiled to fill
    /// or pen a geometry.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapBrush(
        _In_opt_ ID2D1Bitmap *bitmap,
        CONST D2D1_BITMAP_BRUSH_PROPERTIES &bitmapBrushProperties,
        CONST D2D1_BRUSH_PROPERTIES &brushProperties,
        _COM_Outptr_ ID2D1BitmapBrush **bitmapBrush 
        )  
    {
        return CreateBitmapBrush(bitmap, &bitmapBrushProperties, &brushProperties, bitmapBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateSolidColorBrush(
        CONST D2D1_COLOR_F &color,
        _COM_Outptr_ ID2D1SolidColorBrush **solidColorBrush 
        )  
    {
        return CreateSolidColorBrush(&color, NULL, solidColorBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateSolidColorBrush(
        CONST D2D1_COLOR_F &color,
        CONST D2D1_BRUSH_PROPERTIES &brushProperties,
        _COM_Outptr_ ID2D1SolidColorBrush **solidColorBrush 
        )  
    {
        return CreateSolidColorBrush(&color, &brushProperties, solidColorBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateGradientStopCollection(
        _In_reads_(gradientStopsCount) CONST D2D1_GRADIENT_STOP *gradientStops,
        UINT32 gradientStopsCount,
        _COM_Outptr_ ID2D1GradientStopCollection **gradientStopCollection 
        )  
    {
        return CreateGradientStopCollection(gradientStops, gradientStopsCount, D2D1_GAMMA_2_2, D2D1_EXTEND_MODE_CLAMP, gradientStopCollection);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateLinearGradientBrush(
        CONST D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES &linearGradientBrushProperties,
        _In_ ID2D1GradientStopCollection *gradientStopCollection,
        _COM_Outptr_ ID2D1LinearGradientBrush **linearGradientBrush 
        )  
    {
        return CreateLinearGradientBrush(&linearGradientBrushProperties, NULL, gradientStopCollection, linearGradientBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateLinearGradientBrush(
        CONST D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES &linearGradientBrushProperties,
        CONST D2D1_BRUSH_PROPERTIES &brushProperties,
        _In_ ID2D1GradientStopCollection *gradientStopCollection,
        _COM_Outptr_ ID2D1LinearGradientBrush **linearGradientBrush 
        )  
    {
        return CreateLinearGradientBrush(&linearGradientBrushProperties, &brushProperties, gradientStopCollection, linearGradientBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateRadialGradientBrush(
        CONST D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES &radialGradientBrushProperties,
        _In_ ID2D1GradientStopCollection *gradientStopCollection,
        _COM_Outptr_ ID2D1RadialGradientBrush **radialGradientBrush 
        )  
    {
        return CreateRadialGradientBrush(&radialGradientBrushProperties, NULL, gradientStopCollection, radialGradientBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateRadialGradientBrush(
        CONST D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES &radialGradientBrushProperties,
        CONST D2D1_BRUSH_PROPERTIES &brushProperties,
        _In_ ID2D1GradientStopCollection *gradientStopCollection,
        _COM_Outptr_ ID2D1RadialGradientBrush **radialGradientBrush 
        )  
    {
        return CreateRadialGradientBrush(&radialGradientBrushProperties, &brushProperties, gradientStopCollection, radialGradientBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateCompatibleRenderTarget(
        _COM_Outptr_ ID2D1BitmapRenderTarget **bitmapRenderTarget 
        )  
    {
        return CreateCompatibleRenderTarget(NULL, NULL, NULL, D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_NONE, bitmapRenderTarget);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateCompatibleRenderTarget(
        D2D1_SIZE_F desiredSize,
        _COM_Outptr_ ID2D1BitmapRenderTarget **bitmapRenderTarget 
        )  
    {
        return CreateCompatibleRenderTarget(&desiredSize, NULL, NULL, D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_NONE, bitmapRenderTarget);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateCompatibleRenderTarget(
        D2D1_SIZE_F desiredSize,
        D2D1_SIZE_U desiredPixelSize,
        _COM_Outptr_ ID2D1BitmapRenderTarget **bitmapRenderTarget 
        )  
    {
        return CreateCompatibleRenderTarget(&desiredSize, &desiredPixelSize, NULL, D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_NONE, bitmapRenderTarget);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateCompatibleRenderTarget(
        D2D1_SIZE_F desiredSize,
        D2D1_SIZE_U desiredPixelSize,
        D2D1_PIXEL_FORMAT desiredFormat,
        _COM_Outptr_ ID2D1BitmapRenderTarget **bitmapRenderTarget 
        )  
    {
        return CreateCompatibleRenderTarget(&desiredSize, &desiredPixelSize, &desiredFormat, D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_NONE, bitmapRenderTarget);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateCompatibleRenderTarget(
        D2D1_SIZE_F desiredSize,
        D2D1_SIZE_U desiredPixelSize,
        D2D1_PIXEL_FORMAT desiredFormat,
        D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS options,
        _COM_Outptr_ ID2D1BitmapRenderTarget **bitmapRenderTarget 
        )  
    {
        return CreateCompatibleRenderTarget(&desiredSize, &desiredPixelSize, &desiredFormat, options, bitmapRenderTarget);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateLayer(
        D2D1_SIZE_F size,
        _COM_Outptr_ ID2D1Layer **layer 
        )  
    {
        return CreateLayer(&size, layer);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateLayer(
        _COM_Outptr_ ID2D1Layer **layer 
        )  
    {
        return CreateLayer(NULL, layer);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawRectangle(
        CONST D2D1_RECT_F &rect,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth = 1.0f,
        _In_opt_ ID2D1StrokeStyle *strokeStyle = NULL 
        )  
    {
        DrawRectangle(&rect, brush, strokeWidth, strokeStyle);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    FillRectangle(
        CONST D2D1_RECT_F &rect,
        _In_ ID2D1Brush *brush 
        )  
    {
        FillRectangle(&rect, brush);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawRoundedRectangle(
        CONST D2D1_ROUNDED_RECT &roundedRect,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth = 1.0f,
        _In_opt_ ID2D1StrokeStyle *strokeStyle = NULL 
        )  
    {
        DrawRoundedRectangle(&roundedRect, brush, strokeWidth, strokeStyle);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    FillRoundedRectangle(
        CONST D2D1_ROUNDED_RECT &roundedRect,
        _In_ ID2D1Brush *brush 
        )  
    {
        FillRoundedRectangle(&roundedRect, brush);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawEllipse(
        CONST D2D1_ELLIPSE &ellipse,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth = 1.0f,
        _In_opt_ ID2D1StrokeStyle *strokeStyle = NULL 
        )  
    {
        DrawEllipse(&ellipse, brush, strokeWidth, strokeStyle);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    FillEllipse(
        CONST D2D1_ELLIPSE &ellipse,
        _In_ ID2D1Brush *brush 
        )  
    {
        FillEllipse(&ellipse, brush);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    FillOpacityMask(
        _In_ ID2D1Bitmap *opacityMask,
        _In_ ID2D1Brush *brush,
        D2D1_OPACITY_MASK_CONTENT content,
        CONST D2D1_RECT_F &destinationRectangle,
        CONST D2D1_RECT_F &sourceRectangle 
        )  
    {
        FillOpacityMask(opacityMask, brush, content, &destinationRectangle, &sourceRectangle);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawBitmap(
        _In_ ID2D1Bitmap *bitmap,
        CONST D2D1_RECT_F &destinationRectangle,
        FLOAT opacity = 1.0f,
        D2D1_BITMAP_INTERPOLATION_MODE interpolationMode = D2D1_BITMAP_INTERPOLATION_MODE_LINEAR,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle = NULL 
        )  
    {
        DrawBitmap(bitmap, &destinationRectangle, opacity, interpolationMode, sourceRectangle);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawBitmap(
        _In_ ID2D1Bitmap *bitmap,
        CONST D2D1_RECT_F &destinationRectangle,
        FLOAT opacity,
        D2D1_BITMAP_INTERPOLATION_MODE interpolationMode,
        CONST D2D1_RECT_F &sourceRectangle 
        )  
    {
        DrawBitmap(bitmap, &destinationRectangle, opacity, interpolationMode, &sourceRectangle);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    SetTransform(
        CONST D2D1_MATRIX_3X2_F &transform 
        )  
    {
        SetTransform(&transform);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    PushLayer(
        CONST D2D1_LAYER_PARAMETERS &layerParameters,
        _In_opt_ ID2D1Layer *layer 
        )  
    {
        PushLayer(&layerParameters, layer);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    PushAxisAlignedClip(
        CONST D2D1_RECT_F &clipRect,
        D2D1_ANTIALIAS_MODE antialiasMode 
        )  
    {
        return PushAxisAlignedClip(&clipRect, antialiasMode);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    Clear(
        CONST D2D1_COLOR_F &clearColor 
        )  
    {
        return Clear(&clearColor);
    }
    
    /// <summary>
    /// Draws the text within the given layout rectangle and by default also performs
    /// baseline snapping.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    void
    DrawText(
        _In_reads_(stringLength) CONST WCHAR *string,
        UINT32 stringLength,
        _In_ IDWriteTextFormat *textFormat,
        CONST D2D1_RECT_F &layoutRect,
        _In_ ID2D1Brush *defaultFillBrush,
        D2D1_DRAW_TEXT_OPTIONS options = D2D1_DRAW_TEXT_OPTIONS_NONE,
        DWRITE_MEASURING_MODE measuringMode = DWRITE_MEASURING_MODE_NATURAL 
        )  
    {
        return DrawText(string, stringLength, textFormat, &layoutRect, defaultFillBrush, options, measuringMode);
    }
    
    COM_DECLSPEC_NOTHROW
    BOOL
    IsSupported(
        CONST D2D1_RENDER_TARGET_PROPERTIES &renderTargetProperties 
        ) CONST  
    {
        return IsSupported(&renderTargetProperties);
    }
}; // interface ID2D1RenderTarget


/// <summary>
/// Renders to an intermediate texture created by the CreateCompatibleRenderTarget
/// method.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd90695-12e2-11dc-9fed-001143a055f9") ID2D1BitmapRenderTarget  : public ID2D1RenderTarget
{
    
    STDMETHOD(GetBitmap)(
        _COM_Outptr_ ID2D1Bitmap **bitmap 
        ) PURE;
}; // interface ID2D1BitmapRenderTarget


/// <summary>
/// Renders drawing instructions to a window.
/// </summary>
interface DX_DECLARE_INTERFACE("2cd90698-12e2-11dc-9fed-001143a055f9") ID2D1HwndRenderTarget  : public ID2D1RenderTarget
{
    
    STDMETHOD_(D2D1_WINDOW_STATE, CheckWindowState)(
        ) PURE;
    
    /// <summary>
    /// Resize the buffer underlying the render target. This operation might fail if
    /// there is insufficient video memory or system memory, or if the render target is
    /// resized beyond the maximum bitmap size. If the method fails, the render target
    /// will be placed in a zombie state and D2DERR_RECREATE_TARGET will be returned
    /// from it when EndDraw is called. In addition an appropriate failure result will
    /// be returned from Resize.
    /// </summary>
    STDMETHOD(Resize)(
        _In_ CONST D2D1_SIZE_U *pixelSize 
        ) PURE;
    
    STDMETHOD_(HWND, GetHwnd)(
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    Resize(
        CONST D2D1_SIZE_U &pixelSize 
        )  
    {
        return Resize(&pixelSize);
    }
}; // interface ID2D1HwndRenderTarget



#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

/// <summary>
/// Provides access to an device context that can accept GDI drawing commands.
/// </summary>
interface DX_DECLARE_INTERFACE("e0db51c3-6f77-4bae-b3d5-e47509b35838") ID2D1GdiInteropRenderTarget  : public IUnknown
{
    
    STDMETHOD(GetDC)(
        D2D1_DC_INITIALIZE_MODE mode,
        _Out_ HDC *hdc 
        ) PURE;
    
    STDMETHOD(ReleaseDC)(
        _In_opt_ CONST RECT *update 
        ) PURE;
}; // interface ID2D1GdiInteropRenderTarget



#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

/// <summary>
/// Issues drawing commands to a GDI device context.
/// </summary>
interface DX_DECLARE_INTERFACE("1c51bc64-de61-46fd-9899-63a5d8f03950") ID2D1DCRenderTarget  : public ID2D1RenderTarget
{
    
    STDMETHOD(BindDC)(
        _In_ CONST HDC hDC,
        _In_ CONST RECT *pSubRect 
        ) PURE;
}; // interface ID2D1DCRenderTarget


/// <summary>
/// The root factory interface for all of D2D's objects.
/// </summary>
interface DX_DECLARE_INTERFACE("06152247-6f50-465a-9245-118bfd3b6007") ID2D1Factory  : public IUnknown
{
    
    /// <summary>
    /// Cause the factory to refresh any system metrics that it might have been snapped
    /// on factory creation.
    /// </summary>
    STDMETHOD(ReloadSystemMetrics)(
        ) PURE;
    
    /// <summary>
    /// Retrieves the current desktop DPI. To refresh this, call ReloadSystemMetrics.
    /// </summary>
    [[deprecated("Deprecated. Use DisplayInformation::LogicalDpi for Windows Store Apps or GetDpiForWindow for desktop apps.")]]
    STDMETHOD_(void, GetDesktopDpi)(
        _Out_ FLOAT *dpiX,
        _Out_ FLOAT *dpiY 
        ) PURE;
    
    STDMETHOD(CreateRectangleGeometry)(
        _In_ CONST D2D1_RECT_F *rectangle,
        _COM_Outptr_ ID2D1RectangleGeometry **rectangleGeometry 
        ) PURE;
    
    STDMETHOD(CreateRoundedRectangleGeometry)(
        _In_ CONST D2D1_ROUNDED_RECT *roundedRectangle,
        _COM_Outptr_ ID2D1RoundedRectangleGeometry **roundedRectangleGeometry 
        ) PURE;
    
    STDMETHOD(CreateEllipseGeometry)(
        _In_ CONST D2D1_ELLIPSE *ellipse,
        _COM_Outptr_ ID2D1EllipseGeometry **ellipseGeometry 
        ) PURE;
    
    /// <summary>
    /// Create a geometry which holds other geometries.
    /// </summary>
    STDMETHOD(CreateGeometryGroup)(
        D2D1_FILL_MODE fillMode,
        _In_reads_(geometriesCount) ID2D1Geometry **geometries,
        UINT32 geometriesCount,
        _COM_Outptr_ ID2D1GeometryGroup **geometryGroup 
        ) PURE;
    
    STDMETHOD(CreateTransformedGeometry)(
        _In_ ID2D1Geometry *sourceGeometry,
        _In_ CONST D2D1_MATRIX_3X2_F *transform,
        _COM_Outptr_ ID2D1TransformedGeometry **transformedGeometry 
        ) PURE;
    
    /// <summary>
    /// Returns an initially empty path geometry interface. A geometry sink is created
    /// off the interface to populate it.
    /// </summary>
    STDMETHOD(CreatePathGeometry)(
        _COM_Outptr_ ID2D1PathGeometry **pathGeometry 
        ) PURE;
    
    /// <summary>
    /// Allows a non-default stroke style to be specified for a given geometry at draw
    /// time.
    /// </summary>
    STDMETHOD(CreateStrokeStyle)(
        _In_ CONST D2D1_STROKE_STYLE_PROPERTIES *strokeStyleProperties,
        _In_reads_opt_(dashesCount) CONST FLOAT *dashes,
        UINT32 dashesCount,
        _COM_Outptr_ ID2D1StrokeStyle **strokeStyle 
        ) PURE;
    
    /// <summary>
    /// Creates a new drawing state block, this can be used in subsequent
    /// SaveDrawingState and RestoreDrawingState operations on the render target.
    /// </summary>
    STDMETHOD(CreateDrawingStateBlock)(
        _In_opt_ CONST D2D1_DRAWING_STATE_DESCRIPTION *drawingStateDescription,
        _In_opt_ IDWriteRenderingParams *textRenderingParams,
        _COM_Outptr_ ID2D1DrawingStateBlock **drawingStateBlock 
        ) PURE;
    
    /// <summary>
    /// Creates a render target which is a source of bitmaps.
    /// </summary>
    STDMETHOD(CreateWicBitmapRenderTarget)(
        _In_ IWICBitmap *target,
        _In_ CONST D2D1_RENDER_TARGET_PROPERTIES *renderTargetProperties,
        _COM_Outptr_ ID2D1RenderTarget **renderTarget 
        ) PURE;
    
    /// <summary>
    /// Creates a render target that appears on the display.
    /// </summary>
    STDMETHOD(CreateHwndRenderTarget)(
        _In_ CONST D2D1_RENDER_TARGET_PROPERTIES *renderTargetProperties,
        _In_ CONST D2D1_HWND_RENDER_TARGET_PROPERTIES *hwndRenderTargetProperties,
        _COM_Outptr_ ID2D1HwndRenderTarget **hwndRenderTarget 
        ) PURE;
    
    /// <summary>
    /// Creates a render target that draws to a DXGI Surface. The device that owns the
    /// surface is used for rendering.
    /// </summary>
    STDMETHOD(CreateDxgiSurfaceRenderTarget)(
        _In_ IDXGISurface *dxgiSurface,
        _In_ CONST D2D1_RENDER_TARGET_PROPERTIES *renderTargetProperties,
        _COM_Outptr_ ID2D1RenderTarget **renderTarget 
        ) PURE;
    
    /// <summary>
    /// Creates a render target that draws to a GDI device context.
    /// </summary>
    STDMETHOD(CreateDCRenderTarget)(
        _In_ CONST D2D1_RENDER_TARGET_PROPERTIES *renderTargetProperties,
        _COM_Outptr_ ID2D1DCRenderTarget **dcRenderTarget 
        ) PURE;
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateRectangleGeometry(
        CONST D2D1_RECT_F &rectangle,
        _COM_Outptr_ ID2D1RectangleGeometry **rectangleGeometry 
        )  
    {
        return CreateRectangleGeometry(&rectangle, rectangleGeometry);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateRoundedRectangleGeometry(
        CONST D2D1_ROUNDED_RECT &roundedRectangle,
        _COM_Outptr_ ID2D1RoundedRectangleGeometry **roundedRectangleGeometry 
        )  
    {
        return CreateRoundedRectangleGeometry(&roundedRectangle, roundedRectangleGeometry);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateEllipseGeometry(
        CONST D2D1_ELLIPSE &ellipse,
        _COM_Outptr_ ID2D1EllipseGeometry **ellipseGeometry 
        )  
    {
        return CreateEllipseGeometry(&ellipse, ellipseGeometry);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateTransformedGeometry(
        _In_ ID2D1Geometry *sourceGeometry,
        CONST D2D1_MATRIX_3X2_F &transform,
        _COM_Outptr_ ID2D1TransformedGeometry **transformedGeometry 
        )  
    {
        return CreateTransformedGeometry(sourceGeometry, &transform, transformedGeometry);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateStrokeStyle(
        CONST D2D1_STROKE_STYLE_PROPERTIES &strokeStyleProperties,
        _In_reads_opt_(dashesCount) CONST FLOAT *dashes,
        UINT32 dashesCount,
        _COM_Outptr_ ID2D1StrokeStyle **strokeStyle 
        )  
    {
        return CreateStrokeStyle(&strokeStyleProperties, dashes, dashesCount, strokeStyle);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateDrawingStateBlock(
        CONST D2D1_DRAWING_STATE_DESCRIPTION &drawingStateDescription,
        _COM_Outptr_ ID2D1DrawingStateBlock **drawingStateBlock 
        )  
    {
        return CreateDrawingStateBlock(&drawingStateDescription, NULL, drawingStateBlock);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateDrawingStateBlock(
        _COM_Outptr_ ID2D1DrawingStateBlock **drawingStateBlock 
        )  
    {
        return CreateDrawingStateBlock(NULL, NULL, drawingStateBlock);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateWicBitmapRenderTarget(
        _In_ IWICBitmap *target,
        CONST D2D1_RENDER_TARGET_PROPERTIES &renderTargetProperties,
        _COM_Outptr_ ID2D1RenderTarget **renderTarget 
        )  
    {
        return CreateWicBitmapRenderTarget(target, &renderTargetProperties, renderTarget);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateHwndRenderTarget(
        CONST D2D1_RENDER_TARGET_PROPERTIES &renderTargetProperties,
        CONST D2D1_HWND_RENDER_TARGET_PROPERTIES &hwndRenderTargetProperties,
        _COM_Outptr_ ID2D1HwndRenderTarget **hwndRenderTarget 
        )  
    {
        return CreateHwndRenderTarget(&renderTargetProperties, &hwndRenderTargetProperties, hwndRenderTarget);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateDxgiSurfaceRenderTarget(
        _In_ IDXGISurface *dxgiSurface,
        CONST D2D1_RENDER_TARGET_PROPERTIES &renderTargetProperties,
        _COM_Outptr_ ID2D1RenderTarget **renderTarget 
        )  
    {
        return CreateDxgiSurfaceRenderTarget(dxgiSurface, &renderTargetProperties, renderTarget);
    }
}; // interface ID2D1Factory



#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion


#endif


#ifdef D2D_USE_C_DEFINITIONS


#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

typedef interface ID2D1Resource ID2D1Resource;

typedef interface ID2D1Image ID2D1Image;

typedef interface ID2D1Bitmap ID2D1Bitmap;

typedef interface ID2D1GradientStopCollection ID2D1GradientStopCollection;

typedef interface ID2D1Brush ID2D1Brush;

typedef interface ID2D1BitmapBrush ID2D1BitmapBrush;

typedef interface ID2D1SolidColorBrush ID2D1SolidColorBrush;

typedef interface ID2D1LinearGradientBrush ID2D1LinearGradientBrush;

typedef interface ID2D1RadialGradientBrush ID2D1RadialGradientBrush;

typedef interface ID2D1StrokeStyle ID2D1StrokeStyle;

typedef interface ID2D1Geometry ID2D1Geometry;

typedef interface ID2D1RectangleGeometry ID2D1RectangleGeometry;

typedef interface ID2D1RoundedRectangleGeometry ID2D1RoundedRectangleGeometry;

typedef interface ID2D1EllipseGeometry ID2D1EllipseGeometry;

typedef interface ID2D1GeometryGroup ID2D1GeometryGroup;

typedef interface ID2D1TransformedGeometry ID2D1TransformedGeometry;

typedef interface ID2D1SimplifiedGeometrySink ID2D1SimplifiedGeometrySink;

typedef interface ID2D1GeometrySink ID2D1GeometrySink;

typedef interface ID2D1TessellationSink ID2D1TessellationSink;

typedef interface ID2D1PathGeometry ID2D1PathGeometry;

typedef interface ID2D1Mesh ID2D1Mesh;

typedef interface ID2D1Layer ID2D1Layer;

typedef interface ID2D1DrawingStateBlock ID2D1DrawingStateBlock;

typedef interface ID2D1RenderTarget ID2D1RenderTarget;

typedef interface ID2D1BitmapRenderTarget ID2D1BitmapRenderTarget;

typedef interface ID2D1HwndRenderTarget ID2D1HwndRenderTarget;

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)

typedef interface ID2D1GdiInteropRenderTarget ID2D1GdiInteropRenderTarget;

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

typedef interface ID2D1DCRenderTarget ID2D1DCRenderTarget;

typedef interface ID2D1Factory ID2D1Factory;

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion


#endif


#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)           
           
#ifdef __cplusplus
extern "C"
{
#endif

    //
    // This export cannot be in a namespace because compiler name mangling isn't consistent
    // also, this must be 'C' callable.
    //
    HRESULT WINAPI
    D2D1CreateFactory(
        _In_ D2D1_FACTORY_TYPE factoryType,
        _In_ REFIID riid,
        _In_opt_ CONST D2D1_FACTORY_OPTIONS *pFactoryOptions,
        _Out_ void **ppIFactory
        );


    void WINAPI
    D2D1MakeRotateMatrix(
        _In_ FLOAT angle,
        _In_ D2D1_POINT_2F center,
        _Out_ D2D1_MATRIX_3X2_F *matrix
        );

    void WINAPI
    D2D1MakeSkewMatrix(
        _In_ FLOAT angleX,
        _In_ FLOAT angleY,
        _In_ D2D1_POINT_2F center,
        _Out_ D2D1_MATRIX_3X2_F *matrix
        );

    BOOL WINAPI
    D2D1IsMatrixInvertible(
        _In_ CONST D2D1_MATRIX_3X2_F *matrix
        );

    BOOL WINAPI
    D2D1InvertMatrix(
        _Inout_ D2D1_MATRIX_3X2_F *matrix
        );

#ifdef __cplusplus
}
#endif

#ifndef D2D1FORCEINLINE
#define D2D1FORCEINLINE FORCEINLINE
#endif // #ifndef D2D1FORCEINLINE

        
#include <d2d1helper.h>


#ifndef D2D_USE_C_DEFINITIONS

COM_DECLSPEC_NOTHROW
inline
HRESULT
D2D1CreateFactory(
    _In_ D2D1_FACTORY_TYPE factoryType,
    _In_ REFIID riid,
    _Out_ void **factory
    )
{
    return
        D2D1CreateFactory(
            factoryType,
            riid,
            NULL,
            factory);
}


template<class Factory>
COM_DECLSPEC_NOTHROW
HRESULT
D2D1CreateFactory(
    _In_ D2D1_FACTORY_TYPE factoryType,
    _Out_ Factory **factory
    )
{
    return
        D2D1CreateFactory(
            factoryType,
            __uuidof(Factory),
            reinterpret_cast<void **>(factory));
}

template<class Factory>
COM_DECLSPEC_NOTHROW
HRESULT
D2D1CreateFactory(
    _In_ D2D1_FACTORY_TYPE factoryType,
    _In_ CONST D2D1_FACTORY_OPTIONS &factoryOptions,
    _Out_ Factory **ppFactory
    )
{
    return
        D2D1CreateFactory(
            factoryType,
            __uuidof(Factory),
            &factoryOptions,
            reinterpret_cast<void **>(ppFactory));
}

#endif // #ifndef D2D_USE_C_DEFINITIONS

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion

#endif // #ifndef _D2D1_H_
