import { defineConfig, devices } from '@playwright/test';

export default defineConfig({
  testDir: './tests',
  fullyParallel: true,
  forbidOnly: !!process.env.CI,
  retries: process.env.CI ? 2 : 0,
  workers: process.env.CI ? 1 : undefined,
  reporter: 'html',
  snapshotPathTemplate: 'tests/snapshots/{arg}/{arg}{ext}',
  expect: {
    toHaveScreenshot: {
      maxDiffPixels: 300
    },
    toMatchSnapshot: {
      maxDiffPixelRatio: 1
    }
  },
  use: {
    baseURL: 'http://localhost:3000',
    trace: 'on-first-retry',
    viewport: {
      width: 1280,
      height: 720
    },
  },
  projects: [
    {
      name: 'chromium',
      use: { ...devices['Desktop Chrome'] }
    }
  ],
  webServer: {
    command: 'npm --prefix ./tests/app run dev',
    url: 'http://localhost:3000'
  }
});
