import { ok, test } from '../../test';

export default test({
	html: `
		<p id="my-id" style="width: 65px; color: blue;"></p>
	`,

	test({ assert, component, target, window }) {
		const p = target.querySelector('p');
		ok(p);

		const styles = window.getComputedStyle(p);
		assert.equal(styles.color, 'rgb(0, 0, 255)');
		assert.equal(styles.width, '65px');
		assert.equal(p.id, 'my-id');

		component.color = 'red';

		assert.htmlEqual(target.innerHTML, '<p id="my-id" style="width: 65px; color: red;"></p>');

		component.obj = { style: 'height: 72px;' };

		assert.htmlEqual(target.innerHTML, '<p style="height: 72px; color: red;"></p>');

		component.obj = { style: 'border-radius: 2px; color: orange' };

		assert.htmlEqual(target.innerHTML, '<p style="border-radius: 2px; color: red;"></p>');

		component.obj = {};

		assert.htmlEqual(target.innerHTML, '<p style="color: red;"></p>');
	}
});
