import { flushSync } from 'svelte';
import { test } from '../../test';

export default test({
	html: `
		<p>_0_1_2_3_4_5_6_7_8_9_10_11_12_13_14_15_16_17_18_19_20_21_22_23_24_25_26_27_28_29_30_31_32_33_34_35_36_37_38_39_40</p>
		<p>b</p>
		<p>-0-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25-26-27-28-29-30-31-32-33-34-35-36-37-38-39-40</p>
		<p>0</p>
		<p>0</p>
		<button></button>
	`,

	test({ assert, component, target, window }) {
		// change from inside
		const button = target.querySelector('button');
		button?.dispatchEvent(new window.Event('click', { bubbles: true }));
		flushSync();

		assert.htmlEqual(
			target.innerHTML,
			`
			<p>_0_1_2_3_4_5_6_7_8_9_10_11_12_13_14_15_16_17_18_19_20_21_22_23_24_25_26_27_28_29_30_31_32_33_34_35_36_37_38_39_40</p>
			<p>b</p>
			<p>-0-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25-26-27-28-29-30-31-32-33-34-35-36-37-38-39-40</p>
			<p>0</p>
			<p>1</p>
			<button></button>
		`
		);

		// change from outside
		component.a = 'AA';

		assert.htmlEqual(
			target.innerHTML,
			`
			<p>_0_1_2_3_4_5_6_7_8_9_10_11_12_13_14_15_16_17_18_19_20_21_22_23_24_25_26_27_28_29_30_31_32_33_34_35_36_37_38_39_40</p>
			<p>b</p>
			<p>-0-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25-26-27-28-29-30-31-32-33-34-35-36-37-38-39-40</p>
			<p>AA</p>
			<p>1</p>
			<button></button>
		`
		);

		// change from outside through props
		component.b = 'BB';

		assert.htmlEqual(
			target.innerHTML,
			`
			<p>_0_1_2_3_4_5_6_7_8_9_10_11_12_13_14_15_16_17_18_19_20_21_22_23_24_25_26_27_28_29_30_31_32_33_34_35_36_37_38_39_40</p>
			<p>BB</p>
			<p>-0-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25-26-27-28-29-30-31-32-33-34-35-36-37-38-39-40</p>
			<p>AA</p>
			<p>1</p>
			<button></button>
		`
		);
	}
});
