---
title: 'Announcing Svelte 4'
description: 'Updated performance, developer experience, and site'
author: The Svelte team
authorURL: https://svelte.dev/
---

After months in the making, we're excited to announce the stable release of Svelte 4.

Time flies - Svelte 3 was released more than four years ago! In JavaScript-framework-time, that's eons. Svelte’s freshness has persisted throughout, but Node.js and browser APIs have evolved during that time and today we’re updating Svelte to take advantage of some of these improvements. Svelte 4 is mainly a maintenance release, bumping minimum version requirements and tightening up the design in specific areas. It sets the stage for the next generation of Svelte to be released as Svelte 5 - we think you’ll love it.

If you haven't tried Svelte yet, take it for a spin in our [interactive tutorial](https://learn.svelte.dev/), on [StackBlitz](https://sveltekit.new/), or locally with `npx sv create`. Svelte lets you easily put together web UIs leveraging the power of HTML, CSS, JS, and the Svelte compiler. Watch [Svelte Radio Live](https://www.youtube.com/watch?v=72TIVhRtyWE) to learn more about this release.

## What's new

### Performance

This release results in smaller and faster hydration code. To see the impact, SvelteKit users can see their compiled output shrink in size by examining the `.svelte-kit/output/client/_app/immutable/nodes` folder. For example, on [kit.svelte.dev](https://kit.svelte.dev) the JS generated across the whole site was reduced in size by 12.7% (126.3 kB to 110.2 kB).

Svelte 4 reduces the Svelte package size by nearly 75% (10.6 MB down to 2.8 MB), which means less waiting on `npm install`. This improvement will be especially noticeable for users who are loading our interactive learning experience on [learn.svelte.dev](https://learn.svelte.dev) for the first time, users of the Svelte REPL, and users with limited connectivity. The majority of the remaining package size is eslint support, which necessitates distributing a CJS build, and once [the eslint rewrite](https://github.com/eslint/eslint/discussions/16557) is completed the Svelte package size can drop by over another 50%.

The number of dependencies in Svelte has been greatly reduced from 61 down to 16. This means faster downloads for our users as well as less susceptibility to supply chain attacks. We also slightly reduced the number of dependencies in the latest versions of SvelteKit as well.

### Developer experience

Svelte 4 makes the Svelte authoring experience more intuitive and consistent: `|local` is now the default for transitions to avoid animations blocking page transitions, preprocessors are now easier to write, and multiple fixes make CSP easier to set up and use.

For users of web components, the largest change is an overhaul of the way you use Svelte to author custom elements. By changing the way they are generated, a whole class of bugs and inconsistencies was eliminated.

Finally, we’ve also made several [improvements to the IDE authoring experience](https://github.com/sveltejs/svelte/pull/8702):
cmd+click in svelte modules now takes you to the implementation rather than a `.d.ts` file
imports from `svelte/internal` are now hidden and will not clutter autocomplete suggestions
auto-imports now work more reliably

### Updated site, docs, and tutorial

The official [svelte.dev](https://svelte.dev) site has gotten an overhaul. It’s now split into multiple pages with improved mobile nav, overhauled typescript docs, dark mode, and an enhanced REPL. The SvelteKit site is also being updated to match. And we’ve updated all the tutorial links to point to our new [learn.svelte.dev](https://learn.svelte.dev) experience. The old tutorial remains available for users of Safari 16.3 and earlier.

Stay tuned for a more in-depth blog post about all the site changes in the coming days!

## Migrating

Most apps and libraries that are compatible with Svelte 3 should be compatible with Svelte 4. Library authors will need to update the version range to include Svelte 4 if `svelte` is specified in the `peerDependencies`. For application authors, the most common change required will be updating tooling to meet the new minimum version requirements such as Node.js 16. Many other migration steps can be handled with `npx sv migrate svelte-4`.

Read the [migration guide](/docs/v4-migration-guide) for full details.

## Svelte 5: the next generation of Svelte

Svelte 5 will be a rewrite of the Svelte compiler and runtime. Svelte 4 was mainly about setting the ground for these future improvements by adopting modern tooling and dropping support for some legacy versions of various technologies such as older bundlers. These changes will help us in a number of ways such as being able to more easily compare the Svelte 5 and Svelte 4 codebases and being able to run the existing tests against the new implementation. Svelte 5 will bring major new features and performance improvements to Svelte. The changes are still baking and not quite ready to share yet, but stay tuned!

## Changelog

See the full list of changes in the [changelog](https://github.com/sveltejs/svelte/blob/master/packages/svelte/CHANGELOG.md).

## Acknowledgements

First and foremost, thank you to all of the many Svelte maintainers and contributors who made this release possible. Developers contributing multiple PRs to this release were [@dummdidumm](https://github.com/dummdidumm), [@gtm-nayan](https://github.com/gtm-nayan), [@benmccann](https://github.com/benmccann), [@tanhauhau](https://github.com/tanhauhau), [@Karlinator](https://github.com/Karlinator), and [@ngtr6788](https://github.com/ngtr6788). Also, thank you to the many community members who donated to [the Svelte OpenCollective](https://opencollective.com/svelte) - these donations sponsored the site overhaul completed by [PuruVJ](https://github.com/puruvj) as well as a number of recent fixes from [@gtm-nayan](https://github.com/gtm-nayan).

Finally, thank you to the various library maintainers from across the ecosystem who helped prepare for this release. Thank you to [@jessebeach](https://github.com/jessebeach) for the help in getting out new versions of `aria-query` and `axobject-query`, [@jreinhold](https://github.com/jreinhold) for ensuring compatibility with Storybook, and [@yanick](https://github.com/yanick) for updating `svelte-testing-library`. And to ensure things stay working, the [`svelte-ecosystem-ci`](https://github.com/sveltejs/svelte-ecosystem-ci) setup by [@dominikg](https://github.com/dominikg) — which was modeled off his similar work for Vite — has been helping to test against major projects in the ecosystem on an ongoing basis.
