#import "ManDrakeController.h"

#import <WebKit/WebKit.h>

@implementation ManDrakeController

- (void)awakeFromNib
{
	refreshTimer = NULL;
	
	//set progress indicators
	[refreshProgressIndicator setUsesThreadedAnimation: YES];
	[saveProgressIndicator setUsesThreadedAnimation: YES];
	
	//set font in text fields
	[editableTextField setFont: [NSFont fontWithName:@"Monaco" size:10]];
	
	//register for drag
	[window registerForDraggedTypes: [NSArray arrayWithObjects:NSFilenamesPboardType, nil]];
	[editableTextField registerForDraggedTypes: [NSArray arrayWithObjects:NSFilenamesPboardType, nil]];
	
	//center and show window
	[window center];
	[window makeKeyAndOrderFront: self];
}

- (IBAction)open:(id)sender
{
	int result;
	
    NSOpenPanel *oPanel = [NSOpenPanel openPanel];
	
	[oPanel setCanChooseDirectories:YES];
	[oPanel setCanChooseFiles: YES];
    [oPanel setAllowsMultipleSelection:NO];
    result = [oPanel runModalForDirectory:nil file:nil types:nil];
    if (result == NSOKButton) 
	{
		[manPathTextField setStringValue: [oPanel filename]];
		[editableTextField setString:  [NSString stringWithContentsOfFile: [oPanel filename]]  ];
		[self refresh: self];
    }
	else
		return;
}


- (IBAction)refresh:(id)sender
{
	[refreshProgressIndicator startAnimation: self];

	[self drawWebView];
		
	[refreshProgressIndicator stopAnimation: self];
}


- (void)drawWebView
{
	NSString *cmdString = [NSString stringWithFormat: @"/usr/bin/nroff -mandoc /tmp/ManDrakeTemp.manText | %@ > /tmp/ManDrakeTemp.html", 
							[[NSBundle mainBundle] pathForResource: @"cat2html" ofType: NULL]
						];

	[[editableTextField string] writeToFile: @"/tmp/ManDrakeTemp.manText" atomically: YES encoding: NSASCIIStringEncoding error: NULL];
	
	system([cmdString cStringUsingEncoding: NSASCIIStringEncoding]);
	
	[[webView mainFrame] loadRequest: [NSURLRequest requestWithURL: [NSURL fileURLWithPath: @"/tmp/ManDrakeTemp.html"]]];
	
}


- (IBAction)revert:(id)sender
{
		[editableTextField setString: [NSString stringWithContentsOfFile: [manPathTextField stringValue]] ];
		[self refresh: self];

}


- (IBAction)save:(id)sender
{   
	if ([[manPathTextField stringValue] isEqualToString: @"No file loaded"])
	{
		[self saveAs: self];
	}
	else
	{
		[saveProgressIndicator startAnimation: self];
		NSString *mantext = [editableTextField string];
		[mantext writeToFile: [manPathTextField stringValue] atomically: YES encoding: NSASCIIStringEncoding error: NULL];
		[saveProgressIndicator stopAnimation: self];
	}
}


- (IBAction)saveAs:(id)sender
{
	NSSavePanel *sp;
	int runResult;

	/* create or get the shared instance of NSSavePanel */
	sp = [NSSavePanel savePanel];

	/* display the NSSavePanel */
	runResult = [sp runModalForDirectory:NSHomeDirectory() file:@""];

	if (runResult == NSOKButton)
	{
		[saveProgressIndicator startAnimation: self];
		
		if (![[editableTextField string] writeToFile:[sp filename] atomically:YES encoding: NSASCIIStringEncoding error: NULL])
			NSBeep();
		else
			[manPathTextField setStringValue: [sp filename]];
			
		[saveProgressIndicator stopAnimation: self];
	}

}

#pragma mark -

- (void)textDidChange:(NSNotification *)aNotification
{
	NSString *refreshText = [refreshPopupMenu titleOfSelectedItem];

	if ([refreshText isEqualToString: @"Delayed"])
	{
		if (refreshTimer != NULL)
		{
			[refreshTimer invalidate];
			refreshTimer = NULL;
		}
		refreshTimer = [NSTimer scheduledTimerWithTimeInterval:0.3 target:self selector:@selector(updateView) userInfo:nil repeats:NO];
	
	}
	else if ([refreshText isEqualToString: @"Live"])
	{
		[self refresh: self];
	}
}

- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
{
	[manPathTextField setStringValue: filename];
	[editableTextField setString: [NSString stringWithContentsOfFile: filename] ];
	[self refresh: self];
	return TRUE;
}

#pragma mark -

/*****************************************
 - Dragging and dropping for Platypus window
*****************************************/

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
	NSPasteboard *pboard = [sender draggingPasteboard];

    if ( [[pboard types] containsObject:NSFilenamesPboardType] ) 
	{
        NSArray *files = [pboard propertyListForType:NSFilenamesPboardType];
		[manPathTextField setStringValue: [files objectAtIndex: 0]];
		[editableTextField setString: [NSString stringWithContentsOfFile: [files objectAtIndex: 0]] ];
		[self refresh: self];
    }

    return YES;

}

- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender 
{
    NSPasteboard *pboard;
    NSDragOperation sourceDragMask;

    sourceDragMask = [sender draggingSourceOperationMask];
    pboard = [sender draggingPasteboard];

    if ( [[pboard types] containsObject:NSFilenamesPboardType] ) 
	{
        if (sourceDragMask & NSDragOperationLink) 
            return NSDragOperationLink;
		else if (sourceDragMask & NSDragOperationCopy)
            return NSDragOperationCopy;
    }

    return NSDragOperationNone;
}


#pragma mark -

- (void)updateView
{
	[self refresh: self];
	refreshTimer = NULL;
	[refreshTimer invalidate];
}

@end
