/*
 Mandrake - simple man page editor for Mac OS X
 Copyright (C) 2004-2010 Sveinbjorn Thordarson <sveinbjornt@simnet.is>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
 */

#import "ManDrakeController.h"
#import <WebKit/WebKit.h>

@implementation ManDrakeController

- (void)awakeFromNib
{
	refreshTimer = NULL;
	
	//set progress indicators
	[refreshProgressIndicator setUsesThreadedAnimation: YES];
	[saveProgressIndicator setUsesThreadedAnimation: YES];
	
	//set font in text fields
	[editableTextField setFont: [NSFont fontWithName:@"Monaco" size:10]];
	
	//register for drag
	[window registerForDraggedTypes: [NSArray arrayWithObjects:NSFilenamesPboardType, nil]];
	[editableTextField registerForDraggedTypes: [NSArray arrayWithObjects:NSFilenamesPboardType, nil]];
	
	[webView setFrameLoadDelegate: self];
	
	//center and show window
	[window center];
	[window makeKeyAndOrderFront: self];
}


/*****************************************
 - Handler for application termination
 *****************************************/

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
	// remove temp files
	[[NSFileManager defaultManager] removeFileAtPath: @"/tmp/ManDrakeTemp.manText" handler: nil];
	[[NSFileManager defaultManager] removeFileAtPath: @"/tmp/ManDrakeTemp.html" handler: nil];
}


- (IBAction)open:(id)sender
{
	int result;
	
    NSOpenPanel *oPanel = [NSOpenPanel openPanel];
	
	[oPanel setCanChooseDirectories:YES];
	[oPanel setCanChooseFiles: YES];
    [oPanel setAllowsMultipleSelection:NO];
    result = [oPanel runModalForDirectory:nil file:nil types:nil];
    if (result == NSOKButton) 
	{
		[manPathTextField setStringValue: [oPanel filename]];
		[editableTextField setString:  [NSString stringWithContentsOfFile: [oPanel filename]]  ];
		[self refresh: self];
    }
	else
		return;
}


- (IBAction)refresh:(id)sender
{
	[refreshProgressIndicator startAnimation: self];

	[self drawWebView];
		
	[refreshProgressIndicator stopAnimation: self];
}


- (void)drawWebView
{
	NSString *cmdString = [NSString stringWithFormat: @"/usr/bin/nroff -mandoc /tmp/ManDrakeTemp.manText | %@ > /tmp/ManDrakeTemp.html", 
							[[NSBundle mainBundle] pathForResource: @"cat2html" ofType: NULL]
						];
	
	[[editableTextField string] writeToFile: @"/tmp/ManDrakeTemp.manText" atomically: YES encoding: NSASCIIStringEncoding error: NULL];
	
	system([cmdString cStringUsingEncoding: NSASCIIStringEncoding]);
	
	NSScrollView *scrollView = [[[[webView mainFrame] frameView] documentView] enclosingScrollView];
	// get the current scroll position of the document view
	NSRect scrollViewBounds = [[scrollView contentView] bounds];
	currentScrollPosition=scrollViewBounds.origin; 	
	
	//[[webView mainFrame] loadHTMLString: [NSString stringWithContentsOfURL: [NSURL fileURLWithPath: @"/tmp/ManDrakeTemp.html"]] baseURL: NULL];
	[[webView mainFrame] loadRequest: [NSURLRequest requestWithURL: [NSURL fileURLWithPath: @"/tmp/ManDrakeTemp.html"]]];

}

- (void)webView:(WebView *)sender didFinishLoadForFrame:(WebFrame *)frame
{
	[[[[webView mainFrame] frameView] documentView] scrollPoint:currentScrollPosition];
}

- (IBAction)revert:(id)sender
{
		[editableTextField setString: [NSString stringWithContentsOfFile: [manPathTextField stringValue]] ];
		[self refresh: self];

}


- (IBAction)save:(id)sender
{   
	if ([[manPathTextField stringValue] isEqualToString: @"No file loaded"])
	{
		[self saveAs: self];
	}
	else
	{
		[saveProgressIndicator startAnimation: self];
		NSString *mantext = [editableTextField string];
		[mantext writeToFile: [manPathTextField stringValue] atomically: YES encoding: NSASCIIStringEncoding error: NULL];
		[saveProgressIndicator stopAnimation: self];
	}
}


- (IBAction)saveAs:(id)sender
{
	NSSavePanel *sp;
	int runResult;

	/* create or get the shared instance of NSSavePanel */
	sp = [NSSavePanel savePanel];

	/* display the NSSavePanel */
	runResult = [sp runModalForDirectory:NSHomeDirectory() file:@""];

	if (runResult == NSOKButton)
	{
		[saveProgressIndicator startAnimation: self];
		
		if (![[editableTextField string] writeToFile:[sp filename] atomically:YES encoding: NSASCIIStringEncoding error: NULL])
			NSBeep();
		else
			[manPathTextField setStringValue: [sp filename]];
			
		[saveProgressIndicator stopAnimation: self];
	}

}

#pragma mark -

- (void)textDidChange:(NSNotification *)aNotification
{
	NSString *refreshText = [refreshPopupMenu titleOfSelectedItem];
		
	if ([refreshText isEqualToString: @"Delayed"])
	{
		if (refreshTimer != NULL)
		{
			[refreshTimer invalidate];
			refreshTimer = NULL;
		}
		refreshTimer = [NSTimer scheduledTimerWithTimeInterval:0.3 target:self selector:@selector(updateView) userInfo:nil repeats:NO];
	
	}
	else if ([refreshText isEqualToString: @"Live"])
	{
		[self refresh: self];
	}
	
	// restore the scroll location
	
	//[ scrollPoint:currentScrollPosition];
}

- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
{
	[manPathTextField setStringValue: filename];
	[editableTextField setString: [NSString stringWithContentsOfFile: filename] ];
	[self refresh: self];
	return TRUE;
}

#pragma mark -

/*****************************************
 - Dragging and dropping for Platypus window
*****************************************/

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
	NSPasteboard *pboard = [sender draggingPasteboard];

    if ( [[pboard types] containsObject:NSFilenamesPboardType] ) 
	{
        NSArray *files = [pboard propertyListForType:NSFilenamesPboardType];
		[manPathTextField setStringValue: [files objectAtIndex: 0]];
		[editableTextField setString: [NSString stringWithContentsOfFile: [files objectAtIndex: 0]] ];
		[self refresh: self];
    }

    return YES;

}

- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender 
{
    NSPasteboard *pboard;
    NSDragOperation sourceDragMask;

    sourceDragMask = [sender draggingSourceOperationMask];
    pboard = [sender draggingPasteboard];

    if ( [[pboard types] containsObject:NSFilenamesPboardType] ) 
	{
        if (sourceDragMask & NSDragOperationLink) 
            return NSDragOperationLink;
		else if (sourceDragMask & NSDragOperationCopy)
            return NSDragOperationCopy;
    }

    return NSDragOperationNone;
}


#pragma mark -

- (void)updateView
{
	[self refresh: self];
	refreshTimer = NULL;
	[refreshTimer invalidate];
}

@end
