# Docker Compose Files for Open-Source Software's
![GitHub License](https://img.shields.io/github/license/suriya-mca/Docker_Compose_Files?style=flat&color=green)  ![GitHub commit activity](https://img.shields.io/github/commit-activity/t/suriya-mca/Docker_Compose_Files)  ![GitHub Repo stars](https://img.shields.io/github/stars/suriya-mca/Docker_Compose_Files?style=flat&color=pink)  ![GitHub forks](https://img.shields.io/github/forks/suriya-mca/Docker_Compose_Files?style=flat&color=orange)


This repository contains a collection of Docker Compose files for various open-source and popular software and frameworks
. Each Docker Compose file is designed to set up a specific software or framework in a containerized environment.

## Getting Started

To use a Docker Compose file in this repository, follow these steps:

1. Clone this repository to your local machine.
2. Navigate to the directory containing the desired Docker Compose file
.
3. Run the following command:
```
docker-compose up
```

This command will start the containers defined in the Docker Compose file.

⚠️ Note: These Docker Compose files are intended for development purposes.

## Available Docker Compose Files

The following Docker Compose files are available in this repository:

* **SQL Database:**
    * Sqlite3
    * PostgreSQL
    * CockroachDB
    * MySQL
    * MSSQL
    * Mariadb
    * TimescaleDB
    * EdgeDB
* **NoSQL Database:**
    * Redis
    * MongoDB
    * KeyDB
    * Cassandra
    * CouchDB
    * Couchbase
    * Neo4j
    * Memcached
    * Valkey
* **Vector Database:**
    * Qdrant
    * ChromaDB
    * PostgresVector
    * Weaviate
* **Analytics Database (OLAP):**
    * ClickHouse
    * Apache Pinot
    * Apache Kylin
    * Apache Druid
* **DB Client:**
    * Dbeaver
    * Dbgate
    * Pgadmin4
    * Phpmyadmin
    * Beekeeper Studio
* **Backend Framework:**
    * FastAPI
    * Django
    * Spring Boot
* **CRM/ERP:**
    * Odoo
    * ERPNext
* **CMS:**
    * WordPress
    * Directus
    * Ghost
    * Grav
    * Strapi
* **Docker Client:**
    * Portainer
    * Dokku
* **Backend as a Service(BaaS):**
    * Pocketbase
    * Appwrite
* **API Platform:**
    * Hoppscotch

## Contributing

Contributions to this repository are welcome. If you would like to add a Docker Compose file for a specific software or framework, please submit a pull request.
