# Contributing to Docker_Compose_Files

Thank you for considering contributing to podman-init! We appreciate your interest in making this project better.

## How to Contribute
We welcome contributions in various forms, including bug reports, feature requests, code improvements, documentation enhancements, and more. Here's how you can contribute:

1. `Opening Issues`: If you encounter any bugs, have suggestions, or want to request a new feature, please open an issue on our tracker[https://github.com/users/suriya-mca/projects/13/views/2].
2. `Submitting Pull Requests (PRs)`: We encourage you to fork this repository, make your changes, and submit a pull request. Please ensure your PR adheres to the following guidelines:
- Describe the problem or feature in the PR description.
- Follow the existing style and conventions.
- Update the documentation, if necessary.
- Ensure your changes don't introduce any breaking changes unless absolutely necessary.

## Development Workflow
This project follows the Git branching model with two main branches:

- main: This branch is for production-ready code. It should always contain stable and tested code.
- dev: This branch is for ongoing development. Features and fixes are developed here before being merged into main.

## Getting Started
To start contributing, follow these steps:

- Fork this repository to your GitHub account.
- Clone the forked repository to your local machine.
- Create a new branch for your changes: git checkout -b dev.
- Make your changes and ensure they are properly tested.
- Commit your changes with a descriptive commit message: git commit -m "Your message".
- Push your changes to your fork: git push origin feature-branch.
- Submit a pull request from your branch to the dev branch of the original repository.

## License
By contributing to Docker_Compose_Files, you agree that your contributions will be licensed under the MIT License.