# How to fund work with the Flutter Bounty Hunters
Most development on `super_editor` and other [Flutter Bounty Hunter](https://flutterbountyhunters.com/) projects are funded by companies in the Flutter community. This document describes the protocol for identifying funders and budgeting the work.

Work is funded at an hourly rate, on a per-ticket basis.

## Identifying funders
Each funded ticket is assigned a label for each company that chooses to fund that particular ticket. For example, if Superlist chooses to fund a ticket, the ticket will include a label that says `f:superlist`.

Multiple funders can fund the same ticket. In fact, multiple funders per ticket is the ideal approach.

## Setting a budget
Work is budgeted by time. A funded ticket will include a label that describes the maximum number of hours that the funders are comfortable funding that ticket. For example, if the funders are willing to fund 10 hours or less of work, the ticket will have the label `maxHours:10`.

## Setting a rate
Flutter Bounty Hunter work falls into four buckets: junior development, senior development, specialist development, technical leadership. Each level has its own rate. Each ticket is assigned one of those levels with a tag, e.g., `bounty_junior`, `bounty_senior`, `bounty_specialist`, `bounty_lead`.
