﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace Sseko.Data.Models
{
    public class ModelBuilderInit
    {
        internal void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<AdminAssert>(entity =>
            {
                entity.HasKey(e => e.AssertId)
                    .HasName("PK_admin_assert");

                entity.ToTable("admin_assert");

                entity.Property(e => e.AssertId)
                    .HasColumnName("assert_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AssertData)
                    .HasColumnName("assert_data")
                    .HasColumnType("text");

                entity.Property(e => e.AssertType)
                    .HasColumnName("assert_type")
                    .HasColumnType("varchar(20)");
            });

            modelBuilder.Entity<AdminRole>(entity =>
            {
                entity.HasKey(e => e.RoleId)
                    .HasName("PK_admin_role");

                entity.ToTable("admin_role");

                entity.HasIndex(e => e.TreeLevel)
                    .HasName("IDX_ADMIN_ROLE_TREE_LEVEL");

                entity.HasIndex(e => new { e.ParentId, e.SortOrder })
                    .HasName("IDX_ADMIN_ROLE_PARENT_ID_SORT_ORDER");

                entity.Property(e => e.RoleId)
                    .HasColumnName("role_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RoleName)
                    .HasColumnName("role_name")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.RoleType)
                    .IsRequired()
                    .HasColumnName("role_type")
                    .HasColumnType("varchar(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TreeLevel)
                    .HasColumnName("tree_level")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<AdminRule>(entity =>
            {
                entity.HasKey(e => e.RuleId)
                    .HasName("PK_admin_rule");

                entity.ToTable("admin_rule");

                entity.HasIndex(e => new { e.ResourceId, e.RoleId })
                    .HasName("IDX_ADMIN_RULE_RESOURCE_ID_ROLE_ID");

                entity.HasIndex(e => new { e.RoleId, e.ResourceId })
                    .HasName("IDX_ADMIN_RULE_ROLE_ID_RESOURCE_ID");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AssertId)
                    .HasColumnName("assert_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Permission)
                    .HasColumnName("permission")
                    .HasColumnType("varchar(10)");

                entity.Property(e => e.Privileges)
                    .HasColumnName("privileges")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.ResourceId)
                    .HasColumnName("resource_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RoleId)
                    .HasColumnName("role_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RoleType)
                    .HasColumnName("role_type")
                    .HasColumnType("varchar(1)");

                entity.HasOne(d => d.Role)
                    .WithMany(p => p.AdminRule)
                    .HasForeignKey(d => d.RoleId)
                    .HasConstraintName("FK_ADMIN_RULE_ROLE_ID_ADMIN_ROLE_ROLE_ID");
            });

            modelBuilder.Entity<AdminUser>(entity =>
            {
                entity.HasKey(e => e.UserId)
                    .HasName("PK_admin_user");

                entity.ToTable("admin_user");

                entity.HasIndex(e => e.Username)
                    .HasName("UNQ_ADMIN_USER_USERNAME")
                    .IsUnique();

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Created)
                    .HasColumnName("created")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Email)
                    .HasColumnName("email")
                    .HasColumnType("varchar(128)");

                entity.Property(e => e.Extra)
                    .HasColumnName("extra")
                    .HasColumnType("text");

                entity.Property(e => e.Firstname)
                    .HasColumnName("firstname")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Lastname)
                    .HasColumnName("lastname")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Logdate)
                    .HasColumnName("logdate")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Lognum)
                    .HasColumnName("lognum")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Modified)
                    .HasColumnName("modified")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Password)
                    .HasColumnName("password")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.ReloadAclFlag)
                    .HasColumnName("reload_acl_flag")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RpToken)
                    .HasColumnName("rp_token")
                    .HasColumnType("text");

                entity.Property(e => e.RpTokenCreatedAt)
                    .HasColumnName("rp_token_created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Username)
                    .IsRequired()
                    .HasColumnName("username")
                    .HasColumnType("varchar(40)");
            });

            modelBuilder.Entity<AdminnotificationInbox>(entity =>
            {
                entity.HasKey(e => e.NotificationId)
                    .HasName("PK_adminnotification_inbox");

                entity.ToTable("adminnotification_inbox");

                entity.HasIndex(e => e.IsRead)
                    .HasName("IDX_ADMINNOTIFICATION_INBOX_IS_READ");

                entity.HasIndex(e => e.IsRemove)
                    .HasName("IDX_ADMINNOTIFICATION_INBOX_IS_REMOVE");

                entity.HasIndex(e => e.Severity)
                    .HasName("IDX_ADMINNOTIFICATION_INBOX_SEVERITY");

                entity.Property(e => e.NotificationId)
                    .HasColumnName("notification_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.DateAdded)
                    .HasColumnName("date_added")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.IsRead)
                    .HasColumnName("is_read")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRemove)
                    .HasColumnName("is_remove")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Severity)
                    .HasColumnName("severity")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .IsRequired()
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Url)
                    .HasColumnName("url")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<AffiliateplusAccount>(entity =>
            {
                entity.HasKey(e => e.AccountId)
                    .HasName("PK_affiliateplus_account");

                entity.ToTable("affiliateplus_account");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("customer_id_2");

                entity.HasIndex(e => e.IdentifyCode)
                    .HasName("identify_code")
                    .IsUnique();

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddressId)
                    .HasColumnName("address_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Approved)
                    .HasColumnName("approved")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("2");

                entity.Property(e => e.Balance)
                    .HasColumnName("balance")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CouponCode)
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedTime)
                    .HasColumnName("created_time")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Email)
                    .IsRequired()
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IdentifyCode)
                    .IsRequired()
                    .HasColumnName("identify_code")
                    .HasColumnType("varchar(63)");

                entity.Property(e => e.InParty)
                    .HasColumnName("inParty")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.LastReceivedDate)
                    .HasColumnName("last_received_date")
                    .HasColumnType("date");

                entity.Property(e => e.MoneybookerEmail)
                    .IsRequired()
                    .HasColumnName("moneybooker_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Notification)
                    .HasColumnName("notification")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.PaypalEmail)
                    .IsRequired()
                    .HasColumnName("paypal_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RecurringMethod)
                    .IsRequired()
                    .HasColumnName("recurring_method")
                    .HasColumnType("varchar(100)")
                    .HasDefaultValueSql("paypal");

                entity.Property(e => e.RecurringPayment)
                    .HasColumnName("recurring_payment")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.ReferredBy)
                    .HasColumnName("referred_by")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ReferringWebsite)
                    .HasColumnName("referring_website")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("2");

                entity.Property(e => e.TotalClicks)
                    .HasColumnName("total_clicks")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TotalCommissionReceived)
                    .HasColumnName("total_commission_received")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalPaid)
                    .HasColumnName("total_paid")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.UniqueClicks)
                    .HasColumnName("unique_clicks")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Customer)
                    .WithOne(p => p.AffiliateplusAccount)
                    .HasForeignKey<AffiliateplusAccount>(d => d.CustomerId)
                    .HasConstraintName("affiliateplus_account_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusAccountValue>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_affiliateplus_account_value");

                entity.ToTable("affiliateplus_account_value");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id_2");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.HasIndex(e => new { e.AccountId, e.StoreId, e.AttributeCode })
                    .HasName("account_id")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeCode)
                    .IsRequired()
                    .HasColumnName("attribute_code")
                    .HasColumnType("varchar(63)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusAccountValue)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliateplus_account_value_ibfk_1");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.AffiliateplusAccountValue)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("affiliateplus_account_value_ibfk_2");
            });

            modelBuilder.Entity<AffiliateplusAction>(entity =>
            {
                entity.HasKey(e => e.ActionId)
                    .HasName("PK_affiliateplus_action");

                entity.ToTable("affiliateplus_action");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.Property(e => e.ActionId)
                    .HasColumnName("action_id")
                    .HasColumnType("bigint(19) unsigned");

                entity.Property(e => e.AccountEmail)
                    .IsRequired()
                    .HasColumnName("account_email")
                    .HasColumnType("varchar(25)");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BannerId)
                    .HasColumnName("banner_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.BannerTitle)
                    .IsRequired()
                    .HasColumnName("banner_title")
                    .HasColumnType("varchar(25)");

                entity.Property(e => e.CreatedDate)
                    .HasColumnName("created_date")
                    .HasColumnType("date");

                entity.Property(e => e.DirectLink)
                    .HasColumnName("direct_link")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Domain)
                    .IsRequired()
                    .HasColumnName("domain")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.IpAddress)
                    .IsRequired()
                    .HasColumnName("ip_address")
                    .HasColumnType("varchar(25)");

                entity.Property(e => e.IsCommission)
                    .HasColumnName("is_commission")
                    .HasColumnType("int(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsUnique)
                    .HasColumnName("is_unique")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LandingPage)
                    .IsRequired()
                    .HasColumnName("landing_page")
                    .HasColumnType("text");

                entity.Property(e => e.Referer)
                    .IsRequired()
                    .HasColumnName("referer")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Totals)
                    .HasColumnName("totals")
                    .HasColumnType("bigint(8)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("2");

                entity.Property(e => e.UpdatedTime)
                    .HasColumnName("updated_time")
                    .HasColumnType("datetime");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.AffiliateplusAction)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("affiliateplus_action_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusBanner>(entity =>
            {
                entity.HasKey(e => e.BannerId)
                    .HasName("PK_affiliateplus_banner");

                entity.ToTable("affiliateplus_banner");

                entity.Property(e => e.BannerId)
                    .HasColumnName("banner_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Height)
                    .HasColumnName("height")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Link)
                    .IsRequired()
                    .HasColumnName("link")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.RelNofollow)
                    .HasColumnName("rel_nofollow")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SourceFile)
                    .IsRequired()
                    .HasColumnName("source_file")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Title)
                    .IsRequired()
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TypeId)
                    .HasColumnName("type_id")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Width)
                    .HasColumnName("width")
                    .HasColumnType("int(11)");
            });

            modelBuilder.Entity<AffiliateplusBannerValue>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_affiliateplus_banner_value");

                entity.ToTable("affiliateplus_banner_value");

                entity.HasIndex(e => e.BannerId)
                    .HasName("banner_id_2");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.HasIndex(e => new { e.BannerId, e.StoreId, e.AttributeCode })
                    .HasName("banner_id")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeCode)
                    .IsRequired()
                    .HasColumnName("attribute_code")
                    .HasColumnType("varchar(63)");

                entity.Property(e => e.BannerId)
                    .HasColumnName("banner_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Banner)
                    .WithMany(p => p.AffiliateplusBannerValue)
                    .HasForeignKey(d => d.BannerId)
                    .HasConstraintName("affiliateplus_banner_value_ibfk_1");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.AffiliateplusBannerValue)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("affiliateplus_banner_value_ibfk_2");
            });

            modelBuilder.Entity<AffiliateplusCoupon>(entity =>
            {
                entity.HasKey(e => e.CouponId)
                    .HasName("PK_affiliateplus_coupon");

                entity.ToTable("affiliateplus_coupon");

                entity.HasIndex(e => e.CouponCode)
                    .HasName("coupon_code")
                    .IsUnique();

                entity.Property(e => e.CouponId)
                    .HasColumnName("coupon_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountName)
                    .IsRequired()
                    .HasColumnName("account_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CouponCode)
                    .IsRequired()
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProgramName)
                    .HasColumnName("program_name")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<AffiliateplusCredit>(entity =>
            {
                entity.ToTable("affiliateplus_credit");

                entity.HasIndex(e => e.PaymentId)
                    .HasName("payment_id");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BasePaidAmount)
                    .HasColumnName("base_paid_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseRefundAmount)
                    .HasColumnName("base_refund_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderIncrementId)
                    .IsRequired()
                    .HasColumnName("order_increment_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PaidAmount)
                    .HasColumnName("paid_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.RefundAmount)
                    .HasColumnName("refund_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Payment)
                    .WithMany(p => p.AffiliateplusCredit)
                    .HasForeignKey(d => d.PaymentId)
                    .HasConstraintName("affiliateplus_credit_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusPayment>(entity =>
            {
                entity.HasKey(e => e.PaymentId)
                    .HasName("PK_affiliateplus_payment");

                entity.ToTable("affiliateplus_payment");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountEmail)
                    .IsRequired()
                    .HasColumnName("account_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountName)
                    .IsRequired()
                    .HasColumnName("account_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Amount)
                    .HasColumnName("amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.AmountInclTax)
                    .HasColumnName("amount_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Description)
                    .IsRequired()
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.Fee)
                    .HasColumnName("fee")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.IsPayerFee)
                    .HasColumnName("is_payer_fee")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsRecurring)
                    .HasColumnName("is_recurring")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsReducedBalance)
                    .HasColumnName("is_reduced_balance")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRefundBalance)
                    .HasColumnName("is_refund_balance")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRequest)
                    .HasColumnName("is_request")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.PaymentMethod)
                    .IsRequired()
                    .HasColumnName("payment_method")
                    .HasColumnType("varchar(63)");

                entity.Property(e => e.RequestTime)
                    .HasColumnName("request_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.StoreIds)
                    .IsRequired()
                    .HasColumnName("store_ids")
                    .HasColumnType("text");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusPayment)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliateplus_payment_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusPaymentHistory>(entity =>
            {
                entity.HasKey(e => e.HistoryId)
                    .HasName("PK_affiliateplus_payment_history");

                entity.ToTable("affiliateplus_payment_history");

                entity.HasIndex(e => e.PaymentId)
                    .HasName("payment_id");

                entity.Property(e => e.HistoryId)
                    .HasColumnName("history_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedTime)
                    .HasColumnName("created_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Description)
                    .IsRequired()
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.HasOne(d => d.Payment)
                    .WithMany(p => p.AffiliateplusPaymentHistory)
                    .HasForeignKey(d => d.PaymentId)
                    .HasConstraintName("affiliateplus_payment_history_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusPaymentPaypal>(entity =>
            {
                entity.HasKey(e => e.PaymentPaypalId)
                    .HasName("PK_affiliateplus_payment_paypal");

                entity.ToTable("affiliateplus_payment_paypal");

                entity.HasIndex(e => e.PaymentId)
                    .HasName("payment_id");

                entity.Property(e => e.PaymentPaypalId)
                    .HasColumnName("payment_paypal_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Description)
                    .IsRequired()
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.Email)
                    .IsRequired()
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.TransactionId)
                    .IsRequired()
                    .HasColumnName("transaction_id")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Payment)
                    .WithMany(p => p.AffiliateplusPaymentPaypal)
                    .HasForeignKey(d => d.PaymentId)
                    .HasConstraintName("affiliateplus_payment_paypal_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusPaymentVerify>(entity =>
            {
                entity.HasKey(e => e.VerifyId)
                    .HasName("PK_affiliateplus_payment_verify");

                entity.ToTable("affiliateplus_payment_verify");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.Property(e => e.VerifyId)
                    .HasColumnName("verify_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Field)
                    .IsRequired()
                    .HasColumnName("field")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Info)
                    .IsRequired()
                    .HasColumnName("info")
                    .HasColumnType("text");

                entity.Property(e => e.PaymentMethod)
                    .IsRequired()
                    .HasColumnName("payment_method")
                    .HasColumnType("varchar(63)");

                entity.Property(e => e.Verified)
                    .HasColumnName("verified")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("2");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusPaymentVerify)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliateplus_payment_verify_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusReferer>(entity =>
            {
                entity.HasKey(e => e.RefererId)
                    .HasName("PK_affiliateplus_referer");

                entity.ToTable("affiliateplus_referer");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.Property(e => e.RefererId)
                    .HasColumnName("referer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.IpList)
                    .IsRequired()
                    .HasColumnName("ip_list");

                entity.Property(e => e.Referer)
                    .IsRequired()
                    .HasColumnName("referer")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TotalClicks)
                    .HasColumnName("total_clicks")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UniqueClicks)
                    .HasColumnName("unique_clicks")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UrlPath)
                    .IsRequired()
                    .HasColumnName("url_path")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("/");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusReferer)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliateplus_referer_ibfk_1");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.AffiliateplusReferer)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("affiliateplus_referer_ibfk_2");
            });

            modelBuilder.Entity<AffiliateplusTracking>(entity =>
            {
                entity.HasKey(e => e.TrackingId)
                    .HasName("PK_affiliateplus_tracking");

                entity.ToTable("affiliateplus_tracking");

                entity.HasIndex(e => e.AccountId)
                    .HasName("FK_AFFILIATEPLUS_TRACKING_ACCOUNT_ID");

                entity.Property(e => e.TrackingId)
                    .HasColumnName("tracking_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedTime)
                    .HasColumnName("created_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomerEmail)
                    .IsRequired()
                    .HasColumnName("customer_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusTracking)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("FK_AFFILIATEPLUS_TRACKING_ACCOUNT");
            });

            modelBuilder.Entity<AffiliateplusTransaction>(entity =>
            {
                entity.HasKey(e => e.TransactionId)
                    .HasName("PK_affiliateplus_transaction");

                entity.ToTable("affiliateplus_transaction");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.Property(e => e.TransactionId)
                    .HasColumnName("transaction_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountEmail)
                    .IsRequired()
                    .HasColumnName("account_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountName)
                    .IsRequired()
                    .HasColumnName("account_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.BannerId)
                    .HasColumnName("banner_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.Commission)
                    .HasColumnName("commission")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CommissionPlus)
                    .HasColumnName("commission_plus")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CouponCode)
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedTime)
                    .HasColumnName("created_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.CreditmemoIds)
                    .IsRequired()
                    .HasColumnName("creditmemo_ids")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerEmail)
                    .IsRequired()
                    .HasColumnName("customer_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Discount)
                    .HasColumnName("discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.HoldingFrom)
                    .HasColumnName("holding_from")
                    .HasColumnType("datetime");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderItemIds)
                    .HasColumnName("order_item_ids")
                    .HasColumnType("text");

                entity.Property(e => e.OrderItemNames)
                    .HasColumnName("order_item_names")
                    .HasColumnType("text");

                entity.Property(e => e.OrderNumber)
                    .HasColumnName("order_number")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.PercentPlus)
                    .HasColumnName("percent_plus")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProgramName)
                    .HasColumnName("program_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SalesCouponCode)
                    .HasColumnName("sales_coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TotalAmount)
                    .HasColumnName("total_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("tinyint(2)")
                    .HasDefaultValueSql("3");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusTransaction)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliateplus_transaction_ibfk_1");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.AffiliateplusTransaction)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("affiliateplus_transaction_ibfk_2");
            });

            modelBuilder.Entity<AffiliatepluslevelTier>(entity =>
            {
                entity.ToTable("affiliatepluslevel_tier");

                entity.HasIndex(e => e.ToptierId)
                    .HasName("toptier_id");

                entity.HasIndex(e => new { e.TierId, e.ToptierId })
                    .HasName("tier_id")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Level)
                    .HasColumnName("level")
                    .HasColumnType("tinyint(3) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierId)
                    .HasColumnName("tier_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ToptierId)
                    .HasColumnName("toptier_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Tier)
                    .WithMany(p => p.AffiliatepluslevelTierTier)
                    .HasForeignKey(d => d.TierId)
                    .HasConstraintName("affiliatepluslevel_tier_ibfk_1");

                entity.HasOne(d => d.Toptier)
                    .WithMany(p => p.AffiliatepluslevelTierToptier)
                    .HasForeignKey(d => d.ToptierId)
                    .HasConstraintName("affiliatepluslevel_tier_ibfk_2");
            });

            modelBuilder.Entity<AffiliatepluslevelTransaction>(entity =>
            {
                entity.ToTable("affiliatepluslevel_transaction");

                entity.HasIndex(e => e.TransactionId)
                    .HasName("transaction_id");

                entity.HasIndex(e => new { e.TierId, e.TransactionId })
                    .HasName("tier_id")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Commission)
                    .HasColumnName("commission")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CommissionPlus)
                    .HasColumnName("commission_plus")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Level)
                    .HasColumnName("level")
                    .HasColumnType("tinyint(3) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierId)
                    .HasColumnName("tier_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TransactionId)
                    .HasColumnName("transaction_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Tier)
                    .WithMany(p => p.AffiliatepluslevelTransaction)
                    .HasForeignKey(d => d.TierId)
                    .HasConstraintName("affiliatepluslevel_transaction_ibfk_1");

                entity.HasOne(d => d.Transaction)
                    .WithMany(p => p.AffiliatepluslevelTransaction)
                    .HasForeignKey(d => d.TransactionId)
                    .HasConstraintName("affiliatepluslevel_transaction_ibfk_2");
            });

            modelBuilder.Entity<AffiliatepluspaymentBank>(entity =>
            {
                entity.ToTable("affiliatepluspayment_bank");

                entity.HasIndex(e => e.PaymentId)
                    .HasName("payment_id");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BankaccountHtml)
                    .IsRequired()
                    .HasColumnName("bankaccount_html")
                    .HasColumnType("text");

                entity.Property(e => e.BankaccountId)
                    .HasColumnName("bankaccount_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.InvoiceNumber)
                    .IsRequired()
                    .HasColumnName("invoice_number")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Message)
                    .IsRequired()
                    .HasColumnName("message")
                    .HasColumnType("text");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Payment)
                    .WithMany(p => p.AffiliatepluspaymentBank)
                    .HasForeignKey(d => d.PaymentId)
                    .HasConstraintName("affiliatepluspayment_bank_ibfk_1");
            });

            modelBuilder.Entity<AffiliatepluspaymentBankaccount>(entity =>
            {
                entity.ToTable("affiliatepluspayment_bankaccount");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountName)
                    .IsRequired()
                    .HasColumnName("account_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AccountNumber)
                    .IsRequired()
                    .HasColumnName("account_number")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Address)
                    .IsRequired()
                    .HasColumnName("address")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RoutingCode)
                    .IsRequired()
                    .HasColumnName("routing_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SwiftCode)
                    .IsRequired()
                    .HasColumnName("swift_code")
                    .HasColumnType("varchar(100)");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliatepluspaymentBankaccount)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliatepluspayment_bankaccount_ibfk_1");
            });

            modelBuilder.Entity<AffiliatepluspaymentMoneybooker>(entity =>
            {
                entity.HasKey(e => e.PaymentMoneybookerId)
                    .HasName("PK_affiliatepluspayment_moneybooker");

                entity.ToTable("affiliatepluspayment_moneybooker");

                entity.HasIndex(e => e.PaymentId)
                    .HasName("payment_id");

                entity.Property(e => e.PaymentMoneybookerId)
                    .HasColumnName("payment_moneybooker_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Description)
                    .IsRequired()
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.Email)
                    .IsRequired()
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.TransactionId)
                    .IsRequired()
                    .HasColumnName("transaction_id")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Payment)
                    .WithMany(p => p.AffiliatepluspaymentMoneybooker)
                    .HasForeignKey(d => d.PaymentId)
                    .HasConstraintName("affiliatepluspayment_moneybooker_ibfk_1");
            });

            modelBuilder.Entity<AffiliatepluspaymentOffline>(entity =>
            {
                entity.ToTable("affiliatepluspayment_offline");

                entity.HasIndex(e => e.PaymentId)
                    .HasName("payment_id");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddressHtml)
                    .IsRequired()
                    .HasColumnName("address_html")
                    .HasColumnType("text");

                entity.Property(e => e.AddressId)
                    .HasColumnName("address_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Message)
                    .IsRequired()
                    .HasColumnName("message")
                    .HasColumnType("text");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.TransferInfo)
                    .IsRequired()
                    .HasColumnName("transfer_info")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Payment)
                    .WithMany(p => p.AffiliatepluspaymentOffline)
                    .HasForeignKey(d => d.PaymentId)
                    .HasConstraintName("affiliatepluspayment_offline_ibfk_1");
            });

            modelBuilder.Entity<Affiliateplusprogram>(entity =>
            {
                entity.HasKey(e => e.ProgramId)
                    .HasName("PK_affiliateplusprogram");

                entity.ToTable("affiliateplusprogram");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ActionsSerialized)
                    .HasColumnName("actions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.AffiliateType)
                    .HasColumnName("affiliate_type")
                    .HasColumnType("varchar(15)");

                entity.Property(e => e.Autojoin)
                    .HasColumnName("autojoin")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Commission)
                    .HasColumnName("commission")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CommissionType)
                    .IsRequired()
                    .HasColumnName("commission_type")
                    .HasColumnType("varchar(31)");

                entity.Property(e => e.ConditionsSerialized)
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.CouponPattern)
                    .HasColumnName("coupon_pattern")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedDate)
                    .HasColumnName("created_date")
                    .HasColumnType("date");

                entity.Property(e => e.CustomerGroupIds)
                    .HasColumnName("customer_group_ids")
                    .HasColumnType("text");

                entity.Property(e => e.CustomerGroups)
                    .HasColumnName("customer_groups")
                    .HasColumnType("text");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.Discount)
                    .HasColumnName("discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountType)
                    .IsRequired()
                    .HasColumnName("discount_type")
                    .HasColumnType("varchar(31)");

                entity.Property(e => e.ExpireTime)
                    .HasColumnName("expire_time")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsProcess)
                    .HasColumnName("is_process")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MaxLevel)
                    .HasColumnName("max_level")
                    .HasColumnType("int(10)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NumAccount)
                    .HasColumnName("num_account")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Priority)
                    .HasColumnName("priority")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Scope)
                    .HasColumnName("scope")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SecCommission)
                    .HasColumnName("sec_commission")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SecCommissionType)
                    .HasColumnName("sec_commission_type")
                    .HasColumnType("varchar(31)");

                entity.Property(e => e.SecDiscount)
                    .HasColumnName("sec_discount")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SecDiscountType)
                    .HasColumnName("sec_discount_type")
                    .HasColumnType("varchar(31)");

                entity.Property(e => e.SecTierCommission)
                    .HasColumnName("sec_tier_commission")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.SecondaryCommission)
                    .HasColumnName("secondary_commission")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.SecondaryDiscount)
                    .HasColumnName("secondary_discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.ShowInWelcome)
                    .HasColumnName("show_in_welcome")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.TierCommission)
                    .HasColumnName("tier_commission")
                    .HasColumnType("text");

                entity.Property(e => e.TotalSalesAmount)
                    .HasColumnName("total_sales_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.UseCoupon)
                    .HasColumnName("use_coupon")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UseSecTier)
                    .HasColumnName("use_sec_tier")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UseTierConfig)
                    .HasColumnName("use_tier_config")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.ValidFrom)
                    .HasColumnName("valid_from")
                    .HasColumnType("date");

                entity.Property(e => e.ValidTo)
                    .HasColumnName("valid_to")
                    .HasColumnType("date");
            });

            modelBuilder.Entity<AffiliateplusprogramAccount>(entity =>
            {
                entity.ToTable("affiliateplusprogram_account");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.HasIndex(e => e.ProgramId)
                    .HasName("program_id_2");

                entity.HasIndex(e => new { e.ProgramId, e.AccountId })
                    .HasName("program_id")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Joined)
                    .HasColumnName("joined")
                    .HasColumnType("datetime");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusprogramAccount)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliateplusprogram_account_ibfk_2");

                entity.HasOne(d => d.Program)
                    .WithMany(p => p.AffiliateplusprogramAccount)
                    .HasForeignKey(d => d.ProgramId)
                    .HasConstraintName("affiliateplusprogram_account_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusprogramCategory>(entity =>
            {
                entity.ToTable("affiliateplusprogram_category");

                entity.HasIndex(e => e.CategoryId)
                    .HasName("category_id");

                entity.HasIndex(e => e.ProgramId)
                    .HasName("program_id_2");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.HasIndex(e => new { e.ProgramId, e.CategoryId, e.StoreId })
                    .HasName("program_id")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CategoryId)
                    .HasColumnName("category_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Category)
                    .WithMany(p => p.AffiliateplusprogramCategory)
                    .HasForeignKey(d => d.CategoryId)
                    .HasConstraintName("affiliateplusprogram_category_ibfk_2");

                entity.HasOne(d => d.Program)
                    .WithMany(p => p.AffiliateplusprogramCategory)
                    .HasForeignKey(d => d.ProgramId)
                    .HasConstraintName("affiliateplusprogram_category_ibfk_1");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.AffiliateplusprogramCategory)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("affiliateplusprogram_category_ibfk_3");
            });

            modelBuilder.Entity<AffiliateplusprogramJoined>(entity =>
            {
                entity.ToTable("affiliateplusprogram_joined");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.HasIndex(e => e.ProgramId)
                    .HasName("program_id_2");

                entity.HasIndex(e => new { e.ProgramId, e.AccountId })
                    .HasName("program_id")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusprogramJoined)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliateplusprogram_joined_ibfk_2");

                entity.HasOne(d => d.Program)
                    .WithMany(p => p.AffiliateplusprogramJoined)
                    .HasForeignKey(d => d.ProgramId)
                    .HasConstraintName("affiliateplusprogram_joined_ibfk_1");
            });

            modelBuilder.Entity<AffiliateplusprogramProduct>(entity =>
            {
                entity.ToTable("affiliateplusprogram_product");

                entity.HasIndex(e => e.ProductId)
                    .HasName("product_id");

                entity.HasIndex(e => e.ProgramId)
                    .HasName("program_id_2");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.HasIndex(e => new { e.ProgramId, e.ProductId, e.StoreId })
                    .HasName("program_id")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.AffiliateplusprogramProduct)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("affiliateplusprogram_product_ibfk_2");

                entity.HasOne(d => d.Program)
                    .WithMany(p => p.AffiliateplusprogramProduct)
                    .HasForeignKey(d => d.ProgramId)
                    .HasConstraintName("affiliateplusprogram_product_ibfk_1");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.AffiliateplusprogramProduct)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("affiliateplusprogram_product_ibfk_3");
            });

            modelBuilder.Entity<AffiliateplusprogramTransaction>(entity =>
            {
                entity.ToTable("affiliateplusprogram_transaction");

                entity.HasIndex(e => e.AccountId)
                    .HasName("account_id");

                entity.HasIndex(e => e.TransactionId)
                    .HasName("transaction_id");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .HasColumnName("account_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountName)
                    .IsRequired()
                    .HasColumnName("account_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Commission)
                    .HasColumnName("commission")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderItemIds)
                    .HasColumnName("order_item_ids")
                    .HasColumnType("text");

                entity.Property(e => e.OrderItemNames)
                    .HasColumnName("order_item_names")
                    .HasColumnType("text");

                entity.Property(e => e.OrderNumber)
                    .HasColumnName("order_number")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProgramName)
                    .IsRequired()
                    .HasColumnName("program_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TotalAmount)
                    .HasColumnName("total_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TransactionId)
                    .HasColumnName("transaction_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("tinyint(2)")
                    .HasDefaultValueSql("3");

                entity.HasOne(d => d.Account)
                    .WithMany(p => p.AffiliateplusprogramTransaction)
                    .HasForeignKey(d => d.AccountId)
                    .HasConstraintName("affiliateplusprogram_transaction_ibfk_1");

                entity.HasOne(d => d.Transaction)
                    .WithMany(p => p.AffiliateplusprogramTransaction)
                    .HasForeignKey(d => d.TransactionId)
                    .HasConstraintName("affiliateplusprogram_transaction_ibfk_2");
            });

            modelBuilder.Entity<AffiliateplusprogramValue>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_affiliateplusprogram_value");

                entity.ToTable("affiliateplusprogram_value");

                entity.HasIndex(e => e.ProgramId)
                    .HasName("program_id_2");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.HasIndex(e => new { e.ProgramId, e.StoreId, e.AttributeCode })
                    .HasName("program_id")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeCode)
                    .IsRequired()
                    .HasColumnName("attribute_code")
                    .HasColumnType("varchar(63)");

                entity.Property(e => e.ProgramId)
                    .HasColumnName("program_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Program)
                    .WithMany(p => p.AffiliateplusprogramValue)
                    .HasForeignKey(d => d.ProgramId)
                    .HasConstraintName("affiliateplusprogram_value_ibfk_1");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.AffiliateplusprogramValue)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("affiliateplusprogram_value_ibfk_2");
            });

            modelBuilder.Entity<Affiliateplusstatistic>(entity =>
            {
                entity.ToTable("affiliateplusstatistic");

                entity.HasIndex(e => e.RefererId)
                    .HasName("referer_id");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountEmail)
                    .HasColumnName("account_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IpAddress)
                    .IsRequired()
                    .HasColumnName("ip_address")
                    .HasColumnType("varchar(63)");

                entity.Property(e => e.Referer)
                    .IsRequired()
                    .HasColumnName("referer")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RefererId)
                    .HasColumnName("referer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UrlPath)
                    .IsRequired()
                    .HasColumnName("url_path")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("/");

                entity.Property(e => e.VisitAt)
                    .HasColumnName("visit_at")
                    .HasColumnType("datetime");

                entity.HasOne(d => d.RefererNavigation)
                    .WithMany(p => p.Affiliateplusstatistic)
                    .HasForeignKey(d => d.RefererId)
                    .HasConstraintName("affiliateplusstatistic_ibfk_1");
            });

            modelBuilder.Entity<Api2AclAttribute>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_api2_acl_attribute");

                entity.ToTable("api2_acl_attribute");

                entity.HasIndex(e => e.UserType)
                    .HasName("IDX_API2_ACL_ATTRIBUTE_USER_TYPE");

                entity.HasIndex(e => new { e.UserType, e.ResourceId, e.Operation })
                    .HasName("UNQ_API2_ACL_ATTRIBUTE_USER_TYPE_RESOURCE_ID_OPERATION")
                    .IsUnique();

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AllowedAttributes)
                    .HasColumnName("allowed_attributes")
                    .HasColumnType("text");

                entity.Property(e => e.Operation)
                    .IsRequired()
                    .HasColumnName("operation")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.ResourceId)
                    .IsRequired()
                    .HasColumnName("resource_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UserType)
                    .IsRequired()
                    .HasColumnName("user_type")
                    .HasColumnType("varchar(20)");
            });

            modelBuilder.Entity<Api2AclRole>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_api2_acl_role");

                entity.ToTable("api2_acl_role");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_API2_ACL_ROLE_CREATED_AT");

                entity.HasIndex(e => e.UpdatedAt)
                    .HasName("IDX_API2_ACL_ROLE_UPDATED_AT");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.RoleName)
                    .IsRequired()
                    .HasColumnName("role_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<Api2AclRule>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_api2_acl_rule");

                entity.ToTable("api2_acl_rule");

                entity.HasIndex(e => new { e.RoleId, e.ResourceId, e.Privilege })
                    .HasName("UNQ_API2_ACL_RULE_ROLE_ID_RESOURCE_ID_PRIVILEGE")
                    .IsUnique();

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Privilege)
                    .IsRequired()
                    .HasColumnName("privilege")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.ResourceId)
                    .IsRequired()
                    .HasColumnName("resource_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RoleId)
                    .HasColumnName("role_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Role)
                    .WithMany(p => p.Api2AclRule)
                    .HasForeignKey(d => d.RoleId)
                    .HasConstraintName("FK_API2_ACL_RULE_ROLE_ID_API2_ACL_ROLE_ENTITY_ID");
            });

            modelBuilder.Entity<Api2AclUser>(entity =>
            {
                entity.HasKey(e => e.AdminId)
                    .HasName("UNQ_API2_ACL_USER_ADMIN_ID");

                entity.ToTable("api2_acl_user");

                entity.HasIndex(e => e.RoleId)
                    .HasName("FK_API2_ACL_USER_ROLE_ID_API2_ACL_ROLE_ENTITY_ID");

                entity.Property(e => e.AdminId)
                    .HasColumnName("admin_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.RoleId)
                    .HasColumnName("role_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Admin)
                    .WithOne(p => p.Api2AclUser)
                    .HasForeignKey<Api2AclUser>(d => d.AdminId)
                    .HasConstraintName("FK_API2_ACL_USER_ADMIN_ID_ADMIN_USER_USER_ID");

                entity.HasOne(d => d.Role)
                    .WithMany(p => p.Api2AclUser)
                    .HasForeignKey(d => d.RoleId)
                    .HasConstraintName("FK_API2_ACL_USER_ROLE_ID_API2_ACL_ROLE_ENTITY_ID");
            });

            modelBuilder.Entity<ApiAssert>(entity =>
            {
                entity.HasKey(e => e.AssertId)
                    .HasName("PK_api_assert");

                entity.ToTable("api_assert");

                entity.Property(e => e.AssertId)
                    .HasColumnName("assert_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AssertData)
                    .HasColumnName("assert_data")
                    .HasColumnType("text");

                entity.Property(e => e.AssertType)
                    .HasColumnName("assert_type")
                    .HasColumnType("varchar(20)");
            });

            modelBuilder.Entity<ApiRole>(entity =>
            {
                entity.HasKey(e => e.RoleId)
                    .HasName("PK_api_role");

                entity.ToTable("api_role");

                entity.HasIndex(e => e.TreeLevel)
                    .HasName("IDX_API_ROLE_TREE_LEVEL");

                entity.HasIndex(e => new { e.ParentId, e.SortOrder })
                    .HasName("IDX_API_ROLE_PARENT_ID_SORT_ORDER");

                entity.Property(e => e.RoleId)
                    .HasColumnName("role_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RoleName)
                    .HasColumnName("role_name")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.RoleType)
                    .IsRequired()
                    .HasColumnName("role_type")
                    .HasColumnType("varchar(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TreeLevel)
                    .HasColumnName("tree_level")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<ApiRule>(entity =>
            {
                entity.HasKey(e => e.RuleId)
                    .HasName("PK_api_rule");

                entity.ToTable("api_rule");

                entity.HasIndex(e => new { e.ResourceId, e.RoleId })
                    .HasName("IDX_API_RULE_RESOURCE_ID_ROLE_ID");

                entity.HasIndex(e => new { e.RoleId, e.ResourceId })
                    .HasName("IDX_API_RULE_ROLE_ID_RESOURCE_ID");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ApiPermission)
                    .HasColumnName("api_permission")
                    .HasColumnType("varchar(10)");

                entity.Property(e => e.ApiPrivileges)
                    .HasColumnName("api_privileges")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.AssertId)
                    .HasColumnName("assert_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ResourceId)
                    .HasColumnName("resource_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RoleId)
                    .HasColumnName("role_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RoleType)
                    .HasColumnName("role_type")
                    .HasColumnType("varchar(1)");

                entity.HasOne(d => d.Role)
                    .WithMany(p => p.ApiRule)
                    .HasForeignKey(d => d.RoleId)
                    .HasConstraintName("FK_API_RULE_ROLE_ID_API_ROLE_ROLE_ID");
            });

            modelBuilder.Entity<ApiUser>(entity =>
            {
                entity.HasKey(e => e.UserId)
                    .HasName("PK_api_user");

                entity.ToTable("api_user");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ApiKey)
                    .HasColumnName("api_key")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Created)
                    .HasColumnName("created")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Email)
                    .HasColumnName("email")
                    .HasColumnType("varchar(128)");

                entity.Property(e => e.Firstname)
                    .HasColumnName("firstname")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Lastname)
                    .HasColumnName("lastname")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Lognum)
                    .HasColumnName("lognum")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Modified)
                    .HasColumnName("modified")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ReloadAclFlag)
                    .HasColumnName("reload_acl_flag")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Username)
                    .HasColumnName("username")
                    .HasColumnType("varchar(40)");
            });

            modelBuilder.Entity<ApptrianImageoptimizerFiles>(entity =>
            {
                entity.ToTable("apptrian_imageoptimizer_files");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.FilePath)
                    .IsRequired()
                    .HasColumnName("file_path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NewFileSize)
                    .HasColumnName("new_file_size")
                    .HasColumnType("int(11) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OldFileSize)
                    .HasColumnName("old_file_size")
                    .HasColumnType("int(11) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OptimizationTime)
                    .HasColumnName("optimization_time")
                    .HasColumnType("int(11) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Optimized)
                    .HasColumnName("optimized")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<CaptchaLog>(entity =>
            {
                entity.HasKey(e => new { e.Type, e.Value })
                    .HasName("PK_captcha_log");

                entity.ToTable("captcha_log");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Count)
                    .HasColumnName("count")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<CatalogCategoryEntity>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_catalog_category_entity");

                entity.ToTable("catalog_category_entity");

                entity.HasIndex(e => e.Level)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_LEVEL");

                entity.HasIndex(e => new { e.Path, e.EntityId })
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_PATH_ENTITY_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ChildrenCount)
                    .HasColumnName("children_count")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Level)
                    .HasColumnName("level")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Path)
                    .IsRequired()
                    .HasColumnName("path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<CatalogCategoryEntityDatetime>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_category_entity_datetime");

                entity.ToTable("catalog_category_entity_datetime");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID");

                entity.HasIndex(e => new { e.EntityTypeId, e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_CTGR_ENTT_DTIME_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("datetime");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogCategoryEntityDatetime)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogCategoryEntityDatetime)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_DTIME_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryEntityDatetime)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCategoryEntityDecimal>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_category_entity_decimal");

                entity.ToTable("catalog_category_entity_decimal");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID");

                entity.HasIndex(e => new { e.EntityTypeId, e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_CTGR_ENTT_DEC_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogCategoryEntityDecimal)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogCategoryEntityDecimal)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_DEC_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryEntityDecimal)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCategoryEntityInt>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_category_entity_int");

                entity.ToTable("catalog_category_entity_int");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_INT_STORE_ID");

                entity.HasIndex(e => new { e.EntityTypeId, e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_CTGR_ENTT_INT_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogCategoryEntityInt)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogCategoryEntityInt)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_INT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryEntityInt)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_ENTITY_INT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCategoryEntityText>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_category_entity_text");

                entity.ToTable("catalog_category_entity_text");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID");

                entity.HasIndex(e => new { e.EntityTypeId, e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_CTGR_ENTT_TEXT_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogCategoryEntityText)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogCategoryEntityText)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_TEXT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryEntityText)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCategoryEntityVarchar>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_category_entity_varchar");

                entity.ToTable("catalog_category_entity_varchar");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID");

                entity.HasIndex(e => new { e.EntityTypeId, e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_CTGR_ENTT_VCHR_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogCategoryEntityVarchar)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogCategoryEntityVarchar)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_CTGR_ENTT_VCHR_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryEntityVarchar)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCategoryFlatStore1>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_catalog_category_flat_store_1");

                entity.ToTable("catalog_category_flat_store_1");

                entity.HasIndex(e => e.Level)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_1_LEVEL");

                entity.HasIndex(e => e.Path)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_1_PATH");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_1_STORE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AllChildren)
                    .HasColumnName("all_children")
                    .HasColumnType("text");

                entity.Property(e => e.AvailableSortBy)
                    .HasColumnName("available_sort_by")
                    .HasColumnType("text");

                entity.Property(e => e.Children)
                    .HasColumnName("children")
                    .HasColumnType("text");

                entity.Property(e => e.ChildrenCount)
                    .HasColumnName("children_count")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CustomApplyToProducts)
                    .HasColumnName("custom_apply_to_products")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CustomDesign)
                    .HasColumnName("custom_design")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomDesignFrom)
                    .HasColumnName("custom_design_from")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomDesignTo)
                    .HasColumnName("custom_design_to")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomLayoutUpdate)
                    .HasColumnName("custom_layout_update")
                    .HasColumnType("text");

                entity.Property(e => e.CustomUseParentSettings)
                    .HasColumnName("custom_use_parent_settings")
                    .HasColumnType("int(11)");

                entity.Property(e => e.DefaultSortBy)
                    .HasColumnName("default_sort_by")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DisplayMode)
                    .HasColumnName("display_mode")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FilterPriceRange)
                    .HasColumnName("filter_price_range")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Image)
                    .HasColumnName("image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IncludeInMenu)
                    .HasColumnName("include_in_menu")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsAnchor)
                    .HasColumnName("is_anchor")
                    .HasColumnType("int(11)");

                entity.Property(e => e.LandingPage)
                    .HasColumnName("landing_page")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Level)
                    .HasColumnName("level")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MarketingTitle)
                    .HasColumnName("marketing_title")
                    .HasColumnType("text");

                entity.Property(e => e.MetaDescription)
                    .HasColumnName("meta_description")
                    .HasColumnType("text");

                entity.Property(e => e.MetaKeywords)
                    .HasColumnName("meta_keywords")
                    .HasColumnType("text");

                entity.Property(e => e.MetaTitle)
                    .HasColumnName("meta_title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PageLayout)
                    .HasColumnName("page_layout")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Path)
                    .IsRequired()
                    .HasColumnName("path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PathInStore)
                    .HasColumnName("path_in_store")
                    .HasColumnType("text");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Thumbnail)
                    .HasColumnName("thumbnail")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UrlKey)
                    .HasColumnName("url_key")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UrlPath)
                    .HasColumnName("url_path")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.CatalogCategoryFlatStore1)
                    .HasForeignKey<CatalogCategoryFlatStore1>(d => d.EntityId)
                    .HasConstraintName("FK_CAT_CTGR_FLAT_STORE_1_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryFlatStore1)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_FLAT_STORE_1_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCategoryFlatStore2>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_catalog_category_flat_store_2");

                entity.ToTable("catalog_category_flat_store_2");

                entity.HasIndex(e => e.Level)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_2_LEVEL");

                entity.HasIndex(e => e.Path)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_2_PATH");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_2_STORE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AllChildren)
                    .HasColumnName("all_children")
                    .HasColumnType("text");

                entity.Property(e => e.AvailableSortBy)
                    .HasColumnName("available_sort_by")
                    .HasColumnType("text");

                entity.Property(e => e.Children)
                    .HasColumnName("children")
                    .HasColumnType("text");

                entity.Property(e => e.ChildrenCount)
                    .HasColumnName("children_count")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CustomApplyToProducts)
                    .HasColumnName("custom_apply_to_products")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CustomDesign)
                    .HasColumnName("custom_design")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomDesignFrom)
                    .HasColumnName("custom_design_from")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomDesignTo)
                    .HasColumnName("custom_design_to")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomLayoutUpdate)
                    .HasColumnName("custom_layout_update")
                    .HasColumnType("text");

                entity.Property(e => e.CustomUseParentSettings)
                    .HasColumnName("custom_use_parent_settings")
                    .HasColumnType("int(11)");

                entity.Property(e => e.DefaultSortBy)
                    .HasColumnName("default_sort_by")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DisplayMode)
                    .HasColumnName("display_mode")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FilterPriceRange)
                    .HasColumnName("filter_price_range")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Image)
                    .HasColumnName("image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IncludeInMenu)
                    .HasColumnName("include_in_menu")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsAnchor)
                    .HasColumnName("is_anchor")
                    .HasColumnType("int(11)");

                entity.Property(e => e.LandingPage)
                    .HasColumnName("landing_page")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Level)
                    .HasColumnName("level")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MarketingTitle)
                    .HasColumnName("marketing_title")
                    .HasColumnType("text");

                entity.Property(e => e.MetaDescription)
                    .HasColumnName("meta_description")
                    .HasColumnType("text");

                entity.Property(e => e.MetaKeywords)
                    .HasColumnName("meta_keywords")
                    .HasColumnType("text");

                entity.Property(e => e.MetaTitle)
                    .HasColumnName("meta_title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PageLayout)
                    .HasColumnName("page_layout")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Path)
                    .IsRequired()
                    .HasColumnName("path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PathInStore)
                    .HasColumnName("path_in_store")
                    .HasColumnType("text");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Thumbnail)
                    .HasColumnName("thumbnail")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UrlKey)
                    .HasColumnName("url_key")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UrlPath)
                    .HasColumnName("url_path")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.CatalogCategoryFlatStore2)
                    .HasForeignKey<CatalogCategoryFlatStore2>(d => d.EntityId)
                    .HasConstraintName("FK_CAT_CTGR_FLAT_STORE_2_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryFlatStore2)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_FLAT_STORE_2_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCategoryFlatStore3>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_catalog_category_flat_store_3");

                entity.ToTable("catalog_category_flat_store_3");

                entity.HasIndex(e => e.Level)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_3_LEVEL");

                entity.HasIndex(e => e.Path)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_3_PATH");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_CATEGORY_FLAT_STORE_3_STORE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AllChildren)
                    .HasColumnName("all_children")
                    .HasColumnType("text");

                entity.Property(e => e.AvailableSortBy)
                    .HasColumnName("available_sort_by")
                    .HasColumnType("text");

                entity.Property(e => e.Children)
                    .HasColumnName("children")
                    .HasColumnType("text");

                entity.Property(e => e.ChildrenCount)
                    .HasColumnName("children_count")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CustomApplyToProducts)
                    .HasColumnName("custom_apply_to_products")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CustomDesign)
                    .HasColumnName("custom_design")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomDesignFrom)
                    .HasColumnName("custom_design_from")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomDesignTo)
                    .HasColumnName("custom_design_to")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomLayoutUpdate)
                    .HasColumnName("custom_layout_update")
                    .HasColumnType("text");

                entity.Property(e => e.CustomUseParentSettings)
                    .HasColumnName("custom_use_parent_settings")
                    .HasColumnType("int(11)");

                entity.Property(e => e.DefaultSortBy)
                    .HasColumnName("default_sort_by")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DisplayMode)
                    .HasColumnName("display_mode")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FilterPriceRange)
                    .HasColumnName("filter_price_range")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Image)
                    .HasColumnName("image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IncludeInMenu)
                    .HasColumnName("include_in_menu")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsAnchor)
                    .HasColumnName("is_anchor")
                    .HasColumnType("int(11)");

                entity.Property(e => e.LandingPage)
                    .HasColumnName("landing_page")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Level)
                    .HasColumnName("level")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MarketingTitle)
                    .HasColumnName("marketing_title")
                    .HasColumnType("text");

                entity.Property(e => e.MetaDescription)
                    .HasColumnName("meta_description")
                    .HasColumnType("text");

                entity.Property(e => e.MetaKeywords)
                    .HasColumnName("meta_keywords")
                    .HasColumnType("text");

                entity.Property(e => e.MetaTitle)
                    .HasColumnName("meta_title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PageLayout)
                    .HasColumnName("page_layout")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Path)
                    .IsRequired()
                    .HasColumnName("path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PathInStore)
                    .HasColumnName("path_in_store")
                    .HasColumnType("text");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Thumbnail)
                    .HasColumnName("thumbnail")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UrlKey)
                    .HasColumnName("url_key")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UrlPath)
                    .HasColumnName("url_path")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.CatalogCategoryFlatStore3)
                    .HasForeignKey<CatalogCategoryFlatStore3>(d => d.EntityId)
                    .HasConstraintName("FK_CAT_CTGR_FLAT_STORE_3_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryFlatStore3)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_FLAT_STORE_3_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCategoryProduct>(entity =>
            {
                entity.HasKey(e => new { e.CategoryId, e.ProductId })
                    .HasName("PK_catalog_category_product");

                entity.ToTable("catalog_category_product");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOG_CATEGORY_PRODUCT_PRODUCT_ID");

                entity.Property(e => e.CategoryId)
                    .HasColumnName("category_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Category)
                    .WithMany(p => p.CatalogCategoryProduct)
                    .HasForeignKey(d => d.CategoryId)
                    .HasConstraintName("FK_CAT_CTGR_PRD_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogCategoryProduct)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_CTGR_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogCategoryProductIndex>(entity =>
            {
                entity.HasKey(e => new { e.CategoryId, e.ProductId, e.StoreId })
                    .HasName("PK_catalog_category_product_index");

                entity.ToTable("catalog_category_product_index");

                entity.HasIndex(e => new { e.ProductId, e.StoreId, e.CategoryId, e.Visibility })
                    .HasName("IDX_CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY");

                entity.HasIndex(e => new { e.StoreId, e.CategoryId, e.Visibility, e.IsParent, e.Position })
                    .HasName("15D3C269665C74C2219037D534F4B0DC");

                entity.Property(e => e.CategoryId)
                    .HasColumnName("category_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsParent)
                    .HasColumnName("is_parent")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Visibility)
                    .HasColumnName("visibility")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Category)
                    .WithMany(p => p.CatalogCategoryProductIndex)
                    .HasForeignKey(d => d.CategoryId)
                    .HasConstraintName("FK_CAT_CTGR_PRD_IDX_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogCategoryProductIndex)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_CTGR_PRD_IDX_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCategoryProductIndex)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_CATEGORY_PRODUCT_INDEX_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogCompareItem>(entity =>
            {
                entity.ToTable("catalog_compare_item");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_CATALOG_COMPARE_ITEM_CUSTOMER_ID");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOG_COMPARE_ITEM_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_COMPARE_ITEM_STORE_ID");

                entity.HasIndex(e => new { e.CustomerId, e.ProductId })
                    .HasName("IDX_CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID");

                entity.HasIndex(e => new { e.VisitorId, e.ProductId })
                    .HasName("IDX_CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID");

                entity.Property(e => e.CatalogCompareItemId)
                    .HasColumnName("catalog_compare_item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.VisitorId)
                    .HasColumnName("visitor_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.CatalogCompareItem)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_CATALOG_COMPARE_ITEM_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogCompareItem)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_CMP_ITEM_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogCompareItem)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_CATALOG_COMPARE_ITEM_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogEavAttribute>(entity =>
            {
                entity.HasKey(e => e.AttributeId)
                    .HasName("PK_catalog_eav_attribute");

                entity.ToTable("catalog_eav_attribute");

                entity.HasIndex(e => e.UsedForSortBy)
                    .HasName("IDX_CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY");

                entity.HasIndex(e => e.UsedInProductListing)
                    .HasName("IDX_CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.ApplyTo)
                    .HasColumnName("apply_to")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FrontendInputRenderer)
                    .HasColumnName("frontend_input_renderer")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsComparable)
                    .HasColumnName("is_comparable")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsConfigurable)
                    .HasColumnName("is_configurable")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsFilterable)
                    .HasColumnName("is_filterable")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsFilterableInSearch)
                    .HasColumnName("is_filterable_in_search")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsGlobal)
                    .HasColumnName("is_global")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsHtmlAllowedOnFront)
                    .HasColumnName("is_html_allowed_on_front")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsSearchable)
                    .HasColumnName("is_searchable")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsUsedForPriceRules)
                    .HasColumnName("is_used_for_price_rules")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsUsedForPromoRules)
                    .HasColumnName("is_used_for_promo_rules")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsVisible)
                    .HasColumnName("is_visible")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsVisibleInAdvancedSearch)
                    .HasColumnName("is_visible_in_advanced_search")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsVisibleOnFront)
                    .HasColumnName("is_visible_on_front")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsWysiwygEnabled)
                    .HasColumnName("is_wysiwyg_enabled")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UsedForSortBy)
                    .HasColumnName("used_for_sort_by")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UsedInProductListing)
                    .HasColumnName("used_in_product_listing")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Attribute)
                    .WithOne(p => p.CatalogEavAttribute)
                    .HasForeignKey<CatalogEavAttribute>(d => d.AttributeId)
                    .HasConstraintName("FK_CATALOG_EAV_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID");
            });

            modelBuilder.Entity<CatalogProductBundleOption>(entity =>
            {
                entity.HasKey(e => e.OptionId)
                    .HasName("PK_catalog_product_bundle_option");

                entity.ToTable("catalog_product_bundle_option");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Required)
                    .HasColumnName("required")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.CatalogProductBundleOption)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_CAT_PRD_BNDL_OPT_PARENT_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductBundleOptionValue>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_bundle_option_value");

                entity.ToTable("catalog_product_bundle_option_value");

                entity.HasIndex(e => new { e.OptionId, e.StoreId })
                    .HasName("UNQ_CATALOG_PRODUCT_BUNDLE_OPTION_VALUE_OPTION_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Option)
                    .WithMany(p => p.CatalogProductBundleOptionValue)
                    .HasForeignKey(d => d.OptionId)
                    .HasConstraintName("FK_CAT_PRD_BNDL_OPT_VAL_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID");
            });

            modelBuilder.Entity<CatalogProductBundlePriceIndex>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.WebsiteId, e.CustomerGroupId })
                    .HasName("PK_catalog_product_bundle_price_index");

                entity.ToTable("catalog_product_bundle_price_index");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogProductBundlePriceIndex)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_CAT_PRD_BNDL_PRICE_IDX_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductBundlePriceIndex)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductBundlePriceIndex)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_BNDL_PRICE_IDX_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductBundleSelection>(entity =>
            {
                entity.HasKey(e => e.SelectionId)
                    .HasName("PK_catalog_product_bundle_selection");

                entity.ToTable("catalog_product_bundle_selection");

                entity.HasIndex(e => e.OptionId)
                    .HasName("IDX_CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID");

                entity.Property(e => e.SelectionId)
                    .HasColumnName("selection_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.IsDefault)
                    .HasColumnName("is_default")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentProductId)
                    .HasColumnName("parent_product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.SelectionCanChangeQty)
                    .HasColumnName("selection_can_change_qty")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SelectionPriceType)
                    .HasColumnName("selection_price_type")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SelectionPriceValue)
                    .HasColumnName("selection_price_value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.SelectionQty)
                    .HasColumnName("selection_qty")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Option)
                    .WithMany(p => p.CatalogProductBundleSelection)
                    .HasForeignKey(d => d.OptionId)
                    .HasConstraintName("FK_CAT_PRD_BNDL_SELECTION_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogProductBundleSelection)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_PRD_BNDL_SELECTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductBundleSelectionPrice>(entity =>
            {
                entity.HasKey(e => new { e.SelectionId, e.WebsiteId })
                    .HasName("PK_catalog_product_bundle_selection_price");

                entity.ToTable("catalog_product_bundle_selection_price");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID");

                entity.Property(e => e.SelectionId)
                    .HasColumnName("selection_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SelectionPriceType)
                    .HasColumnName("selection_price_type")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SelectionPriceValue)
                    .HasColumnName("selection_price_value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Selection)
                    .WithMany(p => p.CatalogProductBundleSelectionPrice)
                    .HasForeignKey(d => d.SelectionId)
                    .HasConstraintName("FK_DCF37523AA05D770A70AA4ED7C2616E4");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductBundleSelectionPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductBundleStockIndex>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.WebsiteId, e.StockId, e.OptionId })
                    .HasName("PK_catalog_product_bundle_stock_index");

                entity.ToTable("catalog_product_bundle_stock_index");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StockId)
                    .HasColumnName("stock_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StockStatus)
                    .HasColumnName("stock_status")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<CatalogProductEnabledIndex>(entity =>
            {
                entity.HasKey(e => new { e.ProductId, e.StoreId })
                    .HasName("PK_catalog_product_enabled_index");

                entity.ToTable("catalog_product_enabled_index");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_ENABLED_INDEX_STORE_ID");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Visibility)
                    .HasColumnName("visibility")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogProductEnabledIndex)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_PRD_ENABLED_IDX_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductEnabledIndex)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_ENABLED_INDEX_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductEntity>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_catalog_product_entity");

                entity.ToTable("catalog_product_entity");

                entity.HasIndex(e => e.AttributeSetId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.Sku)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_SKU");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.HasOptions)
                    .HasColumnName("has_options")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RequiredOptions)
                    .HasColumnName("required_options")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.TypeId)
                    .IsRequired()
                    .HasColumnName("type_id")
                    .HasColumnType("varchar(32)")
                    .HasDefaultValueSql("simple");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.HasOne(d => d.AttributeSet)
                    .WithMany(p => p.CatalogProductEntity)
                    .HasForeignKey(d => d.AttributeSetId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_ATTR_SET_ID_EAV_ATTR_SET_ATTR_SET_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CatalogProductEntity)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CatalogProductEntityDatetime>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_datetime");

                entity.ToTable("catalog_product_entity_datetime");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_PRD_ENTT_DTIME_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("datetime");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductEntityDatetime)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityDatetime)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductEntityDatetime)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductEntityDecimal>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_decimal");

                entity.ToTable("catalog_product_entity_decimal");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_DECIMAL_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_PRD_ENTT_DEC_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductEntityDecimal)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityDecimal)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_DEC_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductEntityDecimal)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductEntityGallery>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_gallery");

                entity.ToTable("catalog_product_entity_gallery");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID");

                entity.HasIndex(e => new { e.EntityTypeId, e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_PRD_ENTT_GLR_ENTT_TYPE_ID_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductEntityGallery)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_GLR_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityGallery)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_GLR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductEntityGallery)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductEntityGroupPrice>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_group_price");

                entity.ToTable("catalog_product_entity_group_price");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_GROUP_PRICE_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_GROUP_PRICE_ENTITY_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_GROUP_PRICE_WEBSITE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AllGroups, e.CustomerGroupId, e.WebsiteId })
                    .HasName("CC12C83765B562314470A24F2BDD0F36")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AllGroups)
                    .HasColumnName("all_groups")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogProductEntityGroupPrice)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_DF909D22C11B60B1E5E3EE64AB220ECE");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityGroupPrice)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_GROUP_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductEntityGroupPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_GROUP_PRICE_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductEntityInt>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_int");

                entity.ToTable("catalog_product_entity_int");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_INT_STORE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductEntityInt)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityInt)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_INT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductEntityInt)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_ENTITY_INT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductEntityMediaGallery>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_media_gallery");

                entity.ToTable("catalog_product_entity_media_gallery");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ENTITY_ID");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductEntityMediaGallery)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_MDA_GLR_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityMediaGallery)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_MDA_GLR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductEntityMediaGalleryValue>(entity =>
            {
                entity.HasKey(e => new { e.ValueId, e.StoreId })
                    .HasName("PK_catalog_product_entity_media_gallery_value");

                entity.ToTable("catalog_product_entity_media_gallery_value");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Disabled)
                    .HasColumnName("disabled")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Label)
                    .HasColumnName("label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductEntityMediaGalleryValue)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_MDA_GLR_VAL_STORE_ID_CORE_STORE_STORE_ID");

                entity.HasOne(d => d.Value)
                    .WithMany(p => p.CatalogProductEntityMediaGalleryValue)
                    .HasForeignKey(d => d.ValueId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_MDA_GLR_VAL_VAL_ID_CAT_PRD_ENTT_MDA_GLR_VAL_ID");
            });

            modelBuilder.Entity<CatalogProductEntityText>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_text");

                entity.ToTable("catalog_product_entity_text");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductEntityText)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityText)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_TEXT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductEntityText)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductEntityTierPrice>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_tier_price");

                entity.ToTable("catalog_product_entity_tier_price");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_TIER_PRICE_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_TIER_PRICE_ENTITY_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_TIER_PRICE_WEBSITE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AllGroups, e.CustomerGroupId, e.Qty, e.WebsiteId })
                    .HasName("E8AB433B9ACB00343ABB312AD2FAB087")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AllGroups)
                    .HasColumnName("all_groups")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("1.0000");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogProductEntityTierPrice)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_6E08D719F0501DD1D8E6D4EFF2511C85");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityTierPrice)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_TIER_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductEntityTierPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_TIER_PRICE_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductEntityVarchar>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_entity_varchar");

                entity.ToTable("catalog_product_entity_varchar");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_VARCHAR_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_VARCHAR_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_CAT_PRD_ENTT_VCHR_ENTT_ID_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductEntityVarchar)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductEntityVarchar)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_ENTT_VCHR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductEntityVarchar)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductFlat1>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_catalog_product_flat_1");

                entity.ToTable("catalog_product_flat_1");

                entity.HasIndex(e => e.AttributeSetId)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_1_ATTRIBUTE_SET_ID");

                entity.HasIndex(e => e.Name)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_1_NAME");

                entity.HasIndex(e => e.Price)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_1_PRICE");

                entity.HasIndex(e => e.TypeId)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_1_TYPE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Cost)
                    .HasColumnName("cost")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.EnableGooglecheckout)
                    .HasColumnName("enable_googlecheckout")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.GiftMessageAvailable)
                    .HasColumnName("gift_message_available")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.HasOptions)
                    .HasColumnName("has_options")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ImageLabel)
                    .HasColumnName("image_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsRecurring)
                    .HasColumnName("is_recurring")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.LinksExist)
                    .HasColumnName("links_exist")
                    .HasColumnType("int(11)");

                entity.Property(e => e.LinksPurchasedSeparately)
                    .HasColumnName("links_purchased_separately")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Msrp)
                    .HasColumnName("msrp")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MsrpDisplayActualPriceType)
                    .HasColumnName("msrp_display_actual_price_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.MsrpEnabled)
                    .HasColumnName("msrp_enabled")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NewsFromDate)
                    .HasColumnName("news_from_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.NewsToDate)
                    .HasColumnName("news_to_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PriceType)
                    .HasColumnName("price_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.PriceView)
                    .HasColumnName("price_view")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RecurringProfile)
                    .HasColumnName("recurring_profile")
                    .HasColumnType("text");

                entity.Property(e => e.RequiredOptions)
                    .HasColumnName("required_options")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ShipmentType)
                    .HasColumnName("shipment_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShortDescription)
                    .HasColumnName("short_description")
                    .HasColumnType("text");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.SkuType)
                    .HasColumnName("sku_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.SmallImage)
                    .HasColumnName("small_image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SmallImageLabel)
                    .HasColumnName("small_image_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SpPrice)
                    .HasColumnName("sp_price")
                    .HasColumnType("text");

                entity.Property(e => e.SpecialFromDate)
                    .HasColumnName("special_from_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.SpecialPrice)
                    .HasColumnName("special_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SpecialToDate)
                    .HasColumnName("special_to_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Thumbnail)
                    .HasColumnName("thumbnail")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ThumbnailLabel)
                    .HasColumnName("thumbnail_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TypeId)
                    .IsRequired()
                    .HasColumnName("type_id")
                    .HasColumnType("varchar(32)")
                    .HasDefaultValueSql("simple");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UrlKey)
                    .HasColumnName("url_key")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UrlPath)
                    .HasColumnName("url_path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Visibility)
                    .HasColumnName("visibility")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeightType)
                    .HasColumnName("weight_type")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.CatalogProductFlat1)
                    .HasForeignKey<CatalogProductFlat1>(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_FLAT_1_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductFlat2>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_catalog_product_flat_2");

                entity.ToTable("catalog_product_flat_2");

                entity.HasIndex(e => e.AttributeSetId)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_2_ATTRIBUTE_SET_ID");

                entity.HasIndex(e => e.Name)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_2_NAME");

                entity.HasIndex(e => e.Price)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_2_PRICE");

                entity.HasIndex(e => e.TypeId)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_2_TYPE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Cost)
                    .HasColumnName("cost")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.EnableGooglecheckout)
                    .HasColumnName("enable_googlecheckout")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.GiftMessageAvailable)
                    .HasColumnName("gift_message_available")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.HasOptions)
                    .HasColumnName("has_options")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ImageLabel)
                    .HasColumnName("image_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsRecurring)
                    .HasColumnName("is_recurring")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.LinksExist)
                    .HasColumnName("links_exist")
                    .HasColumnType("int(11)");

                entity.Property(e => e.LinksPurchasedSeparately)
                    .HasColumnName("links_purchased_separately")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Msrp)
                    .HasColumnName("msrp")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MsrpDisplayActualPriceType)
                    .HasColumnName("msrp_display_actual_price_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.MsrpEnabled)
                    .HasColumnName("msrp_enabled")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NewsFromDate)
                    .HasColumnName("news_from_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.NewsToDate)
                    .HasColumnName("news_to_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PriceType)
                    .HasColumnName("price_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.PriceView)
                    .HasColumnName("price_view")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RecurringProfile)
                    .HasColumnName("recurring_profile")
                    .HasColumnType("text");

                entity.Property(e => e.RequiredOptions)
                    .HasColumnName("required_options")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ShipmentType)
                    .HasColumnName("shipment_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShortDescription)
                    .HasColumnName("short_description")
                    .HasColumnType("text");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.SkuType)
                    .HasColumnName("sku_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.SmallImage)
                    .HasColumnName("small_image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SmallImageLabel)
                    .HasColumnName("small_image_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SpPrice)
                    .HasColumnName("sp_price")
                    .HasColumnType("text");

                entity.Property(e => e.SpecialFromDate)
                    .HasColumnName("special_from_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.SpecialPrice)
                    .HasColumnName("special_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SpecialToDate)
                    .HasColumnName("special_to_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Thumbnail)
                    .HasColumnName("thumbnail")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ThumbnailLabel)
                    .HasColumnName("thumbnail_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TypeId)
                    .IsRequired()
                    .HasColumnName("type_id")
                    .HasColumnType("varchar(32)")
                    .HasDefaultValueSql("simple");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UrlKey)
                    .HasColumnName("url_key")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UrlPath)
                    .HasColumnName("url_path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Visibility)
                    .HasColumnName("visibility")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeightType)
                    .HasColumnName("weight_type")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.CatalogProductFlat2)
                    .HasForeignKey<CatalogProductFlat2>(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_FLAT_2_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductFlat3>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_catalog_product_flat_3");

                entity.ToTable("catalog_product_flat_3");

                entity.HasIndex(e => e.AttributeSetId)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_3_ATTRIBUTE_SET_ID");

                entity.HasIndex(e => e.Name)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_3_NAME");

                entity.HasIndex(e => e.Price)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_3_PRICE");

                entity.HasIndex(e => e.TypeId)
                    .HasName("IDX_CATALOG_PRODUCT_FLAT_3_TYPE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Cost)
                    .HasColumnName("cost")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.EnableGooglecheckout)
                    .HasColumnName("enable_googlecheckout")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.GiftMessageAvailable)
                    .HasColumnName("gift_message_available")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.HasOptions)
                    .HasColumnName("has_options")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ImageLabel)
                    .HasColumnName("image_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsRecurring)
                    .HasColumnName("is_recurring")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.LinksExist)
                    .HasColumnName("links_exist")
                    .HasColumnType("int(11)");

                entity.Property(e => e.LinksPurchasedSeparately)
                    .HasColumnName("links_purchased_separately")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Msrp)
                    .HasColumnName("msrp")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MsrpDisplayActualPriceType)
                    .HasColumnName("msrp_display_actual_price_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.MsrpEnabled)
                    .HasColumnName("msrp_enabled")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NewsFromDate)
                    .HasColumnName("news_from_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.NewsToDate)
                    .HasColumnName("news_to_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PriceType)
                    .HasColumnName("price_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.PriceView)
                    .HasColumnName("price_view")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RecurringProfile)
                    .HasColumnName("recurring_profile")
                    .HasColumnType("text");

                entity.Property(e => e.RequiredOptions)
                    .HasColumnName("required_options")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ShipmentType)
                    .HasColumnName("shipment_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShortDescription)
                    .HasColumnName("short_description")
                    .HasColumnType("text");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.SkuType)
                    .HasColumnName("sku_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.SmallImage)
                    .HasColumnName("small_image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SmallImageLabel)
                    .HasColumnName("small_image_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SpPrice)
                    .HasColumnName("sp_price")
                    .HasColumnType("text");

                entity.Property(e => e.SpecialFromDate)
                    .HasColumnName("special_from_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.SpecialPrice)
                    .HasColumnName("special_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SpecialToDate)
                    .HasColumnName("special_to_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Thumbnail)
                    .HasColumnName("thumbnail")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ThumbnailLabel)
                    .HasColumnName("thumbnail_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TypeId)
                    .IsRequired()
                    .HasColumnName("type_id")
                    .HasColumnType("varchar(32)")
                    .HasDefaultValueSql("simple");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UrlKey)
                    .HasColumnName("url_key")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UrlPath)
                    .HasColumnName("url_path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Visibility)
                    .HasColumnName("visibility")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeightType)
                    .HasColumnName("weight_type")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.CatalogProductFlat3)
                    .HasForeignKey<CatalogProductFlat3>(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_FLAT_3_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductIndexEav>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.AttributeId, e.StoreId, e.Value })
                    .HasName("PK_catalog_product_index_eav");

                entity.ToTable("catalog_product_index_eav");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_STORE_ID");

                entity.HasIndex(e => e.Value)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_VALUE");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductIndexEav)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_IDX_EAV_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductIndexEav)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_IDX_EAV_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductIndexEav)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_INDEX_EAV_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductIndexEavDecimal>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("PK_catalog_product_index_eav_decimal");

                entity.ToTable("catalog_product_index_eav_decimal");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_STORE_ID");

                entity.HasIndex(e => e.Value)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_VALUE");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CatalogProductIndexEavDecimal)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CAT_PRD_IDX_EAV_DEC_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductIndexEavDecimal)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_IDX_EAV_DEC_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductIndexEavDecimal)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CAT_PRD_IDX_EAV_DEC_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductIndexEavDecimalIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.AttributeId, e.StoreId, e.Value })
                    .HasName("PK_catalog_product_index_eav_decimal_idx");

                entity.ToTable("catalog_product_index_eav_decimal_idx");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_STORE_ID");

                entity.HasIndex(e => e.Value)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_VALUE");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexEavDecimalTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("PK_catalog_product_index_eav_decimal_tmp");

                entity.ToTable("catalog_product_index_eav_decimal_tmp");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_STORE_ID");

                entity.HasIndex(e => e.Value)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_VALUE");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexEavIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.AttributeId, e.StoreId, e.Value })
                    .HasName("PK_catalog_product_index_eav_idx");

                entity.ToTable("catalog_product_index_eav_idx");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_IDX_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_IDX_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_IDX_STORE_ID");

                entity.HasIndex(e => e.Value)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_IDX_VALUE");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(10) unsigned");
            });

            modelBuilder.Entity<CatalogProductIndexEavTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.AttributeId, e.StoreId, e.Value })
                    .HasName("PK_catalog_product_index_eav_tmp");

                entity.ToTable("catalog_product_index_eav_tmp");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_TMP_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_TMP_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_TMP_STORE_ID");

                entity.HasIndex(e => e.Value)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_EAV_TMP_VALUE");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(10) unsigned");
            });

            modelBuilder.Entity<CatalogProductIndexGroupPrice>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_group_price");

                entity.ToTable("catalog_product_index_group_price");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_GROUP_PRICE_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_GROUP_PRICE_WEBSITE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogProductIndexGroupPrice)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_195DF97C81B0BDD6A2EEC50F870E16D1");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductIndexGroupPrice)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_IDX_GROUP_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductIndexGroupPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_IDX_GROUP_PRICE_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductIndexPrice>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price");

                entity.ToTable("catalog_product_index_price");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.MinPrice)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_MIN_PRICE");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_WEBSITE_ID");

                entity.HasIndex(e => new { e.WebsiteId, e.CustomerGroupId, e.MinPrice })
                    .HasName("IDX_CAT_PRD_IDX_PRICE_WS_ID_CSTR_GROUP_ID_MIN_PRICE");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.FinalPrice)
                    .HasColumnName("final_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogProductIndexPrice)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_CAT_PRD_IDX_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductIndexPrice)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_IDX_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductIndexPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_IDX_PRICE_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductIndexPriceBundleIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_bundle_idx");

                entity.ToTable("catalog_product_index_price_bundle_idx");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.BaseGroupPrice)
                    .HasColumnName("base_group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTier)
                    .HasColumnName("base_tier")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPricePercent)
                    .HasColumnName("group_price_percent")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrigPrice)
                    .HasColumnName("orig_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PriceType)
                    .HasColumnName("price_type")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SpecialPrice)
                    .HasColumnName("special_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierPercent)
                    .HasColumnName("tier_percent")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceBundleOptIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId, e.OptionId })
                    .HasName("PK_catalog_product_index_price_bundle_opt_idx");

                entity.ToTable("catalog_product_index_price_bundle_opt_idx");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.AltGroupPrice)
                    .HasColumnName("alt_group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AltPrice)
                    .HasColumnName("alt_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AltTierPrice)
                    .HasColumnName("alt_tier_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceBundleOptTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId, e.OptionId })
                    .HasName("PK_catalog_product_index_price_bundle_opt_tmp");

                entity.ToTable("catalog_product_index_price_bundle_opt_tmp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.AltGroupPrice)
                    .HasColumnName("alt_group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AltPrice)
                    .HasColumnName("alt_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AltTierPrice)
                    .HasColumnName("alt_tier_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceBundleSelIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId, e.OptionId, e.SelectionId })
                    .HasName("PK_catalog_product_index_price_bundle_sel_idx");

                entity.ToTable("catalog_product_index_price_bundle_sel_idx");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SelectionId)
                    .HasColumnName("selection_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupType)
                    .HasColumnName("group_type")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRequired)
                    .HasColumnName("is_required")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceBundleSelTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId, e.OptionId, e.SelectionId })
                    .HasName("PK_catalog_product_index_price_bundle_sel_tmp");

                entity.ToTable("catalog_product_index_price_bundle_sel_tmp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SelectionId)
                    .HasColumnName("selection_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupType)
                    .HasColumnName("group_type")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRequired)
                    .HasColumnName("is_required")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceBundleTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_bundle_tmp");

                entity.ToTable("catalog_product_index_price_bundle_tmp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.BaseGroupPrice)
                    .HasColumnName("base_group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTier)
                    .HasColumnName("base_tier")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPricePercent)
                    .HasColumnName("group_price_percent")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrigPrice)
                    .HasColumnName("orig_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PriceType)
                    .HasColumnName("price_type")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SpecialPrice)
                    .HasColumnName("special_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierPercent)
                    .HasColumnName("tier_percent")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceCfgOptAgrIdx>(entity =>
            {
                entity.HasKey(e => new { e.ParentId, e.ChildId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_cfg_opt_agr_idx");

                entity.ToTable("catalog_product_index_price_cfg_opt_agr_idx");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ChildId)
                    .HasColumnName("child_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceCfgOptAgrTmp>(entity =>
            {
                entity.HasKey(e => new { e.ParentId, e.ChildId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_cfg_opt_agr_tmp");

                entity.ToTable("catalog_product_index_price_cfg_opt_agr_tmp");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ChildId)
                    .HasColumnName("child_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceCfgOptIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_cfg_opt_idx");

                entity.ToTable("catalog_product_index_price_cfg_opt_idx");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceCfgOptTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_cfg_opt_tmp");

                entity.ToTable("catalog_product_index_price_cfg_opt_tmp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceDownlodIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_downlod_idx");

                entity.ToTable("catalog_product_index_price_downlod_idx");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");
            });

            modelBuilder.Entity<CatalogProductIndexPriceDownlodTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_downlod_tmp");

                entity.ToTable("catalog_product_index_price_downlod_tmp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");
            });

            modelBuilder.Entity<CatalogProductIndexPriceFinalIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_final_idx");

                entity.ToTable("catalog_product_index_price_final_idx");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.BaseGroupPrice)
                    .HasColumnName("base_group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTier)
                    .HasColumnName("base_tier")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrigPrice)
                    .HasColumnName("orig_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceFinalTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_final_tmp");

                entity.ToTable("catalog_product_index_price_final_tmp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.BaseGroupPrice)
                    .HasColumnName("base_group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTier)
                    .HasColumnName("base_tier")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrigPrice)
                    .HasColumnName("orig_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_idx");

                entity.ToTable("catalog_product_index_price_idx");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_IDX_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.MinPrice)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_IDX_MIN_PRICE");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_IDX_WEBSITE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.FinalPrice)
                    .HasColumnName("final_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceOptAgrIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId, e.OptionId })
                    .HasName("PK_catalog_product_index_price_opt_agr_idx");

                entity.ToTable("catalog_product_index_price_opt_agr_idx");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceOptAgrTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId, e.OptionId })
                    .HasName("PK_catalog_product_index_price_opt_agr_tmp");

                entity.ToTable("catalog_product_index_price_opt_agr_tmp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceOptIdx>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_opt_idx");

                entity.ToTable("catalog_product_index_price_opt_idx");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceOptTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_opt_tmp");

                entity.ToTable("catalog_product_index_price_opt_tmp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexPriceTmp>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_price_tmp");

                entity.ToTable("catalog_product_index_price_tmp");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_TMP_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.MinPrice)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_TMP_MIN_PRICE");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_PRICE_TMP_WEBSITE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.FinalPrice)
                    .HasColumnName("final_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GroupPrice)
                    .HasColumnName("group_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MaxPrice)
                    .HasColumnName("max_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TierPrice)
                    .HasColumnName("tier_price")
                    .HasColumnType("decimal(12,4)");
            });

            modelBuilder.Entity<CatalogProductIndexTierPrice>(entity =>
            {
                entity.HasKey(e => new { e.EntityId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalog_product_index_tier_price");

                entity.ToTable("catalog_product_index_tier_price");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_TIER_PRICE_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_TIER_PRICE_WEBSITE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.MinPrice)
                    .HasColumnName("min_price")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogProductIndexTierPrice)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_CAT_PRD_IDX_TIER_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CatalogProductIndexTierPrice)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CAT_PRD_IDX_TIER_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductIndexTierPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_IDX_TIER_PRICE_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductIndexWebsite>(entity =>
            {
                entity.HasKey(e => e.WebsiteId)
                    .HasName("PK_catalog_product_index_website");

                entity.ToTable("catalog_product_index_website");

                entity.HasIndex(e => e.WebsiteDate)
                    .HasName("IDX_CATALOG_PRODUCT_INDEX_WEBSITE_WEBSITE_DATE");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Rate)
                    .HasColumnName("rate")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.WebsiteDate)
                    .HasColumnName("website_date")
                    .HasColumnType("date");

                entity.HasOne(d => d.Website)
                    .WithOne(p => p.CatalogProductIndexWebsite)
                    .HasForeignKey<CatalogProductIndexWebsite>(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_IDX_WS_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductLink>(entity =>
            {
                entity.HasKey(e => e.LinkId)
                    .HasName("PK_catalog_product_link");

                entity.ToTable("catalog_product_link");

                entity.HasIndex(e => e.LinkTypeId)
                    .HasName("IDX_CATALOG_PRODUCT_LINK_LINK_TYPE_ID");

                entity.HasIndex(e => e.LinkedProductId)
                    .HasName("IDX_CATALOG_PRODUCT_LINK_LINKED_PRODUCT_ID");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOG_PRODUCT_LINK_PRODUCT_ID");

                entity.HasIndex(e => new { e.LinkTypeId, e.ProductId, e.LinkedProductId })
                    .HasName("UNQ_CAT_PRD_LNK_LNK_TYPE_ID_PRD_ID_LNKED_PRD_ID")
                    .IsUnique();

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.LinkTypeId)
                    .HasColumnName("link_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LinkedProductId)
                    .HasColumnName("linked_product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.LinkType)
                    .WithMany(p => p.CatalogProductLink)
                    .HasForeignKey(d => d.LinkTypeId)
                    .HasConstraintName("FK_CAT_PRD_LNK_LNK_TYPE_ID_CAT_PRD_LNK_TYPE_LNK_TYPE_ID");

                entity.HasOne(d => d.LinkedProduct)
                    .WithMany(p => p.CatalogProductLinkLinkedProduct)
                    .HasForeignKey(d => d.LinkedProductId)
                    .HasConstraintName("FK_CAT_PRD_LNK_LNKED_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogProductLinkProduct)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_PRD_LNK_PRD_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductLinkAttribute>(entity =>
            {
                entity.HasKey(e => e.ProductLinkAttributeId)
                    .HasName("PK_catalog_product_link_attribute");

                entity.ToTable("catalog_product_link_attribute");

                entity.HasIndex(e => e.LinkTypeId)
                    .HasName("IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_LINK_TYPE_ID");

                entity.Property(e => e.ProductLinkAttributeId)
                    .HasColumnName("product_link_attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.DataType)
                    .HasColumnName("data_type")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.LinkTypeId)
                    .HasColumnName("link_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductLinkAttributeCode)
                    .HasColumnName("product_link_attribute_code")
                    .HasColumnType("varchar(32)");

                entity.HasOne(d => d.LinkType)
                    .WithMany(p => p.CatalogProductLinkAttribute)
                    .HasForeignKey(d => d.LinkTypeId)
                    .HasConstraintName("FK_CAT_PRD_LNK_ATTR_LNK_TYPE_ID_CAT_PRD_LNK_TYPE_LNK_TYPE_ID");
            });

            modelBuilder.Entity<CatalogProductLinkAttributeDecimal>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_link_attribute_decimal");

                entity.ToTable("catalog_product_link_attribute_decimal");

                entity.HasIndex(e => e.LinkId)
                    .HasName("IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_DECIMAL_LINK_ID");

                entity.HasIndex(e => e.ProductLinkAttributeId)
                    .HasName("IDX_CAT_PRD_LNK_ATTR_DEC_PRD_LNK_ATTR_ID");

                entity.HasIndex(e => new { e.ProductLinkAttributeId, e.LinkId })
                    .HasName("UNQ_CAT_PRD_LNK_ATTR_DEC_PRD_LNK_ATTR_ID_LNK_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductLinkAttributeId)
                    .IsRequired()
                    .HasColumnName("product_link_attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Link)
                    .WithMany(p => p.CatalogProductLinkAttributeDecimal)
                    .HasForeignKey(d => d.LinkId)
                    .HasConstraintName("FK_CAT_PRD_LNK_ATTR_DEC_LNK_ID_CAT_PRD_LNK_LNK_ID");

                entity.HasOne(d => d.ProductLinkAttribute)
                    .WithMany(p => p.CatalogProductLinkAttributeDecimal)
                    .HasForeignKey(d => d.ProductLinkAttributeId)
                    .HasConstraintName("FK_AB2EFA9A14F7BCF1D5400056203D14B6");
            });

            modelBuilder.Entity<CatalogProductLinkAttributeInt>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_link_attribute_int");

                entity.ToTable("catalog_product_link_attribute_int");

                entity.HasIndex(e => e.LinkId)
                    .HasName("IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_INT_LINK_ID");

                entity.HasIndex(e => e.ProductLinkAttributeId)
                    .HasName("IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_INT_PRODUCT_LINK_ATTRIBUTE_ID");

                entity.HasIndex(e => new { e.ProductLinkAttributeId, e.LinkId })
                    .HasName("UNQ_CAT_PRD_LNK_ATTR_INT_PRD_LNK_ATTR_ID_LNK_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductLinkAttributeId)
                    .IsRequired()
                    .HasColumnName("product_link_attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Link)
                    .WithMany(p => p.CatalogProductLinkAttributeInt)
                    .HasForeignKey(d => d.LinkId)
                    .HasConstraintName("FK_CAT_PRD_LNK_ATTR_INT_LNK_ID_CAT_PRD_LNK_LNK_ID");

                entity.HasOne(d => d.ProductLinkAttribute)
                    .WithMany(p => p.CatalogProductLinkAttributeInt)
                    .HasForeignKey(d => d.ProductLinkAttributeId)
                    .HasConstraintName("FK_D6D878F8BA2A4282F8DDED7E6E3DE35C");
            });

            modelBuilder.Entity<CatalogProductLinkAttributeVarchar>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_link_attribute_varchar");

                entity.ToTable("catalog_product_link_attribute_varchar");

                entity.HasIndex(e => e.LinkId)
                    .HasName("IDX_CATALOG_PRODUCT_LINK_ATTRIBUTE_VARCHAR_LINK_ID");

                entity.HasIndex(e => e.ProductLinkAttributeId)
                    .HasName("IDX_CAT_PRD_LNK_ATTR_VCHR_PRD_LNK_ATTR_ID");

                entity.HasIndex(e => new { e.ProductLinkAttributeId, e.LinkId })
                    .HasName("UNQ_CAT_PRD_LNK_ATTR_VCHR_PRD_LNK_ATTR_ID_LNK_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductLinkAttributeId)
                    .HasColumnName("product_link_attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Link)
                    .WithMany(p => p.CatalogProductLinkAttributeVarchar)
                    .HasForeignKey(d => d.LinkId)
                    .HasConstraintName("FK_CAT_PRD_LNK_ATTR_VCHR_LNK_ID_CAT_PRD_LNK_LNK_ID");

                entity.HasOne(d => d.ProductLinkAttribute)
                    .WithMany(p => p.CatalogProductLinkAttributeVarchar)
                    .HasForeignKey(d => d.ProductLinkAttributeId)
                    .HasConstraintName("FK_DEE9C4DA61CFCC01DFCF50F0D79CEA51");
            });

            modelBuilder.Entity<CatalogProductLinkType>(entity =>
            {
                entity.HasKey(e => e.LinkTypeId)
                    .HasName("PK_catalog_product_link_type");

                entity.ToTable("catalog_product_link_type");

                entity.Property(e => e.LinkTypeId)
                    .HasColumnName("link_type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasColumnType("varchar(32)");
            });

            modelBuilder.Entity<CatalogProductOption>(entity =>
            {
                entity.HasKey(e => e.OptionId)
                    .HasName("PK_catalog_product_option");

                entity.ToTable("catalog_product_option");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_PRODUCT_ID");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.FileExtension)
                    .HasColumnName("file_extension")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.ImageSizeX)
                    .HasColumnName("image_size_x")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.ImageSizeY)
                    .HasColumnName("image_size_y")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.IsRequire)
                    .HasColumnName("is_require")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.MaxCharacters)
                    .HasColumnName("max_characters")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("varchar(50)");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogProductOption)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_PRD_OPT_PRD_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductOptionPrice>(entity =>
            {
                entity.HasKey(e => e.OptionPriceId)
                    .HasName("PK_catalog_product_option_price");

                entity.ToTable("catalog_product_option_price");

                entity.HasIndex(e => e.OptionId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_PRICE_OPTION_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_PRICE_STORE_ID");

                entity.HasIndex(e => new { e.OptionId, e.StoreId })
                    .HasName("UNQ_CATALOG_PRODUCT_OPTION_PRICE_OPTION_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.OptionPriceId)
                    .HasColumnName("option_price_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.PriceType)
                    .IsRequired()
                    .HasColumnName("price_type")
                    .HasColumnType("varchar(7)")
                    .HasDefaultValueSql("fixed");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Option)
                    .WithMany(p => p.CatalogProductOptionPrice)
                    .HasForeignKey(d => d.OptionId)
                    .HasConstraintName("FK_CAT_PRD_OPT_PRICE_OPT_ID_CAT_PRD_OPT_OPT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductOptionPrice)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_OPTION_PRICE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductOptionTitle>(entity =>
            {
                entity.HasKey(e => e.OptionTitleId)
                    .HasName("PK_catalog_product_option_title");

                entity.ToTable("catalog_product_option_title");

                entity.HasIndex(e => e.OptionId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_TITLE_OPTION_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_TITLE_STORE_ID");

                entity.HasIndex(e => new { e.OptionId, e.StoreId })
                    .HasName("UNQ_CATALOG_PRODUCT_OPTION_TITLE_OPTION_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.OptionTitleId)
                    .HasColumnName("option_title_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Option)
                    .WithMany(p => p.CatalogProductOptionTitle)
                    .HasForeignKey(d => d.OptionId)
                    .HasConstraintName("FK_CAT_PRD_OPT_TTL_OPT_ID_CAT_PRD_OPT_OPT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductOptionTitle)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_OPTION_TITLE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductOptionTypePrice>(entity =>
            {
                entity.HasKey(e => e.OptionTypePriceId)
                    .HasName("PK_catalog_product_option_type_price");

                entity.ToTable("catalog_product_option_type_price");

                entity.HasIndex(e => e.OptionTypeId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE_ID");

                entity.HasIndex(e => new { e.OptionTypeId, e.StoreId })
                    .HasName("UNQ_CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION_TYPE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.OptionTypePriceId)
                    .HasColumnName("option_type_price_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OptionTypeId)
                    .HasColumnName("option_type_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.PriceType)
                    .IsRequired()
                    .HasColumnName("price_type")
                    .HasColumnType("varchar(7)")
                    .HasDefaultValueSql("fixed");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.OptionType)
                    .WithMany(p => p.CatalogProductOptionTypePrice)
                    .HasForeignKey(d => d.OptionTypeId)
                    .HasConstraintName("FK_B523E3378E8602F376CC415825576B7F");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductOptionTypePrice)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CAT_PRD_OPT_TYPE_PRICE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductOptionTypeTitle>(entity =>
            {
                entity.HasKey(e => e.OptionTypeTitleId)
                    .HasName("PK_catalog_product_option_type_title");

                entity.ToTable("catalog_product_option_type_title");

                entity.HasIndex(e => e.OptionTypeId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE_ID");

                entity.HasIndex(e => new { e.OptionTypeId, e.StoreId })
                    .HasName("UNQ_CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION_TYPE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.OptionTypeTitleId)
                    .HasColumnName("option_type_title_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OptionTypeId)
                    .HasColumnName("option_type_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.OptionType)
                    .WithMany(p => p.CatalogProductOptionTypeTitle)
                    .HasForeignKey(d => d.OptionTypeId)
                    .HasConstraintName("FK_C085B9CF2C2A302E8043FDEA1937D6A2");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductOptionTypeTitle)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CAT_PRD_OPT_TYPE_TTL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductOptionTypeValue>(entity =>
            {
                entity.HasKey(e => e.OptionTypeId)
                    .HasName("PK_catalog_product_option_type_value");

                entity.ToTable("catalog_product_option_type_value");

                entity.HasIndex(e => e.OptionId)
                    .HasName("IDX_CATALOG_PRODUCT_OPTION_TYPE_VALUE_OPTION_ID");

                entity.Property(e => e.OptionTypeId)
                    .HasColumnName("option_type_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Option)
                    .WithMany(p => p.CatalogProductOptionTypeValue)
                    .HasForeignKey(d => d.OptionId)
                    .HasConstraintName("FK_CAT_PRD_OPT_TYPE_VAL_OPT_ID_CAT_PRD_OPT_OPT_ID");
            });

            modelBuilder.Entity<CatalogProductRelation>(entity =>
            {
                entity.HasKey(e => new { e.ParentId, e.ChildId })
                    .HasName("PK_catalog_product_relation");

                entity.ToTable("catalog_product_relation");

                entity.HasIndex(e => e.ChildId)
                    .HasName("IDX_CATALOG_PRODUCT_RELATION_CHILD_ID");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ChildId)
                    .HasColumnName("child_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Child)
                    .WithMany(p => p.CatalogProductRelationChild)
                    .HasForeignKey(d => d.ChildId)
                    .HasConstraintName("FK_CAT_PRD_RELATION_CHILD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.CatalogProductRelationParent)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_CAT_PRD_RELATION_PARENT_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductSuperAttribute>(entity =>
            {
                entity.HasKey(e => e.ProductSuperAttributeId)
                    .HasName("PK_catalog_product_super_attribute");

                entity.ToTable("catalog_product_super_attribute");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRODUCT_ID");

                entity.HasIndex(e => new { e.ProductId, e.AttributeId })
                    .HasName("UNQ_CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRODUCT_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.Property(e => e.ProductSuperAttributeId)
                    .HasColumnName("product_super_attribute_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogProductSuperAttribute)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_PRD_SPR_ATTR_PRD_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductSuperAttributeLabel>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_super_attribute_label");

                entity.ToTable("catalog_product_super_attribute_label");

                entity.HasIndex(e => e.ProductSuperAttributeId)
                    .HasName("IDX_CAT_PRD_SPR_ATTR_LBL_PRD_SPR_ATTR_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOG_PRODUCT_SUPER_ATTRIBUTE_LABEL_STORE_ID");

                entity.HasIndex(e => new { e.ProductSuperAttributeId, e.StoreId })
                    .HasName("UNQ_CAT_PRD_SPR_ATTR_LBL_PRD_SPR_ATTR_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductSuperAttributeId)
                    .HasColumnName("product_super_attribute_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UseDefault)
                    .HasColumnName("use_default")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.ProductSuperAttribute)
                    .WithMany(p => p.CatalogProductSuperAttributeLabel)
                    .HasForeignKey(d => d.ProductSuperAttributeId)
                    .HasConstraintName("FK_309442281DF7784210ED82B2CC51E5D5");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogProductSuperAttributeLabel)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CAT_PRD_SPR_ATTR_LBL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogProductSuperAttributePricing>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_catalog_product_super_attribute_pricing");

                entity.ToTable("catalog_product_super_attribute_pricing");

                entity.HasIndex(e => e.ProductSuperAttributeId)
                    .HasName("IDX_CAT_PRD_SPR_ATTR_PRICING_PRD_SPR_ATTR_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRICING_WEBSITE_ID");

                entity.HasIndex(e => new { e.ProductSuperAttributeId, e.ValueIndex, e.WebsiteId })
                    .HasName("UNQ_CAT_PRD_SPR_ATTR_PRICING_PRD_SPR_ATTR_ID_VAL_IDX_WS_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.IsPercent)
                    .HasColumnName("is_percent")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.PricingValue)
                    .HasColumnName("pricing_value")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductSuperAttributeId)
                    .HasColumnName("product_super_attribute_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ValueIndex)
                    .IsRequired()
                    .HasColumnName("value_index")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.ProductSuperAttribute)
                    .WithMany(p => p.CatalogProductSuperAttributePricing)
                    .HasForeignKey(d => d.ProductSuperAttributeId)
                    .HasConstraintName("FK_CDE8813117106CFAA3AD209358F66332");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductSuperAttributePricing)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CAT_PRD_SPR_ATTR_PRICING_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CatalogProductSuperLink>(entity =>
            {
                entity.HasKey(e => e.LinkId)
                    .HasName("PK_catalog_product_super_link");

                entity.ToTable("catalog_product_super_link");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_CATALOG_PRODUCT_SUPER_LINK_PARENT_ID");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOG_PRODUCT_SUPER_LINK_PRODUCT_ID");

                entity.HasIndex(e => new { e.ProductId, e.ParentId })
                    .HasName("UNQ_CATALOG_PRODUCT_SUPER_LINK_PRODUCT_ID_PARENT_ID")
                    .IsUnique();

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.CatalogProductSuperLinkParent)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_CAT_PRD_SPR_LNK_PARENT_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogProductSuperLinkProduct)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_PRD_SPR_LNK_PRD_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<CatalogProductWebsite>(entity =>
            {
                entity.HasKey(e => new { e.ProductId, e.WebsiteId })
                    .HasName("PK_catalog_product_website");

                entity.ToTable("catalog_product_website");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOG_PRODUCT_WEBSITE_WEBSITE_ID");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogProductWebsite)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CAT_PRD_WS_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogProductWebsite)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CATALOG_PRODUCT_WEBSITE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<CataloginventoryStock>(entity =>
            {
                entity.HasKey(e => e.StockId)
                    .HasName("PK_cataloginventory_stock");

                entity.ToTable("cataloginventory_stock");

                entity.Property(e => e.StockId)
                    .HasColumnName("stock_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StockName)
                    .HasColumnName("stock_name")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<CataloginventoryStockItem>(entity =>
            {
                entity.HasKey(e => e.ItemId)
                    .HasName("PK_cataloginventory_stock_item");

                entity.ToTable("cataloginventory_stock_item");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOGINVENTORY_STOCK_ITEM_PRODUCT_ID");

                entity.HasIndex(e => e.StockId)
                    .HasName("IDX_CATALOGINVENTORY_STOCK_ITEM_STOCK_ID");

                entity.HasIndex(e => new { e.ProductId, e.StockId })
                    .HasName("UNQ_CATALOGINVENTORY_STOCK_ITEM_PRODUCT_ID_STOCK_ID")
                    .IsUnique();

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Backorders)
                    .HasColumnName("backorders")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EnableQtyIncrements)
                    .HasColumnName("enable_qty_increments")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsDecimalDivided)
                    .HasColumnName("is_decimal_divided")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsInStock)
                    .HasColumnName("is_in_stock")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsQtyDecimal)
                    .HasColumnName("is_qty_decimal")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LowStockDate)
                    .HasColumnName("low_stock_date")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ManageStock)
                    .HasColumnName("manage_stock")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MaxSaleQty)
                    .HasColumnName("max_sale_qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.MinQty)
                    .HasColumnName("min_qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.MinSaleQty)
                    .HasColumnName("min_sale_qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("1.0000");

                entity.Property(e => e.NotifyStockQty)
                    .HasColumnName("notify_stock_qty")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyIncrements)
                    .HasColumnName("qty_increments")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.StockId)
                    .HasColumnName("stock_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StockStatusChangedAuto)
                    .HasColumnName("stock_status_changed_auto")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UseConfigBackorders)
                    .HasColumnName("use_config_backorders")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.UseConfigEnableQtyInc)
                    .HasColumnName("use_config_enable_qty_inc")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.UseConfigManageStock)
                    .HasColumnName("use_config_manage_stock")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.UseConfigMaxSaleQty)
                    .HasColumnName("use_config_max_sale_qty")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.UseConfigMinQty)
                    .HasColumnName("use_config_min_qty")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.UseConfigMinSaleQty)
                    .HasColumnName("use_config_min_sale_qty")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.UseConfigNotifyStockQty)
                    .HasColumnName("use_config_notify_stock_qty")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.UseConfigQtyIncrements)
                    .HasColumnName("use_config_qty_increments")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CataloginventoryStockItem)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CATINV_STOCK_ITEM_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Stock)
                    .WithMany(p => p.CataloginventoryStockItem)
                    .HasForeignKey(d => d.StockId)
                    .HasConstraintName("FK_CATINV_STOCK_ITEM_STOCK_ID_CATINV_STOCK_STOCK_ID");
            });

            modelBuilder.Entity<CataloginventoryStockStatus>(entity =>
            {
                entity.HasKey(e => new { e.ProductId, e.WebsiteId, e.StockId })
                    .HasName("PK_cataloginventory_stock_status");

                entity.ToTable("cataloginventory_stock_status");

                entity.HasIndex(e => e.StockId)
                    .HasName("IDX_CATALOGINVENTORY_STOCK_STATUS_STOCK_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOGINVENTORY_STOCK_STATUS_WEBSITE_ID");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StockId)
                    .HasColumnName("stock_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.StockStatus)
                    .HasColumnName("stock_status")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CataloginventoryStockStatus)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CATINV_STOCK_STS_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Stock)
                    .WithMany(p => p.CataloginventoryStockStatus)
                    .HasForeignKey(d => d.StockId)
                    .HasConstraintName("FK_CATINV_STOCK_STS_STOCK_ID_CATINV_STOCK_STOCK_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CataloginventoryStockStatus)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CATINV_STOCK_STS_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CataloginventoryStockStatusIdx>(entity =>
            {
                entity.HasKey(e => new { e.ProductId, e.WebsiteId, e.StockId })
                    .HasName("PK_cataloginventory_stock_status_idx");

                entity.ToTable("cataloginventory_stock_status_idx");

                entity.HasIndex(e => e.StockId)
                    .HasName("IDX_CATALOGINVENTORY_STOCK_STATUS_IDX_STOCK_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOGINVENTORY_STOCK_STATUS_IDX_WEBSITE_ID");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StockId)
                    .HasColumnName("stock_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.StockStatus)
                    .HasColumnName("stock_status")
                    .HasColumnType("smallint(5) unsigned");
            });

            modelBuilder.Entity<CataloginventoryStockStatusTmp>(entity =>
            {
                entity.HasKey(e => new { e.ProductId, e.WebsiteId, e.StockId })
                    .HasName("PK_cataloginventory_stock_status_tmp");

                entity.ToTable("cataloginventory_stock_status_tmp");

                entity.HasIndex(e => e.StockId)
                    .HasName("IDX_CATALOGINVENTORY_STOCK_STATUS_TMP_STOCK_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOGINVENTORY_STOCK_STATUS_TMP_WEBSITE_ID");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StockId)
                    .HasColumnName("stock_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.StockStatus)
                    .HasColumnName("stock_status")
                    .HasColumnType("smallint(5) unsigned");
            });

            modelBuilder.Entity<Catalogrule>(entity =>
            {
                entity.HasKey(e => e.RuleId)
                    .HasName("PK_catalogrule");

                entity.ToTable("catalogrule");

                entity.HasIndex(e => new { e.IsActive, e.SortOrder, e.ToDate, e.FromDate })
                    .HasName("IDX_CATALOGRULE_IS_ACTIVE_SORT_ORDER_TO_DATE_FROM_DATE");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ActionsSerialized)
                    .HasColumnName("actions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.ConditionsSerialized)
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.FromDate)
                    .HasColumnName("from_date")
                    .HasColumnType("date");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SimpleAction)
                    .HasColumnName("simple_action")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StopRulesProcessing)
                    .HasColumnName("stop_rules_processing")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.SubDiscountAmount)
                    .HasColumnName("sub_discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.SubIsEnable)
                    .HasColumnName("sub_is_enable")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SubSimpleAction)
                    .HasColumnName("sub_simple_action")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.ToDate)
                    .HasColumnName("to_date")
                    .HasColumnType("date");
            });

            modelBuilder.Entity<CatalogruleAffectedProduct>(entity =>
            {
                entity.HasKey(e => e.ProductId)
                    .HasName("PK_catalogrule_affected_product");

                entity.ToTable("catalogrule_affected_product");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");
            });

            modelBuilder.Entity<CatalogruleCustomerGroup>(entity =>
            {
                entity.HasKey(e => new { e.RuleId, e.CustomerGroupId })
                    .HasName("PK_catalogrule_customer_group");

                entity.ToTable("catalogrule_customer_group");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOGRULE_CUSTOMER_GROUP_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.RuleId)
                    .HasName("IDX_CATALOGRULE_CUSTOMER_GROUP_RULE_ID");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogruleCustomerGroup)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_CATRULE_CSTR_GROUP_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.CatalogruleCustomerGroup)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_CATALOGRULE_CUSTOMER_GROUP_RULE_ID_CATALOGRULE_RULE_ID");
            });

            modelBuilder.Entity<CatalogruleGroupWebsite>(entity =>
            {
                entity.HasKey(e => new { e.RuleId, e.CustomerGroupId, e.WebsiteId })
                    .HasName("PK_catalogrule_group_website");

                entity.ToTable("catalogrule_group_website");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOGRULE_GROUP_WEBSITE_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.RuleId)
                    .HasName("IDX_CATALOGRULE_GROUP_WEBSITE_RULE_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogruleGroupWebsite)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_CATRULE_GROUP_WS_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.CatalogruleGroupWebsite)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_CATALOGRULE_GROUP_WEBSITE_RULE_ID_CATALOGRULE_RULE_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogruleGroupWebsite)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<CatalogruleProduct>(entity =>
            {
                entity.HasKey(e => e.RuleProductId)
                    .HasName("PK_catalogrule_product");

                entity.ToTable("catalogrule_product");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOGRULE_PRODUCT_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.FromTime)
                    .HasName("IDX_CATALOGRULE_PRODUCT_FROM_TIME");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOGRULE_PRODUCT_PRODUCT_ID");

                entity.HasIndex(e => e.RuleId)
                    .HasName("IDX_CATALOGRULE_PRODUCT_RULE_ID");

                entity.HasIndex(e => e.ToTime)
                    .HasName("IDX_CATALOGRULE_PRODUCT_TO_TIME");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOGRULE_PRODUCT_WEBSITE_ID");

                entity.HasIndex(e => new { e.RuleId, e.FromTime, e.ToTime, e.WebsiteId, e.CustomerGroupId, e.ProductId, e.SortOrder })
                    .HasName("EAA51B56FF092A0DCB795D1CEF812B7B")
                    .IsUnique();

                entity.Property(e => e.RuleProductId)
                    .HasColumnName("rule_product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ActionAmount)
                    .HasColumnName("action_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.ActionOperator)
                    .HasColumnName("action_operator")
                    .HasColumnType("varchar(10)")
                    .HasDefaultValueSql("to_fixed");

                entity.Property(e => e.ActionStop)
                    .HasColumnName("action_stop")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.FromTime)
                    .HasColumnName("from_time")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SubDiscountAmount)
                    .HasColumnName("sub_discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.SubSimpleAction)
                    .HasColumnName("sub_simple_action")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.ToTime)
                    .HasColumnName("to_time")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogruleProduct)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_CATRULE_PRD_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogruleProduct)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CATRULE_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.CatalogruleProduct)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_CATALOGRULE_PRODUCT_RULE_ID_CATALOGRULE_RULE_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogruleProduct)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CATALOGRULE_PRODUCT_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<CatalogruleProductPrice>(entity =>
            {
                entity.HasKey(e => e.RuleProductPriceId)
                    .HasName("PK_catalogrule_product_price");

                entity.ToTable("catalogrule_product_price");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_CATALOGRULE_PRODUCT_PRICE_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOGRULE_PRODUCT_PRICE_PRODUCT_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID");

                entity.HasIndex(e => new { e.RuleDate, e.WebsiteId, e.CustomerGroupId, e.ProductId })
                    .HasName("UNQ_CATRULE_PRD_PRICE_RULE_DATE_WS_ID_CSTR_GROUP_ID_PRD_ID")
                    .IsUnique();

                entity.Property(e => e.RuleProductPriceId)
                    .HasColumnName("rule_product_price_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EarliestEndDate)
                    .HasColumnName("earliest_end_date")
                    .HasColumnType("date");

                entity.Property(e => e.LatestStartDate)
                    .HasColumnName("latest_start_date")
                    .HasColumnType("date");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RuleDate)
                    .HasColumnName("rule_date")
                    .HasColumnType("date");

                entity.Property(e => e.RulePrice)
                    .HasColumnName("rule_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.CatalogruleProductPrice)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_CATRULE_PRD_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogruleProductPrice)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CATRULE_PRD_PRICE_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogruleProductPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<CatalogruleWebsite>(entity =>
            {
                entity.HasKey(e => new { e.RuleId, e.WebsiteId })
                    .HasName("PK_catalogrule_website");

                entity.ToTable("catalogrule_website");

                entity.HasIndex(e => e.RuleId)
                    .HasName("IDX_CATALOGRULE_WEBSITE_RULE_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CATALOGRULE_WEBSITE_WEBSITE_ID");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.CatalogruleWebsite)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_CATALOGRULE_WEBSITE_RULE_ID_CATALOGRULE_RULE_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CatalogruleWebsite)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CATALOGRULE_WEBSITE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<CatalogsearchFulltext>(entity =>
            {
                entity.HasKey(e => e.FulltextId)
                    .HasName("PK_catalogsearch_fulltext");

                entity.ToTable("catalogsearch_fulltext");

                entity.HasIndex(e => e.DataIndex)
                    .HasName("FTI_CATALOGSEARCH_FULLTEXT_DATA_INDEX");

                entity.HasIndex(e => new { e.ProductId, e.StoreId })
                    .HasName("UNQ_CATALOGSEARCH_FULLTEXT_PRODUCT_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.FulltextId)
                    .HasColumnName("fulltext_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.DataIndex).HasColumnName("data_index");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");
            });

            modelBuilder.Entity<CatalogsearchQuery>(entity =>
            {
                entity.HasKey(e => e.QueryId)
                    .HasName("PK_catalogsearch_query");

                entity.ToTable("catalogsearch_query");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CATALOGSEARCH_QUERY_STORE_ID");

                entity.HasIndex(e => e.SynonymFor)
                    .HasName("IDX_CATALOGSEARCH_QUERY_SYNONYM_FOR");

                entity.HasIndex(e => new { e.QueryText, e.StoreId, e.Popularity })
                    .HasName("IDX_CATALOGSEARCH_QUERY_QUERY_TEXT_STORE_ID_POPULARITY");

                entity.Property(e => e.QueryId)
                    .HasColumnName("query_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.DisplayInTerms)
                    .HasColumnName("display_in_terms")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsProcessed)
                    .HasColumnName("is_processed")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.NumResults)
                    .HasColumnName("num_results")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Popularity)
                    .HasColumnName("popularity")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.QueryText)
                    .HasColumnName("query_text")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Redirect)
                    .HasColumnName("redirect")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SynonymFor)
                    .HasColumnName("synonym_for")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CatalogsearchQuery)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CATALOGSEARCH_QUERY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CatalogsearchResult>(entity =>
            {
                entity.HasKey(e => new { e.QueryId, e.ProductId })
                    .HasName("PK_catalogsearch_result");

                entity.ToTable("catalogsearch_result");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_CATALOGSEARCH_RESULT_PRODUCT_ID");

                entity.HasIndex(e => e.QueryId)
                    .HasName("IDX_CATALOGSEARCH_RESULT_QUERY_ID");

                entity.Property(e => e.QueryId)
                    .HasColumnName("query_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Relevance)
                    .HasColumnName("relevance")
                    .HasColumnType("decimal(20,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CatalogsearchResult)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_CATSRCH_RESULT_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Query)
                    .WithMany(p => p.CatalogsearchResult)
                    .HasForeignKey(d => d.QueryId)
                    .HasConstraintName("FK_CATALOGSEARCH_RESULT_QUERY_ID_CATALOGSEARCH_QUERY_QUERY_ID");
            });

            modelBuilder.Entity<CheckoutAgreement>(entity =>
            {
                entity.HasKey(e => e.AgreementId)
                    .HasName("PK_checkout_agreement");

                entity.ToTable("checkout_agreement");

                entity.Property(e => e.AgreementId)
                    .HasColumnName("agreement_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CheckboxText)
                    .HasColumnName("checkbox_text")
                    .HasColumnType("text");

                entity.Property(e => e.Content)
                    .HasColumnName("content")
                    .HasColumnType("text");

                entity.Property(e => e.ContentHeight)
                    .HasColumnName("content_height")
                    .HasColumnType("varchar(25)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsHtml)
                    .HasColumnName("is_html")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<CheckoutAgreementStore>(entity =>
            {
                entity.HasKey(e => new { e.AgreementId, e.StoreId })
                    .HasName("PK_checkout_agreement_store");

                entity.ToTable("checkout_agreement_store");

                entity.HasIndex(e => e.StoreId)
                    .HasName("FK_CHECKOUT_AGREEMENT_STORE_STORE_ID_CORE_STORE_STORE_ID");

                entity.Property(e => e.AgreementId)
                    .HasColumnName("agreement_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Agreement)
                    .WithMany(p => p.CheckoutAgreementStore)
                    .HasForeignKey(d => d.AgreementId)
                    .HasConstraintName("FK_CHKT_AGRT_STORE_AGRT_ID_CHKT_AGRT_AGRT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CheckoutAgreementStore)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CHECKOUT_AGREEMENT_STORE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CmsBlock>(entity =>
            {
                entity.HasKey(e => e.BlockId)
                    .HasName("PK_cms_block");

                entity.ToTable("cms_block");

                entity.Property(e => e.BlockId)
                    .HasColumnName("block_id")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.Content)
                    .HasColumnName("content")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.CreationTime)
                    .HasColumnName("creation_time")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Identifier)
                    .IsRequired()
                    .HasColumnName("identifier")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Title)
                    .IsRequired()
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<CmsBlockStore>(entity =>
            {
                entity.HasKey(e => new { e.BlockId, e.StoreId })
                    .HasName("PK_cms_block_store");

                entity.ToTable("cms_block_store");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CMS_BLOCK_STORE_STORE_ID");

                entity.Property(e => e.BlockId)
                    .HasColumnName("block_id")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Block)
                    .WithMany(p => p.CmsBlockStore)
                    .HasForeignKey(d => d.BlockId)
                    .HasConstraintName("FK_CMS_BLOCK_STORE_BLOCK_ID_CMS_BLOCK_BLOCK_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CmsBlockStore)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CMS_BLOCK_STORE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CmsPage>(entity =>
            {
                entity.HasKey(e => e.PageId)
                    .HasName("PK_cms_page");

                entity.ToTable("cms_page");

                entity.HasIndex(e => e.Identifier)
                    .HasName("IDX_CMS_PAGE_IDENTIFIER");

                entity.Property(e => e.PageId)
                    .HasColumnName("page_id")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.Content)
                    .HasColumnName("content")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.ContentHeading)
                    .HasColumnName("content_heading")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreationTime)
                    .HasColumnName("creation_time")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CustomLayoutUpdateXml)
                    .HasColumnName("custom_layout_update_xml")
                    .HasColumnType("text");

                entity.Property(e => e.CustomRootTemplate)
                    .HasColumnName("custom_root_template")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomTheme)
                    .HasColumnName("custom_theme")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.CustomThemeFrom)
                    .HasColumnName("custom_theme_from")
                    .HasColumnType("date");

                entity.Property(e => e.CustomThemeTo)
                    .HasColumnName("custom_theme_to")
                    .HasColumnType("date");

                entity.Property(e => e.Identifier)
                    .HasColumnName("identifier")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.LayoutUpdateXml)
                    .HasColumnName("layout_update_xml")
                    .HasColumnType("text");

                entity.Property(e => e.MetaDescription)
                    .HasColumnName("meta_description")
                    .HasColumnType("text");

                entity.Property(e => e.MetaKeywords)
                    .HasColumnName("meta_keywords")
                    .HasColumnType("text");

                entity.Property(e => e.RootTemplate)
                    .HasColumnName("root_template")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<CmsPageStore>(entity =>
            {
                entity.HasKey(e => new { e.PageId, e.StoreId })
                    .HasName("PK_cms_page_store");

                entity.ToTable("cms_page_store");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CMS_PAGE_STORE_STORE_ID");

                entity.Property(e => e.PageId)
                    .HasColumnName("page_id")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Page)
                    .WithMany(p => p.CmsPageStore)
                    .HasForeignKey(d => d.PageId)
                    .HasConstraintName("FK_CMS_PAGE_STORE_PAGE_ID_CMS_PAGE_PAGE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CmsPageStore)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CMS_PAGE_STORE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CoreCache>(entity =>
            {
                entity.ToTable("core_cache");

                entity.HasIndex(e => e.ExpireTime)
                    .HasName("IDX_CORE_CACHE_EXPIRE_TIME");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Data)
                    .HasColumnName("data")
                    .HasColumnType("mediumblob");

                entity.Property(e => e.ExpireTime)
                    .HasColumnName("expire_time")
                    .HasColumnType("int(11)");

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("int(11)");
            });

            modelBuilder.Entity<CoreCacheOption>(entity =>
            {
                entity.HasKey(e => e.Code)
                    .HasName("PK_core_cache_option");

                entity.ToTable("core_cache_option");

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("smallint(6)");
            });

            modelBuilder.Entity<CoreCacheTag>(entity =>
            {
                entity.HasKey(e => new { e.Tag, e.CacheId })
                    .HasName("PK_core_cache_tag");

                entity.ToTable("core_cache_tag");

                entity.HasIndex(e => e.CacheId)
                    .HasName("IDX_CORE_CACHE_TAG_CACHE_ID");

                entity.Property(e => e.Tag)
                    .HasColumnName("tag")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.CacheId)
                    .HasColumnName("cache_id")
                    .HasColumnType("varchar(200)");
            });

            modelBuilder.Entity<CoreConfigData>(entity =>
            {
                entity.HasKey(e => e.ConfigId)
                    .HasName("PK_core_config_data");

                entity.ToTable("core_config_data");

                entity.HasIndex(e => new { e.Scope, e.ScopeId, e.Path })
                    .HasName("UNQ_CORE_CONFIG_DATA_SCOPE_SCOPE_ID_PATH")
                    .IsUnique();

                entity.Property(e => e.ConfigId)
                    .HasColumnName("config_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Path)
                    .IsRequired()
                    .HasColumnName("path")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("general");

                entity.Property(e => e.Scope)
                    .IsRequired()
                    .HasColumnName("scope")
                    .HasColumnType("varchar(8)")
                    .HasDefaultValueSql("default");

                entity.Property(e => e.ScopeId)
                    .HasColumnName("scope_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<CoreEmailQueue>(entity =>
            {
                entity.HasKey(e => e.MessageId)
                    .HasName("PK_core_email_queue");

                entity.ToTable("core_email_queue");

                entity.HasIndex(e => new { e.EntityId, e.EntityType, e.EventType, e.MessageBodyHash })
                    .HasName("0ADECE62FD629241C147389ADF20706E");

                entity.Property(e => e.MessageId)
                    .HasColumnName("message_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.EntityType)
                    .HasColumnName("entity_type")
                    .HasColumnType("varchar(128)");

                entity.Property(e => e.EventType)
                    .HasColumnName("event_type")
                    .HasColumnType("varchar(128)");

                entity.Property(e => e.MessageBody)
                    .IsRequired()
                    .HasColumnName("message_body")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.MessageBodyHash)
                    .IsRequired()
                    .HasColumnName("message_body_hash")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.MessageParameters)
                    .IsRequired()
                    .HasColumnName("message_parameters")
                    .HasColumnType("text");

                entity.Property(e => e.ProcessedAt)
                    .HasColumnName("processed_at")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<CoreEmailQueueRecipients>(entity =>
            {
                entity.HasKey(e => e.RecipientId)
                    .HasName("PK_core_email_queue_recipients");

                entity.ToTable("core_email_queue_recipients");

                entity.HasIndex(e => e.EmailType)
                    .HasName("IDX_CORE_EMAIL_QUEUE_RECIPIENTS_EMAIL_TYPE");

                entity.HasIndex(e => e.RecipientEmail)
                    .HasName("IDX_CORE_EMAIL_QUEUE_RECIPIENTS_RECIPIENT_EMAIL");

                entity.HasIndex(e => new { e.MessageId, e.RecipientEmail, e.EmailType })
                    .HasName("19BDB9C5FE4BD685FCF992A71E976CD0")
                    .IsUnique();

                entity.Property(e => e.RecipientId)
                    .HasColumnName("recipient_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.EmailType)
                    .HasColumnName("email_type")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MessageId)
                    .HasColumnName("message_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.RecipientEmail)
                    .IsRequired()
                    .HasColumnName("recipient_email")
                    .HasColumnType("varchar(128)");

                entity.Property(e => e.RecipientName)
                    .IsRequired()
                    .HasColumnName("recipient_name")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Message)
                    .WithMany(p => p.CoreEmailQueueRecipients)
                    .HasForeignKey(d => d.MessageId)
                    .HasConstraintName("FK_6F4948F3ABF97DE12127EF14B140802A");
            });

            modelBuilder.Entity<CoreEmailTemplate>(entity =>
            {
                entity.HasKey(e => e.TemplateId)
                    .HasName("PK_core_email_template");

                entity.ToTable("core_email_template");

                entity.HasIndex(e => e.AddedAt)
                    .HasName("IDX_CORE_EMAIL_TEMPLATE_ADDED_AT");

                entity.HasIndex(e => e.ModifiedAt)
                    .HasName("IDX_CORE_EMAIL_TEMPLATE_MODIFIED_AT");

                entity.HasIndex(e => e.TemplateCode)
                    .HasName("UNQ_CORE_EMAIL_TEMPLATE_TEMPLATE_CODE")
                    .IsUnique();

                entity.Property(e => e.TemplateId)
                    .HasColumnName("template_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddedAt)
                    .HasColumnName("added_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ModifiedAt)
                    .HasColumnName("modified_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.OrigTemplateCode)
                    .HasColumnName("orig_template_code")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.OrigTemplateVariables)
                    .HasColumnName("orig_template_variables")
                    .HasColumnType("text");

                entity.Property(e => e.TemplateCode)
                    .IsRequired()
                    .HasColumnName("template_code")
                    .HasColumnType("varchar(150)");

                entity.Property(e => e.TemplateSenderEmail)
                    .HasColumnName("template_sender_email")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.TemplateSenderName)
                    .HasColumnName("template_sender_name")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.TemplateStyles)
                    .HasColumnName("template_styles")
                    .HasColumnType("text");

                entity.Property(e => e.TemplateSubject)
                    .IsRequired()
                    .HasColumnName("template_subject")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.TemplateText)
                    .IsRequired()
                    .HasColumnName("template_text")
                    .HasColumnType("text");

                entity.Property(e => e.TemplateType)
                    .HasColumnName("template_type")
                    .HasColumnType("int(10) unsigned");
            });

            modelBuilder.Entity<CoreFlag>(entity =>
            {
                entity.HasKey(e => e.FlagId)
                    .HasName("PK_core_flag");

                entity.ToTable("core_flag");

                entity.HasIndex(e => e.LastUpdate)
                    .HasName("IDX_CORE_FLAG_LAST_UPDATE");

                entity.Property(e => e.FlagId)
                    .HasColumnName("flag_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.FlagCode)
                    .IsRequired()
                    .HasColumnName("flag_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FlagData)
                    .HasColumnName("flag_data")
                    .HasColumnType("text");

                entity.Property(e => e.LastUpdate)
                    .HasColumnName("last_update")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.State)
                    .HasColumnName("state")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<CoreLayoutLink>(entity =>
            {
                entity.HasKey(e => e.LayoutLinkId)
                    .HasName("PK_core_layout_link");

                entity.ToTable("core_layout_link");

                entity.HasIndex(e => e.LayoutUpdateId)
                    .HasName("IDX_CORE_LAYOUT_LINK_LAYOUT_UPDATE_ID");

                entity.HasIndex(e => new { e.StoreId, e.Package, e.Theme, e.LayoutUpdateId })
                    .HasName("UNQ_CORE_LAYOUT_LINK_STORE_ID_PACKAGE_THEME_LAYOUT_UPDATE_ID")
                    .IsUnique();

                entity.Property(e => e.LayoutLinkId)
                    .HasColumnName("layout_link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Area)
                    .HasColumnName("area")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.LayoutUpdateId)
                    .HasColumnName("layout_update_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Package)
                    .IsRequired()
                    .HasColumnName("package")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Theme)
                    .IsRequired()
                    .HasColumnName("theme")
                    .HasColumnType("varchar(64)");

                entity.HasOne(d => d.LayoutUpdate)
                    .WithMany(p => p.CoreLayoutLink)
                    .HasForeignKey(d => d.LayoutUpdateId)
                    .HasConstraintName("FK_CORE_LYT_LNK_LYT_UPDATE_ID_CORE_LYT_UPDATE_LYT_UPDATE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CoreLayoutLink)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CORE_LAYOUT_LINK_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CoreLayoutUpdate>(entity =>
            {
                entity.HasKey(e => e.LayoutUpdateId)
                    .HasName("PK_core_layout_update");

                entity.ToTable("core_layout_update");

                entity.HasIndex(e => e.Handle)
                    .HasName("IDX_CORE_LAYOUT_UPDATE_HANDLE");

                entity.Property(e => e.LayoutUpdateId)
                    .HasColumnName("layout_update_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Handle)
                    .HasColumnName("handle")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Xml)
                    .HasColumnName("xml")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<CoreResource>(entity =>
            {
                entity.HasKey(e => e.Code)
                    .HasName("PK_core_resource");

                entity.ToTable("core_resource");

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.DataVersion)
                    .HasColumnName("data_version")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.Version)
                    .HasColumnName("version")
                    .HasColumnType("varchar(50)");
            });

            modelBuilder.Entity<CoreSession>(entity =>
            {
                entity.HasKey(e => e.SessionId)
                    .HasName("PK_core_session");

                entity.ToTable("core_session");

                entity.Property(e => e.SessionId)
                    .HasColumnName("session_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SessionData)
                    .IsRequired()
                    .HasColumnName("session_data")
                    .HasColumnType("mediumblob");

                entity.Property(e => e.SessionExpires)
                    .HasColumnName("session_expires")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<CoreStore>(entity =>
            {
                entity.HasKey(e => e.StoreId)
                    .HasName("PK_core_store");

                entity.ToTable("core_store");

                entity.HasIndex(e => e.Code)
                    .HasName("UNQ_CORE_STORE_CODE")
                    .IsUnique();

                entity.HasIndex(e => e.GroupId)
                    .HasName("IDX_CORE_STORE_GROUP_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CORE_STORE_WEBSITE_ID");

                entity.HasIndex(e => new { e.IsActive, e.SortOrder })
                    .HasName("IDX_CORE_STORE_IS_ACTIVE_SORT_ORDER");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.GroupId)
                    .HasColumnName("group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Group)
                    .WithMany(p => p.CoreStore)
                    .HasForeignKey(d => d.GroupId)
                    .HasConstraintName("FK_CORE_STORE_GROUP_ID_CORE_STORE_GROUP_GROUP_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CoreStore)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CORE_STORE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<CoreStoreGroup>(entity =>
            {
                entity.HasKey(e => e.GroupId)
                    .HasName("PK_core_store_group");

                entity.ToTable("core_store_group");

                entity.HasIndex(e => e.DefaultStoreId)
                    .HasName("IDX_CORE_STORE_GROUP_DEFAULT_STORE_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CORE_STORE_GROUP_WEBSITE_ID");

                entity.Property(e => e.GroupId)
                    .HasColumnName("group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.DefaultStoreId)
                    .HasColumnName("default_store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RootCategoryId)
                    .HasColumnName("root_category_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CoreStoreGroup)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CORE_STORE_GROUP_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<CoreTranslate>(entity =>
            {
                entity.HasKey(e => e.KeyId)
                    .HasName("PK_core_translate");

                entity.ToTable("core_translate");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CORE_TRANSLATE_STORE_ID");

                entity.HasIndex(e => new { e.StoreId, e.Locale, e.CrcString, e.String })
                    .HasName("UNQ_CORE_TRANSLATE_STORE_ID_LOCALE_CRC_STRING_STRING")
                    .IsUnique();

                entity.Property(e => e.KeyId)
                    .HasColumnName("key_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CrcString)
                    .HasColumnName("crc_string")
                    .HasColumnType("bigint(20)")
                    .HasDefaultValueSql("1591228201");

                entity.Property(e => e.Locale)
                    .IsRequired()
                    .HasColumnName("locale")
                    .HasColumnType("varchar(20)")
                    .HasDefaultValueSql("en_US");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.String)
                    .IsRequired()
                    .HasColumnName("string")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("Translate String");

                entity.Property(e => e.Translate)
                    .HasColumnName("translate")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CoreTranslate)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CORE_TRANSLATE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CoreUrlRewrite>(entity =>
            {
                entity.HasKey(e => e.UrlRewriteId)
                    .HasName("PK_core_url_rewrite");

                entity.ToTable("core_url_rewrite");

                entity.HasIndex(e => e.CategoryId)
                    .HasName("FK_CORE_URL_REWRITE_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasIndex(e => e.IdPath)
                    .HasName("IDX_CORE_URL_REWRITE_ID_PATH");

                entity.HasIndex(e => e.ProductId)
                    .HasName("FK_CORE_URL_REWRITE_PRODUCT_ID_CATALOG_CATEGORY_ENTITY_ENTITY_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CORE_URL_REWRITE_STORE_ID");

                entity.HasIndex(e => new { e.RequestPath, e.StoreId })
                    .HasName("UNQ_CORE_URL_REWRITE_REQUEST_PATH_STORE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.TargetPath, e.StoreId })
                    .HasName("IDX_CORE_URL_REWRITE_TARGET_PATH_STORE_ID");

                entity.HasIndex(e => new { e.IdPath, e.IsSystem, e.StoreId })
                    .HasName("UNQ_CORE_URL_REWRITE_ID_PATH_IS_SYSTEM_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.UrlRewriteId)
                    .HasColumnName("url_rewrite_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CategoryId)
                    .HasColumnName("category_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IdPath)
                    .IsRequired()
                    .HasColumnName("id_path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsSystem)
                    .IsRequired()
                    .HasColumnName("is_system")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Options)
                    .HasColumnName("options")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.RequestPath)
                    .IsRequired()
                    .HasColumnName("request_path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TargetPath)
                    .HasColumnName("target_path")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Category)
                    .WithMany(p => p.CoreUrlRewrite)
                    .HasForeignKey(d => d.CategoryId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_CORE_URL_REWRITE_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.CoreUrlRewrite)
                    .HasForeignKey(d => d.ProductId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_CORE_URL_REWRITE_PRODUCT_ID_CATALOG_CATEGORY_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CoreUrlRewrite)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CORE_URL_REWRITE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CoreVariable>(entity =>
            {
                entity.HasKey(e => e.VariableId)
                    .HasName("PK_core_variable");

                entity.ToTable("core_variable");

                entity.HasIndex(e => e.Code)
                    .HasName("UNQ_CORE_VARIABLE_CODE")
                    .IsUnique();

                entity.Property(e => e.VariableId)
                    .HasColumnName("variable_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<CoreVariableValue>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_core_variable_value");

                entity.ToTable("core_variable_value");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CORE_VARIABLE_VALUE_STORE_ID");

                entity.HasIndex(e => e.VariableId)
                    .HasName("IDX_CORE_VARIABLE_VALUE_VARIABLE_ID");

                entity.HasIndex(e => new { e.VariableId, e.StoreId })
                    .HasName("UNQ_CORE_VARIABLE_VALUE_VARIABLE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.HtmlValue)
                    .HasColumnName("html_value")
                    .HasColumnType("text");

                entity.Property(e => e.PlainValue)
                    .HasColumnName("plain_value")
                    .HasColumnType("text");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.VariableId)
                    .HasColumnName("variable_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CoreVariableValue)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_CORE_VARIABLE_VALUE_STORE_ID_CORE_STORE_STORE_ID");

                entity.HasOne(d => d.Variable)
                    .WithMany(p => p.CoreVariableValue)
                    .HasForeignKey(d => d.VariableId)
                    .HasConstraintName("FK_CORE_VARIABLE_VALUE_VARIABLE_ID_CORE_VARIABLE_VARIABLE_ID");
            });

            modelBuilder.Entity<CoreWebsite>(entity =>
            {
                entity.HasKey(e => e.WebsiteId)
                    .HasName("PK_core_website");

                entity.ToTable("core_website");

                entity.HasIndex(e => e.Code)
                    .HasName("UNQ_CORE_WEBSITE_CODE")
                    .IsUnique();

                entity.HasIndex(e => e.DefaultGroupId)
                    .HasName("IDX_CORE_WEBSITE_DEFAULT_GROUP_ID");

                entity.HasIndex(e => e.SortOrder)
                    .HasName("IDX_CORE_WEBSITE_SORT_ORDER");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.DefaultGroupId)
                    .HasColumnName("default_group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsDefault)
                    .HasColumnName("is_default")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<CouponAggregated>(entity =>
            {
                entity.ToTable("coupon_aggregated");

                entity.HasIndex(e => e.RuleName)
                    .HasName("IDX_COUPON_AGGREGATED_RULE_NAME");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_COUPON_AGGREGATED_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus, e.CouponCode })
                    .HasName("UNQ_COUPON_AGGREGATED_PERIOD_STORE_ID_ORDER_STATUS_COUPON_CODE")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CouponCode)
                    .IsRequired()
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.CouponUses)
                    .HasColumnName("coupon_uses")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountAmountActual)
                    .HasColumnName("discount_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.Period)
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.RuleName)
                    .HasColumnName("rule_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SubtotalAmount)
                    .HasColumnName("subtotal_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.SubtotalAmountActual)
                    .HasColumnName("subtotal_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalAmount)
                    .HasColumnName("total_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalAmountActual)
                    .HasColumnName("total_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CouponAggregated)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_COUPON_AGGREGATED_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CouponAggregatedOrder>(entity =>
            {
                entity.ToTable("coupon_aggregated_order");

                entity.HasIndex(e => e.RuleName)
                    .HasName("IDX_COUPON_AGGREGATED_ORDER_RULE_NAME");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_COUPON_AGGREGATED_ORDER_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus, e.CouponCode })
                    .HasName("UNQ_COUPON_AGGRED_ORDER_PERIOD_STORE_ID_ORDER_STS_COUPON_CODE")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CouponCode)
                    .IsRequired()
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.CouponUses)
                    .HasColumnName("coupon_uses")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.Period)
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.RuleName)
                    .HasColumnName("rule_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SubtotalAmount)
                    .HasColumnName("subtotal_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalAmount)
                    .HasColumnName("total_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CouponAggregatedOrder)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_COUPON_AGGREGATED_ORDER_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CouponAggregatedUpdated>(entity =>
            {
                entity.ToTable("coupon_aggregated_updated");

                entity.HasIndex(e => e.RuleName)
                    .HasName("IDX_COUPON_AGGREGATED_UPDATED_RULE_NAME");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_COUPON_AGGREGATED_UPDATED_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus, e.CouponCode })
                    .HasName("UNQ_COUPON_AGGRED_UPDATED_PERIOD_STORE_ID_ORDER_STS_COUPON_CODE")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CouponCode)
                    .IsRequired()
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.CouponUses)
                    .HasColumnName("coupon_uses")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountAmountActual)
                    .HasColumnName("discount_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.Period)
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.RuleName)
                    .HasColumnName("rule_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SubtotalAmount)
                    .HasColumnName("subtotal_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.SubtotalAmountActual)
                    .HasColumnName("subtotal_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalAmount)
                    .HasColumnName("total_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalAmountActual)
                    .HasColumnName("total_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CouponAggregatedUpdated)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_COUPON_AGGREGATED_UPDATED_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<CronSchedule>(entity =>
            {
                entity.HasKey(e => e.ScheduleId)
                    .HasName("PK_cron_schedule");

                entity.ToTable("cron_schedule");

                entity.HasIndex(e => e.JobCode)
                    .HasName("IDX_CRON_SCHEDULE_JOB_CODE");

                entity.HasIndex(e => new { e.ScheduledAt, e.Status })
                    .HasName("IDX_CRON_SCHEDULE_SCHEDULED_AT_STATUS");

                entity.Property(e => e.ScheduleId)
                    .HasColumnName("schedule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Eta)
                    .HasColumnName("eta")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ExecutedAt)
                    .HasColumnName("executed_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.FinishedAt)
                    .HasColumnName("finished_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Host)
                    .HasColumnName("host")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.JobCode)
                    .IsRequired()
                    .HasColumnName("job_code")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.KillRequest)
                    .HasColumnName("kill_request")
                    .HasColumnType("timestamp");

                entity.Property(e => e.LastSeen)
                    .HasColumnName("last_seen")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Messages)
                    .HasColumnName("messages")
                    .HasColumnType("text");

                entity.Property(e => e.Parameters)
                    .HasColumnName("parameters")
                    .HasColumnType("text");

                entity.Property(e => e.Pid)
                    .HasColumnName("pid")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProgressMessage)
                    .HasColumnName("progress_message")
                    .HasColumnType("text");

                entity.Property(e => e.ScheduledAt)
                    .HasColumnName("scheduled_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ScheduledBy)
                    .HasColumnName("scheduled_by")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ScheduledReason)
                    .HasColumnName("scheduled_reason")
                    .HasColumnType("text");

                entity.Property(e => e.Status)
                    .IsRequired()
                    .HasColumnName("status")
                    .HasColumnType("varchar(7)")
                    .HasDefaultValueSql("pending");
            });

            modelBuilder.Entity<CustomerAddressEntity>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_customer_address_entity");

                entity.ToTable("customer_address_entity");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IncrementId)
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.CustomerAddressEntity)
                    .HasForeignKey(d => d.ParentId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_CUSTOMER_ADDRESS_ENTITY_PARENT_ID_CUSTOMER_ENTITY_ENTITY_ID");
            });

            modelBuilder.Entity<CustomerAddressEntityDatetime>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_address_entity_datetime");

                entity.ToTable("customer_address_entity_datetime");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_DATETIME_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_DATETIME_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_DATETIME_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ADDRESS_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.Value })
                    .HasName("IDX_CSTR_ADDR_ENTT_DTIME_ENTT_ID_ATTR_ID_VAL");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerAddressEntityDatetime)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerAddressEntityDatetime)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_DTIME_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerAddressEntityDatetime)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_DTIME_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerAddressEntityDecimal>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_address_entity_decimal");

                entity.ToTable("customer_address_entity_decimal");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_DECIMAL_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_DECIMAL_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_DECIMAL_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ADDRESS_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.Value })
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_VALUE");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerAddressEntityDecimal)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerAddressEntityDecimal)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_DEC_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerAddressEntityDecimal)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_DEC_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerAddressEntityInt>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_address_entity_int");

                entity.ToTable("customer_address_entity_int");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_INT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_INT_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_INT_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ADDRESS_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.Value })
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_VALUE");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerAddressEntityInt)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerAddressEntityInt)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_INT_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerAddressEntityInt)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_INT_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerAddressEntityText>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_address_entity_text");

                entity.ToTable("customer_address_entity_text");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_TEXT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_TEXT_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_TEXT_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ADDRESS_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerAddressEntityText)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerAddressEntityText)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_TEXT_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerAddressEntityText)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_TEXT_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerAddressEntityVarchar>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_address_entity_varchar");

                entity.ToTable("customer_address_entity_varchar");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_VARCHAR_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_VARCHAR_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_VARCHAR_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ADDRESS_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.Value })
                    .HasName("IDX_CUSTOMER_ADDRESS_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_VALUE");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerAddressEntityVarchar)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerAddressEntityVarchar)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_VCHR_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerAddressEntityVarchar)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ADDR_ENTT_VCHR_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerEavAttribute>(entity =>
            {
                entity.HasKey(e => e.AttributeId)
                    .HasName("PK_customer_eav_attribute");

                entity.ToTable("customer_eav_attribute");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.DataModel)
                    .HasColumnName("data_model")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.InputFilter)
                    .HasColumnName("input_filter")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsSystem)
                    .HasColumnName("is_system")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsVisible)
                    .HasColumnName("is_visible")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.MultilineCount)
                    .HasColumnName("multiline_count")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ValidateRules)
                    .HasColumnName("validate_rules")
                    .HasColumnType("text");

                entity.HasOne(d => d.Attribute)
                    .WithOne(p => p.CustomerEavAttribute)
                    .HasForeignKey<CustomerEavAttribute>(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_EAV_ATTR_ATTR_ID_EAV_ATTR_ATTR_ID");
            });

            modelBuilder.Entity<CustomerEavAttributeWebsite>(entity =>
            {
                entity.HasKey(e => new { e.AttributeId, e.WebsiteId })
                    .HasName("PK_customer_eav_attribute_website");

                entity.ToTable("customer_eav_attribute_website");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CUSTOMER_EAV_ATTRIBUTE_WEBSITE_WEBSITE_ID");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.DefaultValue)
                    .HasColumnName("default_value")
                    .HasColumnType("text");

                entity.Property(e => e.IsRequired)
                    .HasColumnName("is_required")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.IsVisible)
                    .HasColumnName("is_visible")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.MultilineCount)
                    .HasColumnName("multiline_count")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerEavAttributeWebsite)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_EAV_ATTR_WS_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CustomerEavAttributeWebsite)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_CSTR_EAV_ATTR_WS_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<CustomerEntity>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_customer_entity");

                entity.ToTable("customer_entity");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ENTITY_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_CUSTOMER_ENTITY_STORE_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_CUSTOMER_ENTITY_WEBSITE_ID");

                entity.HasIndex(e => new { e.Email, e.WebsiteId })
                    .HasName("IDX_CUSTOMER_ENTITY_EMAIL_WEBSITE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.DisableAutoGroupChange)
                    .HasColumnName("disable_auto_group_change")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Email)
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GroupId)
                    .HasColumnName("group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IncrementId)
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.CustomerEntity)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_STORE_ID_CORE_STORE_STORE_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.CustomerEntity)
                    .HasForeignKey(d => d.WebsiteId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<CustomerEntityDatetime>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_entity_datetime");

                entity.ToTable("customer_entity_datetime");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ENTITY_DATETIME_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ENTITY_DATETIME_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ENTITY_DATETIME_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.Value })
                    .HasName("IDX_CUSTOMER_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_VALUE");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerEntityDatetime)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerEntityDatetime)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_DATETIME_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerEntityDatetime)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ENTT_DTIME_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerEntityDecimal>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_entity_decimal");

                entity.ToTable("customer_entity_decimal");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ENTITY_DECIMAL_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ENTITY_DECIMAL_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ENTITY_DECIMAL_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.Value })
                    .HasName("IDX_CUSTOMER_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_VALUE");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerEntityDecimal)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerEntityDecimal)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_DECIMAL_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerEntityDecimal)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ENTT_DEC_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerEntityInt>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_entity_int");

                entity.ToTable("customer_entity_int");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ENTITY_INT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ENTITY_INT_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ENTITY_INT_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.Value })
                    .HasName("IDX_CUSTOMER_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_VALUE");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerEntityInt)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_INT_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerEntityInt)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_INT_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerEntityInt)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ENTT_INT_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerEntityText>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_entity_text");

                entity.ToTable("customer_entity_text");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ENTITY_TEXT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ENTITY_TEXT_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ENTITY_TEXT_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerEntityText)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_TEXT_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerEntityText)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_TEXT_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerEntityText)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ENTT_TEXT_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerEntityVarchar>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_customer_entity_varchar");

                entity.ToTable("customer_entity_varchar");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_ENTITY_VARCHAR_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_CUSTOMER_ENTITY_VARCHAR_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_CUSTOMER_ENTITY_VARCHAR_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId })
                    .HasName("UNQ_CUSTOMER_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.Value })
                    .HasName("IDX_CUSTOMER_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_VALUE");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerEntityVarchar)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.CustomerEntityVarchar)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_CUSTOMER_ENTITY_VARCHAR_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.CustomerEntityVarchar)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_CSTR_ENTT_VCHR_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<CustomerFormAttribute>(entity =>
            {
                entity.HasKey(e => new { e.FormCode, e.AttributeId })
                    .HasName("PK_customer_form_attribute");

                entity.ToTable("customer_form_attribute");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_CUSTOMER_FORM_ATTRIBUTE_ATTRIBUTE_ID");

                entity.Property(e => e.FormCode)
                    .HasColumnName("form_code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.CustomerFormAttribute)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_CSTR_FORM_ATTR_ATTR_ID_EAV_ATTR_ATTR_ID");
            });

            modelBuilder.Entity<CustomerGroup>(entity =>
            {
                entity.ToTable("customer_group");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CustomerGroupCode)
                    .IsRequired()
                    .HasColumnName("customer_group_code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.TaxClassId)
                    .HasColumnName("tax_class_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<DataflowBatch>(entity =>
            {
                entity.HasKey(e => e.BatchId)
                    .HasName("PK_dataflow_batch");

                entity.ToTable("dataflow_batch");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_DATAFLOW_BATCH_CREATED_AT");

                entity.HasIndex(e => e.ProfileId)
                    .HasName("IDX_DATAFLOW_BATCH_PROFILE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_DATAFLOW_BATCH_STORE_ID");

                entity.Property(e => e.BatchId)
                    .HasColumnName("batch_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Adapter)
                    .HasColumnName("adapter")
                    .HasColumnType("varchar(128)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Params)
                    .HasColumnName("params")
                    .HasColumnType("text");

                entity.Property(e => e.ProfileId)
                    .HasColumnName("profile_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Profile)
                    .WithMany(p => p.DataflowBatch)
                    .HasForeignKey(d => d.ProfileId)
                    .HasConstraintName("FK_DATAFLOW_BATCH_PROFILE_ID_DATAFLOW_PROFILE_PROFILE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.DataflowBatch)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_DATAFLOW_BATCH_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<DataflowBatchExport>(entity =>
            {
                entity.HasKey(e => e.BatchExportId)
                    .HasName("PK_dataflow_batch_export");

                entity.ToTable("dataflow_batch_export");

                entity.HasIndex(e => e.BatchId)
                    .HasName("IDX_DATAFLOW_BATCH_EXPORT_BATCH_ID");

                entity.Property(e => e.BatchExportId)
                    .HasColumnName("batch_export_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.BatchData).HasColumnName("batch_data");

                entity.Property(e => e.BatchId)
                    .HasColumnName("batch_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Batch)
                    .WithMany(p => p.DataflowBatchExport)
                    .HasForeignKey(d => d.BatchId)
                    .HasConstraintName("FK_DATAFLOW_BATCH_EXPORT_BATCH_ID_DATAFLOW_BATCH_BATCH_ID");
            });

            modelBuilder.Entity<DataflowBatchImport>(entity =>
            {
                entity.HasKey(e => e.BatchImportId)
                    .HasName("PK_dataflow_batch_import");

                entity.ToTable("dataflow_batch_import");

                entity.HasIndex(e => e.BatchId)
                    .HasName("IDX_DATAFLOW_BATCH_IMPORT_BATCH_ID");

                entity.Property(e => e.BatchImportId)
                    .HasColumnName("batch_import_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.BatchData).HasColumnName("batch_data");

                entity.Property(e => e.BatchId)
                    .HasColumnName("batch_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Batch)
                    .WithMany(p => p.DataflowBatchImport)
                    .HasForeignKey(d => d.BatchId)
                    .HasConstraintName("FK_DATAFLOW_BATCH_IMPORT_BATCH_ID_DATAFLOW_BATCH_BATCH_ID");
            });

            modelBuilder.Entity<DataflowImportData>(entity =>
            {
                entity.HasKey(e => e.ImportId)
                    .HasName("PK_dataflow_import_data");

                entity.ToTable("dataflow_import_data");

                entity.HasIndex(e => e.SessionId)
                    .HasName("IDX_DATAFLOW_IMPORT_DATA_SESSION_ID");

                entity.Property(e => e.ImportId)
                    .HasColumnName("import_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.SerialNumber)
                    .HasColumnName("serial_number")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SessionId)
                    .HasColumnName("session_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Session)
                    .WithMany(p => p.DataflowImportData)
                    .HasForeignKey(d => d.SessionId)
                    .HasConstraintName("FK_DATAFLOW_IMPORT_DATA_SESSION_ID_DATAFLOW_SESSION_SESSION_ID");
            });

            modelBuilder.Entity<DataflowProfile>(entity =>
            {
                entity.HasKey(e => e.ProfileId)
                    .HasName("PK_dataflow_profile");

                entity.ToTable("dataflow_profile");

                entity.Property(e => e.ProfileId)
                    .HasColumnName("profile_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ActionsXml)
                    .HasColumnName("actions_xml")
                    .HasColumnType("text");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.DataTransfer)
                    .HasColumnName("data_transfer")
                    .HasColumnType("varchar(11)");

                entity.Property(e => e.Direction)
                    .HasColumnName("direction")
                    .HasColumnType("varchar(6)");

                entity.Property(e => e.EntityType)
                    .HasColumnName("entity_type")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.GuiData)
                    .HasColumnName("gui_data")
                    .HasColumnType("text");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<DataflowProfileHistory>(entity =>
            {
                entity.HasKey(e => e.HistoryId)
                    .HasName("PK_dataflow_profile_history");

                entity.ToTable("dataflow_profile_history");

                entity.HasIndex(e => e.ProfileId)
                    .HasName("IDX_DATAFLOW_PROFILE_HISTORY_PROFILE_ID");

                entity.Property(e => e.HistoryId)
                    .HasColumnName("history_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ActionCode)
                    .HasColumnName("action_code")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.PerformedAt)
                    .HasColumnName("performed_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ProfileId)
                    .HasColumnName("profile_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Profile)
                    .WithMany(p => p.DataflowProfileHistory)
                    .HasForeignKey(d => d.ProfileId)
                    .HasConstraintName("FK_AEA06B0C500063D3CE6EA671AE776645");
            });

            modelBuilder.Entity<DataflowSession>(entity =>
            {
                entity.HasKey(e => e.SessionId)
                    .HasName("PK_dataflow_session");

                entity.ToTable("dataflow_session");

                entity.Property(e => e.SessionId)
                    .HasColumnName("session_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Comment)
                    .HasColumnName("comment")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedDate)
                    .HasColumnName("created_date")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Direction)
                    .HasColumnName("direction")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.File)
                    .HasColumnName("file")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(11)");
            });

            modelBuilder.Entity<DesignChange>(entity =>
            {
                entity.ToTable("design_change");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_DESIGN_CHANGE_STORE_ID");

                entity.Property(e => e.DesignChangeId)
                    .HasColumnName("design_change_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.DateFrom)
                    .HasColumnName("date_from")
                    .HasColumnType("date");

                entity.Property(e => e.DateTo)
                    .HasColumnName("date_to")
                    .HasColumnType("date");

                entity.Property(e => e.Design)
                    .HasColumnName("design")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.DesignChange)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_DESIGN_CHANGE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<DirectoryCountry>(entity =>
            {
                entity.HasKey(e => e.CountryId)
                    .HasName("PK_directory_country");

                entity.ToTable("directory_country");

                entity.Property(e => e.CountryId)
                    .HasColumnName("country_id")
                    .HasColumnType("varchar(2)");

                entity.Property(e => e.Iso2Code)
                    .HasColumnName("iso2_code")
                    .HasColumnType("varchar(2)");

                entity.Property(e => e.Iso3Code)
                    .HasColumnName("iso3_code")
                    .HasColumnType("varchar(3)");
            });

            modelBuilder.Entity<DirectoryCountryFormat>(entity =>
            {
                entity.HasKey(e => e.CountryFormatId)
                    .HasName("PK_directory_country_format");

                entity.ToTable("directory_country_format");

                entity.HasIndex(e => new { e.CountryId, e.Type })
                    .HasName("UNQ_DIRECTORY_COUNTRY_FORMAT_COUNTRY_ID_TYPE")
                    .IsUnique();

                entity.Property(e => e.CountryFormatId)
                    .HasColumnName("country_format_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CountryId)
                    .IsRequired()
                    .HasColumnName("country_id")
                    .HasColumnType("varchar(2)");

                entity.Property(e => e.Format)
                    .IsRequired()
                    .HasColumnName("format")
                    .HasColumnType("text");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasColumnName("type")
                    .HasColumnType("varchar(30)");
            });

            modelBuilder.Entity<DirectoryCountryRegion>(entity =>
            {
                entity.HasKey(e => e.RegionId)
                    .HasName("PK_directory_country_region");

                entity.ToTable("directory_country_region");

                entity.HasIndex(e => e.CountryId)
                    .HasName("IDX_DIRECTORY_COUNTRY_REGION_COUNTRY_ID");

                entity.Property(e => e.RegionId)
                    .HasColumnName("region_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.CountryId)
                    .IsRequired()
                    .HasColumnName("country_id")
                    .HasColumnType("varchar(4)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.DefaultName)
                    .HasColumnName("default_name")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<DirectoryCountryRegionName>(entity =>
            {
                entity.HasKey(e => new { e.Locale, e.RegionId })
                    .HasName("PK_directory_country_region_name");

                entity.ToTable("directory_country_region_name");

                entity.HasIndex(e => e.RegionId)
                    .HasName("IDX_DIRECTORY_COUNTRY_REGION_NAME_REGION_ID");

                entity.Property(e => e.Locale)
                    .HasColumnName("locale")
                    .HasColumnType("varchar(8)");

                entity.Property(e => e.RegionId)
                    .HasColumnName("region_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Region)
                    .WithMany(p => p.DirectoryCountryRegionName)
                    .HasForeignKey(d => d.RegionId)
                    .HasConstraintName("FK_D7CFDEB379F775328EB6F62695E2B3E1");
            });

            modelBuilder.Entity<DirectoryCurrencyRate>(entity =>
            {
                entity.HasKey(e => new { e.CurrencyFrom, e.CurrencyTo })
                    .HasName("PK_directory_currency_rate");

                entity.ToTable("directory_currency_rate");

                entity.HasIndex(e => e.CurrencyTo)
                    .HasName("IDX_DIRECTORY_CURRENCY_RATE_CURRENCY_TO");

                entity.Property(e => e.CurrencyFrom)
                    .HasColumnName("currency_from")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.CurrencyTo)
                    .HasColumnName("currency_to")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.Rate)
                    .HasColumnName("rate")
                    .HasColumnType("decimal(24,12)")
                    .HasDefaultValueSql("0.000000000000");
            });

            modelBuilder.Entity<DownloadableLink>(entity =>
            {
                entity.HasKey(e => e.LinkId)
                    .HasName("PK_downloadable_link");

                entity.ToTable("downloadable_link");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_DOWNLOADABLE_LINK_PRODUCT_ID");

                entity.HasIndex(e => new { e.ProductId, e.SortOrder })
                    .HasName("IDX_DOWNLOADABLE_LINK_PRODUCT_ID_SORT_ORDER");

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.IsShareable)
                    .HasColumnName("is_shareable")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LinkFile)
                    .HasColumnName("link_file")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.LinkType)
                    .HasColumnName("link_type")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.LinkUrl)
                    .HasColumnName("link_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NumberOfDownloads)
                    .HasColumnName("number_of_downloads")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SampleFile)
                    .HasColumnName("sample_file")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SampleType)
                    .HasColumnName("sample_type")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.SampleUrl)
                    .HasColumnName("sample_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.DownloadableLink)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_DOWNLOADABLE_LINK_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID");
            });

            modelBuilder.Entity<DownloadableLinkPrice>(entity =>
            {
                entity.HasKey(e => e.PriceId)
                    .HasName("PK_downloadable_link_price");

                entity.ToTable("downloadable_link_price");

                entity.HasIndex(e => e.LinkId)
                    .HasName("IDX_DOWNLOADABLE_LINK_PRICE_LINK_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_DOWNLOADABLE_LINK_PRICE_WEBSITE_ID");

                entity.Property(e => e.PriceId)
                    .HasColumnName("price_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Link)
                    .WithMany(p => p.DownloadableLinkPrice)
                    .HasForeignKey(d => d.LinkId)
                    .HasConstraintName("FK_DOWNLOADABLE_LINK_PRICE_LINK_ID_DOWNLOADABLE_LINK_LINK_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.DownloadableLinkPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_DOWNLOADABLE_LINK_PRICE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<DownloadableLinkPurchased>(entity =>
            {
                entity.HasKey(e => e.PurchasedId)
                    .HasName("PK_downloadable_link_purchased");

                entity.ToTable("downloadable_link_purchased");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_DOWNLOADABLE_LINK_PURCHASED_CUSTOMER_ID");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_DOWNLOADABLE_LINK_PURCHASED_ORDER_ID");

                entity.HasIndex(e => e.OrderItemId)
                    .HasName("IDX_DOWNLOADABLE_LINK_PURCHASED_ORDER_ITEM_ID");

                entity.Property(e => e.PurchasedId)
                    .HasColumnName("purchased_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LinkSectionTitle)
                    .HasColumnName("link_section_title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OrderIncrementId)
                    .HasColumnName("order_increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrderItemId)
                    .HasColumnName("order_item_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductName)
                    .HasColumnName("product_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductSku)
                    .HasColumnName("product_sku")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.DownloadableLinkPurchased)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_DL_LNK_PURCHASED_CSTR_ID_CSTR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.DownloadableLinkPurchased)
                    .HasForeignKey(d => d.OrderId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_DL_LNK_PURCHASED_ORDER_ID_SALES_FLAT_ORDER_ENTT_ID");
            });

            modelBuilder.Entity<DownloadableLinkPurchasedItem>(entity =>
            {
                entity.HasKey(e => e.ItemId)
                    .HasName("PK_downloadable_link_purchased_item");

                entity.ToTable("downloadable_link_purchased_item");

                entity.HasIndex(e => e.LinkHash)
                    .HasName("IDX_DOWNLOADABLE_LINK_PURCHASED_ITEM_LINK_HASH");

                entity.HasIndex(e => e.OrderItemId)
                    .HasName("IDX_DOWNLOADABLE_LINK_PURCHASED_ITEM_ORDER_ITEM_ID");

                entity.HasIndex(e => e.PurchasedId)
                    .HasName("IDX_DOWNLOADABLE_LINK_PURCHASED_ITEM_PURCHASED_ID");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.IsShareable)
                    .HasColumnName("is_shareable")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LinkFile)
                    .HasColumnName("link_file")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.LinkHash)
                    .HasColumnName("link_hash")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LinkTitle)
                    .HasColumnName("link_title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.LinkType)
                    .HasColumnName("link_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.LinkUrl)
                    .HasColumnName("link_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NumberOfDownloadsBought)
                    .HasColumnName("number_of_downloads_bought")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.NumberOfDownloadsUsed)
                    .HasColumnName("number_of_downloads_used")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OrderItemId)
                    .HasColumnName("order_item_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.PurchasedId)
                    .HasColumnName("purchased_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.OrderItem)
                    .WithMany(p => p.DownloadableLinkPurchasedItem)
                    .HasForeignKey(d => d.OrderItemId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_B219BF25756700DEE44550B21220ECCE");

                entity.HasOne(d => d.Purchased)
                    .WithMany(p => p.DownloadableLinkPurchasedItem)
                    .HasForeignKey(d => d.PurchasedId)
                    .HasConstraintName("FK_46CC8E252307CE62F00A8F1887512A39");
            });

            modelBuilder.Entity<DownloadableLinkTitle>(entity =>
            {
                entity.HasKey(e => e.TitleId)
                    .HasName("PK_downloadable_link_title");

                entity.ToTable("downloadable_link_title");

                entity.HasIndex(e => e.LinkId)
                    .HasName("IDX_DOWNLOADABLE_LINK_TITLE_LINK_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_DOWNLOADABLE_LINK_TITLE_STORE_ID");

                entity.HasIndex(e => new { e.LinkId, e.StoreId })
                    .HasName("UNQ_DOWNLOADABLE_LINK_TITLE_LINK_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.TitleId)
                    .HasColumnName("title_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Link)
                    .WithMany(p => p.DownloadableLinkTitle)
                    .HasForeignKey(d => d.LinkId)
                    .HasConstraintName("FK_DOWNLOADABLE_LINK_TITLE_LINK_ID_DOWNLOADABLE_LINK_LINK_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.DownloadableLinkTitle)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_DOWNLOADABLE_LINK_TITLE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<DownloadableSample>(entity =>
            {
                entity.HasKey(e => e.SampleId)
                    .HasName("PK_downloadable_sample");

                entity.ToTable("downloadable_sample");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_DOWNLOADABLE_SAMPLE_PRODUCT_ID");

                entity.Property(e => e.SampleId)
                    .HasColumnName("sample_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SampleFile)
                    .HasColumnName("sample_file")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SampleType)
                    .HasColumnName("sample_type")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.SampleUrl)
                    .HasColumnName("sample_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.DownloadableSample)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_DL_SAMPLE_PRD_ID_CAT_PRD_ENTT_ENTT_ID");
            });

            modelBuilder.Entity<DownloadableSampleTitle>(entity =>
            {
                entity.HasKey(e => e.TitleId)
                    .HasName("PK_downloadable_sample_title");

                entity.ToTable("downloadable_sample_title");

                entity.HasIndex(e => e.SampleId)
                    .HasName("IDX_DOWNLOADABLE_SAMPLE_TITLE_SAMPLE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_DOWNLOADABLE_SAMPLE_TITLE_STORE_ID");

                entity.HasIndex(e => new { e.SampleId, e.StoreId })
                    .HasName("UNQ_DOWNLOADABLE_SAMPLE_TITLE_SAMPLE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.TitleId)
                    .HasColumnName("title_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.SampleId)
                    .HasColumnName("sample_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Sample)
                    .WithMany(p => p.DownloadableSampleTitle)
                    .HasForeignKey(d => d.SampleId)
                    .HasConstraintName("FK_DL_SAMPLE_TTL_SAMPLE_ID_DL_SAMPLE_SAMPLE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.DownloadableSampleTitle)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_DOWNLOADABLE_SAMPLE_TITLE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavAttribute>(entity =>
            {
                entity.HasKey(e => e.AttributeId)
                    .HasName("PK_eav_attribute");

                entity.ToTable("eav_attribute");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_ATTRIBUTE_ENTITY_TYPE_ID");

                entity.HasIndex(e => new { e.EntityTypeId, e.AttributeCode })
                    .HasName("UNQ_EAV_ATTRIBUTE_ENTITY_TYPE_ID_ATTRIBUTE_CODE")
                    .IsUnique();

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.AttributeCode)
                    .IsRequired()
                    .HasColumnName("attribute_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AttributeModel)
                    .HasColumnName("attribute_model")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.BackendModel)
                    .HasColumnName("backend_model")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.BackendTable)
                    .HasColumnName("backend_table")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.BackendType)
                    .IsRequired()
                    .HasColumnName("backend_type")
                    .HasColumnType("varchar(8)")
                    .HasDefaultValueSql("static");

                entity.Property(e => e.DefaultValue)
                    .HasColumnName("default_value")
                    .HasColumnType("text");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.FrontendClass)
                    .HasColumnName("frontend_class")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FrontendInput)
                    .HasColumnName("frontend_input")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.FrontendLabel)
                    .HasColumnName("frontend_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FrontendModel)
                    .HasColumnName("frontend_model")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsRequired)
                    .HasColumnName("is_required")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsUnique)
                    .HasColumnName("is_unique")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsUserDefined)
                    .HasColumnName("is_user_defined")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Note)
                    .HasColumnName("note")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SourceModel)
                    .HasColumnName("source_model")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavAttribute)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ATTRIBUTE_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID");
            });

            modelBuilder.Entity<EavAttributeGroup>(entity =>
            {
                entity.HasKey(e => e.AttributeGroupId)
                    .HasName("PK_eav_attribute_group");

                entity.ToTable("eav_attribute_group");

                entity.HasIndex(e => new { e.AttributeSetId, e.AttributeGroupName })
                    .HasName("UNQ_EAV_ATTRIBUTE_GROUP_ATTRIBUTE_SET_ID_ATTRIBUTE_GROUP_NAME")
                    .IsUnique();

                entity.HasIndex(e => new { e.AttributeSetId, e.SortOrder })
                    .HasName("IDX_EAV_ATTRIBUTE_GROUP_ATTRIBUTE_SET_ID_SORT_ORDER");

                entity.Property(e => e.AttributeGroupId)
                    .HasColumnName("attribute_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.AttributeGroupName)
                    .IsRequired()
                    .HasColumnName("attribute_group_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.DefaultId)
                    .HasColumnName("default_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.AttributeSet)
                    .WithMany(p => p.EavAttributeGroup)
                    .HasForeignKey(d => d.AttributeSetId)
                    .HasConstraintName("FK_EAV_ATTR_GROUP_ATTR_SET_ID_EAV_ATTR_SET_ATTR_SET_ID");
            });

            modelBuilder.Entity<EavAttributeLabel>(entity =>
            {
                entity.HasKey(e => e.AttributeLabelId)
                    .HasName("PK_eav_attribute_label");

                entity.ToTable("eav_attribute_label");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_ATTRIBUTE_LABEL_ATTRIBUTE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ATTRIBUTE_LABEL_STORE_ID");

                entity.HasIndex(e => new { e.AttributeId, e.StoreId })
                    .HasName("IDX_EAV_ATTRIBUTE_LABEL_ATTRIBUTE_ID_STORE_ID");

                entity.Property(e => e.AttributeLabelId)
                    .HasColumnName("attribute_label_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.EavAttributeLabel)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_EAV_ATTRIBUTE_LABEL_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavAttributeLabel)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ATTRIBUTE_LABEL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavAttributeOption>(entity =>
            {
                entity.HasKey(e => e.OptionId)
                    .HasName("PK_eav_attribute_option");

                entity.ToTable("eav_attribute_option");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_ATTRIBUTE_OPTION_ATTRIBUTE_ID");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.EavAttributeOption)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_EAV_ATTRIBUTE_OPTION_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID");
            });

            modelBuilder.Entity<EavAttributeOptionValue>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_eav_attribute_option_value");

                entity.ToTable("eav_attribute_option_value");

                entity.HasIndex(e => e.OptionId)
                    .HasName("IDX_EAV_ATTRIBUTE_OPTION_VALUE_OPTION_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ATTRIBUTE_OPTION_VALUE_STORE_ID");

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Option)
                    .WithMany(p => p.EavAttributeOptionValue)
                    .HasForeignKey(d => d.OptionId)
                    .HasConstraintName("FK_EAV_ATTR_OPT_VAL_OPT_ID_EAV_ATTR_OPT_OPT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavAttributeOptionValue)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ATTRIBUTE_OPTION_VALUE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavAttributeSet>(entity =>
            {
                entity.HasKey(e => e.AttributeSetId)
                    .HasName("PK_eav_attribute_set");

                entity.ToTable("eav_attribute_set");

                entity.HasIndex(e => new { e.EntityTypeId, e.AttributeSetName })
                    .HasName("UNQ_EAV_ATTRIBUTE_SET_ENTITY_TYPE_ID_ATTRIBUTE_SET_NAME")
                    .IsUnique();

                entity.HasIndex(e => new { e.EntityTypeId, e.SortOrder })
                    .HasName("IDX_EAV_ATTRIBUTE_SET_ENTITY_TYPE_ID_SORT_ORDER");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.AttributeSetName)
                    .IsRequired()
                    .HasColumnName("attribute_set_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavAttributeSet)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ATTR_SET_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");
            });

            modelBuilder.Entity<EavEntity>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_eav_entity");

                entity.ToTable("eav_entity");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_ENTITY_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ENTITY_STORE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IncrementId)
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavEntity)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ENTITY_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavEntity)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ENTITY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavEntityAttribute>(entity =>
            {
                entity.HasKey(e => e.EntityAttributeId)
                    .HasName("PK_eav_entity_attribute");

                entity.ToTable("eav_entity_attribute");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_ID");

                entity.HasIndex(e => new { e.AttributeGroupId, e.AttributeId })
                    .HasName("UNQ_EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_GROUP_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.AttributeSetId, e.AttributeId })
                    .HasName("UNQ_EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_SET_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.AttributeSetId, e.SortOrder })
                    .HasName("IDX_EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_SET_ID_SORT_ORDER");

                entity.Property(e => e.EntityAttributeId)
                    .HasColumnName("entity_attribute_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeGroupId)
                    .HasColumnName("attribute_group_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.AttributeSetId)
                    .HasColumnName("attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.AttributeGroup)
                    .WithMany(p => p.EavEntityAttribute)
                    .HasForeignKey(d => d.AttributeGroupId)
                    .HasConstraintName("FK_EAV_ENTT_ATTR_ATTR_GROUP_ID_EAV_ATTR_GROUP_ATTR_GROUP_ID");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.EavEntityAttribute)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID");
            });

            modelBuilder.Entity<EavEntityDatetime>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_eav_entity_datetime");

                entity.ToTable("eav_entity_datetime");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_ENTITY_DATETIME_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_EAV_ENTITY_DATETIME_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_ENTITY_DATETIME_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ENTITY_DATETIME_STORE_ID");

                entity.HasIndex(e => new { e.AttributeId, e.Value })
                    .HasName("IDX_EAV_ENTITY_DATETIME_ATTRIBUTE_ID_VALUE");

                entity.HasIndex(e => new { e.EntityTypeId, e.Value })
                    .HasName("IDX_EAV_ENTITY_DATETIME_ENTITY_TYPE_ID_VALUE");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_EAV_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.EavEntityDatetime)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_EAV_ENTITY_DATETIME_ENTITY_ID_EAV_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavEntityDatetime)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ENTT_DTIME_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavEntityDatetime)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ENTITY_DATETIME_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavEntityDecimal>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_eav_entity_decimal");

                entity.ToTable("eav_entity_decimal");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_ENTITY_DECIMAL_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_EAV_ENTITY_DECIMAL_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_ENTITY_DECIMAL_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ENTITY_DECIMAL_STORE_ID");

                entity.HasIndex(e => new { e.AttributeId, e.Value })
                    .HasName("IDX_EAV_ENTITY_DECIMAL_ATTRIBUTE_ID_VALUE");

                entity.HasIndex(e => new { e.EntityTypeId, e.Value })
                    .HasName("IDX_EAV_ENTITY_DECIMAL_ENTITY_TYPE_ID_VALUE");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_EAV_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.EavEntityDecimal)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_EAV_ENTITY_DECIMAL_ENTITY_ID_EAV_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavEntityDecimal)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ENTT_DEC_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavEntityDecimal)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ENTITY_DECIMAL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavEntityInt>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_eav_entity_int");

                entity.ToTable("eav_entity_int");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_ENTITY_INT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_EAV_ENTITY_INT_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_ENTITY_INT_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ENTITY_INT_STORE_ID");

                entity.HasIndex(e => new { e.AttributeId, e.Value })
                    .HasName("IDX_EAV_ENTITY_INT_ATTRIBUTE_ID_VALUE");

                entity.HasIndex(e => new { e.EntityTypeId, e.Value })
                    .HasName("IDX_EAV_ENTITY_INT_ENTITY_TYPE_ID_VALUE");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_EAV_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.EavEntityInt)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_EAV_ENTITY_INT_ENTITY_ID_EAV_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavEntityInt)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ENTITY_INT_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavEntityInt)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ENTITY_INT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavEntityStore>(entity =>
            {
                entity.HasKey(e => e.EntityStoreId)
                    .HasName("PK_eav_entity_store");

                entity.ToTable("eav_entity_store");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_ENTITY_STORE_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ENTITY_STORE_STORE_ID");

                entity.Property(e => e.EntityStoreId)
                    .HasColumnName("entity_store_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IncrementLastId)
                    .HasColumnName("increment_last_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.IncrementPrefix)
                    .HasColumnName("increment_prefix")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavEntityStore)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ENTT_STORE_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavEntityStore)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ENTITY_STORE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavEntityText>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_eav_entity_text");

                entity.ToTable("eav_entity_text");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_ENTITY_TEXT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_EAV_ENTITY_TEXT_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_ENTITY_TEXT_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ENTITY_TEXT_STORE_ID");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_EAV_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.EavEntityText)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_EAV_ENTITY_TEXT_ENTITY_ID_EAV_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavEntityText)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ENTITY_TEXT_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavEntityText)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ENTITY_TEXT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavEntityType>(entity =>
            {
                entity.HasKey(e => e.EntityTypeId)
                    .HasName("PK_eav_entity_type");

                entity.ToTable("eav_entity_type");

                entity.HasIndex(e => e.EntityTypeCode)
                    .HasName("IDX_EAV_ENTITY_TYPE_ENTITY_TYPE_CODE");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.AdditionalAttributeTable)
                    .HasColumnName("additional_attribute_table")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AttributeModel)
                    .HasColumnName("attribute_model")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.DataSharingKey)
                    .HasColumnName("data_sharing_key")
                    .HasColumnType("varchar(100)")
                    .HasDefaultValueSql("default");

                entity.Property(e => e.DefaultAttributeSetId)
                    .HasColumnName("default_attribute_set_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityAttributeCollection)
                    .HasColumnName("entity_attribute_collection")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EntityIdField)
                    .HasColumnName("entity_id_field")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EntityModel)
                    .IsRequired()
                    .HasColumnName("entity_model")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EntityTable)
                    .HasColumnName("entity_table")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EntityTypeCode)
                    .IsRequired()
                    .HasColumnName("entity_type_code")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.IncrementModel)
                    .HasColumnName("increment_model")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IncrementPadChar)
                    .IsRequired()
                    .HasColumnName("increment_pad_char")
                    .HasColumnType("varchar(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IncrementPadLength)
                    .HasColumnName("increment_pad_length")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("8");

                entity.Property(e => e.IncrementPerStore)
                    .HasColumnName("increment_per_store")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsDataSharing)
                    .HasColumnName("is_data_sharing")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.ValueTablePrefix)
                    .HasColumnName("value_table_prefix")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<EavEntityVarchar>(entity =>
            {
                entity.HasKey(e => e.ValueId)
                    .HasName("PK_eav_entity_varchar");

                entity.ToTable("eav_entity_varchar");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_ENTITY_VARCHAR_ATTRIBUTE_ID");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_EAV_ENTITY_VARCHAR_ENTITY_ID");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_ENTITY_VARCHAR_ENTITY_TYPE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_ENTITY_VARCHAR_STORE_ID");

                entity.HasIndex(e => new { e.AttributeId, e.Value })
                    .HasName("IDX_EAV_ENTITY_VARCHAR_ATTRIBUTE_ID_VALUE");

                entity.HasIndex(e => new { e.EntityTypeId, e.Value })
                    .HasName("IDX_EAV_ENTITY_VARCHAR_ENTITY_TYPE_ID_VALUE");

                entity.HasIndex(e => new { e.EntityId, e.AttributeId, e.StoreId })
                    .HasName("UNQ_EAV_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.ValueId)
                    .HasColumnName("value_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.EavEntityVarchar)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_EAV_ENTITY_VARCHAR_ENTITY_ID_EAV_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavEntityVarchar)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_ENTT_VCHR_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavEntityVarchar)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_ENTITY_VARCHAR_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavFormElement>(entity =>
            {
                entity.HasKey(e => e.ElementId)
                    .HasName("PK_eav_form_element");

                entity.ToTable("eav_form_element");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_EAV_FORM_ELEMENT_ATTRIBUTE_ID");

                entity.HasIndex(e => e.FieldsetId)
                    .HasName("IDX_EAV_FORM_ELEMENT_FIELDSET_ID");

                entity.HasIndex(e => e.TypeId)
                    .HasName("IDX_EAV_FORM_ELEMENT_TYPE_ID");

                entity.HasIndex(e => new { e.TypeId, e.AttributeId })
                    .HasName("UNQ_EAV_FORM_ELEMENT_TYPE_ID_ATTRIBUTE_ID")
                    .IsUnique();

                entity.Property(e => e.ElementId)
                    .HasColumnName("element_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.FieldsetId)
                    .HasColumnName("fieldset_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TypeId)
                    .HasColumnName("type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.EavFormElement)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_EAV_FORM_ELEMENT_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID");

                entity.HasOne(d => d.Fieldset)
                    .WithMany(p => p.EavFormElement)
                    .HasForeignKey(d => d.FieldsetId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_EAV_FORM_ELEMENT_FIELDSET_ID_EAV_FORM_FIELDSET_FIELDSET_ID");

                entity.HasOne(d => d.Type)
                    .WithMany(p => p.EavFormElement)
                    .HasForeignKey(d => d.TypeId)
                    .HasConstraintName("FK_EAV_FORM_ELEMENT_TYPE_ID_EAV_FORM_TYPE_TYPE_ID");
            });

            modelBuilder.Entity<EavFormFieldset>(entity =>
            {
                entity.HasKey(e => e.FieldsetId)
                    .HasName("PK_eav_form_fieldset");

                entity.ToTable("eav_form_fieldset");

                entity.HasIndex(e => e.TypeId)
                    .HasName("IDX_EAV_FORM_FIELDSET_TYPE_ID");

                entity.HasIndex(e => new { e.TypeId, e.Code })
                    .HasName("UNQ_EAV_FORM_FIELDSET_TYPE_ID_CODE")
                    .IsUnique();

                entity.Property(e => e.FieldsetId)
                    .HasColumnName("fieldset_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TypeId)
                    .HasColumnName("type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Type)
                    .WithMany(p => p.EavFormFieldset)
                    .HasForeignKey(d => d.TypeId)
                    .HasConstraintName("FK_EAV_FORM_FIELDSET_TYPE_ID_EAV_FORM_TYPE_TYPE_ID");
            });

            modelBuilder.Entity<EavFormFieldsetLabel>(entity =>
            {
                entity.HasKey(e => new { e.FieldsetId, e.StoreId })
                    .HasName("PK_eav_form_fieldset_label");

                entity.ToTable("eav_form_fieldset_label");

                entity.HasIndex(e => e.FieldsetId)
                    .HasName("IDX_EAV_FORM_FIELDSET_LABEL_FIELDSET_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_FORM_FIELDSET_LABEL_STORE_ID");

                entity.Property(e => e.FieldsetId)
                    .HasColumnName("fieldset_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Label)
                    .IsRequired()
                    .HasColumnName("label")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Fieldset)
                    .WithMany(p => p.EavFormFieldsetLabel)
                    .HasForeignKey(d => d.FieldsetId)
                    .HasConstraintName("FK_EAV_FORM_FSET_LBL_FSET_ID_EAV_FORM_FSET_FSET_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavFormFieldsetLabel)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_FORM_FIELDSET_LABEL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavFormType>(entity =>
            {
                entity.HasKey(e => e.TypeId)
                    .HasName("PK_eav_form_type");

                entity.ToTable("eav_form_type");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_EAV_FORM_TYPE_STORE_ID");

                entity.HasIndex(e => new { e.Code, e.Theme, e.StoreId })
                    .HasName("UNQ_EAV_FORM_TYPE_CODE_THEME_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.TypeId)
                    .HasColumnName("type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.IsSystem)
                    .HasColumnName("is_system")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Label)
                    .IsRequired()
                    .HasColumnName("label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Theme)
                    .IsRequired()
                    .HasColumnName("theme")
                    .HasColumnType("varchar(64)");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.EavFormType)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_EAV_FORM_TYPE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<EavFormTypeEntity>(entity =>
            {
                entity.HasKey(e => new { e.TypeId, e.EntityTypeId })
                    .HasName("PK_eav_form_type_entity");

                entity.ToTable("eav_form_type_entity");

                entity.HasIndex(e => e.EntityTypeId)
                    .HasName("IDX_EAV_FORM_TYPE_ENTITY_ENTITY_TYPE_ID");

                entity.Property(e => e.TypeId)
                    .HasColumnName("type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.EntityTypeId)
                    .HasColumnName("entity_type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.EntityType)
                    .WithMany(p => p.EavFormTypeEntity)
                    .HasForeignKey(d => d.EntityTypeId)
                    .HasConstraintName("FK_EAV_FORM_TYPE_ENTT_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID");

                entity.HasOne(d => d.Type)
                    .WithMany(p => p.EavFormTypeEntity)
                    .HasForeignKey(d => d.TypeId)
                    .HasConstraintName("FK_EAV_FORM_TYPE_ENTITY_TYPE_ID_EAV_FORM_TYPE_TYPE_ID");
            });

            modelBuilder.Entity<GiftMessage>(entity =>
            {
                entity.ToTable("gift_message");

                entity.Property(e => e.GiftMessageId)
                    .HasColumnName("gift_message_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Message)
                    .HasColumnName("message")
                    .HasColumnType("text");

                entity.Property(e => e.Recipient)
                    .HasColumnName("recipient")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Sender)
                    .HasColumnName("sender")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<GiftcardOrder>(entity =>
            {
                entity.HasKey(e => e.IdFake)
                    .HasName("PK_giftcard_order");

                entity.ToTable("giftcard_order");

                entity.Property(e => e.IdFake)
                    .HasColumnName("id_fake")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedTime)
                    .HasColumnName("created_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Discounted)
                    .HasColumnName("discounted")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.IdGiftcard)
                    .HasColumnName("id_giftcard")
                    .HasColumnType("int(10)");

                entity.Property(e => e.IdOrder)
                    .HasColumnName("id_order")
                    .HasColumnType("int(10)");
            });

            modelBuilder.Entity<GiftcardTemplate>(entity =>
            {
                entity.ToTable("giftcard_template");

                entity.Property(e => e.GiftcardTemplateId)
                    .HasColumnName("giftcard_template_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.BackgroundImg)
                    .HasColumnName("background_img")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Caption)
                    .IsRequired()
                    .HasColumnName("caption")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.DesignPattern)
                    .HasColumnName("design_pattern")
                    .HasColumnType("smallint(5)");

                entity.Property(e => e.Images)
                    .HasColumnName("images")
                    .HasColumnType("text");

                entity.Property(e => e.Notes)
                    .HasColumnName("notes")
                    .HasColumnType("text");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.StyleColor)
                    .IsRequired()
                    .HasColumnName("style_color")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TemplateName)
                    .IsRequired()
                    .HasColumnName("template_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TextColor)
                    .IsRequired()
                    .HasColumnName("text_color")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<GiftcardsCard>(entity =>
            {
                entity.HasKey(e => e.CardId)
                    .HasName("PK_giftcards_card");

                entity.ToTable("giftcards_card");

                entity.Property(e => e.CardId)
                    .HasColumnName("card_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CardAmount)
                    .HasColumnName("card_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CardBalance)
                    .HasColumnName("card_balance")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CardCode)
                    .IsRequired()
                    .HasColumnName("card_code")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.CardCurrency)
                    .HasColumnName("card_currency")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.CardStatus)
                    .HasColumnName("card_status")
                    .HasColumnType("tinyint(3) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedTime)
                    .HasColumnName("created_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.MailDeliveryDate)
                    .HasColumnName("mail_delivery_date")
                    .HasColumnType("date");

                entity.Property(e => e.MailFrom)
                    .IsRequired()
                    .HasColumnName("mail_from")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.MailMessage)
                    .IsRequired()
                    .HasColumnName("mail_message")
                    .HasColumnType("text");

                entity.Property(e => e.MailTo)
                    .IsRequired()
                    .HasColumnName("mail_to")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.MailToEmail)
                    .IsRequired()
                    .HasColumnName("mail_to_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflineCity)
                    .IsRequired()
                    .HasColumnName("offline_city")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflineCountry)
                    .IsRequired()
                    .HasColumnName("offline_country")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflinePhone)
                    .IsRequired()
                    .HasColumnName("offline_phone")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflineState)
                    .IsRequired()
                    .HasColumnName("offline_state")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflineStreet)
                    .IsRequired()
                    .HasColumnName("offline_street")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflineZip)
                    .IsRequired()
                    .HasColumnName("offline_zip")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.UpdatedTime)
                    .HasColumnName("updated_time")
                    .HasColumnType("datetime");
            });

            modelBuilder.Entity<GiftcardsCardlist>(entity =>
            {
                entity.HasKey(e => e.ListId)
                    .HasName("PK_giftcards_cardlist");

                entity.ToTable("giftcards_cardlist");

                entity.Property(e => e.ListId)
                    .HasColumnName("list_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedTime)
                    .HasColumnName("created_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.FilePath)
                    .IsRequired()
                    .HasColumnName("file_path")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<GiftcardsLog>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_giftcards_log");

                entity.ToTable("giftcards_log");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CardAction)
                    .HasColumnName("card_action")
                    .HasColumnType("varchar(10)");

                entity.Property(e => e.CardAmount)
                    .HasColumnName("card_amount")
                    .HasColumnType("decimal(12,2)");

                entity.Property(e => e.CardBalance)
                    .HasColumnName("card_balance")
                    .HasColumnType("decimal(12,2)");

                entity.Property(e => e.CardCode)
                    .IsRequired()
                    .HasColumnName("card_code")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.CardComment)
                    .HasColumnName("card_comment")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.CardId)
                    .HasColumnName("card_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.CardStatus)
                    .HasColumnName("card_status")
                    .HasColumnType("tinyint(3) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedTime)
                    .HasColumnName("created_time")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.OrderId)
                    .IsRequired()
                    .HasColumnName("order_id")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.User)
                    .HasColumnName("user")
                    .HasColumnType("varchar(10)");

                entity.Property(e => e.UserName)
                    .HasColumnName("user_name")
                    .HasColumnType("varchar(50)");
            });

            modelBuilder.Entity<GiftcardsOrderItems>(entity =>
            {
                entity.ToTable("giftcards_order_items");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Discount)
                    .HasColumnName("discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftcardId)
                    .HasColumnName("giftcard_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.OrderItemId)
                    .HasColumnName("order_item_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.QuoteItemId)
                    .HasColumnName("quote_item_id")
                    .HasColumnType("int(10)");
            });

            modelBuilder.Entity<GiftcardsPregenerated>(entity =>
            {
                entity.HasKey(e => e.CardId)
                    .HasName("PK_giftcards_pregenerated");

                entity.ToTable("giftcards_pregenerated");

                entity.Property(e => e.CardId)
                    .HasColumnName("card_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CardCode)
                    .IsRequired()
                    .HasColumnName("card_code")
                    .HasColumnType("text");

                entity.Property(e => e.CardStatus)
                    .HasColumnName("card_status")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10)");
            });

            modelBuilder.Entity<Giftvoucher>(entity =>
            {
                entity.ToTable("giftvoucher");

                entity.HasIndex(e => e.GiftCode)
                    .HasName("gift_code")
                    .IsUnique();

                entity.HasIndex(e => e.GiftcardTemplateId)
                    .HasName("FK_GIFTVOUCHER_RELATION_TEMPLATE");

                entity.Property(e => e.GiftvoucherId)
                    .HasColumnName("giftvoucher_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.ActionsSerialized)
                    .HasColumnName("actions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.Balance)
                    .HasColumnName("balance")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.ConditionsSerialized)
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.CreatedForm)
                    .HasColumnName("created_form")
                    .HasColumnType("varchar(45)");

                entity.Property(e => e.Currency)
                    .HasColumnName("currency")
                    .HasColumnType("char(3)");

                entity.Property(e => e.CustomerEmail)
                    .IsRequired()
                    .HasColumnName("customer_email")
                    .HasColumnType("varchar(127)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(11) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CustomerName)
                    .IsRequired()
                    .HasColumnName("customer_name")
                    .HasColumnType("varchar(127)");

                entity.Property(e => e.DayStore)
                    .HasColumnName("day_store")
                    .HasColumnType("datetime");

                entity.Property(e => e.DayToSend)
                    .HasColumnName("day_to_send")
                    .HasColumnType("date");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.EmailSender)
                    .HasColumnName("email_sender")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ExpiredAt)
                    .HasColumnName("expired_at")
                    .HasColumnType("datetime");

                entity.Property(e => e.GiftCode)
                    .IsRequired()
                    .HasColumnName("gift_code")
                    .HasColumnType("varchar(127)");

                entity.Property(e => e.GiftcardCustomImage)
                    .HasColumnName("giftcard_custom_image")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GiftcardTemplateId)
                    .HasColumnName("giftcard_template_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.GiftcardTemplateImage)
                    .HasColumnName("giftcard_template_image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.GiftvoucherComments)
                    .HasColumnName("giftvoucher_comments")
                    .HasColumnType("text");

                entity.Property(e => e.IsSent)
                    .HasColumnName("is_sent")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Message)
                    .HasColumnName("message")
                    .HasColumnType("text");

                entity.Property(e => e.NotifySuccess)
                    .HasColumnName("notify_success")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RecipientAddress)
                    .HasColumnName("recipient_address")
                    .HasColumnType("text");

                entity.Property(e => e.RecipientEmail)
                    .IsRequired()
                    .HasColumnName("recipient_email")
                    .HasColumnType("varchar(127)");

                entity.Property(e => e.RecipientName)
                    .IsRequired()
                    .HasColumnName("recipient_name")
                    .HasColumnType("varchar(127)");

                entity.Property(e => e.ShippedToCustomer)
                    .HasColumnName("shipped_to_customer")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(6) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TemplateId)
                    .HasColumnName("template_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.TimezoneToSend)
                    .HasColumnName("timezone_to_send")
                    .HasColumnType("text");

                entity.HasOne(d => d.GiftcardTemplate)
                    .WithMany(p => p.Giftvoucher)
                    .HasForeignKey(d => d.GiftcardTemplateId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_GIFTVOUCHER_RELATION_TEMPLATE");
            });

            modelBuilder.Entity<GiftvoucherCredit>(entity =>
            {
                entity.HasKey(e => e.CreditId)
                    .HasName("PK_giftvoucher_credit");

                entity.ToTable("giftvoucher_credit");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("customer_id");

                entity.Property(e => e.CreditId)
                    .HasColumnName("credit_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Balance)
                    .HasColumnName("balance")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Currency)
                    .HasColumnName("currency")
                    .HasColumnType("varchar(45)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.GiftvoucherCredit)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("giftvoucher_credit_ibfk_1");
            });

            modelBuilder.Entity<GiftvoucherCreditHistory>(entity =>
            {
                entity.HasKey(e => e.HistoryId)
                    .HasName("PK_giftvoucher_credit_history");

                entity.ToTable("giftvoucher_credit_history");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("customer_id");

                entity.Property(e => e.HistoryId)
                    .HasColumnName("history_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Action)
                    .HasColumnName("action")
                    .HasColumnType("varchar(45)");

                entity.Property(e => e.Amount)
                    .HasColumnName("amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BalanceChange)
                    .HasColumnName("balance_change")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseAmount)
                    .HasColumnName("base_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CreatedDate)
                    .HasColumnName("created_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.Currency)
                    .HasColumnName("currency")
                    .HasColumnType("varchar(45)");

                entity.Property(e => e.CurrencyBalance)
                    .HasColumnName("currency_balance")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.GiftcardCode)
                    .IsRequired()
                    .HasColumnName("giftcard_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.OrderNumber)
                    .HasColumnName("order_number")
                    .HasColumnType("varchar(50)");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.GiftvoucherCreditHistory)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("giftvoucher_credit_history_ibfk_1");
            });

            modelBuilder.Entity<GiftvoucherCustomerVoucher>(entity =>
            {
                entity.HasKey(e => e.CustomerVoucherId)
                    .HasName("PK_giftvoucher_customer_voucher");

                entity.ToTable("giftvoucher_customer_voucher");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("customer_id");

                entity.HasIndex(e => e.VoucherId)
                    .HasName("voucher_id");

                entity.Property(e => e.CustomerVoucherId)
                    .HasColumnName("customer_voucher_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddedDate)
                    .HasColumnName("added_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.VoucherId)
                    .HasColumnName("voucher_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.GiftvoucherCustomerVoucher)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("giftvoucher_customer_voucher_ibfk_1");

                entity.HasOne(d => d.Voucher)
                    .WithMany(p => p.GiftvoucherCustomerVoucher)
                    .HasForeignKey(d => d.VoucherId)
                    .HasConstraintName("giftvoucher_customer_voucher_ibfk_2");
            });

            modelBuilder.Entity<GiftvoucherHistory>(entity =>
            {
                entity.HasKey(e => e.HistoryId)
                    .HasName("PK_giftvoucher_history");

                entity.ToTable("giftvoucher_history");

                entity.HasIndex(e => e.GiftvoucherId)
                    .HasName("giftvoucher_id");

                entity.Property(e => e.HistoryId)
                    .HasColumnName("history_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.Action)
                    .HasColumnName("action")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Amount)
                    .HasColumnName("amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Balance)
                    .HasColumnName("balance")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Comments)
                    .HasColumnName("comments")
                    .HasColumnType("text");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("datetime");

                entity.Property(e => e.Currency)
                    .HasColumnName("currency")
                    .HasColumnType("char(3)");

                entity.Property(e => e.CustomerEmail)
                    .HasColumnName("customer_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.ExtraContent)
                    .HasColumnName("extra_content")
                    .HasColumnType("text");

                entity.Property(e => e.GiftvoucherId)
                    .HasColumnName("giftvoucher_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.OrderAmount)
                    .HasColumnName("order_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.OrderIncrementId)
                    .HasColumnName("order_increment_id")
                    .HasColumnType("varchar(127)");

                entity.Property(e => e.OrderItemId)
                    .HasColumnName("order_item_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Giftvoucher)
                    .WithMany(p => p.GiftvoucherHistory)
                    .HasForeignKey(d => d.GiftvoucherId)
                    .HasConstraintName("giftvoucher_history_ibfk_1");
            });

            modelBuilder.Entity<GiftvoucherProduct>(entity =>
            {
                entity.HasKey(e => e.GiftcardProductId)
                    .HasName("PK_giftvoucher_product");

                entity.ToTable("giftvoucher_product");

                entity.Property(e => e.GiftcardProductId)
                    .HasColumnName("giftcard_product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ActionsSerialized)
                    .HasColumnName("actions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.ConditionsSerialized)
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.GiftcardDescription)
                    .HasColumnName("giftcard_description")
                    .HasColumnType("text");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");
            });

            modelBuilder.Entity<GiftvoucherTemplate>(entity =>
            {
                entity.HasKey(e => e.TemplateId)
                    .HasName("PK_giftvoucher_template");

                entity.ToTable("giftvoucher_template");

                entity.Property(e => e.TemplateId)
                    .HasColumnName("template_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Amount)
                    .HasColumnName("amount")
                    .HasColumnType("int(10)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Balance)
                    .HasColumnName("balance")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.ConditionsSerialized)
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.Currency)
                    .HasColumnName("currency")
                    .HasColumnType("varchar(45)");

                entity.Property(e => e.DayToSend)
                    .HasColumnName("day_to_send")
                    .HasColumnType("datetime");

                entity.Property(e => e.ExpiredAt)
                    .HasColumnName("expired_at")
                    .HasColumnType("datetime");

                entity.Property(e => e.GiftcardTemplateId)
                    .HasColumnName("giftcard_template_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.GiftcardTemplateImage)
                    .HasColumnName("giftcard_template_image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsGenerated)
                    .HasColumnName("is_generated")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Pattern)
                    .HasColumnName("pattern")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TemplateName)
                    .HasColumnName("template_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("varchar(45)");
            });

            modelBuilder.Entity<GooglecheckoutNotification>(entity =>
            {
                entity.HasKey(e => e.SerialNumber)
                    .HasName("PK_googlecheckout_notification");

                entity.ToTable("googlecheckout_notification");

                entity.Property(e => e.SerialNumber)
                    .HasColumnName("serial_number")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.StartedAt)
                    .HasColumnName("started_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<ImportexportImportdata>(entity =>
            {
                entity.ToTable("importexport_importdata");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Behavior)
                    .IsRequired()
                    .HasColumnName("behavior")
                    .HasColumnType("varchar(10)")
                    .HasDefaultValueSql("append");

                entity.Property(e => e.Data).HasColumnName("data");

                entity.Property(e => e.Entity)
                    .IsRequired()
                    .HasColumnName("entity")
                    .HasColumnType("varchar(50)");
            });

            modelBuilder.Entity<IndexEvent>(entity =>
            {
                entity.HasKey(e => e.EventId)
                    .HasName("PK_index_event");

                entity.ToTable("index_event");

                entity.HasIndex(e => new { e.Type, e.Entity, e.EntityPk })
                    .HasName("UNQ_INDEX_EVENT_TYPE_ENTITY_ENTITY_PK")
                    .IsUnique();

                entity.Property(e => e.EventId)
                    .HasColumnName("event_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Entity)
                    .IsRequired()
                    .HasColumnName("entity")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.EntityPk)
                    .IsRequired()
                    .HasColumnName("entity_pk")
                    .HasColumnType("bigint(20)");

                entity.Property(e => e.NewData)
                    .HasColumnName("new_data")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.OldData)
                    .HasColumnName("old_data")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasColumnName("type")
                    .HasColumnType("varchar(64)");
            });

            modelBuilder.Entity<IndexProcess>(entity =>
            {
                entity.HasKey(e => e.ProcessId)
                    .HasName("PK_index_process");

                entity.ToTable("index_process");

                entity.HasIndex(e => e.IndexerCode)
                    .HasName("UNQ_INDEX_PROCESS_INDEXER_CODE")
                    .IsUnique();

                entity.Property(e => e.ProcessId)
                    .HasColumnName("process_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.EndedAt)
                    .HasColumnName("ended_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.IndexerCode)
                    .IsRequired()
                    .HasColumnName("indexer_code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Mode)
                    .IsRequired()
                    .HasColumnName("mode")
                    .HasColumnType("varchar(9)")
                    .HasDefaultValueSql("real_time");

                entity.Property(e => e.StartedAt)
                    .HasColumnName("started_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Status)
                    .IsRequired()
                    .HasColumnName("status")
                    .HasColumnType("varchar(15)")
                    .HasDefaultValueSql("pending");
            });

            modelBuilder.Entity<IndexProcessEvent>(entity =>
            {
                entity.HasKey(e => new { e.ProcessId, e.EventId })
                    .HasName("PK_index_process_event");

                entity.ToTable("index_process_event");

                entity.HasIndex(e => e.EventId)
                    .HasName("IDX_INDEX_PROCESS_EVENT_EVENT_ID");

                entity.Property(e => e.ProcessId)
                    .HasColumnName("process_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.EventId)
                    .HasColumnName("event_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.Status)
                    .IsRequired()
                    .HasColumnName("status")
                    .HasColumnType("varchar(7)")
                    .HasDefaultValueSql("new");

                entity.HasOne(d => d.Event)
                    .WithMany(p => p.IndexProcessEvent)
                    .HasForeignKey(d => d.EventId)
                    .HasConstraintName("FK_INDEX_PROCESS_EVENT_EVENT_ID_INDEX_EVENT_EVENT_ID");

                entity.HasOne(d => d.Process)
                    .WithMany(p => p.IndexProcessEvent)
                    .HasForeignKey(d => d.ProcessId)
                    .HasConstraintName("FK_INDEX_PROCESS_EVENT_PROCESS_ID_INDEX_PROCESS_PROCESS_ID");
            });

            modelBuilder.Entity<LogCustomer>(entity =>
            {
                entity.HasKey(e => e.LogId)
                    .HasName("PK_log_customer");

                entity.ToTable("log_customer");

                entity.HasIndex(e => e.VisitorId)
                    .HasName("IDX_LOG_CUSTOMER_VISITOR_ID");

                entity.Property(e => e.LogId)
                    .HasColumnName("log_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LoginAt)
                    .HasColumnName("login_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.LogoutAt)
                    .HasColumnName("logout_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.VisitorId)
                    .HasColumnName("visitor_id")
                    .HasColumnType("bigint(20) unsigned");
            });

            modelBuilder.Entity<LogQuote>(entity =>
            {
                entity.HasKey(e => e.QuoteId)
                    .HasName("PK_log_quote");

                entity.ToTable("log_quote");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.DeletedAt)
                    .HasColumnName("deleted_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.VisitorId)
                    .HasColumnName("visitor_id")
                    .HasColumnType("bigint(20) unsigned");
            });

            modelBuilder.Entity<LogSummary>(entity =>
            {
                entity.HasKey(e => e.SummaryId)
                    .HasName("PK_log_summary");

                entity.ToTable("log_summary");

                entity.Property(e => e.SummaryId)
                    .HasColumnName("summary_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.AddDate)
                    .HasColumnName("add_date")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerCount)
                    .HasColumnName("customer_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TypeId)
                    .HasColumnName("type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.VisitorCount)
                    .HasColumnName("visitor_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<LogSummaryType>(entity =>
            {
                entity.HasKey(e => e.TypeId)
                    .HasName("PK_log_summary_type");

                entity.ToTable("log_summary_type");

                entity.Property(e => e.TypeId)
                    .HasColumnName("type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Period)
                    .HasColumnName("period")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.PeriodType)
                    .IsRequired()
                    .HasColumnName("period_type")
                    .HasColumnType("varchar(6)")
                    .HasDefaultValueSql("MINUTE");

                entity.Property(e => e.TypeCode)
                    .HasColumnName("type_code")
                    .HasColumnType("varchar(64)");
            });

            modelBuilder.Entity<LogUrlInfo>(entity =>
            {
                entity.HasKey(e => e.UrlId)
                    .HasName("PK_log_url_info");

                entity.ToTable("log_url_info");

                entity.Property(e => e.UrlId)
                    .HasColumnName("url_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.Referer)
                    .HasColumnName("referer")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Url)
                    .HasColumnName("url")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<LogVisitor>(entity =>
            {
                entity.HasKey(e => e.VisitorId)
                    .HasName("PK_log_visitor");

                entity.ToTable("log_visitor");

                entity.Property(e => e.VisitorId)
                    .HasColumnName("visitor_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.FirstVisitAt)
                    .HasColumnName("first_visit_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.LastUrlId)
                    .HasColumnName("last_url_id")
                    .HasColumnType("bigint(20) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LastVisitAt)
                    .HasColumnName("last_visit_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.SessionId)
                    .HasColumnName("session_id")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");
            });

            modelBuilder.Entity<LogVisitorInfo>(entity =>
            {
                entity.HasKey(e => e.VisitorId)
                    .HasName("PK_log_visitor_info");

                entity.ToTable("log_visitor_info");

                entity.Property(e => e.VisitorId)
                    .HasColumnName("visitor_id")
                    .HasColumnType("bigint(20) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.HttpAcceptCharset)
                    .HasColumnName("http_accept_charset")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.HttpAcceptLanguage)
                    .HasColumnName("http_accept_language")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.HttpReferer)
                    .HasColumnName("http_referer")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.HttpUserAgent)
                    .HasColumnName("http_user_agent")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RemoteAddr)
                    .HasColumnName("remote_addr")
                    .HasColumnType("varbinary(16)");

                entity.Property(e => e.ServerAddr)
                    .HasColumnName("server_addr")
                    .HasColumnType("varbinary(16)");
            });

            modelBuilder.Entity<LogVisitorOnline>(entity =>
            {
                entity.HasKey(e => e.VisitorId)
                    .HasName("PK_log_visitor_online");

                entity.ToTable("log_visitor_online");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_LOG_VISITOR_ONLINE_CUSTOMER_ID");

                entity.HasIndex(e => e.VisitorType)
                    .HasName("IDX_LOG_VISITOR_ONLINE_VISITOR_TYPE");

                entity.HasIndex(e => new { e.FirstVisitAt, e.LastVisitAt })
                    .HasName("IDX_LOG_VISITOR_ONLINE_FIRST_VISIT_AT_LAST_VISIT_AT");

                entity.Property(e => e.VisitorId)
                    .HasColumnName("visitor_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.FirstVisitAt)
                    .HasColumnName("first_visit_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.LastUrl)
                    .HasColumnName("last_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.LastVisitAt)
                    .HasColumnName("last_visit_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.RemoteAddr)
                    .HasColumnName("remote_addr")
                    .HasColumnType("varbinary(16)");

                entity.Property(e => e.VisitorType)
                    .IsRequired()
                    .HasColumnName("visitor_type")
                    .HasColumnType("varchar(1)");
            });

            modelBuilder.Entity<MFpcCrawlerUrl>(entity =>
            {
                entity.HasKey(e => e.UrlId)
                    .HasName("PK_m_fpc_crawler_url");

                entity.ToTable("m_fpc_crawler_url");

                entity.HasIndex(e => e.Currency)
                    .HasName("currency");

                entity.HasIndex(e => e.MobileGroup)
                    .HasName("mobile_group");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.HasIndex(e => e.Url)
                    .HasName("url");

                entity.Property(e => e.UrlId)
                    .HasColumnName("url_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CacheId)
                    .IsRequired()
                    .HasColumnName("cache_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CheckedAt)
                    .HasColumnName("checked_at")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.Currency)
                    .HasColumnName("currency")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MobileGroup)
                    .HasColumnName("mobile_group")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Rate)
                    .HasColumnName("rate")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortByPageType)
                    .IsRequired()
                    .HasColumnName("sort_by_page_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortByProductAttribute)
                    .HasColumnName("sort_by_product_attribute")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("1000");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.Url)
                    .IsRequired()
                    .HasColumnName("url")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<MFpcCrawlerloggedUrl>(entity =>
            {
                entity.HasKey(e => e.UrlId)
                    .HasName("PK_m_fpc_crawlerlogged_url");

                entity.ToTable("m_fpc_crawlerlogged_url");

                entity.HasIndex(e => e.Currency)
                    .HasName("currency");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("customer_group_id");

                entity.HasIndex(e => e.MobileGroup)
                    .HasName("mobile_group");

                entity.HasIndex(e => e.StoreId)
                    .HasName("store_id");

                entity.HasIndex(e => e.Url)
                    .HasName("urllogged");

                entity.Property(e => e.UrlId)
                    .HasColumnName("url_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CacheId)
                    .IsRequired()
                    .HasColumnName("cache_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CheckedAt)
                    .HasColumnName("checked_at")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.Currency)
                    .HasColumnName("currency")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5)");

                entity.Property(e => e.MobileGroup)
                    .HasColumnName("mobile_group")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Rate)
                    .HasColumnName("rate")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortByPageType)
                    .IsRequired()
                    .HasColumnName("sort_by_page_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortByProductAttribute)
                    .HasColumnName("sort_by_product_attribute")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("1000");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.Url)
                    .IsRequired()
                    .HasColumnName("url")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<MFpcLog>(entity =>
            {
                entity.HasKey(e => e.LogId)
                    .HasName("PK_m_fpc_log");

                entity.ToTable("m_fpc_log");

                entity.HasIndex(e => e.FromCache)
                    .HasName("from_cache");

                entity.HasIndex(e => e.ResponseTime)
                    .HasName("response_time");

                entity.Property(e => e.LogId)
                    .HasColumnName("log_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.FromCache)
                    .HasColumnName("from_cache")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ResponseTime)
                    .HasColumnName("response_time")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");
            });

            modelBuilder.Entity<MFpcLogAggregated>(entity =>
            {
                entity.ToTable("m_fpc_log_aggregated");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.FromCache)
                    .HasColumnName("from_cache")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Hits)
                    .HasColumnName("hits")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Period)
                    .HasColumnName("period")
                    .HasColumnType("date")
                    .HasDefaultValueSql("0000-00-00");

                entity.Property(e => e.ResponseTime)
                    .HasColumnName("response_time")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");
            });

            modelBuilder.Entity<MFpcLogAggregatedDaily>(entity =>
            {
                entity.ToTable("m_fpc_log_aggregated_daily");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.FromCache)
                    .HasColumnName("from_cache")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Hits)
                    .HasColumnName("hits")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Period)
                    .HasColumnName("period")
                    .HasColumnType("date")
                    .HasDefaultValueSql("0000-00-00");

                entity.Property(e => e.ResponseTime)
                    .HasColumnName("response_time")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");
            });

            modelBuilder.Entity<MMstcoreAttachment>(entity =>
            {
                entity.HasKey(e => e.AttachmentId)
                    .HasName("PK_m_mstcore_attachment");

                entity.ToTable("m_mstcore_attachment");

                entity.HasIndex(e => e.Uid)
                    .HasName("uid")
                    .IsUnique();

                entity.Property(e => e.AttachmentId)
                    .HasColumnName("attachment_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Body).HasColumnName("body");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.EntityType)
                    .IsRequired()
                    .HasColumnName("entity_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Size)
                    .HasColumnName("size")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasColumnName("type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Uid)
                    .IsRequired()
                    .HasColumnName("uid")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<MMstcoreLogger>(entity =>
            {
                entity.HasKey(e => e.LogId)
                    .HasName("PK_m_mstcore_logger");

                entity.ToTable("m_mstcore_logger");

                entity.Property(e => e.LogId)
                    .HasColumnName("log_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Class)
                    .IsRequired()
                    .HasColumnName("class")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Content)
                    .IsRequired()
                    .HasColumnName("content")
                    .HasColumnType("text");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("datetime")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.Level)
                    .HasColumnName("level")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Message)
                    .IsRequired()
                    .HasColumnName("message")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Module)
                    .IsRequired()
                    .HasColumnName("module")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Trace)
                    .IsRequired()
                    .HasColumnName("trace")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<MMstcoreUrlrewrite>(entity =>
            {
                entity.HasKey(e => e.UrlrewriteId)
                    .HasName("PK_m_mstcore_urlrewrite");

                entity.ToTable("m_mstcore_urlrewrite");

                entity.HasIndex(e => new { e.UrlKey, e.Module })
                    .HasName("mstcore_urlrewrite_index2")
                    .IsUnique();

                entity.HasIndex(e => new { e.Module, e.Type, e.EntityId })
                    .HasName("mstcore_urlrewrite_index1")
                    .IsUnique();

                entity.Property(e => e.UrlrewriteId)
                    .HasColumnName("urlrewrite_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.EntityId)
                    .IsRequired()
                    .HasColumnName("entity_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Module)
                    .IsRequired()
                    .HasColumnName("module")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasColumnName("type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UrlKey)
                    .IsRequired()
                    .HasColumnName("url_key")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<MRmaComment>(entity =>
            {
                entity.HasKey(e => e.CommentId)
                    .HasName("PK_m_rma_comment");

                entity.ToTable("m_rma_comment");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("fk_rma_comment_customer_id");

                entity.HasIndex(e => e.RmaId)
                    .HasName("fk_rma_comment_rma_id");

                entity.HasIndex(e => e.StatusId)
                    .HasName("fk_rma_comment_status_id");

                entity.HasIndex(e => e.UserId)
                    .HasName("fk_rma_comment_user_id");

                entity.Property(e => e.CommentId)
                    .HasColumnName("comment_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerName)
                    .IsRequired()
                    .HasColumnName("customer_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EmailId)
                    .HasColumnName("email_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsCustomerNotified)
                    .HasColumnName("is_customer_notified")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsHtml)
                    .HasColumnName("is_html")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRead)
                    .HasColumnName("is_read")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsVisibleInFrontend)
                    .HasColumnName("is_visible_in_frontend")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RmaId)
                    .HasColumnName("rma_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StatusId)
                    .HasColumnName("status_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Text)
                    .HasColumnName("text")
                    .HasColumnType("text");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.MRmaComment)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_4c6f91e9e296b0641c1881e543f3cf09");

                entity.HasOne(d => d.Rma)
                    .WithMany(p => p.MRmaComment)
                    .HasForeignKey(d => d.RmaId)
                    .HasConstraintName("mst_e53ea47d9d7ec6e779ba0de3ff8b78b2");

                entity.HasOne(d => d.Status)
                    .WithMany(p => p.MRmaComment)
                    .HasForeignKey(d => d.StatusId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_faa0dc357796a205d32cce27234442fd");

                entity.HasOne(d => d.User)
                    .WithMany(p => p.MRmaComment)
                    .HasForeignKey(d => d.UserId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_5958c13ea82bb0cab3612e12eaab94db");
            });

            modelBuilder.Entity<MRmaCondition>(entity =>
            {
                entity.HasKey(e => e.ConditionId)
                    .HasName("PK_m_rma_condition");

                entity.ToTable("m_rma_condition");

                entity.Property(e => e.ConditionId)
                    .HasColumnName("condition_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<MRmaFedexLabel>(entity =>
            {
                entity.HasKey(e => e.LabelId)
                    .HasName("PK_m_rma_fedex_label");

                entity.ToTable("m_rma_fedex_label");

                entity.HasIndex(e => e.RmaId)
                    .HasName("fk_rma_fedex_label_rma_id");

                entity.Property(e => e.LabelId)
                    .HasColumnName("label_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.LabelBody)
                    .HasColumnName("label_body")
                    .HasColumnType("blob");

                entity.Property(e => e.LabelDate)
                    .HasColumnName("label_date")
                    .HasColumnType("timestamp");

                entity.Property(e => e.PackageNumber)
                    .HasColumnName("package_number")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RmaId)
                    .HasColumnName("rma_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.TrackNumber)
                    .IsRequired()
                    .HasColumnName("track_number")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Rma)
                    .WithMany(p => p.MRmaFedexLabel)
                    .HasForeignKey(d => d.RmaId)
                    .HasConstraintName("mst_be47b58261860e56a17c37c31fe492e4");
            });

            modelBuilder.Entity<MRmaField>(entity =>
            {
                entity.HasKey(e => e.FieldId)
                    .HasName("PK_m_rma_field");

                entity.ToTable("m_rma_field");

                entity.Property(e => e.FieldId)
                    .HasColumnName("field_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsEditableCustomer)
                    .HasColumnName("is_editable_customer")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRequiredCustomer)
                    .HasColumnName("is_required_customer")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRequiredStaff)
                    .HasColumnName("is_required_staff")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsShowInConfirmShipping)
                    .HasColumnName("is_show_in_confirm_shipping")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsVisibleCustomer)
                    .HasColumnName("is_visible_customer")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasColumnName("type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Values)
                    .HasColumnName("values")
                    .HasColumnType("text");

                entity.Property(e => e.VisibleCustomerStatus)
                    .IsRequired()
                    .HasColumnName("visible_customer_status")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<MRmaItem>(entity =>
            {
                entity.HasKey(e => e.ItemId)
                    .HasName("PK_m_rma_item");

                entity.ToTable("m_rma_item");

                entity.HasIndex(e => e.ConditionId)
                    .HasName("fk_rma_item_condition_id");

                entity.HasIndex(e => e.OrderId)
                    .HasName("fk_rma_rma_order_id");

                entity.HasIndex(e => e.ReasonId)
                    .HasName("fk_rma_item_reason_id");

                entity.HasIndex(e => e.ResolutionId)
                    .HasName("fk_rma_item_resolution_id");

                entity.HasIndex(e => e.RmaId)
                    .HasName("fk_rma_item_rma_id");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ConditionId)
                    .HasColumnName("condition_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.IsRemoved)
                    .HasColumnName("is_removed")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflineOrderName)
                    .HasColumnName("offline_order_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.OrderItemId)
                    .HasColumnName("order_item_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ProductOptions)
                    .HasColumnName("product_options")
                    .HasColumnType("text");

                entity.Property(e => e.QtyRequested)
                    .HasColumnName("qty_requested")
                    .HasColumnType("int(11)");

                entity.Property(e => e.QtyReturned)
                    .HasColumnName("qty_returned")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ReasonId)
                    .HasColumnName("reason_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ResolutionId)
                    .HasColumnName("resolution_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RmaId)
                    .HasColumnName("rma_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ToStock)
                    .HasColumnName("to_stock")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Condition)
                    .WithMany(p => p.MRmaItem)
                    .HasForeignKey(d => d.ConditionId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_9c5f65d4b052b10b78d1fac88f9d101d");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.MRmaItem)
                    .HasForeignKey(d => d.OrderId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("mst_69eaead6204d31508d9b7cddf50050ea");

                entity.HasOne(d => d.Reason)
                    .WithMany(p => p.MRmaItem)
                    .HasForeignKey(d => d.ReasonId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_aa079f3184daab6fc043a86191a7dc18");

                entity.HasOne(d => d.Resolution)
                    .WithMany(p => p.MRmaItem)
                    .HasForeignKey(d => d.ResolutionId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_fa11b611a0646649046b3f7ad2a7d094");

                entity.HasOne(d => d.Rma)
                    .WithMany(p => p.MRmaItem)
                    .HasForeignKey(d => d.RmaId)
                    .HasConstraintName("mst_de6add712108ad78167f577b6c45e61f");
            });

            modelBuilder.Entity<MRmaOfflineItem>(entity =>
            {
                entity.HasKey(e => e.OfflineItemId)
                    .HasName("PK_m_rma_offline_item");

                entity.ToTable("m_rma_offline_item");

                entity.HasIndex(e => e.ConditionId)
                    .HasName("fk_rma_offline_item_condition_id");

                entity.HasIndex(e => e.OfflineOrderId)
                    .HasName("fk_rma_offline_order_id");

                entity.HasIndex(e => e.ReasonId)
                    .HasName("fk_rma_offline_item_reason_id");

                entity.HasIndex(e => e.ResolutionId)
                    .HasName("fk_rma_offline_item_resolution_id");

                entity.HasIndex(e => e.RmaId)
                    .HasName("fk_rma_offline_item_rma_id");

                entity.Property(e => e.OfflineItemId)
                    .HasColumnName("offline_item_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ConditionId)
                    .HasColumnName("condition_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflineOrderId)
                    .HasColumnName("offline_order_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.QtyRequested)
                    .HasColumnName("qty_requested")
                    .HasColumnType("int(11)");

                entity.Property(e => e.QtyReturned)
                    .HasColumnName("qty_returned")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ReasonId)
                    .HasColumnName("reason_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ResolutionId)
                    .HasColumnName("resolution_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RmaId)
                    .HasColumnName("rma_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Condition)
                    .WithMany(p => p.MRmaOfflineItem)
                    .HasForeignKey(d => d.ConditionId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_rma_offline_item_condition_id");

                entity.HasOne(d => d.OfflineOrder)
                    .WithMany(p => p.MRmaOfflineItem)
                    .HasForeignKey(d => d.OfflineOrderId)
                    .HasConstraintName("mst_rma_offline_order_id");

                entity.HasOne(d => d.Reason)
                    .WithMany(p => p.MRmaOfflineItem)
                    .HasForeignKey(d => d.ReasonId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_rma_offline_item_reason_id");

                entity.HasOne(d => d.Resolution)
                    .WithMany(p => p.MRmaOfflineItem)
                    .HasForeignKey(d => d.ResolutionId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_rma_offline_item_resolution_id");

                entity.HasOne(d => d.Rma)
                    .WithMany(p => p.MRmaOfflineItem)
                    .HasForeignKey(d => d.RmaId)
                    .HasConstraintName("mst_rma_offline_item_rma_id");
            });

            modelBuilder.Entity<MRmaOfflineOrder>(entity =>
            {
                entity.HasKey(e => e.OfflineOrderId)
                    .HasName("PK_m_rma_offline_order");

                entity.ToTable("m_rma_offline_order");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("fk_rma_offline_order_customer_id");

                entity.Property(e => e.OfflineOrderId)
                    .HasColumnName("offline_order_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ReceiptNumber)
                    .IsRequired()
                    .HasColumnName("receipt_number")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.MRmaOfflineOrder)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_rma_offline_order_customer_id");
            });

            modelBuilder.Entity<MRmaReason>(entity =>
            {
                entity.HasKey(e => e.ReasonId)
                    .HasName("PK_m_rma_reason");

                entity.ToTable("m_rma_reason");

                entity.Property(e => e.ReasonId)
                    .HasColumnName("reason_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<MRmaResolution>(entity =>
            {
                entity.HasKey(e => e.ResolutionId)
                    .HasName("PK_m_rma_resolution");

                entity.ToTable("m_rma_resolution");

                entity.Property(e => e.ResolutionId)
                    .HasColumnName("resolution_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<MRmaRma>(entity =>
            {
                entity.HasKey(e => e.RmaId)
                    .HasName("PK_m_rma_rma");

                entity.ToTable("m_rma_rma");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("fk_rma_rma_customer_id");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("increment_id")
                    .IsUnique();

                entity.HasIndex(e => e.OrderId)
                    .HasName("fk_rma_rma_order_id");

                entity.HasIndex(e => e.StatusId)
                    .HasName("fk_rma_rma_status_id");

                entity.HasIndex(e => e.StoreId)
                    .HasName("fk_rma_rma_store_id");

                entity.Property(e => e.RmaId)
                    .HasColumnName("rma_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.City)
                    .IsRequired()
                    .HasColumnName("city")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Company)
                    .IsRequired()
                    .HasColumnName("company")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CountryId)
                    .IsRequired()
                    .HasColumnName("country_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.CreditMemoId)
                    .HasColumnName("credit_memo_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Email)
                    .IsRequired()
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ExchangeOrderId)
                    .HasColumnName("exchange_order_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Firstname)
                    .IsRequired()
                    .HasColumnName("firstname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.GuestId)
                    .IsRequired()
                    .HasColumnName("guest_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsAdminRead)
                    .HasColumnName("is_admin_read")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsArchived)
                    .HasColumnName("is_archived")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsGift)
                    .HasColumnName("is_gift")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsResolved)
                    .HasColumnName("is_resolved")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LastReplyAt)
                    .HasColumnName("last_reply_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.LastReplyName)
                    .IsRequired()
                    .HasColumnName("last_reply_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Lastname)
                    .IsRequired()
                    .HasColumnName("lastname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OfflineAddress)
                    .HasColumnName("offline_address")
                    .HasColumnType("varchar(512)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Postcode)
                    .IsRequired()
                    .HasColumnName("postcode")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Region)
                    .IsRequired()
                    .HasColumnName("region")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RegionId)
                    .HasColumnName("region_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StatusId)
                    .HasColumnName("status_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Street)
                    .IsRequired()
                    .HasColumnName("street")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Telephone)
                    .IsRequired()
                    .HasColumnName("telephone")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TicketId)
                    .HasColumnName("ticket_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.TrackingCode)
                    .IsRequired()
                    .HasColumnName("tracking_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.MRmaRma)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_69a8b395f24a094533cf153e8e7858f8");

                entity.HasOne(d => d.Status)
                    .WithMany(p => p.MRmaRma)
                    .HasForeignKey(d => d.StatusId)
                    .HasConstraintName("mst_c06ac63c728d57ffa50c0764ad0b9668");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.MRmaRma)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("mst_dc1a175a9f3b92e40f0fc89072824bb7");
            });

            modelBuilder.Entity<MRmaRmaCreditmemo>(entity =>
            {
                entity.HasKey(e => e.RmaCreditmemoId)
                    .HasName("PK_m_rma_rma_creditmemo");

                entity.ToTable("m_rma_rma_creditmemo");

                entity.HasIndex(e => e.RcRmaId)
                    .HasName("fk_rma_rma_creditmemo_rma_id");

                entity.Property(e => e.RmaCreditmemoId)
                    .HasColumnName("rma_creditmemo_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RcCreditMemoId)
                    .HasColumnName("rc_credit_memo_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RcRmaId)
                    .HasColumnName("rc_rma_id")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.RcRma)
                    .WithMany(p => p.MRmaRmaCreditmemo)
                    .HasForeignKey(d => d.RcRmaId)
                    .HasConstraintName("mst_c05dff0fd72e8951b8521815dbdd8564");
            });

            modelBuilder.Entity<MRmaRmaOrder>(entity =>
            {
                entity.HasKey(e => e.RmaOrderId)
                    .HasName("PK_m_rma_rma_order");

                entity.ToTable("m_rma_rma_order");

                entity.HasIndex(e => e.ReRmaId)
                    .HasName("fk_rma_rma_order_rma_id");

                entity.Property(e => e.RmaOrderId)
                    .HasColumnName("rma_order_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ReExchangeOrderId)
                    .HasColumnName("re_exchange_order_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ReRmaId)
                    .HasColumnName("re_rma_id")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.ReRma)
                    .WithMany(p => p.MRmaRmaOrder)
                    .HasForeignKey(d => d.ReRmaId)
                    .HasConstraintName("mst_0634dda093533cb5972030cadeb3a4ca");
            });

            modelBuilder.Entity<MRmaRmaStore>(entity =>
            {
                entity.HasKey(e => e.RmaStoreId)
                    .HasName("PK_m_rma_rma_store");

                entity.ToTable("m_rma_rma_store");

                entity.HasIndex(e => e.RsRmaId)
                    .HasName("fk_rma_rma_store_rma_id");

                entity.HasIndex(e => e.RsStoreId)
                    .HasName("fk_rma_rma_store_store_id");

                entity.Property(e => e.RmaStoreId)
                    .HasColumnName("rma_store_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RsRmaId)
                    .HasColumnName("rs_rma_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RsStoreId)
                    .HasColumnName("rs_store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.RsRma)
                    .WithMany(p => p.MRmaRmaStore)
                    .HasForeignKey(d => d.RsRmaId)
                    .HasConstraintName("mst_a4d8c322882c1c00f6a47d496c2d2b53");

                entity.HasOne(d => d.RsStore)
                    .WithMany(p => p.MRmaRmaStore)
                    .HasForeignKey(d => d.RsStoreId)
                    .HasConstraintName("mst_ab18e99ea1f412d02e4affdacfbb3cf7");
            });

            modelBuilder.Entity<MRmaRule>(entity =>
            {
                entity.HasKey(e => e.RuleId)
                    .HasName("PK_m_rma_rule");

                entity.ToTable("m_rma_rule");

                entity.HasIndex(e => e.StatusId)
                    .HasName("fk_rma_rule_status_id");

                entity.HasIndex(e => e.UserId)
                    .HasName("fk_rma_rule_user_id");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ConditionsSerialized)
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("text");

                entity.Property(e => e.EmailBody)
                    .HasColumnName("email_body")
                    .HasColumnType("text");

                entity.Property(e => e.EmailSubject)
                    .IsRequired()
                    .HasColumnName("email_subject")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Event)
                    .IsRequired()
                    .HasColumnName("event")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsArchived)
                    .HasColumnName("is_archived")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsResolved)
                    .HasColumnName("is_resolved")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsSendAttachment)
                    .HasColumnName("is_send_attachment")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsSendCustomer)
                    .HasColumnName("is_send_customer")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsSendDepartment)
                    .HasColumnName("is_send_department")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsSendOwner)
                    .HasColumnName("is_send_owner")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsStopProcessing)
                    .HasColumnName("is_stop_processing")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OtherEmail)
                    .IsRequired()
                    .HasColumnName("other_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StatusId)
                    .HasColumnName("status_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Status)
                    .WithMany(p => p.MRmaRule)
                    .HasForeignKey(d => d.StatusId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_9e6ac3ae5bab043d53a4940b65683295");

                entity.HasOne(d => d.User)
                    .WithMany(p => p.MRmaRule)
                    .HasForeignKey(d => d.UserId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("mst_bff2a325ea2c3b6d8b1565bfe5252d06");
            });

            modelBuilder.Entity<MRmaStatus>(entity =>
            {
                entity.HasKey(e => e.StatusId)
                    .HasName("PK_m_rma_status");

                entity.ToTable("m_rma_status");

                entity.Property(e => e.StatusId)
                    .HasColumnName("status_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.AdminMessage)
                    .HasColumnName("admin_message")
                    .HasColumnType("text");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerMessage)
                    .HasColumnName("customer_message")
                    .HasColumnType("text");

                entity.Property(e => e.HistoryMessage)
                    .HasColumnName("history_message")
                    .HasColumnType("text");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRmaResolved)
                    .HasColumnName("is_rma_resolved")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("smallint(5)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<MRmaTemplate>(entity =>
            {
                entity.HasKey(e => e.TemplateId)
                    .HasName("PK_m_rma_template");

                entity.ToTable("m_rma_template");

                entity.Property(e => e.TemplateId)
                    .HasColumnName("template_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Template)
                    .HasColumnName("template")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<MRmaTemplateStore>(entity =>
            {
                entity.HasKey(e => e.TemplateStoreId)
                    .HasName("PK_m_rma_template_store");

                entity.ToTable("m_rma_template_store");

                entity.HasIndex(e => e.TsStoreId)
                    .HasName("fk_rma_template_store_store_id");

                entity.HasIndex(e => e.TsTemplateId)
                    .HasName("fk_rma_template_store_template_id");

                entity.Property(e => e.TemplateStoreId)
                    .HasColumnName("template_store_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.TsStoreId)
                    .HasColumnName("ts_store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TsTemplateId)
                    .HasColumnName("ts_template_id")
                    .HasColumnType("int(11)");

                entity.HasOne(d => d.TsStore)
                    .WithMany(p => p.MRmaTemplateStore)
                    .HasForeignKey(d => d.TsStoreId)
                    .HasConstraintName("mst_bd84e1780b43c1b6319f0a070c383add");

                entity.HasOne(d => d.TsTemplate)
                    .WithMany(p => p.MRmaTemplateStore)
                    .HasForeignKey(d => d.TsTemplateId)
                    .HasConstraintName("mst_9fffbac352a78f98b60c7abaa9b0c1cd");
            });

            modelBuilder.Entity<Magenotification>(entity =>
            {
                entity.ToTable("magenotification");

                entity.Property(e => e.MagenotificationId)
                    .HasColumnName("magenotification_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.AddedDate)
                    .HasColumnName("added_date")
                    .HasColumnType("datetime");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.IsRead)
                    .HasColumnName("is_read")
                    .HasColumnType("tinyint(4)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsRemove)
                    .HasColumnName("is_remove")
                    .HasColumnType("tinyint(4)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RelatedExtensions)
                    .HasColumnName("related_extensions")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Severity)
                    .HasColumnName("severity")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .IsRequired()
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Url)
                    .IsRequired()
                    .HasColumnName("url")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<MagenotificationExtensionFeedback>(entity =>
            {
                entity.HasKey(e => e.FeedbackId)
                    .HasName("PK_magenotification_extension_feedback");

                entity.ToTable("magenotification_extension_feedback");

                entity.Property(e => e.FeedbackId)
                    .HasColumnName("feedback_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Comment)
                    .IsRequired()
                    .HasColumnName("comment")
                    .HasColumnType("text");

                entity.Property(e => e.Content)
                    .IsRequired()
                    .HasColumnName("content")
                    .HasColumnType("text");

                entity.Property(e => e.CouponCode)
                    .IsRequired()
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CouponValue)
                    .IsRequired()
                    .HasColumnName("coupon_value")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.Created)
                    .HasColumnName("created")
                    .HasColumnType("datetime");

                entity.Property(e => e.ExpiredCounpon)
                    .HasColumnName("expired_counpon")
                    .HasColumnType("datetime");

                entity.Property(e => e.Extension)
                    .IsRequired()
                    .HasColumnName("extension")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ExtensionVersion)
                    .IsRequired()
                    .HasColumnName("extension_version")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.File)
                    .IsRequired()
                    .HasColumnName("file")
                    .HasColumnType("text");

                entity.Property(e => e.IsSent)
                    .HasColumnName("is_sent")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("2");

                entity.Property(e => e.LatestMessage)
                    .IsRequired()
                    .HasColumnName("latest_message")
                    .HasColumnType("text");

                entity.Property(e => e.LatestResponse)
                    .IsRequired()
                    .HasColumnName("latest_response")
                    .HasColumnType("text");

                entity.Property(e => e.LatestResponseTime)
                    .HasColumnName("latest_response_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("3");

                entity.Property(e => e.Updated)
                    .HasColumnName("updated")
                    .HasColumnType("datetime");
            });

            modelBuilder.Entity<MagenotificationExtensionFeedbackmessage>(entity =>
            {
                entity.HasKey(e => e.FeedbackmessageId)
                    .HasName("PK_magenotification_extension_feedbackmessage");

                entity.ToTable("magenotification_extension_feedbackmessage");

                entity.Property(e => e.FeedbackmessageId)
                    .HasColumnName("feedbackmessage_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.FeedbackCode)
                    .IsRequired()
                    .HasColumnName("feedback_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FeedbackId)
                    .HasColumnName("feedback_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.File)
                    .IsRequired()
                    .HasColumnName("file")
                    .HasColumnType("text");

                entity.Property(e => e.IsCustomer)
                    .HasColumnName("is_customer")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("2");

                entity.Property(e => e.IsSent)
                    .HasColumnName("is_sent")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("2");

                entity.Property(e => e.Message)
                    .IsRequired()
                    .HasColumnName("message")
                    .HasColumnType("text");

                entity.Property(e => e.PostedTime)
                    .HasColumnName("posted_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.User)
                    .IsRequired()
                    .HasColumnName("user")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<MagenotificationLicense>(entity =>
            {
                entity.HasKey(e => e.LicenseId)
                    .HasName("PK_magenotification_license");

                entity.ToTable("magenotification_license");

                entity.Property(e => e.LicenseId)
                    .HasColumnName("license_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.ActiveAt)
                    .HasColumnName("active_at")
                    .HasColumnType("date");

                entity.Property(e => e.Domains)
                    .HasColumnName("domains")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ExtensionCode)
                    .IsRequired()
                    .HasColumnName("extension_code")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.IsValid)
                    .HasColumnName("is_valid")
                    .HasColumnType("tinyint(1)");

                entity.Property(e => e.LicenseKey)
                    .IsRequired()
                    .HasColumnName("license_key")
                    .HasColumnType("text");

                entity.Property(e => e.ResponseCode)
                    .HasColumnName("response_code")
                    .HasColumnType("smallint(5)");

                entity.Property(e => e.SumCode)
                    .HasColumnName("sum_code")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<MagenotificationLog>(entity =>
            {
                entity.HasKey(e => e.LogId)
                    .HasName("PK_magenotification_log");

                entity.ToTable("magenotification_log");

                entity.Property(e => e.LogId)
                    .HasColumnName("log_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.CheckDate)
                    .HasColumnName("check_date")
                    .HasColumnType("date");

                entity.Property(e => e.ExpiredTime)
                    .HasColumnName("expired_time")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ExtensionCode)
                    .IsRequired()
                    .HasColumnName("extension_code")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.IsValid)
                    .HasColumnName("is_valid")
                    .HasColumnType("tinyint(1)");

                entity.Property(e => e.LicenseKey)
                    .IsRequired()
                    .HasColumnName("license_key")
                    .HasColumnType("text");

                entity.Property(e => e.LicenseType)
                    .IsRequired()
                    .HasColumnName("license_type")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.ResponseCode)
                    .HasColumnName("response_code")
                    .HasColumnType("smallint(5)");

                entity.Property(e => e.SumCode)
                    .HasColumnName("sum_code")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<MailchimpErrors>(entity =>
            {
                entity.ToTable("mailchimp_errors");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BatchId)
                    .IsRequired()
                    .HasColumnName("batch_id")
                    .HasColumnType("varchar(64)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Errors)
                    .HasColumnName("errors")
                    .HasColumnType("text");

                entity.Property(e => e.OriginalId)
                    .HasColumnName("original_id")
                    .HasColumnType("int(10)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Regtype)
                    .HasColumnName("regtype")
                    .HasColumnType("char(3)");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("int(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(128)");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("varchar(256)");
            });

            modelBuilder.Entity<MailchimpSyncBatches>(entity =>
            {
                entity.ToTable("mailchimp_sync_batches");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BatchId)
                    .IsRequired()
                    .HasColumnName("batch_id")
                    .HasColumnType("varchar(24)");

                entity.Property(e => e.Status)
                    .IsRequired()
                    .HasColumnName("status")
                    .HasColumnType("varchar(10)");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("varchar(50)");
            });

            modelBuilder.Entity<Mksstorelocator>(entity =>
            {
                entity.ToTable("mksstorelocator");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Address)
                    .HasColumnName("address")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.City)
                    .HasColumnName("city")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.CountryId)
                    .HasColumnName("country_id")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Email)
                    .HasColumnName("email")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Fax)
                    .HasColumnName("fax")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Image)
                    .HasColumnName("image")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Lat)
                    .HasColumnName("lat")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Longt)
                    .HasColumnName("longt")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Phone)
                    .HasColumnName("phone")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Radius)
                    .HasColumnName("radius")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.StoreUrl)
                    .HasColumnName("store_url")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Tradinghours)
                    .HasColumnName("tradinghours")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.Zipcode)
                    .HasColumnName("zipcode")
                    .HasColumnType("varchar(100)");
            });

            modelBuilder.Entity<NewsletterProblem>(entity =>
            {
                entity.HasKey(e => e.ProblemId)
                    .HasName("PK_newsletter_problem");

                entity.ToTable("newsletter_problem");

                entity.HasIndex(e => e.QueueId)
                    .HasName("IDX_NEWSLETTER_PROBLEM_QUEUE_ID");

                entity.HasIndex(e => e.SubscriberId)
                    .HasName("IDX_NEWSLETTER_PROBLEM_SUBSCRIBER_ID");

                entity.Property(e => e.ProblemId)
                    .HasColumnName("problem_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProblemErrorCode)
                    .HasColumnName("problem_error_code")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProblemErrorText)
                    .HasColumnName("problem_error_text")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.QueueId)
                    .HasColumnName("queue_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SubscriberId)
                    .HasColumnName("subscriber_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Queue)
                    .WithMany(p => p.NewsletterProblem)
                    .HasForeignKey(d => d.QueueId)
                    .HasConstraintName("FK_NEWSLETTER_PROBLEM_QUEUE_ID_NEWSLETTER_QUEUE_QUEUE_ID");

                entity.HasOne(d => d.Subscriber)
                    .WithMany(p => p.NewsletterProblem)
                    .HasForeignKey(d => d.SubscriberId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_NLTTR_PROBLEM_SUBSCRIBER_ID_NLTTR_SUBSCRIBER_SUBSCRIBER_ID");
            });

            modelBuilder.Entity<NewsletterQueue>(entity =>
            {
                entity.HasKey(e => e.QueueId)
                    .HasName("PK_newsletter_queue");

                entity.ToTable("newsletter_queue");

                entity.HasIndex(e => e.TemplateId)
                    .HasName("IDX_NEWSLETTER_QUEUE_TEMPLATE_ID");

                entity.Property(e => e.QueueId)
                    .HasColumnName("queue_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.NewsletterSenderEmail)
                    .HasColumnName("newsletter_sender_email")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.NewsletterSenderName)
                    .HasColumnName("newsletter_sender_name")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.NewsletterStyles)
                    .HasColumnName("newsletter_styles")
                    .HasColumnType("text");

                entity.Property(e => e.NewsletterSubject)
                    .HasColumnName("newsletter_subject")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.NewsletterText)
                    .HasColumnName("newsletter_text")
                    .HasColumnType("text");

                entity.Property(e => e.NewsletterType)
                    .HasColumnName("newsletter_type")
                    .HasColumnType("int(11)");

                entity.Property(e => e.QueueFinishAt)
                    .HasColumnName("queue_finish_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.QueueStartAt)
                    .HasColumnName("queue_start_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.QueueStatus)
                    .HasColumnName("queue_status")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TemplateId)
                    .HasColumnName("template_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Template)
                    .WithMany(p => p.NewsletterQueue)
                    .HasForeignKey(d => d.TemplateId)
                    .HasConstraintName("FK_NEWSLETTER_QUEUE_TEMPLATE_ID_NEWSLETTER_TEMPLATE_TEMPLATE_ID");
            });

            modelBuilder.Entity<NewsletterQueueLink>(entity =>
            {
                entity.HasKey(e => e.QueueLinkId)
                    .HasName("PK_newsletter_queue_link");

                entity.ToTable("newsletter_queue_link");

                entity.HasIndex(e => e.QueueId)
                    .HasName("IDX_NEWSLETTER_QUEUE_LINK_QUEUE_ID");

                entity.HasIndex(e => e.SubscriberId)
                    .HasName("IDX_NEWSLETTER_QUEUE_LINK_SUBSCRIBER_ID");

                entity.HasIndex(e => new { e.QueueId, e.LetterSentAt })
                    .HasName("IDX_NEWSLETTER_QUEUE_LINK_QUEUE_ID_LETTER_SENT_AT");

                entity.Property(e => e.QueueLinkId)
                    .HasColumnName("queue_link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.LetterSentAt)
                    .HasColumnName("letter_sent_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.QueueId)
                    .HasColumnName("queue_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SubscriberId)
                    .HasColumnName("subscriber_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Queue)
                    .WithMany(p => p.NewsletterQueueLink)
                    .HasForeignKey(d => d.QueueId)
                    .HasConstraintName("FK_NEWSLETTER_QUEUE_LINK_QUEUE_ID_NEWSLETTER_QUEUE_QUEUE_ID");

                entity.HasOne(d => d.Subscriber)
                    .WithMany(p => p.NewsletterQueueLink)
                    .HasForeignKey(d => d.SubscriberId)
                    .HasConstraintName("FK_NLTTR_QUEUE_LNK_SUBSCRIBER_ID_NLTTR_SUBSCRIBER_SUBSCRIBER_ID");
            });

            modelBuilder.Entity<NewsletterQueueStoreLink>(entity =>
            {
                entity.HasKey(e => new { e.QueueId, e.StoreId })
                    .HasName("PK_newsletter_queue_store_link");

                entity.ToTable("newsletter_queue_store_link");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_NEWSLETTER_QUEUE_STORE_LINK_STORE_ID");

                entity.Property(e => e.QueueId)
                    .HasColumnName("queue_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Queue)
                    .WithMany(p => p.NewsletterQueueStoreLink)
                    .HasForeignKey(d => d.QueueId)
                    .HasConstraintName("FK_NLTTR_QUEUE_STORE_LNK_QUEUE_ID_NLTTR_QUEUE_QUEUE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.NewsletterQueueStoreLink)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_NEWSLETTER_QUEUE_STORE_LINK_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<NewsletterSubscriber>(entity =>
            {
                entity.HasKey(e => e.SubscriberId)
                    .HasName("PK_newsletter_subscriber");

                entity.ToTable("newsletter_subscriber");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_NEWSLETTER_SUBSCRIBER_CUSTOMER_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_NEWSLETTER_SUBSCRIBER_STORE_ID");

                entity.Property(e => e.SubscriberId)
                    .HasColumnName("subscriber_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ChangeStatusAt)
                    .HasColumnName("change_status_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MailchimpSyncDelta)
                    .HasColumnName("mailchimp_sync_delta")
                    .HasColumnType("datetime");

                entity.Property(e => e.MailchimpSyncError)
                    .IsRequired()
                    .HasColumnName("mailchimp_sync_error")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SubscriberConfirmCode)
                    .HasColumnName("subscriber_confirm_code")
                    .HasColumnType("varchar(32)")
                    .HasDefaultValueSql("NULL");

                entity.Property(e => e.SubscriberEmail)
                    .HasColumnName("subscriber_email")
                    .HasColumnType("varchar(150)");

                entity.Property(e => e.SubscriberFirstname)
                    .HasColumnName("subscriber_firstname")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.SubscriberLastname)
                    .HasColumnName("subscriber_lastname")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.SubscriberStatus)
                    .HasColumnName("subscriber_status")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.NewsletterSubscriber)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_NEWSLETTER_SUBSCRIBER_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<NewsletterTemplate>(entity =>
            {
                entity.HasKey(e => e.TemplateId)
                    .HasName("PK_newsletter_template");

                entity.ToTable("newsletter_template");

                entity.HasIndex(e => e.AddedAt)
                    .HasName("IDX_NEWSLETTER_TEMPLATE_ADDED_AT");

                entity.HasIndex(e => e.ModifiedAt)
                    .HasName("IDX_NEWSLETTER_TEMPLATE_MODIFIED_AT");

                entity.HasIndex(e => e.TemplateActual)
                    .HasName("IDX_NEWSLETTER_TEMPLATE_TEMPLATE_ACTUAL");

                entity.Property(e => e.TemplateId)
                    .HasColumnName("template_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddedAt)
                    .HasColumnName("added_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ModifiedAt)
                    .HasColumnName("modified_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.TemplateActual)
                    .HasColumnName("template_actual")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.TemplateCode)
                    .HasColumnName("template_code")
                    .HasColumnType("varchar(150)");

                entity.Property(e => e.TemplateSenderEmail)
                    .HasColumnName("template_sender_email")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.TemplateSenderName)
                    .HasColumnName("template_sender_name")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.TemplateStyles)
                    .HasColumnName("template_styles")
                    .HasColumnType("text");

                entity.Property(e => e.TemplateSubject)
                    .HasColumnName("template_subject")
                    .HasColumnType("varchar(200)");

                entity.Property(e => e.TemplateText)
                    .HasColumnName("template_text")
                    .HasColumnType("text");

                entity.Property(e => e.TemplateTextPreprocessed)
                    .HasColumnName("template_text_preprocessed")
                    .HasColumnType("text");

                entity.Property(e => e.TemplateType)
                    .HasColumnName("template_type")
                    .HasColumnType("int(10) unsigned");
            });

            modelBuilder.Entity<OauthConsumer>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_oauth_consumer");

                entity.ToTable("oauth_consumer");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_OAUTH_CONSUMER_CREATED_AT");

                entity.HasIndex(e => e.Key)
                    .HasName("UNQ_OAUTH_CONSUMER_KEY")
                    .IsUnique();

                entity.HasIndex(e => e.Secret)
                    .HasName("UNQ_OAUTH_CONSUMER_SECRET")
                    .IsUnique();

                entity.HasIndex(e => e.UpdatedAt)
                    .HasName("IDX_OAUTH_CONSUMER_UPDATED_AT");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CallbackUrl)
                    .HasColumnName("callback_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Key)
                    .IsRequired()
                    .HasColumnName("key")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RejectedCallbackUrl)
                    .IsRequired()
                    .HasColumnName("rejected_callback_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Secret)
                    .IsRequired()
                    .HasColumnName("secret")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<OauthNonce>(entity =>
            {
                entity.HasKey(e => e.Nonce)
                    .HasName("UNQ_OAUTH_NONCE_NONCE");

                entity.ToTable("oauth_nonce");

                entity.Property(e => e.Nonce)
                    .HasColumnName("nonce")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Timestamp)
                    .HasColumnName("timestamp")
                    .HasColumnType("int(10) unsigned");
            });

            modelBuilder.Entity<OauthToken>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_oauth_token");

                entity.ToTable("oauth_token");

                entity.HasIndex(e => e.AdminId)
                    .HasName("FK_OAUTH_TOKEN_ADMIN_ID_ADMIN_USER_USER_ID");

                entity.HasIndex(e => e.ConsumerId)
                    .HasName("IDX_OAUTH_TOKEN_CONSUMER_ID");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("FK_OAUTH_TOKEN_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasIndex(e => e.Token)
                    .HasName("UNQ_OAUTH_TOKEN_TOKEN")
                    .IsUnique();

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdminId)
                    .HasColumnName("admin_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Authorized)
                    .HasColumnName("authorized")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CallbackUrl)
                    .IsRequired()
                    .HasColumnName("callback_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ConsumerId)
                    .HasColumnName("consumer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Revoked)
                    .HasColumnName("revoked")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Secret)
                    .IsRequired()
                    .HasColumnName("secret")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Token)
                    .IsRequired()
                    .HasColumnName("token")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasColumnName("type")
                    .HasColumnType("varchar(16)");

                entity.Property(e => e.Verifier)
                    .HasColumnName("verifier")
                    .HasColumnType("varchar(32)");

                entity.HasOne(d => d.Admin)
                    .WithMany(p => p.OauthToken)
                    .HasForeignKey(d => d.AdminId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_OAUTH_TOKEN_ADMIN_ID_ADMIN_USER_USER_ID");

                entity.HasOne(d => d.Consumer)
                    .WithMany(p => p.OauthToken)
                    .HasForeignKey(d => d.ConsumerId)
                    .HasConstraintName("FK_OAUTH_TOKEN_CONSUMER_ID_OAUTH_CONSUMER_ENTITY_ID");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.OauthToken)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_OAUTH_TOKEN_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");
            });

            modelBuilder.Entity<OnestepcheckoutConfigData>(entity =>
            {
                entity.HasKey(e => e.ConfigId)
                    .HasName("PK_onestepcheckout_config_data");

                entity.ToTable("onestepcheckout_config_data");

                entity.Property(e => e.ConfigId)
                    .HasColumnName("config_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.Path)
                    .HasColumnName("path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Scope)
                    .HasColumnName("scope")
                    .HasColumnType("varchar(8)");

                entity.Property(e => e.ScopeId)
                    .HasColumnName("scope_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<OnestepcheckoutDelivery>(entity =>
            {
                entity.HasKey(e => e.DeliveryId)
                    .HasName("PK_onestepcheckout_delivery");

                entity.ToTable("onestepcheckout_delivery");

                entity.Property(e => e.DeliveryId)
                    .HasColumnName("delivery_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.DeliveryTimeDate)
                    .HasColumnName("delivery_time_date")
                    .HasColumnType("varchar(16)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<OnestepcheckoutSurvey>(entity =>
            {
                entity.HasKey(e => e.SurveyId)
                    .HasName("PK_onestepcheckout_survey");

                entity.ToTable("onestepcheckout_survey");

                entity.Property(e => e.SurveyId)
                    .HasColumnName("survey_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.Answer)
                    .HasColumnName("answer")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Question)
                    .HasColumnName("question")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<PaypalCert>(entity =>
            {
                entity.HasKey(e => e.CertId)
                    .HasName("PK_paypal_cert");

                entity.ToTable("paypal_cert");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_PAYPAL_CERT_WEBSITE_ID");

                entity.Property(e => e.CertId)
                    .HasColumnName("cert_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Content)
                    .HasColumnName("content")
                    .HasColumnType("text");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.PaypalCert)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_PAYPAL_CERT_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<PaypalPaymentTransaction>(entity =>
            {
                entity.HasKey(e => e.TransactionId)
                    .HasName("PK_paypal_payment_transaction");

                entity.ToTable("paypal_payment_transaction");

                entity.HasIndex(e => e.TxnId)
                    .HasName("UNQ_PAYPAL_PAYMENT_TRANSACTION_TXN_ID")
                    .IsUnique();

                entity.Property(e => e.TransactionId)
                    .HasColumnName("transaction_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalInformation)
                    .HasColumnName("additional_information")
                    .HasColumnType("blob");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.TxnId)
                    .IsRequired()
                    .HasColumnName("txn_id")
                    .HasColumnType("varchar(100)");
            });

            modelBuilder.Entity<PaypalSettlementReport>(entity =>
            {
                entity.HasKey(e => e.ReportId)
                    .HasName("PK_paypal_settlement_report");

                entity.ToTable("paypal_settlement_report");

                entity.HasIndex(e => new { e.ReportDate, e.AccountId })
                    .HasName("UNQ_PAYPAL_SETTLEMENT_REPORT_REPORT_DATE_ACCOUNT_ID")
                    .IsUnique();

                entity.Property(e => e.ReportId)
                    .HasColumnName("report_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountId)
                    .IsRequired()
                    .HasColumnName("account_id")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.Filename)
                    .HasColumnName("filename")
                    .HasColumnType("varchar(24)");

                entity.Property(e => e.LastModified)
                    .HasColumnName("last_modified")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ReportDate)
                    .IsRequired()
                    .HasColumnName("report_date")
                    .HasColumnType("timestamp");
            });

            modelBuilder.Entity<PaypalSettlementReportRow>(entity =>
            {
                entity.HasKey(e => e.RowId)
                    .HasName("PK_paypal_settlement_report_row");

                entity.ToTable("paypal_settlement_report_row");

                entity.HasIndex(e => e.ReportId)
                    .HasName("IDX_PAYPAL_SETTLEMENT_REPORT_ROW_REPORT_ID");

                entity.Property(e => e.RowId)
                    .HasColumnName("row_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ConsumerId)
                    .HasColumnName("consumer_id")
                    .HasColumnType("varchar(127)");

                entity.Property(e => e.CustomField)
                    .HasColumnName("custom_field")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FeeAmount)
                    .HasColumnName("fee_amount")
                    .HasColumnType("decimal(20,6)")
                    .HasDefaultValueSql("0.000000");

                entity.Property(e => e.FeeCurrency)
                    .HasColumnName("fee_currency")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.FeeDebitOrCredit)
                    .HasColumnName("fee_debit_or_credit")
                    .HasColumnType("varchar(2)");

                entity.Property(e => e.GrossTransactionAmount)
                    .HasColumnName("gross_transaction_amount")
                    .HasColumnType("decimal(20,6)")
                    .HasDefaultValueSql("0.000000");

                entity.Property(e => e.GrossTransactionCurrency)
                    .HasColumnName("gross_transaction_currency")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.InvoiceId)
                    .HasColumnName("invoice_id")
                    .HasColumnType("varchar(127)");

                entity.Property(e => e.PaymentTrackingId)
                    .HasColumnName("payment_tracking_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PaypalReferenceId)
                    .HasColumnName("paypal_reference_id")
                    .HasColumnType("varchar(19)");

                entity.Property(e => e.PaypalReferenceIdType)
                    .HasColumnName("paypal_reference_id_type")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.ReportId)
                    .HasColumnName("report_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.TransactionCompletionDate)
                    .HasColumnName("transaction_completion_date")
                    .HasColumnType("timestamp");

                entity.Property(e => e.TransactionDebitOrCredit)
                    .IsRequired()
                    .HasColumnName("transaction_debit_or_credit")
                    .HasColumnType("varchar(2)")
                    .HasDefaultValueSql("CR");

                entity.Property(e => e.TransactionEventCode)
                    .HasColumnName("transaction_event_code")
                    .HasColumnType("varchar(5)");

                entity.Property(e => e.TransactionId)
                    .HasColumnName("transaction_id")
                    .HasColumnType("varchar(19)");

                entity.Property(e => e.TransactionInitiationDate)
                    .HasColumnName("transaction_initiation_date")
                    .HasColumnType("timestamp");

                entity.HasOne(d => d.Report)
                    .WithMany(p => p.PaypalSettlementReportRow)
                    .HasForeignKey(d => d.ReportId)
                    .HasConstraintName("FK_E183E488F593E0DE10C6EBFFEBAC9B55");
            });

            modelBuilder.Entity<PaypalauthCustomer>(entity =>
            {
                entity.ToTable("paypalauth_customer");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_UNIQUE_CUSTOMER_ID")
                    .IsUnique();

                entity.HasIndex(e => e.PayerId)
                    .HasName("IDX_UNIQUE_PAYER_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Email)
                    .IsRequired()
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PayerId)
                    .IsRequired()
                    .HasColumnName("payer_id")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Customer)
                    .WithOne(p => p.PaypalauthCustomer)
                    .HasForeignKey<PaypalauthCustomer>(d => d.CustomerId)
                    .HasConstraintName("FK_CUSTOMER_PAYPAL_CUSTOMER_ID");
            });

            modelBuilder.Entity<PermissionBlock>(entity =>
            {
                entity.HasKey(e => e.BlockId)
                    .HasName("PK_permission_block");

                entity.ToTable("permission_block");

                entity.HasIndex(e => e.BlockName)
                    .HasName("UNQ_PERMISSION_BLOCK_BLOCK_NAME")
                    .IsUnique();

                entity.Property(e => e.BlockId)
                    .HasColumnName("block_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BlockName)
                    .IsRequired()
                    .HasColumnName("block_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsAllowed)
                    .HasColumnName("is_allowed")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<PermissionVariable>(entity =>
            {
                entity.HasKey(e => new { e.VariableId, e.VariableName })
                    .HasName("PK_permission_variable");

                entity.ToTable("permission_variable");

                entity.HasIndex(e => e.VariableName)
                    .HasName("UNQ_PERMISSION_VARIABLE_VARIABLE_NAME")
                    .IsUnique();

                entity.Property(e => e.VariableId)
                    .HasColumnName("variable_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.VariableName)
                    .HasColumnName("variable_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsAllowed)
                    .HasColumnName("is_allowed")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<PersistentSession>(entity =>
            {
                entity.HasKey(e => e.PersistentId)
                    .HasName("PK_persistent_session");

                entity.ToTable("persistent_session");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_PERSISTENT_SESSION_CUSTOMER_ID")
                    .IsUnique();

                entity.HasIndex(e => e.Key)
                    .HasName("IDX_PERSISTENT_SESSION_KEY")
                    .IsUnique();

                entity.HasIndex(e => e.UpdatedAt)
                    .HasName("IDX_PERSISTENT_SESSION_UPDATED_AT");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("FK_PERSISTENT_SESSION_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");

                entity.Property(e => e.PersistentId)
                    .HasColumnName("persistent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerId)
                    .IsRequired()
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Info)
                    .HasColumnName("info")
                    .HasColumnType("text");

                entity.Property(e => e.Key)
                    .IsRequired()
                    .HasColumnName("key")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Customer)
                    .WithOne(p => p.PersistentSession)
                    .HasForeignKey<PersistentSession>(d => d.CustomerId)
                    .HasConstraintName("FK_PERSISTENT_SESSION_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.PersistentSession)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_PERSISTENT_SESSION_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<Poll>(entity =>
            {
                entity.ToTable("poll");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_POLL_STORE_ID");

                entity.Property(e => e.PollId)
                    .HasColumnName("poll_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Active)
                    .HasColumnName("active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.AnswersDisplay)
                    .HasColumnName("answers_display")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.Closed)
                    .HasColumnName("closed")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.DateClosed)
                    .HasColumnName("date_closed")
                    .HasColumnType("timestamp");

                entity.Property(e => e.DatePosted)
                    .HasColumnName("date_posted")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.PollTitle)
                    .HasColumnName("poll_title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.VotesCount)
                    .HasColumnName("votes_count")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.Poll)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_POLL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<PollAnswer>(entity =>
            {
                entity.HasKey(e => e.AnswerId)
                    .HasName("PK_poll_answer");

                entity.ToTable("poll_answer");

                entity.HasIndex(e => e.PollId)
                    .HasName("IDX_POLL_ANSWER_POLL_ID");

                entity.Property(e => e.AnswerId)
                    .HasColumnName("answer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AnswerOrder)
                    .HasColumnName("answer_order")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.AnswerTitle)
                    .HasColumnName("answer_title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PollId)
                    .HasColumnName("poll_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.VotesCount)
                    .HasColumnName("votes_count")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Poll)
                    .WithMany(p => p.PollAnswer)
                    .HasForeignKey(d => d.PollId)
                    .HasConstraintName("FK_POLL_ANSWER_POLL_ID_POLL_POLL_ID");
            });

            modelBuilder.Entity<PollStore>(entity =>
            {
                entity.HasKey(e => new { e.PollId, e.StoreId })
                    .HasName("PK_poll_store");

                entity.ToTable("poll_store");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_POLL_STORE_STORE_ID");

                entity.Property(e => e.PollId)
                    .HasColumnName("poll_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Poll)
                    .WithMany(p => p.PollStore)
                    .HasForeignKey(d => d.PollId)
                    .HasConstraintName("FK_POLL_STORE_POLL_ID_POLL_POLL_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.PollStore)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_POLL_STORE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<PollVote>(entity =>
            {
                entity.HasKey(e => e.VoteId)
                    .HasName("PK_poll_vote");

                entity.ToTable("poll_vote");

                entity.HasIndex(e => e.PollAnswerId)
                    .HasName("IDX_POLL_VOTE_POLL_ANSWER_ID");

                entity.Property(e => e.VoteId)
                    .HasColumnName("vote_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IpAddress)
                    .HasColumnName("ip_address")
                    .HasColumnType("varbinary(16)");

                entity.Property(e => e.PollAnswerId)
                    .HasColumnName("poll_answer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.PollId)
                    .HasColumnName("poll_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.VoteTime)
                    .HasColumnName("vote_time")
                    .HasColumnType("timestamp");

                entity.HasOne(d => d.PollAnswer)
                    .WithMany(p => p.PollVote)
                    .HasForeignKey(d => d.PollAnswerId)
                    .HasConstraintName("FK_POLL_VOTE_POLL_ANSWER_ID_POLL_ANSWER_ANSWER_ID");
            });

            modelBuilder.Entity<ProductAlertPrice>(entity =>
            {
                entity.HasKey(e => e.AlertPriceId)
                    .HasName("PK_product_alert_price");

                entity.ToTable("product_alert_price");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_PRODUCT_ALERT_PRICE_CUSTOMER_ID");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_PRODUCT_ALERT_PRICE_PRODUCT_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_PRODUCT_ALERT_PRICE_WEBSITE_ID");

                entity.Property(e => e.AlertPriceId)
                    .HasColumnName("alert_price_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddDate)
                    .HasColumnName("add_date")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LastSendDate)
                    .HasColumnName("last_send_date")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SendCount)
                    .HasColumnName("send_count")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.ProductAlertPrice)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("FK_PRODUCT_ALERT_PRICE_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.ProductAlertPrice)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_PRD_ALERT_PRICE_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.ProductAlertPrice)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_PRODUCT_ALERT_PRICE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<ProductAlertStock>(entity =>
            {
                entity.HasKey(e => e.AlertStockId)
                    .HasName("PK_product_alert_stock");

                entity.ToTable("product_alert_stock");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_PRODUCT_ALERT_STOCK_CUSTOMER_ID");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_PRODUCT_ALERT_STOCK_PRODUCT_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_PRODUCT_ALERT_STOCK_WEBSITE_ID");

                entity.Property(e => e.AlertStockId)
                    .HasColumnName("alert_stock_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddDate)
                    .HasColumnName("add_date")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SendCount)
                    .HasColumnName("send_count")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SendDate)
                    .HasColumnName("send_date")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.ProductAlertStock)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("FK_PRODUCT_ALERT_STOCK_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.ProductAlertStock)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_PRD_ALERT_STOCK_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.ProductAlertStock)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_PRODUCT_ALERT_STOCK_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<PromotionalgiftBanner>(entity =>
            {
                entity.HasKey(e => e.BannerId)
                    .HasName("PK_promotionalgift_banner");

                entity.ToTable("promotionalgift_banner");

                entity.Property(e => e.BannerId)
                    .HasColumnName("banner_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.BannerCalendar)
                    .IsRequired()
                    .HasColumnName("banner_calendar")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("all");

                entity.Property(e => e.Cmsblock)
                    .HasColumnName("cmsblock")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ConditionsSerialized)
                    .IsRequired()
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.CustomerGroupIds)
                    .HasColumnName("customer_group_ids")
                    .HasColumnType("text");

                entity.Property(e => e.Daily)
                    .HasColumnName("daily")
                    .HasColumnType("text");

                entity.Property(e => e.FromDate)
                    .HasColumnName("from_date")
                    .HasColumnType("date");

                entity.Property(e => e.IsCart)
                    .HasColumnName("is_cart")
                    .HasColumnType("int(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsOnepage)
                    .HasColumnName("is_onepage")
                    .HasColumnType("int(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Monthly)
                    .HasColumnName("monthly")
                    .HasColumnType("text");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Priority)
                    .HasColumnName("priority")
                    .HasColumnType("int(11) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TimeUsed)
                    .HasColumnName("time_used")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ToDate)
                    .HasColumnName("to_date")
                    .HasColumnType("date");

                entity.Property(e => e.WebsiteIds)
                    .HasColumnName("website_ids")
                    .HasColumnType("text");

                entity.Property(e => e.Weekly)
                    .HasColumnName("weekly")
                    .HasColumnType("text");

                entity.Property(e => e.Yearly)
                    .HasColumnName("yearly")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<PromotionalgiftCatalogItem>(entity =>
            {
                entity.HasKey(e => e.ItemId)
                    .HasName("PK_promotionalgift_catalog_item");

                entity.ToTable("promotionalgift_catalog_item");

                entity.HasIndex(e => e.RuleId)
                    .HasName("rule_id");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.GiftQty)
                    .HasColumnName("gift_qty")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductIds)
                    .HasColumnName("product_ids")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(11) unsigned");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.PromotionalgiftCatalogItem)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("promotionalgift_catalog_item_ibfk_1");
            });

            modelBuilder.Entity<PromotionalgiftCatalogProduct>(entity =>
            {
                entity.HasKey(e => e.RuleProductId)
                    .HasName("PK_promotionalgift_catalog_product");

                entity.ToTable("promotionalgift_catalog_product");

                entity.HasIndex(e => e.RuleId)
                    .HasName("rule_id");

                entity.Property(e => e.RuleProductId)
                    .HasColumnName("rule_product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.PromotionalgiftCatalogProduct)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("promotionalgift_catalog_product_ibfk_1");
            });

            modelBuilder.Entity<PromotionalgiftCatalogRule>(entity =>
            {
                entity.HasKey(e => e.RuleId)
                    .HasName("PK_promotionalgift_catalog_rule");

                entity.ToTable("promotionalgift_catalog_rule");

                entity.HasIndex(e => e.DiscountProduct)
                    .HasName("discount_product");

                entity.HasIndex(e => e.FreeShipping)
                    .HasName("free_shipping");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.ConditionsSerialized)
                    .IsRequired()
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.CustomerGroupIds)
                    .HasColumnName("customer_group_ids")
                    .HasColumnType("text");

                entity.Property(e => e.Daily)
                    .HasColumnName("daily")
                    .HasColumnType("text");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountProduct)
                    .HasColumnName("discount_product")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("100");

                entity.Property(e => e.DiscountProductFixed)
                    .HasColumnName("discount_product_fixed")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.FreeShipping)
                    .HasColumnName("free_shipping")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.FromDate)
                    .HasColumnName("from_date")
                    .HasColumnType("date");

                entity.Property(e => e.GiftCalendar)
                    .IsRequired()
                    .HasColumnName("gift_calendar")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("all");

                entity.Property(e => e.Image)
                    .HasColumnName("image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Monthly)
                    .HasColumnName("monthly")
                    .HasColumnType("text");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NumberItemFree)
                    .HasColumnName("number_item_free")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.PriceType)
                    .HasColumnName("price_type")
                    .HasColumnType("int(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Priority)
                    .HasColumnName("priority")
                    .HasColumnType("int(11) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ShowBeforeDate)
                    .HasColumnName("show_before_date")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TimeUsed)
                    .HasColumnName("time_used")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ToDate)
                    .HasColumnName("to_date")
                    .HasColumnType("date");

                entity.Property(e => e.UsesLimit)
                    .HasColumnName("uses_limit")
                    .HasColumnType("int(11)");

                entity.Property(e => e.WebsiteIds)
                    .HasColumnName("website_ids")
                    .HasColumnType("text");

                entity.Property(e => e.Weekly)
                    .HasColumnName("weekly")
                    .HasColumnType("text");

                entity.Property(e => e.Yearly)
                    .HasColumnName("yearly")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<PromotionalgiftQuote>(entity =>
            {
                entity.ToTable("promotionalgift_quote");

                entity.HasIndex(e => e.GroupedId)
                    .HasName("grouped_id");

                entity.Property(e => e.PromotionalgiftQuoteId)
                    .HasColumnName("promotionalgift_quote_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.CatalogRuleId)
                    .HasColumnName("catalog_rule_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GroupedId)
                    .HasColumnName("grouped_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ItemParentId)
                    .HasColumnName("item_parent_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Message)
                    .HasColumnName("message")
                    .HasColumnType("text");

                entity.Property(e => e.NumberItemFree)
                    .HasColumnName("number_item_free")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ShoppingCartRuleId)
                    .HasColumnName("shopping_cart_rule_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<PromotionalgiftSale>(entity =>
            {
                entity.HasKey(e => e.SaleId)
                    .HasName("PK_promotionalgift_sale");

                entity.ToTable("promotionalgift_sale");

                entity.Property(e => e.SaleId)
                    .HasColumnName("sale_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.CatalogruleId)
                    .HasColumnName("catalogrule_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CouponCode)
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("datetime");

                entity.Property(e => e.GiftTotal)
                    .HasColumnName("gift_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OrderIncrementId)
                    .HasColumnName("order_increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrderStatus)
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderTotal)
                    .HasColumnName("order_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductIds)
                    .HasColumnName("product_ids")
                    .HasColumnType("text");

                entity.Property(e => e.ProductNames)
                    .HasColumnName("product_names")
                    .HasColumnType("text");

                entity.Property(e => e.ShoppingcartruleId)
                    .HasColumnName("shoppingcartrule_id")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<PromotionalgiftShoppingCartItem>(entity =>
            {
                entity.HasKey(e => e.ItemId)
                    .HasName("PK_promotionalgift_shopping_cart_item");

                entity.ToTable("promotionalgift_shopping_cart_item");

                entity.HasIndex(e => e.RuleId)
                    .HasName("rule_id");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.GiftQty)
                    .HasColumnName("gift_qty")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductIds)
                    .HasColumnName("product_ids")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(11) unsigned");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.PromotionalgiftShoppingCartItem)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("promotionalgift_shopping_cart_item_ibfk_1");
            });

            modelBuilder.Entity<PromotionalgiftShoppingCartQuote>(entity =>
            {
                entity.HasKey(e => e.ShoppingcartQuoteId)
                    .HasName("PK_promotionalgift_shopping_cart_quote");

                entity.ToTable("promotionalgift_shopping_cart_quote");

                entity.HasIndex(e => e.GroupedId)
                    .HasName("grouped_id");

                entity.Property(e => e.ShoppingcartQuoteId)
                    .HasColumnName("shoppingcart_quote_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.CouponCode)
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.GroupedId)
                    .HasColumnName("grouped_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Message)
                    .HasColumnName("message")
                    .HasColumnType("text");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ShoppingcartruleId)
                    .HasColumnName("shoppingcartrule_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<PromotionalgiftShoppingCartRule>(entity =>
            {
                entity.HasKey(e => e.RuleId)
                    .HasName("PK_promotionalgift_shopping_cart_rule");

                entity.ToTable("promotionalgift_shopping_cart_rule");

                entity.HasIndex(e => e.DiscountProduct)
                    .HasName("discount_product");

                entity.HasIndex(e => e.FreeShipping)
                    .HasName("free_shipping");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.ConditionsSerialized)
                    .IsRequired()
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.CouponCode)
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CouponType)
                    .HasColumnName("coupon_type")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CustomerGroupIds)
                    .HasColumnName("customer_group_ids")
                    .HasColumnType("text");

                entity.Property(e => e.Daily)
                    .HasColumnName("daily")
                    .HasColumnType("text");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountProduct)
                    .HasColumnName("discount_product")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("100");

                entity.Property(e => e.DiscountProductFixed)
                    .HasColumnName("discount_product_fixed")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.FreeShipping)
                    .HasColumnName("free_shipping")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.FromDate)
                    .HasColumnName("from_date")
                    .HasColumnType("date");

                entity.Property(e => e.GiftCalendar)
                    .IsRequired()
                    .HasColumnName("gift_calendar")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("all");

                entity.Property(e => e.Monthly)
                    .HasColumnName("monthly")
                    .HasColumnType("text");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NumberItemFree)
                    .HasColumnName("number_item_free")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.PriceType)
                    .HasColumnName("price_type")
                    .HasColumnType("int(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Priority)
                    .HasColumnName("priority")
                    .HasColumnType("int(11) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ShowBeforeDate)
                    .HasColumnName("show_before_date")
                    .HasColumnType("tinyint(1)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ToDate)
                    .HasColumnName("to_date")
                    .HasColumnType("date");

                entity.Property(e => e.UsesPerCoupon)
                    .HasColumnName("uses_per_coupon")
                    .HasColumnType("int(11)");

                entity.Property(e => e.WebsiteIds)
                    .HasColumnName("website_ids")
                    .HasColumnType("text");

                entity.Property(e => e.Weekly)
                    .HasColumnName("weekly")
                    .HasColumnType("text");

                entity.Property(e => e.Yearly)
                    .HasColumnName("yearly")
                    .HasColumnType("text");
            });

            modelBuilder.Entity<Rating>(entity =>
            {
                entity.ToTable("rating");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_RATING_ENTITY_ID");

                entity.HasIndex(e => e.RatingCode)
                    .HasName("UNQ_RATING_RATING_CODE")
                    .IsUnique();

                entity.Property(e => e.RatingId)
                    .HasColumnName("rating_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RatingCode)
                    .IsRequired()
                    .HasColumnName("rating_code")
                    .HasColumnType("varchar(64)");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.Rating)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_RATING_ENTITY_ID_RATING_ENTITY_ENTITY_ID");
            });

            modelBuilder.Entity<RatingEntity>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_rating_entity");

                entity.ToTable("rating_entity");

                entity.HasIndex(e => e.EntityCode)
                    .HasName("UNQ_RATING_ENTITY_ENTITY_CODE")
                    .IsUnique();

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.EntityCode)
                    .IsRequired()
                    .HasColumnName("entity_code")
                    .HasColumnType("varchar(64)");
            });

            modelBuilder.Entity<RatingOption>(entity =>
            {
                entity.HasKey(e => e.OptionId)
                    .HasName("PK_rating_option");

                entity.ToTable("rating_option");

                entity.HasIndex(e => e.RatingId)
                    .HasName("IDX_RATING_OPTION_RATING_ID");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RatingId)
                    .HasColumnName("rating_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Rating)
                    .WithMany(p => p.RatingOption)
                    .HasForeignKey(d => d.RatingId)
                    .HasConstraintName("FK_RATING_OPTION_RATING_ID_RATING_RATING_ID");
            });

            modelBuilder.Entity<RatingOptionVote>(entity =>
            {
                entity.HasKey(e => e.VoteId)
                    .HasName("PK_rating_option_vote");

                entity.ToTable("rating_option_vote");

                entity.HasIndex(e => e.OptionId)
                    .HasName("IDX_RATING_OPTION_VOTE_OPTION_ID");

                entity.HasIndex(e => e.ReviewId)
                    .HasName("FK_RATING_OPTION_VOTE_REVIEW_ID_REVIEW_REVIEW_ID");

                entity.Property(e => e.VoteId)
                    .HasColumnName("vote_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityPkValue)
                    .HasColumnName("entity_pk_value")
                    .HasColumnType("bigint(20) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Percent)
                    .HasColumnName("percent")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RatingId)
                    .HasColumnName("rating_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RemoteIp)
                    .HasColumnName("remote_ip")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.RemoteIpLong)
                    .HasColumnName("remote_ip_long")
                    .HasColumnType("varbinary(16)");

                entity.Property(e => e.ReviewId)
                    .HasColumnName("review_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Option)
                    .WithMany(p => p.RatingOptionVote)
                    .HasForeignKey(d => d.OptionId)
                    .HasConstraintName("FK_RATING_OPTION_VOTE_OPTION_ID_RATING_OPTION_OPTION_ID");

                entity.HasOne(d => d.Review)
                    .WithMany(p => p.RatingOptionVote)
                    .HasForeignKey(d => d.ReviewId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_RATING_OPTION_VOTE_REVIEW_ID_REVIEW_REVIEW_ID");
            });

            modelBuilder.Entity<RatingOptionVoteAggregated>(entity =>
            {
                entity.HasKey(e => e.PrimaryId)
                    .HasName("PK_rating_option_vote_aggregated");

                entity.ToTable("rating_option_vote_aggregated");

                entity.HasIndex(e => e.RatingId)
                    .HasName("IDX_RATING_OPTION_VOTE_AGGREGATED_RATING_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_RATING_OPTION_VOTE_AGGREGATED_STORE_ID");

                entity.Property(e => e.PrimaryId)
                    .HasColumnName("primary_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.EntityPkValue)
                    .HasColumnName("entity_pk_value")
                    .HasColumnType("bigint(20) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Percent)
                    .HasColumnName("percent")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.PercentApproved)
                    .HasColumnName("percent_approved")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RatingId)
                    .HasColumnName("rating_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.VoteCount)
                    .HasColumnName("vote_count")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.VoteValueSum)
                    .HasColumnName("vote_value_sum")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Rating)
                    .WithMany(p => p.RatingOptionVoteAggregated)
                    .HasForeignKey(d => d.RatingId)
                    .HasConstraintName("FK_RATING_OPTION_VOTE_AGGREGATED_RATING_ID_RATING_RATING_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.RatingOptionVoteAggregated)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_RATING_OPTION_VOTE_AGGREGATED_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<RatingStore>(entity =>
            {
                entity.HasKey(e => new { e.RatingId, e.StoreId })
                    .HasName("PK_rating_store");

                entity.ToTable("rating_store");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_RATING_STORE_STORE_ID");

                entity.Property(e => e.RatingId)
                    .HasColumnName("rating_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Rating)
                    .WithMany(p => p.RatingStore)
                    .HasForeignKey(d => d.RatingId)
                    .HasConstraintName("FK_RATING_STORE_RATING_ID_RATING_RATING_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.RatingStore)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_RATING_STORE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<RatingTitle>(entity =>
            {
                entity.HasKey(e => new { e.RatingId, e.StoreId })
                    .HasName("PK_rating_title");

                entity.ToTable("rating_title");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_RATING_TITLE_STORE_ID");

                entity.Property(e => e.RatingId)
                    .HasColumnName("rating_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Rating)
                    .WithMany(p => p.RatingTitle)
                    .HasForeignKey(d => d.RatingId)
                    .HasConstraintName("FK_RATING_TITLE_RATING_ID_RATING_RATING_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.RatingTitle)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_RATING_TITLE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<ReportComparedProductIndex>(entity =>
            {
                entity.HasKey(e => e.IndexId)
                    .HasName("PK_report_compared_product_index");

                entity.ToTable("report_compared_product_index");

                entity.HasIndex(e => e.AddedAt)
                    .HasName("IDX_REPORT_COMPARED_PRODUCT_INDEX_ADDED_AT");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_REPORT_COMPARED_PRODUCT_INDEX_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REPORT_COMPARED_PRODUCT_INDEX_STORE_ID");

                entity.HasIndex(e => new { e.CustomerId, e.ProductId })
                    .HasName("UNQ_REPORT_COMPARED_PRODUCT_INDEX_CUSTOMER_ID_PRODUCT_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.VisitorId, e.ProductId })
                    .HasName("UNQ_REPORT_COMPARED_PRODUCT_INDEX_VISITOR_ID_PRODUCT_ID")
                    .IsUnique();

                entity.Property(e => e.IndexId)
                    .HasColumnName("index_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.AddedAt)
                    .HasColumnName("added_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .IsRequired()
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.VisitorId)
                    .IsRequired()
                    .HasColumnName("visitor_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.ReportComparedProductIndex)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("FK_REPORT_CMPD_PRD_IDX_CSTR_ID_CSTR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.ReportComparedProductIndex)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_REPORT_CMPD_PRD_IDX_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReportComparedProductIndex)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_REPORT_COMPARED_PRODUCT_INDEX_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<ReportEvent>(entity =>
            {
                entity.HasKey(e => e.EventId)
                    .HasName("PK_report_event");

                entity.ToTable("report_event");

                entity.HasIndex(e => e.EventTypeId)
                    .HasName("IDX_REPORT_EVENT_EVENT_TYPE_ID");

                entity.HasIndex(e => e.ObjectId)
                    .HasName("IDX_REPORT_EVENT_OBJECT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REPORT_EVENT_STORE_ID");

                entity.HasIndex(e => e.SubjectId)
                    .HasName("IDX_REPORT_EVENT_SUBJECT_ID");

                entity.HasIndex(e => e.Subtype)
                    .HasName("IDX_REPORT_EVENT_SUBTYPE");

                entity.Property(e => e.EventId)
                    .HasColumnName("event_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.EventTypeId)
                    .HasColumnName("event_type_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.LoggedAt)
                    .HasColumnName("logged_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.ObjectId)
                    .HasColumnName("object_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SubjectId)
                    .HasColumnName("subject_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Subtype)
                    .HasColumnName("subtype")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.EventType)
                    .WithMany(p => p.ReportEvent)
                    .HasForeignKey(d => d.EventTypeId)
                    .HasConstraintName("FK_REPORT_EVENT_EVENT_TYPE_ID_REPORT_EVENT_TYPES_EVENT_TYPE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReportEvent)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_REPORT_EVENT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<ReportEventTypes>(entity =>
            {
                entity.HasKey(e => e.EventTypeId)
                    .HasName("PK_report_event_types");

                entity.ToTable("report_event_types");

                entity.Property(e => e.EventTypeId)
                    .HasColumnName("event_type_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CustomerLogin)
                    .HasColumnName("customer_login")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EventName)
                    .IsRequired()
                    .HasColumnName("event_name")
                    .HasColumnType("varchar(64)");
            });

            modelBuilder.Entity<ReportViewedProductAggregatedDaily>(entity =>
            {
                entity.ToTable("report_viewed_product_aggregated_daily");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_AGGREGATED_DAILY_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_AGGREGATED_DAILY_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.ProductId })
                    .HasName("UNQ_REPORT_VIEWED_PRD_AGGRED_DAILY_PERIOD_STORE_ID_PRD_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.ProductId)
                    .IsRequired()
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductName)
                    .HasColumnName("product_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductPrice)
                    .HasColumnName("product_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RatingPos)
                    .HasColumnName("rating_pos")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.ViewsNum)
                    .HasColumnName("views_num")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.ReportViewedProductAggregatedDaily)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_REPORT_VIEWED_PRD_AGGRED_DAILY_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReportViewedProductAggregatedDaily)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_REPORT_VIEWED_PRD_AGGRED_DAILY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<ReportViewedProductAggregatedMonthly>(entity =>
            {
                entity.ToTable("report_viewed_product_aggregated_monthly");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_AGGREGATED_MONTHLY_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_AGGREGATED_MONTHLY_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.ProductId })
                    .HasName("UNQ_REPORT_VIEWED_PRD_AGGRED_MONTHLY_PERIOD_STORE_ID_PRD_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.ProductId)
                    .IsRequired()
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductName)
                    .HasColumnName("product_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductPrice)
                    .HasColumnName("product_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RatingPos)
                    .HasColumnName("rating_pos")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.ViewsNum)
                    .HasColumnName("views_num")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.ReportViewedProductAggregatedMonthly)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_REPORT_VIEWED_PRD_AGGRED_MONTHLY_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReportViewedProductAggregatedMonthly)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_REPORT_VIEWED_PRD_AGGRED_MONTHLY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<ReportViewedProductAggregatedYearly>(entity =>
            {
                entity.ToTable("report_viewed_product_aggregated_yearly");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_AGGREGATED_YEARLY_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_AGGREGATED_YEARLY_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.ProductId })
                    .HasName("UNQ_REPORT_VIEWED_PRD_AGGRED_YEARLY_PERIOD_STORE_ID_PRD_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.ProductId)
                    .IsRequired()
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductName)
                    .HasColumnName("product_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductPrice)
                    .HasColumnName("product_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RatingPos)
                    .HasColumnName("rating_pos")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.ViewsNum)
                    .HasColumnName("views_num")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.ReportViewedProductAggregatedYearly)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_REPORT_VIEWED_PRD_AGGRED_YEARLY_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReportViewedProductAggregatedYearly)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_REPORT_VIEWED_PRD_AGGRED_YEARLY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<ReportViewedProductIndex>(entity =>
            {
                entity.HasKey(e => e.IndexId)
                    .HasName("PK_report_viewed_product_index");

                entity.ToTable("report_viewed_product_index");

                entity.HasIndex(e => e.AddedAt)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_INDEX_ADDED_AT");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_INDEX_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REPORT_VIEWED_PRODUCT_INDEX_STORE_ID");

                entity.HasIndex(e => new { e.CustomerId, e.ProductId })
                    .HasName("UNQ_REPORT_VIEWED_PRODUCT_INDEX_CUSTOMER_ID_PRODUCT_ID")
                    .IsUnique();

                entity.HasIndex(e => new { e.VisitorId, e.ProductId })
                    .HasName("UNQ_REPORT_VIEWED_PRODUCT_INDEX_VISITOR_ID_PRODUCT_ID")
                    .IsUnique();

                entity.Property(e => e.IndexId)
                    .HasColumnName("index_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.AddedAt)
                    .HasColumnName("added_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .IsRequired()
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.VisitorId)
                    .IsRequired()
                    .HasColumnName("visitor_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.ReportViewedProductIndex)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("FK_REPORT_VIEWED_PRD_IDX_CSTR_ID_CSTR_ENTT_ENTT_ID");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.ReportViewedProductIndex)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_REPORT_VIEWED_PRD_IDX_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReportViewedProductIndex)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_REPORT_VIEWED_PRODUCT_INDEX_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<Review>(entity =>
            {
                entity.ToTable("review");

                entity.HasIndex(e => e.EntityId)
                    .HasName("IDX_REVIEW_ENTITY_ID");

                entity.HasIndex(e => e.EntityPkValue)
                    .HasName("IDX_REVIEW_ENTITY_PK_VALUE");

                entity.HasIndex(e => e.StatusId)
                    .HasName("IDX_REVIEW_STATUS_ID");

                entity.Property(e => e.ReviewId)
                    .HasColumnName("review_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityPkValue)
                    .HasColumnName("entity_pk_value")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StatusId)
                    .HasColumnName("status_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Entity)
                    .WithMany(p => p.Review)
                    .HasForeignKey(d => d.EntityId)
                    .HasConstraintName("FK_REVIEW_ENTITY_ID_REVIEW_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Status)
                    .WithMany(p => p.Review)
                    .HasForeignKey(d => d.StatusId)
                    .OnDelete(DeleteBehavior.Restrict)
                    .HasConstraintName("FK_REVIEW_STATUS_ID_REVIEW_STATUS_STATUS_ID");
            });

            modelBuilder.Entity<ReviewDetail>(entity =>
            {
                entity.HasKey(e => e.DetailId)
                    .HasName("PK_review_detail");

                entity.ToTable("review_detail");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_REVIEW_DETAIL_CUSTOMER_ID");

                entity.HasIndex(e => e.ReviewId)
                    .HasName("IDX_REVIEW_DETAIL_REVIEW_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REVIEW_DETAIL_STORE_ID");

                entity.Property(e => e.DetailId)
                    .HasColumnName("detail_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Detail)
                    .IsRequired()
                    .HasColumnName("detail")
                    .HasColumnType("text");

                entity.Property(e => e.Nickname)
                    .IsRequired()
                    .HasColumnName("nickname")
                    .HasColumnType("varchar(128)");

                entity.Property(e => e.ReviewId)
                    .HasColumnName("review_id")
                    .HasColumnType("bigint(20) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Title)
                    .IsRequired()
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.ReviewDetail)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_REVIEW_DETAIL_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Review)
                    .WithMany(p => p.ReviewDetail)
                    .HasForeignKey(d => d.ReviewId)
                    .HasConstraintName("FK_REVIEW_DETAIL_REVIEW_ID_REVIEW_REVIEW_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReviewDetail)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_REVIEW_DETAIL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<ReviewEntity>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_review_entity");

                entity.ToTable("review_entity");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.EntityCode)
                    .IsRequired()
                    .HasColumnName("entity_code")
                    .HasColumnType("varchar(32)");
            });

            modelBuilder.Entity<ReviewEntitySummary>(entity =>
            {
                entity.HasKey(e => e.PrimaryId)
                    .HasName("PK_review_entity_summary");

                entity.ToTable("review_entity_summary");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REVIEW_ENTITY_SUMMARY_STORE_ID");

                entity.Property(e => e.PrimaryId)
                    .HasColumnName("primary_id")
                    .HasColumnType("bigint(20)");

                entity.Property(e => e.EntityPkValue)
                    .HasColumnName("entity_pk_value")
                    .HasColumnType("bigint(20)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EntityType)
                    .HasColumnName("entity_type")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RatingSummary)
                    .HasColumnName("rating_summary")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ReviewsCount)
                    .HasColumnName("reviews_count")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReviewEntitySummary)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_REVIEW_ENTITY_SUMMARY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<ReviewStatus>(entity =>
            {
                entity.HasKey(e => e.StatusId)
                    .HasName("PK_review_status");

                entity.ToTable("review_status");

                entity.Property(e => e.StatusId)
                    .HasColumnName("status_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StatusCode)
                    .IsRequired()
                    .HasColumnName("status_code")
                    .HasColumnType("varchar(32)");
            });

            modelBuilder.Entity<ReviewStore>(entity =>
            {
                entity.HasKey(e => new { e.ReviewId, e.StoreId })
                    .HasName("PK_review_store");

                entity.ToTable("review_store");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_REVIEW_STORE_STORE_ID");

                entity.Property(e => e.ReviewId)
                    .HasColumnName("review_id")
                    .HasColumnType("bigint(20) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Review)
                    .WithMany(p => p.ReviewStore)
                    .HasForeignKey(d => d.ReviewId)
                    .HasConstraintName("FK_REVIEW_STORE_REVIEW_ID_REVIEW_REVIEW_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.ReviewStore)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_REVIEW_STORE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesBestsellersAggregatedDaily>(entity =>
            {
                entity.ToTable("sales_bestsellers_aggregated_daily");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_SALES_BESTSELLERS_AGGREGATED_DAILY_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_BESTSELLERS_AGGREGATED_DAILY_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.ProductId })
                    .HasName("UNQ_SALES_BESTSELLERS_AGGRED_DAILY_PERIOD_STORE_ID_PRD_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.ProductId)
                    .IsRequired()
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductName)
                    .HasColumnName("product_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductPrice)
                    .HasColumnName("product_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyOrdered)
                    .HasColumnName("qty_ordered")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RatingPos)
                    .HasColumnName("rating_pos")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.SalesBestsellersAggregatedDaily)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_SALES_BESTSELLERS_AGGRED_DAILY_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesBestsellersAggregatedDaily)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_SALES_BESTSELLERS_AGGRED_DAILY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesBestsellersAggregatedMonthly>(entity =>
            {
                entity.ToTable("sales_bestsellers_aggregated_monthly");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_SALES_BESTSELLERS_AGGREGATED_MONTHLY_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_BESTSELLERS_AGGREGATED_MONTHLY_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.ProductId })
                    .HasName("UNQ_SALES_BESTSELLERS_AGGRED_MONTHLY_PERIOD_STORE_ID_PRD_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.ProductId)
                    .IsRequired()
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductName)
                    .HasColumnName("product_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductPrice)
                    .HasColumnName("product_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyOrdered)
                    .HasColumnName("qty_ordered")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RatingPos)
                    .HasColumnName("rating_pos")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.SalesBestsellersAggregatedMonthly)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_SALES_BESTSELLERS_AGGRED_MONTHLY_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesBestsellersAggregatedMonthly)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_SALES_BESTSELLERS_AGGRED_MONTHLY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesBestsellersAggregatedYearly>(entity =>
            {
                entity.ToTable("sales_bestsellers_aggregated_yearly");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_SALES_BESTSELLERS_AGGREGATED_YEARLY_PRODUCT_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_BESTSELLERS_AGGREGATED_YEARLY_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.ProductId })
                    .HasName("UNQ_SALES_BESTSELLERS_AGGRED_YEARLY_PERIOD_STORE_ID_PRD_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.ProductId)
                    .IsRequired()
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductName)
                    .HasColumnName("product_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductPrice)
                    .HasColumnName("product_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyOrdered)
                    .HasColumnName("qty_ordered")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RatingPos)
                    .HasColumnName("rating_pos")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.SalesBestsellersAggregatedYearly)
                    .HasForeignKey(d => d.ProductId)
                    .HasConstraintName("FK_SALES_BESTSELLERS_AGGRED_YEARLY_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesBestsellersAggregatedYearly)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_SALES_BESTSELLERS_AGGRED_YEARLY_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesBillingAgreement>(entity =>
            {
                entity.HasKey(e => e.AgreementId)
                    .HasName("PK_sales_billing_agreement");

                entity.ToTable("sales_billing_agreement");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_SALES_BILLING_AGREEMENT_CUSTOMER_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_BILLING_AGREEMENT_STORE_ID");

                entity.Property(e => e.AgreementId)
                    .HasColumnName("agreement_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AgreementLabel)
                    .HasColumnName("agreement_label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.MethodCode)
                    .IsRequired()
                    .HasColumnName("method_code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.ReferenceId)
                    .IsRequired()
                    .HasColumnName("reference_id")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Status)
                    .IsRequired()
                    .HasColumnName("status")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.SalesBillingAgreement)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("FK_SALES_BILLING_AGREEMENT_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesBillingAgreement)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_BILLING_AGREEMENT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesBillingAgreementOrder>(entity =>
            {
                entity.HasKey(e => new { e.AgreementId, e.OrderId })
                    .HasName("PK_sales_billing_agreement_order");

                entity.ToTable("sales_billing_agreement_order");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_BILLING_AGREEMENT_ORDER_ORDER_ID");

                entity.Property(e => e.AgreementId)
                    .HasColumnName("agreement_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Agreement)
                    .WithMany(p => p.SalesBillingAgreementOrder)
                    .HasForeignKey(d => d.AgreementId)
                    .HasConstraintName("FK_SALES_BILLING_AGRT_ORDER_AGRT_ID_SALES_BILLING_AGRT_AGRT_ID");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.SalesBillingAgreementOrder)
                    .HasForeignKey(d => d.OrderId)
                    .HasConstraintName("FK_SALES_BILLING_AGRT_ORDER_ORDER_ID_SALES_FLAT_ORDER_ENTT_ID");
            });

            modelBuilder.Entity<SalesFlatCreditmemo>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_creditmemo");

                entity.ToTable("sales_flat_creditmemo");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_CREATED_AT");

                entity.HasIndex(e => e.CreditmemoStatus)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_CREDITMEMO_STATUS");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("UNQ_SALES_FLAT_CREDITMEMO_INCREMENT_ID")
                    .IsUnique();

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_ORDER_ID");

                entity.HasIndex(e => e.State)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_STATE");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_STORE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Adjustment)
                    .HasColumnName("adjustment")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AdjustmentNegative)
                    .HasColumnName("adjustment_negative")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AdjustmentPositive)
                    .HasColumnName("adjustment_positive")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AffiliateCredit)
                    .HasColumnName("affiliate_credit")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AffiliateplusDiscount)
                    .HasColumnName("affiliateplus_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAdjustment)
                    .HasColumnName("base_adjustment")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAdjustmentNegative)
                    .HasColumnName("base_adjustment_negative")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAdjustmentPositive)
                    .HasColumnName("base_adjustment_positive")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAffiliateCredit)
                    .HasColumnName("base_affiliate_credit")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAffiliateplusDiscount)
                    .HasColumnName("base_affiliateplus_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseCurrencyCode)
                    .HasColumnName("base_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGiftVoucherDiscount)
                    .HasColumnName("base_gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGrandTotal)
                    .HasColumnName("base_grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingAmount)
                    .HasColumnName("base_shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingHiddenTaxAmnt)
                    .HasColumnName("base_shipping_hidden_tax_amnt")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingInclTax)
                    .HasColumnName("base_shipping_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingTaxAmount)
                    .HasColumnName("base_shipping_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotal)
                    .HasColumnName("base_subtotal")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotalInclTax)
                    .HasColumnName("base_subtotal_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToGlobalRate)
                    .HasColumnName("base_to_global_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToOrderRate)
                    .HasColumnName("base_to_order_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseUseGiftCreditAmount)
                    .HasColumnName("base_use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BillingAddressId)
                    .HasColumnName("billing_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CreditmemoStatus)
                    .HasColumnName("creditmemo_status")
                    .HasColumnType("int(11)");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.EmailSent)
                    .HasColumnName("email_sent")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GiftVoucherDiscount)
                    .HasColumnName("gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftcardRefundAmount)
                    .HasColumnName("giftcard_refund_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftcreditBaseHiddenTaxAmount)
                    .HasColumnName("giftcredit_base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftcreditHiddenTaxAmount)
                    .HasColumnName("giftcredit_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherBaseHiddenTaxAmount)
                    .HasColumnName("giftvoucher_base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherHiddenTaxAmount)
                    .HasColumnName("giftvoucher_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GlobalCurrencyCode)
                    .HasColumnName("global_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.GrandTotal)
                    .HasColumnName("grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.InvoiceId)
                    .HasColumnName("invoice_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.OrderCurrencyCode)
                    .HasColumnName("order_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ShippingAddressId)
                    .HasColumnName("shipping_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShippingAmount)
                    .HasColumnName("shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingHiddenTaxAmount)
                    .HasColumnName("shipping_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingInclTax)
                    .HasColumnName("shipping_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingTaxAmount)
                    .HasColumnName("shipping_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.State)
                    .HasColumnName("state")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StoreCurrencyCode)
                    .HasColumnName("store_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreToBaseRate)
                    .HasColumnName("store_to_base_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.StoreToOrderRate)
                    .HasColumnName("store_to_order_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Subtotal)
                    .HasColumnName("subtotal")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SubtotalInclTax)
                    .HasColumnName("subtotal_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TransactionId)
                    .HasColumnName("transaction_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UseGiftCreditAmount)
                    .HasColumnName("use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.SalesFlatCreditmemo)
                    .HasForeignKey(d => d.OrderId)
                    .HasConstraintName("FK_SALES_FLAT_CREDITMEMO_ORDER_ID_SALES_FLAT_ORDER_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatCreditmemo)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_CREDITMEMO_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatCreditmemoComment>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_creditmemo_comment");

                entity.ToTable("sales_flat_creditmemo_comment");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_COMMENT_CREATED_AT");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_COMMENT_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Comment)
                    .HasColumnName("comment")
                    .HasColumnType("text");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.IsCustomerNotified)
                    .HasColumnName("is_customer_notified")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsVisibleOnFront)
                    .HasColumnName("is_visible_on_front")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatCreditmemoComment)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_B0FCB0B5467075BE63D474F2CD5F7804");
            });

            modelBuilder.Entity<SalesFlatCreditmemoGrid>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_creditmemo_grid");

                entity.ToTable("sales_flat_creditmemo_grid");

                entity.HasIndex(e => e.BaseGrandTotal)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_BASE_GRAND_TOTAL");

                entity.HasIndex(e => e.BillingName)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_BILLING_NAME");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_CREATED_AT");

                entity.HasIndex(e => e.CreditmemoStatus)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_CREDITMEMO_STATUS");

                entity.HasIndex(e => e.GrandTotal)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_GRAND_TOTAL");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("UNQ_SALES_FLAT_CREDITMEMO_GRID_INCREMENT_ID")
                    .IsUnique();

                entity.HasIndex(e => e.OrderCreatedAt)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_ORDER_CREATED_AT");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_ORDER_ID");

                entity.HasIndex(e => e.OrderIncrementId)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_ORDER_INCREMENT_ID");

                entity.HasIndex(e => e.State)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_STATE");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_GRID_STORE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BaseCurrencyCode)
                    .HasColumnName("base_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.BaseGrandTotal)
                    .HasColumnName("base_grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToGlobalRate)
                    .HasColumnName("base_to_global_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToOrderRate)
                    .HasColumnName("base_to_order_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BillingName)
                    .HasColumnName("billing_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CreditmemoStatus)
                    .HasColumnName("creditmemo_status")
                    .HasColumnType("int(11)");

                entity.Property(e => e.GlobalCurrencyCode)
                    .HasColumnName("global_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.GrandTotal)
                    .HasColumnName("grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.InvoiceId)
                    .HasColumnName("invoice_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.OrderCreatedAt)
                    .HasColumnName("order_created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.OrderCurrencyCode)
                    .HasColumnName("order_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderIncrementId)
                    .HasColumnName("order_increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.State)
                    .HasColumnName("state")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StoreCurrencyCode)
                    .HasColumnName("store_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreToBaseRate)
                    .HasColumnName("store_to_base_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.StoreToOrderRate)
                    .HasColumnName("store_to_order_rate")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.SalesFlatCreditmemoGrid)
                    .HasForeignKey<SalesFlatCreditmemoGrid>(d => d.EntityId)
                    .HasConstraintName("FK_78C711B225167A11CC077B03D1C8E1CC");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatCreditmemoGrid)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_CREDITMEMO_GRID_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatCreditmemoItem>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_creditmemo_item");

                entity.ToTable("sales_flat_creditmemo_item");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_CREDITMEMO_ITEM_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalData)
                    .HasColumnName("additional_data")
                    .HasColumnType("text");

                entity.Property(e => e.AffiliateplusCommissionFlag)
                    .HasColumnName("affiliateplus_commission_flag")
                    .HasColumnType("smallint(2)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.BaseCost)
                    .HasColumnName("base_cost")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGiftVoucherDiscount)
                    .HasColumnName("base_gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BasePrice)
                    .HasColumnName("base_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BasePriceInclTax)
                    .HasColumnName("base_price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseRowTotal)
                    .HasColumnName("base_row_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseRowTotalInclTax)
                    .HasColumnName("base_row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseUseGiftCreditAmount)
                    .HasColumnName("base_use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxAppliedAmount)
                    .HasColumnName("base_weee_tax_applied_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxAppliedRowAmnt)
                    .HasColumnName("base_weee_tax_applied_row_amnt")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxDisposition)
                    .HasColumnName("base_weee_tax_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxRowDisposition)
                    .HasColumnName("base_weee_tax_row_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftVoucherDiscount)
                    .HasColumnName("gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftcardRefundAmount)
                    .HasColumnName("giftcard_refund_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderItemId)
                    .HasColumnName("order_item_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PriceInclTax)
                    .HasColumnName("price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.RowTotal)
                    .HasColumnName("row_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.RowTotalInclTax)
                    .HasColumnName("row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.UseGiftCreditAmount)
                    .HasColumnName("use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxApplied)
                    .HasColumnName("weee_tax_applied")
                    .HasColumnType("text");

                entity.Property(e => e.WeeeTaxAppliedAmount)
                    .HasColumnName("weee_tax_applied_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxAppliedRowAmount)
                    .HasColumnName("weee_tax_applied_row_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxDisposition)
                    .HasColumnName("weee_tax_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxRowDisposition)
                    .HasColumnName("weee_tax_row_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatCreditmemoItem)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_306DAC836C699F0B5E13BE486557AC8A");
            });

            modelBuilder.Entity<SalesFlatInvoice>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_invoice");

                entity.ToTable("sales_flat_invoice");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_INVOICE_CREATED_AT");

                entity.HasIndex(e => e.GrandTotal)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRAND_TOTAL");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("UNQ_SALES_FLAT_INVOICE_INCREMENT_ID")
                    .IsUnique();

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_FLAT_INVOICE_ORDER_ID");

                entity.HasIndex(e => e.State)
                    .HasName("IDX_SALES_FLAT_INVOICE_STATE");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_INVOICE_STORE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AffiliateCredit)
                    .HasColumnName("affiliate_credit")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AffiliateplusDiscount)
                    .HasColumnName("affiliateplus_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAffiliateCredit)
                    .HasColumnName("base_affiliate_credit")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAffiliateplusDiscount)
                    .HasColumnName("base_affiliateplus_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseCurrencyCode)
                    .HasColumnName("base_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGiftVoucherDiscount)
                    .HasColumnName("base_gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGrandTotal)
                    .HasColumnName("base_grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingAmount)
                    .HasColumnName("base_shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingHiddenTaxAmnt)
                    .HasColumnName("base_shipping_hidden_tax_amnt")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingInclTax)
                    .HasColumnName("base_shipping_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingTaxAmount)
                    .HasColumnName("base_shipping_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotal)
                    .HasColumnName("base_subtotal")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotalInclTax)
                    .HasColumnName("base_subtotal_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToGlobalRate)
                    .HasColumnName("base_to_global_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToOrderRate)
                    .HasColumnName("base_to_order_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalRefunded)
                    .HasColumnName("base_total_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseUseGiftCreditAmount)
                    .HasColumnName("base_use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BillingAddressId)
                    .HasColumnName("billing_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CanVoidFlag)
                    .HasColumnName("can_void_flag")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.EmailSent)
                    .HasColumnName("email_sent")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GiftVoucherDiscount)
                    .HasColumnName("gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftcreditBaseHiddenTaxAmount)
                    .HasColumnName("giftcredit_base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftcreditHiddenTaxAmount)
                    .HasColumnName("giftcredit_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherBaseHiddenTaxAmount)
                    .HasColumnName("giftvoucher_base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherHiddenTaxAmount)
                    .HasColumnName("giftvoucher_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GlobalCurrencyCode)
                    .HasColumnName("global_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.GrandTotal)
                    .HasColumnName("grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.IsUsedForRefund)
                    .HasColumnName("is_used_for_refund")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.OrderCurrencyCode)
                    .HasColumnName("order_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ShippingAddressId)
                    .HasColumnName("shipping_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShippingAmount)
                    .HasColumnName("shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingHiddenTaxAmount)
                    .HasColumnName("shipping_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingInclTax)
                    .HasColumnName("shipping_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingTaxAmount)
                    .HasColumnName("shipping_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.State)
                    .HasColumnName("state")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StoreCurrencyCode)
                    .HasColumnName("store_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreToBaseRate)
                    .HasColumnName("store_to_base_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.StoreToOrderRate)
                    .HasColumnName("store_to_order_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Subtotal)
                    .HasColumnName("subtotal")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SubtotalInclTax)
                    .HasColumnName("subtotal_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalQty)
                    .HasColumnName("total_qty")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TransactionId)
                    .HasColumnName("transaction_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UseGiftCreditAmount)
                    .HasColumnName("use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.SalesFlatInvoice)
                    .HasForeignKey(d => d.OrderId)
                    .HasConstraintName("FK_SALES_FLAT_INVOICE_ORDER_ID_SALES_FLAT_ORDER_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatInvoice)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_INVOICE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatInvoiceComment>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_invoice_comment");

                entity.ToTable("sales_flat_invoice_comment");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_INVOICE_COMMENT_CREATED_AT");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_INVOICE_COMMENT_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Comment)
                    .HasColumnName("comment")
                    .HasColumnType("text");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.IsCustomerNotified)
                    .HasColumnName("is_customer_notified")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.IsVisibleOnFront)
                    .HasColumnName("is_visible_on_front")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatInvoiceComment)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_5C4B36BBE5231A76AB8018B281ED50BC");
            });

            modelBuilder.Entity<SalesFlatInvoiceGrid>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_invoice_grid");

                entity.ToTable("sales_flat_invoice_grid");

                entity.HasIndex(e => e.BillingName)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRID_BILLING_NAME");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRID_CREATED_AT");

                entity.HasIndex(e => e.GrandTotal)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRID_GRAND_TOTAL");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("UNQ_SALES_FLAT_INVOICE_GRID_INCREMENT_ID")
                    .IsUnique();

                entity.HasIndex(e => e.OrderCreatedAt)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRID_ORDER_CREATED_AT");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRID_ORDER_ID");

                entity.HasIndex(e => e.OrderIncrementId)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRID_ORDER_INCREMENT_ID");

                entity.HasIndex(e => e.State)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRID_STATE");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_INVOICE_GRID_STORE_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BaseCurrencyCode)
                    .HasColumnName("base_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.BaseGrandTotal)
                    .HasColumnName("base_grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BillingName)
                    .HasColumnName("billing_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.GlobalCurrencyCode)
                    .HasColumnName("global_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.GrandTotal)
                    .HasColumnName("grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrderCreatedAt)
                    .HasColumnName("order_created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.OrderCurrencyCode)
                    .HasColumnName("order_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderIncrementId)
                    .HasColumnName("order_increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.State)
                    .HasColumnName("state")
                    .HasColumnType("int(11)");

                entity.Property(e => e.StoreCurrencyCode)
                    .HasColumnName("store_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.SalesFlatInvoiceGrid)
                    .HasForeignKey<SalesFlatInvoiceGrid>(d => d.EntityId)
                    .HasConstraintName("FK_SALES_FLAT_INVOICE_GRID_ENTT_ID_SALES_FLAT_INVOICE_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatInvoiceGrid)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_INVOICE_GRID_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatInvoiceItem>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_invoice_item");

                entity.ToTable("sales_flat_invoice_item");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_INVOICE_ITEM_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalData)
                    .HasColumnName("additional_data")
                    .HasColumnType("text");

                entity.Property(e => e.AffiliateplusCommissionFlag)
                    .HasColumnName("affiliateplus_commission_flag")
                    .HasColumnType("smallint(2)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.BaseCost)
                    .HasColumnName("base_cost")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGiftVoucherDiscount)
                    .HasColumnName("base_gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BasePrice)
                    .HasColumnName("base_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BasePriceInclTax)
                    .HasColumnName("base_price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseRowTotal)
                    .HasColumnName("base_row_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseRowTotalInclTax)
                    .HasColumnName("base_row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseUseGiftCreditAmount)
                    .HasColumnName("base_use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxAppliedAmount)
                    .HasColumnName("base_weee_tax_applied_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxAppliedRowAmnt)
                    .HasColumnName("base_weee_tax_applied_row_amnt")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxDisposition)
                    .HasColumnName("base_weee_tax_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxRowDisposition)
                    .HasColumnName("base_weee_tax_row_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftVoucherDiscount)
                    .HasColumnName("gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderItemId)
                    .HasColumnName("order_item_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PriceInclTax)
                    .HasColumnName("price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.RowTotal)
                    .HasColumnName("row_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.RowTotalInclTax)
                    .HasColumnName("row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.UseGiftCreditAmount)
                    .HasColumnName("use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxApplied)
                    .HasColumnName("weee_tax_applied")
                    .HasColumnType("text");

                entity.Property(e => e.WeeeTaxAppliedAmount)
                    .HasColumnName("weee_tax_applied_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxAppliedRowAmount)
                    .HasColumnName("weee_tax_applied_row_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxDisposition)
                    .HasColumnName("weee_tax_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxRowDisposition)
                    .HasColumnName("weee_tax_row_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatInvoiceItem)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_SALES_FLAT_INVOICE_ITEM_PARENT_ID_SALES_FLAT_INVOICE_ENTT_ID");
            });

            modelBuilder.Entity<SalesFlatOrder>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_order");

                entity.ToTable("sales_flat_order");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_ORDER_CREATED_AT");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_SALES_FLAT_ORDER_CUSTOMER_ID");

                entity.HasIndex(e => e.ExtOrderId)
                    .HasName("IDX_SALES_FLAT_ORDER_EXT_ORDER_ID");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("UNQ_SALES_FLAT_ORDER_INCREMENT_ID")
                    .IsUnique();

                entity.HasIndex(e => e.QuoteId)
                    .HasName("IDX_SALES_FLAT_ORDER_QUOTE_ID");

                entity.HasIndex(e => e.State)
                    .HasName("IDX_SALES_FLAT_ORDER_STATE");

                entity.HasIndex(e => e.Status)
                    .HasName("IDX_SALES_FLAT_ORDER_STATUS");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_ORDER_STORE_ID");

                entity.HasIndex(e => e.UpdatedAt)
                    .HasName("IDX_SALES_FLAT_ORDER_UPDATED_AT");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdjustmentNegative)
                    .HasColumnName("adjustment_negative")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AdjustmentPositive)
                    .HasColumnName("adjustment_positive")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AffiliateCredit)
                    .HasColumnName("affiliate_credit")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AffiliateplusCoupon)
                    .HasColumnName("affiliateplus_coupon")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.AffiliateplusDiscount)
                    .HasColumnName("affiliateplus_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AppliedRuleIds)
                    .HasColumnName("applied_rule_ids")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.BaseAdjustmentNegative)
                    .HasColumnName("base_adjustment_negative")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAdjustmentPositive)
                    .HasColumnName("base_adjustment_positive")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAffiliateCredit)
                    .HasColumnName("base_affiliate_credit")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAffiliateplusDiscount)
                    .HasColumnName("base_affiliateplus_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseCurrencyCode)
                    .HasColumnName("base_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseDiscountCanceled)
                    .HasColumnName("base_discount_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseDiscountInvoiced)
                    .HasColumnName("base_discount_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseDiscountRefunded)
                    .HasColumnName("base_discount_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGiftVoucherDiscount)
                    .HasColumnName("base_gift_voucher_discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseGiftcreditDiscountForShipping)
                    .HasColumnName("base_giftcredit_discount_for_shipping")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGiftvoucherDiscountForShipping)
                    .HasColumnName("base_giftvoucher_discount_for_shipping")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGrandTotal)
                    .HasColumnName("base_grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxInvoiced)
                    .HasColumnName("base_hidden_tax_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxRefunded)
                    .HasColumnName("base_hidden_tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingAmount)
                    .HasColumnName("base_shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingCanceled)
                    .HasColumnName("base_shipping_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingDiscountAmount)
                    .HasColumnName("base_shipping_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingHiddenTaxAmnt)
                    .HasColumnName("base_shipping_hidden_tax_amnt")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingInclTax)
                    .HasColumnName("base_shipping_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingInvoiced)
                    .HasColumnName("base_shipping_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingRefunded)
                    .HasColumnName("base_shipping_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingTaxAmount)
                    .HasColumnName("base_shipping_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingTaxRefunded)
                    .HasColumnName("base_shipping_tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotal)
                    .HasColumnName("base_subtotal")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotalCanceled)
                    .HasColumnName("base_subtotal_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotalInclTax)
                    .HasColumnName("base_subtotal_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotalInvoiced)
                    .HasColumnName("base_subtotal_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotalRefunded)
                    .HasColumnName("base_subtotal_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxCanceled)
                    .HasColumnName("base_tax_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxInvoiced)
                    .HasColumnName("base_tax_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxRefunded)
                    .HasColumnName("base_tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToGlobalRate)
                    .HasColumnName("base_to_global_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToOrderRate)
                    .HasColumnName("base_to_order_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalCanceled)
                    .HasColumnName("base_total_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalDue)
                    .HasColumnName("base_total_due")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalInvoiced)
                    .HasColumnName("base_total_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalInvoicedCost)
                    .HasColumnName("base_total_invoiced_cost")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalOfflineRefunded)
                    .HasColumnName("base_total_offline_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalOnlineRefunded)
                    .HasColumnName("base_total_online_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalPaid)
                    .HasColumnName("base_total_paid")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalQtyOrdered)
                    .HasColumnName("base_total_qty_ordered")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalRefunded)
                    .HasColumnName("base_total_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseUseGiftCreditAmount)
                    .HasColumnName("base_use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BillingAddressId)
                    .HasColumnName("billing_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CanShipPartially)
                    .HasColumnName("can_ship_partially")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CanShipPartiallyItem)
                    .HasColumnName("can_ship_partially_item")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CouponCode)
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CouponRuleName)
                    .HasColumnName("coupon_rule_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CustomerDob)
                    .HasColumnName("customer_dob")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomerEmail)
                    .HasColumnName("customer_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerFirstname)
                    .HasColumnName("customer_firstname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerGender)
                    .HasColumnName("customer_gender")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerIsGuest)
                    .HasColumnName("customer_is_guest")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CustomerLastname)
                    .HasColumnName("customer_lastname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerMiddlename)
                    .HasColumnName("customer_middlename")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerNote)
                    .HasColumnName("customer_note")
                    .HasColumnType("text");

                entity.Property(e => e.CustomerNoteNotify)
                    .HasColumnName("customer_note_notify")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CustomerPrefix)
                    .HasColumnName("customer_prefix")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerSuffix)
                    .HasColumnName("customer_suffix")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerTaxvat)
                    .HasColumnName("customer_taxvat")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.DiscountCanceled)
                    .HasColumnName("discount_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.DiscountDescription)
                    .HasColumnName("discount_description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.DiscountInvoiced)
                    .HasColumnName("discount_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.DiscountRefunded)
                    .HasColumnName("discount_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.EbizmartsAbandonedcartFlag)
                    .HasColumnName("ebizmarts_abandonedcart_flag")
                    .HasColumnType("int(1)");

                entity.Property(e => e.EbizmartsMagemonkeyCampaignId)
                    .HasColumnName("ebizmarts_magemonkey_campaign_id")
                    .HasColumnType("varchar(10)");

                entity.Property(e => e.EditIncrement)
                    .HasColumnName("edit_increment")
                    .HasColumnType("int(11)");

                entity.Property(e => e.EmailSent)
                    .HasColumnName("email_sent")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.ExtCustomerId)
                    .HasColumnName("ext_customer_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ExtOrderId)
                    .HasColumnName("ext_order_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ForcedShipmentWithInvoice)
                    .HasColumnName("forced_shipment_with_invoice")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.GiftMessageId)
                    .HasColumnName("gift_message_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.GiftVoucherDiscount)
                    .HasColumnName("gift_voucher_discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftcreditBaseHiddenTaxAmount)
                    .HasColumnName("giftcredit_base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftcreditBaseShippingHiddenTaxAmount)
                    .HasColumnName("giftcredit_base_shipping_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftcreditDiscountForShipping)
                    .HasColumnName("giftcredit_discount_for_shipping")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftcreditHiddenTaxAmount)
                    .HasColumnName("giftcredit_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftcreditShippingHiddenTaxAmount)
                    .HasColumnName("giftcredit_shipping_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherBaseHiddenTaxAmount)
                    .HasColumnName("giftvoucher_base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherBaseShippingHiddenTaxAmount)
                    .HasColumnName("giftvoucher_base_shipping_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherDiscountForShipping)
                    .HasColumnName("giftvoucher_discount_for_shipping")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftvoucherHiddenTaxAmount)
                    .HasColumnName("giftvoucher_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherShippingHiddenTaxAmount)
                    .HasColumnName("giftvoucher_shipping_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GlobalCurrencyCode)
                    .HasColumnName("global_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.GrandTotal)
                    .HasColumnName("grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxInvoiced)
                    .HasColumnName("hidden_tax_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxRefunded)
                    .HasColumnName("hidden_tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HoldBeforeState)
                    .HasColumnName("hold_before_state")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.HoldBeforeStatus)
                    .HasColumnName("hold_before_status")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.IsVirtual)
                    .HasColumnName("is_virtual")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.MailchimpAbandonedcartFlag)
                    .HasColumnName("mailchimp_abandonedcart_flag")
                    .HasColumnType("int(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MailchimpCampaignId)
                    .HasColumnName("mailchimp_campaign_id")
                    .HasColumnType("varchar(16)");

                entity.Property(e => e.MailchimpSyncDelta)
                    .HasColumnName("mailchimp_sync_delta")
                    .HasColumnType("datetime");

                entity.Property(e => e.MailchimpSyncError)
                    .IsRequired()
                    .HasColumnName("mailchimp_sync_error")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OnestepcheckoutGiftwrapAmount)
                    .HasColumnName("onestepcheckout_giftwrap_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OnestepcheckoutOrderComment)
                    .HasColumnName("onestepcheckout_order_comment")
                    .HasColumnType("text");

                entity.Property(e => e.OrderCurrencyCode)
                    .HasColumnName("order_currency_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OriginalIncrementId)
                    .HasColumnName("original_increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.PaymentAuthExpiration)
                    .HasColumnName("payment_auth_expiration")
                    .HasColumnType("int(11)");

                entity.Property(e => e.PaymentAuthorizationAmount)
                    .HasColumnName("payment_authorization_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PaypalIpnCustomerNotified)
                    .HasColumnName("paypal_ipn_customer_notified")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProtectCode)
                    .HasColumnName("protect_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.QuoteAddressId)
                    .HasColumnName("quote_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RelationChildId)
                    .HasColumnName("relation_child_id")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.RelationChildRealId)
                    .HasColumnName("relation_child_real_id")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.RelationParentId)
                    .HasColumnName("relation_parent_id")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.RelationParentRealId)
                    .HasColumnName("relation_parent_real_id")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.RemoteIp)
                    .HasColumnName("remote_ip")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ShippingAddressId)
                    .HasColumnName("shipping_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShippingAmount)
                    .HasColumnName("shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingCanceled)
                    .HasColumnName("shipping_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingDescription)
                    .HasColumnName("shipping_description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ShippingDiscountAmount)
                    .HasColumnName("shipping_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingHiddenTaxAmount)
                    .HasColumnName("shipping_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingInclTax)
                    .HasColumnName("shipping_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingInvoiced)
                    .HasColumnName("shipping_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingMethod)
                    .HasColumnName("shipping_method")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ShippingRefunded)
                    .HasColumnName("shipping_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingTaxAmount)
                    .HasColumnName("shipping_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingTaxRefunded)
                    .HasColumnName("shipping_tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.State)
                    .HasColumnName("state")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.StoreCurrencyCode)
                    .HasColumnName("store_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreName)
                    .HasColumnName("store_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreToBaseRate)
                    .HasColumnName("store_to_base_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.StoreToOrderRate)
                    .HasColumnName("store_to_order_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Subtotal)
                    .HasColumnName("subtotal")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SubtotalCanceled)
                    .HasColumnName("subtotal_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SubtotalInclTax)
                    .HasColumnName("subtotal_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SubtotalInvoiced)
                    .HasColumnName("subtotal_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SubtotalRefunded)
                    .HasColumnName("subtotal_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxCanceled)
                    .HasColumnName("tax_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxInvoiced)
                    .HasColumnName("tax_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxRefunded)
                    .HasColumnName("tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalCanceled)
                    .HasColumnName("total_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalDue)
                    .HasColumnName("total_due")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalInvoiced)
                    .HasColumnName("total_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalItemCount)
                    .HasColumnName("total_item_count")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TotalOfflineRefunded)
                    .HasColumnName("total_offline_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalOnlineRefunded)
                    .HasColumnName("total_online_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalPaid)
                    .HasColumnName("total_paid")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalQtyOrdered)
                    .HasColumnName("total_qty_ordered")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalRefunded)
                    .HasColumnName("total_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.UseGiftCreditAmount)
                    .HasColumnName("use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.XForwardedFor)
                    .HasColumnName("x_forwarded_for")
                    .HasColumnType("varchar(255)");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.SalesFlatOrder)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatOrder)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatOrderAddress>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_order_address");

                entity.ToTable("sales_flat_order_address");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_ORDER_ADDRESS_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddressType)
                    .HasColumnName("address_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.City)
                    .HasColumnName("city")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Company)
                    .HasColumnName("company")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CountryId)
                    .HasColumnName("country_id")
                    .HasColumnType("varchar(2)");

                entity.Property(e => e.CustomerAddressId)
                    .HasColumnName("customer_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Email)
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Fax)
                    .HasColumnName("fax")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Firstname)
                    .HasColumnName("firstname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Lastname)
                    .HasColumnName("lastname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Middlename)
                    .HasColumnName("middlename")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Postcode)
                    .HasColumnName("postcode")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Prefix)
                    .HasColumnName("prefix")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.QuoteAddressId)
                    .HasColumnName("quote_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Region)
                    .HasColumnName("region")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RegionId)
                    .HasColumnName("region_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Street)
                    .HasColumnName("street")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Suffix)
                    .HasColumnName("suffix")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Telephone)
                    .HasColumnName("telephone")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.VatId)
                    .HasColumnName("vat_id")
                    .HasColumnType("text");

                entity.Property(e => e.VatIsValid)
                    .HasColumnName("vat_is_valid")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.VatRequestDate)
                    .HasColumnName("vat_request_date")
                    .HasColumnType("text");

                entity.Property(e => e.VatRequestId)
                    .HasColumnName("vat_request_id")
                    .HasColumnType("text");

                entity.Property(e => e.VatRequestSuccess)
                    .HasColumnName("vat_request_success")
                    .HasColumnType("smallint(6)");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatOrderAddress)
                    .HasForeignKey(d => d.ParentId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_ADDRESS_PARENT_ID_SALES_FLAT_ORDER_ENTITY_ID");
            });

            modelBuilder.Entity<SalesFlatOrderGrid>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_order_grid");

                entity.ToTable("sales_flat_order_grid");

                entity.HasIndex(e => e.BaseGrandTotal)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_BASE_GRAND_TOTAL");

                entity.HasIndex(e => e.BaseTotalPaid)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_BASE_TOTAL_PAID");

                entity.HasIndex(e => e.BillingName)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_BILLING_NAME");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_CREATED_AT");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_CUSTOMER_ID");

                entity.HasIndex(e => e.GrandTotal)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_GRAND_TOTAL");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("UNQ_SALES_FLAT_ORDER_GRID_INCREMENT_ID")
                    .IsUnique();

                entity.HasIndex(e => e.ShippingName)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_SHIPPING_NAME");

                entity.HasIndex(e => e.Status)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_STATUS");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_STORE_ID");

                entity.HasIndex(e => e.TotalPaid)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_TOTAL_PAID");

                entity.HasIndex(e => e.UpdatedAt)
                    .HasName("IDX_SALES_FLAT_ORDER_GRID_UPDATED_AT");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BaseCurrencyCode)
                    .HasColumnName("base_currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.BaseGrandTotal)
                    .HasColumnName("base_grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTotalPaid)
                    .HasColumnName("base_total_paid")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BillingName)
                    .HasColumnName("billing_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.GrandTotal)
                    .HasColumnName("grand_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrderCurrencyCode)
                    .HasColumnName("order_currency_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ShippingName)
                    .HasColumnName("shipping_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.StoreName)
                    .HasColumnName("store_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TotalPaid)
                    .HasColumnName("total_paid")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.SalesFlatOrderGrid)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_GRID_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.SalesFlatOrderGrid)
                    .HasForeignKey<SalesFlatOrderGrid>(d => d.EntityId)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_GRID_ENTITY_ID_SALES_FLAT_ORDER_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatOrderGrid)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_GRID_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatOrderItem>(entity =>
            {
                entity.HasKey(e => e.ItemId)
                    .HasName("PK_sales_flat_order_item");

                entity.ToTable("sales_flat_order_item");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_FLAT_ORDER_ITEM_ORDER_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_ORDER_ITEM_STORE_ID");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalData)
                    .HasColumnName("additional_data")
                    .HasColumnType("text");

                entity.Property(e => e.AffiliateplusAmount)
                    .HasColumnName("affiliateplus_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.AffiliateplusCommission)
                    .HasColumnName("affiliateplus_commission")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.AffiliateplusCommissionItem)
                    .HasColumnName("affiliateplus_commission_item")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AffiliateplusCredit)
                    .HasColumnName("affiliateplus_credit")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.AmountRefunded)
                    .HasColumnName("amount_refunded")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.AppliedRuleIds)
                    .HasColumnName("applied_rule_ids")
                    .HasColumnType("text");

                entity.Property(e => e.BaseAffiliateplusAmount)
                    .HasColumnName("base_affiliateplus_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseAffiliateplusCredit)
                    .HasColumnName("base_affiliateplus_credit")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseAmountRefunded)
                    .HasColumnName("base_amount_refunded")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseCost)
                    .HasColumnName("base_cost")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseDiscountInvoiced)
                    .HasColumnName("base_discount_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseDiscountRefunded)
                    .HasColumnName("base_discount_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseGiftVoucherDiscount)
                    .HasColumnName("base_gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxInvoiced)
                    .HasColumnName("base_hidden_tax_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseHiddenTaxRefunded)
                    .HasColumnName("base_hidden_tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseOriginalPrice)
                    .HasColumnName("base_original_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BasePrice)
                    .HasColumnName("base_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BasePriceInclTax)
                    .HasColumnName("base_price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseRowInvoiced)
                    .HasColumnName("base_row_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseRowTotal)
                    .HasColumnName("base_row_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseRowTotalInclTax)
                    .HasColumnName("base_row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseTaxBeforeDiscount)
                    .HasColumnName("base_tax_before_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxInvoiced)
                    .HasColumnName("base_tax_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseTaxRefunded)
                    .HasColumnName("base_tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseUseGiftCreditAmount)
                    .HasColumnName("base_use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxAppliedAmount)
                    .HasColumnName("base_weee_tax_applied_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxAppliedRowAmnt)
                    .HasColumnName("base_weee_tax_applied_row_amnt")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxDisposition)
                    .HasColumnName("base_weee_tax_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxRowDisposition)
                    .HasColumnName("base_weee_tax_row_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountInvoiced)
                    .HasColumnName("discount_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountPercent)
                    .HasColumnName("discount_percent")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountRefunded)
                    .HasColumnName("discount_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ExtOrderItemId)
                    .HasColumnName("ext_order_item_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FreeShipping)
                    .HasColumnName("free_shipping")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GiftMessageAvailable)
                    .HasColumnName("gift_message_available")
                    .HasColumnType("int(11)");

                entity.Property(e => e.GiftMessageId)
                    .HasColumnName("gift_message_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.GiftVoucherDiscount)
                    .HasColumnName("gift_voucher_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GiftcreditBaseHiddenTaxAmount)
                    .HasColumnName("giftcredit_base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftcreditHiddenTaxAmount)
                    .HasColumnName("giftcredit_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherBaseHiddenTaxAmount)
                    .HasColumnName("giftvoucher_base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.GiftvoucherHiddenTaxAmount)
                    .HasColumnName("giftvoucher_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxCanceled)
                    .HasColumnName("hidden_tax_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxInvoiced)
                    .HasColumnName("hidden_tax_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.HiddenTaxRefunded)
                    .HasColumnName("hidden_tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.IsNominal)
                    .HasColumnName("is_nominal")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsQtyDecimal)
                    .HasColumnName("is_qty_decimal")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.IsVirtual)
                    .HasColumnName("is_virtual")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.LockedDoInvoice)
                    .HasColumnName("locked_do_invoice")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.LockedDoShip)
                    .HasColumnName("locked_do_ship")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NoDiscount)
                    .HasColumnName("no_discount")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OriginalPrice)
                    .HasColumnName("original_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ParentItemId)
                    .HasColumnName("parent_item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.PriceInclTax)
                    .HasColumnName("price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductOptions)
                    .HasColumnName("product_options")
                    .HasColumnType("text");

                entity.Property(e => e.ProductType)
                    .HasColumnName("product_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.QtyBackordered)
                    .HasColumnName("qty_backordered")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyCanceled)
                    .HasColumnName("qty_canceled")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyInvoiced)
                    .HasColumnName("qty_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyOrdered)
                    .HasColumnName("qty_ordered")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyRefunded)
                    .HasColumnName("qty_refunded")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QtyShipped)
                    .HasColumnName("qty_shipped")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QuoteItemId)
                    .HasColumnName("quote_item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.RowInvoiced)
                    .HasColumnName("row_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RowTotal)
                    .HasColumnName("row_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RowTotalInclTax)
                    .HasColumnName("row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.RowWeight)
                    .HasColumnName("row_weight")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TaxBeforeDiscount)
                    .HasColumnName("tax_before_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxCanceled)
                    .HasColumnName("tax_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxInvoiced)
                    .HasColumnName("tax_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TaxPercent)
                    .HasColumnName("tax_percent")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TaxRefunded)
                    .HasColumnName("tax_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.UseGiftCreditAmount)
                    .HasColumnName("use_gift_credit_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxApplied)
                    .HasColumnName("weee_tax_applied")
                    .HasColumnType("text");

                entity.Property(e => e.WeeeTaxAppliedAmount)
                    .HasColumnName("weee_tax_applied_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxAppliedRowAmount)
                    .HasColumnName("weee_tax_applied_row_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxDisposition)
                    .HasColumnName("weee_tax_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxRowDisposition)
                    .HasColumnName("weee_tax_row_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.SalesFlatOrderItem)
                    .HasForeignKey(d => d.OrderId)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_ITEM_ORDER_ID_SALES_FLAT_ORDER_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatOrderItem)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_ITEM_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatOrderPayment>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_order_payment");

                entity.ToTable("sales_flat_order_payment");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_ORDER_PAYMENT_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AccountStatus)
                    .HasColumnName("account_status")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AdditionalData)
                    .HasColumnName("additional_data")
                    .HasColumnType("text");

                entity.Property(e => e.AdditionalInformation)
                    .HasColumnName("additional_information")
                    .HasColumnType("text");

                entity.Property(e => e.AddressStatus)
                    .HasColumnName("address_status")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AmountAuthorized)
                    .HasColumnName("amount_authorized")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AmountCanceled)
                    .HasColumnName("amount_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AmountOrdered)
                    .HasColumnName("amount_ordered")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AmountPaid)
                    .HasColumnName("amount_paid")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AmountRefunded)
                    .HasColumnName("amount_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.AnetTransMethod)
                    .HasColumnName("anet_trans_method")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.BaseAmountAuthorized)
                    .HasColumnName("base_amount_authorized")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAmountCanceled)
                    .HasColumnName("base_amount_canceled")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAmountOrdered)
                    .HasColumnName("base_amount_ordered")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAmountPaid)
                    .HasColumnName("base_amount_paid")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAmountPaidOnline)
                    .HasColumnName("base_amount_paid_online")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAmountRefunded)
                    .HasColumnName("base_amount_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAmountRefundedOnline)
                    .HasColumnName("base_amount_refunded_online")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingAmount)
                    .HasColumnName("base_shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingCaptured)
                    .HasColumnName("base_shipping_captured")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingRefunded)
                    .HasColumnName("base_shipping_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CcApproval)
                    .HasColumnName("cc_approval")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcAvsStatus)
                    .HasColumnName("cc_avs_status")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcCidStatus)
                    .HasColumnName("cc_cid_status")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcDebugRequestBody)
                    .HasColumnName("cc_debug_request_body")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcDebugResponseBody)
                    .HasColumnName("cc_debug_response_body")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcDebugResponseSerialized)
                    .HasColumnName("cc_debug_response_serialized")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcExpMonth)
                    .HasColumnName("cc_exp_month")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcExpYear)
                    .HasColumnName("cc_exp_year")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcLast4)
                    .HasColumnName("cc_last4")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcNumberEnc)
                    .HasColumnName("cc_number_enc")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcOwner)
                    .HasColumnName("cc_owner")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcSecureVerify)
                    .HasColumnName("cc_secure_verify")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcSsIssue)
                    .HasColumnName("cc_ss_issue")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcSsStartMonth)
                    .HasColumnName("cc_ss_start_month")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcSsStartYear)
                    .HasColumnName("cc_ss_start_year")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcStatus)
                    .HasColumnName("cc_status")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcStatusDescription)
                    .HasColumnName("cc_status_description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcTransId)
                    .HasColumnName("cc_trans_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcType)
                    .HasColumnName("cc_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EcheckAccountName)
                    .HasColumnName("echeck_account_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EcheckAccountType)
                    .HasColumnName("echeck_account_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EcheckBankName)
                    .HasColumnName("echeck_bank_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EcheckRoutingNumber)
                    .HasColumnName("echeck_routing_number")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EcheckType)
                    .HasColumnName("echeck_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.LastTransId)
                    .HasColumnName("last_trans_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Method)
                    .HasColumnName("method")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.PayboxRequestNumber)
                    .HasColumnName("paybox_request_number")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PoNumber)
                    .HasColumnName("po_number")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProtectionEligibility)
                    .HasColumnName("protection_eligibility")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.QuotePaymentId)
                    .HasColumnName("quote_payment_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShippingAmount)
                    .HasColumnName("shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingCaptured)
                    .HasColumnName("shipping_captured")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingRefunded)
                    .HasColumnName("shipping_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatOrderPayment)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_SALES_FLAT_ORDER_PAYMENT_PARENT_ID_SALES_FLAT_ORDER_ENTITY_ID");
            });

            modelBuilder.Entity<SalesFlatOrderStatusHistory>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_order_status_history");

                entity.ToTable("sales_flat_order_status_history");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_ORDER_STATUS_HISTORY_CREATED_AT");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_ORDER_STATUS_HISTORY_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Comment)
                    .HasColumnName("comment")
                    .HasColumnType("text");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.EntityName)
                    .HasColumnName("entity_name")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.IsCustomerNotified)
                    .HasColumnName("is_customer_notified")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsVisibleOnFront)
                    .HasColumnName("is_visible_on_front")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("varchar(32)");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatOrderStatusHistory)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_CE7C71E74CB74DDACED337CEE6753D5E");
            });

            modelBuilder.Entity<SalesFlatQuote>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_quote");

                entity.ToTable("sales_flat_quote");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_QUOTE_STORE_ID");

                entity.HasIndex(e => new { e.CustomerId, e.StoreId, e.IsActive })
                    .HasName("IDX_SALES_FLAT_QUOTE_CUSTOMER_ID_STORE_ID_IS_ACTIVE");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AppliedRuleIds)
                    .HasColumnName("applied_rule_ids")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.BaseCurrencyCode)
                    .HasColumnName("base_currency_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.BaseGrandTotal)
                    .HasColumnName("base_grand_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseSubtotal)
                    .HasColumnName("base_subtotal")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotalWithDiscount)
                    .HasColumnName("base_subtotal_with_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToGlobalRate)
                    .HasColumnName("base_to_global_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseToQuoteRate)
                    .HasColumnName("base_to_quote_rate")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CheckoutMethod)
                    .HasColumnName("checkout_method")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ConvertedAt)
                    .HasColumnName("converted_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CouponCode)
                    .HasColumnName("coupon_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerDob)
                    .HasColumnName("customer_dob")
                    .HasColumnType("datetime");

                entity.Property(e => e.CustomerEmail)
                    .HasColumnName("customer_email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerFirstname)
                    .HasColumnName("customer_firstname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerGender)
                    .HasColumnName("customer_gender")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CustomerIsGuest)
                    .HasColumnName("customer_is_guest")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CustomerLastname)
                    .HasColumnName("customer_lastname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerMiddlename)
                    .HasColumnName("customer_middlename")
                    .HasColumnType("varchar(40)");

                entity.Property(e => e.CustomerNote)
                    .HasColumnName("customer_note")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CustomerNoteNotify)
                    .HasColumnName("customer_note_notify")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.CustomerPrefix)
                    .HasColumnName("customer_prefix")
                    .HasColumnType("varchar(40)");

                entity.Property(e => e.CustomerSuffix)
                    .HasColumnName("customer_suffix")
                    .HasColumnType("varchar(40)");

                entity.Property(e => e.CustomerTaxClassId)
                    .HasColumnName("customer_tax_class_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CustomerTaxvat)
                    .HasColumnName("customer_taxvat")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.EbizmartsAbandonedcartCounter)
                    .HasColumnName("ebizmarts_abandonedcart_counter")
                    .HasColumnType("int(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EbizmartsAbandonedcartFlag)
                    .HasColumnName("ebizmarts_abandonedcart_flag")
                    .HasColumnType("int(5)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.EbizmartsAbandonedcartToken)
                    .HasColumnName("ebizmarts_abandonedcart_token")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ExtShippingInfo)
                    .HasColumnName("ext_shipping_info")
                    .HasColumnType("text");

                entity.Property(e => e.GiftMessageId)
                    .HasColumnName("gift_message_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.GiftcardsDiscount)
                    .HasColumnName("giftcards_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.GlobalCurrencyCode)
                    .HasColumnName("global_currency_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.GrandTotal)
                    .HasColumnName("grand_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsChanged)
                    .HasColumnName("is_changed")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.IsMultiShipping)
                    .HasColumnName("is_multi_shipping")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsPersistent)
                    .HasColumnName("is_persistent")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsVirtual)
                    .HasColumnName("is_virtual")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ItemsCount)
                    .HasColumnName("items_count")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ItemsQty)
                    .HasColumnName("items_qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.MailchimpAbandonedcartFlag)
                    .HasColumnName("mailchimp_abandonedcart_flag")
                    .HasColumnType("int(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MailchimpDeleted)
                    .HasColumnName("mailchimp_deleted")
                    .HasColumnType("int(1)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.MailchimpSyncDelta)
                    .HasColumnName("mailchimp_sync_delta")
                    .HasColumnType("datetime");

                entity.Property(e => e.MailchimpSyncError)
                    .IsRequired()
                    .HasColumnName("mailchimp_sync_error")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.MailchimpToken)
                    .IsRequired()
                    .HasColumnName("mailchimp_token")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrigOrderId)
                    .HasColumnName("orig_order_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.PasswordHash)
                    .HasColumnName("password_hash")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.QuoteCurrencyCode)
                    .HasColumnName("quote_currency_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RemoteIp)
                    .HasColumnName("remote_ip")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.ReservedOrderId)
                    .HasColumnName("reserved_order_id")
                    .HasColumnType("varchar(64)");

                entity.Property(e => e.StoreCurrencyCode)
                    .HasColumnName("store_currency_code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StoreToBaseRate)
                    .HasColumnName("store_to_base_rate")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.StoreToQuoteRate)
                    .HasColumnName("store_to_quote_rate")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Subtotal)
                    .HasColumnName("subtotal")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SubtotalWithDiscount)
                    .HasColumnName("subtotal_with_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TriggerRecollect)
                    .HasColumnName("trigger_recollect")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.UseGiftcards)
                    .HasColumnName("use_giftcards")
                    .HasColumnType("tinyint(1)");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatQuote)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_SALES_FLAT_QUOTE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatQuoteAddress>(entity =>
            {
                entity.HasKey(e => e.AddressId)
                    .HasName("PK_sales_flat_quote_address");

                entity.ToTable("sales_flat_quote_address");

                entity.HasIndex(e => e.QuoteId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ADDRESS_QUOTE_ID");

                entity.Property(e => e.AddressId)
                    .HasColumnName("address_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddressType)
                    .HasColumnName("address_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.AppliedTaxes)
                    .HasColumnName("applied_taxes")
                    .HasColumnType("text");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseGrandTotal)
                    .HasColumnName("base_grand_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingAmount)
                    .HasColumnName("base_shipping_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseShippingDiscountAmount)
                    .HasColumnName("base_shipping_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingHiddenTaxAmnt)
                    .HasColumnName("base_shipping_hidden_tax_amnt")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingInclTax)
                    .HasColumnName("base_shipping_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseShippingTaxAmount)
                    .HasColumnName("base_shipping_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotal)
                    .HasColumnName("base_subtotal")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseSubtotalTotalInclTax)
                    .HasColumnName("base_subtotal_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseSubtotalWithDiscount)
                    .HasColumnName("base_subtotal_with_discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.City)
                    .HasColumnName("city")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CollectShippingRates)
                    .HasColumnName("collect_shipping_rates")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Company)
                    .HasColumnName("company")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CountryId)
                    .HasColumnName("country_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerAddressId)
                    .HasColumnName("customer_address_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerNotes)
                    .HasColumnName("customer_notes")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountDescription)
                    .HasColumnName("discount_description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Email)
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Fax)
                    .HasColumnName("fax")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Firstname)
                    .HasColumnName("firstname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.FreeShipping)
                    .HasColumnName("free_shipping")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GiftMessageId)
                    .HasColumnName("gift_message_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.GrandTotal)
                    .HasColumnName("grand_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Lastname)
                    .HasColumnName("lastname")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Middlename)
                    .HasColumnName("middlename")
                    .HasColumnType("varchar(40)");

                entity.Property(e => e.Postcode)
                    .HasColumnName("postcode")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Prefix)
                    .HasColumnName("prefix")
                    .HasColumnType("varchar(40)");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Region)
                    .HasColumnName("region")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RegionId)
                    .HasColumnName("region_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.SameAsBilling)
                    .HasColumnName("same_as_billing")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SaveInAddressBook)
                    .HasColumnName("save_in_address_book")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ShippingAmount)
                    .HasColumnName("shipping_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.ShippingDescription)
                    .HasColumnName("shipping_description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ShippingDiscountAmount)
                    .HasColumnName("shipping_discount_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingHiddenTaxAmount)
                    .HasColumnName("shipping_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingInclTax)
                    .HasColumnName("shipping_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ShippingMethod)
                    .HasColumnName("shipping_method")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ShippingTaxAmount)
                    .HasColumnName("shipping_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Street)
                    .HasColumnName("street")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Subtotal)
                    .HasColumnName("subtotal")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.SubtotalInclTax)
                    .HasColumnName("subtotal_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.SubtotalWithDiscount)
                    .HasColumnName("subtotal_with_discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Suffix)
                    .HasColumnName("suffix")
                    .HasColumnType("varchar(40)");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Telephone)
                    .HasColumnName("telephone")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.VatId)
                    .HasColumnName("vat_id")
                    .HasColumnType("text");

                entity.Property(e => e.VatIsValid)
                    .HasColumnName("vat_is_valid")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.VatRequestDate)
                    .HasColumnName("vat_request_date")
                    .HasColumnType("text");

                entity.Property(e => e.VatRequestId)
                    .HasColumnName("vat_request_id")
                    .HasColumnType("text");

                entity.Property(e => e.VatRequestSuccess)
                    .HasColumnName("vat_request_success")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Quote)
                    .WithMany(p => p.SalesFlatQuoteAddress)
                    .HasForeignKey(d => d.QuoteId)
                    .HasConstraintName("FK_SALES_FLAT_QUOTE_ADDRESS_QUOTE_ID_SALES_FLAT_QUOTE_ENTITY_ID");
            });

            modelBuilder.Entity<SalesFlatQuoteAddressItem>(entity =>
            {
                entity.HasKey(e => e.AddressItemId)
                    .HasName("PK_sales_flat_quote_address_item");

                entity.ToTable("sales_flat_quote_address_item");

                entity.HasIndex(e => e.ParentItemId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ADDRESS_ITEM_PARENT_ITEM_ID");

                entity.HasIndex(e => e.QuoteAddressId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ADDRESS_ITEM_QUOTE_ADDRESS_ID");

                entity.HasIndex(e => e.QuoteItemId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ADDRESS_ITEM_QUOTE_ITEM_ID");

                entity.Property(e => e.AddressItemId)
                    .HasColumnName("address_item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalData)
                    .HasColumnName("additional_data")
                    .HasColumnType("text");

                entity.Property(e => e.AppliedRuleIds)
                    .HasColumnName("applied_rule_ids")
                    .HasColumnType("text");

                entity.Property(e => e.BaseCost)
                    .HasColumnName("base_cost")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BasePrice)
                    .HasColumnName("base_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BasePriceInclTax)
                    .HasColumnName("base_price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseRowTotal)
                    .HasColumnName("base_row_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseRowTotalInclTax)
                    .HasColumnName("base_row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountPercent)
                    .HasColumnName("discount_percent")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.FreeShipping)
                    .HasColumnName("free_shipping")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.GiftMessageId)
                    .HasColumnName("gift_message_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Image)
                    .HasColumnName("image")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.IsQtyDecimal)
                    .HasColumnName("is_qty_decimal")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NoDiscount)
                    .HasColumnName("no_discount")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentItemId)
                    .HasColumnName("parent_item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentProductId)
                    .HasColumnName("parent_product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.PriceInclTax)
                    .HasColumnName("price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QuoteAddressId)
                    .HasColumnName("quote_address_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.QuoteItemId)
                    .HasColumnName("quote_item_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RowTotal)
                    .HasColumnName("row_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RowTotalInclTax)
                    .HasColumnName("row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.RowTotalWithDiscount)
                    .HasColumnName("row_total_with_discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RowWeight)
                    .HasColumnName("row_weight")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SuperProductId)
                    .HasColumnName("super_product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TaxPercent)
                    .HasColumnName("tax_percent")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.ParentItem)
                    .WithMany(p => p.InverseParentItem)
                    .HasForeignKey(d => d.ParentItemId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_A345FC758F20C314169CE27DCE53477F");

                entity.HasOne(d => d.QuoteAddress)
                    .WithMany(p => p.SalesFlatQuoteAddressItem)
                    .HasForeignKey(d => d.QuoteAddressId)
                    .HasConstraintName("FK_B521389746C00700D1B2B76EBBE53854");

                entity.HasOne(d => d.QuoteItem)
                    .WithMany(p => p.SalesFlatQuoteAddressItem)
                    .HasForeignKey(d => d.QuoteItemId)
                    .HasConstraintName("FK_2EF8E28181D666D94D4E30DC2B0F80BF");
            });

            modelBuilder.Entity<SalesFlatQuoteItem>(entity =>
            {
                entity.HasKey(e => e.ItemId)
                    .HasName("PK_sales_flat_quote_item");

                entity.ToTable("sales_flat_quote_item");

                entity.HasIndex(e => e.ParentItemId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ITEM_PARENT_ITEM_ID");

                entity.HasIndex(e => e.ProductId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ITEM_PRODUCT_ID");

                entity.HasIndex(e => e.QuoteId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ITEM_QUOTE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ITEM_STORE_ID");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalData)
                    .HasColumnName("additional_data")
                    .HasColumnType("text");

                entity.Property(e => e.AppliedRuleIds)
                    .HasColumnName("applied_rule_ids")
                    .HasColumnType("text");

                entity.Property(e => e.BaseCost)
                    .HasColumnName("base_cost")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseDiscountAmount)
                    .HasColumnName("base_discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseHiddenTaxAmount)
                    .HasColumnName("base_hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BasePrice)
                    .HasColumnName("base_price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BasePriceInclTax)
                    .HasColumnName("base_price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseRowTotal)
                    .HasColumnName("base_row_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseRowTotalInclTax)
                    .HasColumnName("base_row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseTaxAmount)
                    .HasColumnName("base_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.BaseTaxBeforeDiscount)
                    .HasColumnName("base_tax_before_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxAppliedAmount)
                    .HasColumnName("base_weee_tax_applied_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxAppliedRowAmnt)
                    .HasColumnName("base_weee_tax_applied_row_amnt")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxDisposition)
                    .HasColumnName("base_weee_tax_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseWeeeTaxRowDisposition)
                    .HasColumnName("base_weee_tax_row_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomPrice)
                    .HasColumnName("custom_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountPercent)
                    .HasColumnName("discount_percent")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.FreeShipping)
                    .HasColumnName("free_shipping")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.GiftMessageId)
                    .HasColumnName("gift_message_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.HiddenTaxAmount)
                    .HasColumnName("hidden_tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.IsQtyDecimal)
                    .HasColumnName("is_qty_decimal")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.IsVirtual)
                    .HasColumnName("is_virtual")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NoDiscount)
                    .HasColumnName("no_discount")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OriginalCustomPrice)
                    .HasColumnName("original_custom_price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ParentItemId)
                    .HasColumnName("parent_item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.PriceInclTax)
                    .HasColumnName("price_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductType)
                    .HasColumnName("product_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RedirectUrl)
                    .HasColumnName("redirect_url")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RowTotal)
                    .HasColumnName("row_total")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RowTotalInclTax)
                    .HasColumnName("row_total_incl_tax")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.RowTotalWithDiscount)
                    .HasColumnName("row_total_with_discount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.RowWeight)
                    .HasColumnName("row_weight")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TaxBeforeDiscount)
                    .HasColumnName("tax_before_discount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TaxPercent)
                    .HasColumnName("tax_percent")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.WeeeTaxApplied)
                    .HasColumnName("weee_tax_applied")
                    .HasColumnType("text");

                entity.Property(e => e.WeeeTaxAppliedAmount)
                    .HasColumnName("weee_tax_applied_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxAppliedRowAmount)
                    .HasColumnName("weee_tax_applied_row_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxDisposition)
                    .HasColumnName("weee_tax_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.WeeeTaxRowDisposition)
                    .HasColumnName("weee_tax_row_disposition")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.ParentItem)
                    .WithMany(p => p.InverseParentItem)
                    .HasForeignKey(d => d.ParentItemId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_B201DEB5DE51B791AF5C5BF87053C5A7");

                entity.HasOne(d => d.Product)
                    .WithMany(p => p.SalesFlatQuoteItem)
                    .HasForeignKey(d => d.ProductId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_SALES_FLAT_QUOTE_ITEM_PRD_ID_CAT_PRD_ENTT_ENTT_ID");

                entity.HasOne(d => d.Quote)
                    .WithMany(p => p.SalesFlatQuoteItem)
                    .HasForeignKey(d => d.QuoteId)
                    .HasConstraintName("FK_SALES_FLAT_QUOTE_ITEM_QUOTE_ID_SALES_FLAT_QUOTE_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatQuoteItem)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_QUOTE_ITEM_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatQuoteItemOption>(entity =>
            {
                entity.HasKey(e => e.OptionId)
                    .HasName("PK_sales_flat_quote_item_option");

                entity.ToTable("sales_flat_quote_item_option");

                entity.HasIndex(e => e.ItemId)
                    .HasName("IDX_SALES_FLAT_QUOTE_ITEM_OPTION_ITEM_ID");

                entity.Property(e => e.OptionId)
                    .HasColumnName("option_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Value)
                    .HasColumnName("value")
                    .HasColumnType("text");

                entity.HasOne(d => d.Item)
                    .WithMany(p => p.SalesFlatQuoteItemOption)
                    .HasForeignKey(d => d.ItemId)
                    .HasConstraintName("FK_5F20E478CA64B6891EA8A9D6C2735739");
            });

            modelBuilder.Entity<SalesFlatQuotePayment>(entity =>
            {
                entity.HasKey(e => e.PaymentId)
                    .HasName("PK_sales_flat_quote_payment");

                entity.ToTable("sales_flat_quote_payment");

                entity.HasIndex(e => e.QuoteId)
                    .HasName("IDX_SALES_FLAT_QUOTE_PAYMENT_QUOTE_ID");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalData)
                    .HasColumnName("additional_data")
                    .HasColumnType("text");

                entity.Property(e => e.AdditionalInformation)
                    .HasColumnName("additional_information")
                    .HasColumnType("text");

                entity.Property(e => e.CcCidEnc)
                    .HasColumnName("cc_cid_enc")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcExpMonth)
                    .HasColumnName("cc_exp_month")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CcExpYear)
                    .HasColumnName("cc_exp_year")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CcLast4)
                    .HasColumnName("cc_last4")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcNumberEnc)
                    .HasColumnName("cc_number_enc")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcOwner)
                    .HasColumnName("cc_owner")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcSsIssue)
                    .HasColumnName("cc_ss_issue")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcSsOwner)
                    .HasColumnName("cc_ss_owner")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CcSsStartMonth)
                    .HasColumnName("cc_ss_start_month")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CcSsStartYear)
                    .HasColumnName("cc_ss_start_year")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CcType)
                    .HasColumnName("cc_type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Method)
                    .HasColumnName("method")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PaypalCorrelationId)
                    .HasColumnName("paypal_correlation_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PaypalPayerId)
                    .HasColumnName("paypal_payer_id")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PaypalPayerStatus)
                    .HasColumnName("paypal_payer_status")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PoNumber)
                    .HasColumnName("po_number")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Quote)
                    .WithMany(p => p.SalesFlatQuotePayment)
                    .HasForeignKey(d => d.QuoteId)
                    .HasConstraintName("FK_SALES_FLAT_QUOTE_PAYMENT_QUOTE_ID_SALES_FLAT_QUOTE_ENTITY_ID");
            });

            modelBuilder.Entity<SalesFlatQuoteShippingRate>(entity =>
            {
                entity.HasKey(e => e.RateId)
                    .HasName("PK_sales_flat_quote_shipping_rate");

                entity.ToTable("sales_flat_quote_shipping_rate");

                entity.HasIndex(e => e.AddressId)
                    .HasName("IDX_SALES_FLAT_QUOTE_SHIPPING_RATE_ADDRESS_ID");

                entity.Property(e => e.RateId)
                    .HasColumnName("rate_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AddressId)
                    .HasColumnName("address_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Carrier)
                    .HasColumnName("carrier")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CarrierTitle)
                    .HasColumnName("carrier_title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.ErrorMessage)
                    .HasColumnName("error_message")
                    .HasColumnType("text");

                entity.Property(e => e.Method)
                    .HasColumnName("method")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.MethodDescription)
                    .HasColumnName("method_description")
                    .HasColumnType("text");

                entity.Property(e => e.MethodTitle)
                    .HasColumnName("method_title")
                    .HasColumnType("text");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.HasOne(d => d.Address)
                    .WithMany(p => p.SalesFlatQuoteShippingRate)
                    .HasForeignKey(d => d.AddressId)
                    .HasConstraintName("FK_B1F177EFB73D3EDF5322BA64AC48D150");
            });

            modelBuilder.Entity<SalesFlatShipment>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_shipment");

                entity.ToTable("sales_flat_shipment");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_CREATED_AT");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("UNQ_SALES_FLAT_SHIPMENT_INCREMENT_ID")
                    .IsUnique();

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_ORDER_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_STORE_ID");

                entity.HasIndex(e => e.TotalQty)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_TOTAL_QTY");

                entity.HasIndex(e => e.UpdatedAt)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_UPDATED_AT");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.BillingAddressId)
                    .HasColumnName("billing_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.EmailSent)
                    .HasColumnName("email_sent")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Packages)
                    .HasColumnName("packages")
                    .HasColumnType("text");

                entity.Property(e => e.ShipmentStatus)
                    .HasColumnName("shipment_status")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShippingAddressId)
                    .HasColumnName("shipping_address_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShippingLabel)
                    .HasColumnName("shipping_label")
                    .HasColumnType("mediumblob");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TotalQty)
                    .HasColumnName("total_qty")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalWeight)
                    .HasColumnName("total_weight")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.SalesFlatShipment)
                    .HasForeignKey(d => d.OrderId)
                    .HasConstraintName("FK_SALES_FLAT_SHIPMENT_ORDER_ID_SALES_FLAT_ORDER_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatShipment)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_SHIPMENT_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatShipmentComment>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_shipment_comment");

                entity.ToTable("sales_flat_shipment_comment");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_COMMENT_CREATED_AT");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_COMMENT_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Comment)
                    .HasColumnName("comment")
                    .HasColumnType("text");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.IsCustomerNotified)
                    .HasColumnName("is_customer_notified")
                    .HasColumnType("int(11)");

                entity.Property(e => e.IsVisibleOnFront)
                    .HasColumnName("is_visible_on_front")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatShipmentComment)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_C2D69CC1FB03D2B2B794B0439F6650CF");
            });

            modelBuilder.Entity<SalesFlatShipmentGrid>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_shipment_grid");

                entity.ToTable("sales_flat_shipment_grid");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_GRID_CREATED_AT");

                entity.HasIndex(e => e.IncrementId)
                    .HasName("UNQ_SALES_FLAT_SHIPMENT_GRID_INCREMENT_ID")
                    .IsUnique();

                entity.HasIndex(e => e.OrderCreatedAt)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_GRID_ORDER_CREATED_AT");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_GRID_ORDER_ID");

                entity.HasIndex(e => e.OrderIncrementId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_GRID_ORDER_INCREMENT_ID");

                entity.HasIndex(e => e.ShipmentStatus)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_GRID_SHIPMENT_STATUS");

                entity.HasIndex(e => e.ShippingName)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_GRID_SHIPPING_NAME");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_GRID_STORE_ID");

                entity.HasIndex(e => e.TotalQty)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_GRID_TOTAL_QTY");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.IncrementId)
                    .IsRequired()
                    .HasColumnName("increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrderCreatedAt)
                    .HasColumnName("order_created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderIncrementId)
                    .HasColumnName("order_increment_id")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.ShipmentStatus)
                    .HasColumnName("shipment_status")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ShippingName)
                    .HasColumnName("shipping_name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TotalQty)
                    .HasColumnName("total_qty")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Entity)
                    .WithOne(p => p.SalesFlatShipmentGrid)
                    .HasForeignKey<SalesFlatShipmentGrid>(d => d.EntityId)
                    .HasConstraintName("FK_SALES_FLAT_SHIPMENT_GRID_ENTT_ID_SALES_FLAT_SHIPMENT_ENTT_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesFlatShipmentGrid)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_FLAT_SHIPMENT_GRID_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesFlatShipmentItem>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_shipment_item");

                entity.ToTable("sales_flat_shipment_item");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_ITEM_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalData)
                    .HasColumnName("additional_data")
                    .HasColumnType("text");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderItemId)
                    .HasColumnName("order_item_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.ProductId)
                    .HasColumnName("product_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.RowTotal)
                    .HasColumnName("row_total")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Sku)
                    .HasColumnName("sku")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatShipmentItem)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_3AECE5007D18F159231B87E8306FC02A");
            });

            modelBuilder.Entity<SalesFlatShipmentTrack>(entity =>
            {
                entity.HasKey(e => e.EntityId)
                    .HasName("PK_sales_flat_shipment_track");

                entity.ToTable("sales_flat_shipment_track");

                entity.HasIndex(e => e.CreatedAt)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_TRACK_CREATED_AT");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_TRACK_ORDER_ID");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_FLAT_SHIPMENT_TRACK_PARENT_ID");

                entity.Property(e => e.EntityId)
                    .HasColumnName("entity_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CarrierCode)
                    .HasColumnName("carrier_code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Qty)
                    .HasColumnName("qty")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.TrackNumber)
                    .HasColumnName("track_number")
                    .HasColumnType("text");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Weight)
                    .HasColumnName("weight")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.SalesFlatShipmentTrack)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("FK_BCD2FA28717D29F37E10A153E6F2F841");
            });

            modelBuilder.Entity<SalesInvoicedAggregated>(entity =>
            {
                entity.ToTable("sales_invoiced_aggregated");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_INVOICED_AGGREGATED_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus })
                    .HasName("UNQ_SALES_INVOICED_AGGREGATED_PERIOD_STORE_ID_ORDER_STATUS")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Invoiced)
                    .HasColumnName("invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.InvoicedCaptured)
                    .HasColumnName("invoiced_captured")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.InvoicedNotCaptured)
                    .HasColumnName("invoiced_not_captured")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrdersCount)
                    .HasColumnName("orders_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OrdersInvoiced)
                    .HasColumnName("orders_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesInvoicedAggregated)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_INVOICED_AGGREGATED_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesInvoicedAggregatedOrder>(entity =>
            {
                entity.ToTable("sales_invoiced_aggregated_order");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_INVOICED_AGGREGATED_ORDER_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus })
                    .HasName("UNQ_SALES_INVOICED_AGGREGATED_ORDER_PERIOD_STORE_ID_ORDER_STATUS")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Invoiced)
                    .HasColumnName("invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.InvoicedCaptured)
                    .HasColumnName("invoiced_captured")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.InvoicedNotCaptured)
                    .HasColumnName("invoiced_not_captured")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrdersCount)
                    .HasColumnName("orders_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OrdersInvoiced)
                    .HasColumnName("orders_invoiced")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesInvoicedAggregatedOrder)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_INVOICED_AGGREGATED_ORDER_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesOrderAggregatedCreated>(entity =>
            {
                entity.ToTable("sales_order_aggregated_created");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_ORDER_AGGREGATED_CREATED_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus })
                    .HasName("UNQ_SALES_ORDER_AGGREGATED_CREATED_PERIOD_STORE_ID_ORDER_STATUS")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrdersCount)
                    .HasColumnName("orders_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TotalCanceledAmount)
                    .HasColumnName("total_canceled_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalDiscountAmount)
                    .HasColumnName("total_discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalDiscountAmountActual)
                    .HasColumnName("total_discount_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalIncomeAmount)
                    .HasColumnName("total_income_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalInvoicedAmount)
                    .HasColumnName("total_invoiced_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalPaidAmount)
                    .HasColumnName("total_paid_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalProfitAmount)
                    .HasColumnName("total_profit_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalQtyInvoiced)
                    .HasColumnName("total_qty_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalQtyOrdered)
                    .HasColumnName("total_qty_ordered")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalRefundedAmount)
                    .HasColumnName("total_refunded_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalRevenueAmount)
                    .HasColumnName("total_revenue_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalShippingAmount)
                    .HasColumnName("total_shipping_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalShippingAmountActual)
                    .HasColumnName("total_shipping_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalTaxAmount)
                    .HasColumnName("total_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalTaxAmountActual)
                    .HasColumnName("total_tax_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesOrderAggregatedCreated)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_ORDER_AGGREGATED_CREATED_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesOrderAggregatedUpdated>(entity =>
            {
                entity.ToTable("sales_order_aggregated_updated");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_ORDER_AGGREGATED_UPDATED_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus })
                    .HasName("UNQ_SALES_ORDER_AGGREGATED_UPDATED_PERIOD_STORE_ID_ORDER_STATUS")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrdersCount)
                    .HasColumnName("orders_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TotalCanceledAmount)
                    .HasColumnName("total_canceled_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalDiscountAmount)
                    .HasColumnName("total_discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalDiscountAmountActual)
                    .HasColumnName("total_discount_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalIncomeAmount)
                    .HasColumnName("total_income_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalInvoicedAmount)
                    .HasColumnName("total_invoiced_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalPaidAmount)
                    .HasColumnName("total_paid_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalProfitAmount)
                    .HasColumnName("total_profit_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalQtyInvoiced)
                    .HasColumnName("total_qty_invoiced")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalQtyOrdered)
                    .HasColumnName("total_qty_ordered")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalRefundedAmount)
                    .HasColumnName("total_refunded_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalRevenueAmount)
                    .HasColumnName("total_revenue_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalShippingAmount)
                    .HasColumnName("total_shipping_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalShippingAmountActual)
                    .HasColumnName("total_shipping_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalTaxAmount)
                    .HasColumnName("total_tax_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.TotalTaxAmountActual)
                    .HasColumnName("total_tax_amount_actual")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesOrderAggregatedUpdated)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_ORDER_AGGREGATED_UPDATED_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesOrderStatus>(entity =>
            {
                entity.HasKey(e => e.Status)
                    .HasName("PK_sales_order_status");

                entity.ToTable("sales_order_status");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.Label)
                    .IsRequired()
                    .HasColumnName("label")
                    .HasColumnType("varchar(128)");
            });

            modelBuilder.Entity<SalesOrderStatusLabel>(entity =>
            {
                entity.HasKey(e => new { e.Status, e.StoreId })
                    .HasName("PK_sales_order_status_label");

                entity.ToTable("sales_order_status_label");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_ORDER_STATUS_LABEL_STORE_ID");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.Label)
                    .IsRequired()
                    .HasColumnName("label")
                    .HasColumnType("varchar(128)");

                entity.HasOne(d => d.StatusNavigation)
                    .WithMany(p => p.SalesOrderStatusLabel)
                    .HasForeignKey(d => d.Status)
                    .HasConstraintName("FK_SALES_ORDER_STATUS_LABEL_STATUS_SALES_ORDER_STATUS_STATUS");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesOrderStatusLabel)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_SALES_ORDER_STATUS_LABEL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesOrderStatusState>(entity =>
            {
                entity.HasKey(e => new { e.Status, e.State })
                    .HasName("PK_sales_order_status_state");

                entity.ToTable("sales_order_status_state");

                entity.Property(e => e.Status)
                    .HasColumnName("status")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.State)
                    .HasColumnName("state")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.IsDefault)
                    .HasColumnName("is_default")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.StatusNavigation)
                    .WithMany(p => p.SalesOrderStatusState)
                    .HasForeignKey(d => d.Status)
                    .HasConstraintName("FK_SALES_ORDER_STATUS_STATE_STATUS_SALES_ORDER_STATUS_STATUS");
            });

            modelBuilder.Entity<SalesOrderTax>(entity =>
            {
                entity.HasKey(e => e.TaxId)
                    .HasName("PK_sales_order_tax");

                entity.ToTable("sales_order_tax");

                entity.HasIndex(e => new { e.OrderId, e.Priority, e.Position })
                    .HasName("IDX_SALES_ORDER_TAX_ORDER_ID_PRIORITY_POSITION");

                entity.Property(e => e.TaxId)
                    .HasColumnName("tax_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Amount)
                    .HasColumnName("amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseAmount)
                    .HasColumnName("base_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.BaseRealAmount)
                    .HasColumnName("base_real_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Hidden)
                    .HasColumnName("hidden")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Percent)
                    .HasColumnName("percent")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.Position)
                    .HasColumnName("position")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Priority)
                    .HasColumnName("priority")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Process)
                    .HasColumnName("process")
                    .HasColumnType("smallint(6)");

                entity.Property(e => e.Title)
                    .HasColumnName("title")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<SalesOrderTaxItem>(entity =>
            {
                entity.HasKey(e => e.TaxItemId)
                    .HasName("PK_sales_order_tax_item");

                entity.ToTable("sales_order_tax_item");

                entity.HasIndex(e => e.ItemId)
                    .HasName("IDX_SALES_ORDER_TAX_ITEM_ITEM_ID");

                entity.HasIndex(e => e.TaxId)
                    .HasName("IDX_SALES_ORDER_TAX_ITEM_TAX_ID");

                entity.HasIndex(e => new { e.TaxId, e.ItemId })
                    .HasName("UNQ_SALES_ORDER_TAX_ITEM_TAX_ID_ITEM_ID")
                    .IsUnique();

                entity.Property(e => e.TaxItemId)
                    .HasColumnName("tax_item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ItemId)
                    .HasColumnName("item_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.TaxId)
                    .HasColumnName("tax_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.TaxPercent)
                    .HasColumnName("tax_percent")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Item)
                    .WithMany(p => p.SalesOrderTaxItem)
                    .HasForeignKey(d => d.ItemId)
                    .HasConstraintName("FK_SALES_ORDER_TAX_ITEM_ITEM_ID_SALES_FLAT_ORDER_ITEM_ITEM_ID");

                entity.HasOne(d => d.Tax)
                    .WithMany(p => p.SalesOrderTaxItem)
                    .HasForeignKey(d => d.TaxId)
                    .HasConstraintName("FK_SALES_ORDER_TAX_ITEM_TAX_ID_SALES_ORDER_TAX_TAX_ID");
            });

            modelBuilder.Entity<SalesPaymentTransaction>(entity =>
            {
                entity.HasKey(e => e.TransactionId)
                    .HasName("PK_sales_payment_transaction");

                entity.ToTable("sales_payment_transaction");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_PAYMENT_TRANSACTION_ORDER_ID");

                entity.HasIndex(e => e.ParentId)
                    .HasName("IDX_SALES_PAYMENT_TRANSACTION_PARENT_ID");

                entity.HasIndex(e => e.PaymentId)
                    .HasName("IDX_SALES_PAYMENT_TRANSACTION_PAYMENT_ID");

                entity.HasIndex(e => new { e.OrderId, e.PaymentId, e.TxnId })
                    .HasName("UNQ_SALES_PAYMENT_TRANSACTION_ORDER_ID_PAYMENT_ID_TXN_ID")
                    .IsUnique();

                entity.Property(e => e.TransactionId)
                    .HasColumnName("transaction_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalInformation)
                    .HasColumnName("additional_information")
                    .HasColumnType("blob");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.IsClosed)
                    .HasColumnName("is_closed")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ParentTxnId)
                    .HasColumnName("parent_txn_id")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.PaymentId)
                    .HasColumnName("payment_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TxnId)
                    .IsRequired()
                    .HasColumnName("txn_id")
                    .HasColumnType("varchar(100)");

                entity.Property(e => e.TxnType)
                    .HasColumnName("txn_type")
                    .HasColumnType("varchar(15)");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.SalesPaymentTransaction)
                    .HasForeignKey(d => d.OrderId)
                    .HasConstraintName("FK_SALES_PAYMENT_TRANSACTION_ORDER_ID_SALES_FLAT_ORDER_ENTITY_ID");

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.InverseParent)
                    .HasForeignKey(d => d.ParentId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_B99FF1A06402D725EBDB0F3A7ECD47A2");

                entity.HasOne(d => d.Payment)
                    .WithMany(p => p.SalesPaymentTransaction)
                    .HasForeignKey(d => d.PaymentId)
                    .HasConstraintName("FK_DA51A10B2405B64A4DAEF77A64F0DAAD");
            });

            modelBuilder.Entity<SalesRecurringProfile>(entity =>
            {
                entity.HasKey(e => e.ProfileId)
                    .HasName("PK_sales_recurring_profile");

                entity.ToTable("sales_recurring_profile");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_SALES_RECURRING_PROFILE_CUSTOMER_ID");

                entity.HasIndex(e => e.InternalReferenceId)
                    .HasName("UNQ_SALES_RECURRING_PROFILE_INTERNAL_REFERENCE_ID")
                    .IsUnique();

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_RECURRING_PROFILE_STORE_ID");

                entity.Property(e => e.ProfileId)
                    .HasColumnName("profile_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.AdditionalInfo)
                    .HasColumnName("additional_info")
                    .HasColumnType("text");

                entity.Property(e => e.BillFailedLater)
                    .HasColumnName("bill_failed_later")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.BillingAddressInfo)
                    .IsRequired()
                    .HasColumnName("billing_address_info")
                    .HasColumnType("text");

                entity.Property(e => e.BillingAmount)
                    .HasColumnName("billing_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CurrencyCode)
                    .IsRequired()
                    .HasColumnName("currency_code")
                    .HasColumnType("varchar(3)");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.InitAmount)
                    .HasColumnName("init_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.InitMayFail)
                    .HasColumnName("init_may_fail")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.InternalReferenceId)
                    .IsRequired()
                    .HasColumnName("internal_reference_id")
                    .HasColumnType("varchar(42)");

                entity.Property(e => e.MethodCode)
                    .IsRequired()
                    .HasColumnName("method_code")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.OrderInfo)
                    .IsRequired()
                    .HasColumnName("order_info")
                    .HasColumnType("text");

                entity.Property(e => e.OrderItemInfo)
                    .IsRequired()
                    .HasColumnName("order_item_info")
                    .HasColumnType("text");

                entity.Property(e => e.PeriodFrequency)
                    .HasColumnName("period_frequency")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.PeriodMaxCycles)
                    .HasColumnName("period_max_cycles")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.PeriodUnit)
                    .IsRequired()
                    .HasColumnName("period_unit")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.ProfileVendorInfo)
                    .HasColumnName("profile_vendor_info")
                    .HasColumnType("text");

                entity.Property(e => e.ReferenceId)
                    .HasColumnName("reference_id")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.ScheduleDescription)
                    .IsRequired()
                    .HasColumnName("schedule_description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ShippingAddressInfo)
                    .HasColumnName("shipping_address_info")
                    .HasColumnType("text");

                entity.Property(e => e.ShippingAmount)
                    .HasColumnName("shipping_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.StartDatetime)
                    .HasColumnName("start_datetime")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("0000-00-00 00:00:00");

                entity.Property(e => e.State)
                    .IsRequired()
                    .HasColumnName("state")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.SubscriberName)
                    .HasColumnName("subscriber_name")
                    .HasColumnType("varchar(150)");

                entity.Property(e => e.SuspensionThreshold)
                    .HasColumnName("suspension_threshold")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TaxAmount)
                    .HasColumnName("tax_amount")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TrialBillingAmount)
                    .HasColumnName("trial_billing_amount")
                    .HasColumnType("text");

                entity.Property(e => e.TrialPeriodFrequency)
                    .HasColumnName("trial_period_frequency")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TrialPeriodMaxCycles)
                    .HasColumnName("trial_period_max_cycles")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TrialPeriodUnit)
                    .HasColumnName("trial_period_unit")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.UpdatedAt)
                    .HasColumnName("updated_at")
                    .HasColumnType("timestamp");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.SalesRecurringProfile)
                    .HasForeignKey(d => d.CustomerId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_RECURRING_PROFILE_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesRecurringProfile)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_RECURRING_PROFILE_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesRecurringProfileOrder>(entity =>
            {
                entity.HasKey(e => e.LinkId)
                    .HasName("PK_sales_recurring_profile_order");

                entity.ToTable("sales_recurring_profile_order");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_SALES_RECURRING_PROFILE_ORDER_ORDER_ID");

                entity.HasIndex(e => new { e.ProfileId, e.OrderId })
                    .HasName("UNQ_SALES_RECURRING_PROFILE_ORDER_PROFILE_ID_ORDER_ID")
                    .IsUnique();

                entity.Property(e => e.LinkId)
                    .HasColumnName("link_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ProfileId)
                    .HasColumnName("profile_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.SalesRecurringProfileOrder)
                    .HasForeignKey(d => d.OrderId)
                    .HasConstraintName("FK_7FF85741C66DCD37A4FBE3E3255A5A01");

                entity.HasOne(d => d.Profile)
                    .WithMany(p => p.SalesRecurringProfileOrder)
                    .HasForeignKey(d => d.ProfileId)
                    .HasConstraintName("FK_B8A7A5397B67455786E55461748C59F4");
            });

            modelBuilder.Entity<SalesRefundedAggregated>(entity =>
            {
                entity.ToTable("sales_refunded_aggregated");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_REFUNDED_AGGREGATED_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus })
                    .HasName("UNQ_SALES_REFUNDED_AGGREGATED_PERIOD_STORE_ID_ORDER_STATUS")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OfflineRefunded)
                    .HasColumnName("offline_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OnlineRefunded)
                    .HasColumnName("online_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrdersCount)
                    .HasColumnName("orders_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.Refunded)
                    .HasColumnName("refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesRefundedAggregated)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_REFUNDED_AGGREGATED_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesRefundedAggregatedOrder>(entity =>
            {
                entity.ToTable("sales_refunded_aggregated_order");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_REFUNDED_AGGREGATED_ORDER_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus })
                    .HasName("UNQ_SALES_REFUNDED_AGGREGATED_ORDER_PERIOD_STORE_ID_ORDER_STATUS")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OfflineRefunded)
                    .HasColumnName("offline_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OnlineRefunded)
                    .HasColumnName("online_refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrdersCount)
                    .HasColumnName("orders_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.Refunded)
                    .HasColumnName("refunded")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesRefundedAggregatedOrder)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_REFUNDED_AGGREGATED_ORDER_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesShippingAggregated>(entity =>
            {
                entity.ToTable("sales_shipping_aggregated");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_SHIPPING_AGGREGATED_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus, e.ShippingDescription })
                    .HasName("UNQ_SALES_SHPP_AGGRED_PERIOD_STORE_ID_ORDER_STS_SHPP_DESCRIPTION")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrdersCount)
                    .HasColumnName("orders_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.ShippingDescription)
                    .IsRequired()
                    .HasColumnName("shipping_description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TotalShipping)
                    .HasColumnName("total_shipping")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalShippingActual)
                    .HasColumnName("total_shipping_actual")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesShippingAggregated)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_SHIPPING_AGGREGATED_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesShippingAggregatedOrder>(entity =>
            {
                entity.ToTable("sales_shipping_aggregated_order");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALES_SHIPPING_AGGREGATED_ORDER_STORE_ID");

                entity.HasIndex(e => new { e.Period, e.StoreId, e.OrderStatus, e.ShippingDescription })
                    .HasName("C05FAE47282EEA68654D0924E946761F")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.OrderStatus)
                    .IsRequired()
                    .HasColumnName("order_status")
                    .HasColumnType("varchar(50)");

                entity.Property(e => e.OrdersCount)
                    .HasColumnName("orders_count")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Period)
                    .IsRequired()
                    .HasColumnName("period")
                    .HasColumnType("date");

                entity.Property(e => e.ShippingDescription)
                    .IsRequired()
                    .HasColumnName("shipping_description")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .IsRequired()
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.TotalShipping)
                    .HasColumnName("total_shipping")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.TotalShippingActual)
                    .HasColumnName("total_shipping_actual")
                    .HasColumnType("decimal(12,4)");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesShippingAggregatedOrder)
                    .HasForeignKey(d => d.StoreId)
                    .OnDelete(DeleteBehavior.SetNull)
                    .HasConstraintName("FK_SALES_SHIPPING_AGGREGATED_ORDER_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<Salesrule>(entity =>
            {
                entity.HasKey(e => e.RuleId)
                    .HasName("PK_salesrule");

                entity.ToTable("salesrule");

                entity.HasIndex(e => new { e.IsActive, e.SortOrder, e.ToDate, e.FromDate })
                    .HasName("IDX_SALESRULE_IS_ACTIVE_SORT_ORDER_TO_DATE_FROM_DATE");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ActionsSerialized)
                    .HasColumnName("actions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.ApplyToShipping)
                    .HasColumnName("apply_to_shipping")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ConditionsSerialized)
                    .HasColumnName("conditions_serialized")
                    .HasColumnType("mediumtext");

                entity.Property(e => e.CouponType)
                    .HasColumnName("coupon_type")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasColumnType("text");

                entity.Property(e => e.DiscountAmount)
                    .HasColumnName("discount_amount")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DiscountQty)
                    .HasColumnName("discount_qty")
                    .HasColumnType("decimal(12,4)");

                entity.Property(e => e.DiscountStep)
                    .HasColumnName("discount_step")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.FromDate)
                    .HasColumnName("from_date")
                    .HasColumnType("date");

                entity.Property(e => e.IsActive)
                    .HasColumnName("is_active")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsAdvanced)
                    .HasColumnName("is_advanced")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsRss)
                    .HasColumnName("is_rss")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.IsUseGiftcard)
                    .HasColumnName("is_use_giftcard")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.ProductIds)
                    .HasColumnName("product_ids")
                    .HasColumnType("text");

                entity.Property(e => e.SimpleAction)
                    .HasColumnName("simple_action")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.SimpleFreeShipping)
                    .HasColumnName("simple_free_shipping")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.SortOrder)
                    .HasColumnName("sort_order")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.StopRulesProcessing)
                    .HasColumnName("stop_rules_processing")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.TimesUsed)
                    .HasColumnName("times_used")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.ToDate)
                    .HasColumnName("to_date")
                    .HasColumnType("date");

                entity.Property(e => e.UseAutoGeneration)
                    .HasColumnName("use_auto_generation")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UsesPerCoupon)
                    .HasColumnName("uses_per_coupon")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UsesPerCustomer)
                    .HasColumnName("uses_per_customer")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<SalesruleCoupon>(entity =>
            {
                entity.HasKey(e => e.CouponId)
                    .HasName("PK_salesrule_coupon");

                entity.ToTable("salesrule_coupon");

                entity.HasIndex(e => e.Code)
                    .HasName("UNQ_SALESRULE_COUPON_CODE")
                    .IsUnique();

                entity.HasIndex(e => e.RuleId)
                    .HasName("IDX_SALESRULE_COUPON_RULE_ID");

                entity.HasIndex(e => new { e.RuleId, e.IsPrimary })
                    .HasName("UNQ_SALESRULE_COUPON_RULE_ID_IS_PRIMARY")
                    .IsUnique();

                entity.Property(e => e.CouponId)
                    .HasColumnName("coupon_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp");

                entity.Property(e => e.ExpirationDate)
                    .HasColumnName("expiration_date")
                    .HasColumnType("timestamp");

                entity.Property(e => e.IsPrimary)
                    .IsRequired()
                    .HasColumnName("is_primary")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.TimesUsed)
                    .HasColumnName("times_used")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasColumnType("smallint(6)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.UsageLimit)
                    .HasColumnName("usage_limit")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.UsagePerCustomer)
                    .HasColumnName("usage_per_customer")
                    .HasColumnType("int(10) unsigned");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.SalesruleCoupon)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_SALESRULE_COUPON_RULE_ID_SALESRULE_RULE_ID");
            });

            modelBuilder.Entity<SalesruleCouponUsage>(entity =>
            {
                entity.HasKey(e => new { e.CouponId, e.CustomerId })
                    .HasName("PK_salesrule_coupon_usage");

                entity.ToTable("salesrule_coupon_usage");

                entity.HasIndex(e => e.CouponId)
                    .HasName("IDX_SALESRULE_COUPON_USAGE_COUPON_ID");

                entity.HasIndex(e => e.CustomerId)
                    .HasName("IDX_SALESRULE_COUPON_USAGE_CUSTOMER_ID");

                entity.Property(e => e.CouponId)
                    .HasColumnName("coupon_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.TimesUsed)
                    .HasColumnName("times_used")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Coupon)
                    .WithMany(p => p.SalesruleCouponUsage)
                    .HasForeignKey(d => d.CouponId)
                    .HasConstraintName("FK_SALESRULE_COUPON_USAGE_COUPON_ID_SALESRULE_COUPON_COUPON_ID");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.SalesruleCouponUsage)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("FK_SALESRULE_COUPON_USAGE_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");
            });

            modelBuilder.Entity<SalesruleCustomer>(entity =>
            {
                entity.HasKey(e => e.RuleCustomerId)
                    .HasName("PK_salesrule_customer");

                entity.ToTable("salesrule_customer");

                entity.HasIndex(e => new { e.CustomerId, e.RuleId })
                    .HasName("IDX_SALESRULE_CUSTOMER_CUSTOMER_ID_RULE_ID");

                entity.HasIndex(e => new { e.RuleId, e.CustomerId })
                    .HasName("IDX_SALESRULE_CUSTOMER_RULE_ID_CUSTOMER_ID");

                entity.Property(e => e.RuleCustomerId)
                    .HasColumnName("rule_customer_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.TimesUsed)
                    .HasColumnName("times_used")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Customer)
                    .WithMany(p => p.SalesruleCustomer)
                    .HasForeignKey(d => d.CustomerId)
                    .HasConstraintName("FK_SALESRULE_CUSTOMER_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.SalesruleCustomer)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_SALESRULE_CUSTOMER_RULE_ID_SALESRULE_RULE_ID");
            });

            modelBuilder.Entity<SalesruleCustomerGroup>(entity =>
            {
                entity.HasKey(e => new { e.RuleId, e.CustomerGroupId })
                    .HasName("PK_salesrule_customer_group");

                entity.ToTable("salesrule_customer_group");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_SALESRULE_CUSTOMER_GROUP_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.RuleId)
                    .HasName("IDX_SALESRULE_CUSTOMER_GROUP_RULE_ID");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.SalesruleCustomerGroup)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_SALESRULE_CSTR_GROUP_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.SalesruleCustomerGroup)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_SALESRULE_CUSTOMER_GROUP_RULE_ID_SALESRULE_RULE_ID");
            });

            modelBuilder.Entity<SalesruleLabel>(entity =>
            {
                entity.HasKey(e => e.LabelId)
                    .HasName("PK_salesrule_label");

                entity.ToTable("salesrule_label");

                entity.HasIndex(e => e.RuleId)
                    .HasName("IDX_SALESRULE_LABEL_RULE_ID");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SALESRULE_LABEL_STORE_ID");

                entity.HasIndex(e => new { e.RuleId, e.StoreId })
                    .HasName("UNQ_SALESRULE_LABEL_RULE_ID_STORE_ID")
                    .IsUnique();

                entity.Property(e => e.LabelId)
                    .HasColumnName("label_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Label)
                    .HasColumnName("label")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.SalesruleLabel)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_SALESRULE_LABEL_RULE_ID_SALESRULE_RULE_ID");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.SalesruleLabel)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_SALESRULE_LABEL_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SalesruleProductAttribute>(entity =>
            {
                entity.HasKey(e => new { e.RuleId, e.WebsiteId, e.CustomerGroupId, e.AttributeId })
                    .HasName("PK_salesrule_product_attribute");

                entity.ToTable("salesrule_product_attribute");

                entity.HasIndex(e => e.AttributeId)
                    .HasName("IDX_SALESRULE_PRODUCT_ATTRIBUTE_ATTRIBUTE_ID");

                entity.HasIndex(e => e.CustomerGroupId)
                    .HasName("IDX_SALESRULE_PRODUCT_ATTRIBUTE_CUSTOMER_GROUP_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_SALESRULE_PRODUCT_ATTRIBUTE_WEBSITE_ID");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.CustomerGroupId)
                    .HasColumnName("customer_group_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.Property(e => e.AttributeId)
                    .HasColumnName("attribute_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Attribute)
                    .WithMany(p => p.SalesruleProductAttribute)
                    .HasForeignKey(d => d.AttributeId)
                    .HasConstraintName("FK_SALESRULE_PRD_ATTR_ATTR_ID_EAV_ATTR_ATTR_ID");

                entity.HasOne(d => d.CustomerGroup)
                    .WithMany(p => p.SalesruleProductAttribute)
                    .HasForeignKey(d => d.CustomerGroupId)
                    .HasConstraintName("FK_SALESRULE_PRD_ATTR_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.SalesruleProductAttribute)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_SALESRULE_PRODUCT_ATTRIBUTE_RULE_ID_SALESRULE_RULE_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.SalesruleProductAttribute)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_SALESRULE_PRD_ATTR_WS_ID_CORE_WS_WS_ID");
            });

            modelBuilder.Entity<SalesruleWebsite>(entity =>
            {
                entity.HasKey(e => new { e.RuleId, e.WebsiteId })
                    .HasName("PK_salesrule_website");

                entity.ToTable("salesrule_website");

                entity.HasIndex(e => e.RuleId)
                    .HasName("IDX_SALESRULE_WEBSITE_RULE_ID");

                entity.HasIndex(e => e.WebsiteId)
                    .HasName("IDX_SALESRULE_WEBSITE_WEBSITE_ID");

                entity.Property(e => e.RuleId)
                    .HasColumnName("rule_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned");

                entity.HasOne(d => d.Rule)
                    .WithMany(p => p.SalesruleWebsite)
                    .HasForeignKey(d => d.RuleId)
                    .HasConstraintName("FK_SALESRULE_WEBSITE_RULE_ID_SALESRULE_RULE_ID");

                entity.HasOne(d => d.Website)
                    .WithMany(p => p.SalesruleWebsite)
                    .HasForeignKey(d => d.WebsiteId)
                    .HasConstraintName("FK_SALESRULE_WEBSITE_WEBSITE_ID_CORE_WEBSITE_WEBSITE_ID");
            });

            modelBuilder.Entity<SendfriendLog>(entity =>
            {
                entity.HasKey(e => e.LogId)
                    .HasName("PK_sendfriend_log");

                entity.ToTable("sendfriend_log");

                entity.HasIndex(e => e.Ip)
                    .HasName("IDX_SENDFRIEND_LOG_IP");

                entity.HasIndex(e => e.Time)
                    .HasName("IDX_SENDFRIEND_LOG_TIME");

                entity.Property(e => e.LogId)
                    .HasColumnName("log_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Ip)
                    .HasColumnName("ip")
                    .HasColumnType("varbinary(16)");

                entity.Property(e => e.Time)
                    .HasColumnName("time")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<ShippingTablerate>(entity =>
            {
                entity.HasKey(e => e.Pk)
                    .HasName("PK_shipping_tablerate");

                entity.ToTable("shipping_tablerate");

                entity.HasIndex(e => new { e.WebsiteId, e.DestCountryId, e.DestRegionId, e.DestZip, e.ConditionName, e.ConditionValue })
                    .HasName("D60821CDB2AFACEE1566CFC02D0D4CAA")
                    .IsUnique();

                entity.Property(e => e.Pk)
                    .HasColumnName("pk")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.ConditionName)
                    .IsRequired()
                    .HasColumnName("condition_name")
                    .HasColumnType("varchar(20)");

                entity.Property(e => e.ConditionValue)
                    .HasColumnName("condition_value")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.Cost)
                    .HasColumnName("cost")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.DestCountryId)
                    .IsRequired()
                    .HasColumnName("dest_country_id")
                    .HasColumnType("varchar(4)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.DestRegionId)
                    .HasColumnName("dest_region_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.DestZip)
                    .IsRequired()
                    .HasColumnName("dest_zip")
                    .HasColumnType("varchar(10)")
                    .HasDefaultValueSql("*");

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(12,4)")
                    .HasDefaultValueSql("0.0000");

                entity.Property(e => e.WebsiteId)
                    .HasColumnName("website_id")
                    .HasColumnType("int(11)")
                    .HasDefaultValueSql("0");
            });

            modelBuilder.Entity<Sitemap>(entity =>
            {
                entity.ToTable("sitemap");

                entity.HasIndex(e => e.StoreId)
                    .HasName("IDX_SITEMAP_STORE_ID");

                entity.Property(e => e.SitemapId)
                    .HasColumnName("sitemap_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.SitemapFilename)
                    .HasColumnName("sitemap_filename")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.SitemapPath)
                    .HasColumnName("sitemap_path")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SitemapTime)
                    .HasColumnName("sitemap_time")
                    .HasColumnType("timestamp");

                entity.Property(e => e.SitemapType)
                    .HasColumnName("sitemap_type")
                    .HasColumnType("varchar(32)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("smallint(5) unsigned")
                    .HasDefaultValueSql("0");

                entity.HasOne(d => d.Store)
                    .WithMany(p => p.Sitemap)
                    .HasForeignKey(d => d.StoreId)
                    .HasConstraintName("FK_SITEMAP_STORE_ID_CORE_STORE_STORE_ID");
            });

            modelBuilder.Entity<SpringbotActions>(entity =>
            {
                entity.ToTable("springbot_actions");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.CategoryId)
                    .HasColumnName("category_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.LockedAt)
                    .HasColumnName("locked_at")
                    .HasColumnType("datetime");

                entity.Property(e => e.LockedBy)
                    .HasColumnName("locked_by")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.PageUrl)
                    .HasColumnName("page_url")
                    .HasColumnType("text");

                entity.Property(e => e.PurchaseId)
                    .HasColumnName("purchase_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Quantity)
                    .HasColumnName("quantity")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(10) unsigned");

                entity.Property(e => e.Sku)
                    .IsRequired()
                    .HasColumnName("sku")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.SkuFulfillment)
                    .IsRequired()
                    .HasColumnName("sku_fulfillment")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.VisitorIp)
                    .IsRequired()
                    .HasColumnName("visitor_ip")
                    .HasColumnType("varchar(100)");
            });

            modelBuilder.Entity<SpringbotCronCount>(entity =>
            {
                entity.ToTable("springbot_cron_count");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.Completed)
                    .HasColumnName("completed")
                    .HasColumnType("timestamp");

                entity.Property(e => e.Count)
                    .HasColumnName("count")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Entity)
                    .IsRequired()
                    .HasColumnName("entity")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.HarvestId)
                    .IsRequired()
                    .HasColumnName("harvest_id")
                    .HasColumnType("char(40)");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("int(11)");
            });

            modelBuilder.Entity<SpringbotCronQueue>(entity =>
            {
                entity.ToTable("springbot_cron_queue");

                entity.HasIndex(e => e.CommandHash)
                    .HasName("command_hash")
                    .IsUnique();

                entity.HasIndex(e => new { e.Priority, e.CreatedAt })
                    .HasName("IDX_PRIORITY_CREATED_AT");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.Args)
                    .IsRequired()
                    .HasColumnName("args")
                    .HasColumnType("text");

                entity.Property(e => e.Attempts)
                    .HasColumnName("attempts")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.CommandHash)
                    .IsRequired()
                    .HasColumnName("command_hash")
                    .HasColumnType("char(40)");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Error)
                    .HasColumnName("error")
                    .HasColumnType("text");

                entity.Property(e => e.LockedAt)
                    .HasColumnName("locked_at")
                    .HasColumnType("datetime");

                entity.Property(e => e.LockedBy)
                    .HasColumnName("locked_by")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Method)
                    .IsRequired()
                    .HasColumnName("method")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.NextRunAt)
                    .HasColumnName("next_run_at")
                    .HasColumnType("datetime");

                entity.Property(e => e.Priority)
                    .HasColumnName("priority")
                    .HasColumnType("int(10) unsigned")
                    .HasDefaultValueSql("5");

                entity.Property(e => e.Queue)
                    .IsRequired()
                    .HasColumnName("queue")
                    .HasColumnType("varchar(255)")
                    .HasDefaultValueSql("default");

                entity.Property(e => e.RunAt)
                    .HasColumnName("run_at")
                    .HasColumnType("datetime");

                entity.Property(e => e.StoreId)
                    .HasColumnName("store_id")
                    .HasColumnType("int(11)");
            });

            modelBuilder.Entity<SpringbotRedirect>(entity =>
            {
                entity.ToTable("springbot_redirect");

                entity.HasIndex(e => e.Email)
                    .HasName("IDX_EMAIL");

                entity.HasIndex(e => new { e.Email, e.RedirectId })
                    .HasName("UNQ_COMPOUND_EMAIL_REDIRECT_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Email)
                    .IsRequired()
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RedirectId)
                    .IsRequired()
                    .HasColumnName("redirect_id")
                    .HasColumnType("char(24)");
            });

            modelBuilder.Entity<SpringbotRedirectOrder>(entity =>
            {
                entity.ToTable("springbot_redirect_order");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_ORDER_ID");

                entity.HasIndex(e => e.RedirectEntityId)
                    .HasName("IDX_REDIRECT_ENTITY_ID");

                entity.HasIndex(e => new { e.RedirectEntityId, e.OrderId })
                    .HasName("UNQ_COMPOUND_REDIRECT_ENTITY_ORDER_ID")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.RedirectEntityId)
                    .HasColumnName("redirect_entity_id")
                    .HasColumnType("int(11)");
            });

            modelBuilder.Entity<SpringbotTrackable>(entity =>
            {
                entity.ToTable("springbot_trackable");

                entity.HasIndex(e => e.Email)
                    .HasName("IDX_EMAIL");

                entity.HasIndex(e => e.OrderId)
                    .HasName("IDX_ORDER_ID");

                entity.HasIndex(e => e.QuoteId)
                    .HasName("IDX_QUOTE_ID");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasColumnType("int(11) unsigned");

                entity.Property(e => e.CreatedAt)
                    .HasColumnName("created_at")
                    .HasColumnType("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.CustomerId)
                    .HasColumnName("customer_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Email)
                    .IsRequired()
                    .HasColumnName("email")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.OrderId)
                    .HasColumnName("order_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.QuoteId)
                    .HasColumnName("quote_id")
                    .HasColumnType("int(11)");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasColumnName("type")
                    .HasColumnType("varchar(255)");

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasColumnType("varchar(255)");
            });

            modelBuilder.Entity<Tag>(entity =>
            {
                entity.ToTable("tag");

                entity.HasIndex(e => e.FirstCustomerId)
                    .HasName("FK_TAG_FIRST_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID");

                entity.HasIndex(e => e.FirstStoreId)
                    .HasName("FK_TAG_FIRST_STORE_ID_CORE_STORE_STORE_ID");

                entity.Property(e => e.TagId)
                    .HasColumnName("tag_id")
           