jshero.koans.add({id:"utc",title:"Weltzeit",lesson:"Wenn man mit Datum und Uhrzeit arbeitet, muss man zwischen\n<a href='https://de.wikipedia.org/wiki/Koordinierte_Weltzeit'>koordinierter Weltzeit</a> (UTC, engl. Coordinated Universal Time) und\n<a href='https://de.wikipedia.org/wiki/Zonenzeit'>Zonenzeit</a> unterscheiden.\nDie koordinierte Weltzeit stellt weltweit eine einheitliche Zeitangabe her.\nDie Zonenzeit ist die in einer Zeitzone geltende Zeit.\nVon der koordinierten Weltzeit werden die verschiedenen Zonenzeiten abgeleitet.\nSo ergibt sich die <a href='https://de.wikipedia.org/wiki/Mitteleurop%C3%A4ische_Zeit'>Mitteleurop\xE4ische Zeit (MEZ)</a>\naus der koordinierten Weltzeit durch Addition von einer Stunde (kurz UTC+1). Die Mitteleurop\xE4ische Sommerzeit (MESZ) entspricht\nUTC+2. UTC selbst ist die Zonenzeit der Westeurop\xE4ischen Zeit (WEZ).<br><br>\nWas wir bisher \xFCber das Date-Objekt gelernt haben, bezog sich meist auf die Zonenzeit. So liefert der Ausdruck\n<code>new Date(2018, 4, 5)</code> ein Date-Objekt, das dem Zeitpunkt 5.5.2018, 0:00 Uhr in lokaler Zeit entspricht.\nMacht man diesen Aufruf in Deutschland, erh\xE4lt man den 5.5.2018, 0:00 UTC+2 (Sommerzeit). In Japan liefert derselbe Aufruf\nden 5.5.2018, 0:00 UTC+9. Zwischen beiden Zeitpunkten liegt eine Differenz von 7 Stunden.\nM\xF6chte man weltweit einen einheitlichen Zeitpunkt erzeugen, so muss man die koordinierte Weltzeit verwenden. Leider kann man nicht\ndirekt ein Date aus den UTC-Daten erzeugen. Man muss einen Umweg \xFCber die Millisekunden seit dem 1.1.1970 machen:\n<pre><code>let millis = Date.UTC(2018, 4, 5);\nlet datum = new Date(millis);</code></pre>\nMit <code>Date.UTC()</code> erh\xE4lt man zun\xE4chst die vergangenen Millisekunden seit dem 1.1.1970, 0:00 UTC.\nMit dieser Zahl und <code>new Date()</code> erzeugt man anschlie\xDFend das gew\xFCnschte Date-Objekt.\nDer Konstruktor-Aufruf mit den Millisekunden als Parameter bezieht sich n\xE4mlich auch auf den 1.1.1970, 0:00 UTC.\nDie Variable <code>datum</code> repr\xE4sentiert den 5.5.2018, 0:00 UTC. <code>Date.UTC()</code> kann analog zu <code>new Date()</code> mit bis zu sieben Parametern\n(Jahr, Monat, Tag, Stunden, Minuten, Sekunden und Millisekunden) aufgerufen werden. Es gelten dieselben Regeln wie bei <code>new Date()</code>:\nBei Jahreszahlen zwischen 0 und 99 wird 1900 hinzuaddiert und die Monate werden beginnend mit 0 durchnummeriert.",task:"Schreibe eine Funktion <code>nikolausUTC</code>, die eine Jahresangabe als Zahl entgegennimmt und die ein\nDate-Objekt mit dem 6. Dezember des \xFCbergebenen Jahres, 0:00 UTC, zur\xFCckgibt.<br><br>Beispiel:\n<code>nikolaus(2017)</code> sollte ein Date-Objekt mit dem Zeitpunkt 6.12.2017, 0:00 UTC zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("nikolausUTC")},function(){return jshero.testutil.assert_functionHasNumOfParameter("nikolausUTC",1)},function(){return jshero.testutil.assert_functionReturnsType("nikolausUTC(2017)","Date")},function(){return jshero.testutil.assert_functionReturns("nikolausUTC(2017)",new Date(Date.UTC(2017,11,6)),{"utc":true})},function(){return jshero.testutil.assert_functionReturnsType("nikolausUTC(1960)","Date")},function(){return jshero.testutil.assert_functionReturns("nikolausUTC(1960)",new Date(Date.UTC(1960,11,6)),{"utc":true})}]});