jshero.koans.add({id:"parseint",title:"parseInt()",lesson:"H\xE4ufig m\xF6chte man eine Zahl, die als String vorliegt, in eine Zahl vom Typ Number umwandeln.\nF\xFCr das Umwandeln von ganzen Zahlen (..., -2, -1, 0, 1, 2, ..) gibt es in JavaScript die Funktion <code>parseInt</code>.\nFolgende Beispiele geben <code>19</code> oder <code>-19</code> zur\xFCck:\n<pre><code>let n1 = parseInt('19', 10);\nlet n2 = parseInt('+19', 10);\nlet n3 = parseInt('-19', 10);\nlet n4 = parseInt('19 Grad', 10);\nlet n5 = parseInt('19.1', 10);\nlet n6 = parseInt('019', 10);\nlet n7 = parseInt(' 19', 10);</code></pre>\nNeben dem direkten Einlesen von ganzen Zahlen mit oder ohne Vorzeichen (n1, n2, n3) beherrscht <code>parseInt</code>\nauch einige komplexe F\xE4lle. Nicht-numerische Zeichen nach der ganzen Zahl (n4, n5) sowie Nullen (n6) und\nLeerzeichen (n7) vor der Zahl werden ignoriert.<br><br>\nIn allen Beispielen ist der zweite an <code>parseInt</code> \xFCbergebene Parameter <code>10</code>.\nDieser Paramter gibt an, zu welcher Basis die Zahl interpretiert werden soll. <code>10</code> steht f\xFCr das\n\xFCbliche Dezimalsystem. L\xE4\xDFt man den zweiten Paramter weg, wird normalerweise das Dezimalsystem als Default verwendet.\nDa es aber von dieser Regel Ausnahmen gibt und diese Ausnahmen in verschiedenen Browsern auch noch unterschiedlich\ngehandhabt werden, sollte man immer die Basis mit angeben!\n<br><br>\nKann <code>parseInt</code> keine Zahl einlesen, gibt sie den Wert <code>NaN</code> (engl.: Not a Number) zur\xFCck:\n<pre><code>let n1 = parseInt('Nur Text', 10);\nlet n2 = parseInt('Nr. 8', 10);</code></pre>\nIm ersten Fall ist \xFCberhaupt keine Zahl vorhanden. Im zweiten Fall gibt es nicht-numerische Zeichen vor der\neigentlichen Zahl. Auch das ist nicht zul\xE4ssig und f\xFChrt zur R\xFCckgabe <code>NaN</code>.\n<br><br>\nEine ausf\xFChrliche Dokumentation von <code>parseInt</code> findest du bei\n<a href='https://developer.mozilla.org/de/docs/Web/JavaScript/Reference/Global_Objects/parseInt'>Mozilla web docs</a>.",task:"Schreibe eine Funktion <code>add</code>, die einen String mit einer Additionsaufgabe entgegennimmt und die das\nErgebnis der Addition als Zahl zur\xFCckgibt. Es sollen zwei nat\xFCrliche Zahlen addiert werden. Die Additionsaufgabe ist\nein String der Form <code>'102+17'</code>.\n<br><br>Beispiel: Der Aufruf <code>add('102+17')</code> soll die Zahl <code>119</code> zur\xFCckgeben.",hint:"Bestimme mit <code>parseInt</code> den ersten Summanden.\nBestimme mit <code>indexOf</code> die Position des Plus-Zeichens.\nBestimme mit <code>substr</code> den Teilstring nach dem Plus-Zeichen.\nBestimme mit <code>parseInt</code> aus diesem Teilstring den zweiten Summanden.",solution:"<pre><code>function add(s) {\n  let summand1 = parseInt(s, 10);\n  let indexPlus = s.indexOf('+');\n  let sAfterPlus = s.substr(indexPlus + 1);\n  let summand2 = parseInt(sAfterPlus, 10);\n  return summand1 + summand2;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("add")},function(){return jshero.testutil.assert_functionHasNumOfParameter("add",1)},function(){return jshero.testutil.assert_functionReturns("add('1+2')",3)},function(){return jshero.testutil.assert_functionReturns("add('10+100')",110)},function(){return jshero.testutil.assert_functionReturns("add('100123+456')",100579)}]});