(function(testutil){jshero.koans.add({id:"nan",title:"NaN",lesson:"<code>NaN</code> repr\xE4sentiert den Wert Not-A-Number (engl.: Keine-Zahl). Numerische Operationen oder\nFunktionen geben <code>NaN</code> zur\xFCck, wenn sie keinen Wert berechnen k\xF6nnen. Wir hatten dies bei\n<code><a href='parseint.html'>parseInt</a></code> kennengelernt. <code>parseInt</code> gibt <code>NaN</code>\nzur\xFCck, wenn es keine Zahl parsen kann. Ein weiteres Beispiel ist die Berechnung der Wurzel aus einer negativen Zahl:\n\n<pre><code>let age = parseInt('Babylon');\nlet length = Math.sqrt(-1);</code></pre>\n\nSowohl <code>age</code> als auch <code>length</code> haben den Wert <code>NaN</code>.<br><br>\nM\xF6chte man testen, ob <code>NaN</code> vorliegt, kann man leider nicht <code>===</code> verwenden.\n<code>NaN</code> ist der einzige Wert in JavaScript, der nicht mit sich selbst gleich ist.\n<code>NaN&nbsp;===&nbsp;NaN</code> ergibt <code>false</code>.\n\nUm auf <code>NaN</code> zu testen, sollte man die Funktion <code>Number.isNaN</code> verwenden:\n\n<pre><code>let input = 'Babylon';\nlet message;\nlet age = parseInt(input);\nif ( Number.isNaN(age) ) {\n  message = 'Du hast keine Zahl eingegeben.';\n}</code></pre>\n\nDie folgende Aufgabe ist anspruchsvoll.",task:"Schreibe eine Funktion <code>parseFirstInt</code>, die einen String entgegennimmt und die die erste in dem\nString vorkommende ganze Zahl zur\xFCckgibt. Enth\xE4lt der String keine ganze Zahl, soll man <code>NaN</code> erhalten.<br><br>\nBeispiel: <code>parseFirstInt('Sonnebornstr. 27')</code> sollte <code>27</code> zur\xFCckgeben.\n<code>parseFirstInt('Babylon')</code> sollte <code>NaN</code> ergeben.",hint:"Benutze eine Schleife. Verwende innerhalb der Schleife <code>parseInt()</code>.",solution:"<pre><code>function parseFirstInt(input) {\n\n  let inputToParse = input;\n\n  for (let i = 0; i < input.length; i++) {\n    let firstInt = parseInt(inputToParse);\n    if (!Number.isNaN(firstInt)) {\n      return firstInt;\n    }\n    inputToParse = inputToParse.substr(1);\n  }\n\n  return NaN;\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("parseFirstInt")},function(){return testutil.assert_functionHasNumOfParameter("parseFirstInt",1)},function(){return testutil.assert_functionReturns("parseFirstInt('Sonnebornstr. 2')",2)},function(){return testutil.assert_functionReturns("parseFirstInt('28.12.05')",28)},function(){return testutil.assert_functionReturns("parseFirstInt('Willi ist 22 Jahre alt.')",22)},function(){return testutil.assert_functionReturns("parseFirstInt('Temperatur: -12 Grad')",-12)},function(){return testutil.assert_functionReturns("parseFirstInt('Ohne Zahl')",NaN)}]})})(jshero.testutil);