jshero.koans.add({id:"filter",title:"Array: filter()",lesson:"Eine weitere wichtige Array-Methode mit Funktionsparamter ist <code>filter()</code>. Sie filtert aus einem Array alle\nElemente heraus, die einen durch die Callback-Funktion implementierten Test bestehen, und gibt diese als neues Array zur\xFCck.\nDie Callback-Funktion muss dabei bei Aufruf mit einem Array-Element entweder <code>true</code> oder <code>false</code>\nergeben. Array-Elemente, die <code>true</code> ergeben, landen im gefilterten Array. Das urspr\xFCngliche Array wird wie bei <code>map()</code>\nnicht ver\xE4ndert.\n  \n<pre><code>let numbers = [7, -6, 120, -21, 2];\n\n// [7, 120, 2]\nlet positiveNumbers = numbers.filter(x => x > 0);\n\n// [-6, -21]\nlet negativeNumbers = numbers.filter(x => x < 0);\n\n// [-6, 120, 2]\nlet evenNumbers = numbers.filter(x => x % 2 === 0);</code></pre>\n\nL\xE4\xDFt sich die Filterbedingung wie hier in einem kurzen Ausdruck darstellen, so kann man die Callback-Funktion elegant\nals Pfeilfunktion \xFCbergeben. In komplexeren F\xE4llen ist eine eigenst\xE4ndige Funktion sinnvoll:\n\n<pre><code>const numbers = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];\n\nfunction isPrime(num) {\n   \n  if (num < 2) {\n    // nicht prim, weil zu klein\n    return false;\n  }\n\n  for (let i = 2; i < num; i++) {\n    if (num % i === 0) {\n      // nicht prim, weil teilbar\n      return false;\n    }\n  }\n  // prim\n  return true;\n}\n\n// [2, 3, 5, 7]\nconst primes = numbers.filter(isPrime);</code></pre>",hint:"Schreibe zun\xE4chst eine Funktion <code>containsBlau()</code>, die einen String entgegennimmt und <code>true</code> zur\xFCckgibt,\nwenn der String <code>'blau'</code> enh\xE4lt. Enth\xE4lt er nicht <code>'blau'</code>, soll <code>false</code> zur\xFCckgegeben werden. Gro\xDF- und Kleinschreibung\nsoll keine Rolle spielen. Verwende dann die Array-Funktion <code>filter()</code> zusammen mit <code>containsBlau()</code>, um die geforderte Funktion\n<code>filterBlau()</code> zu schreiben.",solution:"<pre><code>function containsBlau(word) {\n  return word.toLowerCase().indexOf('blau') >= 0;\n}\n\nfunction filterBlau(words) {\n  return words.filter(containsBlau);\n}</pre></code>",task:"Schreibe eine Funktion <code>filterBlau</code>, die ein Array mit Strings entgegennimmt\nund alle Array-Elemente, die den String <code>'blau'</code> enthalten, als Array zur\xFCckgibt. Gro\xDF- und Kleinschreibung\nsoll keine Rolle spielen.<br><br>\nBeispiel: <code>filterBlau(['Korngelb', 'Tannenblau', 'Rosenrot'])</code> sollte\n<code>['Tannenblau']</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("filterBlau")},function(){return jshero.testutil.assert_functionHasNumOfParameter("filterBlau",1)},function(){return jshero.testutil.assert_functionReturns("filterBlau(['Himmelblau'])",["Himmelblau"])},function(){return jshero.testutil.assert_functionReturns("filterBlau(['Korngelb', 'Tannenblau', 'Rosenrot'])",["Tannenblau"])},function(){return jshero.testutil.assert_functionReturns("filterBlau(['Blau', 'Gelb'])",["Blau"])},function(){return jshero.testutil.assert_functionReturns("filterBlau(['ROTKELCHEN', 'BLAUMEISE'])",["BLAUMEISE"])},function(){return jshero.testutil.assert_functionReturns("filterBlau(['gr\xFCn', 'wei\xDF'])",[])},function(){return jshero.testutil.assert_functionReturns("filterBlau([])",[])}]});