jshero.koans.add({id:"dowhile",title:"do...while-Schleife",lesson:"Die <code>do...while</code>-Schleife funktioniert \xE4hnlich wie die <code>while</code>-Schleife.\nDer Schleifen-Code wird ausgef\xFChrt, solange die Schleifenbedingung <code>true</code> ergibt.\nEinziger Unterschied ist, dass die Schleifenbedingung nach dem Schleifen-Code \xFCberpr\xFCft wird.\nDadurch ist sichergestellt, dass der Schleifen-Code mindestens einmal durchlaufen wird.\n\n<pre><code>let restDurch6;\nlet restDurch8;\nlet kgV = 0;\ndo {\n  kgV++;\n  restDurch6 = kgV % 6;\n  restDurch8 = kgV % 8;\n} while (restDurch6 !== 0 || restDurch8 !== 0);</code></pre>\n\nDieser Codeabschnitt berechnet das\n<a href='https://de.wikipedia.org/wiki/Kleinstes_gemeinsames_Vielfaches'>kleinste gemeinsame Vielfache (kgV)</a> von 6 und 8.\nDas kgV ist die kleinste Zahl, die sowohl ein Vielfaches von 6 als auch ein Vielfaches von 8 ist.\nDie Vielfachen von 6 sind 6, 12, 18, 24, 30, ... und die Vielfachen von 8 sind 8, 16, 24, 32, ... .\nDamit ist das kgV von 6 und 8 die Zahl 24.<br>\nUnser Codebeispiel pr\xFCft beginnend mit <code>1</code>, ob <code>kgV</code> sowohl durch <code>6</code> als auch durch <code>8</code> teilbar ist.\nDie Teilbarkeit wird mithilfe des Modulo-Operators \xFCberpr\xFCft. Eine Zahl ist durch 6 bzw. 8 teilbar,\nwenn sie Modulo 6 bzw. Modulo 8 den Wert 0 liefert. Die Modulo-Berechnung findet im Schleifen-Code statt.\nIn der Schleifenbedingung wird dann \xFCberpr\xFCft, ob beide Modulo-Berechnungen <code>0</code> ergeben. Ist eine von beiden\nModulo-Berechnungen nicht <code>0</code>, ist die Schleifenbedingung <code>true</code> und der Schleifen-Code wird mit einem um 1 erh\xF6hten <code>kgV</code>\nerneut durchlaufen. Ergeben beide Modulo-Berechnungen <code>0</code>, ist die Schleifenbedingung <code>false</code> und die Schleife wird beendet.\n<code>kgV</code> hat dann den gew\xFCnschten Wert (n\xE4mlich 24), da es die erste Zahl ist, die sowohl durch 6 als auch durch 8 teilbar ist.",task:"Schreibe eine Funktion <code>kgV</code>, die zwei nat\xFCrliche Zahlen als Parameter entgegennimmt und deren kgV berechnet.\n<br><br>Beispiel: <code>kgV(6, 8)</code> sollte <code>24</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("kgV")},function(){return jshero.testutil.assert_functionHasNumOfParameter("kgV",2)},function(){return jshero.testutil.assert_functionReturns("kgV(1, 1)",1)},function(){return jshero.testutil.assert_functionReturns("kgV(1, 2)",2)},function(){return jshero.testutil.assert_functionReturns("kgV(2, 3)",6)},function(){return jshero.testutil.assert_functionReturns("kgV(3, 2)",6)},function(){return jshero.testutil.assert_functionReturns("kgV(4, 6)",12)},function(){return jshero.testutil.assert_functionReturns("kgV(5, 7)",35)},function(){return jshero.testutil.assert_functionReturns("kgV(6, 8)",24)},function(){return jshero.testutil.assert_functionReturns("kgV(10, 20)",20)},function(){return jshero.testutil.assert_functionReturns("kgV(20, 10)",20)}]});