(function(testutil){jshero.koans.add({id:"const",title:"Konstanten",lesson:"Bisher haben wir Variablen mit <code>let</code> deklariert. Solchen Variablen kann man beliebig oft einen\nneuen Wert zuweisen. Manchmal kommt es jedoch vor, dass eine Variable ihren Wert garnicht \xE4ndern soll.\nEine solche Variable k\xF6nnte man nat\xFCrlich auch mit <code>let</code> deklarieren. Man muss dann aufpassen,\ndass man ihren Wert nicht aus Versehen \xE4ndert. Besser w\xE4re es, wenn man ihren Wert erst garnicht \xE4ndern kann. Hier kommt\n<code>const</code> ins Spiel:\n\n<pre><code>const MEHRWERTSTEUER = 19;\nlet netto = 100;\nlet steuer = netto * MEHRWERTSTEUER / 100;\nconsole.log(steuer);\n\nMEHRWERTSTEUER = 20; // Programmfehler!\nnetto = 200;\nsteuer = netto * MEHRWERTSTEUER / 100;\nconsole.log(steuer);</code></pre>\n\nEine Deklaration mit <code>const</code> erzeugt eine Konstante. Eine Konstante funktioniert genauso wie eine mit\n<code>let</code> erzeugte Variable. Mit einem Unterschied: weist man einer Konstante einen neuen Wert zu, so kommt\nes zu einem Programmfehler. F\xFChrt man obigen Code im <a href=\"../playground.html\">JS-Hero Playground</a> aus,\nso wird korrekt <code>19</code> ausgegeben. Die n\xE4chste Steuer wird allerdings nicht ausgegeben.\nStattdessen erhalten wir einen Fehler wie \"invalid assignment to const 'MEHRWERTSTEUER'\". In Zeile 6 haben wir der\nKonstanten <code>MEHRWERTSTEUER</code> den neuen Wert <code>20</code> zugeordnet. Das ist nicht erlaubt. Das Programm\nbricht an dieser Stelle mit dem genannten Fehler ab. Entfernt man diese Zeile, l\xE4uft das Programm korrekt durch.\n<br><br>\nEiner Konstante muss man direkt bei der Deklaration einen Wert zuweisen. Eine Konstante nur deklarieren und ihr\nsp\xE4ter einen Wert zuzuweisein, ist nicht zul\xE4ssig.\n\n<pre><code>const HOUR_IN_SECONDS = 3600; // Korrekt!\nconst NUMBER_OF_WEEKDAYS; // Programmfehler!\nNUMBER_OF_WEEKDAYS = 7;</code></pre>\n\nDas Programm bricht in der zweiten Zeile mit einen Fehler wie \"missing = in const declaration\" ab.\n<br><br>\nNoch ein stylistischer Hinweis: Wir haben Konstanten mit Gro\xDFbuchstaben geschrieben. Das ist keine Vorgabe.\nWir h\xE4tten sie auch klein schreiben k\xF6nnen. <code>mehrwertsteuer</code> geht genauso gut wie\n<code>MEHRWERTSTEUER</code>. Die Gro\xDFschreibung hat jedoch den Vorteil, dass man Konstanten schon an ihrer Schreibweise\nerkennt.\n<br><br>\nDa man die Verwendung von Konstanten nicht gut testen kann, hier eine komplexere Aufgabe aus dem Bereich der\nMathematik.",task:"Schreibe eine Funktion <code>primes</code>, die eine nat\xFCrliche Zahl n entgegennimmt und ein Array aller\n<a href=\"https://de.wikipedia.org/wiki/Primzahl\">Primzahlen</a> kleiner gleich n zur\xFCckgibt.<br><br>\nBeispiel: <code>primes(10)</code> sollte <code>[2, 3, 5, 7]</code> zur\xFCckgeben.",tests:[function(){return testutil.assert_isFunction("primes")},function(){return testutil.assert_functionHasNumOfParameter("primes",1)},function(){return testutil.assert_functionReturns("primes(1)",[])},function(){return testutil.assert_functionReturns("primes(2)",[2])},function(){return testutil.assert_functionReturns("primes(3)",[2,3])},function(){return testutil.assert_functionReturns("primes(10)",[2,3,5,7])},function(){return testutil.assert_functionReturns("primes(30)",[2,3,5,7,11,13,17,19,23,29])}]})})(jshero.testutil);