jshero.koans.add({id:"arrow",title:"Pfeilfunktionen",lesson:"Pfeilfunktionen (engl.: arrow functions) bieten verschiedene M\xF6glichkeiten, Funktionsausdr\xFCcke noch\nk\xFCrzer zu schreiben. Zun\xE4chst kann <code>function</code> durch einen Pfeil ersetzt werden:\n\n<pre><code>const f1 = function(a, b) {\n  const offset = 100;\n  return a + b + offset;\n};\n\nconst f2 = (a, b) => {\n  const offset = 100;\n  return a + b + offset;\n};</code></pre>\n\nDie beiden Funktionen <code>f1</code> und <code>f2</code> sind funktional identisch. <code>f1</code>\nwird ein anonymer Funktionsausdruck zugeordnet, <code>f2</code> eine Pfeilfunktion.<br><br>\nKann man den return-Wert direkt mit einem Ausdruck bestimmen, so kann man das <code>return</code>\nzusammen mit den Funktionsklammern weglassen:\n\n<pre><code>const f3 = function(a, b) {\n  return a * b * 100;\n};\n\nconst f4 = (a, b) => a * b * 100;</code></pre>\n\n<code>f3</code> und <code>f4</code> sind wieder funktional identisch.<br><br>\nBesitzt die Funktion nur einen Parameter, so ergibt sich eine weitere Vereinfachung.\nIn diesem Fall kann man die Parameter-Klammer weglassen:\n\n<pre><code>const f5 = function(a) {\n  return a * a;\n};\n\nconst f6 = a => a * a;</code></pre>\n\nPfeilfunktionen werden, wie wir sp\xE4ter sehen, haupts\xE4chlich in der funktionalen Programmierung verwendet.<br><br>\nDa man die Verwendung von Pfeilfunktionen nur schwer testen kann, hier eine anspruchsvolle Aufgabe aus\ndem Gebiet der Mathematik:",task:"Schreibe eine Funktion <code>toDecimal</code>, die einen String mit einer\n<a href=\"https://de.wikipedia.org/wiki/Dualsystem\">Bin\xE4rzahl</a> entgegennimmt und diese als Dezimalzahl zur\xFCckgibt.<br><br>\nBeispiel: <code>toDecimal(\"10\")</code> sollte <code>2</code> und\n<code>toDecimal(\"101\")</code> sollte <code>5</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("toDecimal")},function(){return jshero.testutil.assert_functionHasNumOfParameter("toDecimal",1)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"0\")",0)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"1\")",1)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"10\")",2)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"11\")",3)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"100\")",4)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"101\")",5)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"110\")",6)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"111\")",7)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"1000\")",8)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"10000000000\")",1024)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"11111010000\")",2000)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"101110111000\")",3000)}]});