jshero.koans.add({id:"arguments",title:"Das arguments-Objekt",lesson:"Das <code>arguments</code>-Objekt ist eine in jeder Funktion verf\xFCgbare Variable.\nEs ist ein Array \xE4hnliches Objekt, das die \xFCbergebenen Argumente einer Funktion der Reihe nach enth\xE4lt.\n\n<pre><code>function add() {\n  let arg0 = arguments[0];\n  let arg1 = arguments[1];\n  return arg0 + arg1;\n}\n\nlet sum = add(1, 2);</code></pre>\n\nHier wird <code>add</code> mit den Argumenten <code>1</code> und <code>2</code> aufgerufen.\n<code>arguments[0]</code> enth\xE4lt also den Wert <code>1</code>, <code>arguments[1]</code> den Wert <code>2</code>.\nMit dem <code>arguments</code>-Objekt kann man ohne Parameter auf die \xFCbergebenen Argumente zugreifen.\nDas ist z.B. dann praktisch, wenn man eine Funktion schreiben m\xF6chte, die eine beliebige Anzahl von Argumenten\nverarbeiten soll.\n\n<pre><code>function add() {\n  let sum = 0;\n  for (let i = 0; i < arguments.length; i++) {\n    sum = sum + arguments[i];\n  }\n  return sum;\n}\n\nlet s1 = add(2, 4);\nlet s2 = add(2, 3, 5, 7);</code></pre>\n\nHier iterieren wir \xFCber alle \xFCbergebenen Argumente und summieren sie auf.\n<code>arguments.length</code> liefert dabei die Anzahl der \xFCbergebenen Argumente.\nNun k\xF6nnen wir <code>add</code> mit einer beliebigen Anzahl von Argumenten aufrufen.",task:"Schreibe eine Funktion <code>maximum</code>, die beliebig viele Zahlen entgegennimmt und das Maximum dieser\nZahlen liefert.<br><br>Beispiel: <code>maximum(12, 68, 3, 52)</code> sollte <code>68</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("maximum")},function(){return jshero.testutil.assert_functionReturns("maximum(1)",1)},function(){return jshero.testutil.assert_functionReturns("maximum(15, 2)",15)},function(){return jshero.testutil.assert_functionReturns("maximum(1, 15, 3)",15)},function(){return jshero.testutil.assert_functionReturns("maximum(-1, 0, 9, 8)",9)},function(){return jshero.testutil.assert_functionReturns("maximum(-4, -3, -2, -1)",-1)}]});