(function(testutil){jshero.koans.add({id:"undefined",title:"undefined",lesson:"Up to now we had always initialized variables at declaration.\n\n<pre><code>// declaration and initialization\nlet x = 1;</code></pre>\n\nHowever, you can also declare a variable and initialize it later.\n\n<pre><code>let x; // declaration\nx = 1; // initialization</code></pre>\n\nVariables that were not initialized have the value <code>undefined</code>.<br><br>\nUninitialized variables can also occur on function calls.\nIf you call a function with a parameter without an argument, the parameter gets the value <code>undefined</code>:\n\n<pre><code>function echo(x) {\n  return x;\n}\n\n// function call without argument\nlet y = echo();</code></pre>\n\n<code>echo</code> is called without any argument.\nThe parameter <code>x</code> receives the value <code>undefined</code>. Since <code>echo</code> simply returns\nit's parameter, <code>y</code> also gets the value <code>undefined</code>.<br><br>\nA function that expects a parameter can be called without an argument.\nWhen writing functions, you should always consider what should happen in this case.\nIt is good practice in such a case to assign a default value to the parameter.\nWe had seen this with the string method <code><a href=\"stringcharat.html\">charAt(index)</a></code>.\nNormally this method returns the character at position <code>index</code>.\nIf we call <code>charAt</code> without an argument, <code>index</code> gets the default <code>0</code>.\nThe character at position <code>0</code> is returned.<br><br>\nTo check for <code>undefined</code>, use  <a href='equals.html'>strict&nbsp;equality</a>.\nTherefore, <code>charAt</code> could contain the following code snippet:\n\n<pre><code>if (index === undefined) {\n  index = 0;\n}</code></pre>",task:"Write a function <code>hello</code> having one parameter and returning <code>'Hello &lt;parameter&gt;!'</code>.\nIf <code>hello</code> is called without an argument, <code>'Hello world!'</code> should be returned.<br><br>\nExample: <code>hello('Nala')</code> should return <code>'Hello Nala!'</code>.",solution:"<pre><code>function hello(name){\n  if (name === undefined) {\n    name = \"world\";\n  }\n  return 'Hello ' + name + '!'\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("hello")},function(){return testutil.assert_functionHasNumOfParameter("hello",1)},function(){return testutil.assert_functionReturns("hello('Nala')","Hello Nala!")},function(){return testutil.assert_functionReturns("hello('Badu')","Hello Badu!")},function(){return testutil.assert_functionReturns("hello()","Hello world!")}]})})(jshero.testutil);