(function(testutil){jshero.koans.add({id:"recursion",title:"Recursion",lesson:"Functions can call themselves. This is called\n<a href='https://en.wikipedia.org/wiki/Recursion_(computer_science)'>recursion</a>.\nThe best known example is the calculation of the factorial:\n\n<pre><code>function factorial(n) {\n  if (n === 0) {\n    return 1;\n  }\n  return factorial(n - 1) * n;\n}</code></pre>\n\nThe <a href='https://en.wikipedia.org/wiki/Factorial'>factorial</a> of a natural number is the product of all natural numbers\n(excluding zero) less than or equal to that number. It is marked by a trailing exclamation mark: n! = 1 * 2 * 3 ... (n-1) * n.\nYou can see that you can use the factorial of n-1 to calculate the factorial of n: n! = (n-1)! * n.\nThe code above is the implementation of this equation. To calculate the factorial of n, you have to calculate the factorial\nof n-1 and multiply the result by n. So the function calls itself repeatedly with a value reduced by 1.\nNow you need a termination condition so that the recursion does not continue infinitely. This termination condition\nis implemented by the <code>if</code> condition. If n has reached 0, the function no longer calls itself, but the result,\nnamely 0! = 1, is returned directly.",task:"Write a function <code>reverse</code> that reverses the order of the characters in a string.\nThe function should be recursive.<br><br>\nExample: <code>reverse('live')</code> should return <code>'evil'</code>.",tests:[function(){return testutil.assert_isFunction("reverse")},function(){return testutil.assert_functionHasNumOfParameter("reverse",1)},function(){return testutil.assert_functionReturns("reverse('')","")},function(){return testutil.assert_functionReturns("reverse('X')","X")},function(){return testutil.assert_functionReturns("reverse('az')","za")},function(){return testutil.assert_functionReturns("reverse('12345')","54321")},function(){return testutil.assert_functionReturns("reverse('live')","evil")}]})})(jshero.testutil);