jshero.koans.add({id:"parseint",title:"parseInt()",lesson:"Sometimes you want to read a number from a string. In case of an integer (..., -2, -1, 0, 1, 2, ..) you can\nuse the <code>parseInt</code> function. The following examples return <code>19</code> or <code>-19</code>:\n\n<pre><code>let n1 = parseInt('19', 10);\nlet n2 = parseInt('+19', 10);\nlet n3 = parseInt('-19', 10);\nlet n4 = parseInt('19 Grad', 10);\nlet n5 = parseInt('19.1', 10);\nlet n6 = parseInt('019', 10);\nlet n7 = parseInt(' 19', 10);</code></pre>\n\nBesides the direct reading of integers with or without sign (n1, n2, n3), <code>parseInt</code> can also handle some\nmore complex cases. Non-numeric characters after (n4, n5) as well as zeros (n6) and spaces (n7) before the integer\nwill be ignored.<br><br>\n\nIn all examples, the second parameter passed to <code>parseInt</code> is <code>10</code>.\nThis parameter specifies the radix (the base in mathematical numeral systems) on which the number is to be interpreted.\n<code>10</code> represents the usual decimal system. If you omit the second parameter, the decimal system is normally\nused as default. Since there are exceptions to this rule, you should always specify the radix!<br><br>\n\nIf <code>parseInt</code> cannot read an integer, it returns <code>NaN</code> (Not a Number).\n\n<pre><code>let n1 = parseInt('text', 10);\nlet n2 = parseInt('No. 10', 10);</code></pre>\n\nIn the first case there is no number at all. In the second case, there are non-numeric characters before the number.\nThis is not allowed and results in <code>NaN</code>.<br><br>\n\nA detailed documentation of <code>parseInt</code> can be found at\n<a href='https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseInt'>Mozilla web docs</a>.",task:"Write a function <code>add</code> that takes a string with a summation task and returns its result as a number.\nTwo natural numbers should be added. The summation task is a string of the form '102+17'.<br><br>\nExample: <code>add('102+17')</code> should return <code>119</code>.",hint:"Determine the first summand with <code>parseInt</code>.\nUse <code>indexOf</code> to determine the position of the plus sign.\nDetermine with <code>substr</code> the substring after the plus sign.\nUse <code>parseInt</code> to determine the second summand from this substring.",solution:"<pre><code>function add(s) {\n  let summand1 = parseInt(s, 10);\n  let indexPlus = s.indexOf('+');\n  let sAfterPlus = s.substr(indexPlus + 1);\n  let summand2 = parseInt(sAfterPlus, 10);\n  return summand1 + summand2;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("add")},function(){return jshero.testutil.assert_functionHasNumOfParameter("add",1)},function(){return jshero.testutil.assert_functionReturns("add('1+2')",3)},function(){return jshero.testutil.assert_functionReturns("add('10+100')",110)},function(){return jshero.testutil.assert_functionReturns("add('10123+456')",10579)}]});