(function(testutil){jshero.koans.add({id:"nan",title:"NaN",lesson:"<code>NaN</code> is a value representing Not-A-Number. Numeric operations or functions return\n<code>NaN</code> if they cannot calculate a value. We had seen this with\n<code><a href='parseint.html'>parseInt</a></code>. It returns <code>NaN</code>, if it can't parse a number.\nAnother example is the calculation of the square root from a negative number:\n\n<pre><code>let age = parseInt('Babylon');\nlet length = Math.sqrt(-1);</code></pre>\n\nBoth <code>age</code> and <code>length</code> get the value <code>NaN</code>.<br><br>\nIf you want to test for <code>NaN</code>, you unfortunately can't use <a href='equals.html'>strict equality</a>.\n<code>NaN</code> is the only value in JavaScript that when compared to itself returns <code>false</code>.\nThat is, <code>NaN&nbsp;===&nbsp;NaN</code> results in <code>false</code>.\nTo check if a value is <code>NaN</code> use the <code>Number.isNaN</code> function:\n\n<pre><code>let input = 'Babylon';\nlet message;\nlet age = parseInt(input);\nif ( Number.isNaN(age) ) {\n  message = 'Input is not a number!';\n}</code></pre>\n\nThe following task is challenging.",task:"Write a function <code>parseFirstInt</code> that takes a string and returns the first integer present in the\nstring. If the string does not contain an integer, you should get <code>NaN</code>.<br><br>\nExample: <code>parseFirstInt('No. 10')</code> should return <code>10</code> and <code>parseFirstInt('Babylon')</code> should\nreturn <code>NaN</code>.",hint:"Use a loop. Within the loop use <code>parseInt()</code>.",solution:"<pre><code>function parseFirstInt(input) {\n\n  let inputToParse = input;\n\n  for (let i = 0; i < input.length; i++) {\n    let firstInt = parseInt(inputToParse);\n    if (!Number.isNaN(firstInt)) {\n      return firstInt;\n    }\n    inputToParse = inputToParse.substr(1);\n  }\n\n  return NaN;\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("parseFirstInt")},function(){return testutil.assert_functionHasNumOfParameter("parseFirstInt",1)},function(){return testutil.assert_functionReturns("parseFirstInt('No. 10')",10)},function(){return testutil.assert_functionReturns("parseFirstInt('18.12')",18)},function(){return testutil.assert_functionReturns("parseFirstInt('Li is 22 years old.')",22)},function(){return testutil.assert_functionReturns("parseFirstInt('sum: -120')",-120)},function(){return testutil.assert_functionReturns("parseFirstInt('a string')",NaN)}]})})(jshero.testutil);