jshero.koans.add({id:"join",title:"Array: join()",lesson:"With <code>join</code> you join all elements of an array into a string:\n\n<pre><code>let words = ['Sex', 'Drugs', 'Rock', 'Roll'];\nlet s1 = words.join();\nlet s2 = words.join(' & ');\nlet s3 = words.join(' and ');</code></pre>\n\nWithout an argument <code>join</code> joins the elements separated by commas.\n<code>s1</code> has the value <code>'Sex,Drugs,Rock,Roll'</code>.\nOtherwise, the passed argument specifies the separator.\n<code>s2</code> has the value <code>'Sex & Drugs & Rock & Roll'</code> and\n<code>s3</code> has the value  <code>'Sex and Drugs and Rock and Roll'</code>.",task:"Write a function <code>list</code> that takes an array of words and returns a string by\nconcatenating the words in the array, separated by commas and - the last word - by an 'and'.\nAn empty array should return an empty string.<br><br>\nExample: <code>list(['Huey', 'Dewey', 'Louie'])</code> should return <code>'Huey, Dewey and Louie'</code>.",hint:"Create a new array without the last element. Join the elements of this new array with a comma.\nAppend the last element of the original array. Handle edge cases separately.",solution:"<pre><code>function list(words) {\n\n  if (words.length === 0) {\n    return '';\n  }\n\n  if (words.length === 1) {\n    return words[0];\n  }\n\n  let wordsExLast = words.slice(0, words.length - 1);\n  let lastWord = words[words.length - 1];\n  return wordsExLast.join(', ') + ' and ' + lastWord;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("list")},function(){return jshero.testutil.assert_functionHasNumOfParameter("list",1)},function(){return jshero.testutil.assert_functionReturns("list([])","")},function(){return jshero.testutil.assert_functionReturns("list(['love'])","love")},function(){return jshero.testutil.assert_functionReturns("list(['Ernie', 'Bert'])","Ernie and Bert")},function(){return jshero.testutil.assert_functionReturns("list(['Huey', 'Dewey', 'Louie'])","Huey, Dewey and Louie")},function(){return jshero.testutil.assert_functionReturns("list(['C', 'C++', 'Python', 'PHP'])","C, C++, Python and PHP")}]});