if(typeof jshero==="undefined"){var jshero={}}jshero.koans=function(){var koans=[];var koansMap={};var add=function(koan){koans.push(koan);koansMap[koan.id]=koan};var initReorder=function(order){if(order.length!==koans.length){console.log("ERROR: Koans-Order-Array length unequal to Koans length!")}var koan;koans=[];for(var i=0,l=order.length;i<l;i++){koan=koansMap[order[i]];if(koan!=null){koans.push(koan)}else{throw"ERROR: No koan for koan-Id ".concat(order[i]," in koansMap!")}}};var getKoans=function(){return koans};return{add:add,initReorder:initReorder,getKoans:getKoans}}();if(typeof module!=="undefined"){module.exports=jshero.koans}
jshero.koans.add({id:"arguments",title:"Das arguments-Objekt",lesson:"Das <code>arguments</code>-Objekt ist eine in jeder Funktion verf\xFCgbare Variable.\nEs ist ein Array \xE4hnliches Objekt, das die \xFCbergebenen Argumente einer Funktion der Reihe nach enth\xE4lt.\n\n<pre><code>function add() {\n  let arg0 = arguments[0];\n  let arg1 = arguments[1];\n  return arg0 + arg1;\n}\n\nlet sum = add(1, 2);</code></pre>\n\nHier wird <code>add</code> mit den Argumenten <code>1</code> und <code>2</code> aufgerufen.\n<code>arguments[0]</code> enth\xE4lt also den Wert <code>1</code>, <code>arguments[1]</code> den Wert <code>2</code>.\nMit dem <code>arguments</code>-Objekt kann man ohne Parameter auf die \xFCbergebenen Argumente zugreifen.\nDas ist z.B. dann praktisch, wenn man eine Funktion schreiben m\xF6chte, die eine beliebige Anzahl von Argumenten\nverarbeiten soll.\n\n<pre><code>function add() {\n  let sum = 0;\n  for (let i = 0; i < arguments.length; i++) {\n    sum = sum + arguments[i];\n  }\n  return sum;\n}\n\nlet s1 = add(2, 4);\nlet s2 = add(2, 3, 5, 7);</code></pre>\n\nHier iterieren wir \xFCber alle \xFCbergebenen Argumente und summieren sie auf.\n<code>arguments.length</code> liefert dabei die Anzahl der \xFCbergebenen Argumente.\nNun k\xF6nnen wir <code>add</code> mit einer beliebigen Anzahl von Argumenten aufrufen.",task:"Schreibe eine Funktion <code>maximum</code>, die beliebig viele Zahlen entgegennimmt und das Maximum dieser\nZahlen liefert.<br><br>Beispiel: <code>maximum(12, 68, 3, 52)</code> sollte <code>68</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("maximum")},function(){return jshero.testutil.assert_functionReturns("maximum(1)",1)},function(){return jshero.testutil.assert_functionReturns("maximum(15, 2)",15)},function(){return jshero.testutil.assert_functionReturns("maximum(1, 15, 3)",15)},function(){return jshero.testutil.assert_functionReturns("maximum(-1, 0, 9, 8)",9)},function(){return jshero.testutil.assert_functionReturns("maximum(-4, -3, -2, -1)",-1)}]});
(function(testutil){jshero.koans.add({id:"array",title:"Arrays",lesson:"Arrays sind Objekte zur Speicherung vieler, meist \xE4hnlicher Werte. Diese sogenannten Elemente werden\nin einem Array der Reihe nach abgelegt. Arrays erzeugt man am besten mit eckigen Klammern.\n\n<pre><code>let sprachen = ['C', 'C++', 'Java', 'JavaScript'];\nlet primzahlen = [2, 3, 5, 7, 11];\nlet leeresArray = [];\nlet a = 'Douglas';\nlet b = 12;\nlet c = true;\nlet allesMoegliche = [a, b, c];</code></pre>\n\nDie Elemente eines Arrays k\xF6nnen, wie das letzte Beispiel zeigt, alle einen anderen Datentyp besitzen.",task:"Schreibe eine Funktion <code>toArray</code>, die 2 Paramter entgegennimmt und diese als Array zur\xFCckgibt.\n<br><br>Beispiel: <code>toArray(5, 9)</code> sollte das Array <code>[5, 9]</code> ergeben.",hint:"<pre><code>function toArray(a, b) {\n  return [...];\n}</code></pre>",solution:"<pre><code>function toArray(a, b) {\n  return [a, b];\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("toArray")},function(){return testutil.assert_functionHasNumOfParameter("toArray",2)},function(){return testutil.assert_functionReturnsType("toArray(1, 2)","Array")},function(){return testutil.assert_functionReturns("toArray(1, 2)",[1,2])},function(){return testutil.assert_functionReturns("toArray('H\xE4nsel', 'Gretel')",["H\xE4nsel","Gretel"])},function(){return testutil.assert_functionReturns("toArray(1, 'Maus')",[1,"Maus"])}]})})(jshero.testutil);
jshero.koans.add({id:"array2",title:"Array-Elemente lesen",lesson:"Die Elemente eines Arrays werden mit einem Index beginnend mit 0 ausgelesen.\n\n<pre><code>let sprachen = ['C', 'C++', 'Java', 'JavaScript'];\nlet c = sprachen[0];\nlet cPlusPlus = sprachen[1];\nlet java = sprachen[2];\nlet javaScript = sprachen[3];</code></pre>",task:"Schreibe eine Funktion <code>getFirstElement</code>, die ein Array entgegennimmt und die das erste Element des\nArrays zur\xFCckgibt.<br><br>Beispiel: <code>getFirstElement([1, 2])</code> sollte <code>1</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("getFirstElement")},function(){return jshero.testutil.assert_functionHasNumOfParameter("getFirstElement",1)},function(){return jshero.testutil.assert_functionReturns("getFirstElement([1, 2])",1)},function(){return jshero.testutil.assert_functionReturns("getFirstElement(['H\xE4nsel', 'Gretel'])","H\xE4nsel")},function(){return jshero.testutil.assert_functionReturns("getFirstElement(['Maus', 1])","Maus")}]});
jshero.koans.add({id:"array3",title:"Array-Elemente schreiben",lesson:"Ebenso wie man Array-Elemente \xFCber einen Index auslesen kann, kann man sie \xFCber diesen Index setzen.\nDabei spielt es keine Rolle, ob das Array vorher gef\xFCllt oder leer war.\n\n<pre><code>let sprachen = [];\nsprachen[0] = 'C';\nsprachen[1] = 'C++';\nsprachen[2] = 'Java';\nsprachen[3] = 'JavaScript';</code></pre>\n\nHier wird ein leeres Array nacheinander mit den aufgef\xFChrten Werten gef\xFCllt.",task:"Schreibe eine Funktion <code>setFirstElement</code>, die ein Array und einen beliebigen Wert entgegennimmt.\nDer Wert soll als erstes Element in das Array geschrieben werden. Das Array soll dann zur\xFCckgegeben werden.<br><br>\nBeispiel: <code>setFirstElement([1, 2], 3)</code> sollte <code>[3, 2]</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("setFirstElement")},function(){return jshero.testutil.assert_functionHasNumOfParameter("setFirstElement",2)},function(){return jshero.testutil.assert_functionReturns("setFirstElement([1, 2], 3)",[3,2])},function(){return jshero.testutil.assert_functionReturns("setFirstElement(['Hein', 'Gretel'], 'H\xE4nsel')",["H\xE4nsel","Gretel"])},function(){return jshero.testutil.assert_functionReturns("setFirstElement([1, 'Maus'], 'kleine')",["kleine","Maus"])}]});
jshero.koans.add({id:"arrayindexof",title:"Array: indexOf()",lesson:"Mit der <code>indexOf</code> Methode kann man die Positions des \xFCbergebenen Elements innerhalb eines\nArrays bestimmen. Die Z\xE4hlung beginnt mit 0:\n\n<pre><code>let systems = ['Debian', 'Ubuntu', 'Mint'];\nlet i1 = systems.indexOf('Mint');\nlet i2 = systems.indexOf('Windows');</code></pre>\n\n<code>i1</code> erh\xE4lt den Wert <code>2</code>, da <code>'Mint'</code> das 2te Element in\n<code>systems</code> ist. <code>i2</code> erh\xE4lt den Wert <code>-1</code>.\nDieser Wert wird zur\xFCckgegeben, wenn sich das \xFCbergebene Element nicht im Array befindet.",task:"Schreibe eine Funktion <code>add</code>, die ein Array und ein Element entgegennimmt und das Element an das Ende des Arrays h\xE4ngt.\nDas Element soll aber nur dann angeh\xE4ngt werden, wenn es sich nicht schon im Array befindet. Das neue Array soll zur\xFCckgegeben werden. <br><br>Beispiel:\n<code>add([1, 2], 3)</code> sollte <code>[1, 2, 3]</code> und <code>add([1, 2], 2)</code> sollte\n<code>[1, 2]</code> zur\xFCckgeben.",hint:"<pre><code>function add(arr, elm) {\n  // ...\n  // Benutze if, indexOf() und push() um \n  // das Element dem Array ggf. hinzuzuf\xFCgen.\n  // ...\n  return arr;\n}</code></pre>",solution:"<pre><code>function add(arr, elm) {\n  if (arr.indexOf(elm) === -1) {\n    arr.push(elm);\n  }\n  return arr;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("add")},function(){return jshero.testutil.assert_functionHasNumOfParameter("add",2)},function(){return jshero.testutil.assert_functionReturns("add(['J'], 'S')",["J","S"])},function(){return jshero.testutil.assert_functionReturns("add(['J'], 'J')",["J"])},function(){return jshero.testutil.assert_functionReturns("add([1, 2], 3)",[1,2,3])},function(){return jshero.testutil.assert_functionReturns("add([1, 2], 2)",[1,2])}]});
(function(){let random=function(){return Math.round(Math.random()*10)};jshero.koans.add({id:"arraylength",title:"Array: length",lesson:"Die Eigenschaft <code>length</code> hatten wird schon bei Strings kennengelernt. Dort gab sie die Anzahl\nder Zeichen eines Strings zur\xFCck. Bei Arrays gibt sie die Anzahl der Elemente zur\xFCck.\n\n<pre><code>let sprachen = [];\nlet l0 = sprachen.length;\nsprachen[0] = 'C';\nlet l1 = sprachen.length;\nsprachen[1] = 'C++';\nlet l2 = sprachen.length;</code></pre>\n\nDas leere Array zu Anfang enth\xE4lt keine Elemente. <code>l0</code> ist also <code>0</code>.\nNun f\xFCllen wir das Array nach und nach. <code>l1</code> und <code>l2</code> haben dann die Werte <code>1</code> und <code>2</code>.\nBeachte: Die L\xE4nge eines Arrays ist immer um 1 gr\xF6\xDFer als der h\xF6chste Index des Arrays.",task:"Schreibe eine Funktion <code>getLastElement</code>, die ein Array entgegennimmt und die das letzte Element\ndes Arrays zur\xFCckgibt.<br><br>Beispiel: <code>getLastElement([1, 2])</code> sollte <code>2</code> zur\xFCckgeben.",hint:"Bestimme den Index des letzten Elements mit der Array-Eigenschaft <code>length</code>.\nBeachte, dass das erste Element im Array den Index <code>0</code> besitzt.",solution:"<pre><code>function getLastElement(anArray) {\n  let lastIndex = anArray.length - 1;\n  return anArray[lastIndex];\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("getLastElement")},function(){return jshero.testutil.assert_functionHasNumOfParameter("getLastElement",1)},function(){return jshero.testutil.assert_functionReturns("getLastElement([1, 2])",2)},function(){return jshero.testutil.assert_functionReturns("getLastElement(['H\xE4nsel', 'Gretel'])","Gretel")},function(){return jshero.testutil.assert_functionReturns("getLastElement(['a', 'b', 'c'])","c")},function(){return jshero.testutil.assert_functionReturns("getLastElement(['Maus', 1])",1)},function(){let testArray=new Array;let testArrayString="[";let size=4;for(let i=0;i<size-1;i++){testArray[i]=random();testArrayString+=testArray[i]+", "}testArray[size-1]=random();testArrayString+=testArray[size-1]+"]";return jshero.testutil.assert_functionReturns("getLastElement("+testArrayString+")",testArray[size-1])}]})})();
(function(testutil){jshero.koans.add({id:"arraypush",title:"Array: shift() und push()",lesson:"Arrays besitzen eine Reihe von Methoden. Zwei dieser Methoden sind <code>shift</code> und <code>push</code>.\nZur Erinnerung: Methoden sind Funktionen, die auf einem Objekt, hier einem Array, ausgef\xFChrt werden. Methoden werden mit einem Punkt\nan das Objekt angeh\xE4ngt. Wie bei Funktionen \xFCblich folgt dem Methodennamen die runden Klammern, ggf. gef\xFCllt mit Parametern.\n<code>shift</code> hat keine Parameter und verschiebt die Elemente eines Arrays nach links.\nDas 1te Element wird zum 0ten, das 2te zum 1ten, das 3te zum 2ten, usw.\nDas 0te Element wird aus dem Array entfernt und zur\xFCckgegeben. Nach dem <code>shift</code> hat das Array ein Element weniger.\n\n<pre><code>let sprachen = ['C', 'Java', 'JavaScript'];\nlet naechsteSprache = sprachen.shift();</code></pre>\n\nDas Array <code>sprachen</code> wird mit 3 Programmiersprachen angelegt.\nNach dem <code>shift</code> enth\xE4lt <code>sprachen</code> nur noch 2 Elemente,\nn\xE4mlich <code>['Java', 'JavaScript']</code>. Der Wert <code>'C'</code> ist in der Variablen\n<code>naechsteSprache</code> gelandet.<br>\nMit der h\xE4ufig verwendeten Methode <code>push</code> f\xFCgt man dem Array ein neues Element hinzu.\nDas neue Element wird als Parameter \xFCbergeben und an das Ende des Arrays geh\xE4ngt.\n\n<pre><code>let sprachen = [];\nsprachen.push('C');\nsprachen.push('Java');\nsprachen.push('JavaScript');</code></pre>\n\nHier wird ein leeres Array nacheinander mit den aufgef\xFChrten Werten gef\xFCllt. Am Ende erhalten wir das Array\n<code>['C', 'Java', 'JavaScript']</code>. Wir hatten gesehen, dass man ein Array auch per Index f\xFCllen kann.\n<code>sprachen[sprachen.length] = 'PHP'</code> ist dasselbe wie <code>sprachen.push('PHP')</code>. Doch schon\nan der L\xE4nge des Codes sieht man, dass die Variante mit <code>push</code> eleganter ist.",task:"Schreibe eine Funktion <code>rotate</code>, die die Elemente eines Arrays rotiert.\nAlle Elemente des Arrays sollen um eine Position nach links verschoben werden.\nDas 0te Element soll ans Ende des Arrays gestellt werden. Das rotierte Array soll zur\xFCckgegeben werden.<br><br>Beispiel:\n<code>rotate(['a', 'b', 'c'])</code> sollte <code>['b', 'c', 'a']</code> ergeben.",hint:"Entferne mit <code>shift</code> das 0te Element.\nF\xFCge mit <code>push</code> das 0te Element wieder hinzu.",solution:"<pre><code>function rotate(anArray) {\n  let element0 = anArray.shift();\n  anArray.push(element0);\n  return anArray;\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("rotate")},function(){return testutil.assert_functionHasNumOfParameter("rotate",1)},function(){return testutil.assert_functionReturns("rotate([1, 2])",[2,1])},function(){return testutil.assert_functionReturns("rotate(['a', 'b', 'c'])",["b","c","a"])},function(){return testutil.assert_functionReturns("rotate([1, 'b', 'c', 37])",["b","c",37,1])}]})})(jshero.testutil);
jshero.koans.add({id:"arraysort",title:"Arrays sortieren",lesson:"Jetzt k\xF6nnen wir Arrays mit vorgegebener L\xE4nge sortieren.",task:"Schreibe eine Funktion <code>sortiere</code>, die ein mit 3 beliebigen Zahlen gef\xFClltes Array entgegennimmt\nund die diese 3 Zahlen aufsteigend sortiert als Array  zur\xFCckgibt.<br><br>Beispiel:\n<code>sortiere([2,&nbsp;3,&nbsp;1])</code> sollte <code>[1,&nbsp;2,&nbsp;3]</code> und\n<code>sortiere([11,&nbsp;-1,&nbsp;4])</code> sollte <code>[-1,&nbsp;4,&nbsp;11]</code>ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("sortiere")},function(){return jshero.testutil.assert_functionHasNumOfParameter("sortiere",1)},function(){return jshero.testutil.assert_functionReturns("sortiere([1, 2, 3])",[1,2,3])},function(){return jshero.testutil.assert_functionReturns("sortiere([1, 3, 2])",[1,2,3])},function(){return jshero.testutil.assert_functionReturns("sortiere([2, 1, 3])",[1,2,3])},function(){return jshero.testutil.assert_functionReturns("sortiere([2, 3, 1])",[1,2,3])},function(){return jshero.testutil.assert_functionReturns("sortiere([3, 1, 2])",[1,2,3])},function(){return jshero.testutil.assert_functionReturns("sortiere([3, 2, 1])",[1,2,3])}]});
jshero.koans.add({id:"arrow",title:"Pfeilfunktionen",lesson:"Pfeilfunktionen (engl.: arrow functions) bieten verschiedene M\xF6glichkeiten, Funktionsausdr\xFCcke noch\nk\xFCrzer zu schreiben. Zun\xE4chst kann <code>function</code> durch einen Pfeil ersetzt werden:\n\n<pre><code>const f1 = function(a, b) {\n  const offset = 100;\n  return a + b + offset;\n};\n\nconst f2 = (a, b) => {\n  const offset = 100;\n  return a + b + offset;\n};</code></pre>\n\nDie beiden Funktionen <code>f1</code> und <code>f2</code> sind funktional identisch. <code>f1</code>\nwird ein anonymer Funktionsausdruck zugeordnet, <code>f2</code> eine Pfeilfunktion.<br><br>\nKann man den return-Wert direkt mit einem Ausdruck bestimmen, so kann man das <code>return</code>\nzusammen mit den Funktionsklammern weglassen:\n\n<pre><code>const f3 = function(a, b) {\n  return a * b * 100;\n};\n\nconst f4 = (a, b) => a * b * 100;</code></pre>\n\n<code>f3</code> und <code>f4</code> sind wieder funktional identisch.<br><br>\nBesitzt die Funktion nur einen Parameter, so ergibt sich eine weitere Vereinfachung.\nIn diesem Fall kann man die Parameter-Klammer weglassen:\n\n<pre><code>const f5 = function(a) {\n  return a * a;\n};\n\nconst f6 = a => a * a;</code></pre>\n\nPfeilfunktionen werden, wie wir sp\xE4ter sehen, haupts\xE4chlich in der funktionalen Programmierung verwendet.<br><br>\nDa man die Verwendung von Pfeilfunktionen nur schwer testen kann, hier eine anspruchsvolle Aufgabe aus\ndem Gebiet der Mathematik:",task:"Schreibe eine Funktion <code>toDecimal</code>, die einen String mit einer\n<a href=\"https://de.wikipedia.org/wiki/Dualsystem\">Bin\xE4rzahl</a> entgegennimmt und diese als Dezimalzahl zur\xFCckgibt.<br><br>\nBeispiel: <code>toDecimal(\"10\")</code> sollte <code>2</code> und\n<code>toDecimal(\"101\")</code> sollte <code>5</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("toDecimal")},function(){return jshero.testutil.assert_functionHasNumOfParameter("toDecimal",1)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"0\")",0)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"1\")",1)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"10\")",2)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"11\")",3)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"100\")",4)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"101\")",5)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"110\")",6)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"111\")",7)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"1000\")",8)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"10000000000\")",1024)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"11111010000\")",2000)},function(){return jshero.testutil.assert_functionReturns("toDecimal(\"101110111000\")",3000)}]});
jshero.koans.add({id:"bool",title:"Wahrheitswerte",lesson:"Der dritte wichtige Datentyp neben Strings und Zahlen sind Wahrheitswerte. Sie werden auch boolesche Werte\ngenannt. Boolesche Werte kennen nur zwei Zust\xE4nde: <code>true</code> und <code>false</code>. Mit booleschen Werten kann\nman \xE4hnlich \"rechnen\" wie mit Zahlen. JavaScript kennt drei boolesche Operatoren: '<code>&&</code> (und),\n<code>||</code> (oder) und <code>!</code> (nicht). Das Ergebnis dieser Operationen ist wieder ein boolescher Wert.\n<code>&&</code> verkn\xFCpft zwei boolesche Werte. Sind beide Werte <code>true</code>, ist das Ergebnis auch\n<code>true</code>. In allen anderen F\xE4llen ist es <code>false</code>. Bei <code>||</code> ist das Ergebnis\n<code>false</code>, wenn beide Eingangswerte auch <code>false</code> sind. In  allen anderen F\xE4llen ist das Ergebnis\n<code>true</code>. <code>!</code> wird nur auf einen booleschen Wert angewendet und invertiert diesen Wert: aus\n<code>true</code> wird <code>false</code> und aus <code>false</code> wird <code>true</code>.\n\n<pre><code>let x1 = true && false;\nlet x2 = !x1;\nlet x3 = x1 || x2;</code></pre>\n\n<code>x1</code> ist <code>false</code>,  <code>x2</code> ist <code>true</code> und <code>x3</code> ist ebenfalls\n<code>true</code>.",task:"Schreibe eine Funktion <code>nand</code>, die zwei boolesche Werte als Parameter entgegennimmt. Die R\xFCckgabe\nder Funktion soll <code>false</code> sein, wenn beide Paramter <code>true</code> sind. In den anderen F\xE4llen soll die\nR\xFCckgabe <code>true</code> sein.<br><br>D. h.: <code>nand(true, true)</code> soll <code>false</code> liefern,\n<code>nand(true, false)</code>, <code>nand(false, true)</code> und <code>nand(false, false)</code> sollen\n<code>true</code> zur\xFCckgeben.",hint:"<pre><code>function nand(a, b) {\n  let and = a && b;\n  ...\n}</code></pre>",solution:"<pre><code>function nand(a, b) {\n  let and = a && b;\n  return !and;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("nand")},function(){return jshero.testutil.assert_functionHasNumOfParameter("nand",2)},function(){return jshero.testutil.assert_functionReturns("nand(true, true)",false)},function(){return jshero.testutil.assert_functionReturns("nand(true, false)",true)},function(){return jshero.testutil.assert_functionReturns("nand(false, true)",true)},function(){return jshero.testutil.assert_functionReturns("nand(false, false)",true)}]});
jshero.koans.add({id:"break",title:"break und continue",lesson:"Mit <code>break</code> wird eine Schleife beendet. Das Programm wird nach der Schleife fortgesetzt.\n\n<pre><code>let words = 'blau wei\xDF rot';\nlet indexFirstSpace = -1;\nfor (let i = 0; i < words.length; i++) {\n  if (words.charAt(i) === ' ') {\n    indexFirstSpace = i;\n    break;\n  }\n}</code></pre>\n\nIst das Zeichen mit dem Index <code>i</code> in <code>words</code> das Leerzeichen, so ist die\n<code>if</code>-Bedingung erf\xFCllt. <code>indexFirstSpace</code> bekommt den Laufindex <code>i</code> zugewisen\nund der <code>break</code>-Befehl wird ausgef\xFChrt. Die Schleife wird beendet.\nDie Codeausf\xFChrung wird nach der Schleife fortgesetzt. In unserem Beispiel ist das Zeichen mit dem Index <code>4</code>\ndas Leerzeichen. Sobald die Schleifenvariable <code>i</code> den Wert <code>4</code> erreicht hat,\nbekommt <code>indexFirstSpace</code> den Wert <code>4</code> zugewiesen und die Schleife wird beendet.<br><br>\n\nMit <code>continue</code> wird der aktuelle Schleifendurchlauf beendet. Die Programmausf\xFChrung springt zum Schleifenkopf.\n\n<pre><code>let sum = 0;\nfor (let i = 0; i < 10; i++) {\n  if (i % 2 === 0) {\n    continue;\n  }\n  sum = sum + i;\n}</code></pre>\n\nIst <code>i</code> eine ungerade Zahl, so gilt: i modulo 2 = 1. Die <code>if</code> - Bedingung ist nicht erf\xFCllt.\nDie Codeausf\xFChrung wird nach dem <code>if</code> fortgesetzt und <code>i</code> wird zu <code>sum</code> hinzugez\xE4hlt.\nIst <code>i</code> eine gerade Zahl, so gilt: i modulo 2 = 0. Die <code>if</code> - Bedingung ist erf\xFCllt und\n<code>continue</code> wird ausgef\xFChrt. Die Code-Ausf\xFChrung springt direkt zum Schleifenkopf. <code>i</code> wird nicht\nzu <code>sum</code> hinzugez\xE4hlt. So werden alle ungeraden Zahlen kleiner 10 aufaddiert.<br><br>\n<code>break</code> und <code>continue</code> kann man in allen Schleifen (for, while, do...while) verwenden.",task:"Schreibe eine Funktion <code>isPrime</code>. Sie soll pr\xFCfen, ob eine \xFCbergebene Zahl eine Primzahl ist oder\nnicht. Ist die Zahl prim, so soll <code>true</code> zur\xFCckgegeben werden, im anderen Fall <code>false</code>. Eine\n<a href='https://de.wikipedia.org/wiki/Primzahl'>Primzahl</a> ist eine nat\xFCrliche Zahl, die gr\xF6\xDFer als 1 und nur durch\nsich selbst und durch 1 teilbar ist.<br><br>\nBeispiel: <code>isPrime(2)</code> soll <code>true</code> und <code>isPrime(4)</code> soll <code>false</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("isPrime")},function(){return jshero.testutil.assert_functionHasNumOfParameter("isPrime",1)},function(){return jshero.testutil.assert_functionReturns("isPrime(1)",false)},function(){return jshero.testutil.assert_functionReturns("isPrime(2)",true)},function(){return jshero.testutil.assert_functionReturns("isPrime(3)",true)},function(){return jshero.testutil.assert_functionReturns("isPrime(4)",false)},function(){return jshero.testutil.assert_functionReturns("isPrime(11)",true)},function(){return jshero.testutil.assert_functionReturns("isPrime(281)",true)},function(){return jshero.testutil.assert_functionReturns("isPrime(351)",false)}]});
(function(ArrayUtil){jshero.koans.add({id:"bubblesort",title:"Bubblesort",lesson:"H\xE4ufig m\xF6chte man Daten der Gr\xF6\xDFe nach sortieren. Hierf\xFCr gibt es verschiedene Sortierverfahren. Ein bekanntes,\neinfaches, aber auch langsames Verfahren ist <a href=\"https://de.wikipedia.org/wiki/Bubblesort\">Bubblesort</a>.\nLiegen die zu sortierenden Daten in einem Array der L\xE4nge n vor und sollen die Daten aufsteigend sortiert werden,\nso wird in einer sogenannten Bubble-Phase das Array vom 1 &apos;ten bis zum n-1 &apos;ten Element durchlaufen.\nDabei wird in jedem Schritt das aktuelle Element an der Stelle i mit dem nachfolgenden Element an der Stelle i+1 verglichen.\nIst das Element an der Stelle i gr\xF6\xDFer als das Element an der Stelle i+1, so vertauscht man beide Elemente.\nHat man so eine Bubble-Phase durchlaufen, ist das gr\xF6\xDFte Element am Ende des Arrays angekommen.\nWiederholt man nun eine Bubble-Phase, so steht auch das zweitgr\xF6\xDFte Element an der richtigen Stelle.\nHat man n-1 Bubble-Phasen durchlaufen, ist das komplette Array sortiert.\nUm ein Array mit 4 Zahlen zu sortieren, ben\xF6tigt man also drei Bubble-Phasen:\n\n<pre><code>Erste Bubble-Phase:\n[4, 2, 3, 1] -> [2, 4, 3, 1] Das erste Element wird mit dem zweiten verglichen. Sie werden vertauscht, da 4>2 ist.\n[2, 4, 3, 1] -> [2, 3, 4, 1] Das zweite Element wird mit dem dritten verglichen. Sie werden vertauscht, da 4>3 ist.\n[2, 3, 4, 1] -> [2, 3, 1, 4] Das dritte Element wird mit dem vierten verglichen. Sie werden vertauscht, da 4>1 ist.\nDas gr\xF6\xDFte Element ist an die richtige Stelle geblubbert.\n\nZweite Bubble-Phase:\n[2, 3, 1, 4] -> [2, 3, 1, 4] Das erste Element wird mit dem zweiten verglichen. Sie werden nicht vertauscht, da 2<3 ist.\n[2, 3, 1, 4] -> [2, 1, 3, 4] Das zweite Element wird mit dem dritten verglichen. Sie werden vertauscht, da 3>1 ist.\n[2, 1, 3, 4] -> [2, 1, 3, 4] Das dritte Element wird mit dem vierten verglichen. Sie werden nicht vertauscht, da 3<4 ist.\nDas zweitgr\xF6\xDFte Element ist an die richtige Stelle geblubbert.\n\nDritte Bubble-Phase:\n[2, 1, 3, 4] -> [1, 2, 3, 4] Das erste Element wird mit dem zweiten verglichen. Sie werden vertauscht, da 2>1 ist.\n[1, 2, 3, 4] -> [1, 2, 3, 4] Das zweite Element wird mit dem dritten verglichen. Sie werden nicht vertauscht, da 2<3 ist.\n[1, 2, 3, 4] -> [1, 2, 3, 4] Das dritte Element wird mit dem vierten verglichen. Sie werden vertauscht, da 3<4 ist.\nDas drittgr\xF6\xDFte Element ist an die richtige Stelle geblubbert.\nDamit ist automatisch auch das kleinste Element an der richtigen Stelle.\nDas Array ist aufsteigend sortiert.</code></pre>",task:"Schreibe eine Funktion <code>sort</code>, die ein mit Zahlen gef\xFClltes Array entgegennimmt und die diese Zahlen\naufsteigend sortiert als Array zur\xFCckgibt. Wird ein leeres Array \xFCbergeben, so soll auch ein leeres Array zur\xFCckgegeben\nwerden.<br><br>Beispiel:\n<code>sort([4,&nbsp;2,&nbsp;3,&nbsp;1])</code> sollte <code>[1,&nbsp;2,&nbsp;3,&nbsp;4]</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("sort")},function(){return jshero.testutil.assert_functionHasNumOfParameter("sort",1)},function(){return jshero.testutil.assert_functionReturns("sort([])",[])},function(){return jshero.testutil.assert_functionReturns("sort([1])",[1])},function(){return jshero.testutil.assert_functionReturns("sort([3, 1])",[1,3])},function(){return jshero.testutil.assert_functionReturns("sort([3, 1, 2])",[1,2,3])},function(){return jshero.testutil.assert_functionReturns("sort([3, 2, 1])",[1,2,3])},function(){return jshero.testutil.assert_functionReturns("sort([5, 4, 3, 2, 1])",[1,2,3,4,5])},function(){return jshero.testutil.assert_functionReturns("sort(['c', 'a', 'b'])",["a","b","c"])}]})})(jshero.array);
jshero.koans.add({id:"comment",title:"Kommentare",lesson:"Neben dem eigentlichen Code kann man Kommentare schreiben. Kommentare dienen dazu, Programme zu erkl\xE4ren.\nSie helfen uns Menschen, Programme zu verstehen und zu verwenden.\nComputer, die Programme ausf\xFChren, ignorieren Kommentare. In JavaScript gibt zwei M\xF6glichkeiten, Kommentare zu schreiben:\nZeilen-Kommentare werden mit <code>//</code> eingeleitet und gelten immer bis zum Ende der Zeile.\nBlock-Kommentare werden mit <code>/*</code> eingeleitet und mit <code>*/</code> beendet.\nAlles dazwischen ist Kommentar. Hier ein paar Beispiele:\n<pre><code>// Das ist ein Zeilenkommentar.\n\n// Dieser Zeilenkommentar geht\n// \xFCber 2 Zeilen.\n\n/* Das ist ein Blockkommentar. */\n\n/* Dieser Blockkommentar geht\n\xFCber mehrere Zeilen. */\n\n/**\n * Auch dies ist ein Blockkommentar.\n * Die zus\xE4tzlichen Sterne zwischen\n * dem Beginn und dem Ende des\n * Blockkommentars dienen nur zur\n * Verzierung. So sieht ein l\xE4ngerer\n * Blockkommentar \xFCbersichtlicher aus.\n */</code></pre>\n\n Block-Kommentare schreibt man gerne \xFCber Funktionen, Zeilen-Kommentare in den Code-Fluss.\n\n <pre><code>/**\n * Pr\xFCft, ob eine String kein Zeichen\n * au\xDFer Leerzeichen enth\xE4lt.\n */\nfunction isBlank(string) {\n  // Die Methode trim() entfernt Leerzeichen\n  // am Anfang und am Ende einer Zeichenfolge.\n  let trimmedString = string.trim();\n  return trimmedString.length === 0;\n}</code></pre>\n\nDa Kommentare mit den hier verwendeten Tests nicht \xFCberpr\xFCfen werden k\xF6nnen, eine Aufgabe, bei der man vieles von dem bisher Gelernten anwenden muss.",task:"Schreibe eine Funktion <code>median</code>, die ein Array von aufsteigend sortierten Zahlen entgegennimmt und die den Median dieser Zahlen zur\xFCckgibt.\n<code>median([1, 2, 10])</code> sollte <code>2</code> ergeben; <code>median([1, 2, 10, 100])</code> sollte <code>6</code> ergeben.\nDer Median einer sortierten Zahlenreihe ist der Wert, der an der mittleren Stelle steht. Ist die Anzahl der Werte gerade, so ist der Median der Mittelwert\nder beiden mittleren Zahlen.",tests:[function(){return jshero.testutil.assert_isFunction("median")},function(){return jshero.testutil.assert_functionHasNumOfParameter("median",1)},function(){return jshero.testutil.assert_functionReturns("median([1])",1)},function(){return jshero.testutil.assert_functionReturns("median([1, 2])",1.5)},function(){return jshero.testutil.assert_functionReturns("median([1, 2, 10])",2)},function(){return jshero.testutil.assert_functionReturns("median([1, 1, 2, 10, 100, 101])",6)}]});
jshero.koans.add({id:"concat",title:"Array: concat()",lesson:"Mit der <code>concat</code> Methode kann man zwei Arrays aneinanderh\xE4ngen:\n\n<pre><code>let a1 = [1, 2, 3];\nlet a2 = [4, 5, 6];\nlet a3 = a1.concat(a2);</code></pre>\n\n<code>a3</code> enth\xE4lt das Array <code>[1, 2, 3, 4, 5, 6]</code>.\nWichtig ist, dass die beiden urspr\xFCnglichen Arrays <code>a1</code> und <code>a2</code> nicht ver\xE4ndert werden.",task:"Schreibe eine Funktion <code>concatUp</code>, die zwei Arrays zu einem zusammenf\xFChrt.\nDabei soll das l\xE4ngere Array an das k\xFCrzere Array angeh\xE4ngt werden. Sind beide Arrays gleich lang,\nso soll das zweite Array dem ersten Array angeh\xE4ngt werden.<br><br>Beispiel: <code>concatUp([5, 7], [6])</code> sollte\n<code>[6, 5, 7]</code> und <code>concatUp([5, 7], [6, 8])</code> sollte <code>[5, 7, 6, 8]</code> ergeben.",hint:"<pre><code>function concatUp(firstArray, secondArray) {\n  // Benutze if, um zu entscheiden,\n  // in welcher Reihenfolge die beiden\n  // Arrays aneinander geh\xE4ngt werden.\n}</code></pre>",solution:"<pre><code>function concatUp(firstArray, secondArray) {\n\n  if (secondArray.length >= firstArray.length) {\n    return firstArray.concat(secondArray);\n  }\n\n  return secondArray.concat(firstArray);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("concatUp")},function(){return jshero.testutil.assert_functionHasNumOfParameter("concatUp",2)},function(){return jshero.testutil.assert_functionReturns("concatUp([5, 7], [6])",[6,5,7])},function(){return jshero.testutil.assert_functionReturns("concatUp(['x'], ['a', 'b'])",["x","a","b"])},function(){return jshero.testutil.assert_functionReturns("concatUp([5, 7], [6, 8])",[5,7,6,8])}]});
(function(testutil){jshero.koans.add({id:"const",title:"Konstanten",lesson:"Bisher haben wir Variablen mit <code>let</code> deklariert. Solchen Variablen kann man beliebig oft einen\nneuen Wert zuweisen. Manchmal kommt es jedoch vor, dass eine Variable ihren Wert garnicht \xE4ndern soll.\nEine solche Variable k\xF6nnte man nat\xFCrlich auch mit <code>let</code> deklarieren. Man muss dann aufpassen,\ndass man ihren Wert nicht aus Versehen \xE4ndert. Besser w\xE4re es, wenn man ihren Wert erst garnicht \xE4ndern kann. Hier kommt\n<code>const</code> ins Spiel:\n\n<pre><code>const MEHRWERTSTEUER = 19;\nlet netto = 100;\nlet steuer = netto * MEHRWERTSTEUER / 100;\nconsole.log(steuer);\n\nMEHRWERTSTEUER = 20; // Programmfehler!\nnetto = 200;\nsteuer = netto * MEHRWERTSTEUER / 100;\nconsole.log(steuer);</code></pre>\n\nEine Deklaration mit <code>const</code> erzeugt eine Konstante. Eine Konstante funktioniert genauso wie eine mit\n<code>let</code> erzeugte Variable. Mit einem Unterschied: weist man einer Konstante einen neuen Wert zu, so kommt\nes zu einem Programmfehler. F\xFChrt man obigen Code im <a href=\"../playground.html\">JS-Hero Playground</a> aus,\nso wird korrekt <code>19</code> ausgegeben. Die n\xE4chste Steuer wird allerdings nicht ausgegeben.\nStattdessen erhalten wir einen Fehler wie \"invalid assignment to const 'MEHRWERTSTEUER'\". In Zeile 6 haben wir der\nKonstanten <code>MEHRWERTSTEUER</code> den neuen Wert <code>20</code> zugeordnet. Das ist nicht erlaubt. Das Programm\nbricht an dieser Stelle mit dem genannten Fehler ab. Entfernt man diese Zeile, l\xE4uft das Programm korrekt durch.\n<br><br>\nEiner Konstante muss man direkt bei der Deklaration einen Wert zuweisen. Eine Konstante nur deklarieren und ihr\nsp\xE4ter einen Wert zuzuweisein, ist nicht zul\xE4ssig.\n\n<pre><code>const HOUR_IN_SECONDS = 3600; // Korrekt!\nconst NUMBER_OF_WEEKDAYS; // Programmfehler!\nNUMBER_OF_WEEKDAYS = 7;</code></pre>\n\nDas Programm bricht in der zweiten Zeile mit einen Fehler wie \"missing = in const declaration\" ab.\n<br><br>\nNoch ein stylistischer Hinweis: Wir haben Konstanten mit Gro\xDFbuchstaben geschrieben. Das ist keine Vorgabe.\nWir h\xE4tten sie auch klein schreiben k\xF6nnen. <code>mehrwertsteuer</code> geht genauso gut wie\n<code>MEHRWERTSTEUER</code>. Die Gro\xDFschreibung hat jedoch den Vorteil, dass man Konstanten schon an ihrer Schreibweise\nerkennt.\n<br><br>\nDa man die Verwendung von Konstanten nicht gut testen kann, hier eine komplexere Aufgabe aus dem Bereich der\nMathematik.",task:"Schreibe eine Funktion <code>primes</code>, die eine nat\xFCrliche Zahl n entgegennimmt und ein Array aller\n<a href=\"https://de.wikipedia.org/wiki/Primzahl\">Primzahlen</a> kleiner gleich n zur\xFCckgibt.<br><br>\nBeispiel: <code>primes(10)</code> sollte <code>[2, 3, 5, 7]</code> zur\xFCckgeben.",tests:[function(){return testutil.assert_isFunction("primes")},function(){return testutil.assert_functionHasNumOfParameter("primes",1)},function(){return testutil.assert_functionReturns("primes(1)",[])},function(){return testutil.assert_functionReturns("primes(2)",[2])},function(){return testutil.assert_functionReturns("primes(3)",[2,3])},function(){return testutil.assert_functionReturns("primes(10)",[2,3,5,7])},function(){return testutil.assert_functionReturns("primes(30)",[2,3,5,7,11,13,17,19,23,29])}]})})(jshero.testutil);
jshero.koans.add({id:"date",title:"Datum und Uhrzeit",lesson:"Um mit Datum und Uhrzeit zu arbeiten, verwendet man <code>Date</code>-Objekte. Ein <code>Date</code>-Objekt repr\xE4sentiert\neinen Zeitpunkt, also ein Datum zusammen mit einer Uhrzeit. Die Uhrzeit wird dabei auf die Millisekunde genau festgelegt.\nEin Date-Objekt erzeugt man mit <code>new Date()</code>. Es gibt 4 m\xF6gliche Aufrufe:\n\n<pre><code>// aktueller Zeitpunkt\nlet d1 = new Date();</code></pre>\n\nOhne Parameter erzeugt <code>new Date()</code> ein Date-Objekt, das dem Zeitpunkt seines Aufrufs entspricht. Wird obiges Beispiel\nam 1. Mai 2017 um 8:15 Uhr aufgerufen, so enth\xE4lt <code>d1</code> eben diesen Zeitpunkt.\n\n<pre><code>// Aufruf mit Jahr, Monat, Tag,\n// Stunde, Minute, Sekunde, Millisekunde\nlet d2 = new Date(2017, 2, 8, 16, 31, 10, 117);</code></pre>\n\nBei der zweiten Variante \xFCbergibt man als Parameter das Jahr, den Monat, den Tag, die Stunde, die Minute, die Sekunde und die Millisekunde.\nDas Jahr sollte man in voller L\xE4nge \xFCbergeben. Aufpassen muss man f\xFCr Jahreszahlen zwischen 0 und 99. Hier wird ungl\xFCcklicherweise 1900 hinzuaddiert.\n<code>17</code> ergibt das Jahr 1917. Bei dem Monat muss man ebenfalls aufpassen. JavaScript nummeriert die Monate von 0 (Januar) bis 11 (Dezember).\nAlle weiteren Zahlen entsprechen der \xFCblichen Bedeutung. <code>d2</code> repr\xE4sentiert also den\nZeitpunkt 8.3.2017, 16:31:10 Uhr und 117 Millisekunden.<br>\nDie Parameter Millisekunde, Sekunde, Minute, Stunde und Tag sind - in dieser Reihenfolge - optional. Man kann sie weglassen.\nGibt man sie nicht an, werden die Zeitangaben automatisch auf 0 gesetzt. Der Tag wird auf den Monatsersten gesetzt.\nDas ist besonders praktisch, wenn man nur mit einem Datum arbeiten m\xF6chte.\nDann l\xE4\xDFt man einfach alle Zeitangaben weg. <code>new&nbsp;Date(2017, 5, 2)</code> ist der 2.6.2017, 0:00 Uhr.\n\n<pre><code>// Millisekunden seit dem 1.1.1970\nlet d3 = new Date(86400000);</code></pre>\n\nBei der dritten Variante \xFCbergibt man die vergangenen Millisekunden seit dem 1.1.1970, 0:00 Uhr.\nDer Bezugspunkt 1.1.1970 f\xFCr Datumsangaben ist seit den Tagen von Unix und der Programmiersprache C in der IT \xFCblich geworden.\nEin Tag hat 24 * 60 * 60 * 1000 = 86400000 Millisekunden. <code>d3</code> ist also der 2.1.1970, 0:00 Uhr.\n\n<pre><code>// \xDCbergabe eines Datumsstrings\nlet d4 = new Date('2017-03-08T16:31:10.117');</code></pre>\n\nBei der vierten Variante wird ein Datumsstring im sogenannten <a href=\"https://de.wikipedia.org/wiki/ISO_8601\">ISO-Format</a> \xFCbergeben.\n<code>d4</code> entspricht ebenfalls dem Zeitpunkt 8.3.2017, 16:31:10 Uhr und 117 Millisekunden.",task:"Schreibe eine Funktion <code>nikolaus</code>, die eine Jahresangabe als Zahl entgegennimmt und die ein Date-Objekt mit dem 6. Dezember\ndes \xFCbergebenen Jahres, 0:00 Uhr, zur\xFCckgibt.<br><br>\nBeispiel: <code>nikolaus(2017)</code> sollte ein Date-Objekt mit dem Zeitpunkt 6.12.2017, 0:00 Uhr zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("nikolaus")},function(){return jshero.testutil.assert_functionHasNumOfParameter("nikolaus",1)},function(){return jshero.testutil.assert_functionReturnsType("nikolaus(2017)","Date")},function(){return jshero.testutil.assert_functionReturns("nikolaus(2017)",new Date(2017,11,6))},function(){return jshero.testutil.assert_functionReturnsType("nikolaus(1960)","Date")},function(){return jshero.testutil.assert_functionReturns("nikolaus(1960)",new Date(1960,11,6))}]});
jshero.koans.add({id:"date2",title:"Datum und Uhrzeit ausgeben",lesson:"Zur Ausgabe der Daten eines Date-Objekts gibt es sieben sogenannte Getter-Methoden:\n\n<pre><code>let startFastnacht = new Date(2017, 10, 11, 11, 11);\nlet jahr = startFastnacht.getFullYear();\nlet monat = startFastnacht.getMonth();\nlet tag = startFastnacht.getDate();\nlet stunde = startFastnacht.getHours();\nlet minute = startFastnacht.getMinutes();\nlet sekunde = startFastnacht.getSeconds();\nlet millisekunde = startFastnacht.getMilliseconds();</code></pre>\n\nMan erh\xE4lt die erwarteten Werte: <code>2017</code> f\xFCr das Jahr, <code>10</code> f\xFCr den Monat,\n<code>11</code> f\xFCr den Tag, die Stunde und die Minute, sowie <code>0</code> f\xFCr die Sekunde und die Millisekunde.\nDie Monatsz\xE4hlung beginnt wie beim Erzeugen eines Date-Objektes mit <code>0</code>.\nDie Zahl <code>10</code> steht also f\xFCr den November.",task:"Schreibe eine Funktion <code>toGerman</code>, die ein Date-Objekt entgegennimmt und dessen Datum im Format\n'd.M.YYYY' zur\xFCckgibt.<br><br>Beispiel: Mit <code>date = new Date(2017, 2, 8)</code> sollte\n<code>toGerman(date)</code> den String <code>'8.3.2017'</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("toGerman")},function(){return jshero.testutil.assert_functionHasNumOfParameter("toGerman",1)},function(){return jshero.testutil.assert_functionReturns("toGerman(new Date(2017, 2, 8))","8.3.2017")},function(){return jshero.testutil.assert_functionReturns("toGerman(new Date(1724, 3, 22))","22.4.1724")}]});
jshero.koans.add({id:"date3",title:"Datum und Uhrzeit \xE4ndern",lesson:"Passend zu den sieben Getter-Methoden besitzt das Date-Objekt sieben Setter-Methoden:\n<code>setFullYear()</code>, <code>setMonth()</code>, <code>setDate()</code>, <code>setHours()</code>, <code>setMinutes()</code>,\n<code>setSeconds()</code> und <code>setMilliseconds()</code>.\nMit diesen 7 Methoden kann man den entsprechenden Date-Eintrag setzen:\n\n<pre><code>let today = new Date();\ntoday.setHours(0);\ntoday.setMinutes(0);\ntoday.setSeconds(0);\ntoday.setMilliseconds(0);</code></pre>\n\n<code>today</code> enth\xE4lt zun\xE4chst den Zeitpunkt seiner Erstellung.\nAnschlie\xDFend wird mit den vier Setter-Aufrufen die Zeit auf 0:00:00.000 Uhr gesetzt.\nSo enth\xE4lt <code>today</code> das aktuelle Tagesdatum mit zur\xFCckgesetzter Uhrzeit.<br><br>\n\xDCberschreitet oder unterschreitet man bei einer dieser Methoden den zul\xE4ssigen Wertebereich,\ndann rechnen diese Methoden den \xDCber- oder Untertrag automatisch um:\n\n<pre><code>let someDay = new Date(2020, 3, 1);\nsomeDay.setDate(32);\nsomeDay.setDate(0);</code></pre>\n\nZun\xE4chst repr\xE4sentiert <code>someDay</code> den 1.4.2020. Nun wird der Tag auf den 32. gesetzt.\nDa der April 30 Tage hat, entspricht das dem 2.5.2020. Wird nun der Tag auf 0 gesetzt, erh\xE4lt man den 30.4.2020.",task:"Schreibe eine Funktion <code>yesterday</code>, die ein Date-Objekt entgegennimmt, dessen Datum um einen Tag\nzur\xFCcksetzt und dann dieses Date-Objekt zur\xFCckgibt. Die Uhrzeit soll dabei nicht ver\xE4ndert werden.<br><br>Beispiel:\nMit <code>date = new Date(1965, 8, 14)</code> sollte <code>yesterday(date)</code> ein Date-Objekt zur\xFCckgeben,\ndas den 13.9.1965 repr\xE4sentiert.",tests:[function(){return jshero.testutil.assert_isFunction("yesterday")},function(){return jshero.testutil.assert_functionHasNumOfParameter("yesterday",1)},function(){return jshero.testutil.assert_functionReturnsType("yesterday(new Date(2015, 8, 14))","Date")},function(){return jshero.testutil.assert_functionReturns("yesterday(new Date(2015, 8, 14))",new Date(2015,8,13))},function(){return jshero.testutil.assert_functionReturnsType("yesterday(new Date(2018, 0, 1, 12))","Date")},function(){return jshero.testutil.assert_functionReturns("yesterday(new Date(2018, 0, 1, 12))",new Date(2017,11,31,12))}]});
(function(testutil){jshero.koans.add({id:"dimarray",title:"Mehrdimensionale Arrays",lesson:"Bisher haben wir in Arrays Zahlen, Strings und boolsche Werte gespeichert.\nMan kann aber auch Arrays in Arrays speichern.\n\n<pre><code>let teams = [\n  ['Ruby', 'Angel'],\n  ['Mia', 'Yui', 'Merve', 'Elif'],\n  ['Saanvi', 'Giulia', 'Zeynep']\n];\n\nlet zeile1 = [4, 9, 2];\nlet zeile2 = [3, 5, 7];\nlet zeile3 = [8, 1, 6];\nlet loshu = [zeile1, zeile2, zeile3];</code></pre>\n\nIm ersten Beispiel werden 3 Teams in einem Array gespeichert. Jedes Team ist wiederum ein Array aus Namen.\nDie einzelnen Teams sind verschieden gro\xDF. Mit <pre><code>let team = teams[0];</code></pre> greift man auf ein Team zu\nund mit <pre><code>let member = teams[0][0];</code></pre> kann man auf die einzelnen Teammitglieder zugreifen.<br><br>\nArrays, die Arrays enthalten, nennt man auch zweidimensionals Arrays. Treibt man dies weiter, erh\xE4lt man\ndrei- bzw. mehrdimensionale Arrays.<br><br>\nIm zweiten Beispiel wird das <a href='https://de.wikipedia.org/wiki/Magisches_Quadrat'>magische Quadrat</a> Lo-Shu in einem\nzweidimensionalen Array gespeichert.",task:"Schreibe eine Funktion <code>flat</code>, die ein zweidimensionales Array mit 3 Eintr\xE4gen in ein\neinfaches Array \xFCberf\xFChrt. <code>flat(loshu)</code> sollte <code>[4, 9, 2, 3, 5, 7, 8, 1, 6]</code> ergeben.\nDabei ist <code>loshu</code> das magische Quadrat aus dem obigen Beispiel.",tests:[function(){return testutil.assert_isFunction("flat")},function(){return testutil.assert_functionHasNumOfParameter("flat",1)},function(){return testutil.assert_functionReturns("flat([[], [], []])",[])},function(){return testutil.assert_functionReturns("flat([[1], [], []])",[1])},function(){return testutil.assert_functionReturns("flat([[1], [2], [3]])",[1,2,3])},function(){return testutil.assert_functionReturns("flat([[1, 2], [3, 4], [5, 6]])",[1,2,3,4,5,6])},function(){return testutil.assert_functionReturns("flat([['a'], ['b', 'c'], ['d', 'e', 'f']])",["a","b","c","d","e","f"])}]})})(jshero.testutil);
jshero.koans.add({id:"doubleloop",title:"Geschachtelte Schleifen",lesson:"Schleifen kann man auch ineinander schachteln. Im Falle einer for-Schleife muss man zwei verschiedene\nLaufindizes benutzen.\n\n<pre><code>let a = [[1, 7, 3], [2, 8, 5], [9, 0, 4]];\nlet sum = 0;\nfor (let i = 0; i < 3; i++) {\n  for (let j = 0; j < 3; j++) {\n    sum = sum + a[i][j];\n  }\n}</code></pre>\n\nIm Codeschnipsel wird die Summe aller Elemente eines zweidimensionalen Arrays berechnet.",task:"Schreibe eine Funktion <code>sum</code>, die die Summe aller Elemente eines zweidimensionalen,\nnumerischen Arrays berechnet.<br><br>Beispiel: <code>sum([[1, 2], [3]])</code> sollte <code>6</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("sum")},function(){return jshero.testutil.assert_functionHasNumOfParameter("sum",1)},function(){return jshero.testutil.assert_functionReturns("sum([[1]])",1)},function(){return jshero.testutil.assert_functionReturns("sum([[1, 2], [3]])",6)},function(){return jshero.testutil.assert_functionReturns("sum([[1, 2, 3], [1, 2], [1, 2, 3, 4]])",19)}]});
jshero.koans.add({id:"dowhile",title:"do...while-Schleife",lesson:"Die <code>do...while</code>-Schleife funktioniert \xE4hnlich wie die <code>while</code>-Schleife.\nDer Schleifen-Code wird ausgef\xFChrt, solange die Schleifenbedingung <code>true</code> ergibt.\nEinziger Unterschied ist, dass die Schleifenbedingung nach dem Schleifen-Code \xFCberpr\xFCft wird.\nDadurch ist sichergestellt, dass der Schleifen-Code mindestens einmal durchlaufen wird.\n\n<pre><code>let restDurch6;\nlet restDurch8;\nlet kgV = 0;\ndo {\n  kgV++;\n  restDurch6 = kgV % 6;\n  restDurch8 = kgV % 8;\n} while (restDurch6 !== 0 || restDurch8 !== 0);</code></pre>\n\nDieser Codeabschnitt berechnet das\n<a href='https://de.wikipedia.org/wiki/Kleinstes_gemeinsames_Vielfaches'>kleinste gemeinsame Vielfache (kgV)</a> von 6 und 8.\nDas kgV ist die kleinste Zahl, die sowohl ein Vielfaches von 6 als auch ein Vielfaches von 8 ist.\nDie Vielfachen von 6 sind 6, 12, 18, 24, 30, ... und die Vielfachen von 8 sind 8, 16, 24, 32, ... .\nDamit ist das kgV von 6 und 8 die Zahl 24.<br>\nUnser Codebeispiel pr\xFCft beginnend mit <code>1</code>, ob <code>kgV</code> sowohl durch <code>6</code> als auch durch <code>8</code> teilbar ist.\nDie Teilbarkeit wird mithilfe des Modulo-Operators \xFCberpr\xFCft. Eine Zahl ist durch 6 bzw. 8 teilbar,\nwenn sie Modulo 6 bzw. Modulo 8 den Wert 0 liefert. Die Modulo-Berechnung findet im Schleifen-Code statt.\nIn der Schleifenbedingung wird dann \xFCberpr\xFCft, ob beide Modulo-Berechnungen <code>0</code> ergeben. Ist eine von beiden\nModulo-Berechnungen nicht <code>0</code>, ist die Schleifenbedingung <code>true</code> und der Schleifen-Code wird mit einem um 1 erh\xF6hten <code>kgV</code>\nerneut durchlaufen. Ergeben beide Modulo-Berechnungen <code>0</code>, ist die Schleifenbedingung <code>false</code> und die Schleife wird beendet.\n<code>kgV</code> hat dann den gew\xFCnschten Wert (n\xE4mlich 24), da es die erste Zahl ist, die sowohl durch 6 als auch durch 8 teilbar ist.",task:"Schreibe eine Funktion <code>kgV</code>, die zwei nat\xFCrliche Zahlen als Parameter entgegennimmt und deren kgV berechnet.\n<br><br>Beispiel: <code>kgV(6, 8)</code> sollte <code>24</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("kgV")},function(){return jshero.testutil.assert_functionHasNumOfParameter("kgV",2)},function(){return jshero.testutil.assert_functionReturns("kgV(1, 1)",1)},function(){return jshero.testutil.assert_functionReturns("kgV(1, 2)",2)},function(){return jshero.testutil.assert_functionReturns("kgV(2, 3)",6)},function(){return jshero.testutil.assert_functionReturns("kgV(3, 2)",6)},function(){return jshero.testutil.assert_functionReturns("kgV(4, 6)",12)},function(){return jshero.testutil.assert_functionReturns("kgV(5, 7)",35)},function(){return jshero.testutil.assert_functionReturns("kgV(6, 8)",24)},function(){return jshero.testutil.assert_functionReturns("kgV(10, 20)",20)},function(){return jshero.testutil.assert_functionReturns("kgV(20, 10)",20)}]});
jshero.koans.add({id:"else",title:"if...else",lesson:"Soll ein Codeblock nur dann ausgef\xFChrt werden, wenn eine <code>if</code>-Bedingung\nnicht erf\xFCllt ist, verwendet man zus\xE4tzlich zum <code>if</code> ein <code>else</code> (engl.: sonst).\n\n<pre><code>let mitteilung;\nif (betrag > 1000) {\n  mitteilung = 'Keine Auszahlung m\xF6glich!';\n} else {\n  mitteilung = 'Der Betrag wird ausgezahlt!';\n}</code></pre>\n\nJe nachdem, ob <code>betrag</code> gr\xF6\xDFer oder kleiner <code>1000</code> ist, wird entweder der\n<code>if</code>-Zweig oder der <code>else</code>-Zweig ausgef\xFChrt.",task:"Schreibe eine Funktion <code>addiereMitZuschlag</code>, die zwei Betr\xE4ge mit Zuschlag addiert.\nF\xFCr jeden Betrag, der kleiner gleich <code>10</code> ist, betr\xE4gt der Zuschlag <code>1</code>.\nF\xFCr jeden Betrag, der gr\xF6\xDFer <code>10</code> ist, betr\xE4gt der Zuschlag <code>2</code>.<br><br>Beispiel:\nDer Aufruf <code>addiereMitZuschlag(5, 15)</code> sollte <code>23</code> ergeben.",hint:"<pre><code>function addiereMitZuschlag(a, b) {\n\n  let zuschlag = 0;\n\n  if (a <= 10) {\n    zuschlag = zuschlag + 1;\n  } else ...\n\n  ...\n\n  return a + b + zuschlag;\n}</code></pre>",solution:"<pre><code>function addiereMitZuschlag(a, b) {\n\n  let zuschlag = 0;\n\n  if (a <= 10) {\n    zuschlag = zuschlag + 1;\n  } else {\n    zuschlag = zuschlag + 2;\n  }\n\n  if (b <= 10) {\n    zuschlag = zuschlag + 1;\n  } else {\n    zuschlag = zuschlag + 2;\n  }\n\n  return a + b + zuschlag;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("addiereMitZuschlag")},function(){return jshero.testutil.assert_functionHasNumOfParameter("addiereMitZuschlag",2)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(1, 1)",4)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(10, 10)",22)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(11, 10)",24)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(10, 11)",24)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(11, 11)",26)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(15, 27)",46)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(5, 25)",33)}]});
jshero.koans.add({id:"elseif",title:"else if",lesson:"M\xF6chte man mehrere F\xE4lle unterscheiden, kann man ein <code>if</code> mit beliebig vielen <code>else if</code>\nerg\xE4nzen. Zum Schluss kann bei Bedarf noch ein einzelnes <code>else</code> stehen.\n\n<pre><code>let mitteilung;\nif (betrag > 1000) {\n  mitteilung = 'Zu gro\xDF. Keine Auszahlung m\xF6glich!';\n} else if (betrag < 10) {\n  mitteilung = 'Zu klein. Keine Auszahlung m\xF6glich!';\n} else {\n  mitteilung = 'Der Betrag wird ausgezahlt!';\n}</code></pre>\n\nZuerst wird gepr\xFCft, ob <code>betrag</code> gr\xF6\xDFer <code>1000</code> ist. Ist das der Fall, wird die 'Zu gro\xDF...'-Mitteilung\ngesetzt und der Code am Ende des gesamten Blocks fortgesetzt. Ist das nicht der Fall, wird die <code>else if</code>-Bedingung\ngepr\xFCft. Ist diese erf\xFCllt, wird die 'Zu klein...'-Mitteilung gesetzt und der Code am Ende des gesamten Blocks fortgesetzt.\nErst wenn keine Bedingung erf\xFCllt ist, wird der abschlie\xDFenden <code>else</code>-Block ausgef\xFChrt.",task:"Schreibe eine Funktion <code>addiereMitZuschlag</code>, die zwei Betr\xE4ge mit Zuschlag addiert.\nF\xFCr jeden Betrag, der kleiner gleich <code>10</code> ist, betr\xE4gt der Zuschlag <code>1</code>. F\xFCr jeden\nBetrag, der gr\xF6\xDFer <code>10</code> und kleiner gleich <code>20</code> ist, betr\xE4gt der Zuschlag <code>2</code>.\nF\xFCr jeden Betrag, der gr\xF6\xDFer <code>20</code> ist, betr\xE4gt der Zuschlag <code>3</code>.<br><br>Beispiel:\n<code>addiereMitZuschlag(10, 30)</code> sollte <code>44</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("addiereMitZuschlag")},function(){return jshero.testutil.assert_functionHasNumOfParameter("addiereMitZuschlag",2)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(1, 1)",4)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(10, 10)",22)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(11, 10)",24)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(10, 11)",24)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(11, 11)",26)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(10, 20)",33)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(20, 10)",33)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(10, 21)",35)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(21, 10)",35)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(11, 20)",35)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(20, 11)",35)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(11, 21)",37)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(21, 11)",37)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(20, 20)",44)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(21, 20)",46)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(20, 21)",46)},function(){return jshero.testutil.assert_functionReturns("addiereMitZuschlag(21, 21)",48)}]});
jshero.koans.add({id:"equals",title:"Strikte Gleichheit",lesson:"Zwei Werte kann man auf strikte Gleichheit \xFCberpr\xFCfen. Das Ergebnis eines solchen Vergleichs ist entweder\n<code>true</code>, die beiden Werte sind gleich, oder <code>false</code>, die beiden Werte sind ungleich.\nDer Operator f\xFCr strikte Gleichheit ist <code>===</code>.\n\n<pre><code>let sprache = 'JavaScript';\nlet x = 10;\nlet v1 = sprache === 'Java';\nlet v2 = x === 10;\nlet v3 = x === '10';</code></pre>\n\n<code>v1</code> bekommt das Ergebnis des Vergleichs der Variablen <code>sprache</code> mit dem Wert\n<code>'Java'</code> zugewiesen. Da <code>sprache</code> zuvor den Wert <code>JavaScript</code> erhalten hat und\ndiese beiden Werte verschieden sind, hat <code>v1</code> den Wert <code>false</code>. <code>v2</code> ist\n<code>true</code>, da der Wert von <code>x</code> gleich <code>10</code> ist. Bei der strikten Gleichheit kommt es\nauch darauf an, dass die Datentypen der beiden verglichenen Werte gleich sind. <code>v3</code> ist <code>false</code>,\nda hier unterschiedliche Typen verglichen werden. Auf der linken Seite des Vergleichs steht eine Zahl, auf der\nrechten Seite ein String.",task:"Schreibe eine Funktion <code>gleich</code>, die zwei Werte auf strikte Gleichheit \xFCberpr\xFCft.<br><br>Beispiel:\n<code>gleich(1, 1)</code> soll <code>true</code> und <code>gleich(1, 2)</code> soll <code>false</code> ergeben.",hint:"<pre><code>function gleich(a, b) {\n  return ...\n}</code></pre>",solution:"<pre><code>function gleich(a, b) {\n  return a === b;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("gleich")},function(){return jshero.testutil.assert_functionHasNumOfParameter("gleich",2)},function(){return jshero.testutil.assert_functionReturns("gleich(1, 1)",true)},function(){return jshero.testutil.assert_functionReturns("gleich(1, '1')",false)},function(){return jshero.testutil.assert_functionReturns("gleich(1, 2)",false)},function(){return jshero.testutil.assert_functionReturns("gleich('klein', 'klein')",true)},function(){return jshero.testutil.assert_functionReturns("gleich('Links', 'Rechts')",false)}]});
jshero.koans.add({id:"equals2",title:"Drei gleiche Werte",lesson:"Die folgende Aufgabe soll das Zusammenspiel von strikter Gleichheit und booleschen Operatoren vertiefen.",task:"Schreibe eine Funktion <code>equals</code>, die 3 Werte auf strikte Gleichheit \xFCberpr\xFCft. Die Funktion soll nur\ndann <code>true</code> ergeben, wenn alle 3 Werte strikt gleich sind.<br><br>\nBeispiel: <code>equals(1, 1, 1)</code> soll <code>true</code> und <code>equals(1, 1, 2)</code> soll <code>false</code> ergeben.",hint:"<pre><code>function equals(a, b, c) {\n  // Vergleiche a und b sowie a und c.\n  // Verkn\xFCpfe das Ergebnis beider Vergleiche mit &&.\n}</code></pre>",solution:"<pre><code>function equals(a, b, c) {\n  return a === b && a === c;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("equals")},function(){return jshero.testutil.assert_functionHasNumOfParameter("equals",3)},function(){return jshero.testutil.assert_functionReturns("equals(1, 1, 1)",true)},function(){return jshero.testutil.assert_functionReturns("equals(1, 1, 2)",false)},function(){return jshero.testutil.assert_functionReturns("equals('1', 1, 1)",false)},function(){return jshero.testutil.assert_functionReturns("equals(1, '1', 1)",false)},function(){return jshero.testutil.assert_functionReturns("equals(1, 1, '1')",false)},function(){return jshero.testutil.assert_functionReturns("equals('klein', 'klein', 'klein')",true)},function(){return jshero.testutil.assert_functionReturns("equals('klein', 'klein', 'gro\xDF')",false)}]});
(function(testutil){jshero.koans.add({id:"euler1",title:"Project Euler",lesson:"Die folgende Aufgabe ist dem <a href='https://projecteuler.net'>Project Euler</a> entnommen.\nEs ist dort die erste Aufgabe. Das Project Euler ist eine Sammlung anspruchsvoller Aufgaben aus dem Bereich Mathematik\nund Informatik. Nach Anlegen eines Account kannst Du auch dort deine L\xF6sung \xFCberpr\xFCfen.",task:"Schreibe eine Funktion <code>sumMultiples</code>, die eine nat\xFCrliche Zahl n \xFCbergeben bekommt und die die Summe\naller Vielfachen von 3 und von 5, die echt kleiner als n sind, zur\xFCckgibt.<br><br>\nBeispiel: Alle Vielfachen von 3 und 5 kleiner als 20 sind 3, 5, 6, 9, 10, 12, 15 und 18. Ihre Summe ist 78.\n<code>sumMultiples(20)</code> sollte also <code>78</code> ergeben.",tests:[function(){return testutil.assert_isFunction("sumMultiples")},function(){return testutil.assert_functionHasNumOfParameter("sumMultiples",1)},function(){return testutil.assert_functionReturns("sumMultiples(1)",0)},function(){return testutil.assert_functionReturns("sumMultiples(2)",0)},function(){return testutil.assert_functionReturns("sumMultiples(3)",0)},function(){return testutil.assert_functionReturns("sumMultiples(4)",3)},function(){return testutil.assert_functionReturns("sumMultiples(5)",3)},function(){return testutil.assert_functionReturns("sumMultiples(6)",8)},function(){return testutil.assert_functionReturns("sumMultiples(7)",14)},function(){return testutil.assert_functionReturns("sumMultiples(8)",14)},function(){return testutil.assert_functionReturns("sumMultiples(9)",14)},function(){return testutil.assert_functionReturns("sumMultiples(10)",23)},function(){return testutil.assert_functionReturns("sumMultiples(11)",33)},function(){return testutil.assert_functionReturns("sumMultiples(16)",60)},function(){return testutil.assert_functionReturns("sumMultiples(20)",78)},function(){return testutil.assert_functionReturns("sumMultiples(100)",2318)},function(){return testutil.assert_functionReturns("sumMultiples(500)",57918)},function(){return testutil.assert_functionReturns("sumMultiples(1000)",233168)}]})})(jshero.testutil);
jshero.koans.add({id:"even",title:"Gerade Zahlen",task:"Schreibe eine Funktion <code>isEven</code>, die pr\xFCft, ob eine Zahl gerade oder ungerade ist.\nIst die Zahl gerade, so soll die Funktion <code>true</code> zur\xFCckgeben, andernfalls <code>false</code>.<br><br>\nBeispiel: <code>isEven(6)</code> soll <code>true</code> und <code>isEven(7)</code> soll\n<code>false</code> zur\xFCckgeben.",hint:"Verwende den Modulo-Operator zusammen mit strikter Gleichheit, um zu bestimmen, ob eine Zahl gerade ist.",solution:"<pre><code>function isEven(n) {\n  return n % 2 === 0;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("isEven")},function(){return jshero.testutil.assert_functionHasNumOfParameter("isEven",1)},function(){return jshero.testutil.assert_functionReturns("isEven(0)",true)},function(){return jshero.testutil.assert_functionReturns("isEven(1)",false)},function(){return jshero.testutil.assert_functionReturns("isEven(2)",true)},function(){return jshero.testutil.assert_functionReturns("isEven(37)",false)},function(){return jshero.testutil.assert_functionReturns("isEven(208)",true)}]});
jshero.koans.add({id:"fahrenheit",title:"Fahrenheit",lesson:"Die folgende Aufgabe ist dem <a href=\"https://www.freecodecamp.org\">freeCodeCamp</a> entnommen.",task:"Schreibe eine Funktion <code>toFahrenheit</code>, die eine Temperaturangabe von\n<a href=\"https://de.wikipedia.org/wiki/Grad_Celsius\">Grad Celsius</a> in\n<a href=\"https://de.wikipedia.org/wiki/Grad_Fahrenheit\">Grad Fahrenheit</a> umrechnet.\n<br><br>Beispiel: <code>toFahrenheit(0)</code> sollte <code>32</code> ergeben.",hint:"Ist C die Temperatur in Grad Celsius und F die Temperatur in Grad Fahrenheit, so gilt: F = 1.8 * C + 32.",solution:"<pre><code>function toFahrenheit(celsius) {\n  return 1.8 * celsius + 32;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("toFahrenheit")},function(){return jshero.testutil.assert_functionHasNumOfParameter("toFahrenheit",1)},function(){return jshero.testutil.assert_functionReturns("toFahrenheit(0)",32)},function(){return jshero.testutil.assert_functionReturns("toFahrenheit(10)",50)},function(){return jshero.testutil.assert_functionReturns("toFahrenheit(40)",104)},function(){return jshero.testutil.assert_functionReturns("toFahrenheit(100)",212)}]});
(function(testutil){jshero.koans.add({id:"fakultaet",title:"Fakult\xE4t",lesson:"Die <code>for</code>-Schleife soll nochmal anhand der in der Mathematik verwendeten Funktion\n<a href='https://de.wikipedia.org/wiki/Fakult%C3%A4t_(Mathematik)'>Fakult\xE4t</a> ge\xFCbt werden.\nDie Fakult\xE4t einer nat\xFCrlichen Zahl n ist das Produkt aller nat\xFCrlichen Zahlen (ohne Null) kleiner oder gleich n.\nSie wird durch ein nachgestelltes Ausrufezeichen abgek\xFCrzt: 3! = 1*2*3 = 6. Per Definition gilt 0! = 1.",task:"Schreibe eine Funktion <code>fakultaet</code>, die die Fakult\xE4t einer nat\xFCrlichen Zahl berechnet.<br><br>\nBeispiel: <code>fakultaet(3)</code> sollte <code>1*2*3</code> = <code>6</code> ergeben.",hint:"<pre><code>function fakultaet(n) {\n      let result = 1;\n      for (...) {\n        ...\n      }\n      return result;\n    }</pre></code>",solution:"<pre><code>function fakultaet(n) {\n  let result = 1;\n  for (let i = 1; i <= n; i++) {\n    result = result * i;\n  }\n  return result;\n}</pre></code>",tests:[function(){return testutil.assert_isFunction("fakultaet")},function(){return testutil.assert_functionHasNumOfParameter("fakultaet",1)},function(){return testutil.assert_functionReturns("fakultaet(0)",1)},function(){return testutil.assert_functionReturns("fakultaet(1)",1)},function(){return testutil.assert_functionReturns("fakultaet(2)",2)},function(){return testutil.assert_functionReturns("fakultaet(3)",6)},function(){return testutil.assert_functionReturns("fakultaet(4)",24)},function(){return testutil.assert_functionReturns("fakultaet(9)",362880)}]})})(jshero.testutil);
jshero.koans.add({id:"filter",title:"Array: filter()",lesson:"Eine weitere wichtige Array-Methode mit Funktionsparamter ist <code>filter()</code>. Sie filtert aus einem Array alle\nElemente heraus, die einen durch die Callback-Funktion implementierten Test bestehen, und gibt diese als neues Array zur\xFCck.\nDie Callback-Funktion muss dabei bei Aufruf mit einem Array-Element entweder <code>true</code> oder <code>false</code>\nergeben. Array-Elemente, die <code>true</code> ergeben, landen im gefilterten Array. Das urspr\xFCngliche Array wird wie bei <code>map()</code>\nnicht ver\xE4ndert.\n  \n<pre><code>let numbers = [7, -6, 120, -21, 2];\n\n// [7, 120, 2]\nlet positiveNumbers = numbers.filter(x => x > 0);\n\n// [-6, -21]\nlet negativeNumbers = numbers.filter(x => x < 0);\n\n// [-6, 120, 2]\nlet evenNumbers = numbers.filter(x => x % 2 === 0);</code></pre>\n\nL\xE4\xDFt sich die Filterbedingung wie hier in einem kurzen Ausdruck darstellen, so kann man die Callback-Funktion elegant\nals Pfeilfunktion \xFCbergeben. In komplexeren F\xE4llen ist eine eigenst\xE4ndige Funktion sinnvoll:\n\n<pre><code>const numbers = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];\n\nfunction isPrime(num) {\n   \n  if (num < 2) {\n    // nicht prim, weil zu klein\n    return false;\n  }\n\n  for (let i = 2; i < num; i++) {\n    if (num % i === 0) {\n      // nicht prim, weil teilbar\n      return false;\n    }\n  }\n  // prim\n  return true;\n}\n\n// [2, 3, 5, 7]\nconst primes = numbers.filter(isPrime);</code></pre>",hint:"Schreibe zun\xE4chst eine Funktion <code>containsBlau()</code>, die einen String entgegennimmt und <code>true</code> zur\xFCckgibt,\nwenn der String <code>'blau'</code> enh\xE4lt. Enth\xE4lt er nicht <code>'blau'</code>, soll <code>false</code> zur\xFCckgegeben werden. Gro\xDF- und Kleinschreibung\nsoll keine Rolle spielen. Verwende dann die Array-Funktion <code>filter()</code> zusammen mit <code>containsBlau()</code>, um die geforderte Funktion\n<code>filterBlau()</code> zu schreiben.",solution:"<pre><code>function containsBlau(word) {\n  return word.toLowerCase().indexOf('blau') >= 0;\n}\n\nfunction filterBlau(words) {\n  return words.filter(containsBlau);\n}</pre></code>",task:"Schreibe eine Funktion <code>filterBlau</code>, die ein Array mit Strings entgegennimmt\nund alle Array-Elemente, die den String <code>'blau'</code> enthalten, als Array zur\xFCckgibt. Gro\xDF- und Kleinschreibung\nsoll keine Rolle spielen.<br><br>\nBeispiel: <code>filterBlau(['Korngelb', 'Tannenblau', 'Rosenrot'])</code> sollte\n<code>['Tannenblau']</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("filterBlau")},function(){return jshero.testutil.assert_functionHasNumOfParameter("filterBlau",1)},function(){return jshero.testutil.assert_functionReturns("filterBlau(['Himmelblau'])",["Himmelblau"])},function(){return jshero.testutil.assert_functionReturns("filterBlau(['Korngelb', 'Tannenblau', 'Rosenrot'])",["Tannenblau"])},function(){return jshero.testutil.assert_functionReturns("filterBlau(['Blau', 'Gelb'])",["Blau"])},function(){return jshero.testutil.assert_functionReturns("filterBlau(['ROTKELCHEN', 'BLAUMEISE'])",["BLAUMEISE"])},function(){return jshero.testutil.assert_functionReturns("filterBlau(['gr\xFCn', 'wei\xDF'])",[])},function(){return jshero.testutil.assert_functionReturns("filterBlau([])",[])}]});
(function(testutil){jshero.koans.add({id:"for1",title:"for-Schleife",lesson:"Mit Schleifen k\xF6nnen Code-Abschnitte mehrmals durchlaufen werden. JavaScript kennt mehrere Schleifenarten.\nDie einfachste ist die <code>for</code>-Schleife.\n\n<pre><code>let summe = 0;\nfor (let i = 1; i < 3; i++) {\n  summe = summe + i;\n}</code></pre>\n\nDie <code>for</code>-Schleife besteht aus drei Steuer-Anweisungen und dem Schleifen-Code. Die drei Anweisungen folgen dem <code>for</code> in runden Klammern.\nSie werden durch Semikolons voneinander getrennt. Die erste Anweisung ist die Start-Anweisung. Sie wird einmal zu Beginn der Schleife ausgef\xFChrt.\nHier wird normalerweise eine Variable, die sogenannte Schleifenvariable, initialisiert. Die zweite Anweisung ist die Schleifen-Bedingung.\nSie wird vor jedem Schleifendurchlauf zu <code>true</code> oder <code>false</code> ausgewertet.\nIst der Ausdruck <code>true</code>, wird der Schleifen-Code ausgef\xFChrt.\nIst er <code>false</code>, wird die Schleife beendet und die Programmausf\xFChrung wird nach der Schleife fortgesetzt.\nNach jedem Schleifen-Durchlauf wird die dritte Anweisung, die sogenannten End-Anweisung, ausgef\xFChrt.\nHier wird normalerweise die Schleifenvariable erh\xF6ht.\nAnschlie\xDFend beginnt ein neuer Schleifendurchlauf mit erneuter Auswertung der Schleifen-Bedingung.\nDer Schleifen-Code folgt in Mengenklammern den drei Steueranweisungen.\nIn unserem Beispiel hat <code>summe</code> zun\xE4chst den Wert <code>0</code>. In der Start-Anweisung wird <code>i</code> mit <code>1</code> initialisiert.\nDie Schleifenbedingung <code>1 < 3</code> ist erf\xFCllt, also wird der Schleifen-Code ausgef\xFChrt.\n<code>summe</code> erh\xE4lt den Wert <code>0 + 1</code>, also <code>1</code>.\nNun wird in der End-Anweisung <code>i</code> um <code>1</code> erh\xF6ht (<code>i++</code> ist identisch mit <code>i = i + 1</code>).\nEs erh\xE4lt also den Wert <code>2</code>. Der zweite Schleifendurchlauf startet mit Auswertung der Schleifenbedingung.\nDiese Bedingung (<code>2 < 3</code>) ist immer noch erf\xFCllt.\nDer Schleifen-Code wird erneut ausgef\xFChrt und <code>summe</code> erh\xE4lt jetzt den Wert <code>1 + 2</code>, also <code>3</code>.\n<code>i</code> wird abermals erh\xF6ht und hat nun den Wert <code>3</code>.\nDie Schleifenbedingung <code>3 < 3</code> ist jetzt nicht mehr erf\xFCllt. Die Schleife wird beendet und die Programmausf\xFChrung wird nach der Schleife fortgesetzt.\nUnser Codebeispiel hat also alle nat\xFCrlichen Zahlen echt kleiner 3 addiert.",task:"Schreibe eine Funktion <code>addiereBis</code>, die eine Zahl als Parameter entgegennimmt und die\nalle nat\xFCrlichen Zahlen kleiner gleich dem Paramter aufaddiert. Das Ergebnis der Addition soll zur\xFCckgegeben werden.<br><br>\nBeispiel: <code>addiereBis(3)</code> sollte <code>1+2+3</code> = <code>6</code> ergeben.",hint:"<pre><code>function addiereBis(n) {\n  let summe = 0;\n  for (let i = 0; i <= n; i++) {\n    ...\n  }\n  return summe;\n}</pre></code>",solution:"<pre><code>function addiereBis(n) {\n  let summe = 0;\n  for (let i = 0; i <= n; i++) {\n    summe = summe + i;\n  }\n  return summe;\n}</pre></code>",tests:[function(){return testutil.assert_isFunction("addiereBis")},function(){return testutil.assert_functionHasNumOfParameter("addiereBis",1)},function(){return testutil.assert_functionReturns("addiereBis(0)",0)},function(){return testutil.assert_functionReturns("addiereBis(1)",1)},function(){return testutil.assert_functionReturns("addiereBis(2)",3)},function(){return testutil.assert_functionReturns("addiereBis(3)",6)},function(){return testutil.assert_functionReturns("addiereBis(9)",45)}]})})(jshero.testutil);
jshero.koans.add({id:"for2",title:"Schleifen und Arrays",lesson:"<code>for</code>-Schleifen eignen sich besonders gut zum Durchlaufen von Arrays.\nIm folgenden Beispiel werden die Elemente eines Arrays aufaddiert:\n\n<pre><code>let sum = 0;\nfor (let i = 0; i < myArray.length; i++) {\n  sum = sum + myArray[i];\n}</code></pre>",task:"Schreibe eine Funktion <code>mean</code>, die ein Array gef\xFCllt mit Zahlen entgegennimmt und den\nDurchschnitt dieser Zahlen zur\xFCckgibt.<br><br>\nBeispiel: <code>mean([1, 2, 3])</code> sollte <code>(1+2+3)/3</code> = <code>2</code> ergeben.",hint:"Um den Durchschnitt von n Zahlen zu berechnen, mu\xDFt du die Zahlen aufaddieren und die erhaltene Summe durch n teilen.",solution:"<pre><code>function mean(data) {\n\n  let sum = 0;\n\n  for (let i = 0; i < data.length; i ++) {\n    sum = sum + data[i];\n  }\n\n  return sum / data.length;\n};</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("mean")},function(){return jshero.testutil.assert_functionHasNumOfParameter("mean",1)},function(){return jshero.testutil.assert_functionReturns("mean([0])",0)},function(){return jshero.testutil.assert_functionReturns("mean([1, 2])",1.5)},function(){return jshero.testutil.assert_functionReturns("mean([1, 2, 3])",2)},function(){return jshero.testutil.assert_functionReturns("mean([-2, -4, 17, 34])",11.25)}]});
(function(testutil){jshero.koans.add({id:"function",title:"Funktionen",lesson:"Eine Funktion ist ein Block von Anweisungen, der beliebig oft ausgef\xFChrt werden kann. Eine Funktion kann\nParameter entgegennehmen und eine Funktion kann einen Wert zur\xFCckgeben. Funktionen kann man in JavaScript auf verschiedene\nWeisen definieren. Die vielleicht gebr\xE4uchlichste ist die sogenannte Funktionsdeklaration. Sie wird mit dem Schl\xFCsselwort\n<code>function</code> eingeleitet. Es folgen:\n<ul><li>der Name der Funktion,</li>\n<li>die Parameter eingeschlossen in runden Klammern,</li>\n<li>die Anweisungen eingeschlossen in geschweiften Klammern.</li></ul>\nMit dem Schl\xFCsselwort <code>return</code> kann ein Wert zur\xFCckgegeben werden. Gleichzeitig beendet <code>return</code>\ndie Funktion. Anweisungen nach einem <code>return</code> werden nicht mehr ausgef\xFChrt. Mit\n\n<pre><code>function farbe() {\n  return 'gr\xFCn';\n}</code></pre>\n\ndefinieren wir eine Funktion mit Namen <code>farbe</code>, die <code>'gr\xFCn'</code> zur\xFCckgibt.\nDie Funktion nimmt keine Paramter entgegen (die runde Klammer ist leer) und sie enth\xE4lt genau eine Anweisung, die R\xFCckgabe.\nDie Funktion wird nicht mit einem Semikolon abgeschlossen.<br><br>\n\xDCber ihren Namen wird die Funktion aufgerufen:\n\n<pre><code>let ergebnis = farbe();</code></pre>\n\nJetzt wird die Funktion ausgef\xFChrt. Ihre R\xFCckgabe wird der Variablen <code>ergebnis</code> zugewiesen.\n<code>ergebnis</code> hat dann den Wert <code>'gr\xFCn'</code>.",task:"Definiere eine Funktion <code>hallo</code>, die <code>'Hallo Welt!'</code> zur\xFCckgibt.",hint:"<pre><code>function hallo() {\n  ...\n}</code></pre>",solution:"<pre><code>function hallo() {\n  return 'Hallo Welt!';\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("hallo")},function(){return testutil.assert_functionReturns("hallo()","Hallo Welt!")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"function2",title:"Mehrere Funktionen",lesson:"Wir definieren nun mehr als eine Funktion.\n  Zur Erinnerung: So wird eine Funktion mit Namen <code>farbe</code> definiert, die den Wert <code>'rot'</code>\n  zur\xFCckgibt:\n\n<pre><code>function farbe() {\n  return 'rot';\n}</code></pre>",task:"Definiere zwei Funktionen. Die erste Funktion <code>a</code> soll <code>'Hallo a!'</code>\nzur\xFCckgeben. Die zweite Funktion <code>b</code> soll <code>'Hallo b!'</code> zur\xFCckgeben.",tests:[function(){return testutil.assert_isFunction("a")},function(){return testutil.assert_isFunction("b")},function(){return testutil.assert_functionReturns("a()","Hallo a!")},function(){return testutil.assert_functionReturns("b()","Hallo b!")}]})})(jshero.testutil);
jshero.koans.add({id:"functional",title:"Funktionale Programmierung",lesson:"Bei der <a href=\"https://de.wikipedia.org/wiki/Funktionale_Programmierung\">funktionalen Programmierung</a>\nwerden Funktionen nicht nur wie bisher deklariert und aufgerufen, sondern Funktionen werden auch als Parameter\nan andere Funktionen \xFCbergeben oder Funktionen werden von Funktionen zur\xFCckgegeben. Eine St\xE4rke von JavaScript ist es, dass es\nebenso wie objektorientierte auch funktionale Programmierung unterst\xFCtzt.<br><br>\nIn JavaScript sind Funktionen Objekte, die wie alle anderen Objekte Variablen zugeordnet werden\nk\xF6nnen. Deklariert man eine Funktion mit dem Schl\xFCsselwort <code>function</code> und anschlie\xDFendem Funktionsnamen,\nso wird automatisch eine Variable mit dem Namen der Funktion erzeugt. Diese Variable enth\xE4lt als Wert die Funktion.<br><br>\nSchauen wir uns das Ganze nun am Beispiel der Array-Methode <code>map()</code> (engl.: abbilden) an:\n\n<pre><code>function addOne(x) {\n  return x + 1;\n}\n\nlet startNumbers = [1, 2, 3];\nlet newNumbers = startNumbers.map(addOne);\n\nconsole.log(startNumbers); // [1, 2, 3]\nconsole.log(newNumbers); // [2, 3, 4]</code></pre>\n\nDie Methode <code>map()</code> verlangt als Parameter eine Funktion. In den ersten drei Zeilen haben wir eine Funktion\nmit dem Namen <code>addOne</code> deklariert. Mit dieser Deklaration wurde gleichzeitig eine Variable mit dem Namen\n<code>addOne</code> erzeugt. Die Variable <code>addOne</code> enth\xE4lt die Funktion <code>addOne()</code>. Diese Funktion\nwird nun der Methode <code>map()</code> \xFCbergeben. Intern ruft jetzt <code>map()</code> die Funktion <code>addOne()</code>\nf\xFCr jedes Array-Element auf. Dabei werden die Array-Elemente <code>addOne()</code> nacheinander als Parameter \xFCbergeben.\n<code>addOne()</code> wird also sukzessive mit den Werten <code>1</code>, <code>2</code> und <code>3</code> aufgerufen.\nAls Ergbnis erh\xE4lt man die Werte <code>2</code>, <code>3</code> und <code>4</code>.\nDiese Werte werden von <code>map()</code> als neues Array zur\xFCckgegeben. Das urspr\xFCngliche Array bleibt dabei unver\xE4ndert.\nDie Methode <code>map()</code> hat also zusammen mit\nder Funktion <code>addOne()</code> das Array <code>[1, 2, 3]</code> auf das Array <code>[2, 3, 4]</code> abgebildet.<br><br>\nEine Funktion, die einer anderen Funktion als Parameter \xFCbergeben wird und von dieser dann aufgerufen wird, bezeichnet man in der\nInformatik als <a href=\"https://de.wikipedia.org/wiki/R%C3%BCckruffunktion\">Callback</a>.",task:"Schreibe eine Funktion <code>double</code>, die ein Array mit Zahlen entgegennimmt und die diese Zahlen\nverdoppelt als Array zur\xFCckgibt.<br><br>\nBeispiel: <code>double([1, 2, 3])</code> sollte <code>[2, 4, 6]</code> ergeben.",hint:"Versuche eine L\xF6sung mit Schleife und eine L\xF6sung mit der Array-Methode <code>map()</code> zu finden.",solution:"<pre><code>// mit Schleife\nfunction double(myNumbers) {\n  let result = [];\n  for (let i = 0; i < myNumbers.length; i++) {\n    result.push(myNumbers[i] * 2);\n  }\n  return result;\n}\n\n// mit map()\nfunction timesTwo(x) {\n  return 2 * x;\n}\n\nfunction double(myNumbers) {\n  return myNumbers.map(timesTwo);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("double")},function(){return jshero.testutil.assert_functionHasNumOfParameter("double",1)},function(){return jshero.testutil.assert_functionReturns("double([1])",[2])},function(){return jshero.testutil.assert_functionReturns("double([10, 15])",[20,30])},function(){return jshero.testutil.assert_functionReturns("double([1, 2, 3])",[2,4,6])}]});
jshero.koans.add({id:"functional2",title:"Funktionale Programmierung 2",lesson:"<a href=\"functionexpression.html\">Funktionsausdr\xFCcke</a> hatten wir schon kennengelernt. Dort wurde einer\nVariablen eine anonyme Funktion zugeordnet. Anonyme Funktionen kann man aber auch direkt, ohne vorherige Variablenzuodnung,\nan Funktionen \xFCbergeben, die Funktionen als Argument verlangen. Das <code>map()</code>-Beispiel aus der vorherigen Lektion sieht dann so aus:\n  \n<pre><code>let startNumbers = [1, 2, 3];\n\nlet newNumbers = startNumbers.map(function(x) {\n  return x + 1;\n});\n  \nconsole.log(newNumbers); // [2, 3, 4]</code></pre>\n\nVerwendet man jetzt auch noch <a href=\"arrow.html\">Pfeilfunktionen</a>, so sieht man direkt\nmit welcher Operation das Array gemappt wird:\n\n<pre><code>let startNumbers = [1, 2, 3];\nlet newNumbers = startNumbers.map(x => x + 1);\nconsole.log(newNumbers); // [2, 3, 4]</code></pre>",task:"Schreibe eine Funktion <code>toX</code>, die ein Array mit Punkten wie <code>{x: 1, y: 2}</code> entgegennimmt\nund die die x-Werte dieser Punkte als Array zur\xFCckgibt.<br><br>\nBeispiel: <code>toX([{x: -1, y: -5}, {x: 2, y: 7}])</code> sollte <code>[-1, 2]</code> zur\xFCckgeben.",hint:"Versuche eine L\xF6sung mit Schleife und eine L\xF6sung mit der Array-Methode <code>map()</code> und einer Pfeilfunktion zu finden.",solution:"<pre><code>// mit Schleife\nfunction toX(points) {\n  let result = [];\n  for (let i = 0; i < points.length; i++) {\n    result.push(points[i].x);\n  }\n  return result;\n}\n\n// mit map() und Pfeilfunktion\nfunction toX(points) {\n  return points.map(p => p.x);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("toX")},function(){return jshero.testutil.assert_functionHasNumOfParameter("toX",1)},function(){return jshero.testutil.assert_functionReturns("toX([{x: -1, y: 2}])",[-1])},function(){return jshero.testutil.assert_functionReturns("toX([{x: 2, y: 3}, {x: 4, y: 5}])",[2,4])},function(){return jshero.testutil.assert_functionReturns("toX([{x: 9, y: 1}, {x: 8, y: 2}, {x: 7, y: 3}])",[9,8,7])}]});
(function(testutil){jshero.koans.add({id:"functioncall",title:"Funktionsaufruf",lesson:"Wichtig ist der Unterschied zwischen der Definition und dem Aufruf einer Funktion.\nMit der Definition, z. B.\n\n<pre><code>function f() {\n  return 'hallo';\n}</code></pre>\n\nwird festgelegt, was die Funktion machen soll. Sie wird dabei nicht ausgef\xFChrt.\nSie wird lediglich zur Ausf\xFChrung bereitgestellt.\nErst mit ihrem Aufruf\n\n<pre><code>let x = f();</code></pre>\n\nwird die Funktion ausgef\xFChrt. Dann werden die Anweisungen im Funktionsblock der Reihe nach abgearbeitet.\nDie R\xFCckgabe der Funktion wird in diesem Beispiel der Variablen <code>x</code> zugewiesen. <code>x</code> erh\xE4lt den\nWert <code>'hallo'</code>. Definiert wurde die Funktion mit dem Schl\xFCsselwort <code>function</code>.\nAufgerufen wurde die Funktion \xFCber ihren Namen.",task:"1. Definiere eine Funktion <code>begruesse</code>, die den Wert <code>'Moin!'</code> zur\xFCckgibt.\n<br/>\n2. Deklariere eine Variable <code>begruessung</code>. Rufe die Funktion <code>begruesse</code> auf und weise der Variablen\n<code>begruessung</code> die R\xFCckgabe dieses Aufrufs zu.",hint:"<pre><code>function begruesse() {\n  ...\n}\n\nlet begruessung = ...</code></pre>",solution:"<pre><code>function begruesse() {\n  return 'Moin!';\n}\n\nlet begruessung = begruesse();</code></pre>",tests:[function(){return testutil.assert_isFunction("begruesse")},function(){return testutil.assert_functionReturns("begruesse()","Moin!")},function(){return testutil.assert_variableDefined("begruessung")},function(){return testutil.assert_variableHasValue("begruessung","Moin!")}]})})(jshero.testutil);
jshero.koans.add({id:"functionexpression",title:"Funktionsausdr\xFCcke",lesson:"Wir haben bisher Funktionsdeklarationen kennen gelernt. Sie beginnen mit dem Schl\xFCsselwort <code>function</code>\ngefolgt von dem Funktionsnamen, den Parametern und dem Funktionsk\xF6rper:\n\n<pre><code>// Funktionsdeklaration\nfunction plusOne(x) {\n  return x + 1;\n}</code></pre>\n  \nMan kann Funktionen aber auch direkt im laufenden Code definieren. Eine solche Funktionsdefinition im laufende Code nennt man Funktionsausdruck.\nSo kann man zum Beispiel einer Variablen oder Konstanten direkt eine Funktion zuordnen.\n\n<pre><code>// Funktionsausdruck\nconst plusOne = function(x) {\n  return x + 1;\n};</code></pre>\n\nHier wurde keine Funktion deklariert, sondern wir haben einen Funktionsausdruck direkt einer Konstanten zugeordnet.\nDa es sich hier um eine Variablen-Zuordnung handelt, sollte das Statement mit einem Semikolon abgeschlossen werden.\nIm Gegensatz zu einer Funktionsdeklaration kann man bei einem Funktionsausdruck den Namen der Funktion weglassen.\nMan spricht in diesem Fall von einer anonymen Funktion. Die Funktion wird \xFCber den zugeordneten Variablennamen\naufgerufen:\n\n<pre><code>let foo = 1;\nfoo = plusOne(foo);\n</code></pre>\n\nEine Funktionsdeklaration und ein Funktionsausdruck mit Variablendeklaration sind praktisch gleichwertig.\nWelche Schreibweise man bevorzugt, ist Geschmackssache.\nWie wir noch sehen werden, spielen Funktionsausdr\xFCcke, insbesondere anonyme Funktionen, in der funktionalen Programmierung eine wichtige Rolle.\n<br></br>\nDa man die Verwendung von Funktionsausdr\xFCcken schwer testen kann, hier eine Aufgabe, die das Zusammenspiel von Strings\nund Schleifen \xFCbt.",task:"Schreibe eine Funktion <code>sperren</code>, die ein Wort entgegennimmt und dieses Wort gesperrt\nzur\xFCckgibt. Das Sperren soll dabei durch Einf\xFCgen von Leerzeichen realisiert werden.<br><br>\nBeispiel: <code>sperren(\"Juni\")</code> sollte <code>\"J u n i\"</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("sperren")},function(){return jshero.testutil.assert_functionHasNumOfParameter("sperren",1)},function(){return jshero.testutil.assert_functionReturns("sperren(\"Ei\")","E i")},function(){return jshero.testutil.assert_functionReturns("sperren(\"Juni\")","J u n i")},function(){return jshero.testutil.assert_functionReturns("sperren(\"Traum\")","T r a u m")},function(){return jshero.testutil.assert_functionReturns("sperren(\"Blaumeise\")","B l a u m e i s e")}]});
jshero.koans.add({id:"further",title:"Quersumme",lesson:"Mit dieser Lektion endet die Einf\xFChrung in den Sprachkern von JavaScript.\n Die folgenden Lektionen bieten einen kleinen Einstieg in das sogenannte clientseitige JavaScript.\n Zum Abschluss der Einf\xFChrung in den Sprachkern noch eine Aufgabe aus dem Gebiet der Mathematik:",task:"Schreibe eine Funktion <code>quersumme</code>, die die Quersumme einer nat\xFCrlichen Zahl berechnet.\nDie Quersumme einer Zahl ist dabei die Summe ihrer Ziffern.<br><br>Beispiel:\n<code>quersumme(198)</code> sollte <code>18</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("quersumme")},function(){return jshero.testutil.assert_functionHasNumOfParameter("quersumme",1)},function(){return jshero.testutil.assert_functionReturns("quersumme(1)",1)},function(){return jshero.testutil.assert_functionReturns("quersumme(198)",18)},function(){return jshero.testutil.assert_functionReturns("quersumme(123456789)",45)}],hint:"<pre><code>function quersumme(zahl) {\n// Extrahiere in einer Schleife\n// mit Modulo jeweils die\n// Einer-Stelle und addiere\n// sie auf.\n}</code></pre>",solution:"<pre><code>function quersumme(zahl) {\n  let sum = 0;\n  let rest = zahl;\n  while (rest > 0) {\n    let einer = rest % 10;\n    sum = sum + einer;\n    rest = (rest - einer)/10;\n  }\n  return sum;\n}</code></pre>"});
(function(testutil){jshero.koans.add({id:"gettime",title:"Date: getTime()",lesson:"Die Date-Methode <code>getTime</code> liefert die Millisekunden, die zwischen dem 1.1.1970, 0:00 UTC\nund dem Zeitpunkt des Datumsobjekts liegen.\n\n<pre><code>let date = new Date(Date.UTC(1970, 0, 1, 0, 0, 1));\nlet time = date.getTime();</code></pre>\n\nZwischen dem 1.1.1970, 0:00:00 UTC und dem 1.1.1970, 0:00:01 UTC liegen 1000 Millisekunden.\n<code>time</code> erh\xE4lt den Wert <code>1000</code>.",task:"Schreibe eine Funktion <code>days</code>, die die Differenz in Tagen zwischen zwei Date-Objekten berechnet.\nEs sollen nur volle Tage gez\xE4hlt werden.<br><br>Beispiel:\n<code>days(new Date(2018, 0, 1), new Date(2018, 0, 2))</code> und\n<code>days(new Date(2018, 0, 1), new Date(2018, 0, 2, 12))</code> sollten <code>1</code> zur\xFCckgeben.",tests:[function(){return testutil.assert_isFunction("days")},function(){return testutil.assert_functionHasNumOfParameter("days",2)},function(){return testutil.assert_functionReturns("days(new Date(2018, 0, 1), new Date(2018, 0, 1))",0)},function(){return testutil.assert_functionReturns("days(new Date(2018, 0, 1), new Date(2018, 0, 2))",1)},function(){return testutil.assert_functionReturns("days(new Date(2018, 0, 1), new Date(2018, 0, 3))",2)},function(){return testutil.assert_functionReturns("days(new Date(2018, 0, 1), new Date(2018, 0, 4))",3)},function(){return testutil.assert_functionReturns("days(new Date(2018, 0, 1), new Date(2018, 0, 4, 23, 59))",3)},function(){return testutil.assert_functionReturns("days(new Date(2018, 0, 1), new Date(2019, 0, 1))",365)}]})})(jshero.testutil);
jshero.koans.add({id:"ggt",title:"ggT",lesson:"Das Gegenst\xFCck zum kleinsten gemeinsamen Vielfachen (kgV) ist der\n<a href='https://de.wikipedia.org/wiki/Gr%C3%B6%C3%9Fter_gemeinsamer_Teiler'>gr\xF6\xDFte gemeinsamer Teiler (ggT)</a>.\nDer gr\xF6\xDFte gemeinsame Teiler zweier Zahlen a und b ist die gr\xF6\xDFte Zahl, durch die sich sowohl a als auch b teilen l\xE4\xDFt.",task:"Schreibe eine Funktion <code>ggT</code>, die zwei nat\xFCrliche Zahlen als Parameter entgegennimmt und deren ggT berechnet.\n<br><br>Beispiel: <code>ggT(6, 15)</code> sollte <code>3</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("ggT")},function(){return jshero.testutil.assert_functionHasNumOfParameter("ggT",2)},function(){return jshero.testutil.assert_functionReturns("ggT(1, 1)",1)},function(){return jshero.testutil.assert_functionReturns("ggT(1, 2)",1)},function(){return jshero.testutil.assert_functionReturns("ggT(2, 3)",1)},function(){return jshero.testutil.assert_functionReturns("ggT(2, 4)",2)},function(){return jshero.testutil.assert_functionReturns("ggT(6, 15)",3)},function(){return jshero.testutil.assert_functionReturns("ggT(12, 18)",6)},function(){return jshero.testutil.assert_functionReturns("ggT(18, 12)",6)},function(){return jshero.testutil.assert_functionReturns("ggT(15, 45)",15)},function(){return jshero.testutil.assert_functionReturns("ggT(45, 15)",15)}]});
jshero.koans.add({id:"greaterthan",title:"Zahlen vergleichen",lesson:"Zahlen kann man mit den aus der Mathematik bekannten Zeichen\n<code>&gt;</code>, <code>&gt;=</code>, <code>&lt;</code> und <code>&lt;=</code>\nauf gr\xF6\xDFer, gr\xF6\xDFer gleich, kleiner und kleiner gleich vergleichen.\nIm folgenden Beispiel liefern alle Ausdr\xFCcke den Wert <code>true</code>:\n<pre><code>let v1 = 5 > 4;\nlet v2 = 5 >= 5;\nlet v3 = 5 < 6;\nlet v4 = 5 <= 5;</code></pre>",task:"Schreibe eine Funktion <code>istDreistellig</code>, die pr\xFCft, ob eine Zahl gr\xF6\xDFer gleich 100 und kleiner 1000\nist.<br><br>Beispiel: <code>istDreistellig(500)</code> sollte <code>true</code> zur\xFCckgeben,\n<code>istDreistellig(50)</code> sollte <code>false</code> ergeben.",hint:"<pre><code>function istDreistellig(x) {\n  return x >= 100 && ...\n}</code></pre>",solution:"<pre><code>function istDreistellig(x) {\n  return x >= 100 && x < 1000;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("istDreistellig")},function(){return jshero.testutil.assert_functionHasNumOfParameter("istDreistellig",1)},function(){return jshero.testutil.assert_functionReturns("istDreistellig(100)",true)},function(){return jshero.testutil.assert_functionReturns("istDreistellig(709)",true)},function(){return jshero.testutil.assert_functionReturns("istDreistellig(999)",true)},function(){return jshero.testutil.assert_functionReturns("istDreistellig(99)",false)},function(){return jshero.testutil.assert_functionReturns("istDreistellig(1000)",false)}]});
jshero.koans.add({id:"if",title:"if",lesson:"H\xE4ufig soll Code nur dann ausgef\xFChrt werden, wenn eine bestimmte Bedingung erf\xFCllt ist.\nDazu verwendet man die <code>if</code>-Anweisung.\n\n<pre><code>let gewinn = 0;\nif (wuerfelzahl === 6) {\n  gewinn = 100;\n}</code></pre>\n\nDiese Anweisung besteht aus dem Schl\xFCsselwort <code>if</code> (engl: wenn) gefolgt von runden Klammern. In den runden\nKlammern steht ein Ausdruck - die Bedingung -, der zu <code>true</code> oder <code>false</code> ausgewertet wird.\nErgibt die Bedingung <code>true</code>, werden alle Anweisungen in dem durch die geschweiften Klammern begrenzten Block\nausgef\xFChrt. Ergibt die Bedingung <code>false</code>, wird der durch die geschweiften Klammern begrenzte Block \xFCbersprungen.\nHat in unserem Beispiel die Variable <code>wuerfelzahl</code> den Wert <code>6</code>, so wird <code>gewinn</code> auf\n<code>100</code> gesetzt. Hat <code>wuerfelzahl</code> nicht den Wert <code>6</code>, bleibt <code>gewinn</code> bei\n<code>0</code>.",task:"Schreibe eine Funktion <code>gleich</code>, die 2 Werte auf strikte Gleichheit \xFCberpr\xFCft. Sind die beiden Werte\ngleich, so soll der String <code>'GLEICH'</code> zur\xFCckgegeben werden. Sind sie ungleich, so soll man\n<code>'UNGLEICH'</code> erhalten.",hint:"<pre><code>function gleich(a, b) {\n// Initialisiere eine Variable\n// mit 'UNGLEICH'. Verwende 'if',\n// um die Variable ggf. auf\n// 'GLEICH' zu setzen. Gebe die\n// Variable zur\xFCck.\n}</code></pre>",solution:"<pre><code>function gleich(a, b) {\n  let ergebnis = 'UNGLEICH';\n  if (a === b) {\n    ergebnis = 'GLEICH';\n  }\n  return ergebnis;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("gleich")},function(){return jshero.testutil.assert_functionHasNumOfParameter("gleich",2)},function(){return jshero.testutil.assert_functionReturns("gleich(1, 1)","GLEICH")},function(){return jshero.testutil.assert_functionReturns("gleich(1, 2)","UNGLEICH")},function(){return jshero.testutil.assert_functionReturns("gleich(1, '1')","UNGLEICH")},function(){return jshero.testutil.assert_functionReturns("gleich('klein', 'klein')","GLEICH")},function(){return jshero.testutil.assert_functionReturns("gleich('Links', 'Rechts')","UNGLEICH")}]});
jshero.koans.add({id:"if2",title:"Zwei return-Anweisungen",lesson:"Mit der <code>if</code>-Anweisung hat man die M\xF6glichkeit, Funktionen mit zwei <code>return</code>-Anweisungen\nzu schreiben:\n\n<pre><code>function gewinn(zahl) {\n  if (zahl === 6) {\n    return 100;\n  }\n  return 0;\n}</code></pre>\n\nHat <code>zahl</code> den Wert <code>6</code>, so ist die <code>if</code>-Bedingung erf\xFCllt und die erste\n<code>return</code>-Anweisung wird ausgef\xFChrt. Die Funktion wird beendet und gibt <code>100</code> zur\xFCck.\nHat <code>zahl</code> nicht den Wert <code>6</code>, so ist die <code>if</code>-Bedingung nicht erf\xFCllt.\nDie Codeausf\xFChrung wird hinter dem zur <code>if</code>-Anweisung geh\xF6rigen Block fortgesetzt. Die zweite\n<code>return</code>-Anweisung wird ausgef\xFChrt. Die Funktion gibt <code>0</code> zur\xFCck.<br><br>\nAber Achtung: Zwei oder auch mehr <code>return</code>-Anweisungen in einer Funktion sollte man sorgsam verwenden.\nAndernfalls wird der Code un\xFCbersichtlich.",task:"Schreibe eine Funktion <code>schnapszahl</code>, die feststellt, ob eine zweistellige Zahl eine Schnapszahl ist\noder nicht. Ist die Zahl eine Schnapszahl, soll <code>'Schnaps!'</code> zur\xFCckgegeben werden, andernfalls\n<code>'Kein Schnaps!'</code>. <br><br>Eine <a href='https://de.wikipedia.org/wiki/Schnapszahl'>Schnapszahl</a>\nist eine mehrstellige Zahl, die ausschlie\xDFlich durch identische Ziffern dargestellt wird.\n<br><br>Beispiel: <code>schnapszahl(22)</code> sollte <code>'Schnaps!'</code> und\n<code>schnapszahl(23)</code> sollte <code>'Kein Schnaps!'</code> zur\xFCckgeben.",hint:"<pre><code>function schnapszahl(n) {\n// Berechne die Einerstelle\n// von n mit Modulo 10.\n// Berechne die Zehnerstelle\n// von n mit Division\n// durch 10 und Abrunden.\n// Vergleiche Einer- und\n// Zehnerstelle.\n}</code></pre>",solution:"<pre><code>function schnapszahl(n) {\n  let einer = n % 10;\n  let zehner = Math.floor(n / 10);\n  if (einer === zehner) {\n    return 'Schnaps!';\n  }\n  return 'Kein Schnaps!';\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("schnapszahl")},function(){return jshero.testutil.assert_functionHasNumOfParameter("schnapszahl",1)},function(){return jshero.testutil.assert_functionReturns("schnapszahl(11)","Schnaps!")},function(){return jshero.testutil.assert_functionReturns("schnapszahl(55)","Schnaps!")},function(){return jshero.testutil.assert_functionReturns("schnapszahl(99)","Schnaps!")},function(){return jshero.testutil.assert_functionReturns("schnapszahl(10)","Kein Schnaps!")},function(){return jshero.testutil.assert_functionReturns("schnapszahl(12)","Kein Schnaps!")},function(){return jshero.testutil.assert_functionReturns("schnapszahl(98)","Kein Schnaps!")}]});
(function(testutil){jshero.koans.add({id:"increment",title:"Inkrement",lesson:"In der Programmierung m\xF6chte man h\xE4ufig einen Z\xE4hler um eins erh\xF6hen oder verringern.\nDas kann man leicht mit dem Inkrement- bzw. dem Dekrementoperator tun.\n\n<pre><code>let x = 1;\nx++;\nlet y = 10;\ny--;</code></pre>\n\n<code>x++</code> ist identisch mit <code>x = x + 1</code> und <code>y--</code> ist identisch mit <code>y = y - 1</code>.\nNach Ausf\xFChrung des Beispielcodes hat <code>x</code> den Wert <code>2</code> und <code>y</code> den Wert <code>9</code>.",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>let x = 3;\nx++;\nx = x * 2;\nx--;</code></pre>",solution:"<pre><code>7</code></pre>",tests:[function(){return testutil.assert_isValue("7")}]})})(jshero.testutil);
jshero.koans.add({id:"join",title:"Array: join()",lesson:"Mit <code>join</code> verbindet man alle Elemente eines Arrays zu einem String:\n\n<pre><code>let words = ['Sex', 'Drugs', 'Rock', 'Roll'];\nlet l1 = words.join();\nlet l2 = words.join(' & ');\nlet l3 = words.join(' and ');</code></pre>\n\nOhne Argument f\xFCgt <code>join</code> die Elemente kommasepariert zusammen.\n<code>l1</code> ergibt <code>'Sex,Drugs,Rock,Roll'</code>.\nAnsonsten gibt das \xFCbergebene Argument das Trennzeichen vor.\n<code>l2</code> ergibt <code>'Sex & Drugs & Rock & Roll'</code> und\n<code>l3</code> den String <code>'Sex and Drugs and Rock and Roll'</code>.",task:"Schreibe eine Funktion <code>list</code>, die W\xF6rter in einem Array zu einer Aufz\xE4hlung zusammenf\xFChrt.\nEin leeres Array soll den Leerstring ergeben.\n<br><br>Beispiel: <code>list(['Sonne', 'Mond', 'Sterne'])</code> soll <code>'Sonne, Mond und Sterne'</code> ergeben.",hint:"Erzeuge aus dem \xFCbergebenen Array ein neues Array ohne das letzte Element.\nVerkette die Elemente des neuen Arrays mit Komma und Leerzeichen.\nF\xFCge das letztes Element des \xFCbergebene Array mit <code>' und '</code> hinzu.\nBehandle Sonderf\xE4lle getrennt.",solution:"<pre><code>function list(words) {\n\n  if (words.length === 0) {\n    return '';\n  }\n\n  if (words.length === 1) {\n    return words[0];\n  }\n\n  let wordsExLast = words.slice(0, words.length - 1);\n  let lastWord = words[words.length - 1];\n  return wordsExLast.join(', ') + ' und ' + lastWord;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("list")},function(){return jshero.testutil.assert_functionHasNumOfParameter("list",1)},function(){return jshero.testutil.assert_functionReturns("list(['Ernie', 'Bert'])","Ernie und Bert")},function(){return jshero.testutil.assert_functionReturns("list(['Sonne', 'Mond', 'Sterne'])","Sonne, Mond und Sterne")},function(){return jshero.testutil.assert_functionReturns("list(['C', 'C++', 'Python', 'PHP'])","C, C++, Python und PHP")},function(){return jshero.testutil.assert_functionReturns("list(['Apfel'])","Apfel")},function(){return jshero.testutil.assert_functionReturns("list([])","")}]});
(function(testutil){jshero.koans.add({id:"jsx01",title:"Was ist x?",lesson:"Das eben Gelernte wollen wir nochmal \xFCben. W\xE4hrend Du bei der ersten Aufgabe Code geschrieben hast,\nsollst du hier Code lesen.",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>let x = 'Josefine';</code></pre>",solution:"<pre><code>'Josefine'</code></pre>",tests:[function(){return testutil.assert_isString("Josefine")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"jsx02",title:"Neuzuweisung",lesson:"Einer Variablen kann man jederzeit mit dem Gleichheitszeichen einen neuen Wert zuweisen.\nDas Schl\xFCsselwort <code>let</code> wird dabei nicht nochmal verwendet.\n<pre><code>let farbe = 'rot';\nfarbe = 'gr\xFCn';</code></pre>\nDie Variable <code>farbe</code> wird mit dem Wert <code>'rot'</code> initialisiert. Danach erh\xE4lt sie den Wert <code>'gr\xFCn'</code>.",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>let x = 'Georg';\nx = 'Karl';\nx = 'Gregor';</code></pre>",solution:"<pre><code>'Gregor'</code></pre>",tests:[function(){return testutil.assert_isString("Gregor")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"jsx03",title:"Variablen zuweisen",lesson:"Einer Variablen kann man auch den Wert einer anderen Variablen zuweisen:\n<pre><code>let name1 = 'Olga';\nlet name2 = name1;\nname1 = 'Clara';</code></pre>\nIn der zweiten Codezeile wird der Variablen <code>name2</code> der Wert der Variablen <code>name1</code> zugewiesen.\n<code>name2</code> erh\xE4lt den Wert <code>'Olga'</code>. Diesen Wert beh\xE4lt <code>name2</code> bei,\nauch wenn anschlie\xDFend <code>name1</code> einen neuen Wert erh\xE4lt.",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>let x = 'rot';\nlet y = 'gr\xFCn';\nlet z = y;\ny = x;\nx = z;</code></pre>",solution:"<pre><code>'gr\xFCn'</code></pre>",tests:[function(){return testutil.assert_isString("gr\xFCn")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"jsx04",title:"Was ist x?",lesson:"Das eben Gelernte wollen wir nochmal \xFCben.",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>function hello() {\n  return 'Hi!';\n}\n\nlet x = hello();</code></pre>",solution:"<pre><code>'Hi!'</code></pre>",tests:[function(){return testutil.assert_isString("Hi!")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"jsx05",title:"Was ist x?",lesson:"Auch bei Funktionen mit Parametern wollen wir den Funktionsaufruf \xFCben.",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>function reply(phrase) {\n  return phrase;\n}\n\nlet x = reply('How do you do?');</code></pre>",solution:"<pre><code>'How do you do?'</code></pre>",tests:[function(){return testutil.assert_isString("How do you do?")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"jsx06",title:"Was ist x?",lesson:"Hier soll nochmal der Unterschied zwischen einer Funktionsdefinition und einem Funktionsaufruf\nge\xFCbt werden.<br><br>M\xF6chtest du das bisher Gelernte in Aktion sehen, schaue dir im\n<a href='https://blog.jshero.net'>Code Hero Blog</a> die Posts\n<a href='https://blog.jshero.net/playground/'>Playground</a> und <a href='https://blog.jshero.net/funktionen/'>Funktionen</a> an.",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>function woIst(name) {\n  return 'Wo ist ' + name + '?';\n}\n\nlet x = woIst('Fred');</code></pre>",solution:"<pre><code>'Wo ist Fred?'</code></pre>",tests:[function(){return testutil.assert_isString("Wo ist Fred?")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"jsx06b",title:"Was ist x?",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>function hi(name) {\n  return 'Hi ' + name + '!';\n}\n\nlet h1 = hi('Selva');\nlet h2 = hi('Pola');\nlet x = h1 + ' ' + h2;</code></pre>",solution:"<pre><code>'Hi Selva! Hi Pola!'</code></pre>",tests:[function(){return testutil.assert_isString("Hi Selva! Hi Pola!")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"jsx07",title:"Silent Teacher",lesson:"Eine wunderbare, kleine Learn-to-Code App ist\n<a href=\"http://silentteacher.toxicode.fr/\">SILENT TEACHER</a>. Spielerisch lernt man einfache\nProgrammierkonzepte kennen. Da SILENT TEACHER als Programmiersprache JavaScript verwendet, eignet\nes sich hervorragend als Erg\xE4nzung zu JS Hero. Mehr zu SILENT TEACHER findest du im\n<a href=\"https://blog.jshero.net/silent-teacher/\">Code Hero Blog</a> und bei\n<a href=\"http://silentteacher.toxicode.fr/about\">Toxicode</a>.<br><br>\nHier soll nochmal die Verkettung von Strings ge\xFCbt werden.",task:"Welchen Wert hat <code>x</code> nach Ausf\xFChrung des folgenden Codes?\n<pre><code>function bleiben(name) {\n  return name + ' bleibt ' + name;\n}\n\nlet x = bleiben('Mainz');</code></pre>",solution:"<pre><code>'Mainz bleibt Mainz'</code></pre>",tests:[function(){return testutil.assert_isString("Mainz bleibt Mainz")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"log",title:"Loggen und Strings",lesson:"Jetzt wollen wir das Loggen zusammen mit dem Verketten von Strings \xFCben.",task:"Schreibe eine Funktion <code>rufe</code>, die einen String als Parameter entgegennimmt und diesen String verdoppelt zur\xFCckgibt.\n  Gleichzeitig soll die R\xFCckgabe geloggt werden.<br><br>\n  Beispiel: Der Aufruf <code>rufe('Werder')</code>\n  sollte <code>'WerderWerder'</code> zur\xFCckgeben und er sollte <code>'WerderWerder'</code> loggen.",hint:"<pre><code>function rufe(name) {\n  let ruf = name + name;\n  ...\n}</code></pre>",solution:"<pre><code>function rufe(name) {\n  let ruf = name + name;\n  console.log(ruf);\n  return ruf;\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("rufe")},function(){return testutil.assert_functionHasNumOfParameter("rufe",1)},function(){return testutil.assert_functionReturns("rufe('Werder')","WerderWerder")},function(){return testutil.assert_functionReturns("rufe('Kickers')","KickersKickers")},function(){return testutil.assert_functionLogs("rufe('Werder')","WerderWerder")},function(){return testutil.assert_functionLogs("rufe('Kickers')","KickersKickers")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"log1",title:"Logging",lesson:"Programmieren beinhaltet immer auch die Suche nach Fehlern.\nEine M\xF6glichkeit Fehler zu finden ist das <a href='https://de.wikipedia.org/wiki/Logging'>Loggen</a>.\nMan macht w\xE4hrend der Programmausf\xFChrung gezielte Ausgaben.\nIn JavaScript verwendet man daf\xFCr die Funktion <code>console.log</code>:\n\n<pre><code>console.log('Hallo Konsole!');</code></pre>\n\nHier wird der String <code>'Hallo Konsole!'</code> mit <code>console.log</code> ausgegeben.\nWo man die Ausgabe zu sehen bekommt, h\xE4ngt von der JavaScript-Umgebung ab.\nIn Browsern sieht man die Log-Ausgabe im normalen Betrieb nicht.\nDoch die meisten Desktop-Browser besitzen sogenannte <a href='https://de.wikipedia.org/wiki/Entwicklerwerkzeuge_in_Webbrowsern'> Entwicklerwerkzeuge</a>.\nDas sind m\xE4chtige Tools zur Unterst\xFCtzung von Webentwicklern. Eines dieser Tools ist die Konsole.\nDort wird das Log ausgegeben. Wie man die Entwickler-Werkzeuge \xF6ffnet h\xE4ngt vom jeweiligen Browser ab.\nBei vielen Desktop-Browsern wird sie mit der Taste F12 ge\xF6ffnet.\nDie Konsole kannst du dann als Reiter ausw\xE4hlen. Alternativ kann man die Konsole \xFCber das Browser-Men\xFC \xF6ffnen.\nAuf mobilen Ger\xE4ten stehen die Entwickler-Werkzeuge nicht zur Verf\xFCgung.\nDeshalb schreibt JS Hero das Log zus\xE4tzlich in die Testausgabe.",task:"Schreibe eine Funktion <code>logge</code>, die den String <code>'Hallo Konsole!'</code> loggt.\nArbeitest du mit einem Desktop-Browser \xF6ffne zus\xE4tzlich die Entwickler-Tools, um auch dort die Ausgabe zu sehen.",hint:"<pre><code>function logge() {\n  console.log(...);\n}</code></pre>",solution:"<pre><code>function logge() {\n  console.log('Hallo Konsole!');\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("logge")},function(){return testutil.assert_functionLogs("logge()","Hallo Konsole!")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"log2",title:"Variablen loggen",lesson:"Nun wollen wir Variablen loggen:\n\n<pre><code>let informatiker = 'Ken Thompson';\nconsole.log(informatiker);</code></pre>\n\nHier wird die Variable <code>informatiker</code> mit <code>console.log</code> geloggt.\nIn der Konsole erscheint <code>'Ken Thompson'</code>. Das ist der Wert der Variablen <code>informatiker</code>.",task:"Schreibe eine Funktion <code>logge</code>, die einen Parameter entgegennimmt und diesen Parameter loggt.<br><br>\nBeispiel: Der Aufruf <code>logge('Ken Thompson')</code> sollte <code>'Ken Thompson'</code> loggen.",hint:"<pre><code>function logge(wert) {\n  ...\n}</code></pre>",solution:"<pre><code>function logge(wert) {\n  console.log(wert);\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("logge")},function(){return testutil.assert_functionHasNumOfParameter("logge",1)},function(){return testutil.assert_functionLogs("logge('Ken Thompson')","Ken Thompson")},function(){return testutil.assert_functionLogs("logge('Dennis Ritchie')","Dennis Ritchie")}]})})(jshero.testutil);
jshero.koans.add({id:"math",title:"Math",lesson:"Viele mathematische Funktionen sind in dem Objekt <code>Math</code> zusammengefasst.\nSo gibt <code>Math.sqrt(x)</code> die Quadratwurzel (engl.: square root) zur\xFCck\nund mit <code>Math.pow(x, y)</code> berechnet man die Potenz (engl.: power) x hoch y.\n\n<pre><code>let y1 = Math.sqrt(9);\nlet y2 = Math.pow(10, 3);</code></pre>\n\n<code>y1</code> hat den Wert <code>3</code> und <code>y2</code> den Wert <code>1000</code> (10&sup3; = 10 * 10 * 10 = 1000).",task:"Schreibe eine Funktion <code>hypotenuse</code>, die die L\xE4nge der Hypotenuse eines rechtwinkligen Dreiecks berechnet.\n\xDCbergeben wird der Funktion als Parameter die L\xE4ngen der beiden Katheten.\n<br><br>Tipp: In einem rechtwinkligen Dreieck gilt der Satz des Pythagoras. Sind a, b die L\xE4ngen der beiden\nKatheten und c die L\xE4nge der Hypotenuse, so gilt: a&sup2; + b&sup2; = c&sup2;.\n<br><br>Beispiel: Da 3&sup2; + 4&sup2; = 5&sup2; gilt, sollte <code>hypotenuse(3,&nbsp;4)</code> den Wert <code>5</code> liefern.",hint:"<pre><code>function hypotenuse(a, b) {\n  let cQuadrat = Math.pow(a, 2) + Math.pow(b, 2);\n  return ...\n}</code></pre>",solution:"<pre><code>function hypotenuse(a, b) {\n  let cQuadrat = Math.pow(a, 2) + Math.pow(b, 2);\n  return Math.sqrt(cQuadrat);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("hypotenuse")},function(){return jshero.testutil.assert_functionHasNumOfParameter("hypotenuse",2)},function(){return jshero.testutil.assert_functionReturns("hypotenuse(3, 4)",5)},function(){return jshero.testutil.assert_functionReturns("hypotenuse(5, 12)",13)},function(){return jshero.testutil.assert_functionReturns("hypotenuse(1, 1)",Math.sqrt(2))}]});
jshero.koans.add({id:"mean",title:"Klammern",lesson:"Ebenso wie in der Mathematik gilt in JavaScript die Punkt-vor-Strichrechnung. Multiplikation und Division\nwerden vor Addition und Subtraktion ausgef\xFChrt. M\xF6chte man zuerst die Strichrechnung ausf\xFChren, verwendet man genauso\nwie in der Mathematik Klammern.\n\n<pre><code>let x1 = 3 + 4 * 2;\nlet x2 = (3 + 4) * 2;</code></pre>\n\n<code>x1</code> hat den Wert <code>11</code>, der Wert von <code>x2</code> ist <code>14</code>.",task:"Schreibe eine Funktion <code>mittelwert</code>, die zwei Zahlen als Parameter entgegennimmt und deren\nMittelwert zur\xFCckgibt.<br><br>Beispiel: <code>mittelwert(1, 2)</code> sollte <code>1.5</code> ergeben.",hint:"<pre><code>Der Mittelwert zweier Zahlen\nx und y ist (x + y) / 2.</code></pre>",solution:"<pre><code>function mittelwert(x, y) {\n  return (x + y) / 2;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("mittelwert")},function(){return jshero.testutil.assert_functionHasNumOfParameter("mittelwert",2)},function(){return jshero.testutil.assert_functionReturns("mittelwert(1, 2)",1.5)},function(){return jshero.testutil.assert_functionReturns("mittelwert(0, 0)",0)},function(){return jshero.testutil.assert_functionReturns("mittelwert(3, -1)",1)}]});
(function(testutil,evaluator){jshero.koans.add({id:"method1",title:"Methoden",lesson:"Bisher waren die Werte von Objekt-Eigenschaften Daten wie Strings oder Zahlen.\nObjekt-Eigenschaften k\xF6nnen aber auch Funktionen sein. Solche Objekt-Eigenschaften nennt man\nMethoden. Methoden operieren auf den Daten eines Objekts.\n\n<pre><code>let ware = {\n  name: '\xC4pfel',\n  preis: 2.15,\n  erhoehePreis: function(erhoehung) {\n    this.preis = this.preis + erhoehung;\n  }\n};\n\nlet alterPreis = ware.preis;\nware.erhoehePreis(0.05);\nlet neuerPreis = ware.preis;</code></pre>\n\nDas Objekt <code>ware</code> besitzt die Methode <code>erhoehePreis</code>. Diese Methode greift mithilfe von\n<code>this</code> auf die Objekt-Eigenschaft <code>preis</code> zu. <code>this</code> steht innerhalb eines Objekts f\xFCr\ndas Objekt selbst. Mit der bekannten Punkt-Notation kann man nun auf die Objekt-Eigenschaften zugreifen und sie\nver\xE4ndern.<br>\nVon au\xDFen wird eine Methode \xFCber die zugeordnete Variable und der Punkt-Notation aufgerufen.",task:"Definiere ein Objekt mit den beiden Eigenschaften <code>x</code> und <code>y</code> sowie einer Methode\n<code>moveX</code>. <code>x</code> und <code>y</code> sollen den Wert <code>0</code> erhalten. <code>moveX</code>\nsoll den Wert von <code>x</code> um <code>1</code> erh\xF6hen. Weise das Objekt einer Variablen <code>point</code> zu.",tests:[function(){return testutil.assert_variableDefined("point")},function(){let out=evaluator.evalTest("point");let ok,msg;if(out===null){ok=false;msg="<code>point</code> ist <code>null</code>."}else if(out.x===0){ok=true;msg="<code>point.x</code> hat den Wert <code>0</code>."}else{ok=false;msg="<code>point.x</code> hat nicht den Wert <code>0</code>, sondern <code>"+out.x+"</code>."}return{ok:ok,msg:msg}},function(){let out=evaluator.evalTest("point");let ok,msg;if(out.y===0){ok=true;msg="<code>point.y</code> hat den Wert <code>0</code>."}else{ok=false;msg="<code>point.y</code> hat nicht den Wert <code>0</code>, sondern <code>"+out.y+"</code>."}return{ok:ok,msg:msg}},function(){return testutil.assert_isFunction("point.moveX")},function(){let out=evaluator.evalTest("point");let ok,msg;out.moveX();if(out.x===1&&out.y===0){ok=true;msg="<code>moveX</code> verschiebt den Punkt von (0, 0) nach (1, 0)."}else{ok=false;msg="<code>moveX</code> verschiebt den Punkt von (0, 0) nicht nach (1, 0), sondern nach ("+out.x+", "+out.y+")."}return{ok:ok,msg:msg}}]})})(jshero.testutil,jshero.evaluator);
jshero.koans.add({id:"minmax",title:"Min und Max",lesson:"Das Minimum und Maximum einer Reihe von Zahlen bestimmt man mit\n<code>Math.min()</code> und <code>Math.max()</code>:\n\n<pre><code>let min = Math.min(5, 7);\nlet max = Math.max(3, 9, 2);</code></pre>\n\n<code>min</code> erh\xE4lt den Wert <code>5</code> und <code>max</code> den Wert <code>9</code>.\nDas Besondere: Beide Funktionen k\xF6nnen mit einer beliebigen Anzahl von Argumenten aufgerufen werden.",task:"Schreibe eine Funktion <code>bereichsmittel</code>, die das Bereichsmittel von 3 Zahlen berechnet.\n<br><br>Tipp: Das <a href='https://de.wikipedia.org/wiki/Mittelwert#Bereichsmittel'>Bereichsmittel</a>\neiner Reihe von Zahlen ist der Mittelwert der kleinsten und gr\xF6\xDFten Zahl.\n<br><br>Beispiel: <code>bereichsmittel(3, 9, 1)</code> sollte <code>(9+1)/2</code> = <code>5</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("bereichsmittel")},function(){return jshero.testutil.assert_functionHasNumOfParameter("bereichsmittel",3)},function(){return jshero.testutil.assert_functionReturns("bereichsmittel(3, 9, 1)",5)},function(){return jshero.testutil.assert_functionReturns("bereichsmittel(3, 0, 8)",4)},function(){return jshero.testutil.assert_functionReturns("bereichsmittel(7, 4, 0)",3.5)},function(){return jshero.testutil.assert_functionReturns("bereichsmittel(-6, -5, -2)",-4)},function(){return jshero.testutil.assert_functionReturns("bereichsmittel(5, -5, 2)",0)},function(){return jshero.testutil.assert_functionReturns("bereichsmittel(10, 20, 17)",15)}]});
jshero.koans.add({id:"modulo",title:"Modulo",lesson:"Ein weiterer arithmetischer Operator ist Modulo. Er berechnet den Rest einer Division und wird mit dem Prozentzeichen <code>%</code> notiert."+"<pre><code>let x = 7 % 2;<br>"+"let y = 20 % 3;</code></pre>"+"7 geteilt durch 2 ergibt 3 Rest 1. <code>x</code> ist also <code>1</code>.<br>"+"20 geteilt durch 3 ergibt 6 Rest 2. <code>y</code> ist also <code>2</code>.",task:"Schreibe eine Funktion <code>einer</code>, die eine nat\xFCrliche Zahl entgegenimmt und die Ziffer der\nEiner-Stelle zur\xFCckgibt.<br><br>Beispiel: <code>einer(2674)</code> sollte <code>4</code> zur\xFCckgeben.",hint:"<pre><code>function einer(n) {\n// Benutze Modulo 10.\n}</code></pre>",solution:"<pre><code>function einer(n) {\n  return n % 10;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("einer")},function(){return jshero.testutil.assert_functionHasNumOfParameter("einer",1)},function(){return jshero.testutil.assert_functionReturns("einer(3)",3)},function(){return jshero.testutil.assert_functionReturns("einer(17)",7)},function(){return jshero.testutil.assert_functionReturns("einer(210)",0)},function(){return jshero.testutil.assert_functionReturns("einer(2674)",4)}]});
(function(testutil){jshero.koans.add({id:"nan",title:"NaN",lesson:"<code>NaN</code> repr\xE4sentiert den Wert Not-A-Number (engl.: Keine-Zahl). Numerische Operationen oder\nFunktionen geben <code>NaN</code> zur\xFCck, wenn sie keinen Wert berechnen k\xF6nnen. Wir hatten dies bei\n<code><a href='parseint.html'>parseInt</a></code> kennengelernt. <code>parseInt</code> gibt <code>NaN</code>\nzur\xFCck, wenn es keine Zahl parsen kann. Ein weiteres Beispiel ist die Berechnung der Wurzel aus einer negativen Zahl:\n\n<pre><code>let age = parseInt('Babylon');\nlet length = Math.sqrt(-1);</code></pre>\n\nSowohl <code>age</code> als auch <code>length</code> haben den Wert <code>NaN</code>.<br><br>\nM\xF6chte man testen, ob <code>NaN</code> vorliegt, kann man leider nicht <code>===</code> verwenden.\n<code>NaN</code> ist der einzige Wert in JavaScript, der nicht mit sich selbst gleich ist.\n<code>NaN&nbsp;===&nbsp;NaN</code> ergibt <code>false</code>.\n\nUm auf <code>NaN</code> zu testen, sollte man die Funktion <code>Number.isNaN</code> verwenden:\n\n<pre><code>let input = 'Babylon';\nlet message;\nlet age = parseInt(input);\nif ( Number.isNaN(age) ) {\n  message = 'Du hast keine Zahl eingegeben.';\n}</code></pre>\n\nDie folgende Aufgabe ist anspruchsvoll.",task:"Schreibe eine Funktion <code>parseFirstInt</code>, die einen String entgegennimmt und die die erste in dem\nString vorkommende ganze Zahl zur\xFCckgibt. Enth\xE4lt der String keine ganze Zahl, soll man <code>NaN</code> erhalten.<br><br>\nBeispiel: <code>parseFirstInt('Sonnebornstr. 27')</code> sollte <code>27</code> zur\xFCckgeben.\n<code>parseFirstInt('Babylon')</code> sollte <code>NaN</code> ergeben.",hint:"Benutze eine Schleife. Verwende innerhalb der Schleife <code>parseInt()</code>.",solution:"<pre><code>function parseFirstInt(input) {\n\n  let inputToParse = input;\n\n  for (let i = 0; i < input.length; i++) {\n    let firstInt = parseInt(inputToParse);\n    if (!Number.isNaN(firstInt)) {\n      return firstInt;\n    }\n    inputToParse = inputToParse.substr(1);\n  }\n\n  return NaN;\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("parseFirstInt")},function(){return testutil.assert_functionHasNumOfParameter("parseFirstInt",1)},function(){return testutil.assert_functionReturns("parseFirstInt('Sonnebornstr. 2')",2)},function(){return testutil.assert_functionReturns("parseFirstInt('28.12.05')",28)},function(){return testutil.assert_functionReturns("parseFirstInt('Willi ist 22 Jahre alt.')",22)},function(){return testutil.assert_functionReturns("parseFirstInt('Temperatur: -12 Grad')",-12)},function(){return testutil.assert_functionReturns("parseFirstInt('Ohne Zahl')",NaN)}]})})(jshero.testutil);
jshero.koans.add({id:"nor",title:"NOR",lesson:"In der letzten Aufgabe hast du ein sogenanntes NAND-Gatter (engl.: Not AND - nicht und) programmiert.\nNAND-Gatter sind in der Digitaltechnik ein sogenannter Standardbaustein.\nMit ihm lassen sich alle logischen Verkn\xFCpfungen zusammenstellen.\nHier sollst du einen weiteren Standardbaustein, das NOR-Gatter (engl.: Not OR - nicht oder), kennen lernen.",task:"Schreibe eine Funktion <code>nor</code>, die zwei boolesche Werte als Parameter entgegennimmt.\nDie R\xFCckgabe der Funktion soll genau dann <code>true</code> sein, wenn beide Paramter <code>false</code> sind.\nIn den anderen F\xE4llen soll die R\xFCckgabe <code>false</code> sein.<br><br>D. h.: <code>nor(false, false)</code> soll\n<code>true</code> liefern, <code>nor(false, true)</code>, <code>nor(true, false)</code> und <code>nor(true, true)</code>\nsollen <code>false</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("nor")},function(){return jshero.testutil.assert_functionHasNumOfParameter("nor",2)},function(){return jshero.testutil.assert_functionReturns("nor(false, false)",true)},function(){return jshero.testutil.assert_functionReturns("nor(false, true)",false)},function(){return jshero.testutil.assert_functionReturns("nor(true, false)",false)},function(){return jshero.testutil.assert_functionReturns("nor(true, true)",false)}]});
jshero.koans.add({id:"notequals",title:"Strikte Ungleichtheit",lesson:"Mit <code>!==</code> vergleicht man zwei Werte auf strikte Ungleichheit.\n\n<pre><code>let v1 = 'lauf' !== 'Lauf';\nlet v2 = 10 !== '10';</code></pre>\n\nBeide Vergleiche ergeben <code>true</code>. Der erste, weil sich die beiden\nStrings in der Gro\xDF- und Kleinschreibung unterscheiden.\nDer zweite, weil sich die beiden Werte von Typ her unterscheiden.",task:"Schreibe eine Funktion <code>unequal</code>, die 3 Werte auf strikte Ungleichheit \xFCberpr\xFCft.\nDie Funktion soll nur dann <code>true</code> ergeben, wenn alle drei Parameter unterschiedlich sind.<br><br>Beispiel:\n<code>unequal(1, 2, 3)</code> soll <code>true</code> liefern, <code>unequal(1, 1, 2)</code> soll\n<code>false</code> ergeben.",hint:"<pre><code>function unequal(a, b, c) {\n  return a !== b && ...\n}</code></pre>",solution:"<pre><code>function unequal(a, b, c) {\n  return a !== b && a !== c && b !== c;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("unequal")},function(){return jshero.testutil.assert_functionHasNumOfParameter("unequal",3)},function(){return jshero.testutil.assert_functionReturns("unequal(1, 2, 3)",true)},function(){return jshero.testutil.assert_functionReturns("unequal(1, 2, 1)",false)},function(){return jshero.testutil.assert_functionReturns("unequal(2, 1, 1)",false)},function(){return jshero.testutil.assert_functionReturns("unequal('2', 2, 2)",false)},function(){return jshero.testutil.assert_functionReturns("unequal('kLein', 'klein', 'kleiN')",true)},function(){return jshero.testutil.assert_functionReturns("unequal('1', 1, true)",true)},function(){return jshero.testutil.assert_functionReturns("unequal('klein', 'klein', 'kIein')",false)}]});
jshero.koans.add({id:"null",title:"null",lesson:"Neben <code>undefined</code> kennt JavaScript einen weiteren Wert f\xFCr die Abwesentheit eines sinnvollen\nWerts: <code>null</code>. Man kann einer Variablen den Wert <code>null</code> zuordnen und testet mit strikter\nGleichheit auf diesen Wert:\n\n<pre><code>let foo = null;\nif (foo === null) {\n  foo = 1;\n}</code></pre>\n\nEs ist ein Design-Fehler, dass JavaScript zwei Werte f\xFCr \"kein Wert\" besitzt. Wenn m\xF6glich, sollte man\n<code>undefined</code> und <code>null</code> gleich behandeln.",task:"Schreibe eine Funktion <code>cutComment</code>, die eine Zeile JavaScript entgegennimmt\nund einen m\xF6glichen Zeilenkommentar getrimmt zur\xFCckgibt. Enth\xE4lt die Zeile keinen Kommentar, soll <code>null</code>\nzur\xFCckgegeben werden. Ein\xADfach\xADheits\xADhal\xADber gehen wir davon aus, dass der Code kein Kommentar-Zeichen innerhalb\neines Strings enth\xE4lt.<br><br>\nBeispiel: <code>cutCommt('let foo; // bar')</code> sollte <code>'bar'</code> zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("cutComment")},function(){return jshero.testutil.assert_functionHasNumOfParameter("cutComment",1)},function(){return jshero.testutil.assert_functionReturns("cutComment('let foo; // bar')","bar")},function(){return jshero.testutil.assert_functionReturns("cutComment('let n; // Number')","Number")},function(){return jshero.testutil.assert_functionReturns("cutComment('let i;')",null)}]});
jshero.koans.add({id:"number",title:"Zahlen",lesson:"Zahlen werden in JavaScript durch einfache Ziffern dargestellt. Sie k\xF6nnen einen\nDezimalpunkt und ein Minuszeichen besitzen.\n\n<pre><code>let x1 = 1;\nlet x2 = 1.0;\nlet x3 = 3.14;\nlet x4 = -1;</code></pre>\n\n<code>1</code> und <code>1.0</code> sind dieselbe Zahl. Mit Zahlen kann man rechnen. Die\nvier Grundrechenarten Addieren, Subtrahieren, Multiplizieren und Dividieren werden durch\n<code>+ - *</code> und <code>/</code> dargestellt.\n\n<pre><code>let x1 = 6;\nlet x2 = 2;\nlet x3 = x1 + x2;\nlet x4 = x1 - x2;\nlet x5 = x1 * x2;\nlet x6 = x1 / x2;</code></pre>\n\nDie Variablen <code>x3</code> bis <code>x6</code> haben so die Werte <code>8</code>,\n<code>4</code>, <code>12</code> und <code>3</code>.",task:"Schreibe eine Funktion <code>add</code>, die zwei Zahlen als Parameter entgegennimmt\nund deren Summe zur\xFCckgibt.<br><br>Beispiel: <code>add(1, 2)</code> sollte <code>3</code> ergeben.",hint:"<pre><code>function add(x, y) {\n  return ...\n}</code></pre>",solution:"<pre><code>function add(x, y) {\n  return x + y;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("add")},function(){return jshero.testutil.assert_functionHasNumOfParameter("add",2)},function(){return jshero.testutil.assert_functionReturns("add(0, 0)",0)},function(){return jshero.testutil.assert_functionReturns("add(2, 3)",5)},function(){return jshero.testutil.assert_functionReturns("add(-1, 3)",2)}]});
jshero.koans.add({id:"numbertofixed",title:"Number: toFixed()",lesson:"Eine weitere Number-Methode ist <code>toFixed</code>. Sie gibt die Zahl als String mit festen Nachkommastellen zur\xFCck.\n\n<code><pre>let n = 7.25\nlet zeroDigits = n.toFixed(0);\nlet oneDigit = n.toFixed(1);\nlet twoDigits = n.toFixed(2);\nlet threeDigits = n.toFixed(3);</code></pre>\n\n<code>zeroDigits</code> hat den Wert <code>'7'</code>. Es hat keine Nachkommastellen. <code>oneDigit</code> hat den Wert\n<code>'7.3'</code>. Es wird wie bei <code>Math.round()</code> kaufm\xE4nisch gerundet. <code>twoDigits</code> hat den Wert\n<code>'7.25'</code>. Und <code>threeDigits</code> hat den Wert <code>'7.250'</code>. Hier werden fehlende Nachkommastellen\nmit 0 aufgef\xFCllt.",task:"Schreibe eine Funktion <code>toEuro</code>, die eine Zahl als Euro-Betrag ausgibt. Der Betrag soll zwei\nNachkommastellen und ein angeh\xE4ngtes Euro-Zeichen besitzen. Dezimalpunkt soll das Komma sein.<br><br>\nBeispiel: <code>toEuro(1)</code> soll '1,00 \u20AC' ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("toEuro")},function(){return jshero.testutil.assert_functionHasNumOfParameter("toEuro",1)},function(){return jshero.testutil.assert_functionReturns("toEuro(0)","0,00 \u20AC")},function(){return jshero.testutil.assert_functionReturns("toEuro(1)","1,00 \u20AC")},function(){return jshero.testutil.assert_functionReturns("toEuro(1.2555)","1,26 \u20AC")},function(){return jshero.testutil.assert_functionReturns("toEuro(123.4)","123,40 \u20AC")}]});
jshero.koans.add({id:"numbertostring",title:"Number: toString()",lesson:"Strings, so hatten wir gesehen, besitzen eine Reihe von Methoden.\nAuch Numbers besitzen einige - wenn auch wenige - Methoden.\nEine davon ist <code>toString</code>. Sie wandelt die Zahl in den entsprechenden String um.\nDer Dezimalpunkt wird dabei als Punkt dargestellt. Das kann man z.B. dazu verwenden, eine Zahl im deutschen Format,\nalso mit Komma als Dezimalpunkt, auszugeben:\n\n<code><pre>let number = 7.25;\nlet numberInEnglish = number.toString();\nlet numberInGerman = numberInEnglish.replace('.', ',');</code></pre>\n\n<code>numberInEnglish</code> enth\xE4lt den String <code>'7.25'</code>. Da wir jetzt unsere Zahl als String vorliegen haben,\nk\xF6nnen wir auf ihr die String-Methode <code>replace</code> anwenden. <code>numberInGerman</code> enth\xE4lt so den String\n<code>'7,25'</code>.",task:"Schreibe eine Funktion <code>digitLength</code>, die die Anzahl der Ziffern einer nat\xFCrlichen Zahl berechnet.\n<br><br>Beispiel: <code>digitLength(709)</code> sollte 3 zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("digitLength")},function(){return jshero.testutil.assert_functionHasNumOfParameter("digitLength",1)},function(){return jshero.testutil.assert_functionReturns("digitLength(1)",1)},function(){return jshero.testutil.assert_functionReturns("digitLength(709)",3)},function(){return jshero.testutil.assert_functionReturns("digitLength(123456)",6)}]});
(function(testutil){jshero.koans.add({id:"object1",title:"Objekte",lesson:"Um komplexere Sachverhalte abzubilden, verwendet man Objekte. Eine Person hat einen Namen und ein Alter.\nDiese beiden Daten k\xF6nnte man in zwei Variablen speichern. Besser ist es, daf\xFCr ein Objekt zu benutzen.\nObjekte in JavaScript sind eine Sammlung von Eigenschaften. Jede Eigenschaft besteht aus einem Namen und ihrem Wert.\nObjekte werden am einfachsten mit der Mengenklammer erzeugt:\n\n<pre><code>let person = {\n  name: 'Toni Morrison',\n  alter: 88\n};</code></pre>\n\nHier haben wir ein Objekt mit den beiden Eigenschaften <code>name</code> und <code>alter</code> erzeugt.\nDas Objekt wurde der Variablen <code>person</code> zugewiesen.\nAuf dem Namen einer Eigenschaft folgt ein Doppelpunkt und anschlie\xDFend ihr Wert.\nDie Eigenschaft <code>name</code> hat den Wert <code>'Toni Morrison'</code> und die Eigenschaft <code>alter</code>\nden Wert <code>52</code>. Jede Eigenschaft wird mit einem Komma beendet. Bei der letzten Eigenschaft wird das\nKomma weglassen. Man kann alle Eigenschaften zusammen mit ihren Werten in einer Zeile notieren.\n\xDCbersichtlicher ist es, wenn man wie hier f\xFCr jede Eigenschaft eine neue Zeile verwendet.<br><br>\nMit der folgenden Aufgabe wollen wir einen Punkt in einer Ebene modellieren.\nDieser Punkt k\xF6nnte zum Beispiel die Position einer Figur in einem 2-dimensionalen Computerspiel sein.",task:"Erzeuge ein Objekt mit den beiden Eigenschaften <code>x</code> und <code>y</code>.\n<code>x</code> soll den Wert <code>1</code> und <code>y</code> den Wert <code>2</code> erhalten.\nWeise das Objekt der Variablen <code>point</code> zu.",hint:"<pre><code>let point = {\n  ...\n};</code></pre>",solution:"<pre><code>let point = {\n  x: 1,\n  y: 2\n};</code></pre>",tests:[function(){return testutil.assert_variableDefined("point")},function(){return testutil.assert_variableIsObject("point",{x:1,y:2})}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"object2",title:"Objekte erzeugen",lesson:"Die Werte von Objekt-Eigenschaften kann man auch mithilfe von Variablen festlegen:\n\n<pre><code>let title = 'Clean Code';\nlet author = 'Robert C. Martin';\nlet book = {\n  title: title,\n  author: author\n};</code></pre>\n\nHier wird ein Objekt mit den Eigenschaften <code>title</code> und <code>author</code> erzeugt.\n<code>title</code> erh\xE4lt den Wert <code>'Clean Code'</code> und <code>author</code> den Wert\n<code>'Robert C. Martin'</code>.\nIn der Zeile <code>title: title</code> ist <code>title</code> vor dem Doppelpunkt die Objekt-Eigenschaft\nund nach dem Doppelpunkt die zuvor definierte Variable.",task:"Schreibe eine Funktion <code>createPoint</code>, die die Koordinaten eines Punkts in der Ebene\nentgegennimmt und ein Objekt mit den Eigenschaften x und y sowie den \xFCbergebenen Koordinaten zur\xFCckgibt.<br><br>\nBeispiel: <code>createPoint(1,&nbsp;2)</code> sollte <code>{x:&nbsp;1,&nbsp;y:&nbsp;2}</code> zur\xFCckgeben.",hint:"<pre><code>function createPoint(x, y) {\n  return ...\n}</code></pre>",solution:"<pre><code>function createPoint(x, y) {\n  return {\n    x: x,\n    y: y\n  };\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("createPoint")},function(){return testutil.assert_functionHasNumOfParameter("createPoint",2)},function(){return testutil.assert_functionReturnsObject("createPoint(1, 2)",{x:1,y:2})},function(){return testutil.assert_functionReturnsObject("createPoint(-5, 18)",{x:-5,y:18})}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"object3",title:"Eigenschaften auslesen",lesson:"Auf Objekt-Eigenschaften kann man mit der Punkt-Notation zugreifen:\n\n<pre><code>let person = {\n  name: 'Constanze Kurz',\n  geburtstag: new Date(1974, 2, 2),\n  geburtsort: 'Ost-Berlin'\n};\n\nlet pName = person.name;\nlet pGeburtstag = person.geburtstag;\nlet pGeburtsort = person.geburtsort;</code></pre>\n\nDie drei Eigenschaften des Objekts <code>person</code> werden in drei Variablen gespeichert.",task:"Schreibe eine Funktion <code>distance</code>, die den Abstand eines Punkts zum Nullpunkt berechnet.\nHier und im Folgenden ist ein Punkt ein Objekt mit den Eigenschaften x und y.<br><br>Beispiel:\n<code>distance({x:&nbsp3,&nbspy:&nbsp;4})</code> sollte <code>5</code> zur\xFCckgeben.",hint:"Der Abstand eines  Punkts mit den Koordinaten x und y zum Nullpunkt ist &radic;(x&sup2;&nbsp;+&nbsp;y&sup2;).",solution:"<pre><code>function distance(point) {\n  let xSquare = Math.pow(point.x, 2);\n  let ySquare = Math.pow(point.y, 2);\n  return Math.sqrt(xSquare + ySquare);\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("distance")},function(){return testutil.assert_functionHasNumOfParameter("distance",1)},function(){return testutil.assert_functionReturns("distance({x: 2, y: 0})",2)},function(){return testutil.assert_functionReturns("distance({x: 0, y: -3})",3)},function(){return testutil.assert_functionReturns("distance({x: 3, y: 4})",5)}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"object4",title:"Eigenschaften setzen",lesson:"Um Objekt-Eigenschaften zu \xE4ndern, verwendet man ebenfalls die Punkt-Notation:\n\n<pre><code>let ware = {\n  name: '\xC4pfel',\n  preis: 2.15\n};\n\n// irgendwann sp\xE4ter\nware.preis = 2.25;</code></pre>\n\nZun\xE4chst legen wir eine Ware mit dem Preis <code>2.15</code> an. Irgendwann sp\xE4ter wird dieser Preis auf\n<code>2.25</code> erh\xF6ht.",task:"Schreibe eine Funktion <code>moveX</code>, die einen Punkt um 1 nach rechts verschiebt.<br><br>Beispiel:\n<code>moveX({x:&nbsp;2,&nbsp;y:&nbsp;5})</code> sollte <code>{x:&nbsp;3,&nbsp;y:&nbsp;5}</code> zur\xFCckgeben.",hint:"<pre><code>function moveX(point) {\n  ...\n  return point;\n}</code></pre>",solution:"<pre><code>function moveX(point) {\n  point.x = point.x + 1;\n  return point;\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("moveX")},function(){return testutil.assert_functionHasNumOfParameter("moveX",1)},function(){return testutil.assert_functionReturnsObject("moveX({x: 2, y: 0})",{x:3,y:0})},function(){return testutil.assert_functionReturnsObject("moveX({x: 3, y: 5})",{x:4,y:5})}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"parameter",title:"Parameter",lesson:"Jetzt lernen wir Funktionen mit Parametern kennen. Mit\n\n  <pre><code>function gebe(eingabe) {\n  return eingabe;\n}</code></pre>\n\ndefinieren wir eine Funktion, die den \xFCbergebenen Parameter <code>eingabe</code> einfach wieder zur\xFCckgibt.\nParameter sind Variablen. Sie stehen in der runden Klammer und ben\xF6tigen nicht das Schl\xFCsselwort <code>let</code> zu\nihrer Deklaration. Mit\n\n<pre><code>let ergebnis = gebe('Apfel');</code></pre>\n\nwird die Funktion mit dem Argument <code>'Apfel'</code> aufgerufen. Jetzt wird unsere zuvor definierte Funktion\nausgef\xFChrt. Dabei wird zun\xE4chst das Argument <code>'Apfel'</code> dem Parameter <code>eingabe</code> zugewiesen.\n<code>eingabe</code> hat jetzt den Wert <code>'Apfel'</code>. In der einzigen Codezeile der Funktion wird nun die\nVariable <code>eingabe</code> mit der <code>return</code>-Anweisung zur\xFCckgegeben. Diese R\xFCckgabe wird der Variablen\n<code>ergebnis</code> zugewiesen. <code>ergebnis</code> hat dann auch den Wert <code>'Apfel'</code>.",task:"Schreibe eine Funktion <code>echo</code>, die ebenfalls den \xFCbergebenen Parameter wieder zur\xFCckgibt.",hint:"<pre><code>function echo(ton) {\n  ...\n}</code></pre>",solution:"<pre><code>function echo(ton) {\n  return ton;\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("echo")},function(){return testutil.assert_functionHasNumOfParameter("echo",1)},function(){return testutil.assert_functionReturns("echo('Greta')","Greta")},function(){return testutil.assert_functionReturns("echo('CO2')","CO2")}]})})(jshero.testutil);
jshero.koans.add({id:"parameter2a",title:"Parameternamen",lesson:"Bitte achte darauf, dass du eventuelle Parameter deiner Funktion anders nennst als die Funktion selbst.\nDie Funktion <code>f1</code> zum Beispiel\n\n<pre><code>function f1(f1) {\n  return f1;\n}</code></pre>\n\nmacht das gleiche wie diese Funktion:\n\n<pre><code>function f2(eingabe) {\n  return eingabe;\n}</code></pre>\n\nDie zweite Funktionsdefinition ist aber besser, weil der Parameter <code>eingabe</code> hei\xDFt\nund damit anders als die Funktion selbst.",task:"Schreibe eine Funktion <code>ping</code>, die einen Parameter hat und dessen Wert einfach zur\xFCckgibt.\nAchte darauf, dass der Parameter anders hei\xDFt, als die Funktion selbst.",tests:[function(){return jshero.testutil.assert_isFunction("ping")},function(){return jshero.testutil.assert_functionHasNumOfParameter("ping",1)},function(){return jshero.testutil.assert_functionReturns("ping('Test')","Test")},function(){return jshero.testutil.assert_functionReturns("ping('Hallo Welt!')","Hallo Welt!")}]});
jshero.koans.add({id:"parseint",title:"parseInt()",lesson:"H\xE4ufig m\xF6chte man eine Zahl, die als String vorliegt, in eine Zahl vom Typ Number umwandeln.\nF\xFCr das Umwandeln von ganzen Zahlen (..., -2, -1, 0, 1, 2, ..) gibt es in JavaScript die Funktion <code>parseInt</code>.\nFolgende Beispiele geben <code>19</code> oder <code>-19</code> zur\xFCck:\n<pre><code>let n1 = parseInt('19', 10);\nlet n2 = parseInt('+19', 10);\nlet n3 = parseInt('-19', 10);\nlet n4 = parseInt('19 Grad', 10);\nlet n5 = parseInt('19.1', 10);\nlet n6 = parseInt('019', 10);\nlet n7 = parseInt(' 19', 10);</code></pre>\nNeben dem direkten Einlesen von ganzen Zahlen mit oder ohne Vorzeichen (n1, n2, n3) beherrscht <code>parseInt</code>\nauch einige komplexe F\xE4lle. Nicht-numerische Zeichen nach der ganzen Zahl (n4, n5) sowie Nullen (n6) und\nLeerzeichen (n7) vor der Zahl werden ignoriert.<br><br>\nIn allen Beispielen ist der zweite an <code>parseInt</code> \xFCbergebene Parameter <code>10</code>.\nDieser Paramter gibt an, zu welcher Basis die Zahl interpretiert werden soll. <code>10</code> steht f\xFCr das\n\xFCbliche Dezimalsystem. L\xE4\xDFt man den zweiten Paramter weg, wird normalerweise das Dezimalsystem als Default verwendet.\nDa es aber von dieser Regel Ausnahmen gibt und diese Ausnahmen in verschiedenen Browsern auch noch unterschiedlich\ngehandhabt werden, sollte man immer die Basis mit angeben!\n<br><br>\nKann <code>parseInt</code> keine Zahl einlesen, gibt sie den Wert <code>NaN</code> (engl.: Not a Number) zur\xFCck:\n<pre><code>let n1 = parseInt('Nur Text', 10);\nlet n2 = parseInt('Nr. 8', 10);</code></pre>\nIm ersten Fall ist \xFCberhaupt keine Zahl vorhanden. Im zweiten Fall gibt es nicht-numerische Zeichen vor der\neigentlichen Zahl. Auch das ist nicht zul\xE4ssig und f\xFChrt zur R\xFCckgabe <code>NaN</code>.\n<br><br>\nEine ausf\xFChrliche Dokumentation von <code>parseInt</code> findest du bei\n<a href='https://developer.mozilla.org/de/docs/Web/JavaScript/Reference/Global_Objects/parseInt'>Mozilla web docs</a>.",task:"Schreibe eine Funktion <code>add</code>, die einen String mit einer Additionsaufgabe entgegennimmt und die das\nErgebnis der Addition als Zahl zur\xFCckgibt. Es sollen zwei nat\xFCrliche Zahlen addiert werden. Die Additionsaufgabe ist\nein String der Form <code>'102+17'</code>.\n<br><br>Beispiel: Der Aufruf <code>add('102+17')</code> soll die Zahl <code>119</code> zur\xFCckgeben.",hint:"Bestimme mit <code>parseInt</code> den ersten Summanden.\nBestimme mit <code>indexOf</code> die Position des Plus-Zeichens.\nBestimme mit <code>substr</code> den Teilstring nach dem Plus-Zeichen.\nBestimme mit <code>parseInt</code> aus diesem Teilstring den zweiten Summanden.",solution:"<pre><code>function add(s) {\n  let summand1 = parseInt(s, 10);\n  let indexPlus = s.indexOf('+');\n  let sAfterPlus = s.substr(indexPlus + 1);\n  let summand2 = parseInt(sAfterPlus, 10);\n  return summand1 + summand2;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("add")},function(){return jshero.testutil.assert_functionHasNumOfParameter("add",1)},function(){return jshero.testutil.assert_functionReturns("add('1+2')",3)},function(){return jshero.testutil.assert_functionReturns("add('10+100')",110)},function(){return jshero.testutil.assert_functionReturns("add('100123+456')",100579)}]});
jshero.koans.add({id:"pi",title:"Math.PI",lesson:"Neben Funktionen bietet <code>Math</code> auch einige mathematische Konstanten an.\n<code>Math.PI</code> liefert die Kreiszahl &pi; (gerundet 3.14) und <code>Math.E</code> die Eulersche Zahl e (gerundet 2.71).\nBeachte: Die Konstanten werden im Gegensatz zu Funktionen ohne anschlie\xDFende Klammern aufgerufen.",task:"Schreibe eine Funktion <code>flaeche</code>, die die Fl\xE4che eines Kreises berechnet.\n\xDCbergeben wird der Funktion als Parameter der Radius des Kreises.\n<br><br>Tipp: Die Fl\xE4che eines Kreises ist &pi; * r&sup2;. Dabei ist r der Radius des Kreises.",tests:[function(){return jshero.testutil.assert_isFunction("flaeche")},function(){return jshero.testutil.assert_functionHasNumOfParameter("flaeche",1)},function(){return jshero.testutil.assert_functionReturns("flaeche(0)",0)},function(){return jshero.testutil.assert_functionReturns("flaeche(1)",Math.PI)},function(){return jshero.testutil.assert_functionReturns("flaeche(4)",Math.PI*4*4)}]});
(function(testutil,evaluator){let evalDice=function(){return evaluator.evalTest("dice()")};let isOneToSix=function(x){return x===1||x===2||x===3||x===4||x===5||x===6};let throwA=function(x){let result;for(let i=0;i<1000;i++){result=evalDice();if(result===x){return true}}return false};let testWith=function(x){let ok,msg,e;try{ok=throwA(x);if(ok){msg="<code>dice()</code> gab bei 1000 Aufrufen mindestens einmal <code>"+x+"</code> zur\xFCck."}else{msg="<code>dice()</code> gab bei 1000 Aufrufen keine <code>"+x+"</code> zur\xFCck."}}catch(exc){ok=false;msg="Fehler beim Aufruf von <code>dice()</code>.";e=exc}return{ok:ok,msg:msg,e:e}};jshero.koans.add({id:"random",title:"Zufallszahlen",lesson:"Mit <code>Math.random()</code> erzeugt man eine Pseudozufallszahl zwischen 0 (inklusive) und 1 (exklusive).\n\n<pre><code>let x = Math.random();</code></pre>\n\n<code>x</code> k\xF6nnte z.B. den Wert <code>0.6206372241429993</code> erhalten.\nJeder Aufruf von <code>Math.random()</code> generiert eine neue Pseudozufallszahl.\nDie Zahlen sind zwischen 0 und 1 gleichverteilt. Sie hei\xDFen Pseudozufallszahlen,\nweil sie zuf\xE4llig aussehen, aber dennoch berechnet werden.\nM\xF6chte man Zufallszahlen in einem anderen Wertebereich oder mit einer anderen Verteilung erhalten,\nmuss man die von <code>Math.random()</code> generierten Zahlen\ngeeignet transformieren. Das soll jetzt gleich ge\xFCbt werden.",task:"Schreibe eine Funktion <code>dice</code>, die wie ein W\xFCrfel eine Zufallszahl zwischen 1 und 6 zur\xFCckgibt.",tests:[function(){return testutil.assert_isFunction("dice")},function(){return testutil.assert_functionHasNumOfParameter("dice",0)},function(){let ok,msg,e;try{ok=true;let result;for(let i=0;i<1000;i++){result=evalDice();if(!isOneToSix(result)){ok=false;break}}if(ok){msg="<code>dice()</code> gab bei 1000 Aufrufen nur nat\xFCrliche Zahlen zwischen <code>1</code> und <code>6</code> zur\xFCck."}else{msg="<code>dice()</code> gab bei 1000 Aufrufen mindestens einmal <code>"+JSON.stringify(result)+"</code> zur\xFCck. Dies ist keine nat\xFCrliche Zahl zwischen <code>1</code> und <code>6</code>."}}catch(exc){ok=false;msg="Fehler beim Aufruf von <code>dice()</code>.";e=exc}return{ok:ok,msg:msg,e:e}},function(){return testWith(1)},function(){return testWith(2)},function(){return testWith(3)},function(){return testWith(4)},function(){return testWith(5)},function(){return testWith(6)}]})})(jshero.testutil,jshero.evaluator);
(function(testutil){jshero.koans.add({id:"recursion",title:"Rekursion",lesson:"Funktionen k\xF6nnen sich auch selbst aufrufen. Das nennt man <a href='https://de.wikipedia.org/wiki/Rekursive_Programmierung'>Rekursion</a>.\nDas bekannteste Beispiel ist die Berechnung der Fakult\xE4t:\n\n<pre><code>function fakultaet(n) {\n  if (n === 0) {\n    return 1;\n  }\n  return fakultaet(n - 1) * n;\n}</code></pre>\n\nDie <a href='https://de.wikipedia.org/wiki/Fakult%C3%A4t_(Mathematik)'>Fakult\xE4t</a> einer nat\xFCrlichen Zahl ist das Produkt aller\nnat\xFCrlichen Zahlen (ohne Null) kleiner oder gleich dieser Zahl. Sie wird durch ein nachgestelltes Ausrufezeichen abgek\xFCrzt:\nn! = 1 * 2 * 3 ... (n-1) * n. Man sieht, dass man f\xFCr die Berechnung der Fakult\xE4t von n die Fakult\xE4t von n-1 benutzen kann: n! = (n-1)! * n.\nDas Beispielprogramm ist die Umsetzung dieser Formel. Um die Fakult\xE4t von n zu berechnen, muss man die Fakult\xE4t von n-1 berechnen und\ndas Ergebnis mit n multiplizieren. So ruft sich die Funktion <code>fakultaet</code> immer wieder selbst mit einem um 1 verminderten Wert auf.\nNun ben\xF6tigt man noch eine Abbruchbedingung, damit die Rekursion nicht unendlich weiterl\xE4uft. Diese Abbruchbedingung ist mit der\n<code>if</code>-Bedingung formuliert. Ist n bei 0 angekommen, ruft sich <code>fakultaet</code> nicht mehr selbst auf,\nsondern das Ergebnis, n\xE4mlich 0! = 1, wird direkt zur\xFCckgegeben.",task:"Schreibe eine Funktion <code>reverse</code>, die die Reihenfolge der Zeichen in einem String umkehrt.\nDie Funktion sollte rekursiv sein.<br><br>\nBeispiel: <code>reverse('Nebel')</code> sollte <code>'lebeN'</code> zur\xFCckgeben.",tests:[function(){return testutil.assert_isFunction("reverse")},function(){return testutil.assert_functionHasNumOfParameter("reverse",1)},function(){return testutil.assert_functionReturns("reverse('')","")},function(){return testutil.assert_functionReturns("reverse('X')","X")},function(){return testutil.assert_functionReturns("reverse('az')","za")},function(){return testutil.assert_functionReturns("reverse('12345')","54321")},function(){return testutil.assert_functionReturns("reverse('Nebel')","lebeN")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"regex1",title:"Regex: Zeichenliterale",lesson:"<a href='https://de.wikipedia.org/wiki/Regul%C3%A4rer_Ausdruck'>Regul\xE4re Ausdr\xFCcke</a>,\nkurz Regex (engl.: regular expression), sind Muster zum Beschreiben von Zeichenketten.\nSie bilden eine kleine, eigenst\xE4ndige Sprache, die Teil von JavaScript\nund vielen weiteren Sprachen (Python, Perl, ...) und Programmen (LibreOffice, Emacs, ...) ist.\nRegul\xE4re Ausdr\xFCcke sind leistungsstark, aber auch sehr kryptisch.\n<br><br>\nIn JavaScript werden regul\xE4re Ausdr\xFCcke zwischen Schr\xE4gstrichen notiert:\n\n<pre><code>let pruefeAufOF = /OF/;</code></pre>\n\nHier ist <code>OF</code> der regul\xE4rer Ausdruck. Es ist ein sogenanntes Zeichenliteral und steht f\xFCr sich selbst.\nMit ihm kann man testen, ob ein anderer String die Zeichenfolge <code>OF</code> enth\xE4lt:\n\n<pre><code>let t1 = /OF/.test('OF-C 79');\nlet t2 = /OF/.test('B-OF 61');\nlet t3 = /OF/.test('HB-F 42');\nlet t4 = /OF/.test('Ofen');</code></pre>\n\n<code>test()</code> ist eine Regex-Methode. Sie gibt <code>true</code> zur\xFCck, wenn\nder ihr \xFCbergebene String das durch den Regex beschriebene Muster enth\xE4lt.\nIn unserem Fall ist das Muster die Zeichenfolge <code>OF</code>. <code>'OF-C 79'</code> und\n<code>'B-OF 61'</code> enthalten <code>OF</code>, also erhalten <code>t1</code> und <code>t2</code>\nden Wert <code>true</code>. Der String <code>'HB-F 42'</code> enth\xE4lt nicht <code>OF</code>.\n<code>t3</code> ist <code>false</code>.\n<br>\nRegul\xE4re Ausdr\xFCcke unterscheiden zwischen Gro\xDF- und Kleinschreibung.\n<code>'Ofen'</code> enth\xE4lt zwar <code>Of</code>, aber nicht <code>OF</code>.\n<code>t4</code> ist <code>false</code>.",task:"Schreibe eine Funktion <code>enthaeltRose</code>, die pr\xFCft, ob ein String den Teilstring\n<code>'Rose'</code> enth\xE4lt.<br><br>Beispiel: <code>enthaeltRose('eine Rose')</code> sollte <code>true</code> und\n<code>enthaeltRose('ein Blatt')</code> sollte <code>false</code> ergeben.",hint:"<pre><code>Benutze den Regex /Rose/.</pre></code>",solution:"<pre><code>function enthaeltRose(s) {\n  return /Rose/.test(s);\n}</pre></code>",tests:[function(){return testutil.assert_isFunction("enthaeltRose")},function(){return testutil.assert_functionHasNumOfParameter("enthaeltRose",1)},function(){return testutil.assert_functionReturns("enthaeltRose('eine Rose')",true)},function(){return testutil.assert_functionReturns("enthaeltRose('zwei Rosen')",true)},function(){return testutil.assert_functionReturns("enthaeltRose('ein Blatt')",false)},function(){return testutil.assert_functionReturns("enthaeltRose('zwei Bl\xE4tter')",false)}]})})(jshero.testutil);
jshero.koans.add({id:"regex2",title:"Regex: Beliebiges Zeichen",lesson:"Neben einfachen Zeichenliteralen kennen regul\xE4re Ausdr\xFCcke eine\nReihe von Zeichen mit besonderer Bedeutung, sogenannte Metazeichen.\nEin solches Metazeichen ist der Punkt. Er steht f\xFCr genau ein beliebiges Zeichen ausgenommen den Zeilenumbruch:\n\n<pre><code>let t1 = /M.ier/.test('Maier');\nlet t2 = /M.ier/.test('Meierei');\nlet t3 = /M.ier/.test('Baier');\nlet t4 = /M.ier/.test('Mier');\nlet t5 = /M.ier/.test('M-ier');</code></pre>\n\nDer regul\xE4rer Ausdruck <code>/M.ier/</code> steht f\xFCr alle Zeichenketten, die mit\n<code>M</code> beginnen, ein beliebiges zweites Zeichen besitzen und anschlie\xDFend mit\n<code>ier</code> enden. Damit k\xF6nnen wir testen, ob ein String <code>Maier</code> oder\n<code>Meier</code> enth\xE4lt. Das ist in den ersten beiden Beispielzeilen der Fall.\n<code>t1</code> und <code>t2</code> sind <code>true</code>. Der String <code>'Baier'</code> enth\xE4lt\nkein Pattern, dass mit <code>M</code> beginnt. <code>t3</code> ist <code>false</code>.\nAuch <code>t4</code> ist <code>false</code>, da zwischen <code>M</code> und <code>ier</code>\ngenau ein Zeichen liegen muss. Das ist hier nicht der Fall. Da der Punkt f\xFCr jedes beliebige Zeichen\nsteht, trifft <code>'M-ier'</code> auch auf unser Pattern zu. <code>t5</code> ist <code>true</code>.\n<br><br>\nDer Punkt kann auch mehrmals in einem Pattern verwendet werden.\n<code>/H..s/</code> steht f\xFCr alle Zeichenketten, die mit <code>H</code> beginnen, anschlie\xDFend\nzwei beliebige Zeichen besitzen und mit <code>s</code> enden. <code>Hans</code> und <code>Haus</code>\ntreffen auf dieses Pattern zu, <code>His</code> und <code>Heros</code> nicht.",task:"Schreibe eine Funktion <code>pruefe</code>, die feststellt, ob ein String zwei in\ndoppelte Anf\xFChrungszeichen eingeschlossene Zeichen besitzt.<br><br>Beispiel:\n<code>pruefe('\"Wo\"')</code> sollte <code>true</code> und\n<code>pruefe('\"Was\"')</code> sollte <code>false</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("pruefe")},function(){return jshero.testutil.assert_functionHasNumOfParameter("pruefe",1)},function(){return jshero.testutil.assert_functionReturns("pruefe('\"Ja\"')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('-\"Oh\"-')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('\"A\"')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('\"Was\"')",false)}]});
jshero.koans.add({id:"regex3",title:"Regex: Zeichenauswahl",lesson:"Die letzte Lektion f\xFChrte als Metazeichen den Punkt ein.\nEr steht f\xFCr ein beliebiges Zeichen. So steht <code>/M.ier/</code> sowohl f\xFCr <code>Maier</code>\nals auch f\xFCr <code>Meier</code>. Er steht aber auch f\xFCr <code>Mxier</code>.\nM\xF6chte man letzteres ausschlie\xDFen, so muss man die Zeichenauswahl auf <code>a</code>\nund <code>e</code> begrenzen. Dazu schreibt man die gew\xFCnschte Auswahl in eckige Klammern:\n\n<pre><code>let t1 = /M[ae]ier/.test('Maier');\nlet t2 = /M[ae]ier/.test('Meier');\nlet t3 = /M[ae]ier/.test('Mxier');\nlet t4 = /M[ae]ier/.test('Maeier');</code></pre>\n\nDer Ausdruck in eckigen Klammern steht f\xFCr genau ein Zeichen aus diesem Ausdruck.\n<code>/[ae]/</code> steht also f\xFCr ein Zeichen, das ein <code>a</code> oder ein <code>e</code> ist.\n<code>/M[ae]ier/</code> steht dann f\xFCr <code>Maier</code> oder <code>Meier</code>.\nDie Variablen <code>t1</code> sowie <code>t2</code> sind <code>true</code> und <code>t3</code>\nist <code>false</code>. Da <code>/[ae]/</code> f\xFCr genau ein Zeichen steht, ist <code>t4</code>\nauch <code>false</code>.<br><br>\nDie Auswahl kann beliebig viele Zeichen enthalten. <code>/[abc]/</code> steht f\xFCr a, b oder c\nund <code>/[123456]/</code> steht f\xFCr eine Ziffer von 1 bis 6.",task:"Schreibe eine Funktion <code>pruefe</code>, die feststellt, ob ein String den Namen\nMeier in einer der 4 Schreibweisen Maier, Meier, Mayer oder Meyer enth\xE4lt.<br><br>Beispiel:\n<code>pruefe('Frau Mayer')</code> sollte <code>true</code> und\n<code>pruefe('Herr Mezer')</code> sollte <code>false</code> ergeben.",hint:"<pre><code>function pruefe(s) {\n// Verwende die Zeichenauswahl\n// zweimal.\n}</code></pre>",solution:"<pre><code>function pruefe(s) {\n  return /M[ae][iy]er/.test(s);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("pruefe")},function(){return jshero.testutil.assert_functionHasNumOfParameter("pruefe",1)},function(){return jshero.testutil.assert_functionReturns("pruefe('Maier')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('Meier')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('Mayer')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('Meyer')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('Mazer')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('Moyer')",false)}]});
jshero.koans.add({id:"regex4",title:"Regex: Bereiche",lesson:"M\xF6chte man mit der Zeichenauswahl alle Ziffern zulassen, so kann man\ndaf\xFCr <code>/[0123456789]/</code> verwenden. Das ist aber recht umst\xE4ndlich.\nMit einem Bindestrich kann man gr\xF6\xDFere, zusammenh\xE4ngende Zeichenbereiche leicht darstellen:\n\n<pre><code>let pruefeZiffer = /[0-9]/;\nlet pruefe1Bis6 = /[1-6]/;\nlet pruefeABisZ = /[A-Z]/;\nlet pruefeaBisz = /[a-z]/;\nlet pruefeDeutschesAlphabet = /[a-z\xE4\xF6\xFC\xDF]/;\nlet pruefeABisz = /[A-Za-z]/;\nlet pruefeMBisT = /[M-T]/;</code></pre>\n\n<code>/[0-9]/</code> steht wie der Regex oben f\xFCr genau eine Ziffer.\nDen Ziffernbereich kann man, wie <code>/[1-6]/</code> zeigt, leicht auf eine gew\xFCnschte Auswahl\n(z.B. Schulnote) einschr\xE4nken. Der Bindestrich funktioniert aber nicht nur f\xFCr Ziffern,\nsondern auch f\xFCr Buchstaben. Dabei muss man zwischen Klein- und\nGro\xDFbuchstaben unterscheiden. <code>/[A-Z]/</code> steht f\xFCr einen der 26 Gro\xDFbuchstaben und\n<code>/[a-z]/</code> f\xFCr einen Kleinbuchstaben. Wichtig ist, dass hier\n\xE4, \xF6, \xFC und \xDF nicht mit erfasst werden. M\xF6chte man das, so muss man diese Buchstaben gesondert\nauff\xFChren. Dazu schreibt man die Umlaute und das Eszett wie bei einer gew\xF6hnlichen Auswahl\neinfach vor oder hinter den Bereich (<code>/[a-z\xE4\xF6\xFC\xDF]/</code>). Ebenso kann man zwei Bereiche\nhintereinander auff\xFChren. <code>/[A-Za-z]/</code> steht f\xFCr genau einen Klein- oder Gro\xDFbuchstaben.\nDen Buchstabenbereich kann man wie bei Ziffern beliebig einschr\xE4nken (<code>/[M-T]/</code>).",task:"Schreibe eine Funktion <code>pruefe</code>, die testet, ob ein String eine Zeichenfolge wie\n'Klasse 2b' enth\xE4lt. Dabei sind Klassen von 1 bis 6 und a bis d zul\xE4ssig.<br><br>Beispiel:\n<code>pruefe('Die Klasse 1a')</code> sollte <code>true</code> ergeben.",hint:"<pre><code>function pruefe(s) {\n// Verwende Literale\n// und Bereiche.\n}</code></pre>",solution:"<pre><code>function pruefe(s) {\n  return /Klasse [1-6][a-d]/.test(s);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("pruefe")},function(){return jshero.testutil.assert_functionHasNumOfParameter("pruefe",1)},function(){return jshero.testutil.assert_functionReturns("pruefe('Klasse 1a')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('Klasse 2b')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('Klasse 5c')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('Klasse 6d')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('Klasse 0a')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('Klasse 1e')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('Klasse 7d')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('Kasse 1a')",false)}]});
(function(testutil){jshero.koans.add({id:"regex5a",title:"Regex: Anfangs- und Endezeichen",lesson:"Pattern, die wir bisher betrachtet haben, konnten an jeder beliebigen Stelle im zu durchsuchenden String\nstehen. Mit <code>^</code> und <code>$</code> kann man festlegen, dass das Pattern am Anfang bzw. am Ende des zu\ndurchsuchenden Strings stehen soll. <code>/^Hans/</code> trifft auf alle Zeichenketten zu, die mit <code>Hans</code>\nbeginnen und <code>/\\d$/</code> trifft auf alle Zeichenketten zu, die mit einer Ziffer enden. Verwendet man sowohl\ndas Anfangs- als auch das Endezeichen, beschreibt das Pattern den zu untersuchenden String vollst\xE4ndig.\n<code>/^\\d[a-z]$/</code> trifft auf alle Zeichenketten zu, die aus genau einer Ziffer gefolgt von einem\nKleinbuchstaben bestehen.\n<br><br>\n<code>^</code> und <code>$</code> legen die Stelle fest, an der das Suchpattern stehen soll. Solche Zeichen nennt man\nAnker.",task:"Schreibe eine Funktion <code>isTime</code>, die pr\xFCft, ob ein String eine Zeitangabe der Form\nhh:mm:ss ist. hh steht dabei f\xFCr die Stunden, mm f\xFCr die Minuten und ss f\xFCr die Sekunden.\nEs sind alle Zeitangaben von 00:00:00 bis 99:59:59 zugelassen. Bei einstelligen Stunden, Minuten oder Sekunden ist eine\nf\xFChrende Null obligatorisch.<br><br>Beispiel: <code>isTime('02:15:25')</code> sollte <code>true</code> und\n<code>isTime('x02:15:25x')</code> sollte <code>false</code> ergeben.",hint:"<pre><code>function isTime(s) {\n// Verwende ^, $ und\n// Bereiche.\n}</code></pre>",solution:"<pre><code>function isTime(s) {\n  return /^\\d\\d:[0-5]\\d:[0-5]\\d$/.test(s);\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("isTime")},function(){return testutil.assert_functionHasNumOfParameter("isTime",1)},function(){return testutil.assert_functionReturns("isTime('00:00:00')",true)},function(){return testutil.assert_functionReturns("isTime('99:59:59')",true)},function(){return testutil.assert_functionReturns("isTime('02:15:25')",true)},function(){return testutil.assert_functionReturns("isTime('000:00:00')",false)},function(){return testutil.assert_functionReturns("isTime('00:00:000')",false)},function(){return testutil.assert_functionReturns("isTime('00:60:00')",false)},function(){return testutil.assert_functionReturns("isTime('00:00:60')",false)},function(){return testutil.assert_functionReturns("isTime('0:00:00')",false)},function(){return testutil.assert_functionReturns("isTime('00:0:00')",false)},function(){return testutil.assert_functionReturns("isTime('00:00:0')",false)}]})})(jshero.testutil);
jshero.koans.add({id:"regex5neu",title:"Regex: Zeichenklassen",lesson:"F\xFCr einige besondere Zeichenbereiche gibt es Buchstaben als Abk\xFCrzung.\n<code>/\\d/</code> steht f\xFCr eine Ziffer (engl.: digit) und ist identisch mit\n<code>/[0-9]/</code>. Der Regex <code>/\\w/</code> steht f\xFCr ein alphanumerisches Zeichen oder\nden Unterstrich (engl.: word character). <code>/\\w/</code> ist identisch mit <code>/[0-9a-zA-Z_]/</code>.\nDer Abk\xFCrzung ist ein Backslash vorangestellt, damit sie nicht als normaler Buchstabe\ngelesen wird. Abk\xFCrzungen kann man auch innerhalb einer Zeichenauswahl verwenden.\n<code>/[\\da-z]/</code> steht f\xFCr eine Ziffer oder einen Kleinbuchstaben.<br><br>\nEine weitere n\xFCtzliche Zeichenklasse ist <code>\\s</code>. Sie steht f\xFCr ein sogenanntes Leerraum-Zeichen\n(engl.: whitespace character). Sie umfasst das gew\xF6hnliche Leerzeichen, das Tabulator-Zeichen, den Zeilenumbruch\nund weitere \xE4hnliche Zeichen.<br><br>\nVerwendet man anstelle des Kleinbuchstaben den Gro\xDFbuchstaben, kann man die negierte Zeichenklasse darstellen.\n<code>\\D</code> steht f\xFCr alle Zeichen, die keine Ziffer sind, <code>\\W</code> f\xFCr alle Zeichen, die kein\nWord Character sind und <code>\\S</code> steht f\xFCr alle Zeichen, die kein Leerraum-Zeichen sind.",task:"Schreibe eine Funktion <code>test</code>, die pr\xFCft, ob ein String 5 aufeinanderfolgende Ziffern enth\xE4lt.\n<br><br>Beispiel: <code>test('28205')</code> sollte <code>true</code> ergeben.",hint:"<pre><code>function test(s) {\n// Verwende \\d f\xFCnfmal.\n}</code></pre>",solution:"<pre><code>function test(s) {\n  return /\\d\\d\\d\\d\\d/.test(s);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("test")},function(){return jshero.testutil.assert_functionHasNumOfParameter("test",1)},function(){return jshero.testutil.assert_functionReturns("test('28205 Bremen')",true)},function(){return jshero.testutil.assert_functionReturns("test('06493 Neudorf')",true)},function(){return jshero.testutil.assert_functionReturns("test('123456')",true)},function(){return jshero.testutil.assert_functionReturns("test('1000 kg')",false)},function(){return jshero.testutil.assert_functionReturns("test('1000-1=999')",false)}]});
(function(testutil){jshero.koans.add({id:"regex6",title:"Regex: ?",lesson:"In vielen Pattern ist das Vorkommen eines Zeichens variabel. Autokennzeichen\nbestehen aus einer variablen Anzahl von Buchstaben und Ziffern. F\xFCr solche Pattern stehen eine Reihe\nsogenannter Quantoren bereit. Ein elementarer Quantor ist das <code>?</code>. Er bedeutet,\ndass der voranstehende Ausdruck kein- oder einmal vorkommt. <code>/ab?c/</code> steht\nf\xFCr <code>ac</code> (b kommt keinmal vor) oder f\xFCr <code>abc</code> (b kommt einmal vor).\n<code>/[1-9]?[0-9]/</code> steht f\xFCr eine ein- oder zweistellige Zahl.",task:"Schreibe eine Funktion <code>pruefe</code>, die feststellt, ob ein String den\n<a href='https://de.wikipedia.org/wiki/Meier_(Familienname)'>Familiennamen Meier</a> in einer\nder 8 Schreibweisen Maier, Meier, Mayer, Meyer, Mair, Meir, Mayr oder Meyr enth\xE4lt.<br><br>Beispiel:\n<code>pruefe('Mayer')</code> und <code>pruefe('Mayr')</code> sollte <code>true</code>\nergeben.",hint:"<pre><code>function pruefe(s) {\n// Benutze e?\n}</code></pre>",solution:"<pre><code>function pruefe(s) {\n  return /M[ae][iy]e?r/.test(s);\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("pruefe")},function(){return testutil.assert_functionHasNumOfParameter("pruefe",1)},function(){return testutil.assert_functionReturns("pruefe('Maier')",true)},function(){return testutil.assert_functionReturns("pruefe('Mair')",true)},function(){return testutil.assert_functionReturns("pruefe('Mayer')",true)},function(){return testutil.assert_functionReturns("pruefe('Mayr')",true)},function(){return testutil.assert_functionReturns("pruefe('Meier')",true)},function(){return testutil.assert_functionReturns("pruefe('Meir')",true)},function(){return testutil.assert_functionReturns("pruefe('Meyer')",true)},function(){return testutil.assert_functionReturns("pruefe('Meyr')",true)},function(){return testutil.assert_functionReturns("pruefe('aye')",false)},function(){return testutil.assert_functionReturns("pruefe('Mai')",false)},function(){return testutil.assert_functionReturns("pruefe('Maie')",false)},function(){return testutil.assert_functionReturns("pruefe('Maior')",false)},function(){return testutil.assert_functionReturns("pruefe('Maiir')",false)},function(){return testutil.assert_functionReturns("pruefe('Major')",false)},function(){return testutil.assert_functionReturns("pruefe('Miyer')",false)},function(){return testutil.assert_functionReturns("pruefe('Mayeer')",false)},function(){return testutil.assert_functionReturns("pruefe('Maer')",false)}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"regex7",title:"Regex: beliebige Wiederholung",lesson:"Zwei weitere wichtige Quantoren sind <code>*</code> und <code>+</code>. Beide bedeuten, dass\nder voranstehende Ausdruck beliebig oft vorkommen darf. Bei <code>*</code> darf er auch keinmal vorkommen.\nBei <code>+</code> muss er mindestens einmal vorkommen.\n<code>b\xE4h*</code> steht f\xFCr b\xE4, b\xE4h, b\xE4hh und so weiter. <code>[01]+</code> steht f\xFCr\neine beliebige <a href='https://de.wikipedia.org/wiki/Dualsystem'>bin\xE4re Zahl</a> wie zum Beispiel\n0, 1, 001, 10111 oder 11001100. Soll das Pattern die Wiederholung einer Zeichenfolge beschreiben, so muss man\nKlammern verwenden. <code>(ha)+</code> steht f\xFCr ha, haha, hahaha und so weiter.",task:"Schreibe eine Funktion <code>hasQuote</code>, die feststellt, ob ein String ein mit doppelten\nAnf\xFChrungszeichen gekennzeichnetes Zitat enth\xE4lt. Innerhalb des Zitats sind beliebige Zeichen\nzul\xE4ssig. Ein leeres Zitat ist auch zugelassen. Das Zitat soll nicht \xFCber mehrere Zeilen gehen.\nEin Zeilenumbruch innerhalb des Zitats ist also nicht zul\xE4ssig.<br><br>Beispiel:\n<code>hasQuote('\"Ja!\"')</code> sollte <code>true</code> und\n<code>hasQuote('Nein')</code> sollte <code>false</code> ergeben.",hint:"<pre><code>function hasQuote(s) {\n// Benutze .*\n}</code></pre>",solution:"<pre><code>function hasQuote(s) {\n  return /\".*\"/.test(s);\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("hasQuote")},function(){return testutil.assert_functionHasNumOfParameter("hasQuote",1)},function(){return testutil.assert_functionReturns("hasQuote('\"\"')",true)},function(){return testutil.assert_functionReturns("hasQuote('\"Topp!\"')",true)},function(){return testutil.assert_functionReturns("hasQuote('Stimme: \"Ist gerettet!\"')",true)},function(){return testutil.assert_functionReturns("hasQuote('nein')",false)},function(){return testutil.assert_functionReturns("hasQuote('\"nein')",false)},function(){return testutil.assert_functionReturns("hasQuote('nein\"')",false)}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"regex8",title:"Regex: {n, m}",lesson:"Mit einen Ausdruck der Form <code>{n}</code>, <code>{n,m}</code> oder <code>{n,}</code> kann man die\nAnzahl der Wiederholungen genauer festlegen. <code>{n}</code> steht f\xFCr genau n Wiederholungen, <code>{n,m}</code>\nf\xFCr mindestens n und h\xF6chstens m Wiederholungen und <code>{n,}</code> f\xFCr mindestens n Wiederholungen.\nSo steht <code>/\\d{5}/</code> f\xFCr genau 5 aufeinanderfolgende Ziffern, <code>/.{6,20}/</code> f\xFCr mindestens 6 und\nh\xF6chsten 20 beliebige Zeichen und <code>/[a-zA-Z]{5,}/</code> f\xFCr mindestens 5 aufeinanderfolgende Buchstaben.",task:"Schreibe eine Funktion <code>pruefe</code>, die feststellt, ob ein String ein deutsches\nKfz-Kennzeichen ist. Ein solches Kennzeichen soll dem Schema 'XXX YY NNNN' gen\xFCgen. Dabei steht XXX f\xFCr 1 bis 3\nbeliebige Gro\xDFbuchstaben, YY f\xFCr 1 bis 2 beliebige Gro\xDFbuchstaben und NNNN f\xFCr eine maximal 4stellige Zahl. F\xFChrende\nNullen sind bei der Zahl nicht zugelassen.<br><br>Beispiel: <code>pruefe('OF C 709')</code> sollte <code>true</code>\nund <code>pruefe('OF 709')</code> sollte <code>false</code> ergeben.",hint:"<pre><code>function pruefe(s) {\n  return /^[A-Z]{1,3}...\n}</code></pre>",solution:"<pre><code>function pruefe(s) {\n  return /^[A-Z]{1,3} [A-Z]{1,2} [1-9][0-9]{0,3}$/.test(s);\n}</code></pre>",tests:[function(){return testutil.assert_isFunction("pruefe")},function(){return testutil.assert_functionHasNumOfParameter("pruefe",1)},function(){return testutil.assert_functionReturns("pruefe('F A 1')",true)},function(){return testutil.assert_functionReturns("pruefe('F A 9999')",true)},function(){return testutil.assert_functionReturns("pruefe('OF ZZ 1')",true)},function(){return testutil.assert_functionReturns("pruefe('LUP B 456')",true)},function(){return testutil.assert_functionReturns("pruefe('F A 0')",false)},function(){return testutil.assert_functionReturns("pruefe('F A 01')",false)},function(){return testutil.assert_functionReturns("pruefe('OF A 12345')",false)},function(){return testutil.assert_functionReturns("pruefe('OF A')",false)},function(){return testutil.assert_functionReturns("pruefe('HH 1')",false)},function(){return testutil.assert_functionReturns("pruefe('HB AAA 1')",false)},function(){return testutil.assert_functionReturns("pruefe('FFFF A 1')",false)},function(){return testutil.assert_functionReturns("pruefe('F A A 1')",false)},function(){return testutil.assert_functionReturns("pruefe('F A 1 1')",false)}]})})(jshero.testutil);
jshero.koans.add({id:"regexescape",title:"Regex: Escape",lesson:"Wie wir gesehen haben, besitzen regul\xE4re Ausdr\xFCcke eine Reihe von Zeichen mit besonderer Bedeutung.\nSo steht <code>.</code> nicht f\xFCr einen Punkt, sondern f\xFCr ein beliebiges Zeichen.\nM\xF6chte man nach einen Punkt suchen, so muss man die besondere Bedeutung gewisserma\xDFen\nausschalten. Das macht man mit einen vorangestellten Backslash:\n\n<pre><code>let t1 = /\\./.test('Z. B.');\nlet t2 = /\\./.test('ZB');</code></pre>\n\nDer erste Ausdruck ergibt <code>true</code>, der zweite <code>false</code>.\nOhne den Backslash w\xFCrden beide Ausdr\xFCcke <code>true</code> ergeben.\nEin solches 'Ausschalten' nennt man maskieren oder escapen.\n\nM\xF6chte man nach dem Backslash suchen, so muss man diesen ebenfalls maskieren:\n\n<pre><code>let t = /\\\\/.test('A \\ B');\n// t ist true</code></pre>\n\nInsgesamt gibt es 15 Zeichen, die man maskieren muss, wenn man nach ihnen suchen m\xF6chte:\n<code>* + ? . ( ) [ ] { } \\ / | ^ $</code>",task:"Schreibe eine Funktion <code>pruefe</code>, die feststellt, ob ein String den Teilstring <code>'(x)'</code>\nenh\xE4lt.<br><br>Beispiel: <code>pruefe('f(x)')</code> sollte <code>true</code> und\n<code>pruefe('f(n)')</code> sollte <code>false</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("pruefe")},function(){return jshero.testutil.assert_functionHasNumOfParameter("pruefe",1)},function(){return jshero.testutil.assert_functionReturns("pruefe('f(x)')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('g(x)')",true)},function(){return jshero.testutil.assert_functionReturns("pruefe('x')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('f(n)')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('f()')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('(x')",false)},function(){return jshero.testutil.assert_functionReturns("pruefe('x)')",false)}]});
jshero.koans.add({id:"regexexec",title:"Regex: exec()",lesson:"Neben der Methode <code>test</code> besitzen regul\xE4re Ausdr\xFCcke noch die Methode <code>exec</code>.\nW\xE4hrend <code>test</code> feststellt, ob ein Regex in einem String gefunden wird, gibt <code>exec</code>\nauch den gefundenen String und alle gefundenen Gruppen zur\xFCck. Das geschiet in Form eines Arrays.\nDieses Array hat dar\xFCber hinaus die beiden Eigenschaften <code>index</code> und <code>input</code>.\n<code>index</code> enth\xE4lt den 0-basierten Index des gefundenen Strings und <code>input</code>\nden originalen String.<br>\n\n<pre><code>let resultat = /(\\d+):(\\d+)/.exec(\"Kiel-Flensburg 23:25\");\nlet endstand = resultat[0]; // \"23:25\"\nlet toreKiel = resultat[1]; // \"23\"\nlet toreFlensburg = resultat[2]; // \"25\"\nlet index = resultat.index; // 15</code></pre>\n\nWird der regul\xE4re Ausdruck nicht gefunden, gibt <code>exec</code> <code>null</code> zur\xFCck.",task:"Schreibe eine Funktion <code>parseDate</code>, die einen String mit einem Datum entgegennimmt und die dieses\nDatum als Date mit UTC 0:00 Uhr zur\xFCckgibt. Das Datum liegt im deutschen Format dd.mm.yyyy vor. F\xFChrende Nullen sind\noptional. Das Datum kann mitten im String stehen. Enth\xE4lt der String kein g\xFCltiges Datum, soll <code>null</code>\nzur\xFCckgegeben werden.<br><br>Beispiel:\n<code>parseDate(\"Geburt: 12.07.2001\")</code> sollte ein Date-Objekt mit dem Zeitpunkt 12.07.2001 0:00 UTC zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("parseDate")},function(){return jshero.testutil.assert_functionHasNumOfParameter("parseDate",1)},function(){return jshero.testutil.assert_functionReturnsType("parseDate(\"23.10.2019\")","Date")},function(){return jshero.testutil.assert_functionReturns("parseDate(\"23.10.2019\")",new Date(Date.UTC(2019,9,23)),{"utc":true})},function(){return jshero.testutil.assert_functionReturns("parseDate(\"2.5.1912\")",new Date(Date.UTC(1912,4,2)),{"utc":true})},function(){return jshero.testutil.assert_functionReturns("parseDate(\"02.05.1912\")",new Date(Date.UTC(1912,4,2)),{"utc":true})},function(){return jshero.testutil.assert_functionReturns("parseDate(\"...31.12.2000...\")",new Date(Date.UTC(2000,11,31)),{"utc":true})},function(){return jshero.testutil.assert_functionReturns("parseDate(\"..ab.12.2000...\")",null)},function(){return jshero.testutil.assert_functionReturns("parseDate(\"32.12.2000\")",null)},function(){return jshero.testutil.assert_functionReturns("parseDate(\"01.13.2000\")",null)}]});
jshero.koans.add({id:"regexgroup",title:"Regex: Gruppen",lesson:"Klammern hatten wir schon kennengelernt. Sie begrenzen die Anwendung eines Operators auf den eingeklammerten\nBereich. Klammern haben aber noch eine weitere wichtige Funktion. Eingeklammerte Bereiche definieren eine Gruppe.\nDiese Gruppen werden von 1 bis 9 durchnummeriert. Mit <code>\\1</code> bis <code>\\9</code> kann man innerhalb des Regex\nauf eine Gruppe zugreifen. Dabei wird der durch die Gruppe zuvor gefundene String referenziert.\nSo ist es m\xF6glich nach Wiederholungen zu suchen.<br>\n<code>/([a-z])\\1/</code> findet doppelte Kleinbuchstaben und <code>/(\\d)(\\d).*\\1\\2/</code>\nfindet doppelte zweistellige Zahlen.\n\n<pre><code>let t1 = /([a-z])\\1/.test('Affe'); // true\nlet t2 = /(\\d)(\\d).*\\1\\2/.test(12 mal 12'); // true</code></pre>",task:"Schreibe eine Funktion <code>test</code>, die feststellt, ob ein String ein doppeltes Wort enth\xE4lt.\nEin Wort soll aus mindestens einem Buchstaben bestehen. Zugrunde liegt das englische Alphabet. Klein- und Gro\xDFschreibung\nsoll keine Rolle spielen.\n<br><br>Beispiel: <code>test('Ich denke, also bin ich.')</code> sollte <code>true</code>\nund <code>test('Sein oder Nichtsein, das ist hier die Frage!')</code> sollte <code>false</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("test")},function(){return jshero.testutil.assert_functionHasNumOfParameter("test",1)},function(){return jshero.testutil.assert_functionReturns("test('a a')",true)},function(){return jshero.testutil.assert_functionReturns("test('aa a')",false)},function(){return jshero.testutil.assert_functionReturns("test('a aa')",false)},function(){return jshero.testutil.assert_functionReturns("test('B A a b')",true)},function(){return jshero.testutil.assert_functionReturns("test('a aa')",false)},function(){return jshero.testutil.assert_functionReturns("test('Apfel Apfel')",true)},function(){return jshero.testutil.assert_functionReturns("test('Apfel Birne Apfel')",true)},function(){return jshero.testutil.assert_functionReturns("test('Apfel Birne')",false)},function(){return jshero.testutil.assert_functionReturns("test('ApfelApfel')",false)},function(){return jshero.testutil.assert_functionReturns("test('Apfel Apfelmus')",false)},function(){return jshero.testutil.assert_functionReturns("test('ein rein')",false)},function(){return jshero.testutil.assert_functionReturns("test('fein rein')",false)},function(){return jshero.testutil.assert_functionReturns("test('Ich denke, also bin ich.')",true)},function(){return jshero.testutil.assert_functionReturns("test('Sein oder Nichtsein, das ist hier die Frage!')",false)},function(){return jshero.testutil.assert_functionReturns("test('Ja, ja!')",true)},function(){return jshero.testutil.assert_functionReturns("test('1 1')",false)}]});
(function(testutil){jshero.koans.add({id:"regexi",title:"Regex: case-insensitive",lesson:"Regul\xE4re Ausdr\xFCcke kann man durch Flags erg\xE4nzen. Eines dieser Flags ist <code>i</code>.\nIst es gesetzt, unterscheidet das Pattern nicht zwischen Gro\xDF- und Kleinschreibung. Der Regex ist case-insensitive.\nFlags werden dem Regex einfach angeh\xE4ngt:\n\n<pre><code>let t1 = /es/i.test(\"War es\"); // true\nlet t2 = /es/i.test(\"Es war\"); // true\nlet t3 = /es/i.test(\"ES\"); // true</code></pre>",task:"Schreibe eine Funktion <code>test</code>, die feststellt, ob ein String das Wort <code>JavaScript</code>\noder <code>JS</code> enth\xE4lt. Dabei soll Gro\xDF- oder Kleinschreibung keine Rolle spielen.",tests:[function(){return testutil.assert_isFunction("test")},function(){return testutil.assert_functionHasNumOfParameter("test",1)},function(){return testutil.assert_functionReturns("test('JAVASCRIPT')",true)},function(){return testutil.assert_functionReturns("test('hello javascript')",true)},function(){return testutil.assert_functionReturns("test('JavaScript Hero')",true)},function(){return testutil.assert_functionReturns("test('JS')",true)},function(){return testutil.assert_functionReturns("test('hello js')",true)},function(){return testutil.assert_functionReturns("test('JS Hero')",true)},function(){return testutil.assert_functionReturns("test('HelloJavaScript')",false)},function(){return testutil.assert_functionReturns("test('JavaScriptHero')",false)},function(){return testutil.assert_functionReturns("test('Java')",false)},function(){return testutil.assert_functionReturns("test('JSF')",false)},function(){return testutil.assert_functionReturns("test('JJS')",false)}]})})(jshero.testutil);
jshero.koans.add({id:"regexnot",title:"Regex: Negation",lesson:"M\xF6chte man alle Zeichen bis auf einige Ausnahmen zulassen, kann man mit <code>^</code> die Zeichenauswahl\nnegieren. <code>^</code> ist als Negation nur innerhalb einer Zeichenauswahl g\xFCltig. Es muss an erster Stelle der\nZeichenauswahl stehen und negiert die komplette Auswahl. <code>[^ab]</code> steht f\xFCr alle Zeichen au\xDFer einem\n<code>a</code> oder <code>b</code> und <code>[^0-9]</code> steht f\xFCr alle Zeichen au\xDFer einer Ziffer.",task:"Schreibe eine Funktion <code>test</code>, die pr\xFCft, ob ein String nur Zeichen des englischen\nAlphabets enth\xE4lt.<br><br>Beispiel: <code>test('Blue')</code> sollte <code>true</code> und <code>test('Blue sea')</code>\nsollte <code>false</code> ergeben (das Leerzeichen geh\xF6rt nicht zum Alphabet).",tests:[function(){return jshero.testutil.assert_isFunction("test")},function(){return jshero.testutil.assert_functionHasNumOfParameter("test",1)},function(){return jshero.testutil.assert_functionReturns("test('OFC')",true)},function(){return jshero.testutil.assert_functionReturns("test('Kickers')",true)},function(){return jshero.testutil.assert_functionReturns("test('Spa ce')",false)},function(){return jshero.testutil.assert_functionReturns("test('CO2')",false)},function(){return jshero.testutil.assert_functionReturns("test('&Foo')",false)},function(){return jshero.testutil.assert_functionReturns("test('#Foo')",false)},function(){return jshero.testutil.assert_functionReturns("test('Fritz?')",false)},function(){return jshero.testutil.assert_functionReturns("test('Punkt.')",false)},function(){return jshero.testutil.assert_functionReturns("test('a-z')",false)},function(){return jshero.testutil.assert_functionReturns("test('UNTER_STRICH')",false)},function(){return jshero.testutil.assert_functionReturns("test('\xC4h')",false)},function(){return jshero.testutil.assert_functionReturns("test('E\xDFzett')",false)}]});
jshero.koans.add({id:"regexor",title:"Regex: Alternativen",lesson:"M\xF6chte man nach Alternativen suchen, kann man daf\xFCr den <code>|</code> Operator verwenden.\n<code>/Tom|Jerry/</code> sucht nach <code>Tom</code> oder <code>Jerry</code>. Der <code>|</code> Operator\ngilt f\xFCr den kompletten Regex. <code>/\\bTom|Jerry\\b/</code> sucht nach W\xF6rtern, die mit <code>Tom</code>\nbeginnen oder mit <code>Jerry</code> enden. <code>Tomme</code> wird so auch gefunden.\nM\xF6chte man, dass beide Wortgrenzen f\xFCr beide Namen gelten, kann man Klammern verwenden.\n<code>/\\b(Tom|Jerry)\\b/</code> sucht nach den W\xF6rtern <code>Tom</code> oder <code>Jerry</code>. Der\n<code>|</code> Operator gilt jetzt nur f\xFCr die Klammer. <code>Tomme</code> wird nicht mehr gefunden.",task:"Schreibe eine Funktion <code>isTime</code>, die feststellt, ob ein String eine Zeitangabe der Form\n<code>hh:mm</code> ist. F\xFCr <code>hh</code> sind alle Werte von <code>00</code> bis <code>23</code> und f\xFCr\n<code>mm</code> alle Werte von <code>00</code> bis <code>59</code> zugelassen.<br><br>Beispiel:\n<code>isTime('23:27')</code> sollte <code>true</code> und <code>isTime('24:12')</code> sollte\n<code>false</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("isTime")},function(){return jshero.testutil.assert_functionHasNumOfParameter("isTime",1)},function(){return jshero.testutil.assert_functionReturns("isTime('00:00')",true)},function(){return jshero.testutil.assert_functionReturns("isTime('01:01')",true)},function(){return jshero.testutil.assert_functionReturns("isTime('09:19')",true)},function(){return jshero.testutil.assert_functionReturns("isTime('12:27')",true)},function(){return jshero.testutil.assert_functionReturns("isTime('18:47')",true)},function(){return jshero.testutil.assert_functionReturns("isTime('23:59')",true)},function(){return jshero.testutil.assert_functionReturns("isTime('24:00')",false)},function(){return jshero.testutil.assert_functionReturns("isTime('02:60')",false)},function(){return jshero.testutil.assert_functionReturns("isTime('-00:00')",false)},function(){return jshero.testutil.assert_functionReturns("isTime('00:00-')",false)},function(){return jshero.testutil.assert_functionReturns("isTime('1:00')",false)},function(){return jshero.testutil.assert_functionReturns("isTime('00:0')",false)},function(){return jshero.testutil.assert_functionReturns("isTime('00-00')",false)}]});
(function(testutil){jshero.koans.add({id:"regexword",title:"Regex: Wortgrenzen",lesson:"Ein weiterer Anker ist <code>\\b</code>. Er steht f\xFCr eine Wortgrenze. <code>/\\bJa/</code> findet\nalle W\xF6rter, die mit <code>Ja</code> beginnen und <code>/tion\\b/</code> alle W\xF6rter, die mit <code>tion</code> enden.\nVerwendet man <code>\\b</code> sowohl am Anfang als auch am Ende, so kann man nach ganzen W\xF6rten suchen.\n\n<pre><code>let t1 = /\\bdenke/.test('Wir denken'); // true\nlet t2 = /\\bdenke/.test('Bedenke'); // false\nlet t3 = /lauf\\b/.test('der Wettlauf hat'); // true\nlet t4 = /lauf\\b/.test('laufen'); // false\nlet t5 = /\\bso\\b/.test('Aber so ist'); // true</code></pre>\n\nWichtig ist, welche Zeichen als Wortgrenze gelten. In den obigen Beispielen war es das Leerzeichen.\nHinzu kommen alle Satzzeichen wie Punkt, Komma, Ausrufezeichen usw.\nAber auch der Bindestrich gilt als Wortgrenze. <code>/Anna\\b/</code> findet sich in <code>Anna-Ida</code>.\nTats\xE4chlich gelten alle Zeichen, die nicht zur Zeichenklasse <code>\\w</code> geh\xF6ren, als Wortgrenze.\nEs z\xE4hlen also alle nicht-alphanumerischen Zeichen ohne den Unterstrich als Wortgrenze.\nDas bezieht sich allerdings auf das englische Alphabet.\nAlle deutschen Umlaute gelten somit als Wortgrenze. Hier muss man aufpassen.\n<code>/bei\\b/</code> findet sich in <code>bei\xDFen</code>, da <code>\xDF</code> als Wortgrenze angesehen wird.",task:"Schreibe eine Funktion <code>hatLauf</code>, die pr\xFCft, ob ein String ein Wort enth\xE4lt, dass mit\n<code>lauf</code> beginnt. Dabei soll es keine Rolle spielen, ob <code>lauf</code> mit gro\xDFem oder kleinem\n<code>l</code> beginnt.",tests:[function(){return testutil.assert_isFunction("hatLauf")},function(){return testutil.assert_functionHasNumOfParameter("hatLauf",1)},function(){return testutil.assert_functionReturns("hatLauf('Lauf!')",true)},function(){return testutil.assert_functionReturns("hatLauf('Wir laufen da lang!')",true)},function(){return testutil.assert_functionReturns("hatLauf('weglaufen')",false)},function(){return testutil.assert_functionReturns("hatLauf('lau')",false)}]})})(jshero.testutil);
jshero.koans.add({id:"replace",title:"String: replace()",lesson:"Die Methode <code>replace</code> ersetzt einen Teilstring durch einen anderen:\n\n<pre><code>let str = 'Hallo Marcel!';\nlet newstr = str.replace('Marcel', 'Robert');</code></pre>\n\n'Marcel' wird durch 'Robert' ersetzt. <code>newstr</code> hat also den Wert <code>'Hallo Robert!'</code>.\nDer urspr\xFCngliche String bleibt unver\xE4ndert. Nur das erste Vorkommen wird ersetzt:\n\n<pre><code>let newname = 'Peter'.replace('e', 'a');</code></pre>\n\n<code>newname</code> enth\xE4lt den Wert <code>'Pater'</code> und nicht <code>'Patar'</code>.\nEin Spezialfall ergibt sich, wenn der ersetzende String der Leerstring ist:\n\n<pre><code>let nurso = 'sowie so'.replace('wie', '');</code></pre>\n\nDer zu ersetzende String wird entfernt. <code>nurso</code> enth\xE4lt den Wert <code>'so so'</code>.\nKommt der zu ersetzende String nicht vor, so wird der urspr\xFCngliche String zur\xFCckgegeben.",task:"Schreibe eine Funktion <code>convert</code>, die einen Datumsstring in englischer Schreibweise (20-05-2017 oder\n20/05/2017) in deutsche Schreibweise (20.05.2017) umwandet.<br><br>Beispiel: Sowohl\n<code>convert('20-05-2017')</code> als auch <code>convert('20/05/2017')</code> sollten <code>'20.05.2017'</code> ergeben.",hint:"<pre><code>function convert(dateEn) {\n  // Verwende replace viermal.\n}</code></pre>",solution:"<pre><code>function convert(dateEn) {\n  let dateDe = dateEn.replace('-', '.');\n  dateDe = dateDe.replace('-', '.');\n  dateDe = dateDe.replace('/', '.');\n  dateDe = dateDe.replace('/', '.');\n  return dateDe;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("convert")},function(){return jshero.testutil.assert_functionHasNumOfParameter("convert",1)},function(){return jshero.testutil.assert_functionReturns("convert('10-07-1871')","10.07.1871")},function(){return jshero.testutil.assert_functionReturns("convert('8/11/1922')","8.11.1922")}]});
(function(testutil){jshero.koans.add({id:"roman1",title:"R\xF6mische Zahlen I",lesson:"Die folgende Aufgabe ist anspruchsvoll. Versuche eine iterative (Schleife) und eine rekursive L\xF6sung zu finden.",task:"Schreibe eine Funktion <code>roman</code>, die eine\n<a href='https://de.wikipedia.org/wiki/R%C3%B6mische_Zahlschrift'>r\xF6mische Zahl</a> (bis 1000) in eine\n<a href='https://de.wikipedia.org/wiki/Arabische_Zahlschrift'>arabische</a> umwandelt.<br><br>Beispiel:\n<code>roman('CDLXXXIII')</code> sollte <code>483</code> ergeben.",tests:[function(){return testutil.assert_isFunction("roman")},function(){return testutil.assert_functionHasNumOfParameter("roman",1)},function(){return testutil.assert_functionReturns("roman('I')",1)},function(){return testutil.assert_functionReturns("roman('II')",2)},function(){return testutil.assert_functionReturns("roman('III')",3)},function(){return testutil.assert_functionReturns("roman('IV')",4)},function(){return testutil.assert_functionReturns("roman('V')",5)},function(){return testutil.assert_functionReturns("roman('VI')",6)},function(){return testutil.assert_functionReturns("roman('X')",10)},function(){return testutil.assert_functionReturns("roman('CDLXXXIII')",483)},function(){return testutil.assert_functionReturns("roman('DCLXVI')",666)},function(){return testutil.assert_functionReturns("roman('CMXCIX')",999)},function(){return testutil.assert_functionReturns("roman('M')",1000)}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"roman2",title:"R\xF6mische Zahlen II",lesson:"Nun wollen wir es andersherum probieren. Versuche auch hier eine iterative und eine rekursive L\xF6sung zu finden.",task:"Schreibe eine Funktion <code>roman</code>, die eine arabische Zahl (bis 1000) in eine r\xF6mische Zahl umwandelt.\n<br><br>Beispiel: <code>roman(483)</code> sollte <code>'CDLXXXIII'</code> ergeben.",tests:[function(){return testutil.assert_isFunction("roman")},function(){return testutil.assert_functionHasNumOfParameter("roman",1)},function(){return testutil.assert_functionReturns("roman(1)","I")},function(){return testutil.assert_functionReturns("roman(2)","II")},function(){return testutil.assert_functionReturns("roman(3)","III")},function(){return testutil.assert_functionReturns("roman(4)","IV")},function(){return testutil.assert_functionReturns("roman(5)","V")},function(){return testutil.assert_functionReturns("roman(6)","VI")},function(){return testutil.assert_functionReturns("roman(10)","X")},function(){return testutil.assert_functionReturns("roman(483)","CDLXXXIII")},function(){return testutil.assert_functionReturns("roman(666)","DCLXVI")},function(){return testutil.assert_functionReturns("roman(999)","CMXCIX")},function(){return testutil.assert_functionReturns("roman(1000)","M")}]})})(jshero.testutil);
jshero.koans.add({id:"round",title:"Runden",lesson:"M\xF6chte man eine Dezimalzahl auf- oder abrunden, stehen einem die Funktionen <code>Math.round()</code>,\n<code>Math.floor()</code> (engl.: Boden) und <code>Math.ceil()</code> (engl: Decke) zur Verf\xFCgung.\n\n<pre><code>let a = Math.round(5.49);\nlet b = Math.round(4.5);\nlet c = Math.floor(5.99);\nlet d = Math.ceil(4.01);</code></pre>\n\n<code>Math.round()</code> rundet kaufm\xE4nnisch. Zahlen mit der ersten Dezimalstelle kleiner gleich 4 werden abgerundet, alle anderen aufgerundet.\n<code>Math.floor()</code> rundet immer ab und <code>Math.ceil()</code> rundet immer auf. Die Variablen <code>a</code> bis <code>d</code>\nerhalten also alle den Wert <code>5</code>.",task:"Schreibe eine Funktion <code>round100</code>, die eine Dezimalzahl kaufm\xE4nnisch auf die Hunderterstelle\nrundet.<br><br>Beispiel: <code>round100(1749)</code> sollte <code>1700</code> und <code>round100(856.123)</code>\nsollte <code>900</code> ergeben.",hint:"Verwende neben <code>Math.round()</code> noch Multiplikation und Division.",solution:"<pre><code>function round100(x) {\n  return Math.round(x / 100) * 100;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("round100")},function(){return jshero.testutil.assert_functionHasNumOfParameter("round100",1)},function(){return jshero.testutil.assert_functionReturns("round100(49.999)",0)},function(){return jshero.testutil.assert_functionReturns("round100(50)",100)},function(){return jshero.testutil.assert_functionReturns("round100(349)",300)},function(){return jshero.testutil.assert_functionReturns("round100(350)",400)},function(){return jshero.testutil.assert_functionReturns("round100(4649)",4600)},function(){return jshero.testutil.assert_functionReturns("round100(4650)",4700)}]});
jshero.koans.add({id:"slice",title:"Array: slice()",lesson:"Mit <code>slice</code> kopiert man aus einem Array ein Teilarray:\n\n<pre><code>let abcd = ['a', 'b', 'c', 'd'];\nlet ab = abcd.slice(0, 2);\nlet bc = abcd.slice(1, 3);\nlet bcd = abcd.slice(1, 4);</code></pre>\n\nDer erste Parameter gibt den Startindex (einschlie\xDFlich), der zweite den Endindex (ausschlie\xDFlich) an.\nDas urspr\xFCngliche Array wird nicht ver\xE4ndert.",task:"Schreibe eine Funktion <code>halve</code>, die aus einem Array die erste H\xE4lfte kopiert.\nBei einer ungeraden Anzahl von Array-Elementen soll das mittlere Element zu der ersten H\xE4lfte geh\xF6ren.<br><br>Beispiel:\n<code>halve([1,&nbsp;2,&nbsp;3,&nbsp;4])</code> sollte <code>[1,&nbsp;2]</code> zur\xFCckgeben.",hint:"Versuche eine L\xF6sung mit der Array-Methode <code>slice()</code>, der Array-Eigenschaft\n<a href = 'arraylength.html'>length</a> und der Funktion <a href=\"round.html\">Math.ceil()</a> zu finden.",solution:"<pre><code>function halve(arr) {\n  let halfLength = Math.ceil(arr.length/2);\n  return arr.slice(0, halfLength);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("halve")},function(){return jshero.testutil.assert_functionHasNumOfParameter("halve",1)},function(){return jshero.testutil.assert_functionReturns("halve([1, 2])",[1])},function(){return jshero.testutil.assert_functionReturns("halve([1, 2, 3])",[1,2])},function(){return jshero.testutil.assert_functionReturns("halve([1, 2, 3, 4])",[1,2])},function(){return jshero.testutil.assert_functionReturns("halve([1, 2, 3, 4, 5])",[1,2,3])}]});
jshero.koans.add({id:"string1",title:"Strings",lesson:"Wir haben gesehen, dass eine Variable ein Beh\xE4lter f\xFCr einen Wert ist.\nEin Wert kann ein Text wie <code>'Hallo Welt!'</code> sein. Werte besitzen dabei einen Typ.\nDer Typ von <code>'Hallo Welt!'</code> ist string.\nUm aus einem Text einen String zu machen, kann man einfache oder doppelte Anf\xFChrungszeichen verwenden.\nSo ist <code>'Hallo Welt!'</code> derselbe String wie <code>\"Hallo Welt!\"</code>.<br><br>\nMit Strings kann man arbeiten. Man kann sie zum Beispiel verketten. Dies macht man mit dem <code>+</code> Zeichen.\n<code>'Blau' + 'meier'</code> ergibt den String <code>'Blaumeier'</code>.<br><br>\nDie folgende Funktion h\xE4ngt an dem \xFCbergebenen Parameter einen Text an und gibt den zusammengesetzten Text zur\xFCck:\n\n<pre><code>function praise(name) {\n  return name + ' ist toll!';\n}</code></pre>\n\nSo liefert <code>praise('JavaScript')</code> den Wert <code>'JavaScript ist toll!'</code>.",task:"Schreibe eine Funktion <code>welcome</code>, die einen Parameter entgegennimmt und die\n<code>'Hallo &lt;Parameter&gt;!'</code> zur\xFCckgibt.<br><br>\nBeispiel: \xDCbergibt man der Funktion <code>welcome</code> den Wert <code>'Ada'</code>,\nso sollte die Funktion <code>'Hallo Ada!'</code> zur\xFCckgeben.",hint:"<pre><code>function welcome(name) {\n  return ...\n}</code></pre>",solution:"<pre><code>function welcome(name) {\n  return 'Hallo ' + name + '!';\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("welcome")},function(){return jshero.testutil.assert_functionHasNumOfParameter("welcome",1)},function(){return jshero.testutil.assert_functionReturns("welcome('Ada')","Hallo Ada!")},function(){return jshero.testutil.assert_functionReturns("welcome('Marianne')","Hallo Marianne!")},function(){return jshero.testutil.assert_functionReturns("welcome('Mitchell')","Hallo Mitchell!")}]});
jshero.koans.add({id:"stringcharat",title:"String: charAt()",lesson:"Um aus einem String das Zeichen an einer bestimmten Stelle zu erhalten, verwendet man die Methode\n<code>charAt(index)</code>. Der Paramter <code>index</code> gibt die Stelle des Zeichens innerhalb der Zeichenkette an.\nDabei hat das erste Zeichen einer Zeichenkette den Index 0:\n\n<pre><code>let n1 = 'Maria'.charAt(0);\nlet n2 = 'Maria'.charAt(1);\nlet n3 = 'Maria'.charAt(5);\nlet n4 = 'Maria'.charAt();</code></pre>\n\n<code>n1</code> hat den Wert <code>'M'</code> und <code>n2</code> hat den Wert <code>'a'</code>. Ist der Index gr\xF6\xDFer\nals der Index des letzten Zeichens, wird der leere String zur\xFCckgegeben. <code>n3</code> hat also den Wert <code>''</code>.\nWird kein Parameter \xFCbergeben, so wird das Zeichen mit dem Index <code>0</code> zur\xFCckgegeben. Man sagt: der Default-Wert\nf\xFCr <code>index</code> ist <code>0</code>. Der Wert von <code>n4</code> ist also auch <code>'M'</code>.",task:"Schreibe eine Funktion <code>abkuerzung</code>, die zwei Strings als Parameter entgegennimmt und als R\xFCckgabe die Anfangsbuchstaben\ndieser Strings zur\xFCckgibt.<br><br>Beispiel: <code>abkuerzung('Hansestadt', 'Bremen')</code> sollte <code>'HB'</code> zur\xFCckliefern.",hint:"<pre><code>function abkuerzung(s1, s2) {\n  ...\n}</code/></pre>",solution:"<pre><code>function abkuerzung(s1, s2) {\n  return s1.charAt(0) + s2.charAt(0);\n}</code/></pre>",tests:[function(){return jshero.testutil.assert_isFunction("abkuerzung")},function(){return jshero.testutil.assert_functionHasNumOfParameter("abkuerzung",2)},function(){return jshero.testutil.assert_functionReturns("abkuerzung('Hansestadt', 'Bremen')","HB")},function(){return jshero.testutil.assert_functionReturns("abkuerzung('Java', 'Script')","JS")},function(){return jshero.testutil.assert_functionReturns("abkuerzung('personal', 'computer')","pc")}]});
jshero.koans.add({id:"stringindexof",title:"String: indexOf()",lesson:"Um die Position eines Strings innerhalb eines anderen Strings zu bestimmen, verwendet man die Methode <code>indexOf</code>:\n\n<pre><code>let n1 = 'Bit'.indexOf('it');\nlet n2 = 'Bit'.indexOf('js');\nlet n3 = 'Bit'.indexOf('IT');</code></pre>\n\n<code>n1</code> ist <code>1</code>, da <code>'it'</code> in <code>'Bit'</code> an der 1. Stelle beginnt.\nWie \xFCblich beginnt die Z\xE4hlung mit 0.\nKommt das Suchwort im aufrufenden String nicht vor, wird <code>-1</code> zur\xFCckgegeben. <code>n2</code> ist also <code>-1</code>.\nDie Methode <code>indexOf()</code> unterscheidet zwischen Gro\xDF- und Kleinschreibung. <code>n3</code> ist also auch <code>-1</code>.",task:"Schreibe eine Funktion <code>indexOfIgnoreCase</code>, die zwei Strings entgegennimmt und wie die Methode\n<code>indexOf</code> die Position des zweiten Strings im ersten String bestimmt. Im Unterschied zur Methode\n<code>indexOf</code> soll die Gro\xDF- oder Kleinschreibung keine Rolle spielen.<br><br>Beispiel:\nSowohl <code>indexOfIgnoreCase('JS', 'JS')</code> als auch <code>indexOfIgnoreCase('JS', 'js')</code> sollten\n<code>0</code> ergeben.",hint:"<pre><code>function indexOfIgnoreCase(s1, s2) {\n// Wandle s1 und s2 zuerst\n// in Kleinbuchstaben um.\n// Verwende dann die\n// indexOf-Methode.\n}</code></pre>",solution:"<pre><code>function indexOfIgnoreCase(s1, s2) {\n  let s1Klein = s1.toLowerCase();\n  let s2Klein = s2.toLowerCase();\n  return s1Klein.indexOf(s2Klein);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("indexOfIgnoreCase")},function(){return jshero.testutil.assert_functionHasNumOfParameter("indexOfIgnoreCase",2)},function(){return jshero.testutil.assert_functionReturns("indexOfIgnoreCase('JS', 'js')",0)},function(){return jshero.testutil.assert_functionReturns("indexOfIgnoreCase('JavaScript', 'Script')",4)},function(){return jshero.testutil.assert_functionReturns("indexOfIgnoreCase('Fred Feuerstein', 'FEUER')",5)},function(){return jshero.testutil.assert_functionReturns("indexOfIgnoreCase('WILMA FEUERSTEIN', 'feuer')",6)}]});
jshero.koans.add({id:"stringindexof2",title:"String: indexOf(), 2. Parameter",lesson:"Der Methode <code>indexOf</code> kann man als zweiten Parameter noch die Stelle mitgeben,\nab der der Suchstring im aufrufenden String gesucht werden soll.\n\n<pre><code>let n1 = \"Fred Feuerstein\".indexOf(\"e\", 2);\nlet n2 = \"Fred Feuerstein\".indexOf(\"e\", 3);\nlet n3 = \"Fred Feuerstein\".indexOf(\"e\", 7);</code></pre>\n\nDas erste <code>\"e\"</code> befindet sich in <code>\"Fred Feuerstein\"</code> an 2. Stelle. Es wird bei einer Suche ab der 2. Stelle gefunden. <code>n1</code>\nist also 2. Das zweite <code>\"e\"</code> in <code>\"Fred Feuerstein\"</code> befindet sich an der 6. Stelle. Es wird bei der Suche ab der 3. Stelle gefunden.\n<code>n2</code> ist <code>6</code>. Mit der dritten Codezeile wird das dritte <code>\"e\"</code> in <code>\"Fred Feuerstein\"</code> gefunden.\n<code>n3</code> ist <code>8</code>.",task:"Schreibe eine Funktion <code>secondIndexOf</code>, die zwei Strings entgegennimmt und die zweite Position des\nzweiten Strings im ersten String bestimmt. Kommt der Suchstring nicht zweimal vor, so soll <code>-1</code> zur\xFCckgegeben werden.\n<br><br>Beispiel: <code>secondIndexOf(\"Ida-Ida\", \"Ida\")</code> soll <code>4</code> zur\xFCckgeben.\n<br><br>Tipp: Falls Du Hilfe brauchst, lies dir auch die Beschreibung in\n<a href=\"https://wiki.selfhtml.org/wiki/JavaScript/Objekte/String/indexOf\">SELFHTML</a> durch.",hint:"<pre><code>function secondIndexOf(s1, s2) {\n// Verwende indexOf zweimal.\n// Zuerst ohne, dann mit\n// zweitem Parameter.\n}</code></pre>",solution:"<pre><code>function secondIndexOf(s1, s2) {\n  let firstIndex = s1.indexOf(s2);\n  return s1.indexOf(s2, firstIndex + 1);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("secondIndexOf")},function(){return jshero.testutil.assert_functionHasNumOfParameter("secondIndexOf",2)},function(){return jshero.testutil.assert_functionReturns("secondIndexOf(\"AA\", \"A\")",1)},function(){return jshero.testutil.assert_functionReturns("secondIndexOf(\"Ida-Ida\", \"Ida\")",4)},function(){return jshero.testutil.assert_functionReturns("secondIndexOf(\"a rose is a rose\", \"rose\")",12)},function(){return jshero.testutil.assert_functionReturns("secondIndexOf(\"There is no there there.\", \"there\")",18)},function(){return jshero.testutil.assert_functionReturns("secondIndexOf(\"There is no there there.\", \"There\")",-1)}]});
jshero.koans.add({id:"stringlength",title:"String: length",lesson:"Strings besitzen die Eigenschaft <code>length</code>. Diese Eigenschaft liefert die Anzahl der Zeichen eines Strings.\nDazu muss man dem String  oder der Variablen, die den String enth\xE4lt, <code>.length</code> anh\xE4ngen:\n\n<pre><code>let anzahl = 'Franz'.length;</code/></pre>\n\n<code>'Franz'</code> hat 5 Zeichen. Also erh\xE4lt <code>anzahl</code> den Wert <code>5</code>.\n\n<pre><code>let stadt = 'Prag';\nanzahl = stadt.length;</code/></pre>\n\n<code>'Prag'</code> hat 4 Zeichen. <code>anzahl</code> hat jetzt den Wert <code>4</code>.\n\n<pre><code>anzahl = ''.length;</code/></pre>\n\nDer Leerstring besitzt keine Zeichen. Der Wert von <code>anzahl</code> ist jetzt <code>0</code>.",task:"Schreibe eine Funktion <code>laenge</code>, die bei \xDCbergabe eines Strings die Anzahl der Zeichen dieses\nStrings zur\xFCckgibt.<br><br>Beispiel: <code>laenge('Franz')</code> sollte <code>5</code> zur\xFCckgeben.",hint:"<pre><code>function laenge(s) {\n  ...\n}</code/></pre>",solution:"<pre><code>function laenge(s) {\n  return s.length;\n}</code/></pre>",tests:[function(){return jshero.testutil.assert_isFunction("laenge")},function(){return jshero.testutil.assert_functionHasNumOfParameter("laenge",1)},function(){return jshero.testutil.assert_functionReturns("laenge('Hallo Welt!')",11)},function(){return jshero.testutil.assert_functionReturns("laenge('')",0)}]});
jshero.koans.add({id:"stringsplit",title:"String: split()",lesson:"Die Methode <code>split</code> zerlegt einen String anhand eines Trennstrings in Teilstrings.\nDie Teilstrings werden als Array zur\xFCckgegeben. Der urspr\xFCngliche String wird nicht ver\xE4ndert.\n\n<pre><code>let date = '31-10-2017';\nlet parts = date.split('-');\nlet day = parts[0]; // '31'\nlet month = parts[1]; // '10'\nlet year = parts[2]; // '2017'</code></pre>\n\nDer Trennstring ist hier der Bindestrich. Er zerlegt den Datumsstring in drei Teile. Diese drei Teile werden als\nArray der Variablen <code>parts</code> zugewiesen. Anschlie\xDFend werden die einzelnen Teile aus dem Array ausgelesen\nund gesonderten Variablen zugewiesen. Die Variable <code>date</code> hat weiterhin den Wert <code>'31-10-2017'</code>.",task:"Schreibe eine Funktion <code>add</code>, die einen String mit einer Additionsaufgabe entgegennimmt und\ndie das Ergebnis der Addition als Zahl zur\xFCckgibt. Es sollen endlich viele nat\xFCrliche Zahlen addiert werden.\nDie Additionsaufgabe ist ein String der Form '1+19+...+281'.<br><br>Beispiel: <code>add('7+12+100')</code> sollte\n<code>119</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("add")},function(){return jshero.testutil.assert_functionHasNumOfParameter("add",1)},function(){return jshero.testutil.assert_functionReturns("add('1+2')",3)},function(){return jshero.testutil.assert_functionReturns("add('12+5+1+10')",28)},function(){return jshero.testutil.assert_functionReturns("add('50000+4000+300+20+1')",54321)},function(){return jshero.testutil.assert_functionReturns("add('13+2+4+100+3')",122)}]});
jshero.koans.add({id:"stringsubstr",title:"String: substr()",lesson:"Die Methode <code>substr</code> extrahiert aus einen String einen Teilstring:\n\n<pre><code>let see = 'see and stop'.substr(0, 3);\nlet and = 'see and stop'.substr(4, 3);\nlet stop = 'see and stop'.substr(8);</code></pre>\n\nDer erste Parameter gibt an, von welcher Stelle an der Substring extrahiert werden soll.\nDer zweite Parameter gibt an, wieviel Zeichen ab der festgelegten Stelle extrahiert werden sollen.\nIst der zweite Paramter nicht angegeben, so wird immer bis zum Ende des urspr\xFCglichen Strings extrahiert.",task:"Schreibe eine Funktion <code>firstWord</code>, die einen String entgegennimmt und das erste Wort\nin diesem String zur\xFCckgibt. Das erste Wort sind dabei alle Zeichen bis zum ersten Leerzeichen.<br><br>Beispiel:\n<code>firstWord('Wo ist hier')</code> sollte <code>'Wo'</code> zur\xFCckgeben.",hint:"<pre><code>function firstWord(s) {\n// Bestimme mit indexOf\n// die Position des\n// ersten Leerzeichens.\n// Verwende dann die\n// substr-Methode.\n}</code></pre>",solution:"<pre><code>function firstWord(s) {\n  let firstBlank = s.indexOf(' ');\n  return s.substr(0, firstBlank);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("firstWord")},function(){return jshero.testutil.assert_functionHasNumOfParameter("firstWord",1)},function(){return jshero.testutil.assert_functionReturns("firstWord('Wo ist hier')","Wo")},function(){return jshero.testutil.assert_functionReturns("firstWord('Irres Licht')","Irres")}]});
jshero.koans.add({id:"stringupper",title:"String: toUpperCase()",lesson:"Neben der Eigenschaft <code>length</code> besitzen Strings noch eine Reihe von Methoden.\nDas sind Funktionen, die direkt auf dem String angewendet werden. Wie die Eigenschaft <code>length</code>\nwerden diese Methoden mit einem Punkt direkt dem String oder einer Variablen, die einen String enth\xE4lt, angeh\xE4ngt.\nDa Methoden Funktionen sind, folgen in runden Klammern eingeschlossen die Argumente.\nZwei dieser String-Methoden sind die parameterlosen Methoden <code>toUpperCase</code> und <code>toLowerCase</code>.\nSie geben den String, auf dem sie angewendet werden, in Gro\xDF- bzw. Kleinbuchstaben zur\xFCck. Wichtig ist,\ndass der eigentliche String unver\xE4ndert bleibt. Die R\xFCckgabe dieser Methoden ist der in Gro\xDF- bzw. Kleinbuchstaben\numgewandelte String.\n<pre><code>let stadt = 'Prag';\nlet ausgabe = stadt.toUpperCase();</code/></pre>\n<code>ausgabe</code> erh\xE4lt den Wert <code>'PRAG'</code>. <code>stadt</code> hat weiterhin den Wert <code>'Prag'</code>.\n<pre><code>ausgabe = stadt.toLowerCase();</code/></pre>\nJetzt hat <code>ausgabe</code> den Wert <code>'prag'</code>.\n<pre><code>ausgabe = 'Flug 714'.toUpperCase();</code/></pre>\nHier wird <code>toUpperCase()</code> direkt auf einen String angewendet. Der Wert von <code>ausgabe</code> ist\n<code>'FLUG 714'</code>. Zahlen und auch Sonderzeichen werden nicht ver\xE4ndert.",task:"Schreibe eine Funktion <code>toCase</code>, die bei \xDCbergabe eines Strings diesen aneinandergeh\xE4ngt\nin Klein- und in Gro\xDFschreibung zur\xFCckgibt. Das Trennzeichen zwischen der Klein- und Gro\xDFschreibung soll\n<code>-</code> sein.<br><br>Beispiel: <code>toCase('Ida')</code> sollte <code>'ida-IDA'</code> zur\xFCckgeben.",hint:"<pre><code>function toCase(text) {\n  return ... + '-' + ...;\n}</code/></pre>",solution:"<pre><code>function toCase(text) {\n  return text.toLowerCase() + '-' + text.toUpperCase();\n}</code/></pre>",tests:[function(){return jshero.testutil.assert_isFunction("toCase")},function(){return jshero.testutil.assert_functionHasNumOfParameter("toCase",1)},function(){return jshero.testutil.assert_functionReturns("toCase('Ida')","ida-IDA")},function(){return jshero.testutil.assert_functionReturns("toCase('Paris')","paris-PARIS")}]});
(function(testutil,evaluator){jshero.koans.add({id:"subfunction",title:"Funktionen rufen Funktionen auf",lesson:"Funktionen k\xF6nnen weitere Funktionen aufrufen:\n<pre><code>function brutto(netto) {\n  let steuersatz = 19;\n  let steuer = netto * steuersatz / 100;\n  return netto + steuer;\n}\n\nfunction addiereMitMehrwertsteuer(nettoX, nettoY) {\n  let bruttoX = brutto(nettoX);\n  let bruttoY = brutto(nettoY);\n  return bruttoX + bruttoY;\n}</code></pre>\n\n<code>addiereMitMehrwertsteuer</code> nimmt 2 Nettobetr\xE4ge entgegen und gibt die Summe der Bruttobetr\xE4ge zur\xFCck.\n<code>brutto</code> berechnet aus einem Nettobetrag den Bruttobetrag. Dabei wird eine Mehrwertsteuer von 19% zugrunde\ngelegt. Anstatt den Bruttobetrag selbst zu berechnen, ruft <code>addiereMitMehrwertsteuer</code> die Funktion\n<code>brutto</code> auf. Das hat zwei Vorteile: Der Code ist besser lesbar und die Bruttoberechnung wird zentral\nan einer Stelle durchgef\xFChrt.",task:"Schreibe eine Funktion <code>sum</code>, die ein Array gef\xFCllt mit Zahlen entgegennimmt und die Summe dieser\nZahlen zur\xFCckgibt. Schreibe eine Funktion <code>mean</code>, die ein Array gef\xFCllt mit Zahlen entgegennimmt und den\nDurchschnitt dieser Zahlen zur\xFCckgibt. Die Funktion <code>mean</code> sollte die Funktion <code>sum</code> benutzen.",tests:[function(){return testutil.assert_isFunction("sum")},function(){return testutil.assert_functionHasNumOfParameter("sum",1)},function(){return testutil.assert_functionReturns("sum([0])",0)},function(){return testutil.assert_functionReturns("sum([1, 2])",3)},function(){return testutil.assert_functionReturns("sum([1, 4, 10, 85])",100)},function(){return testutil.assert_functionReturns("sum([-2, -4, 17, 34])",45)},function(){return testutil.assert_isFunction("mean")},function(){return testutil.assert_functionHasNumOfParameter("mean",1)},function(){return testutil.assert_functionReturns("mean([0])",0)},function(){return testutil.assert_functionReturns("mean([1, 2])",1.5)},function(){return testutil.assert_functionReturns("mean([1, 4, 10, 85])",25)},function(){return testutil.assert_functionReturns("mean([-2, -4, 17, 34])",11.25)}]})})(jshero.testutil,jshero.evaluator);
jshero.koans.add({id:"trim",title:"String: trim()",lesson:"Die Methode <code>trim</code> entfernt Leerzeichen an beiden Enden eines Strings.\nDer an den Enden um Leerzeichen bereinigte String wird zur\xFCckgegeben.\nDer urspr\xFCgliche String bleibt unver\xE4ndert.\n\n<pre><code>let eingabe = ' Rosa Parks ';\nlet name = eingabe.trim();</code></pre>\n\n<code>name</code> enth\xE4lt den String <code>'Rosa Parks'</code>.\nWie angedeutet werden Benutzereingaben h\xE4ufig vor der Verarbeitung getrimmt.",task:"Schreibe eine Funktion <code>firstChar</code>, die bei \xDCbergabe eines Strings das erste Zeichen,\ndas kein Leerzeichen ist, zur\xFCckgibt.<br><br>Beispiel: <code>firstChar(' Rosa')</code> sollte <code>'R'</code>\nzur\xFCckgeben.",hint:"<pre><code>function firstChar(text) {\n// Trimme zuerst text.\n// Verwende dann die\n// charAt-Methode.\n}</code></pre>",solution:"<pre><code>function firstChar(text) {\n  let textGetrimmt = text.trim();\n  return textGetrimmt.charAt(0);\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("firstChar")},function(){return jshero.testutil.assert_functionHasNumOfParameter("firstChar",1)},function(){return jshero.testutil.assert_functionReturns("firstChar('Rosa')","R")},function(){return jshero.testutil.assert_functionReturns("firstChar(' Louise')","L")},function(){return jshero.testutil.assert_functionReturns("firstChar('  Parks')","P")}]});
(function(testutil){jshero.koans.add({id:"undefined",title:"undefined",lesson:"Bisher hatten wir Variablen bei der Deklaration immer auch initialisiert.\n\n<pre><code>// Deklaration und Initialisierung\nlet x = 1;</code></pre>\n\nMan kann eine Variable aber auch deklarieren und ihr sp\xE4ter einen Wert zuweisen.\n\n<pre><code>let x; // Deklaration\nx = 1; // Initialisierung</code></pre>\n\nVariablen, die nicht initialisiert wurden, haben den Wert <code>undefined</code> (engl.: nicht definiert).<br><br>\nNicht initialisierte Variablen k\xF6nnen auch bei Funktionsaufrufen vorkommen. Ruft man eine Funktion, die einen Parameter\nerwartet, ohne Argument auf, dann erh\xE4lt der Funktionsparameter den Wert <code>undefined</code>.\n\n<pre><code>function echo(x) {\n  return x;\n}\n\n// Aufruf ohne Argument\nlet y = echo();</code></pre>\n\n<code>echo</code> wird ohne Argument aufgerufen. Dem Parameter <code>x</code> wird so kein Wert zugewiesen,\ner erh\xE4lt den Wert <code>undefined</code>.\nDa <code>echo</code> den Parameter <code>x</code> einfach zur\xFCckgibt,\nerh\xE4lt auch <code>y</code> den Wert <code>undefined</code>.<br><br>\nEine Funktion, die einen Parameter erwartet, kann immer auch ohne Argument aufgerufen werden.\nMan sollte sich beim Schreiben von Funktionen immer \xFCberlegen, was in diesem Fall passieren soll.\nGute Praxis ist es, in einem solchen Fall dem Parameter einen Default-Wert (engl.: Vorgabe) zuzuweisen.\nDas hatten wir schon bei der String-Methode <code><a href=\"stringcharat.html\">charAt(index)</a></code> kennengelernt.\nNormalerweise gibt diese Methode das Zeichen an der Stelle <code>index</code>\nzur\xFCck. Rufen wir <code>charAt</code> ohne Argument auf, erh\xE4lt <code>index</code> den Default <code>0</code>.\nEs wird das Zeichen an der Stelle <code>0</code> zur\xFCckgegeben.<br><br>\nUm eine deklarierte Varaible auf <code>undefined</code> zu \xFCberpr\xFCfen, verwendet man wie \xFCblich die\n<a href='equals.html'>strikte&nbsp;Gleichkeit</a>.\nDie Methode <code>charAt</code> k\xF6nnte also folgenden Code-Ausschnitt enthalten:\n\n<pre><code>if (index === undefined) {\n  index = 0;\n}</code></pre>",task:"Schreibe eine Funktion <code>hallo</code>, die einen String als Parameter entgegennimmt und <code>'Hallo &lt;Parameter&gt;!'</code> zur\xFCckgibt.\n<code>hallo('Akg\xFCn')</code> sollte <code>'Hallo Akg\xFCn!'</code> zur\xFCckgeben.\nWird <code>hallo</code> ohne Argument aufgerufen, so soll <code>'Hallo Welt!'</code> zur\xFCckgegeben werden.",tests:[function(){return testutil.assert_isFunction("hallo")},function(){return testutil.assert_functionHasNumOfParameter("hallo",1)},function(){return testutil.assert_functionReturns("hallo('Melek')","Hallo Melek!")},function(){return testutil.assert_functionReturns("hallo('Badu')","Hallo Badu!")},function(){return testutil.assert_functionReturns("hallo()","Hallo Welt!")}]})})(jshero.testutil);
jshero.koans.add({id:"utc",title:"Weltzeit",lesson:"Wenn man mit Datum und Uhrzeit arbeitet, muss man zwischen\n<a href='https://de.wikipedia.org/wiki/Koordinierte_Weltzeit'>koordinierter Weltzeit</a> (UTC, engl. Coordinated Universal Time) und\n<a href='https://de.wikipedia.org/wiki/Zonenzeit'>Zonenzeit</a> unterscheiden.\nDie koordinierte Weltzeit stellt weltweit eine einheitliche Zeitangabe her.\nDie Zonenzeit ist die in einer Zeitzone geltende Zeit.\nVon der koordinierten Weltzeit werden die verschiedenen Zonenzeiten abgeleitet.\nSo ergibt sich die <a href='https://de.wikipedia.org/wiki/Mitteleurop%C3%A4ische_Zeit'>Mitteleurop\xE4ische Zeit (MEZ)</a>\naus der koordinierten Weltzeit durch Addition von einer Stunde (kurz UTC+1). Die Mitteleurop\xE4ische Sommerzeit (MESZ) entspricht\nUTC+2. UTC selbst ist die Zonenzeit der Westeurop\xE4ischen Zeit (WEZ).<br><br>\nWas wir bisher \xFCber das Date-Objekt gelernt haben, bezog sich meist auf die Zonenzeit. So liefert der Ausdruck\n<code>new Date(2018, 4, 5)</code> ein Date-Objekt, das dem Zeitpunkt 5.5.2018, 0:00 Uhr in lokaler Zeit entspricht.\nMacht man diesen Aufruf in Deutschland, erh\xE4lt man den 5.5.2018, 0:00 UTC+2 (Sommerzeit). In Japan liefert derselbe Aufruf\nden 5.5.2018, 0:00 UTC+9. Zwischen beiden Zeitpunkten liegt eine Differenz von 7 Stunden.\nM\xF6chte man weltweit einen einheitlichen Zeitpunkt erzeugen, so muss man die koordinierte Weltzeit verwenden. Leider kann man nicht\ndirekt ein Date aus den UTC-Daten erzeugen. Man muss einen Umweg \xFCber die Millisekunden seit dem 1.1.1970 machen:\n<pre><code>let millis = Date.UTC(2018, 4, 5);\nlet datum = new Date(millis);</code></pre>\nMit <code>Date.UTC()</code> erh\xE4lt man zun\xE4chst die vergangenen Millisekunden seit dem 1.1.1970, 0:00 UTC.\nMit dieser Zahl und <code>new Date()</code> erzeugt man anschlie\xDFend das gew\xFCnschte Date-Objekt.\nDer Konstruktor-Aufruf mit den Millisekunden als Parameter bezieht sich n\xE4mlich auch auf den 1.1.1970, 0:00 UTC.\nDie Variable <code>datum</code> repr\xE4sentiert den 5.5.2018, 0:00 UTC. <code>Date.UTC()</code> kann analog zu <code>new Date()</code> mit bis zu sieben Parametern\n(Jahr, Monat, Tag, Stunden, Minuten, Sekunden und Millisekunden) aufgerufen werden. Es gelten dieselben Regeln wie bei <code>new Date()</code>:\nBei Jahreszahlen zwischen 0 und 99 wird 1900 hinzuaddiert und die Monate werden beginnend mit 0 durchnummeriert.",task:"Schreibe eine Funktion <code>nikolausUTC</code>, die eine Jahresangabe als Zahl entgegennimmt und die ein\nDate-Objekt mit dem 6. Dezember des \xFCbergebenen Jahres, 0:00 UTC, zur\xFCckgibt.<br><br>Beispiel:\n<code>nikolaus(2017)</code> sollte ein Date-Objekt mit dem Zeitpunkt 6.12.2017, 0:00 UTC zur\xFCckgeben.",tests:[function(){return jshero.testutil.assert_isFunction("nikolausUTC")},function(){return jshero.testutil.assert_functionHasNumOfParameter("nikolausUTC",1)},function(){return jshero.testutil.assert_functionReturnsType("nikolausUTC(2017)","Date")},function(){return jshero.testutil.assert_functionReturns("nikolausUTC(2017)",new Date(Date.UTC(2017,11,6)),{"utc":true})},function(){return jshero.testutil.assert_functionReturnsType("nikolausUTC(1960)","Date")},function(){return jshero.testutil.assert_functionReturns("nikolausUTC(1960)",new Date(Date.UTC(1960,11,6)),{"utc":true})}]});
jshero.koans.add({id:"utc2",title:"UTC Setter und Getter",lesson:"Die bisher vorgestellten sieben Date-Getter und -Setter beziehen sich auf die lokale Zeit. Repr\xE4sentiert ein Date-Objekt den\n31.12.2022 22:00 Uhr UTC, so liefern die Methoden <code>getFullYear()</code>, <code>getMonth()</code>, <code>getDate()</code> und <code>getHours()</code>\nin Deutschland (UTC+1) die Werte <code>2022</code>, <code>11</code>, <code>31</code> und <code>23</code>. In Japan (UTC+9) erhielte man\n<code>2023</code>, <code>0</code>, <code>1</code> und <code>7</code>.\n<br><br>\nAnalog zu den sieben lokalen Date-Gettern und -Settern gibt es sieben UTC Date-Getter und -Setter: <code>getUTCFullYear()</code>, <code>setUTCFullYear()</code>,\n<code>getUTCMonth()</code> usw. F\xFCr obiges Datum liefern die Methoden <code>getUTCFullYear()</code>, <code>getUTCMonth()</code>, <code>getUTCDate()</code>\nund <code>getUTCHours()</code> unabh\xE4ngig vom Ort die Werte <code>2022</code>, <code>11</code>, <code>31</code> und <code>22</code>.",task:"Schreibe eine Funktion <code>toJST</code>, die ein Date entgegennimmt und das Datum inkl. Uhrzeit als String in der\n<a href='https://en.wikipedia.org/wiki/Japan_Standard_Time'>Japan Standard Time (JST)</a>\nzur\xFCckgibt. Die Uhrzeit soll dabei ohne Millisekunden angegeben werden.<br><br>Beispiel: F\xFCr <code>date = new Date(Date.UTC(2022, 11, 31, 22, 0))</code> sollte\n<code>toJSTDateTimeString(date)</code>den String <code>'2023-01-01T07:00:00 JST'</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("toJST")},function(){return jshero.testutil.assert_functionHasNumOfParameter("toJST",1)},function(){return jshero.testutil.assert_functionReturns("toJST(new Date(Date.UTC(2022, 11, 31, 22, 0)))","2023-01-01T07:00:00 JST")},function(){return jshero.testutil.assert_functionReturns("toJST(new Date(Date.UTC(2023, 0, 1, 0, 1, 1)))","2023-01-01T09:01:01 JST")}]});
(function(testutil){jshero.koans.add({id:"var",title:"Variablen",lesson:"<a href='https://de.wikipedia.org/wiki/JavaScript'>JavaScript</a>-Programme bestehen\naus einer Reihe von Anweisungen. Jede Anweisung f\xFChrt eine elementare Operation durch.\nDurch das Ausf\xFChren vieler Anweisungen kann man schlie\xDFlich komplexe Aufgaben l\xF6sen.\nJede Anweisung schreibt man in eine Zeile und schlie\xDFt sie mit einem Semikolon ab.<br><br>\nEine elementare Anweisung ist die Deklaration und Initialisierung einer Variablen.\nIn der Programmierung ist eine Variable ein Beh\xE4lter f\xFCr einen Wert.\nMit der Anweisung\n\n<pre><code>let stadt = 'Prag';</code></pre>\n\ndeklariert man eine Variable mit dem Namen <code>stadt</code> und initialisiert sie mit dem Wert <code>'Prag'</code>.\nMit dem Schl\xFCsselwort <code>let</code> wird die Variable deklariert.\nMit dem Gleichheitszeichen, dem Zuweisungsoperator, weist man der Variablen einen Wert zu.<br><br>\nBeachte: JavaScript unterscheidet zwischen Gro\xDF- und Kleinschreibung. <code>stadt</code> und <code>Stadt</code> sind\nzwei verschiedene Variablen. Man sagt auch: JavaScript ist case sensitive.",task:"Deklariere eine Variable <code>vorname</code> und initialisiere sie mit dem Wert <code>'Franz'</code>.",hint:"<pre><code>let vorname = ...</code></pre>",solution:"<pre><code>let vorname = 'Franz';</code></pre>",tests:[function(){return testutil.assert_variableDefined("vorname")},function(){return testutil.assert_variableHasValue("vorname","Franz")}]})})(jshero.testutil);
(function(testutil){jshero.koans.add({id:"var2",title:"Mehrere Variablen",lesson:"M\xF6chte man mehrere Variablen deklarieren und initialisieren, so kann man das in zwei Programmzeilen tun:\n\n<pre><code>let stadt = 'Prag';\nlet land = 'Tschechien';</code></pre>\n\nIn jeder Zeile steht eine Anweisung. Jede Anweisung sollte mit einem Semikolon abgeschlossen werden.",task:"Deklariere eine Variable <code>blume</code> und weise ihr den Wert <code>'Rose'</code> zu.\nDeklariere eine zweite Variable <code>tier</code> und weise ihr den Wert <code>'K\xE4fer'</code> zu.",tests:[function(){return testutil.assert_variableDefined("blume")},function(){return testutil.assert_variableHasValue("blume","Rose")},function(){return testutil.assert_variableDefined("tier")},function(){return testutil.assert_variableHasValue("tier","K\xE4fer")}]})})(jshero.testutil);
jshero.koans.add({id:"while",title:"while-Schleife",lesson:"Die <code>while</code>-Schleife besitzt nur eine Schleifen-Bedingung.\nDer Schleifen-Code wird ausgef\xFChrt, solange die Bedingung <code>true</code> ergibt.\nErgibt die Bedingung <code>false</code>, wird die Schleife beendet und die Codeausf\xFChrung\nwird nach der Schleife fortgesetzt.\n\n<pre><code>let dreiX = '';\nwhile (dreiX.length < 3) {\n  dreiX = dreiX + 'x';\n}</code></pre>\n\nSolange <code>dreiX</code> weniger als 3 Zeichen besitzt, wird es um <code>'x'</code> erg\xE4nzt.\nHat <code>dreiX</code> die L\xE4nge 3, wird die Schleife beendet.\n<code>dreiX</code> hat dann den Wert <code>'xxx'</code>.",task:"Schreibe eine Funktion <code>abstand</code>, die eine nat\xFCrliche Zahl n als Parameter\nentgegennimmt und die einen String bestehend aus n Leerzeichen zur\xFCckgibt.<br><br>\nBeispiel: <code>abstand(1)</code> sollte <code>' '</code> ergeben.",tests:[function(){return jshero.testutil.assert_isFunction("abstand")},function(){return jshero.testutil.assert_functionHasNumOfParameter("abstand",1)},function(){return jshero.testutil.assert_functionReturns("abstand(0)","")},function(){return jshero.testutil.assert_functionReturns("abstand(1)"," ")},function(){return jshero.testutil.assert_functionReturns("abstand(2)","  ")},function(){return jshero.testutil.assert_functionReturns("abstand(3)","   ")}]});
jshero.koans.add({id:"xor",title:"XOR",lesson:"Die logischen Operatoren kennen, \xE4hnlich der Punkt- vor Strich-Rechnung, eine Reihenfolge:\nNICHT zuerst, anschlie\xDFend UND, zuletzt ODER. M\xF6chte man diese Reihenfolge \xE4ndern, verwendet man Klammern:\n\n<pre><code>let x1 = true || false && false;\nlet x2 = (true || false) && false;\nlet x3 = !false && false;\nlet x4 = !(false && false);</code></pre>\n\nIn der ersten Zeile wird zuerst UND ausgewertet. <code>x1</code> wird <code>true</code>.\nIn der zweiten Zeile wird zuerst ODER ausgewertet. <code>x2</code> wird <code>false</code>.\nIn der dritten Zeile wird zuerst NICHT ausgewertet. <code>x3</code> wird <code>false</code>.\nUnd in der vierten Zeile wird zuerst UND ausgewertet. <code>x4</code> wird <code>true</code>.<br><br>\nIn der folgenden Aufgabe sollst du ein weiteres wichtiges Gatter, das XOR-Gatter (engl.: eXclusive OR - exklusives oder),\nprogrammieren.",task:"Schreibe eine Funktion <code>xor</code>, die zwei boolesche Werte als Parameter entgegennimmt.\nDie R\xFCckgabe der Funktion soll <code>true</code> sein, wenn beide Paramter verschieden sind.\nIn den anderen F\xE4llen soll die R\xFCckgabe <code>false</code> sein.<br><br>D. h.: <code>xor(true, false)</code> und\n<code>xor(false, true)</code> sollen <code>true</code> liefern, <code>xor(true, true)</code> und\n<code>xor(false, false)</code> sollen <code>false</code> zur\xFCckgeben.",hint:"Schreibe einen Ausdruck, der nur dann <code>true</code> ergibt, wenn der erste Parameter <code>true</code> und\nder zweite <code>false</code> ist. Schreibe dann einen Ausdruck, der nur dann <code>true</code> ergibt, wenn der erste\nParameter <code>false</code> und der zweite <code>true</code> ist. Verkn\xFCpfe beide Ausdr\xFCcke angemessen.\nKlammern sind bei der L\xF6sung nicht n\xF6tig.",solution:"<pre><code>function xor(a, b) {\n  return a && !b || !a && b;\n}</code></pre>",tests:[function(){return jshero.testutil.assert_isFunction("xor")},function(){return jshero.testutil.assert_functionHasNumOfParameter("xor",2)},function(){return jshero.testutil.assert_functionReturns("xor(true, true)",false)},function(){return jshero.testutil.assert_functionReturns("xor(true, false)",true)},function(){return jshero.testutil.assert_functionReturns("xor(false, true)",true)},function(){return jshero.testutil.assert_functionReturns("xor(false, false)",false)}]});
jshero.koans.initReorder(["var","jsx01","var2","jsx02","jsx03","function","function2","functioncall","jsx04","parameter","jsx05","parameter2a","string1","jsx06","jsx06b","log1","log2","log","jsx07","stringlength","stringupper","stringcharat","trim","stringindexof","stringindexof2","stringsubstr","replace","number","increment","fahrenheit","modulo","mean","math","minmax","pi","round","random","parseint","numbertostring","numbertofixed","bool","nor","xor","equals","equals2","even","notequals","greaterthan","if","if2","else","elseif","array","array2","array3","arraylength","arraysort","arraypush","arrayindexof","concat","slice","join","dimarray","comment","undefined","null","for1","fakultaet","for2","while","dowhile","ggt","break","bubblesort","doubleloop","arguments","nan","stringsplit","date","date2","date3","utc","utc2","gettime","subfunction","recursion","const","functionexpression","arrow","roman1","roman2","euler1","object1","object2","object3","object4","method1","functional","functional2","filter","regex1","regex2","regex3","regex4","regexnot","regex5neu","regexescape","regex5a","regexword","regexor","regexi","regex6","regex7","regex8","regexgroup","regexexec","further"]);
