---
title: 'Storybook 7.0 - March 2023'
---

## The future of UI development

SB7.0 is a full rework of Storybook's core with fast build and next-generation interaction testing.

- 3️⃣ [**Component Story Format v3**](https://storybook.js.org/blog/storybook-csf3-is-here/) trims boilerplate code and improves ergonomics
- 🛡️ [**Improved type safety**](https://storybook.js.org/blog/improved-type-safety-in-storybook-7/)
- 📚 [**Docs overhaul**](https://storybook.js.org/blog/storybook-7-docs/) with MDX2 support and streamlined doc blocks
- 🏗️ [**Frameworks API**](https://storybook.js.org/blog/framework-api/) for streamlined integrations
  - 🔼 [**Zero-config NextJS**](https://storybook.js.org/blog/integrate-nextjs-and-storybook-automatically/)
  - 🇸 [**Zero-config SvelteKit**](https://storybook.js.org/blog/storybook-for-sveltekit/)
- ⚡️ [**First-class Vite support**](https://storybook.js.org/blog/first-class-vite-support-in-storybook/): Storybook is configured automatically based on your Vite settings, and reduced installation size & startup time.
- [**Improved interaction testing:**](https://storybook.js.org/blog/test-component-interactions-with-storybook/) stabilized test runner and interactions debugger
- ☂️ [**Code coverage**](https://storybook.js.org/blog/code-coverage-with-the-storybook-test-runner/) for interaction tests
- 🎨 [**UI design refresh:**](https://storybook.js.org/blog/7-0-design-alpha/) edge-to-edge layout, redrawn icons & refined forms
- 🏛️ [**Improved stability**](https://storybook.js.org/blog/storybook-ecosystem-ci/) with Ecosystem CI
- 💯 Hundreds more improvements at every level

---

7.0 contains hundreds more fixes, features, and tweaks. Browse the [changelogs](https://github.com/storybookjs/storybook/blob/next/CHANGELOG.md) matching `7.0.0-alpha.*`, `7.0.0-beta.*`, and `7.0.0-rc.*` for the full list of changes.

See our [Migration guide](https://storybook.js.org/migration-guides/7.0) to upgrade from earlier versions of Storybook.
