const ILLUSTRATION_ARIA_LABEL =
  "Vercel and Next.js logos side-by-side, surrounded by multiple growing ellipses with orbiting circles on top.";

export function Illustration() {
  return (
    <>
      <svg
        width={780}
        height={780}
        viewBox="0 0 780 780"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        className="illustration"
        data-theme="light"
        aria-label={ILLUSTRATION_ARIA_LABEL}
        style={
          {
            "--circle-opacity": 0.1,
          } as React.CSSProperties
        }
      >
        <circle
          opacity={0.1}
          cx={390.125}
          cy={389.911}
          r={160.417}
          stroke="url(#paint0_linear_155_13)"
          strokeWidth={1.16501}
        />
        <circle
          opacity={0.1}
          cx={388.125}
          cy={389.911}
          r={103.417}
          stroke="url(#paint1_linear_155_13)"
          strokeWidth={1.16501}
        />
        <circle
          opacity={0.1}
          cx={388.125}
          cy={389.911}
          r={53.4175}
          stroke="url(#paint2_linear_155_13)"
          strokeWidth={1.16501}
        />
        <circle
          opacity={0.1}
          cx={390}
          cy={390}
          r={267.295}
          stroke="url(#paint3_linear_155_13)"
          strokeWidth={1.16501}
        />
        <circle
          opacity={0.1}
          cx={390}
          cy={390}
          r={388.507}
          stroke="url(#paint4_linear_155_13)"
          strokeWidth={1.16501}
        />
        <circle
          style={
            {
              "--circle-opacity": 1,
            } as React.CSSProperties
          }
          className="orbit"
          cx={146.533}
          cy={500.319}
          r={5.65757}
          transform="rotate(180 146.533 500.319)"
          fill="#fff"
          stroke="#2F77D1"
          strokeWidth={1.5}
        />
        <circle
          style={
            {
              "--circle-opacity": 1,
            } as React.CSSProperties
          }
          className="orbit"
          cx={153.533}
          cy={265.319}
          r={5.65757}
          transform="rotate(180 153.533 265.319)"
          fill="#fff"
          stroke="#2F77D1"
          strokeWidth={1.5}
        />
        <circle
          style={
            {
              "--circle-opacity": 1,
            } as React.CSSProperties
          }
          className="orbit"
          cx={320.533}
          cy={311.319}
          r={5.65757}
          transform="rotate(180 320.533 311.319)"
          fill="#fff"
          stroke="#000"
          strokeWidth={1.5}
        />
        <circle
          style={
            {
              "--circle-opacity": 1,
            } as React.CSSProperties
          }
          className="orbit"
          cx={492.533}
          cy={265.319}
          r={5.65757}
          transform="rotate(180 492.533 265.319)"
          fill="#fff"
          stroke="#2F77D1"
          strokeWidth={1.5}
        />
        <circle
          style={
            {
              "--circle-opacity": 1,
            } as React.CSSProperties
          }
          className="orbit"
          cx={641.533}
          cy={483.319}
          r={5.82506}
          transform="rotate(180 641.533 483.319)"
          fill="#fff"
          stroke="#000"
          strokeWidth={1.16501}
        />
        <path d="M306.5 429.911l-46.188-80-46.187 80H306.5z" fill="#000" />
        <path
          d="M389.125 372.411v35M371.625 389.911h35"
          stroke="#999"
          strokeWidth={3.5625}
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <g clipPath="url(#clip0_155_13)">
          <mask
            id="a"
            style={{
              maskType: "alpha",
            }}
            maskUnits="userSpaceOnUse"
            x={493}
            y={348}
            width={82}
            height={82}
          >
            <path
              d="M534 430c22.644 0 41-18.356 41-41s-18.356-41-41-41-41 18.356-41 41 18.356 41 41 41z"
              fill="#000"
            />
          </mask>
          <g mask="url(#a)">
            <path
              d="M534 430c22.644 0 41-18.356 41-41s-18.356-41-41-41-41 18.356-41 41 18.356 41 41 41z"
              fill="#000"
            />
            <path
              d="M561.109 419.759L524.498 372.6H517.6v32.786h5.518v-25.778l33.659 43.488a41.047 41.047 0 004.332-3.337z"
              fill="url(#paint5_linear_155_13)"
            />
            <path
              d="M550.856 372.6h-5.467v32.8h5.467v-32.8z"
              fill="url(#paint6_linear_155_13)"
            />
          </g>
        </g>
        <defs>
          <linearGradient
            id="paint0_linear_155_13"
            x1={390.125}
            y1={228.911}
            x2={390.125}
            y2={550.911}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.463542} stopColor="#323232" />
            <stop offset={1} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint1_linear_155_13"
            x1={388.125}
            y1={285.911}
            x2={388.125}
            y2={493.911}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.463542} stopColor="#464646" />
            <stop offset={1} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint2_linear_155_13"
            x1={388.125}
            y1={335.911}
            x2={388.125}
            y2={443.911}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.463542} stopColor="#666" />
            <stop offset={1} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint3_linear_155_13"
            x1={390}
            y1={122.123}
            x2={390}
            y2={657.878}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.09375} stopColor="#1E1E1E" stopOpacity={0} />
            <stop offset={0.463542} stopColor="#2E2E2E" />
            <stop offset={0.901042} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint4_linear_155_13"
            x1={390}
            y1={0.910889}
            x2={390}
            y2={779.089}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.208333} stopColor="#171717" stopOpacity={0} />
            <stop offset={0.463542} stopColor="#151515" />
            <stop offset={0.786458} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint5_linear_155_13"
            x1={542.656}
            y1={401.072}
            x2={558.828}
            y2={421.117}
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#fff" />
            <stop offset={1} stopColor="#fff" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint6_linear_155_13"
            x1={548.122}
            y1={372.6}
            x2={548.031}
            y2={396.688}
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#fff" />
            <stop offset={1} stopColor="#fff" stopOpacity={0} />
          </linearGradient>
          <clipPath id="clip0_155_13">
            <path
              fill="#fff"
              transform="translate(493 348)"
              d="M0 0H82V82H0z"
            />
          </clipPath>
        </defs>
      </svg>
      <svg
        width={780}
        height={780}
        viewBox="0 0 780 780"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        className="illustration"
        data-theme="dark"
        aria-label={ILLUSTRATION_ARIA_LABEL}
        style={
          {
            "--circle-opacity": 1,
          } as React.CSSProperties
        }
      >
        <circle
          cx={390.125}
          cy={389.911}
          r={160.417}
          stroke="url(#paint0_linear_155_43)"
          strokeWidth={1.16501}
        />
        <circle
          cx={388.125}
          cy={389.911}
          r={103.417}
          stroke="url(#paint1_linear_155_43)"
          strokeWidth={1.16501}
        />
        <circle
          cx={388.125}
          cy={389.911}
          r={53.4175}
          stroke="url(#paint2_linear_155_43)"
          strokeWidth={1.16501}
        />
        <circle
          cx={390}
          cy={390}
          r={267.295}
          stroke="url(#paint3_linear_155_43)"
          strokeWidth={1.16501}
        />
        <circle
          cx={390}
          cy={390}
          r={388.507}
          stroke="url(#paint4_linear_155_43)"
          strokeWidth={1.16501}
        />
        <g
          filter="url(#filter0_d_155_43)"
          transform="rotate(180 146.533 500.319)"
        >
          <circle cx={146.533} cy={500.319} r={6.40757} fill="#000" />
          <circle
            cx={146.533}
            cy={500.319}
            r={5.82506}
            stroke="#2F77D1"
            strokeWidth={1.16501}
          />
        </g>
        <g
          filter="url(#filter1_d_155_43)"
          transform="rotate(180 153.533 265.319)"
        >
          <circle cx={153.533} cy={265.319} r={6.40757} fill="#000" />
          <circle
            cx={153.533}
            cy={265.319}
            r={5.82506}
            stroke="#2F77D1"
            strokeWidth={1.16501}
          />
        </g>
        <g
          filter="url(#filter2_d_155_43)"
          transform="rotate(180 320.533 311.319)"
        >
          <circle cx={320.533} cy={311.319} r={6.40757} fill="#000" />
          <circle
            cx={320.533}
            cy={311.319}
            r={5.82506}
            stroke="#fff"
            strokeWidth={1.16501}
          />
        </g>
        <g
          filter="url(#filter3_d_155_43)"
          transform="rotate(180 492.533 265.319)"
        >
          <circle cx={492.533} cy={265.319} r={6.40757} fill="#000" />
          <circle
            cx={492.533}
            cy={265.319}
            r={5.82506}
            stroke="#2F77D1"
            strokeWidth={1.16501}
          />
        </g>
        <g
          filter="url(#filter4_d_155_43)"
          transform="rotate(180 641.533 483.319)"
        >
          <circle cx={641.533} cy={483.319} r={6.40757} fill="#000" />
          <circle
            cx={641.533}
            cy={483.319}
            r={5.82506}
            stroke="#fff"
            strokeWidth={1.16501}
          />
        </g>
        <path d="M306.5 429.911l-46.188-80-46.187 80H306.5z" fill="#fff" />
        <path
          d="M389.125 372.411v35M371.625 389.911h35"
          stroke="#999"
          strokeWidth={3.5625}
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <mask
          id="a"
          style={{
            maskType: "alpha",
          }}
          maskUnits="userSpaceOnUse"
          x={493}
          y={348}
          width={82}
          height={82}
        >
          <path
            d="M534 430c22.644 0 41-18.356 41-41s-18.356-41-41-41-41 18.356-41 41 18.356 41 41 41z"
            fill="#000"
          />
        </mask>
        <g mask="url(#a)">
          <path
            d="M534 430c22.644 0 41-18.356 41-41s-18.356-41-41-41-41 18.356-41 41 18.356 41 41 41z"
            fill="#000"
            stroke="#fff"
            strokeWidth={2.66667}
          />
          <path
            d="M561.109 419.759L524.498 372.6H517.6v32.786h5.518v-25.778l33.659 43.488a41.047 41.047 0 004.332-3.337z"
            fill="url(#paint5_linear_155_43)"
          />
          <path
            d="M550.856 372.6h-5.467v32.8h5.467v-32.8z"
            fill="url(#paint6_linear_155_43)"
          />
        </g>
        <defs>
          <filter
            id="filter0_d_155_43"
            x={105.175}
            y={470.611}
            width={82.716}
            height={82.716}
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity={0} result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy={11.6501} />
            <feGaussianBlur stdDeviation={17.4752} />
            <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0" />
            <feBlend
              in2="BackgroundImageFix"
              result="effect1_dropShadow_155_43"
            />
            <feBlend
              in="SourceGraphic"
              in2="effect1_dropShadow_155_43"
              result="shape"
            />
          </filter>
          <filter
            id="filter1_d_155_43"
            x={112.175}
            y={235.611}
            width={82.716}
            height={82.716}
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity={0} result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy={11.6501} />
            <feGaussianBlur stdDeviation={17.4752} />
            <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0" />
            <feBlend
              in2="BackgroundImageFix"
              result="effect1_dropShadow_155_43"
            />
            <feBlend
              in="SourceGraphic"
              in2="effect1_dropShadow_155_43"
              result="shape"
            />
          </filter>
          <filter
            id="filter2_d_155_43"
            x={279.175}
            y={281.611}
            width={82.7159}
            height={82.716}
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity={0} result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy={11.6501} />
            <feGaussianBlur stdDeviation={17.4752} />
            <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0" />
            <feBlend
              in2="BackgroundImageFix"
              result="effect1_dropShadow_155_43"
            />
            <feBlend
              in="SourceGraphic"
              in2="effect1_dropShadow_155_43"
              result="shape"
            />
          </filter>
          <filter
            id="filter3_d_155_43"
            x={451.175}
            y={235.611}
            width={82.7159}
            height={82.716}
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity={0} result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy={11.6501} />
            <feGaussianBlur stdDeviation={17.4752} />
            <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0" />
            <feBlend
              in2="BackgroundImageFix"
              result="effect1_dropShadow_155_43"
            />
            <feBlend
              in="SourceGraphic"
              in2="effect1_dropShadow_155_43"
              result="shape"
            />
          </filter>
          <filter
            id="filter4_d_155_43"
            x={600.175}
            y={453.611}
            width={82.7159}
            height={82.716}
            filterUnits="userSpaceOnUse"
            colorInterpolationFilters="sRGB"
          >
            <feFlood floodOpacity={0} result="BackgroundImageFix" />
            <feColorMatrix
              in="SourceAlpha"
              values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
              result="hardAlpha"
            />
            <feOffset dy={11.6501} />
            <feGaussianBlur stdDeviation={17.4752} />
            <feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0" />
            <feBlend
              in2="BackgroundImageFix"
              result="effect1_dropShadow_155_43"
            />
            <feBlend
              in="SourceGraphic"
              in2="effect1_dropShadow_155_43"
              result="shape"
            />
          </filter>
          <linearGradient
            id="paint0_linear_155_43"
            x1={390.125}
            y1={228.911}
            x2={390.125}
            y2={550.911}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.463542} stopColor="#323232" />
            <stop offset={1} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint1_linear_155_43"
            x1={388.125}
            y1={285.911}
            x2={388.125}
            y2={493.911}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.463542} stopColor="#464646" />
            <stop offset={1} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint2_linear_155_43"
            x1={388.125}
            y1={335.911}
            x2={388.125}
            y2={443.911}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.463542} stopColor="#666" />
            <stop offset={1} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint3_linear_155_43"
            x1={390}
            y1={122.123}
            x2={390}
            y2={657.878}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.09375} stopColor="#1E1E1E" stopOpacity={0} />
            <stop offset={0.463542} stopColor="#2E2E2E" />
            <stop offset={0.901042} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint4_linear_155_43"
            x1={390}
            y1={0.910889}
            x2={390}
            y2={779.089}
            gradientUnits="userSpaceOnUse"
          >
            <stop offset={0.208333} stopColor="#171717" stopOpacity={0} />
            <stop offset={0.463542} stopColor="#151515" />
            <stop offset={0.786458} stopColor="#333" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint5_linear_155_43"
            x1={542.656}
            y1={401.072}
            x2={558.828}
            y2={421.117}
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#fff" />
            <stop offset={1} stopColor="#fff" stopOpacity={0} />
          </linearGradient>
          <linearGradient
            id="paint6_linear_155_43"
            x1={548.122}
            y1={372.6}
            x2={548.031}
            y2={396.688}
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#fff" />
            <stop offset={1} stopColor="#fff" stopOpacity={0} />
          </linearGradient>
        </defs>
      </svg>
    </>
  );
}
