# Reverse Engineering on OS X

For the past several years I've been a developer at Mozilla,
specializing in OS X and particularly in fixing bugs that happen only
on OS X.  Since many of these bugs involve third party apps (for
example plugins) or the OS itself, I've had to learn a lot about
reverse engineering on OS X.  This an attempt to distill my
experience, acquired over the last few years, into something like a
tutorial.  I hope people will be able to learn from it, and even
become excited about it!

Steven Michaud, 5/2013

## Table of Contents

* [Why Reverse Engineer?](reverse-engineering-why.md)

* [Resources](reverse-engineering-resources.md)

* [Techniques](reverse-engineering-techniques.md)

* [Example 1: Figuring Out NSView Dirty
  Rects](reverse-engineering-examples-1.md)

* [Example 2: Locating the Source of a Problem Using an Error
  Message](reverse-engineering-examples-2.md)

* [Example 3: Finding Out How Flash Detects Graphics
  Hardware](reverse-engineering-examples-3.md)

* [Example 4: Locating the Source of a Problem Using a Crash
  Stack](reverse-engineering-examples-4.md)
