# Uncle Steve's Big List of Text Analytics and NLP Resources

```
 ____ ____ ____ ____ _________ ____ ____ ____ ____ ____ ____ 
||t |||e |||x |||t |||       |||m |||i |||n |||i |||n |||g ||
||__|||__|||__|||__|||_______|||__|||__|||__|||__|||__|||__||
|/__\|/__\|/__\|/__\|/_______\|/__\|/__\|/__\|/__\|/__\|/__\|
```

A curated list of resources for learning about natural language processing, text analytics, and unstructured data. [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

## Table of Contents
- [Books](#books)
  - [R](#r)
  - [Python](#python)
  - [General](#general-books)
- [Blogs](#blogs)
- [Blog articles, Papers, Case Studies](#blog-articles-papers-case-studies)
  - [General](#general-articles)
  - [Biases in NLP](#biases-in-nlp)
  - [Scraping](#scraping)
  - [Cleaning](#cleaning)
  - [Stemming](#stemming)
  - [Dimensionality Reduction](#dimensionality-reduction)
  - [Sarcasm Detection](#sarcasm-detection)
  - [Document Classification](#document-classification)
  - [Entity and Information Extraction](#entity-and-information-extraction)
  - [Document Clustering and Document Similarity](#document-clustering-and-document-similarity)
  - [Concept Analysis/Topic Modeling](#concept-analysis)
  - [Sentiment Analysis](#sentiment-analysis)
  - [Text Summarization](#text-summarization)
  - [Machine Translation](#machine-translation)
  - [Q&A Systems, Chatbots](#qa-systems)
  - [Fuzzy Matching, Probabilistic Matching, Record Linkage, Etc.](#fuzzy-matching)
  - [Word and Document Embeddings](#word-and-document-embeddings)
  - [Transformers and Language Models](#transformers-and-language-models)
  - [Deep Learning](#deep-learning)
  - [Knowledge Graphs](#knowledge-graphs)
- [Major NLP Conferences](#major-nlp-conferences)
- [Benchmarks](#benchmarks)
- [Online Courses](#online-courses)
- [APIs and Libraries](#apis-and-libraries)
- [Products](#products)
- [Online Demos and Tools](#online-demos-and-tools)
- [Datasets](#datasets)
- [Misc](#misc)
- [Other Curated Lists](#other-curated-lists)

## Books

#### R
- [Text Mining with R](http://tidytextmining.com/)
- [Mastering Text Mining with R](http://shop.oreilly.com/product/9781783551811.do?green=C89CE13A-3CEC-5EBD-08AC-F97ED76586DF&intcmp=af-mybuy-9781783551811.IP)
- [Text Mining in Practice with R](https://www.wiley.com/en-us/Text+Mining+in+Practice+with+R-p-9781119282013)

#### Python
- [Natural Language Processing with Transformers, Revised Edition](https://transformersbook.com/)
- [Getting Started with Natural Language Processing](https://www.manning.com/books/getting-started-with-natural-language-processing)
- [Blueprints for Text Analytics Using Python: Machine Learning-Based Solutions for Common Real World (NLP) Applications](https://www.oreilly.com/library/view/blueprints-for-text/9781492074076/)
- [Practical Natural Language Processing](https://www.oreilly.com/library/view/practical-natural-language/9781492054047/)
- [Natural Language Processing with Python](http://www.nltk.org/book/)
- [Natural Language Processing with PyTorch](http://shop.oreilly.com/product/0636920063445.do)
- [Python Natural Language Processing](http://shop.oreilly.com/product/9781787121423.do)
- [Mastering Natural Language Processing with Python](http://shop.oreilly.com/product/9781783989041.do)
- [Natural Language Processing: Python and NLTK](http://shop.oreilly.com/product/9781787285101.do)
- [Applied Text Analysis with Python: Enabling Language-Aware Data Products with Machine Learning](http://shop.oreilly.com/product/0636920052555.do)
- [Applied Natural Language Processing With Python](https://link.springer.com/book/10.1007%2F978-1-4842-3733-5). 2018.
- [Deep Learning with Text](http://shop.oreilly.com/product/0636920076063.do)

#### General <a id="general-books"></a>
- [Taming Text: How to Find, Organize, and Manipulate It](https://www.manning.com/books/taming-text). A hands-on guide to learn innovative tools and techniques for finding, organizing, and manipulating unstructured text.
- [Speech and Language Processing](https://web.stanford.edu/~jurafsky/slp3/)
- [Foundations of Statistical Natural Language Processing](http://nlp.stanford.edu/fsnlp/)
- [Language Processing with Perl and Prolog: Theories, Implementation, and Application (Cognitive Technologies)](http://promethee.philo.ulg.ac.be/engdep1/download/bacIII/Nugues%20second%20ed.pdf)
- [An introduction for information retrieval](http://nlp.stanford.edu/IR-book/)
- [Handbook of Natural Language Processing](https://karczmarczuk.users.greyc.fr/TEACH/TAL/Doc/Handbook%20Of%20Natural%20Language%20Processing,%20Second%20Edition%20Chapman%20&%20Hall%20Crc%20Machine%20Learning%20&%20Pattern%20Recognition%202010.pdf)
- [Practical Text Mining and Statistical Analysis for Non-structured Text Data Applications](http://store.elsevier.com/Practical-Text-Mining-and-Statistical-Analysis-for-Non-structured-Text-Data-Applications/Gary-Miner/isbn-9780123870117/)
- [Fundamentals of Predictive Text Mining](http://www.springer.com/us/book/9781447125655#otherversion=9781849962254)
- [Mining the Social Web: Data Mining Facebook, Twitter, LinkedIn, Google+, GitHub, and More](https://www.amazon.com/Mining-Social-Web-Facebook-LinkedIn/dp/1449367615/ref=pd_sim_b_3?ie=UTF8&refRID=1HV4RRVDA02CYH3S6W8C)
- [Neural Network Methods for Natural Language Processing](http://www.morganclaypool.com/doi/abs/10.2200/S00762ED1V01Y201703HLT037)
- [Text Mining: A Guidebook for the Social Sciences](https://us.sagepub.com/en-us/nam/text-mining/book244124)
- [Practical Text Analytics: Interpreting Text and Unstructured Data for Business Intelligence](https://www.koganpage.com/product/practical-text-analytics-9780749474010#region)
- [Neural Network Methods in Natural Language Processing](https://www.morganclaypool.com/doi/abs/10.2200/S00762ED1V01Y201703HLT037)
- [Machine Learning for Text (2018)](https://www.springer.com/us/book/9783319735306)
- [Natural Language Processing in Spanish](https://iaarbook.github.io/procesamiento-del-lenguaje-natural/)
- [Foundations of Computational Linguistics Human-Computer Communication in Natural Language](https://www.springer.com/gp/book/9783642414305). Provides insights on how to build talking robots.
- [Statistical Methods for Speech Recognition](https://mitpress.mit.edu/books/statistical-methods-speech-recognition). Highlights important research and statistical methods for speech recognition.
- [How To Label Data](https://www.lighttag.io/how-to-label-data/) Extended guide on managing large text annotation projects


## Blogs
- [Probably Approximately a Scientific Blog](http://veredshwartz.blogspot.com/)
- [Sebastian Ruder](http://ruder.io/)
- [NLP-progress](https://nlpprogress.com/)
- [Natural Language Processing Blog](https://nlpers.blogspot.com/)


## Blog Articles, Papers, Case Studies

### General <a id="general-articles"></a>
- [NLP in healthcare](https://www.mckinsey.com/industries/healthcare-systems-and-services/our-insights/natural-language-processing-in-healthcare). How NLP can be used by healthcare payers and providers.
- [AI Harvard Business Review](https://hbr.org/2018/07/ais-next-great-challenge-understanding-the-nuances-of-language). The impact of improvement in NLP on human interaction with machines.
- [Why Accuracy in Natural Language Processing is Crucial to the Future of AI in Retail](https://www.mytotalretail.com/article/why-accuracy-in-natural-language-processing-is-crucial-to-the-future-of-ai-in-retail/)
- [Natural Language Processing is Fun! How computers understand Human Language](https://medium.com/@ageitgey/natural-language-processing-is-fun-9a0bff37854e). 2018.
- [WEF Live Campaign - Twitter fed Global News Topics & Sentiment Tracker](https://365.weflive.com/#!/r/worldwide/t/all-topics) - Live Jan 2019
- [Modern Deep Learning Techniques Applied to Natural Language Processing](https://nlpoverview.com)
- [The Definitive Guide to Natural Language Processing](https://monkeylearn.com/blog/definitive-guide-natural-language-processing/). MonkeyLearn. Non technical overview.
- [From Natural Language to Calendar Entries, with Clojure](http://edeferia.blogspot.ca/2015/03/from-natural-language-to-calendar.html). March 2015. NLP, Clojure
- [Ask HN: How Can I Get into NLP (Natural Language Processing)?](https://news.ycombinator.com/item?id=12916498)
- [Ask HN: What are the best tools for analyzing large bodies of text?](https://news.ycombinator.com/item?id=9733883)
- [Quora: How do I learn Natural Language Processing?](https://www.quora.com/How-do-I-learn-Natural-Language-Processing). Good intro for beginner with time estimate breakdown and links to Stanford CS courses.
- [Quora Topic: Natural Language Processing](https://www.quora.com/topic/Natural-Language-Processing)
- [The Definitive Guide to Natural Language Processing](https://blog.monkeylearn.com/the-definitive-guide-to-natural-language-processing/) October 2015.
- [Futures of text](http://whoo.ps/2015/02/23/futures-of-text) Feb 2015. A survey of all the current innovation in text as a medium.
- [R or Python on Text Mining](https://datawarrior.wordpress.com/2015/08/12/codienerd-1-r-or-python-on-text-mining/) Aug 2015. Comparison of efficiency between R and Python in the field of Text Mining.
- [Where to start in Text Mining](https://tedunderwood.com/2012/08/14/where-to-start-with-text-mining/) Aug 2012.
- [Text Mining in R and Python: 8 Tips To Get Started](https://www.r-bloggers.com/text-mining-in-r-and-python-8-tips-to-get-started/). Oct 2016
- [An introduction to text analysis with Python, Part 1](http://nealcaren.web.unc.edu/an-introduction-to-text-analysis-with-python-part-1/) April 2012. A beginner’s walkthrough on the basics idea of sentiment analysis in Python.
- [Mining Twitter Data with Python (Part 1: Collecting Data)](https://marcobonzanini.com/2015/03/02/mining-twitter-data-with-python-part-1/)
- [Why Text Mining May Be The Next Big Thing](http://business.time.com/2012/03/20/why-text-mining-may-be-the-next-big-thing/). March 2012.
- [SAS CEO offers analytics over BI, reveals use cases for text analytics](http://www.computerweekly.com/news/2240037240/SAS-CEO-offers-analytics-over-BI-reveals-use-cases-for-text-analytics) June 2011.
- [Value and benefits of text mining](https://www.jisc.ac.uk/reports/value-and-benefits-of-text-mining). Sep 2015.
- [Text Mining South Park](http://kaylinwalker.com/text-mining-south-park/) Feb 2016 - A Text Mining blog which covers on a variety of topics.
- [Natural Language Processing: An Introduction](http://jamia.oxfordjournals.org/content/18/5/544.full)
- [Natural Language Processing Tutorial](http://www.vikparuchuri.com/blog/natural-language-processing-tutorial/). June 2013.
- [Natural Language Processing blog](http://nlpers.blogspot.ca/). 
- [An Introduction to Text Mining using Twitter Streaming API and Python](http://adilmoujahid.com/posts/2014/07/twitter-analytics/)
  - GitHub repo with code: https://github.com/adilmoujahid/Twitter_Analytics
- [How To Get Into Natural Language Processing](http://blog.ycombinator.com/how-to-get-into-natural-language-processing/)'. Basic non technical intro to NLP.
- [Betty: a friendly English-like interface for your command line.](https://github.com/pickhardt/betty)
- [Creating machine learning models to analyze startup news - Part1](https://monkeylearn.com/blog/filtering-startup-news-machine-learning/). [Part 2](https://monkeylearn.com/blog/creating-machine-learning-models-analyze-news/). [Part 3](https://monkeylearn.com/blog/analyzing-startup-news-with-machine-learning/).
- [Comparison of the Most Useful Text Processing APIs](https://www.kdnuggets.com/2018/08/comparison-most-useful-text-processing-apis.html)
- [100 Must-Read NLP Papers](https://github.com/mhagiwara/100-nlp-papers)
- [Python Guide for dealing with Text Data](https://www.analyticsvidhya.com/blog/2018/02/the-different-methods-deal-text-data-predictive-python/)
- [Crowdsourcing Ground Truth for Medical Relation Extraction](https://dl.acm.org/citation.cfm?id=3152889)
- [Natural language based financial forecasting: a survey](https://sentic.net/natural-language-based-financial-forecasting.pdf)
- [Natural language based financial forecasting: a survey](https://sentic.net/natural-language-based-financial-forecasting.pdf). An article that clarifies the scope of Natural Language Financial Forecasting.
- [5 Heroic Tools for Natural Language Processing](https://towardsdatascience.com/5-heroic-tools-for-natural-language-processing-7f3c1f8fc9f0)
- [Natural Language Processing unlocks hidden data to transform healthcare efficiency, quality and cost](https://www.healthcareglobal.com/technology/natural-language-processing-unlocks-hidden-data-transform-healthcare-efficiency-quality)
- [Extracting medical problems from electronic clinical documents](https://www.sciencedirect.com/science/article/pii/S1532046405001140)
- [Natural Language Processing (NLP) for Machine Learning](https://towardsdatascience.com/natural-language-processing-nlp-for-machine-learning-d44498845d5b). Includes basic, easy to understand preprocessing and compares a few ML classificaiotn models in Python.
- [How to Write a Spelling Corrector - by Peter Norvig](https://norvig.com/spell-correct.html)
- [Using AI to unleash the power of unstructured government data](https://www2.deloitte.com/insights/us/en/focus/cognitive-technologies/natural-language-processing-examples-in-government-data.html): (W. Eggers, N. Malik, & M. Gracie, January 2019). “Think of unstructured text as being ‘trapped’ in physical and virtual file cabinets. The promise is clear: Governments could improve effectiveness and prevent many catastrophes by improving their ability to ‘connect the dots’ and identify patterns in available data.” This Deloitte article provides an easy-to-comprehend primer and background on NLP, and the various applications NLP could be used on unstructured Government text data. The article includes many US Government examples on how NLP is currently deployed across different domains (e.g. to help analyze public feedback/sentiment analysis/topic modelling, to improve forensic investigations, to aid in Government policy-making and regulatory compliance). The key point is to apply different NLP techniques to explore and uncover key Government intelligence insights.
- [Extracting Features of Entertainment Products: A Guided Latent Dirichlet Allocation Approach Informed by the Psychology of Media Consumption](https://doi.org/10.1177/0022243718820559): (O. Toubia, G. Iyengar, R. Bunnell, & A. Lemaire, February 2019). “We rely on the NLP literature to develop a method for tagging entertainment products in an automated and scalable manner. In the context of movies, we first show that the proposed features improve our ability to predict consumption at the individual level… We also show that guided LDA features have the potential to improve the performance of models that predict aggregate performance outcomes rather than individual-level consumption.” This academic article provides both a framework and managerial implications that suggest the application of LDA and NLP for feature extraction in entertainment products that can aid in traditional content-based consumer behavior models, and relevant marketing models applied to the media and entertainment industry.
- [Lessons learned building natural language processing systems in health care](https://www.oreilly.com/ideas/lessons-learned-building-natural-language-processing-systems-in-health-care)
- [How Algorithms Know What You’ll Type Next](https://pudding.cool/2019/04/text-prediction)


### Biases in NLP 
- [AI bias: It is the responsibility of humans to ensure fairness](https://www.information-age.com/ai-bias-123479217/)
- [Venturebeat Blogpost - Gender biases in datasets](https://venturebeat.com/2018/09/07/researchers-develop-a-method-that-reduces-gender-bias-in-ai-datasets/) - Based on UCLA research paper "Learning Gender Neutral Word Embeddings" Aug 2018.
- [Examining Gender and Race Bias in Two Hundred Sentiment Analysis Systems](http://aclweb.org/anthology/S18-2005). 2018
- [Man is to Computer Programmer as Woman is to Homemaker? Debiasing Word Embeddings](https://arxiv.org/abs/1607.06520).

### Scraping
- [Scraping HTML using Scrapy](https://blog.scrapinghub.com/2016/01/19/scrapy-tips-from-the-pros-part-1/) Tutorial on using the Python module Scrapy for easy data extraction from messy HTML websites.
- [Extract text from any document; no muss, no fuss.](https://datascopeanalytics.com/blog/extract-text-from-any-document-no-muss-no-fuss/) July 2014.
- [Using Scrapy to Build your Own Dataset](https://medium.com/towards-data-science/using-scrapy-to-build-your-own-dataset-64ea2d7d4673) Sep 2017.

### Cleaning
- [How to solve 90% of NLP problems: a step-by-step guide](https://blog.insightdatascience.com/how-to-solve-90-of-nlp-problems-a-step-by-step-guide-fda605278e4e) Jan 2018. A step by step guide on data cleaning and exploration for successful NLP model building.
- [Text Preprocessing in Python: Steps, Tools, and Examples](https://medium.com/@datamonsters/text-preprocessing-in-python-steps-tools-and-examples-bf025f872908). Oct 2018
- [How to Clean Text for Machine Learning with Python](https://machinelearningmastery.com/clean-text-machine-learning-python/) October 2017. Step-by-step guide of how to perform text data pre-processing. 
- [Feature Extraction, Basic Pre-processing, and Advanced Processing](https://www.analyticsvidhya.com/blog/2018/02/the-different-methods-deal-text-data-predictive-python/)

### Stop Words
- [Removing stop words with NLTK in Python](https://www.geeksforgeeks.org/removing-stop-words-nltk-python/)
- [TEXT CLASSIFICATION FOR SENTIMENT ANALYSIS – STOPWORDS AND COLLOCATIONS](https://streamhacker.com/2010/05/24/text-classification-sentiment-analysis-stopwords-collocations/)

### Stemming
- [Article: Text Stemming: Approaches, Applications, and Challenges](http://dl.acm.org/citation.cfm?id=2975608). Dec 2016.
- [What is the Difference Between Stemming and Lemmatization?](https://blog.bitext.com/what-is-the-difference-between-stemming-and-lemmatization/). Feb 2018. Differences and examples of using stemming and lemmatization in different languages.
- [Stemming and Lemmatization in Python](https://www.datacamp.com/community/tutorials/stemming-lemmatization-python). Oct 2018. Comparison of stemming and lemmatization with algorithms behind, results, pros and cons, context to use, and code syntax. 
- [Sentiment Symposium Tutorial: Stemming](http://sentiment.christopherpotts.net/stemming.html)

### Dimensionality Reduction
- [Taming Text with the SVD](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.395.4666&rep=rep1&type=pdf). SAS. Jan 2004.
- [Dimensionality Reduction for Bag-of-Words Models: PCA vs LSA](http://cs229.stanford.edu/proj2017/final-reports/5163902.pdf) 
- [An introduction to Bag of Words and how to code it in Python for NLP](https://medium.freecodecamp.org/an-introduction-to-bag-of-words-and-how-to-code-it-in-python-for-nlp-282e87a9da04) 
- [Bag of Words and Tf-idf Explained](http://datameetsmedia.com/bag-of-words-tf-idf-explained/) 

### Sarcasm Detection
- [Automatic Sarcasm Detection: A Survey](https://dl.acm.org/citation.cfm?id=3124420) ACM Computer Surveys, Sep 2017.
- [CASCADE: Contextual Sarcasm Detection in Online Discussion Forums](http://aclweb.org/anthology/C18-1156) 27th International Conference on Computational Linguistics, Aug 2018.
- [A Deeper Look into Sarcastic Tweets Using Deep Convolutional Neural Networks](https://pdfs.semanticscholar.org/402f/bb0d3eb259eeabae0522a747de14b7d7f8b5.pdf) International Journal of Advanced Research in Computer Engineering & Technology, Volume 6, Issue 1, Jan 2017.
- [Detecting Sarcasm with Deep Convolutional Neural Networks](https://medium.com/dair-ai/detecting-sarcasm-with-deep-convolutional-neural-networks-4a0657f79e80). Apr 30, 2018. Contextual learning using CNNs for effective detection of sarcasm.

### Document Classification
- [Naive Bayes and Text Classification](http://sebastianraschka.com/Articles/2014_naive_bayes_1.html), 2014. An in-depth overview of both the Naive Bayes algorithm and how it can be used in the document classification process.
- [Bag of Tricks for Efficient Text Classification](https://arxiv.org/abs/1607.01759), 2016. A paper from Facebook researchers that introduces fastText, a fast and effective document classification algorithm.
- [Text Classifier Algorithms in Machine Learning](https://blog.statsbot.co/text-classifier-algorithms-in-machine-learning-acc115293278), 2017. A blog article that shows how to apply several deep learning algorithms to document classification problems.
- [Classifying Documents in the Reuters-21578 R8 Dataset](https://rstudio-pubs-static.s3.amazonaws.com/202711_8f3ddd24fc9a4a6594d31f5da6344dcc.html), 2016. A nice tutorial in R that shows how to classify news articles using three different ML algorithms.
- [Tidy Text Mining Beer Reviews](http://kaylinwalker.com/tidy-text-beer), 2018. Uses the KNN algorithm to classify reviews of craft beer products into styles of beer (e.g., "pilsner", "IPA", or "Belgian").
- [Using fastText and Comet.ml to classify relationships in Knowledge Graphs](https://medium.com/comet-ml/using-fasttext-and-comet-ml-to-classify-relationships-in-knowledge-graphs-e73d27b40d67)
- [Multi-Class Text Classification with Scikit-Learn](https://www.kdnuggets.com/2018/08/multi-class-text-classification-scikit-learn.html), 2018. An article that shows how to deal with multi-class problems, such as classifying consumer complaints into one of 12 categories.
- [Machine Learning with Text in scikit-learn (PyCon 2016)](https://www.youtube.com/watch?v=ZiKMIuYidY0&list=PL5-da3qGB5ICeMbQuqbbCOQWcS6OYBr5A&index=10), 2016. A nice video tutorial that discusses how to use scikit-learn in the document classification process.
- [Ultimate guide to deal with Text Data (using Python) – for Data Scientists & Engineers](https://www.analyticsvidhya.com/blog/2018/02/the-different-methods-deal-text-data-predictive-python), 2018. The title says it all.
- [Text Classification in Python with scikit-learn and nltk](https://towardsdatascience.com/machine-learning-nlp-text-classification-using-scikit-learn-python-and-nltk-c52b92a7c73a), 2017. Another tutorial showing how to perform text classification using scikit-learn.
- [Introducing state of the art text classification with universal language models](http://nlp.fast.ai/classification/2019/09/10/multifit.html), 2019. Introduces a groundbreaking transfer learning method for document classification.
- [Learning Document Embeddings by Predicting N-grams for Sentiment Classification of Long Movie Reviews](https://github.com/libofang/DV-ngram) - paper with code on Github
- [Towards Explainable NLP: A Generative Explanation Framework for Text Classification](https://arxiv.org/pdf/1811.00196.pdf), 2019. A paper that describes a new approach for explaining the inner workings of text classification models.

### Entity and Information Extraction
- [Entity Extraction and Network Analysis](http://brandonrose.org/ner2sna). Python, `StanfordCoreNLP`
- [Natural Language Processing for Information Extraction](https://arxiv.org/abs/1807.02383)
- [NLP Techniques for Extracting Information](https://www.searchtechnologies.com/blog/natural-language-processing-techniques). In-depth exploration of the seven steps framework of NLP data mining tools and techniques.

### Document Clustering and Document Similarity
- [Text Clustering: Get quick insights from Unstructured Data](http://www.kdnuggets.com/2017/06/text-clustering-unstructured-data.html). July 2017.
- [Document Clustering](http://cse.iitkgp.ac.in/~abhij/facad/03UG/Report/03CS3024_Pankaj_Jajoo.pdf). MSc Thesis.
- [Document Clustering: A Detailed Review](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.401.8494&rep=rep1&type=pdf). Shah and Mahajan. IJAIS 2012.
- [Document Clustering with Python](https://github.com/harrywang/document_clustering) A GitHub repository that clusters IMDB movie descriptions. Based on [this original tutorial](http://brandonrose.org/clustering), whose GitHub repo is [here](https://github.com/brandomr/document_cluster). 
- [Text mining and sentiment analysis on video game user reviews using SAS® Enterprise Miner](http://analytics.ncsu.edu/sesug/2016/EPO-280_Final_PDF.pdf)
- [Who wrote the anti-Trump New York Times op-ed? Using tidytext to find document similarity](http://varianceexplained.org/r/op-ed-text-analysis/)

### Concept Analysis/Topic Modeling <a id="concept-analysis"></a>
- [Topic models: Past, present, and future](https://www.oreilly.com/ideas/topic-models-past-present-and-future)
- [Word vectors using LSA, Part - 2](http://www.vikasing.com/2015/05/word-vectors-using-lsa-part-2.html)
- [Probabilistic Topic Models](http://www.cs.columbia.edu/~blei/papers/Blei2012.pdf)
- [LEGO color themes as topic models](http://nateaff.com/2017/09/11/lego-topic-models/?utm_campaign=Data%2BElixir&utm_medium=email&utm_source=Data_Elixir_150) Sep 2017.
- [How our startup switched from Unsupervised LDA to Semi-Supervised GuidedLDA](https://medium.freecodecamp.org/how-we-changed-unsupervised-lda-to-semi-supervised-guidedlda-e36a95f3a164)
- [Topic Modeling with LSA, PLSA, LDA & lda2Vec](https://www.kdnuggets.com/2018/08/topic-modeling-lsa-plsa-lda-lda2vec.html) Aug 2018.
- [text2vec's Description of Topic Models](http://text2vec.org/topic_modeling.html)
- [Topic Modelling Portal](http://topicmodels.west.uni-koblenz.de/)
- [Applications of Topic Models](https://mimno.infosci.cornell.edu/papers/2017_fntir_tm_applications.pdf) 2017.
- [MACS 30500: Text analysis: topic modeling](https://cfss.uchicago.edu/text_topicmodels.html)
- [COTA, Uber’s topic modelling approach to improving customer support](https://eng.uber.com/cota/)
- [Using LDA Topic Models as a Classification Model Input](https://towardsdatascience.com/unsupervised-nlp-topic-models-as-a-supervised-learning-input-cf8ee9e5cf28)
- [NLP: Extracting the main topics from your dataset using LDA in minutes](https://towardsdatascience.com/nlp-extracting-the-main-topics-from-your-dataset-using-lda-in-minutes-21486f5aa925)
- [Topic Modelling The Legal Subject Matter And Judicial Activity Of The High Court Of Australia, 1903–2015](https://osf.io/qhezc/download/?format=pdf)

### Sentiment Analysis

#### Methods
- [CACM: Techniques and Applications for Sentiment Analysis](http://cacm.acm.org/magazines/2013/4/162501-techniques-and-applications-for-sentiment-analysis/abstract), 2013. A nice overview of sentiment analysis from the Communications of the ACM journal.
- [Unsupervised Sentiment Analysis with Signed Social Networks](https://aaai.org/ocs/index.php/AAAI/AAAI17/paper/view/14656/14129), 2017. A conference paper that describes that challenges of applying sentiment analysis to social networks, and presents an new unsupervised method.
- [Lexicon-Based Methods for Sentiment Analysis](https://www.aclweb.org/anthology/J/J11/J11-2001.pdf), 2010. Uses SO-CAL (Semantic Orientation CALculator), a measure of subjectivity and opinion for sentimental analysis.
- [That Sentimental Feeling](http://www.matthewjockers.net/2015/12/20/that-sentimental-feeling/), 2015. Compares the result of R's Syezhet package with human labels on a series of novels. [A 2016 update](http://www.matthewjockers.net/2016/08/11/more-syuzhet-validation/).
- [Unsupervised Sentiment Neuron](https://blog.openai.com/unsupervised-sentiment-neuron/), 2017. OpenAI's team developed a new way of using deep NNs to perform sentiment analysis, on much less data than usual.
- [Current State of Text Sentiment Analysis from Opinion to Emotion Mining](http://dl.acm.org/citation.cfm?id=3057270), 2017. A journal article that surveys the current state of sentiment analysis research and tools.
- [Sentiment Analysis Tools Overview, Part 1. Positive and Negative Words Databases](https://medium.com/@datamonsters/sentiment-analysis-tools-overview-part-1-positive-and-negative-words-databases-ae35431a470c), 2017. A blog article that outlines some lexicon databases.
- [Sentiment analysis, Concept analysis and Applications](https://towardsdatascience.com/sentiment-analysis-concept-analysis-and-applications-6c94d6f58c17), 2018. An overview of sentiment analysis, with an analysis of tweets about Uber.
- [Breakthrough Research Papers and Models for Sentiment Analysis](https://blog.paralleldots.com/data-science/breakthrough-research-papers-and-models-for-sentiment-analysis/), 2018. A blog that compares the performance of simple to advanced methods for sentiment analysis.
- [Twitter sentiment analysis using combined LSTM-CNN models](http://konukoii.com/blog/2018/02/19/twitter-sentiment-analysis-using-combined-lstm-cnn-models/), 2018. A blog article that describes a new method for sentiment analysis that uses deep learning.
- [VADER: A Parsimonious Rule-based Model for Sentiment Analysis of Social Media Text](http://comp.social.gatech.edu/papers/icwsm14.vader.hutto.pdf), 2014. A conference paper that presents VADER, a simple rule-based model of sentiment analysis.
- [A comparison of Lexicon-based approaches for Sentiment Analysis of microblog posts](http://ceur-ws.org/Vol-1314/paper-06.pdf), 2014. A conference paper that presents a new lexicon-based approach for sentiment analysis of Twitter posts, based on lexical resources such as SentiWordNet. 

#### Challenges
- [On the negativity of negation](http://web.stanford.edu/~cgpotts/papers/potts-salt20-negation.pdf), 2011. A conference paper that discusses the challenges of dealing with negativity in text, with a case study on IMDB movie reviews.
- [Challenges in Sentiment Analysis](http://saifmohammad.com/WebDocs/sentiment-challenges.pdf), 2015. A practical guide from the National Reseach Council of Canada that describes some of the main challenges of sentiment analysis.
- [A survey on sentiment analysis challenges](https://www.sciencedirect.com/science/article/pii/S1018363916300071), 2016. A journal article that discusses and compares sentiment analysis challenges among forty-seven papers. 

#### Politics
- [Sentiment analysis on Trump's tweets using Python](https://dev.to/rodolfoferro/sentiment-analysis-on-trumpss-tweets-using-python-?utm_campaign=Data%2BElixir&utm_medium=email&utm_source=Data_Elixir_149), 2017. Sentiment analysis on Trump's tweets using tweepy and textblob for NLP processing. 
- [Donald Trump vs Hillary Clinton: sentiment analysis on Twitter mentions](https://blog.monkeylearn.com/donald-trump-vs-hillary-clinton-sentiment-analysis-twitter-mentions/), 2016. Compares the sentiment of Trump's tweets vs. Hillary's tweets leading up to the 2016 US presidential election.
- [Does sentiment analysis work? A tidy analysis of Yelp reviews](http://varianceexplained.org/r/yelp-sentiment/), 2016. Combined prediction results and individual words in reviews to show that sentiment analysis worked well on Yelp reviews.
- [From tweets to polls: Linking text sentiment to public opinion time series](https://www.aaai.org/ocs/index.php/ICWSM/ICWSM10/paper/viewFile/1536/1842), 2010. A conference paper that describes how sentiment analysis on Twitter is connected to public opinion polls.


#### Stock Market
- [Twitter mood predicts the stock market](https://arxiv.org/abs/1010.3003), 2010. A journal article that measures the "mood" of daily Twitter feedsa and shows that the moods can predict the DJIA.
- [A nonlinear impact: evidences of causal effects of social
media on market prices](https://arxiv.org/pdf/1601.04535v2.pdf), 2016. A journal article that shows that social media's relationship with the DJIA is nonlinear.
- [Forbes: How Quant Traders Use Sentiment To Get An Edge On The Market](http://www.forbes.com/sites/kumesharoomoogan/2015/08/06/how-quant-traders-use-sentiment-to-get-an-edge-on-the-market/#6266d9ec2fd8), 2015. An article that shows how quant traders can use sentiment analysis.
- [Sentdex: Quantifying the Qualitative](http://sentdex.com/financial-analysis/). An online tool that measures the overall sentiment of different stocks.
- [Trump2Cash: A stock trading bot powered by Trump tweets](https://github.com/maxbbraun/trump2cash). A bot that watches Donald Trump's Twitter account and waits for him to mention any publicly-traded companies. A [related blog article](https://medium.com/@maxbraun/this-machine-turns-trump-tweets-into-planned-parenthood-donations-4ece8301e722#.3232hx7gx) describes a bot that turns Trump's tweets into Planned Parenthood donations.


#### Applications
- [Lost at Sea: How Social Media is Helping Cruise Lines Attract Millennials](https://www.crimsonhexagon.com/blog/cruises-hunting-millennials), 2016. A whitepaper describing how cruise lines can attract a different audience. 
- [Harry Plotter: Celebrating the 20 year anniversary with tidytext and the tidyverse in R](https://paulvanderlaken.com/2017/08/03/harry-plotter-celebrating-the-20-year-anniversary-with-tidytext-the-tidyverse-and-r/), 2015. A technical article showing how to apply sentiment analysis to the text of the Harry Potter series.
- [Data Science 101: Sentiment Analysis in R Tutorial](http://blog.kaggle.com/2017/10/05/data-science-101-sentiment-analysis-in-r-tutorial/), 2017. A technical article describing how to use the Tidytext package in R to analyze US presidential speeches.
- [Cannes Lions 2017: Hungerithm, Mars Chocolate Australia (Clemenger BBDO, Melbourne)](https://vimeo.com/223731129), 2017. A video that shows how Snickers developed a tool to change the price of Snickers bar based on the mood of the internet. 
- [Sentiment analysis: 10 applications and 4 services](https://towardsdatascience.com/machine-learning-as-a-service-487e930265b2), 2018. A brief but concise introduction to sentiment analysis, it's business implications and four sentiment analysis cloud service providers including Google, Amazon and Microsoft.
- [What Your Boss Could Learn by Reading the Whole Company’s Emails](https://www.theatlantic.com/magazine/archive/2018/09/the-secrets-in-your-inbox/565745/), 2018. "The lesson: Figure out the truth about how the workforce is feeling not by eavesdropping on the substance of what employees say, but by examining how they are saying it.” This article is centered around the topic of applying sentiment analysis to large internal unstructured text datasets (e.g. employee e-mails). Text analytics and NLP have become an increasingly popular approach to help search for clues that may indicate the level of employee engagement in the workplace, and any potential ‘red-flags’ that should receive particular attention by an organization and its ethical implications.
- [Aspect Based Sentiment Analysis of Amazon Product Reviews](https://www.researchgate.net/publication/325843745_ASPECT_BASED_SENTIMENT_ANALYSIS_OF_AMAZON_PRODUCT_REVIEWS), 2018. An article showing how to apply sentiment analysis on different aspects of a product review on Amazon. 
- [Sentiment Analysis of 2.2 million tweets from Super Bowl 51](http://blog.aylien.com/sentiment-analysis-of-2-2-million-tweets-from-super-bowl-51/), 2017. An article showing how to apply sentiment analysis to tweets about the Super Bowl.
- [Emotion and Sentiment Analysis: A Practitioner’s Guide to NLP](https://www.kdnuggets.com/2018/08/emotion-sentiment-analysis-practitioners-guide-nlp-5.html), 2018. An overview of sentiment analysis, applied to news articles.

#### Tools and Technology

- [Streaming Analytics Tutorial on Azure](https://docs.microsoft.com/en-ca/azure/azure-databricks/databricks-sentiment-analysis-cognitive-services?toc=%2Fen-ca%2Fazure%2Fcognitive-services%2Ftext-analytics%2Ftoc.json&bc=%2Fen-ca%2Fazure%2Fbread%2Ftoc.json).
- [How to Analyze sentiment in Azure](https://docs.microsoft.com/en-ca/azure/cognitive-services/text-analytics/how-tos/text-analytics-how-to-sentiment-analysis).
- [how-to-perform-sentiment-analysis-using-python-tutorial/](https://hub.packtpub.com/how-to-perform-sentiment-analysis-using-python-tutorial/).
- [Twitter Sentiment Analysis Overview](https://www.youtube.com/watch?v=o_OZdbCzHUA&t=235s), 2016. Overview of sentiment analysis, and a step-by-step walkthrough on how to perform sentiment analysis using TextBlob.
- [ELMO embeddings in Keras using Tensorflow Hub](https://towardsdatascience.com/elmo-embeddings-in-keras-with-tensorflow-hub-7eb6f0145440), 2018. A guide to use Google's ELMO in your Keras model using Tensorflow hub.
- [Twitter Sentiment Analysis in Python using TextBlob](https://medium.freecodecamp.org/how-to-build-a-twitter-sentiments-analyzer-in-python-using-textblob-948e1e8aae14), 2018.


### Text Summarization
- [Text Summarization with Gensim](https://rare-technologies.com/text-summarization-with-gensim/)
- [Unsupervised Text Summarization using Sentence Embeddings](https://medium.com/jatana/unsupervised-text-summarization-using-sentence-embeddings-adb15ce83db1)
- [Improving Abstraction in Text Summarization](http://aclweb.org/anthology/D18-1207) Proposing two techniques for improvement
- [Text Summarization and Categorization for Scientific and Health-Related Data](https://repository.library.georgetown.edu/bitstream/handle/10822/1050759/Cohan_georgetown_0076D_13889.pdf?sequence=1) 
-[Text summarization with TensorFlow](https://ai.googleblog.com/2016/08/text-summarization-with-tensorflow.html). 2016. A basic study on text summarization.

### Machine Translation
- [Blog Post: Found in translation: More accurate, fluent sentences in Google Translate](https://blog.google/products/translate/found-translation-more-accurate-fluent-sentences-google-translate/) Nov 2016
- [NYTimes: The Great A.I. Awakening](https://www.nytimes.com/2016/12/14/magazine/the-great-ai-awakening.html?_r=0) Dec 2016. How Google used artificial intelligence to transform Google Translate, one of its more popular services — and how machine learning is poised to reinvent computing itself.
- [Machine Learning Translation and the Google Translate Algorithm](http://www.kdnuggets.com/2017/09/machine-learning-translation-google-translate-algorithm.html)
- [Neural Machine Translation (seq2seq) Tutorial](https://github.com/tensorflow/nmt)
- [Paper Dissected: “Attention is All You Need” Explained](http://mlexplained.com/2017/12/29/attention-is-all-you-need-explained/) Explanation of an important paper that first introduced 'Attention mechanism' in 2017.
- [The Annotated Transformer](http://nlp.seas.harvard.edu/2018/04/03/attention.html) A line-by-line implementation of "Attention Is All You Need".
- [BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding](https://arxiv.org/abs/1810.04805) A new language representation model published in 2018. [Implementation code](https://github.com/google-research/bert). [Pytorch port.]( https://github.com/codertimo/BERT-pytorch)
- [Phrase-Based & Neural Unsupervised Machine Translation](https://arxiv.org/abs/1804.07755) Proposed two model variants: neural and phrase-based model. Awarded as the Best Paper Award at EMNLP 2018. [Implementation code](https://github.com/facebookresearch/UnsupervisedMT). 

### Q&A Systems, Chatbots <a id="qa-systems"></a>
- [Meet Lucy: Creating a Chatbot Prototype](http://www.kdnuggets.com/2017/09/meet-lucy-chatbot-prototype.html)
- [Microsoft Bot Framework](https://dev.botframework.com/).
- [Training Millions of Personalized Dialogue Agents](https://arxiv.org/abs/1809.01984)
- [Ultimate Guide to Leveraging NLP & Machine Learning for your Chatbot](https://chatbotslife.com/ultimate-guide-to-leveraging-nlp-machine-learning-for-you-chatbot-531ff2dd870c). 2016.
- [Building a Simple Chatbot from Scratch in Python (using NLTK)](https://medium.com/analytics-vidhya/building-a-simple-chatbot-in-python-using-nltk-7c8c8215ac6e). Sep 2018
- [A Survey on Dialogue Systems: Recent Advances and New Frontiers](https://arxiv.org/pdf/1711.01731.pdf) Jan 2018.
- [Examining the Impact of an Automated Translation Chatbot on Online Collaborative Dialog for Incidental L2 Learning](https://www.researchgate.net/publication/329525159_Examining_the_impact_of_an_automated_translation_chatbot_on_online_collaborative_dialog_for_incidental_L2_learning)
- [Create a banking chatbot with FAQ discovery, anger detection and natural language understanding](https://github.com/IBM/watson-banking-chatbot)
- [Generative Model Chatbots- May 2017](https://medium.com/botsupply/generative-model-chatbots-e422ab08461e)
- [A Guide to Building a Multi-Featured Slackbot with Python- March 2017](https://hackernoon.com/a-guide-to-building-a-multi-featured-slackbot-with-python-73ea5394acc)
- [Building a Simple Chatbot from Scratch in Python (Using NLTK)- September 2018](https://medium.com/analytics-vidhya/building-a-simple-chatbot-in-python-using-nltk-7c8c8215ac6e)
- [The Road to a Conversational Banking Future-February 2019](https://chatbotslife.com/the-road-to-a-conversational-banking-future-1872f870a653)
- [Chatbots - Designing intents and entities for NLP Models](https://medium.com/@brijrajsingh/chat-bots-designing-intents-and-entities-for-your-nlp-models-35c385b7730d) Jan 2017
- [Task-oriented Dialogue System for Automatic Diagnosis](http://www.sdspeople.fudan.edu.cn/zywei/paper/liu-acl2018.pdf). 2018. Talks about the use of MDP trained dataset and its medical diagnostic applications.
- [Li Deng at AI Frontiers: Three Generations of Spoken Dialogue Systems (Bots)](https://www.slideshare.net/AIFrontiers/li-deng-three-generations-of-spoken-dialogue-systems-bots). 2017. Slides by Microsoft Chief Scientist for AI.
- [NLP — Building a Question Answering model](https://towardsdatascience.com/nlp-building-a-question-answering-model-ed0529a68c54). March 2018

### Fuzzy Matching, Probabilistic Matching, Record Linkage, Etc. <a id="fuzzy-matching"></a>
- [agrep method in R](http://stat.ethz.ch/R-manual/R-devel/library/base/html/agrep.html). Approximate String Matching (Fuzzy Matching)
- [fuzzywuzzy package in R](https://cran.r-project.org/web/packages/fuzzywuzzyR/index.html). [Example usage](http://mlampros.github.io/2017/04/13/fuzzywuzzyR_package).
- [Fuzzy String Matching – a survival skill to tackle unstructured information](https://journal.r-project.org/archive/2010-2/RJournal_2010-2_Sariyar+Borg.pdf)
- [The RecordLinkage Package: Detecting
Errors in Data](https://journal.r-project.org/archive/2010-2/RJournal_2010-2_Sariyar+Borg.pdf)
- [R package fastLink: Fast Probabilistic Record Linkage](https://github.com/kosukeimai/fastLink)
- [Fuzzy merge in R](https://www.princeton.edu/~otorres/FuzzyMergeR101.pdf) An R function to merge files by defining a Key File
- [Learning Text Similarity with Siamese Recurrent Networks](http://www.aclweb.org/anthology/W/W16/W16-1617.pdf)
- [Dedupe](https://github.com/dedupeio/dedupe): A Python library for accurate and scalable fuzzy matching, record deduplication and entity-resolution.
- [recordlinkage](https://github.com/J535D165/recordlinkage): A toolkit for record linkage and deduplication written in Python.

### Word and Document Embeddings
- [The Current Best of Universal Word Embeddings and Sentence Embeddings](https://medium.com/huggingface/universal-word-sentence-embeddings-ce48ddc8fc3a)
- [An Intuitive Understanding of Word Embeddings: From Count Vectors to Word2Vec](https://www.analyticsvidhya.com/blog/2017/06/word-embeddings-count-word2veec)
- [An Empirical Evaluation of doc2vec with Practical Insights into Document Embedding Generation](https://arxiv.org/pdf/1607.05368.pdf) 2016. From IBM.
- [Document Embedding with Paragraph Vectors](https://storage.googleapis.com/pub-tools-public-publication-data/pdf/44894.pdf) 2015. From Google.
- [GloVe Word Embeddings Demo](https://github.com/fastai/word-embeddings-workshop/blob/master/Word%20Embeddings.ipynb) 2017. From fasti.
- [Text Classification With Word2Vec](http://nadbordrozd.github.io/blog/2016/05/20/text-classification-with-word2vec/) 2016.
- [Document Embedding](http://sybrandt.com/post/document-embedding/) 2017
- [From Word Embeddings To Document Distances](http://proceedings.mlr.press/v37/kusnerb15.pdf) 2015.
- [Word Embeddings, Bias in ML, Why You Don't Like Math, & Why AI Needs You](https://www.youtube.com/watch?v=25nC0n9ERq4) 2017. Rachel Thomas (fastai)
- [Word Vectors in Natural Language Processing: Global Vectors (GloVe)](https://www.kdnuggets.com/2018/08/word-vectors-nlp-glove.html). Aug 2018.
- [Doc2Vec Tutorial on the Lee Dataset](https://github.com/RaRe-Technologies/gensim/blob/develop/docs/notebooks/doc2vec-lee.ipynb)
- [Word Embeddings in Python with SpaCy and Gensim](https://www.shanelynn.ie/word-embeddings-in-python-with-spaCy-and-gensim/)
- [Deep Contextualized Word Represenations](https://arxiv.org/abs/1802.05365). ElMo. [PyTorch implementation](https://github.com/allenai/allennlp/blob/master/tutorials/how_to/elmo.md). [TF Implementation](https://github.com/allenai/bilm-tf)
- [Universal Language Model Fine-tuning for Text Classification](https://arxiv.org/abs/1801.06146). [Implementation code](http://nlp.fast.ai/category/classification.html). 
- [Supervised Learning of Universal Sentence Representations from Natural Language Inference Data](https://arxiv.org/abs/1705.02364).
- [Learned in Translation: Contextualized Word Vectors](https://arxiv.org/abs/1708.00107). CoVe.
- [Distributed Representations of Sentences and Documents](http://cs.stanford.edu/~quocle/paragraph_vector.pdf). Paragraph vectors. See [doc2vec tutorial at gensim](http://rare-technologies.com/doc2vec-tutorial/)
- [sense2vec](http://arxiv.org/abs/1511.06388). Word sense disambiguation.
- [Skip Thought Vectors](http://arxiv.org/abs/1506.06726). Word representation method.
- [Sequence to Sequence Learning with Neural Networks](http://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf)
- [The Amazing Power of Word Vectors](https://blog.acolyer.org/2016/04/21/the-amazing-power-of-word-vectors/). 2016.
- [Contextual String Embeddings for Sequence Labeling](http://alanakbik.github.io/papers/coling2018.pdf). 2018.
- [A Hierarchical Multi-task Approach for Learning Embeddings from Semantic Tasks](https://arxiv.org/abs/1811.06031) Introducing a multi-task learning approach for a set of interrelated NLP tasks. Presented at AAAI conference in January 2019.[Implementation code](https://github.com/huggingface/hmtl).  
- [ELMo Word embeddings](allennlp.org/elmo)
- [An Idiot’s Guide to Word2vec Natural Language Processing](https://medium.com/@ODSC/an-idiots-guide-to-word2vec-natural-language-processing-5c3767cf8295)
- [Get Busy with Word Embeddings- An Introduction (February 2018)](https://www.shanelynn.ie/get-busy-with-word-embeddings-introduction/)
- [NLP's ImageNet moment has arrived](http://ruder.io/nlp-imagenet/). July 2018. Overview of pre-trained NLP language models, drawing parallels to ImageNet's contributions to computer vision. 
- [Word2vec: fish + music = bass](https://graceavery.com/word2vec-fish-music-bass)
- [Universal Sentence Encoder Visually Explained](https://amitness.com/2020/06/universal-sentence-encoder/). June 2020.

### Transformers and Language Models

- [Understanding Large Language Models](https://sebastianraschka.com/blog/2023/llm-reading-list.html). Sebastian Raschka. Feb 2023.
- [A Primer in BERTology: What we know about how BERT works](https://arxiv.org/pdf/2002.12327.pdf). Nov 2020.
- [A review of BERT based models](https://towardsdatascience.com/a-review-of-bert-based-models-4ffdc0f15d58). July 2019.
- [BERT Explained - State of the art language model for NLP](https://towardsdatascience.com/bert-explained-state-of-the-art-language-model-for-nlp-f8b21a9b6270). A great explaination of the fundamentals of how BERT works.
- [The Illustrated BERT, ELMo, and co. (How NLP Cracked Transfer Learning)](https://jalammar.github.io/illustrated-bert/). Dec 2018.
- [Machines Beat Humans on a Reading Test. But Do They Understand?](https://www.quantamagazine.org/machines-beat-humans-on-a-reading-test-but-do-they-understand-20191017)
- [WHAT EVERY NLP ENGINEER NEEDS TO KNOW ABOUT PRE-TRAINED LANGUAGE MODELS](https://www.topbots.com/ai-nlp-research-pretrained-language-models). 2019.
- [the transformer … “explained”?](https://nostalgebraist.tumblr.com/post/185326092369/the-transformer-explained)
- [The Illustrated Transformer](https://jalammar.github.io/illustrated-transformer/)
- [Hugging Face's course on Transformer Models](https://huggingface.co/course/chapter1/1)
- [OpenAI: Better Language Models and Their Implications](https://blog.openai.com/better-language-models/): Pre-trained Transformer-based unsupervised language model that achieves state-of-the-art on many language benchmarks with focus on text generation. Controversial limited release. February 14, 2019.

#### ChatGPT

- [ChatGPT launch blog](https://openai.com/blog/chatgpt/)
- [Awesome ChatGPT Prompts](https://github.com/f/awesome-chatgpt-prompts)

##### ...in Education
- [ChatGPT User Experience: Implications for Education](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4312418). Xiaoming Zhai (Unviversity of Georgia). December 2022.
- [New Modes of Learning Enabled by AI Chatbots: Three Methods and Assignments](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4300783) Mollick and Mollick (University of Pennsylvania). December 2022.
- [Educators Battle Plagiarism As 89% Of Students Admit To Using OpenAI’s ChatGPT For Homework](https://www.forbes.com/sites/chriswestfall/2023/01/28/educators-battle-plagiarism-as-89-of-students-admit-to-using-open-ais-chatgpt-for-homework/?sh=1924574750de). Forbes, January 2023
- [ChatGPT: Educational friend or foe?](https://www.brookings.edu/blog/education-plus-development/2023/01/09/chatgpt-educational-friend-or-foe/). Hirsh-Pasek and Blinkoff (Temple University). January 2023. 
- [Don’t Ban ChatGPT in Schools. Teach With It.](https://www.nytimes.com/2023/01/12/technology/chatgpt-schools-teachers.html). New York Times (January 2023). 
- [ChatGPT and the Future of Business Education](https://knowledge.insead.edu/leadership-organisations/chatgpt-and-future-business-education). Feb 2023.
- [Udemy course (January 2023). ChatGPT for Teachers in Education.](https://www.udemy.com/course/chatgpt-in-education/)

### Deep Learning
- [Keras LSTM tutorial – How to easily build a powerful deep learning language model](http://adventuresinmachinelearning.com/keras-lstm-tutorial/). 
  - First half of the article describes RNNs, the anatomy of an LSTM cell, LSTM networks. Second half is a walkthrough of features in Keras for LSTM implementation using generators for data input. 
- [Deep Learning for Natural Language Processing: Tutorials with Jupyter Notebooks](https://insights.untapt.com/deep-learning-for-natural-language-processing-tutorials-with-jupyter-notebooks-ad67f336ce3f). 
  - A short article containing links and descriptions to further video tutorials for DL approaches to NLP problems. Five lessons total including preprocessing, word representations, and LSTM, among other topics.
- [A Survey of the Usages of Deep Learning in Natural Language Processing](https://arxiv.org/abs/1807.10854). 
  - A 35-page academic literature review of DL in NLP (University of Colorado, July 2018). Detailed description of neural network architectures followed by a comprehensive set of applications.
- [Sequence Classification with Human Attention](http://aclweb.org/anthology/K18-1030): Using human attention derived from eye-tracking corpora to regularize attention in recurrent neural networks (RNN). [Implementation code](https://github.com/coastalcph/Sequence_classification_with_human_attention).
- [Tutorial on Text Classification (NLP) using ULMFiT and fastai Library in Python](https://www.analyticsvidhya.com/blog/2018/11/tutorial-text-classification-ulmfit-fastai-library/)
- [Multi-Task Deep Neural Networks for Natural Language Understanding](https://www.topbots.com/ai-nlp-research-pretrained-language-models). Academic article detailing Microsoft's MTDNN algorithm which has outperformed BERT, ELMo & BiLSTM as of February 2019 in the GLUE Benchmark.
- [Natural Language Processing Tutorial for Deep Learning Researchers](https://github.com/graykode/nlp-tutorial): A 2019 NLP tutorial repository using TensorFlow and Pytorch.
- [Deep Learning for Sentiment Analysis : A Survey](https://arxiv.org/abs/1801.07883)
- [NEURAL READING COMPREHENSION AND BEYOND](https://cs.stanford.edu/~danqi/papers/thesis.pdf) December 2018 Stanford - Reading comprehension models built on top of deep neural networks.
- [Microsoft: Multi-Task Deep Neural Network (MT-DNN)](https://arxiv.org/pdf/1901.11504): Microsoft's improvement on Google's BERT with focus on natural language understanding. Code to be released. January 31, 2019. 
- [A STRUCTURED SELF-ATTENTIVE SENTENCE EMBEDDING](https://arxiv.org/pdf/1703.03130.pdf)


##### Capsule Networks
- [Investigating Capsule Networks with Dynamic Routing for Text Classification](https://arxiv.org/pdf/1804.00538.pdf). 2018.
- [Attention-Based Capsule Networks with Dynamic Routing for Relation Extraction](http://aclweb.org/anthology/D18-1120). 2018. 
- [TWITTER SENTIMENT ANALYSIS USING CAPSULE NETS AND GRU](https://wwjournals.com/index.php/ijsr/article/view/13386). 2018. 
- [Identifying Aggression and Toxicity in Comments using Capsule Network](http://aclweb.org/anthology/W18-4412). 2018. It is early days for Capsule Networks, which was introduced by Geoffrey Hinton, et al., in 2017 as an attempt to introduce an NN architecture superior to the classical CNNs. The idea aims to capture hierarchincal relationships in the input layer through dynamic routing between "capsules" of neurons. Due likely to the affinitity of the theme of addressing hierarchical complexities, the idea's extention to the NLP field has since been a sujbect of active research, such as in the papers listed above.
- [Dynamic Routing Between Capsules](https://arxiv.org/pdf/1710.09829.pdf). 2017. 
- [MATRIX CAPSULES WITH EM ROUTING](https://openreview.net/pdf?id=HJWLfGWRb). 2018.

### Knowledge Graphs
- [Using fastText and Comet.ml to classify relationships in Knowledge Graphs](https://medium.com/comet-ml/using-fasttext-and-comet-ml-to-classify-relationships-in-knowledge-graphs-e73d27b40d67)
- [WTF is a knowledge graph?](https://hackernoon.com/wtf-is-a-knowledge-graph-a16603a1a25f)
- [A survey of graphs in natural language processing](https://web.eecs.umich.edu/~mihalcea/papers/nastase.jnle15.pdf). Nastase et al, 2015. 

## Major NLP Conferences

- [NeurIPS](https://nips.cc/)
- [Association for Computational Linguistics (ACL)](https://www.aclweb.org/portal/)
- [Empirical Methods in Natural Language Processing (EMNLP)](https://2022.emnlp.org/)
- [North American Chapter of the Association for Computational Linguistics (NAACL)](https://2022.naacl.org/)
- [European Chapter of the Association for Computational Linguistics (EACL)](https://2023.eacl.org/)
- [International Conference on Computational Linguistics(COLING)](https://coling2022.org/)


## Benchmarks

- [SQuAD leaderboard](https://rajpurkar.github.io/SQuAD-explorer/). A list of the strongest-performing NLP models on the Stanford Question Answering Dataset (SQuAD).
  - [SQuAD 1.0 paper](https://arxiv.org/pdf/1606.05250.pdf) (Last updated October 2016). SQuAD v1.1 includes over 100,000 question and answer pairs based on Wikipedia articles.
  - [SQuAD 2.0 paper](https://arxiv.org/pdf/1806.03822.pdf) (October 2018). The second generation of SQuAD includes unanswerable questions that the NLP model must identify as being unanswerable from the training data.
- [GLUE leaderboard](https://gluebenchmark.com/leaderboard). 
  - [GLUE paper](https://arxiv.org/pdf/1804.07461.pdf) (September 2018). A collection of nine NLP tasks including single-sentence tasks (e.g. check if grammar is correct, sentiment analysis), similarity and paraphrase tasks (e.g. determine if two questions are equivalent), and inference tasks (e.g. determine whether a premise contradicts a hypothesis). 


## Online courses

#### Udemy
- [Udemy: Deep Learning and NLP A-Z™: How to create a ChatBot](https://www.udemy.com/chatbot/)
- [Udemy: Natural Language Processing with Deep Learning in Python](https://www.udemy.com/natural-language-processing-with-deep-learning-in-python/)
- [Udemy: NLP - Natural Language Processing with Python](https://www.udemy.com/nlp-natural-language-processing-with-python/)
- [Udemy: Deep Learning: Advanced NLP and RNNs](https://www.udemy.com/deep-learning-advanced-nlp/)
- [Udemy: Natural Language Processing and Text Mining Without Coding](https://www.udemy.com/master-natural-language-processing-nlp-text-mining-without-coding/)

#### Stanford
- [Stanford CS 224N / Ling 284](http://web.stanford.edu/class/cs224n/)
  - Website: http://cs224d.stanford.edu/
  - Reddit: https://www.reddit.com/r/CS224d/comments/4n04ew/follow_along_with_cs224d_2015_or_2016/
- [Lecture Collection | Natural Language Processing with Deep Learning (Winter 2017)](https://www.youtube.com/playlist?list=PL3FW7Lu3i5Jsnh1rnUwq_TcylNr7EkRe6)

#### Coursera
- [Courses for "natural language processing" on Coursera](https://www.coursera.org/courses?query=natural%20language%20processing&)
- [Coursera: Applied Text Mining in Python](https://www.coursera.org/learn/python-text-mining)
- [Coursera: Nartual Language Processing](https://www.coursera.org/learn/language-processing)
- [Coursera: Sequence Models for Time Series and Natural Language Processing](https://www.coursera.org/learn/sequence-models-tensorflow-gcp)
- [Coursera: Coursera: Clinical Natural Language Processing](https://www.coursera.org/learn/clinical-natural-language-processing)

#### DataCamp
- [DataCamp: Natural Language Processing Fundamentals in Python](https://www.datacamp.com/courses/natural-language-processing-fundamentals-in-python)
- [DataCamp: Sentiment Analysis in R: The Tidy Way](https://www.datacamp.com/courses/sentiment-analysis-in-r-the-tidy-way)
- [DataCamp: Text Mining: Bag of Words](https://www.datacamp.com/courses/intro-to-text-mining-bag-of-words)
- [DataCamp: Building Chatbots in Python](https://www.datacamp.com/courses/building-chatbots-in-python)
- [DataCamp: Advanced NLP with spaCy](https://www.datacamp.com/courses/advanced-nlp-with-spacy)

#### Others
- [Deep Learning Drizzle](https://github.com/kmario23/deep-learning-drizzle) : Drench yourself in Deep Learning, Reinforcement Learning, Machine Learning, Computer Vision, and NLP from this curated list of exciting lectures!
- [Natural Language Processing | Dan Jurafsky, Christopher Manning](https://www.youtube.com/playlist?list=PLQiyVNMpDLKnZYBTUOlSI9mi9wAErFtFm)
- [Deep Learning for NLP](https://github.com/oxford-cs-deepnlp-2017/lectures). DeepMind and University of Oxford Department of Computer Science.
- [CMU CS 11-747: Neural Network for NLP](http://phontron.com/class/nn4nlp2017/)
- [YSDA NLP course](https://github.com/yandexdataschool/nlp_course). [Yandex School of data analysis](https://yandexdataschool.com/).
- [CMU Language and Statistics II: (More) Empirical Methods in Natural Language Processing](http://www.cs.cmu.edu/~nasmith/LS2.F06/)
- [UT CS 388: Natural Language Processing](http://www.cs.cmu.edu/~nasmith/LS2.F06/)
- [Columbia: COMS W4705: Natural Language Processing](http://www.cs.columbia.edu/~cs4705/)
- [Columbia: COMS E6998: Machine Learning for Natural Language Processing (Spring 2012)](http://www.cs.columbia.edu/~mcollins/courses/6998-2012/index.html)
- [Machine Translation: Spring 2016](http://mt-class.org/)
- [Commonlounge: Learn Natural Language Processing: From Beginner to Expert](https://www.commonlounge.com/discussion/9e98fc12d49e4cd59e248fc5fb72a8e9)
- [Big Data University: Advanced Text Analytics – Getting Results with SystemT](https://bigdatauniversity.com/courses/adv-text-analytics-getting-results-with-systemt/)
- [Udacity: Natural Language Processing Nanodegree](https://www.udacity.com/course/natural-language-processing-nanodegree--nd892)
- [edX: Natural Language Processing](https://www.edx.org/course/natural-language-processing-3): An introduction to NLP, taught by Microsoft researchers


## APIs and Libraries
- [R packages](https://cran.r-project.org/web/views/NaturalLanguageProcessing.html)
  - [tm](https://cran.r-project.org/web/packages/tm/index.html): Text Mining.
  - [lsa](https://cran.r-project.org/web/packages/lsa/index.html): Latent Semantic Analysis.
  - [lda](https://cran.r-project.org/web/packages/lda/lda.pdf): Collapsed Gibbs Sampling Methods for Topic Models.
  - [textir](https://cran.r-project.org/web/packages/textir/index.html): Inverse Regression for Text Analysis.
  - [corpora](https://cran.r-project.org/web/packages/corpora/index.html): Statistics and data sets for corpus frequency data.
  - [tau](https://cran.r-project.org/web/packages/tau/index.html): Text Analysis Utilities.
  - [tidytext](https://github.com/juliasilge/tidytext): Text mining using dplyr, ggplot2, and other tidy tools.
  - [Sentiment140](https://github.com/okugami79/sentiment140): Sentiment text analysis
  - [sentimentr](https://cran.r-project.org/web/packages/sentimentr/sentimentr.pdf): Lexicon-based sentiment analysis.
  - [cleanNLP](https://cran.r-project.org/web/packages/cleanNLP/cleanNLP.pdf): ML-based sentiment analysis.
  - [RSentiment](https://cran.r-project.org/web/packages/RSentiment/RSentiment.pdf): Lexicon-based sentiment analysis. Contains support for negation detection and sarcasm.
  - [text2vec](https://cran.r-project.org/web/packages/text2vec/index.html): Fast and memory-friendly tools for text vectorization, topic modeling (LDA, LSA), word embeddings (GloVe), similarities.
  - [fastTextR](https://cran.r-project.org/web/packages/fastTextR/README.html): Interface to the fastText library.
  - [LDAvis](https://cran.r-project.org/web/packages/LDAvis/): Interactive visualization of topic models.
  - [keras](https://cran.r-project.org/web/packages/keras/index.html): Interface to [Keras](https://keras.io), a high-level neural networks 'API'. ([RStudio Blog: TensorFlow for R](https://blog.rstudio.com/2018/02/06/tensorflow-for-r))
  - [retweet](http://rtweet.info/): Client for accessing Twitter’s REST and stream APIs. ([21 Recipes for Mining Twitter Data with rtweet](https://rud.is/books/21-recipes/))
  - [topicmodels](https://cran.r-project.org/web/packages/topicmodels/topicmodels.pdf): Interface to the C code for Latent Dirichlet Allocation (LDA).
  - [textmineR](https://cran.r-project.org/web/packages/textmineR/index.html): Aid for text mining in R, with a syntax that should be familiar to experienced R users.
  - [wordVectors](https://github.com/bmschmidt/wordVectors): Creating and exploring word2vec and other word embedding models.
  - [gtrendsR](https://cran.r-project.org/web/packages/gtrendsR/index.html): Interface for retrieving and displaying the information returned online by Google Trends.
    - [Analyzing Google Trends Data in R](https://datascienceplus.com/analyzing-google-trends-data-in-r/)
  - [textstem](https://cran.r-project.org/web/packages/textstem/): Tools that stem and lemmatize text.
  - [NLPutils](https://CRAN.R-project.org/package=NLPutils) Utilities for Natural Language Processing.
  - [Udpipe](https://cran.r-project.org/web/packages/udpipe/readme/README.html) Tokenization, Parts of Speech Tagging, Lemmatization and Dependency Parsing using UDPipe.
- [Python modules](https://pypi.org/)
  - [NLTK](http://www.nltk.org): Natural Language Toolkit.
    - [Video: NLTK with Python 3 for Natural Language Processing](https://www.youtube.com/playlist?list=PLQVvvaa0QuDf2JswnfiGkliBInZnIC4HL)
  - [scikit-learn](http://scikit-learn.org/): Machine Learning in Python
     - [Tutorial](http://nbviewer.jupyter.org/gist/rjweiss/7158866)
  - [Spark NLP](https://nlp.johnsnowlabs.com/): Open source text processing library for Python, Java, and Scala. It provides production-grade, scalable, and trainable versions of the latest research in natural language processing.
  - [spaCy](https://spacy.io/): Industrial-Strength Natural Language Processing in Python.
  - [textblob](https://textblob.readthedocs.io/en/dev/): Simplified Text processing.
    - [Natural Language Basics with TextBlob](http://rwet.decontextualize.com/book/textblob/)
  - [Gensim](https://radimrehurek.com/gensim/): Topic Modeling for humans.
  - [Pattern.en](https://www.clips.uantwerpen.be/pages/pattern-en): A fast part-of-speech tagger for English, sentiment analysis, tools for English verb conjugation and noun singularization & pluralization, and a WordNet interface.
  - [textmining](https://pypi.python.org/pypi/textmining/1.0): Python Text Mining utilities.
  - [Scrapy](https://scrapy.org/): Open source and collaborative framework for extracting the data you need from websites.
  - [lda2vec](https://github.com/cemoody/lda2vec): Tools for interpreting natural language.
  - [PyText](https://pytext-pytext.readthedocs-hosted.com/en/latest/) A deep-learning based NLP modeling framework built on PyTorch.
  - [sent2vec](https://github.com/epfml/sent2vec): General purpose unsupervised sentence representations.
  - [flair](https://github.com/zalandoresearch/flair): A very simple framework for state-of-the-art Natural Language Processing (NLP)
  - [word_forms](https://github.com/gutfeeling/word_forms): Accurately generate all possible forms of an English word e.g "election" --> "elect", "electoral", "electorate" etc.
  - [AllenNLP](https://github.com/allenai/allennlp): Open-source NLP research library, built on PyTorch.
  - [Beautiful Soup](https://www.crummy.com/software/BeautifulSoup/): Parse HTML and XML documents. Useful for webscraping. 
  - [BigARTM](https://github.com/bigartm/bigartm): Fast topic modeling platform.
  - [Scattertext](https://github.com/JasonKessler/scattertext): Beautiful visualizations of how language differs among document types.
  - [embeddings](https://pypi.org/project/embeddings/): Pretrained word embeddings in Python.
  - [fastText](https://github.com/facebookresearch/fastText/tree/master/python): Library for efficient learning of word representations and sentence classification.
  - [Google Seq2Seq](https://github.com/google/seq2seq): A general-purpose encoder-decoder framework for Tensorflow that can be used for Machine Translation, Text Summarization, Conversational Modeling, Image Captioning, and more.
  - [polyglot](https://polyglot.readthedocs.io/en/latest/index.html): A natural language pipeline that supports multilingual applications.
  - [textacy](https://chartbeat-labs.github.io/textacy/index.html): NLP, before and after spaCy
  - [Glove-Python](https://github.com/maciejkula/glove-python): A “toy” implementation of GloVe in Python. Includes a paragraph embedder. 
  - [Bert As A Service](https://github.com/hanxiao/bert-as-service): Client/Server package for sentence encoding, i.e. mapping a variable-length sentence to a fixed-length vector.  Design intent to provide a scalable production ready service, also allowing researchers to apply BERT quickly. 
  - [Keras-BERT](https://github.com/Separius/BERT-keras): A Keras Implementation of BERT 
  - [Paragraph embedding scripts and Pre-trained models](https://github.com/jhlau/doc2vec): Scripts for training and testing paragraph vectors, with links to some pre-trained Doc2Vec and Word2Vec models
  - [Texthero](https://github.com/jbesomi/texthero) Text preprocessing, representation and visualization from zero to hero.
- [Apache Tika](http://tika.apache.org/): a content analysis tookilt.
- [Apache Spark](https://spark.apache.org/docs/latest/): is a fast and general-purpose cluster computing system. It provides high-level APIs in Java, Scala, Python and R, and an optimized engine that supports general execution graphs.
  - [MLlib](https://spark.apache.org/docs/latest/ml-guide.html): MLlib is Spark’s machine learning (ML) library. Its goal is to make practical machine learning scalable and easy. Related to NLP there are methods available for LDA, Word2Vec, and TFIDF.
  - [LDA](https://spark.apache.org/docs/latest/ml-clustering.html#latent-dirichlet-allocation-lda): latent Dirichlet allocation
  - [Word2Vec](https://spark.apache.org/docs/latest/ml-features.html#word2vec): is an Estimator which takes sequences of words representing documents and trains a Word2VecModel. The model maps each word to a unique fixed-size vector. The Word2VecModel transforms each document into a vector using the average of all words in the document
  - [TFIDF](https://spark.apache.org/docs/latest/ml-features.html#tf-idf): term frequency-inverse document frequency
- [HDF5](https://www.neonscience.org/about-hdf5): an open source file format that supports large, complex, heterogeneous data. Requires no configuration.
  - [h5py](http://docs.h5py.org/en/stable/quick.html): Python HDF5 package
- [Stanford CoreNLP](http://stanfordnlp.github.io/CoreNLP/): a suite of core NLP tools
  - Also checkout http://corenlp.run for a hosted version of the CoreNLP server.
  - [Introduction to StanfordNLP: An Incredible State-of-the-Art NLP Library for 53 Languages (with Python code)](https://www.analyticsvidhya.com/blog/2019/02/stanfordnlp-nlp-library-python/)
- [Stanford Parser](http://nlp.stanford.edu/software/lex-parser.html): A probabilistic natural language parser.
- [Stanford POS Tagger](http://nlp.stanford.edu/software/tagger.html): A Parts-of-Speech tagger.
- [Stanford Named Entity Recognizer](http://nlp.stanford.edu/software/CRF-NER.html): Recognizes proper nouns (things, places, organizations) and labels them as such.
- [Stanford Classifier](http://nlp.stanford.edu/software/classifier.html): A softmax classifier.
- [Stanford OpenIE](http://nlp.stanford.edu/software/openie.html): Extracts relationships between words in a sentence (e.g. Mark Zuckerberg; founded; Facebook).
- [Stanford Topic Modeling Toolbox](http://nlp.stanford.edu/software/tmt/tmt-0.2/)
- [MALLET](http://mallet.cs.umass.edu/): MAchine Learning for LanguagE Toolkit
  - Github: https://github.com/mimno/Mallet
- [Apache OpenNLP](https://opennlp.apache.org/): Machine learning based toolkit for text NLP.
- [Streamcrab](https://github.com/cyhex/streamcrab): Real-Time, Twitter sentiment analyzer engine http:/www.streamcrab.com
- [TextRazor API](https://www.textrazor.com/): Extract Meaning from your Text.
- [fastText](https://github.com/facebookresearch/fastText). Library for fast text representation and classification. Facebook.
- [Comparison of Top 6 Python NLP Libraries](https://www.kdnuggets.com/2018/07/comparison-top-6-python-nlp-libraries.html).
- [pyCaret's NLP Module](https://pycaret.org/nlp/). PyCaret is an open source, low-code machine learning library in Python that aims to reduce the cycle time from hypothesis to insights; also, PyCaret's Founder Moez Ali is a Smith Alumni - MMA 2020.


## Products
- [Systran - Enterprise Translation Products](http://www.systransoft.com/translation-products/)
- [SAS Text Miner (Part of SAS Enterprise Miner)](http://www.sas.com/en_us/software/analytics/text-miner.html)
- [SAS Sentiment Analysis](http://www.sas.com/en_ca/software/analytics/sentiment-analysis.html)
- [STATISTICA](http://www.statsoft.com/Products/STATISTICA/Product-Index)
  - [Text Mining (Big Data, Unstructured Data)](http://www.statsoft.com/Textbook/Text-Mining/button/3)
- [KNIME](https://www.knime.org/)
- [RapidMiner](https://rapidminer.com/)
- [Gate](https://gate.ac.uk/)
- [IBM Watson](http://www.ibm.com/watson/)
  - [Video: How IBM Watson learns (3 minutes)](https://www.youtube.com/watch?v=ymUFadN_MO4)
  - [Video: IBM Watson on Jeapardy! (10 minutes)](https://www.youtube.com/watch?v=lI-M7O_bRNg)
  - [Video: IBM Watson: The Science Behind an Answer (7 minutes)](https://www.youtube.com/watch?v=DywO4zksfXw)
- [Crimson Hexagon](https://www.crimsonhexagon.com/)  
- [Stocktwits](http://stocktwits.com/): Tap into the Pulse of Markets
- [Meltwater](https://www.meltwater.com/)
- [CrowdFlower](https://www.crowdflower.com/): AI for your business.
- [Lexalytics Sematria](https://www.lexalytics.com/): API and Excel plugin.
- [Rosette Text Analytics](https://www.rosette.com/): AI for Human Language
- [Alchemy API](https://www.ibm.com/watson/alchemy-api.html)
- [Monkey Learn](http://monkeylearn.com/)
- [LightTag Annotation Tool](https://lighttag.io). Hosted annotation tool for teams. 
- [UBIAI](https://ubiai.tools). Easy-to-use text annotation tool for teams with most comprehensive auto-annotation features. Supports NER, relations and document classification as well as OCR annotation for invoice labeling
- [Anafora](https://github.com/weitechen/anafora): Free and open source web-based raw text annotation tool
- [brat](http://brat.nlplab.org/): Rapid annotation tool.
- [Google's Colab](http://colab.research.google.com): Ready-to-go Notebook environment that makes it easy to get up and running.
- [Lyrebird.ai](https://lyrebird.ai/): “Ultra-Realistic Voice Cloning and Text-to-Speech” recognition platform. This Canadian start-up has created a product/platform that syncs both voice cloning with text-to-speech. Lyrebird recognizes the intonations and voice patterns from audio recordings, and overlays text data input to recreate a text-to-speech audio file output from the selected voice pattern audio recording.
- [Ask Data by Tableau Software Inc.](https://www.tableau.com/products/new-features/ask-data#hero-reveal): In February 2019, Tableau released a new NLP feature service add-on to help assist existing Tableau platform users with retrieving quick and easy data visualizations to drive business intelligence insights. Similar to a search engine user interface, Tableau’s Ask Data feature interface applies NLP from user text input to extract key words to find data analytics and business insights quickly on the Tableau Platform.
- [Dialogflow](https://dialogflow.com/) Google's Natural Language Platform used to integrate conversational user interfaces into mobile apps, web applications, bots, VRUs, etc.
- [Weka](https://www.cs.waikato.ac.nz/ml/weka/) Easy-to-use, graphical Machine Learning Workbench including NLP capabilities.
- [Annotation Lab](https://www.johnsnowlabs.com/annotation-lab/) - Free End-to-End No-Code platform for text annotation and DL model training/tuning. Out-of-the-box support for Named Entity Recognition, Classification, Relation extraction and Assertion Status Spark NLP models. Unlimited support for users, teams, projects, documents.  

#### Cloud 
- [Microsoft Azure Text Analytics](https://docs.microsoft.com/en-ca/azure/cognitive-services/text-analytics/overview)
- [Amazon Lex](https://aws.amazon.com/lex/): A service for building conversational interfaces into any application using voice and text.
- [Amazon Comprehend](https://aws.amazon.com/comprehend/)
- [Google Cloud Natural Language](https://cloud.google.com/natural-language/)
- [IBM Watson](http://www.ibm.com/watson/)
  - [Video: How IBM Watson learns (3 minutes)](https://www.youtube.com/watch?v=ymUFadN_MO4)
  - [Video: IBM Watson on Jeapardy! (10 minutes)](https://www.youtube.com/watch?v=lI-M7O_bRNg)
  - [Video: IBM Watson: The Science Behind an Answer (7 minutes)](https://www.youtube.com/watch?v=DywO4zksfXw)



#### Getting Data out of PDFs

- [Apache PDFBox](https://pdfbox.apache.org/)
- [Tabula: A tool for liberating data tables locked inside PDF files.](http://tabula.technology/)
- [PDFLayoutTextStripper: Converts a pdf file into a text file while keeping the layout of the original pdf.](https://github.com/JonathanLink/PDFLayoutTextStripper)
- [pdftabextract: A set of tools for extracting tables from PDF files helping to do data mining on (OCR-processed) scanned documents.](https://github.com/WZBSocialScienceCenter/pdftabextract)
- [SO: How to extract text from a PDF?](http://stackoverflow.com/questions/3650957/how-to-extract-text-from-a-pdf)
- [Tools for Extracting Data and Text from PDFs - A Review](http://okfnlabs.org/blog/2016/04/19/pdf-tools-extract-text-and-data-from-pdfs.html)
- [How I used NLP (SpaCy) to screen Data Science Resumes](https://towardsdatascience.com/do-the-keywords-in-your-resume-aptly-represent-what-type-of-data-scientist-you-are-59134105ba0d)
 - [PyPDF2](https://github.com/mstamy2/PyPDF2): PDF file manipulation (PDF to PDF).


## Online Demos and Tools

- [MIT OpenNPT for neural machine translation and neural sequence modeling](http://opennmt.net/)
- [Stanford Parser](http://nlp.stanford.edu:8080/parser/)
- [Stanford CoreNLP](http://nlp.stanford.edu:8080/corenlp/)
- [word2vec demo](http://bionlp-www.utu.fi/wv_demo)
- [Another word2vec demo](http://turbomaze.github.io/word2vecjson/)
- [sense2vec: Semantic Analysis of the Reddit Hivemind](https://explosion.ai/demos/sense2vec)
- [RegexPal](https://www.regexpal.com/): Great tool for testing out regular expressions.
- [AllenNLP Demo](https://demo.allennlp.org): Great demo using AllenNLP of everything from Named Entity Recognition to Textual Entailment.
- [Cognitive Computation Group - Part of Speech Tagging Demo](http://cogcomp.org/page/demos/) These demos exhibit part-of-speech tagging, information extraction tasks etc.


## Datasets

- [UCI's Text Datasets](https://archive.ics.uci.edu/ml/datasets.html?format=&task=&att=&area=&numAtt=&numIns=&type=text&sort=nameUp&view=table). A collection of databases, domain theories, and data generators used by Machine Learning community. 
- [data.world's Text Datasets](https://data.world/datasets/text-mining)
- [Awesome Public Datasets' Natural Languge](https://github.com/caesar0301/awesome-public-datasets#natural-language)
- [Insight Resources Datasets](http://mlg.ucd.ie/datasets/index.html#data)
- [Bing Sentiment Analysis](https://www.cs.uic.edu/~liub/FBS/sentiment-analysis.html#datasets)
- [Consumer Complaint Database](https://www.consumerfinance.gov/data-research/consumer-complaints/#download-the-data). From the Consumer Financial Protection Bureau.
- [Sentiment Labelled Sentences Data Set ](http://archive.ics.uci.edu/ml/datasets/Sentiment+Labelled+Sentences). Contains sentences labelled as "positive" or "negative", from imdb.com, amazon.com, and yelp.com.
- [Amazon product data](http://jmcauley.ucsd.edu/data/amazon/)
- [Data is Plural](https://docs.google.com/spreadsheets/d/1wZhPLMCHKJvwOkP4juclhjFgqIY8fQFMemwKL2c64vk/edit#gid=0)
- [FiveThirtyEight's datasets](https://data.fivethirtyeight.com/?utm_campaign=Data%2BElixir&utm_medium=email&utm_source=Data_Elixir_169)
- [r/datasets](https://www.reddit.com/r/datasets/)
- [Awesome public datasets](https://github.com/caesar0301/awesome-public-datasets)
- [R's `datasets` package](https://stat.ethz.ch/R-manual/R-devel/library/datasets/html/00Index.html)
- [200,000 Russian Troll Tweets](https://www.reddit.com/r/politics/comments/7zfk4i/im_a_reporter_for_nbc_news_and_we_published_over/) - Released by Congress from Twitter suspended accounts and removed from public view.
- [Wikipedia: List of datasets for ML research](https://en.wikipedia.org/wiki/List_of_datasets_for_machine_learning_research)
- [Google Dataset Search](https://toolbox.google.com/datasetsearch)
- [Kaggle: UMICH SI650 - Sentiment Classification](https://www.kaggle.com/c/si650winter11/data)
- [Lee's Similarity Data Sets](https://faculty.sites.uci.edu/mdlee/similarity-data/)
- [Corpus of Presidential Speeches (CoPS) and a Clinton/Trump Corpus ](http://www.thegrammarlab.com/?nor-portfolio=corpus-of-presidential-speeches-cops-and-a-clintontrump-corpus)
- [15 Best Chatbot Datasets for Machine Learning](https://gengo.ai/datasets/15-best-chatbot-datasets-for-machine-learning/)
- [A Survey of Available Corpora for Building Data-Driven Dialogue Systems](https://arxiv.org/pdf/1512.05742.pdf)
- [nlp-datasets](https://github.com/niderhoff/nlp-datasets)
- [Hate-speech-and-offensive-language](https://github.com/t-davidson/hate-speech-and-offensive-language)
- [First Quora Dataset Release: Question Pairs](https://data.world/socialmediadata/quora-question-pairs)
- [The Best 25 Datasets for Natural Language Processing](https://gengo.ai/datasets/the-best-25-datasets-for-natural-language-processing/)
- [SWAG](https://github.com/rowanz/swagaf): A large-scale dataset created for Natural Language Inference (NLI) with common-sense reasoning.
- [MIMIC](https://mimic.physionet.org/gettingstarted/access/): an openly available dataset developed by the MIT Lab for Computational Physiology, comprising deidentified health data associated with ~40,000 critical care patients.
- [Clinical NLP Dataset Repository](https://clinical-nlp.github.io/2019/resources.html): A curated list of publicly-available clinical datasets for use in NLP research.  
- [Million Song Lyrics](https://labrosa.ee.columbia.edu/millionsong/musixmatch)
- [The Multi-Genre NLI Corpus](https://www.nyu.edu/projects/bowman/multinli/)
- [Twitter US Airline Sentiment](https://www.kaggle.com/crowdflower/twitter-airline-sentiment/home)
- [Million Song Lyrics](https://labrosa.ee.columbia.edu/millionsong/musixmatch): Dataset of song lyrics in Bag-Of-Words (BOW) format.
- [DuoRC](https://github.com/duorc/duorc/tree/master/dataset) – 186K unique question-answer pairs with evaluation script for Paraphrased Reading Comprehension
- [EDGAR Financial Statements](https://edgar-online.com): Reporting engine for financial and regulatory filings for companies worldwide. A huge repository of financial and company data for text mining.
- [American National Corpus Download](http://www.anc.org/data/oanc/contents/)
- [Santa Barbara Corpus of Spoken American English](http://www.linguistics.ucsb.edu/research/santa-barbara-corpus)
- [Leipzig Corpora Collection: Corpora in English, Arabic, French, Russian, German](http://wortschatz.uni-leipzig.de/en/download/)
- [Awesome Twitter](https://github.com/hridaydutta123/awesome-twitter-tools/blob/master/README.md)
- [The Big Bad NLP Database](https://quantumstat.com/dataset/dataset.html)
- [CBC News Coronavirus articles](https://www.kaggle.com/ryanxjhan/cbc-news-coronavirus-articles-march-26)
- [Huggingface](https://huggingface.co/datasets/viewer/?dataset=financial_phrasebank)

### Lexicons for Sentiment Analysis
- [MPQA Lexicon](http://mpqa.cs.pitt.edu/lexicons/)
- [SentiWordNet](http://sentiwordnet.isti.cnr.it/)
- [AFINN](http://www2.imm.dtu.dk/pubdb/views/publication_details.php?id=6010)
- [Bing](https://www.cs.uic.edu/~liub/FBS/sentiment-analysis.html)
- [nrc](http://saifmohammad.com/WebPages/NRC-Emotion-Lexicon.htm)
- [vaderSentiment](https://github.com/cjhutto/vaderSentiment)


## Misc
- [AskReddit: People with a mother tongue that isn't English, what are the most annoying things about the English language when you are trying to learn it?](https://www.reddit.com/r/AskReddit/comments/6qvmny/people_with_a_mother_tongue_that_isnt_english/)
- [Funny Video: Emotional Spell Check](https://vimeo.com/17859540)
- [How to win Kaggle competition based on NLP task, if you are not an NLP expert](http://www.kdnuggets.com/2017/09/win-kaggle-nlp-not-expert.html)
- [Detecting Gang-Involved Escalation on Social Media Using Context](http://aclweb.org/anthology/D18-1005) Detecting Aggression and Loss in social media using CNN
- [Reasoning about Actions and State Changes by Injecting Commonsense Knowledge](http://aclweb.org/anthology/D18-1006) Incorporating global, commonsense constraints & biasing reading with preferences from large-scale corp
- [The Language of Hip Hop](https://pudding.cool/2017/09/hip-hop-words/): A 2017 analysis by Matt Daniels of Pudding determining the popularity of various words in hip hop music and across artists.
- [Using Natural Language Processing for Automatic Detection of Plagiarism](https://pdfs.semanticscholar.org/636d/4c0b0fe6919abe6eb546907d28ed39bf56e6.pdf)
- [Probabilistic Graphical Models: Lagrangian Relaxation Algorithms for Natural Language Processing](http://people.csail.mit.edu/dsontag/courses/pgm12/slides/lecture3.pdf)
- [Human Emotion](https://www.youtube.com/watch?v=qwsft6tmvBA&list=PLrAXtmErZgOdP_8GztsuKi9nrraNbKKp4) How to determine confidence level for manually labeled sentiment data?
- [A Complete Exploratory Data Analysis and Visualization for Text Data](https://towardsdatascience.com/a-complete-exploratory-data-analysis-and-visualization-for-text-data-29fb1b96fb6a)

## Other Curated Lists
- [awesome-nlp](https://github.com/keonkim/awesome-nlp): A curated list of resources dedicated to Natural Language Processing (NLP)
- [awesome-machine-learning](https://github.com/josephmisiti/awesome-machine-learning#cpp-nlp)
- [Awesome Deep Learning for Natural Language Processing (NLP)](https://github.com/brianspiering/awesome-dl4nlp)
- [Paper with Code](https://paperswithcode.com/): A fantastic list of recent machine learning papers on ArXiv, with links to code.   
- [Chinese NLP Tools](https://datascience.shanghai.nyu.edu/chinese-nlp-tools). 2019. List of tools for NLP in Chinese Language.
- [Association for Computational Linguistics Papers Anthology](https://aclanthology.info/): The ACL Anthology currently hosts almost 50,000 papers on the study of computational linguistics and natural language processing.  Includes all papers from recent conferences.
- [Over 150 of the Best Machine Learning, NLP, and Python Tutorials I’ve Found](https://medium.com/machine-learning-in-practice/over-150-of-the-best-machine-learning-nlp-and-python-tutorials-ive-found-ffce2939bd78)

# Contribute

Contributions are more than welcome! Please read the [contribution guidelines](CONTRIBUTING.md) first.


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0)

To the extent possible under law, @stepthom has waived all copyright and
related or neighboring rights to this work.
