## Setup Helper
resource "aws_iam_role" "test_role" {
  assume_role_policy = <<-EOF
  {
    "Version": "2012-10-17",
    "Statement": [
      {
        "Action": "sts:AssumeRole",
        "Principal": {
          "Service": "ec2.amazonaws.com"
        },
        "Effect": "Allow",
        "Sid": ""
      }
    ]
  }
  EOF
}

# Pass
resource "aws_iam_role_policy" "policy_statement_without_notaction" {
  role = aws_iam_role.test_role.id

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "ec2:Describe*"
      ],
      "Effect": "Allow",
      "Resource": "*"
    }
  ]
}
EOF
}

# Warn
resource "aws_iam_role_policy" "policy_statement_with_notaction" {
  role = aws_iam_role.test_role.id

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "NotAction": "ec2:DescribeVpcs",
      "Effect": "Allow",
      "Resource": "*"
    }
  ]
}
EOF
}
