unit dutil.util.digest.Crc32Test;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  TestFramework, Classes, Windows, dutil.util.digest.Crc32;

type
  // Test methods for class TCrc32
  TCrc32Test = class(TTestCase)
  strict private
    FCrc32: TCrc32;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestDigest;
    procedure TestDigest1;
    procedure TestDigestFromFile;
  end;

implementation

uses
  Forms;

procedure TCrc32Test.SetUp;
begin
  FCrc32 := TCrc32.Create;
end;

procedure TCrc32Test.TearDown;
begin
  FCrc32.Free;
  FCrc32 := nil;
end;

procedure TCrc32Test.TestDigest;
var
  ReturnValue: System.Cardinal;
  Stream: TCustomMemoryStream;
begin
  Stream := TStringStream.Create('This is a test!');
  try
    ReturnValue := FCrc32.digest(Stream);
  finally
    Stream.Free;
  end;
  CheckEquals($567CD4CC, ReturnValue);
end;

procedure TCrc32Test.TestDigest1;
var
  ReturnValue: System.Cardinal;
  ReturnValue2: System.Cardinal;
  S: string;
begin
  S := 'This is a test!';
  ReturnValue := FCrc32.digest(S);
  ReturnValue2 := FCrc32.digest(S + '1');
  CheckEquals($29492415, ReturnValue);
  CheckNotEquals(ReturnValue2, ReturnValue);
end;

procedure TCrc32Test.TestDigestFromFile;
var
  ReturnValue: System.Cardinal;
  FileName: string;
begin
  FileName := Application.ExeName;
  ReturnValue := FCrc32.DigestFromFile(FileName);
  CheckNotEquals(0, ReturnValue);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TCrc32Test.Suite);

end.
