unit dutil.util.concurrent.BlockingQueueTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.util.concurrent.BlockingQueue, Generics.Collections,
  SyncObjs;

type
  // Test methods for class TBlockingQueue
  TBlockingQueueTest = class(TTestCase)
  private type
    TElement = class
      Value: Integer;
      constructor Create(Value: Integer);
    end;
  strict private
    FBlockingQueue: TBlockingQueue<TElement>;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestPutAndTake;
  private
    procedure RunMethodForPutAndTake;
  end;

implementation

uses
  Windows,
  dutil.util.concurrent.FailSafeThread;

constructor TBlockingQueueTest.TElement.Create(Value: Integer);
begin
  Self.Value := Value;
end;

procedure TBlockingQueueTest.SetUp;
begin
  FBlockingQueue := TBlockingQueue<TElement>.Create;
end;

procedure TBlockingQueueTest.TearDown;
begin
  FBlockingQueue.Free;
  FBlockingQueue := nil;
end;

procedure TBlockingQueueTest.TestPutAndTake;
var
  Thread: TFailSafeThread;
  Element: TElement;
  Elements: TList<TElement>;
begin
  Thread := TFailSafeThread.Create(RunMethodForPutAndTake);
  Thread.Start;

  Elements := TList<TElement>.Create;
  try
    Element := FBlockingQueue.Take;
    while Element <> nil do
    begin
      Elements.Add(Element);
      Element := FBlockingQueue.Take;
    end;

    CheckEquals(2, Elements.Count);
    CheckEquals(0, Elements.Items[0].Value);
    CheckEquals(1, Elements.Items[1].Value);
    CheckEquals(0, FBlockingQueue.Count);

    Thread.WaitFor;
    Thread.Free;
  finally
    for Element in Elements do
      Element.Free;
    Elements.Free;
  end;
end;

procedure TBlockingQueueTest.RunMethodForPutAndTake;
begin
  FBlockingQueue.Put(TElement.Create(0));
  Windows.Sleep(100);
  FBlockingQueue.Put(TElement.Create(1));
  Windows.Sleep(100);
  FBlockingQueue.Put(nil);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TBlockingQueueTest.Suite);

end.
