unit dutil.text.xml.ValidationTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, Generics.Collections, SysUtils, dutil.text.xml.Validation,
  NativeXml;

type
  // Test methods for class TValidation
  TValidationTest = class(TTestCase)
  strict private
    FValidation: TValidation;
    FXml: TNativeXml;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestRequireElement;
    procedure TestRequireElement_Failed;
    procedure TestRequireChild;
    procedure TestRequireChild_Failed;
    procedure TestRequireChildren;
    procedure TestRequireChildren_Failed;
    procedure TestRequireStr;
    procedure TestRequireStr_Failed;
    procedure TestRequireBool;
    procedure TestRequireBool_Failed;
    procedure TestRequireInt;
    //procedure TestRequireInt_Failed;
    procedure TestRequireUInt;
    //procedure TestRequireUInt_Failed;
  end;

implementation

uses
  dutil.core.Exception;

procedure TValidationTest.SetUp;
begin
  FValidation := TValidation.Create;
  FXml := TNativeXml.Create(nil);
  FXml.LoadFromFile('..\fixture\example.xml');
end;

procedure TValidationTest.TearDown;
begin
  FXml.Free;
  FValidation.Free;
  FValidation := nil;
end;

procedure TValidationTest.TestRequireElement;
begin
  FValidation.RequireElement(FXml.Root, 'profile');
end;

procedure TValidationTest.TestRequireElement_Failed;
begin
  StartExpectingException(EXmlException);

  FValidation.RequireElement(FXml.Root, '');
  StopExpectingException;
end;

procedure TValidationTest.TestRequireChild;
var
  ReturnValue: TXmlNode;
begin
  ReturnValue := FValidation.RequireChild(FXml.Root, 'language');
  CheckNotNull(ReturnValue);
end;

procedure TValidationTest.TestRequireChild_Failed;
begin
  StartExpectingException(EXmlException);

  FValidation.RequireChild(FXml.Root, '');
  StopExpectingException;
end;

procedure TValidationTest.TestRequireChildren;
var
  ReturnValue: TList<TXmlNode>;
begin
  ReturnValue := FValidation.RequireChildren(FXml.Root, 'language');
  try
    CheckNotNull(ReturnValue);
    CheckEquals(ReturnValue.Count, 1);
  finally
    ReturnValue.Free;
  end;
end;

procedure TValidationTest.TestRequireChildren_Failed;
var
  ReturnValue: TList<TXmlNode>;
begin
  StartExpectingException(EXmlException);

  ReturnValue := FValidation.RequireChildren(FXml.Root, '');
  ReturnValue.Free;
  StopExpectingException;
end;

procedure TValidationTest.TestRequireStr;
var
  ReturnValue: string;
  Node: TXmlNode;
begin
  Node := FValidation.RequireChild(FXml.Root, 'language');

  ReturnValue := FValidation.RequireStr(Node, 'ui');
  CheckEquals(ReturnValue, 'english');
end;

procedure TValidationTest.TestRequireStr_Failed;
var
  Node: TXmlNode;
begin
  Node := FValidation.RequireChild(FXml.Root, 'appearance');
  StartExpectingException(EXmlException);

  FValidation.RequireStr(Node, '');
  StopExpectingException;
end;

procedure TValidationTest.TestRequireBool;
var
  ReturnValue: Boolean;
  Node: TXmlNode;
begin
  Node := FValidation.RequireChild(FXml.Root, 'appearance');

  ReturnValue := FValidation.RequireBool(Node, 'defaultFont');
  CheckTrue(ReturnValue);
end;

procedure TValidationTest.TestRequireBool_Failed;
var
  Node: TXmlNode;
begin
  Node := FValidation.RequireChild(FXml.Root, 'appearance');
  StartExpectingException(EXmlException);

  FValidation.RequireBool(Node, 'ui');
  StopExpectingException;
end;

procedure TValidationTest.TestRequireInt;
var
  ReturnValue: Integer;
  Node: TXmlNode;
begin
  Node := FValidation.RequireChild(FXml.Root, 'appearance');

  ReturnValue := FValidation.RequireInt(Node, 'x');
  CheckEquals(ReturnValue, 300);
end;
(*
procedure TValidationTest.TestRequireInt_Failed;
var
  Node: TXmlNode;
begin
  Node := FValidation.RequireChild(FXml.Root, 'appearance');
  StartExpectingException(EXmlException);

  FValidation.RequireInt(Node, 'int64');
  StopExpectingException;
end;
*)
procedure TValidationTest.TestRequireUInt;
var
  ReturnValue: Cardinal;
  Node: TXmlNode;
begin
  Node := FValidation.RequireChild(FXml.Root, 'appearance');

  ReturnValue := FValidation.RequireUInt(Node, 'x');
  CheckEquals(ReturnValue, 300);
end;
(*
procedure TValidationTest.TestRequireUInt_Failed;
var
  Node: TXmlNode;
begin
  Node := FValidation.RequireChild(FXml.Root, 'appearance');
  StartExpectingException(EXmlException);

  FValidation.RequireUInt(Node, 'y');
  StopExpectingException;
end;
*)
initialization

// Register any test cases with the test runner
RegisterTest(TValidationTest.Suite);

end.
