unit dutil.text.json.ReaderTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.text.json.Reader,
  superobject { An universal object serialization framework with Json support };

type
  // Test methods for class TJson
  TReaderTest = class(TTestCase)
  strict private
    FJSON: ISuperObject;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestReadStrMember;
    procedure TestReadStrMember_Fallback;
    procedure TestReadBoolMember;
    procedure TestReadBoolMember_Fallback;
    procedure TestReadIntMember;
    procedure TestReadIntMember_Fallback;
    procedure TestReadUIntMember;
    procedure TestReadUIntMember_Fallback;
    procedure TestReadStrPairMember;
    procedure TestReadStrPairMember_Fallback;
    procedure TestReadStrArrayMember;
    procedure TestReadStrArrayMember_Fallback;
    procedure TestReadBoolArrayMember;
    procedure TestReadBoolArrayMember_Fallback;
    procedure TestReadIntArrayMember;
    procedure TestReadIntArrayMember_Fallback;
    procedure TestReadUIntArrayMember;
    procedure TestReadUIntArrayMember_Fallback;
    procedure TestReadStrPairArrayMember;
    procedure TestReadStrPairArrayMember_Fallback;
  end;

implementation

uses
  Types,
  System.Generics.Collections;

procedure TReaderTest.SetUp;
begin
  FJSON := SO('{"str":"string1", "bool":true, "int":-42, "uint":42, "pair":["s1","s2"], "str_arr":["s1","s2"], ' +
    '"bool_arr":[true,false], "int_arr":[-42,42], "uint_arr":[42,24], "pair_arr":[["k1","v1"],["k2","v2"]]}');
end;

procedure TReaderTest.TearDown;
begin
  FJSON := nil;
end;

procedure TReaderTest.TestReadStrMember;
var
  ReturnValue: string;
begin
  ReturnValue := TReader.ReadStrMember(FJSON, 'str', '');
  CheckEquals('string1', ReturnValue);
end;

procedure TReaderTest.TestReadStrMember_Fallback;
var
  ReturnValue: string;
begin
  ReturnValue := TReader.ReadStrMember(FJSON, 'str2', 'not_found');
  CheckEquals('not_found', ReturnValue);
end;

procedure TReaderTest.TestReadBoolMember;
var
  ReturnValue: Boolean;
begin
  ReturnValue := TReader.ReadBoolMember(FJSON, 'bool', False);
  CheckEquals(True, ReturnValue);
end;

procedure TReaderTest.TestReadBoolMember_Fallback;
var
  ReturnValue: Boolean;
begin
  ReturnValue := TReader.ReadBoolMember(FJSON, 'bool2', True);
  CheckEquals(True, ReturnValue);
end;

procedure TReaderTest.TestReadIntMember;
var
  ReturnValue: Integer;
begin
  ReturnValue := TReader.ReadIntMember(FJSON, 'int', 0);
  CheckEquals(-42, ReturnValue);
end;

procedure TReaderTest.TestReadIntMember_Fallback;
var
  ReturnValue: Integer;
begin
  ReturnValue := TReader.ReadIntMember(FJSON, 'int2', -1);
  CheckEquals(-1, ReturnValue);
end;

procedure TReaderTest.TestReadUIntMember;
var
  ReturnValue: Integer;
begin
  ReturnValue := TReader.ReadUIntMember(FJSON, 'uint', 0);
  CheckEquals(42, ReturnValue);
end;

procedure TReaderTest.TestReadUIntMember_Fallback;
var
  ReturnValue: Integer;
begin
  ReturnValue := TReader.ReadUIntMember(FJSON, 'uint2', 24);
  CheckEquals(24, ReturnValue);
end;

procedure TReaderTest.TestReadStrPairMember;
var
  ReturnValue: TPair<string, string>;
begin
  ReturnValue := TReader.ReadStrPairMember(FJSON, 'pair', TPair<string, string>.Create('',''));
  CheckEquals('s1', ReturnValue.Key);
  CheckEquals('s2', ReturnValue.Value);
end;

procedure TReaderTest.TestReadStrPairMember_Fallback;
var
  ReturnValue: TPair<string, string>;
begin
  ReturnValue := TReader.ReadStrPairMember(FJSON, 'pair2', TPair<string, string>.Create('no1','no2'));
  CheckEquals('no1', ReturnValue.Key);
  CheckEquals('no2', ReturnValue.Value);
end;

procedure TReaderTest.TestReadStrArrayMember;
var
  ReturnValue: TArray<string>;
begin
  ReturnValue := TReader.ReadStrArrayMember(FJSON, 'str_arr', nil);
  CheckEquals(2, Length(ReturnValue));
  CheckEquals('s1', ReturnValue[0]);
  CheckEquals('s2', ReturnValue[1]);
end;

procedure TReaderTest.TestReadStrArrayMember_Fallback;
var
  ReturnValue: TArray<string>;
begin
  ReturnValue := TReader.ReadStrArrayMember(FJSON, 'str_arr2', nil);
  Check(ReturnValue = nil);
end;

procedure TReaderTest.TestReadBoolArrayMember;
var
  ReturnValue: TArray<Boolean>;
begin
  ReturnValue := TReader.ReadBoolArrayMember(FJSON, 'bool_arr', nil);
  CheckEquals(2, Length(ReturnValue));
  CheckEquals(True, ReturnValue[0]);
  CheckEquals(False, ReturnValue[1]);
end;

procedure TReaderTest.TestReadBoolArrayMember_Fallback;
var
  ReturnValue: TArray<Boolean>;
begin
  ReturnValue := TReader.ReadBoolArrayMember(FJSON, 'bool_arr2', nil);
  Check(ReturnValue = nil);
end;

procedure TReaderTest.TestReadIntArrayMember;
var
  ReturnValue: TArray<Integer>;
begin
  ReturnValue := TReader.ReadIntArrayMember(FJSON, 'int_arr', nil);
  CheckEquals(2, Length(ReturnValue));
  CheckEquals(-42, ReturnValue[0]);
  CheckEquals(42, ReturnValue[1]);
end;

procedure TReaderTest.TestReadIntArrayMember_Fallback;
var
  ReturnValue: TArray<Integer>;
begin
  ReturnValue := TReader.ReadIntArrayMember(FJSON, 'int_arr2', nil);
  Check(ReturnValue = nil);
end;

procedure TReaderTest.TestReadUIntArrayMember;
var
  ReturnValue: TArray<Cardinal>;
begin
  ReturnValue := TReader.ReadUIntArrayMember(FJSON, 'uint_arr', nil);
  CheckEquals(2, Length(ReturnValue));
  CheckEquals(42, ReturnValue[0]);
  CheckEquals(24, ReturnValue[1]);
end;

procedure TReaderTest.TestReadUIntArrayMember_Fallback;
var
  ReturnValue: TArray<Cardinal>;
begin
  ReturnValue := TReader.ReadUIntArrayMember(FJSON, 'uint_arr2', nil);
  Check(ReturnValue = nil);
end;

procedure TReaderTest.TestReadStrPairArrayMember;
var
  ReturnValue: TArray<TPair<string, string>>;
begin
  ReturnValue := TReader.ReadStrPairArrayMember(FJSON, 'pair_arr', nil);
  CheckEquals(2, Length(ReturnValue));
  CheckEquals('k1', ReturnValue[0].Key);
  CheckEquals('v1', ReturnValue[0].Value);
  CheckEquals('k2', ReturnValue[1].Key);
  CheckEquals('v2', ReturnValue[1].Value);
end;

procedure TReaderTest.TestReadStrPairArrayMember_Fallback;
var
  ReturnValue: TArray<TPair<string, string>>;
begin
  ReturnValue := TReader.ReadStrPairArrayMember(FJSON, 'pair_arr2', nil);
  Check(ReturnValue = nil);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TReaderTest.Suite);

end.
