unit dutil.text.json.JsonTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.text.json.Json;

type
  // Test methods for class TJson
  TJsonTest = class(TTestCase)
  strict private
    FJson: TJson;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestPrint;
    procedure TestCreateArray_String;
    procedure TestCreateArray_Boolean;
    procedure TestCreateArray_Integer;
    procedure TestCreateArray_Cardinal;
    procedure TestCreateArray_PairStringString;
  end;

implementation

uses
  Types,
  System.Generics.Collections,
  superobject { An universal object serialization framework with Json support };

procedure TJsonTest.SetUp;
begin
  FJson := TJson.Create;
end;

procedure TJsonTest.TearDown;
begin
  FJson.Free;
  FJson := nil;
end;

procedure TJsonTest.TestPrint;
var
  ReturnValue: string;
begin
  ReturnValue := TJson.Print(nil);
  CheckEquals('null', ReturnValue);
end;

procedure TJsonTest.TestCreateArray_String;
var
  DynArray: TArray<string>;
  ReturnValue: ISuperObject;
begin
  DynArray := TArray<string>.Create('s1', 's2');

  ReturnValue := TJson.CreateArray(DynArray);
  CheckEquals('["s1","s2"]', ReturnValue.AsJSon);
end;

procedure TJsonTest.TestCreateArray_Boolean;
var
  DynArray: TArray<Boolean>;
  ReturnValue: ISuperObject;
begin
  DynArray := TArray<Boolean>.Create(True, False);

  ReturnValue := TJson.CreateArray(DynArray);
  CheckEquals('[true,false]', ReturnValue.AsJSon);
end;

procedure TJsonTest.TestCreateArray_Integer;
var
  DynArray: TArray<Integer>;
  ReturnValue: ISuperObject;
begin
  DynArray := TArray<Integer>.Create(42, -42);

  ReturnValue := TJson.CreateArray(DynArray);
  CheckEquals('[42,-42]', ReturnValue.AsJSon);
end;

procedure TJsonTest.TestCreateArray_Cardinal;
var
  DynArray: TArray<Cardinal>;
  ReturnValue: ISuperObject;
begin
  DynArray := TArray<Cardinal>.Create(42, 24);

  ReturnValue := TJson.CreateArray(DynArray);
  CheckEquals('[42,24]', ReturnValue.AsJSon);
end;

procedure TJsonTest.TestCreateArray_PairStringString;
var
  DynArray: TArray<TPair<string, string>>;
  ReturnValue: ISuperObject;
begin
  DynArray := TArray<TPair<string, string>>.Create(
    TPair<string, string>.Create('name1', 'value1'),
    TPair<string, string>.Create('name2', 'value2')
  );

  ReturnValue := TJson.CreateArray(DynArray);
  CheckEquals('[["name1","value1"],["name2","value2"]]', ReturnValue.AsJSon);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TJsonTest.Suite);

end.
