unit dutil.text.UtilTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.text.Util;

type
  // Test methods for class TUtil
  TUtilTest = class(TTestCase)
  strict private
    FUtil: TUtil;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestStrip;
    procedure TestStrip_Left;
    procedure TestStrip_Right;
    procedure TestSplit;
  end;

implementation

uses
  Types;

procedure TUtilTest.SetUp;
begin
  FUtil := TUtil.Create;
end;

procedure TUtilTest.TearDown;
begin
  FUtil.Free;
  FUtil := nil;
end;

procedure TUtilTest.TestStrip;
var
  ReturnValue: string;
  Match: Char;
  Source: string;
begin
  Source := '"""Hello world""';
  Match := '"';

  ReturnValue := FUtil.Strip(Source, Match);
  CheckEquals('Hello world', ReturnValue);
end;

procedure TUtilTest.TestStrip_Left;
var
  ReturnValue: string;
  Match: Char;
  Source: string;
begin
  Source := '"""Hello world';
  Match := '"';

  ReturnValue := FUtil.Strip(Source, Match);
  CheckEquals('Hello world', ReturnValue);
end;

procedure TUtilTest.TestStrip_Right;
var
  ReturnValue: string;
  Match: Char;
  Source: string;
begin
  Source := 'Hello world"""';
  Match := '"';

  ReturnValue := FUtil.Strip(Source, Match);
  CheckEquals('Hello world', ReturnValue);
end;

procedure TUtilTest.TestSplit;
var
  ReturnValue: TArray<string>;
  S: string;
  Separator: string;
begin
  S := 'foo=&int=42&token';
  Separator := '&';

  ReturnValue := FUtil.Split(S, Separator);
  CheckEquals(3, Length(ReturnValue));
  CheckEquals('foo=', ReturnValue[0]);
  CheckEquals('int=42', ReturnValue[1]);
  CheckEquals('token', ReturnValue[2]);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TUtilTest.Suite);

end.
